/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class EntstehungsQuelle {
    public static final int UNDEF = 0;
    public static final int AUS_VERMESSUNG = 1000;
    public static final int AUS_LUFTBILD = 2000;
    public static final int AUS_ZAHLEN = 4100;
    public static final int AUS_KARTE = 4200;
    public static final int AUS_SONST_KARTE = 4300;
    public static final int OHNE_QUELLE = 9998;
    private static final String UNDEF_STRING = "";
    private static final String AUS_VERMESSUNG_STRING = "Aus Katastervermessung ermittelt";
    private static final String AUS_LUFTBILD_STRING = "Aus Luftbildmessung ermittelt";
    private static final String AUS_ZAHLEN_STRING = "Aus Katasterzahlen f\u00fcr graphische Zwecke ermittelt";
    private static final String AUS_KARTE_STRING = "Aus Katasterkarten digitalisiert";
    private static final String AUS_SONST_KARTE_STRING = "Aus sonstigen Unterlagen digitalisiert";
    private static final String OHNE_QUELLE_STRING = "Nach Quellenlage nicht zu spezifizieren";
    private static final Vector arten = new Vector();
    private int eq;
    private String name;
    private Color color;

    public EntstehungsQuelle(int n, String string, Color color) {
        this.eq = n;
        this.name = string;
        this.color = color;
    }

    public int getValue() {
        return this.eq;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public static String getItem(int n) {
        return n + "  " + EntstehungsQuelle.toString(n);
    }

    public static Enumeration elements() {
        return arten.elements();
    }

    public static String toString(int n) {
        switch (n) {
            case 1000: {
                return AUS_VERMESSUNG_STRING;
            }
            case 2000: {
                return AUS_LUFTBILD_STRING;
            }
            case 4100: {
                return AUS_ZAHLEN_STRING;
            }
            case 4200: {
                return AUS_KARTE_STRING;
            }
            case 4300: {
                return AUS_SONST_KARTE_STRING;
            }
            case 9998: {
                return OHNE_QUELLE_STRING;
            }
        }
        return UNDEF_STRING;
    }

    public static String toOutString(int n) {
        if (n == 0) {
            return AUS_VERMESSUNG_STRING;
        }
        return EntstehungsQuelle.toString(n);
    }

    public String toString() {
        return EntstehungsQuelle.toString(this.eq);
    }

    static {
        arten.addElement(new EntstehungsQuelle(0, UNDEF_STRING, Color.white));
        arten.addElement(new EntstehungsQuelle(1000, AUS_VERMESSUNG_STRING, new Color(0, 180, 0)));
        arten.addElement(new EntstehungsQuelle(2000, AUS_LUFTBILD_STRING, new Color(255, 127, 39)));
        arten.addElement(new EntstehungsQuelle(4100, AUS_ZAHLEN_STRING, new Color(255, 226, 0)));
        arten.addElement(new EntstehungsQuelle(4200, AUS_KARTE_STRING, Color.red));
        arten.addElement(new EntstehungsQuelle(4300, AUS_SONST_KARTE_STRING, new Color(198, 0, 0)));
        arten.addElement(new EntstehungsQuelle(9998, OHNE_QUELLE_STRING, Color.white));
    }
}

