/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import de.geocalc.util.CountTable;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class ErrorManagerDialog
extends ObjectInfoDialog
implements ITableListener,
DataBaseListener,
ActionListener,
ItemListener {
    private static final String ALL_COMMAND = "Alle";
    private static final String NOT_COMMAND = "Keine";
    private static final String INVERT_COMMAND = "Umkehren";
    private static final String SET_COMMAND = "Setzen";
    private String titel = "";
    private List idList;
    private Label errCountLabel;
    private Label warnCountLabel;
    private Label msgCountLabel;
    private Label procCountLabel;
    private Checkbox errCheckbox;
    private Checkbox warnCheckbox;
    private Checkbox msgCheckbox;
    private Checkbox procCheckbox;
    private Button setButton;
    private Hashtable idsVis;
    private static boolean isFatalVisible = true;
    private static boolean isErrorVisible = true;
    private static boolean isWarningVisible = true;
    private static boolean isMessageVisible = true;
    private static boolean isProcessedVisible = true;

    public ErrorManagerDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Object)null);
    }

    public ErrorManagerDialog(IFrame iFrame, String string, Object object) {
        super(iFrame, string, (Object)null);
        this.titel = string;
        this.setCountLabels();
        this.setObjects();
    }

    @Override
    public void setObject(Object object) {
        this.showObject(object);
    }

    @Override
    protected Panel createInfoPanel() {
        Object object;
        Object object2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Panel panel = new Panel(gridBagLayout);
        CountTable countTable = new CountTable();
        this.idsVis = new Hashtable();
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = DataBase.ERR.elements();
        while (enumeration.hasMoreElements()) {
            ErrorObject errorObject = (ErrorObject)enumeration.nextElement();
            object2 = errorObject.getId();
            if (object2 == null) {
                object2 = "";
            }
            if ((object = (Boolean)this.idsVis.get(object2)) == null) {
                this.idsVis.put(object2, new Boolean(errorObject.isVisible()));
            } else if (!((Boolean)object).booleanValue() && errorObject.isVisible()) {
                this.idsVis.put(object2, new Boolean(true));
            }
            countTable.put(object2);
            n = Math.max(n, ((String)object2).length());
            n2 = Math.max(n2, Integer.toString(countTable.getCount(object2)).length());
        }
        int n3 = Math.max(1, Math.min(5, this.idsVis.size()));
        this.idList = new List(n3, true);
        this.idList.setFont(new Font("Monospaced", 0, 12));
        this.idList.addItemListener(this);
        int n4 = 0;
        object2 = this.idsVis.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            boolean bl = (Boolean)this.idsVis.get(object);
            int n5 = countTable.getCount(object);
            this.idList.add(IFormat.getLeftString((String)object, n) + " : " + IFormat.getRightString(Integer.toString(n5), n2) + " Meldungen ");
            if (bl) {
                this.idList.select(n4);
            }
            ++n4;
        }
        panel.add(this.idList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        gridBagLayout.setConstraints(this.idList, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        object2 = new Button(ALL_COMMAND);
        panel.add((Component)object2);
        ((Button)object2).addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
        object2 = new Button(NOT_COMMAND);
        panel.add((Component)object2);
        ((Button)object2).addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
        object2 = new Button(INVERT_COMMAND);
        panel.add((Component)object2);
        ((Button)object2).addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
        this.errCountLabel = new Label("      ", 2);
        panel.add(this.errCountLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.errCountLabel, gridBagConstraints);
        this.warnCountLabel = new Label("      ", 2);
        panel.add(this.warnCountLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.warnCountLabel, gridBagConstraints);
        this.msgCountLabel = new Label("      ", 2);
        panel.add(this.msgCountLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.msgCountLabel, gridBagConstraints);
        this.procCountLabel = new Label("      ", 2);
        panel.add(this.procCountLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.procCountLabel, gridBagConstraints);
        this.errCheckbox = new Checkbox("Fehler", isErrorVisible);
        panel.add(this.errCheckbox);
        this.errCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.errCheckbox, gridBagConstraints);
        this.warnCheckbox = new Checkbox("Warnungen", isWarningVisible);
        panel.add(this.warnCheckbox);
        this.warnCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.warnCheckbox, gridBagConstraints);
        this.msgCheckbox = new Checkbox("Meldungen", isMessageVisible);
        panel.add(this.msgCheckbox);
        this.msgCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.msgCheckbox, gridBagConstraints);
        this.procCheckbox = new Checkbox("bearbeitet", isProcessedVisible);
        panel.add(this.procCheckbox);
        this.procCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.procCheckbox, gridBagConstraints);
        this.setButton = new Button(SET_COMMAND);
        panel.add(this.setButton);
        this.setButton.setEnabled(false);
        this.setButton.addActionListener(this);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(this.setButton, gridBagConstraints);
        return panel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(16);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Quelle", 0), new ITableCell("Typ", 0), new ITableCell("Meldung", -10)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    private void setCountLabels() {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
        for (int i = 0; i < this.idList.getItemCount(); ++i) {
            if (!this.idList.isSelected(i)) continue;
            object = this.idList.getItem(i);
            int n5 = ((String)object).indexOf(" ");
            hashtable.put(n5 >= 0 ? ((String)object).substring(0, n5) : object, new Boolean(true));
        }
        Enumeration enumeration = DataBase.ERR.elements();
        while (enumeration.hasMoreElements()) {
            object = (ErrorObject)enumeration.nextElement();
            String string = ((ErrorObject)object).getId();
            if (string == null) {
                string = "";
            }
            if (hashtable.get(string) == null) {
                ((ErrorObject)object).setVisible(false);
                continue;
            }
            byte by = ((ErrorObject)object).getType();
            if (by == 3) {
                ++n;
                continue;
            }
            if (by == 2) {
                ++n2;
                continue;
            }
            if (by == 1) {
                ++n3;
                continue;
            }
            if (by != 99) continue;
            ++n4;
        }
        this.errCountLabel.setText(Integer.toString(n));
        this.warnCountLabel.setText(Integer.toString(n2));
        this.msgCountLabel.setText(Integer.toString(n3));
        this.procCountLabel.setText(Integer.toString(n4));
    }

    public void setObjects() {
        Object object;
        int n;
        Object object2 = this.table.getSelectedObject();
        int n2 = -1;
        this.table.removeLines();
        Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
        for (n = 0; n < this.idList.getItemCount(); ++n) {
            if (!this.idList.isSelected(n)) continue;
            object = this.idList.getItem(n);
            int n3 = ((String)object).indexOf(" ");
            hashtable.put(n3 >= 0 ? ((String)object).substring(0, n3) : object, new Boolean(true));
        }
        n = 0;
        object = DataBase.ERR.elements();
        while (object.hasMoreElements()) {
            ErrorObject errorObject = (ErrorObject)object.nextElement();
            String string = errorObject.getId();
            if (string == null) {
                string = "";
            }
            if (hashtable.get(string) == null) {
                errorObject.setVisible(false);
            } else {
                byte by = errorObject.getType();
                if (by == 3) {
                    errorObject.setVisible(this.errCheckbox.getState());
                } else if (by == 2) {
                    errorObject.setVisible(this.warnCheckbox.getState());
                } else if (by == 1) {
                    errorObject.setVisible(this.msgCheckbox.getState());
                } else if (by == 99) {
                    errorObject.setVisible(this.procCheckbox.getState());
                } else {
                    errorObject.setVisible(true);
                }
                if (errorObject.isVisible()) {
                    if (object2 == errorObject) {
                        n2 = n;
                    }
                    this.addObjectToTable(errorObject);
                }
            }
            ++n;
        }
        this.table.select(n2);
        this.table.doLayout();
        this.pack();
        this.table.requestFocus();
    }

    protected void addObjectToTable(Object object) {
        if (object instanceof ErrorObject) {
            ErrorObject errorObject = (ErrorObject)object;
            ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(errorObject.getId(), -10), new ITableCell(errorObject.getTypeAsString(), -10), new ITableCell(errorObject.getText().replace('\n', ' '), -10)};
            this.table.addLine(new ITableLine(iTableCellArray, object));
        }
    }

    @Override
    protected void showObject(Object object) {
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.idList) {
            this.setCountLabels();
        }
        this.setButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(SET_COMMAND)) {
            this.setObjects();
            if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
            isErrorVisible = this.errCheckbox.getState();
            isWarningVisible = this.warnCheckbox.getState();
            isMessageVisible = this.msgCheckbox.getState();
            isProcessedVisible = this.procCheckbox.getState();
        } else if (string.equals(ALL_COMMAND)) {
            int n = this.idList.getVisibleIndex();
            for (int i = 0; i < this.idList.getItemCount(); ++i) {
                this.idList.select(i);
            }
            this.idList.makeVisible(n);
            this.setCountLabels();
            this.setButton.setEnabled(true);
        } else if (string.equals(NOT_COMMAND)) {
            int n = this.idList.getVisibleIndex();
            for (int i = 0; i < this.idList.getItemCount(); ++i) {
                this.idList.deselect(i);
            }
            this.idList.makeVisible(n);
            this.setCountLabels();
            this.setButton.setEnabled(true);
        } else if (string.equals(INVERT_COMMAND)) {
            int n = this.idList.getVisibleIndex();
            for (int i = 0; i < this.idList.getItemCount(); ++i) {
                if (this.idList.isSelected(i)) {
                    this.idList.deselect(i);
                    continue;
                }
                this.idList.select(i);
            }
            this.idList.makeVisible(n);
            this.setCountLabels();
            this.setButton.setEnabled(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        Object object = iTableEvent.getContent();
        if (this.elementListener != null) {
            this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), object, iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
        }
    }
}

