/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ErrorObject
extends TextBox
implements PaintObject,
Messager {
    public static final byte MESSAGE = 1;
    public static final byte WARNING = 2;
    public static final byte ERROR = 3;
    public static final byte PROCESSED = 99;
    public static final byte DB_CONFIRM = 10;
    public static final byte DB_REPLACE = 11;
    public static final byte DB_INSERT = 12;
    public static final byte DB_DELETE = 13;
    public static final byte DB_OBJECT = 20;
    private DPoint loc;
    private GeomElement object;
    private String id;
    private byte type = (byte)3;
    private boolean isVisible = true;
    private DRectangle paintBox = null;
    private boolean lastMode = false;

    public ErrorObject(String string) {
        this(null, null, string, null, 3);
    }

    public ErrorObject(String string, GeomException geomException) {
        this(geomException.getLocation(), geomException.getObject(), string, geomException.getMessage(), 3);
    }

    public ErrorObject(DPoint dPoint, GeomElement geomElement, String string, String string2) {
        this(dPoint, geomElement, string, string2, 3);
    }

    public ErrorObject(DPoint dPoint, GeomElement geomElement, String string, String string2, byte by) {
        this.loc = dPoint;
        this.id = string;
        this.object = geomElement;
        this.setText(string2);
        this.type = by;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public String getTypeAsString() {
        return ErrorObject.getTypeAsString(this.type);
    }

    public static String getTypeAsString(int n) {
        if (n == 1) {
            return "Meldung";
        }
        if (n == 2) {
            return "Warnung";
        }
        if (n == 3) {
            return "Fehler";
        }
        if (n == 99) {
            return "bearbeitet";
        }
        if (n == 10) {
            return "Punkt best\u00e4tigt";
        }
        if (n == 11) {
            return "Punkt ersetzt";
        }
        if (n == 12) {
            return "Punkt eingef\u00fcgt";
        }
        if (n == 13) {
            return "Punkt gel\u00f6scht";
        }
        if (n == 20) {
            return "Objekt nicht aktuell";
        }
        return "unbekannt";
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        KafPlotIOConstants.writeGeomElement(dataOutput, this.loc);
        KafPlotIOConstants.writeGeomElement(dataOutput, this.object);
        dataOutput.writeByte(this.type);
        KafPlotIOConstants.writeString(dataOutput, this.id != null ? this.id : "");
        KafPlotIOConstants.writeString(dataOutput, this.getText());
    }

    public static ErrorObject readObject(DataInput dataInput) throws IOException {
        DPoint dPoint = (DPoint)KafPlotIOConstants.readGeomElement(dataInput);
        GeomElement geomElement = KafPlotIOConstants.readGeomElement(dataInput);
        byte by = KpvIOProperties.RVER >= 114 ? (byte)dataInput.readByte() : (byte)3;
        String string = KpvIOProperties.RVER >= 114 ? KafPlotIOConstants.readString(dataInput) : null;
        String string2 = KafPlotIOConstants.readString(dataInput);
        ErrorObject errorObject = new ErrorObject(dPoint, geomElement, string, string2);
        errorObject.setType(by);
        return errorObject;
    }

    public void setPoint(DPoint dPoint) {
        this.loc = dPoint;
    }

    public DPoint getPoint() {
        return this.loc;
    }

    public void setGeom(GeomElement geomElement) {
        this.object = geomElement;
    }

    public void addGeom(GeomElement geomElement) {
        if (this.object == null) {
            this.object = geomElement;
        } else if (this.object instanceof DCollection) {
            ((DCollection)this.object).addElement(this.object);
        } else {
            DCollection dCollection = new DCollection();
            dCollection.addElement(this.object);
            dCollection.addElement(geomElement);
            this.object = dCollection;
        }
    }

    public GeomElement getGeom() {
        return this.object;
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorObject) {
            if (this.loc == null) {
                return ((ErrorObject)object).getPoint() == null;
            }
            return this.loc.equals(((ErrorObject)object).getPoint());
        }
        return false;
    }

    @Override
    protected void calculatePosition() {
        int n = 11;
        if (this.object instanceof DPoint) {
            n = 11;
        } else if (this.object instanceof DLine) {
            double d = ((DLine)this.object).getOrientation() * 180.0 / Math.PI;
            n = d < -157.5 ? -10 : (d < -112.5 ? 11 : (d < -67.5 ? 1 : (d < -22.5 ? -9 : (d < 22.5 ? 10 : (d < 67.5 ? 11 : (d < 112.5 ? 1 : (d < 157.5 ? -9 : -10)))))));
        }
        this.setPosition(n);
    }

    @Override
    public DPoint getCatchPoint() {
        return this.getHashPoint();
    }

    @Override
    public DPoint getHashPoint() {
        if (this.loc == null) {
            return null;
        }
        DPoint dPoint = new DPoint(this.loc.y, this.loc.x);
        double d = 0.01;
        switch (this.getPosition()) {
            case -11: {
                dPoint.y += d;
                dPoint.x -= d;
                break;
            }
            case -1: {
                dPoint.x -= d;
                break;
            }
            case 9: {
                dPoint.y -= d;
                dPoint.x -= d;
                break;
            }
            case -10: {
                dPoint.y += d;
                break;
            }
            case 10: {
                dPoint.y -= d;
                break;
            }
            case -9: {
                dPoint.y += d;
                dPoint.x += d;
                break;
            }
            case 1: {
                dPoint.x += d;
                break;
            }
            case 11: {
                dPoint.y -= d;
                dPoint.x += d;
            }
        }
        return dPoint;
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        if (this.loc != null) {
            d = Math.min(d, this.loc.y);
            d2 = Math.min(d2, this.loc.x);
            d3 = Math.max(d3, this.loc.y);
            d4 = Math.max(d4, this.loc.x);
        }
        if (this.paintBox != null) {
            d = Math.min(d, this.paintBox.y);
            d2 = Math.min(d2, this.paintBox.x);
            d3 = Math.max(d3, this.paintBox.y + this.paintBox.width);
            d4 = Math.max(d4, this.paintBox.x + this.paintBox.height);
        }
        if (this.object != null) {
            DRectangle dRectangle = this.object.getBounds();
            d = Math.min(d, dRectangle.y);
            d2 = Math.min(d2, dRectangle.x);
            d3 = Math.max(d3, dRectangle.y + dRectangle.width);
            d4 = Math.max(d4, dRectangle.x + dRectangle.height);
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    @Override
    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTypeAsString());
        stringBuffer.append(": ");
        stringBuffer.append(this.getId());
        return stringBuffer.toString();
    }

    public String getUnformatedText() {
        return this.getText().replace('\n', ' ');
    }

    @Override
    public Message getMessage() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(this.getUnformatedText());
        return new Message(this, string, stringBuffer.toString());
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return this.loc == null ? false : iViewport.contains(this.loc.y, this.loc.x);
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        this.drawInscription(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (bl2) {
            iGraphics.setXORMode();
        } else {
            iGraphics.setPaintMode();
        }
        if (this.object != null) {
            iGraphics.fillGeomElement(this.object);
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (bl2) {
            iGraphics.setXORMode();
        } else {
            iGraphics.setPaintMode();
        }
        if (this.object != null) {
            iGraphics.drawGeomElement(this.object);
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        DPoint dPoint = this.getCatchPoint();
        Point point = iGraphics.getGraphicPoint(dPoint);
        DPoint dPoint2 = iGraphics.getDataPoint(new Point(point.x - this.getWidth(), point.y - this.getHeight()), new DPoint());
        if (this.paintBox == null) {
            this.paintBox = new DRectangle();
        }
        this.paintBox.y = dPoint2.y;
        this.paintBox.x = dPoint.x;
        this.paintBox.width = dPoint.y - dPoint2.y;
        this.paintBox.height = dPoint2.x - dPoint.x;
        super.setLocation(point);
        if (this.lastMode) {
            bl2 = false;
        }
        this.lastMode = bl2;
        graphics.setPaintMode();
        Color color = KafPlotColor.BEMERKUNG_FG;
        Color color2 = KafPlotColor.BEMERKUNG_BEM_BG;
        if (bl2) {
            color2 = KafPlotColor.BEMERKUNG_RAISED_BG;
            color = KafPlotColor.BEMERKUNG_RAISED_FG;
        } else {
            color2 = KafPlotProperties.bemColor.getColor(new Integer(this.type));
            if (KafPlotProperties.getBemerkungColorAlpha() < 255) {
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), KafPlotProperties.getBemerkungColorAlpha());
            }
        }
        this.setBackground(color2);
        this.setForeground(color);
        this.paint(graphics);
    }

    public String toString() {
        return String.valueOf(this.loc) + ":" + this.getText();
    }
}

