/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktFilter;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.BooleanFilter;
import de.geocalc.util.CharacterFilter;
import de.geocalc.util.DoubleFilter;
import de.geocalc.util.Filter;
import de.geocalc.util.IntegerFilter;
import de.geocalc.util.IntegerListFilter;
import de.geocalc.util.LongFilter;
import de.geocalc.util.NumberFilter;

public class ExtendedPunktFilter
extends PunktFilter {
    protected IntegerFilter psFilter;
    protected IntegerFilter ebFilter;
    protected IntegerFilter vaFilter;
    protected IntegerFilter osFilter;
    protected IntegerFilter ksFilter;
    protected IntegerFilter lsFilter;
    protected IntegerFilter lzFilter;
    protected DoubleFilter xFilter;
    protected DoubleFilter yFilter;
    protected DoubleFilter dsFilter;
    protected DoubleFilter spFilter;
    protected DoubleFilter lspFilter;
    protected DoubleFilter zlFilter;
    protected BooleanFilter katAllFilter;
    protected BooleanFilter katNeuFilter;
    protected BooleanFilter katAendFilter;
    protected BooleanFilter katDiffFilter;
    protected BooleanFilter katAltFilter;
    protected BooleanFilter katNutzFilter;
    protected BooleanFilter katGebFilter;
    protected Filter lgFilter;
    private boolean alkis = DataBase.model.getModel() == 2;

    public ExtendedPunktFilter(DataBase dataBase) {
        this.pnrFilter = new LongFilter(1L, 99999999999999L);
        this.pnrFilter.setEnabled(false);
        this.paFilter = new IntegerListFilter(DataBase.model.getPunktArten(true), false);
        this.paFilter.setTranslator(PunktArt.getTranslator());
        this.paFilter.setEnabled(false);
        this.psFilter = new IntegerFilter(-9, 5);
        this.psFilter.setMinimum(0);
        this.psFilter.setEnabled(false);
        this.vaFilter = new IntegerFilter(0, this.alkis ? 9999 : 999);
        this.vaFilter.setEnabled(false);
        this.ebFilter = new IntegerFilter(0, 99);
        this.ebFilter.setEnabled(false);
        this.osFilter = new IntegerFilter(0, 9999);
        this.osFilter.setEnabled(false);
        this.ksFilter = new IntegerFilter(0, 9);
        this.ksFilter.setEnabled(false);
        this.lgFilter = this.alkis ? new IntegerFilter(0, 9999) : new CharacterFilter("0H123456789A");
        this.lgFilter.setEnabled(false);
        this.lsFilter = new IntegerFilter(0, this.alkis ? 1000 : 999);
        this.lsFilter.setEnabled(false);
        this.lzFilter = new IntegerFilter(0, 2);
        this.lzFilter.setEnabled(false);
        try {
            this.dsFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.dsFilter.setBounds(0.0, DataBase.vmax);
            this.dsFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.spFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.spFilter.setBounds(0.0, DataBase.emax);
            this.spFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.lspFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.lspFilter.setBounds(0.0, DataBase.emax);
            this.lspFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.zlFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.zlFilter.setBounds(0.0, DataBase.zmax);
            this.zlFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.xFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.xFilter.setBounds(DataBase.xmin, DataBase.xmax);
            this.xFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.yFilter = new DoubleFilter(-1.7976931348623157E308, Double.MAX_VALUE);
            this.yFilter.setBounds(DataBase.ymin, DataBase.ymax);
            this.yFilter.setEnabled(false);
        }
        catch (ValueOutOfBoundsException valueOutOfBoundsException) {
            // empty catch block
        }
        this.katAllFilter = new BooleanFilter();
        this.katAllFilter.setEnabled(false);
        this.katNeuFilter = new BooleanFilter();
        this.katNeuFilter.setEnabled(false);
        this.katAendFilter = new BooleanFilter();
        this.katAendFilter.setEnabled(false);
        this.katDiffFilter = new BooleanFilter();
        this.katDiffFilter.setEnabled(false);
        this.katAltFilter = new BooleanFilter();
        this.katAltFilter.setEnabled(false);
        this.katNutzFilter = new BooleanFilter();
        this.katNutzFilter.setEnabled(false);
        this.katGebFilter = new BooleanFilter();
        this.katGebFilter.setEnabled(false);
    }

    @Override
    public boolean isPunktEnabled(Punkt punkt) {
        PunktParameter punktParameter = punkt.getParameter();
        if (super.isPunktEnabled(punkt) == this.invert) {
            return this.invert;
        }
        if (!this.psFilter.isValidValue(punkt.getPs())) {
            return this.invert;
        }
        if (!this.vaFilter.isValidValue(punktParameter.getModVa())) {
            return this.invert;
        }
        if (!this.ebFilter.isValidValue(punktParameter.getModEb())) {
            return this.invert;
        }
        if (!this.osFilter.isValidValue(punktParameter.getModOska())) {
            return this.invert;
        }
        if (!this.ksFilter.isValidValue(punktParameter.getModPst())) {
            return this.invert;
        }
        if (this.alkis ? !((NumberFilter)this.lgFilter).isValidValue(punktParameter.getModLg()) : !((CharacterFilter)this.lgFilter).isValidValue((char)punktParameter.getModLg())) {
            return this.invert;
        }
        if (!this.lsFilter.isValidValue(punktParameter.getModLs())) {
            return this.invert;
        }
        if (!this.lzFilter.isValidValue(punktParameter.getModLz())) {
            return this.invert;
        }
        if (!this.dsFilter.isValidValue(punkt.getDS())) {
            return this.invert;
        }
        if (!this.spFilter.isValidValue(punkt.getSP())) {
            return this.invert;
        }
        if (!this.lspFilter.isValidValue(punkt.getLSP())) {
            return this.invert;
        }
        if (!this.zlFilter.isValidValue(punkt.getZL())) {
            return this.invert;
        }
        if (!this.xFilter.isValidValue(punkt.x)) {
            return this.invert;
        }
        if (!this.yFilter.isValidValue(punkt.y)) {
            return this.invert;
        }
        if (this.katAllFilter.isEnabled() && !this.katAllFilter.isValidValue(punkt.isKatasterPunkt())) {
            return this.invert;
        }
        if (this.katNeuFilter.isEnabled() && !this.katNeuFilter.isValidValue(punkt.isKatasterNeuElement())) {
            return this.invert;
        }
        if (this.katAendFilter.isEnabled() && !this.katAendFilter.isValidValue(punkt.isKatasterAenderungElement())) {
            return this.invert;
        }
        if (this.katDiffFilter.isEnabled() && !this.katDiffFilter.isValidValue(punkt.isKatasterNeuElement() || punkt.isKatasterAenderungElement())) {
            return this.invert;
        }
        if (this.katAltFilter.isEnabled() && !this.katAltFilter.isValidValue(punkt.isKatasterNachweisElement())) {
            return this.invert;
        }
        if (this.katNutzFilter.isEnabled() && !this.katNutzFilter.isValidValue(DataBase.isFreeNutzungsartenPunkt(punkt))) {
            return this.invert;
        }
        if (this.katGebFilter.isEnabled() && !this.katGebFilter.isValidValue(DataBase.isFreeGebaeudePunkt(punkt))) {
            return this.invert;
        }
        return !this.invert;
    }

    @Override
    public Filter getFilter(int n) {
        switch (n) {
            case 203: {
                return this.vaFilter;
            }
            case 202: {
                return this.ebFilter;
            }
            case 222: {
                return this.osFilter;
            }
            case 223: {
                return this.ksFilter;
            }
            case 200: {
                return this.psFilter;
            }
            case 205: {
                return this.lgFilter;
            }
            case 204: {
                return this.lsFilter;
            }
            case 206: {
                return this.lzFilter;
            }
            case 209: {
                return this.dsFilter;
            }
            case 210: {
                return this.spFilter;
            }
            case 411: {
                return this.lspFilter;
            }
            case 211: {
                return this.zlFilter;
            }
            case 302: {
                return this.xFilter;
            }
            case 301: {
                return this.yFilter;
            }
            case 1000: {
                return this.katAllFilter;
            }
            case 1001: {
                return this.katNeuFilter;
            }
            case 1002: {
                return this.katAendFilter;
            }
            case 1003: {
                return this.katDiffFilter;
            }
            case 1004: {
                return this.katAltFilter;
            }
            case 1005: {
                return this.katNutzFilter;
            }
            case 1006: {
                return this.katGebFilter;
            }
        }
        return super.getFilter(n);
    }
}

