/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.ICardPanel;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ISwitchDialog;
import de.geocalc.awt.ITextField;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ExtendedPunktFilter;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.CharacterFilter;
import de.geocalc.util.DoubleFilter;
import de.geocalc.util.IntegerListFilter;
import de.geocalc.util.NumberFilter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ExtendedPunktFilterDialog
extends IDialog
implements ActionListener,
ItemListener {
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String DO_COMMAND = "\u00dcbernehmen";
    private static final String ALL = "Alle";
    private static final String SEPARATOR = "-";
    private static final String PNR = "Punktnummer";
    private static final String PA = "Punktart";
    private static final String VA = "Vermarkungsart";
    private static final String EB = "Ebene";
    private static final String X_KOO = "Hochwert";
    private static final String Y_KOO = "Rechtswert";
    private static final String DP = ": ";
    private static final String BIS = "  -";
    private static final int TFW = 11;
    protected DataBase db;
    private ITextField vPnrTextField;
    private ITextField bPnrTextField;
    private ITextField vPsTextField;
    private ITextField bPsTextField;
    private ITextField vPaTextField;
    private ITextField bPaTextField;
    private ITextField cPaTextField;
    private ITextField vVaTextField;
    private ITextField bVaTextField;
    private ITextField vEbTextField;
    private ITextField bEbTextField;
    private ITextField vOsTextField;
    private ITextField bOsTextField;
    private ITextField vKsTextField;
    private ITextField bKsTextField;
    private ITextField vLgTextField;
    private ITextField bLgTextField;
    private ITextField cLgTextField;
    private ITextField vLsTextField;
    private ITextField bLsTextField;
    private ITextField vLzTextField;
    private ITextField bLzTextField;
    private ITextField vDsTextField;
    private ITextField bDsTextField;
    private ITextField vSpTextField;
    private ITextField bSpTextField;
    private ITextField vLspTextField;
    private ITextField bLspTextField;
    private ITextField vZlTextField;
    private ITextField bZlTextField;
    private ITextField vXTextField;
    private ITextField bXTextField;
    private ITextField vYTextField;
    private ITextField bYTextField;
    private Checkbox aPnrCheckbox;
    private Checkbox aPsCheckbox;
    private Checkbox aPaCheckbox;
    private Checkbox aVaCheckbox;
    private Checkbox aEbCheckbox;
    private Checkbox aOsCheckbox;
    private Checkbox aKsCheckbox;
    private Checkbox aLgCheckbox;
    private Checkbox aLsCheckbox;
    private Checkbox aLzCheckbox;
    private Checkbox aDsCheckbox;
    private Checkbox aSpCheckbox;
    private Checkbox aLspCheckbox;
    private Checkbox aZlCheckbox;
    private Checkbox aXCheckbox;
    private Checkbox aYCheckbox;
    private Checkbox aAllCheckbox;
    private Checkbox aKatAllCheckbox;
    private Checkbox aKatNeuCheckbox;
    private Checkbox aKatAendCheckbox;
    private Checkbox aKatDiffCheckbox;
    private Checkbox aKatAltCheckbox;
    private Checkbox aKatNutzCheckbox;
    private Checkbox aKatGebCheckbox;
    private Checkbox offCheckbox;
    private Checkbox invertCheckbox;
    private Button okButton;
    private Button doButton;
    private Button abortButton;
    protected ExtendedPunktFilter filter;
    private boolean filterSet = false;

    public ExtendedPunktFilterDialog(IFrame iFrame, DataBase dataBase, boolean bl) {
        this(iFrame, "Punkte filtern", dataBase, new ExtendedPunktFilter(dataBase), bl);
    }

    public ExtendedPunktFilterDialog(IFrame iFrame, String string, DataBase dataBase, boolean bl) {
        this(iFrame, string, dataBase, new ExtendedPunktFilter(dataBase), bl);
    }

    public ExtendedPunktFilterDialog(IFrame iFrame, String string, DataBase dataBase, ExtendedPunktFilter extendedPunktFilter, boolean bl) {
        super(iFrame, string, bl);
        this.db = dataBase;
        this.filter = extendedPunktFilter != null ? extendedPunktFilter : new ExtendedPunktFilter(dataBase);
        this.setLayout(new BorderLayout());
        this.add("North", this.layoutDialogPanel());
        this.add("South", this.layoutButtonPanel());
        this.updateLayout();
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setLayout(new BorderLayout());
        ICardPanel iCardPanel = new ICardPanel();
        iCardPanel.addCard("Parameter", this.createParameterPanel());
        iCardPanel.addCard("Lage", this.createLagePanel());
        iCardPanel.addCard("Koordinaten", this.createKoordinatenPanel());
        iCardPanel.addCard("Kataster", this.createKatasterPanel());
        iPanel.add("North", iCardPanel);
        iPanel.add("South", this.createSonstigesPanel());
        return iPanel;
    }

    protected IPanel layoutButtonPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setLayout(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        iPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.doButton = new Button(DO_COMMAND);
        iPanel.add(this.doButton);
        this.doButton.addActionListener(this);
        this.abortButton = new Button(ABORT_COMMAND);
        iPanel.add(this.abortButton);
        this.abortButton.addActionListener(this);
        return iPanel;
    }

    private IPanel createParameterPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("von:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("bis:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.aPnrCheckbox = new Checkbox("Punktnummer:", this.filter.getFilter(101).isEnabled());
        iPanel.add(this.aPnrCheckbox);
        this.aPnrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.aPnrCheckbox, gridBagConstraints);
        this.vPnrTextField = new ITextField(11);
        iPanel.add(this.vPnrTextField);
        this.vPnrTextField.setText(((NumberFilter)this.filter.getFilter(101)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.vPnrTextField, gridBagConstraints);
        this.bPnrTextField = new ITextField(11);
        iPanel.add(this.bPnrTextField);
        this.bPnrTextField.setText(((NumberFilter)this.filter.getFilter(101)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.bPnrTextField, gridBagConstraints);
        this.aPsCheckbox = new Checkbox("Punktstatus:", this.filter.getFilter(200).isEnabled());
        iPanel.add(this.aPsCheckbox);
        this.aPsCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.aPsCheckbox, gridBagConstraints);
        this.vPsTextField = new ITextField(11);
        iPanel.add(this.vPsTextField);
        this.vPsTextField.setText(((NumberFilter)this.filter.getFilter(200)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.vPsTextField, gridBagConstraints);
        this.bPsTextField = new ITextField(11);
        iPanel.add(this.bPsTextField);
        this.bPsTextField.setText(((NumberFilter)this.filter.getFilter(200)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.bPsTextField, gridBagConstraints);
        this.aPaCheckbox = new Checkbox("Punktart:", this.filter.getFilter(201).isEnabled());
        iPanel.add(this.aPaCheckbox);
        this.aPaCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.aPaCheckbox, gridBagConstraints);
        if (DataBase.model.getModel() == 2) {
            this.cPaTextField = new ITextField(22);
            iPanel.add(this.cPaTextField);
            this.cPaTextField.setText(((IntegerListFilter)this.filter.getFilter(201)).getBounds());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.cPaTextField, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
        } else {
            this.vPaTextField = new ITextField(11);
            iPanel.add(this.vPaTextField);
            this.vPaTextField.setText(((NumberFilter)this.filter.getFilter(201)).getMinimum().toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagLayout.setConstraints(this.vPaTextField, gridBagConstraints);
            this.bPaTextField = new ITextField(11);
            iPanel.add(this.bPaTextField);
            this.bPaTextField.setText(((NumberFilter)this.filter.getFilter(201)).getMaximum().toString());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagLayout.setConstraints(this.bPaTextField, gridBagConstraints);
        }
        this.aVaCheckbox = new Checkbox("Vermarkungsart:", this.filter.getFilter(203).isEnabled());
        iPanel.add(this.aVaCheckbox);
        this.aVaCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.aVaCheckbox, gridBagConstraints);
        this.vVaTextField = new ITextField(11);
        iPanel.add(this.vVaTextField);
        this.vVaTextField.setText(((NumberFilter)this.filter.getFilter(203)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.vVaTextField, gridBagConstraints);
        this.bVaTextField = new ITextField(11);
        iPanel.add(this.bVaTextField);
        this.bVaTextField.setText(((NumberFilter)this.filter.getFilter(203)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.bVaTextField, gridBagConstraints);
        this.aEbCheckbox = new Checkbox("Ebene:", this.filter.getFilter(202).isEnabled());
        iPanel.add(this.aEbCheckbox);
        this.aEbCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.aEbCheckbox, gridBagConstraints);
        this.vEbTextField = new ITextField(11);
        iPanel.add(this.vEbTextField);
        this.vEbTextField.setText(((NumberFilter)this.filter.getFilter(202)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.vEbTextField, gridBagConstraints);
        this.bEbTextField = new ITextField(11);
        iPanel.add(this.bEbTextField);
        this.bEbTextField.setText(((NumberFilter)this.filter.getFilter(202)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.bEbTextField, gridBagConstraints);
        if (DataBase.model.getModel() != 2) {
            this.aOsCheckbox = new Checkbox("Oska:", this.filter.getFilter(222).isEnabled());
            iPanel.add(this.aOsCheckbox);
            this.aOsCheckbox.addItemListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.aOsCheckbox, gridBagConstraints);
            this.vOsTextField = new ITextField(11);
            iPanel.add(this.vOsTextField);
            this.vOsTextField.setText(((NumberFilter)this.filter.getFilter(222)).getMinimum().toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.vOsTextField, gridBagConstraints);
            this.bOsTextField = new ITextField(11);
            iPanel.add(this.bOsTextField);
            this.bOsTextField.setText(((NumberFilter)this.filter.getFilter(222)).getMaximum().toString());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.bOsTextField, gridBagConstraints);
            this.aKsCheckbox = new Checkbox("Katasterstatus :", this.filter.getFilter(223).isEnabled());
            iPanel.add(this.aKsCheckbox);
            this.aKsCheckbox.addItemListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.aKsCheckbox, gridBagConstraints);
            this.vKsTextField = new ITextField(11);
            iPanel.add(this.vKsTextField);
            this.vKsTextField.setText(((NumberFilter)this.filter.getFilter(223)).getMinimum().toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.vKsTextField, gridBagConstraints);
            this.bKsTextField = new ITextField(11);
            iPanel.add(this.bKsTextField);
            this.bKsTextField.setText(((NumberFilter)this.filter.getFilter(223)).getMaximum().toString());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.bKsTextField, gridBagConstraints);
        }
        return iPanel;
    }

    private IPanel createLagePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Stufen:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("von:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("bis:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.aLgCheckbox = new Checkbox("Lagegenauigkeit:", this.filter.getFilter(205).isEnabled());
        iPanel.add(this.aLgCheckbox);
        this.aLgCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aLgCheckbox, gridBagConstraints);
        if (DataBase.model.getModel() == 2) {
            this.vLgTextField = new ITextField(11);
            iPanel.add(this.vLgTextField);
            this.vLgTextField.setText(((NumberFilter)this.filter.getFilter(205)).getMinimum().toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.vLgTextField, gridBagConstraints);
            this.bLgTextField = new ITextField(11);
            iPanel.add(this.bLgTextField);
            this.bLgTextField.setText(((NumberFilter)this.filter.getFilter(205)).getMaximum().toString());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.bLgTextField, gridBagConstraints);
        } else {
            label = new Label("g\u00fcltige Zeichen:");
            iPanel.add(label);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.cLgTextField = new ITextField(11);
            iPanel.add(this.cLgTextField);
            this.cLgTextField.setText(((CharacterFilter)this.filter.getFilter(205)).getBounds());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(this.cLgTextField, gridBagConstraints);
        }
        this.aLsCheckbox = new Checkbox(DataBase.model.getModel() == 2 ? "Koordinatenstatus" : "Lagestatus:", this.filter.getFilter(204).isEnabled());
        iPanel.add(this.aLsCheckbox);
        this.aLsCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aLsCheckbox, gridBagConstraints);
        this.vLsTextField = new ITextField(11);
        iPanel.add(this.vLsTextField);
        this.vLsTextField.setText(((NumberFilter)this.filter.getFilter(204)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.vLsTextField, gridBagConstraints);
        this.bLsTextField = new ITextField(11);
        iPanel.add(this.bLsTextField);
        this.bLsTextField.setText(((NumberFilter)this.filter.getFilter(204)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.bLsTextField, gridBagConstraints);
        this.aLzCheckbox = new Checkbox("Lagezuverl\u00e4ssigkeit:", this.filter.getFilter(206).isEnabled());
        iPanel.add(this.aLzCheckbox);
        this.aLzCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.aLzCheckbox, gridBagConstraints);
        this.vLzTextField = new ITextField(11);
        iPanel.add(this.vLzTextField);
        this.vLzTextField.setText(((NumberFilter)this.filter.getFilter(206)).getMinimum().toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.vLzTextField, gridBagConstraints);
        this.bLzTextField = new ITextField(11);
        iPanel.add(this.bLzTextField);
        this.bLzTextField.setText(((NumberFilter)this.filter.getFilter(206)).getMaximum().toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.bLzTextField, gridBagConstraints);
        label = new Label("Werte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.aDsCheckbox = new Checkbox("Verschiebung:", this.filter.getFilter(209).isEnabled());
        iPanel.add(this.aDsCheckbox);
        this.aDsCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aDsCheckbox, gridBagConstraints);
        this.vDsTextField = new ITextField(11);
        iPanel.add(this.vDsTextField);
        this.vDsTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(209)).getMinimum()).toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.vDsTextField, gridBagConstraints);
        this.bDsTextField = new ITextField(11);
        iPanel.add(this.bDsTextField);
        this.bDsTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(209)).getMaximum()).toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.bDsTextField, gridBagConstraints);
        this.aSpCheckbox = new Checkbox("Standardabweichung:", this.filter.getFilter(210).isEnabled());
        iPanel.add(this.aSpCheckbox);
        this.aSpCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aSpCheckbox, gridBagConstraints);
        this.vSpTextField = new ITextField(11);
        iPanel.add(this.vSpTextField);
        this.vSpTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(210)).getMinimum()).toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.vSpTextField, gridBagConstraints);
        this.bSpTextField = new ITextField(11);
        iPanel.add(this.bSpTextField);
        this.bSpTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(210)).getMaximum()).toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.bSpTextField, gridBagConstraints);
        this.aLspCheckbox = new Checkbox("lok. Standardabw:", this.filter.getFilter(411).isEnabled());
        iPanel.add(this.aLspCheckbox);
        this.aLspCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aLspCheckbox, gridBagConstraints);
        this.vLspTextField = new ITextField(11);
        iPanel.add(this.vLspTextField);
        this.vLspTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(411)).getMinimum()).toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.vLspTextField, gridBagConstraints);
        this.bLspTextField = new ITextField(11);
        iPanel.add(this.bLspTextField);
        this.bLspTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(411)).getMaximum()).toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.bLspTextField, gridBagConstraints);
        this.aZlCheckbox = new Checkbox("Zuverl\u00e4ssigkeit:", this.filter.getFilter(211).isEnabled());
        iPanel.add(this.aZlCheckbox);
        this.aZlCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aZlCheckbox, gridBagConstraints);
        this.vZlTextField = new ITextField(11);
        iPanel.add(this.vZlTextField);
        this.vZlTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(211)).getMinimum()).toString());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.vZlTextField, gridBagConstraints);
        this.bZlTextField = new ITextField(11);
        iPanel.add(this.bZlTextField);
        this.bZlTextField.setText(IFormat.f_3.format(((DoubleFilter)this.filter.getFilter(211)).getMaximum()).toString());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.bZlTextField, gridBagConstraints);
        return iPanel;
    }

    private IPanel createKoordinatenPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("von:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("bis:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.aXCheckbox = new Checkbox("Hochwert:", this.filter.getFilter(302).isEnabled());
        iPanel.add(this.aXCheckbox);
        this.aXCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.aXCheckbox, gridBagConstraints);
        this.vXTextField = new ITextField(GeoNumberFormat.koo03.format(((NumberFilter)this.filter.getFilter(302)).getMinimum()).toString(), 11);
        iPanel.add(this.vXTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.vXTextField, gridBagConstraints);
        this.bXTextField = new ITextField(GeoNumberFormat.koo03.format(((NumberFilter)this.filter.getFilter(302)).getMaximum()).toString(), 11);
        iPanel.add(this.bXTextField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.bXTextField, gridBagConstraints);
        this.aYCheckbox = new Checkbox("Rechtswert:", this.filter.getFilter(301).isEnabled());
        iPanel.add(this.aYCheckbox);
        this.aYCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.aYCheckbox, gridBagConstraints);
        this.vYTextField = new ITextField(GeoNumberFormat.koo03.format(((NumberFilter)this.filter.getFilter(301)).getMinimum()).toString(), 11);
        iPanel.add(this.vYTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.vYTextField, gridBagConstraints);
        this.bYTextField = new ITextField(GeoNumberFormat.koo03.format(((NumberFilter)this.filter.getFilter(301)).getMaximum()).toString(), 11);
        iPanel.add(this.bYTextField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.bYTextField, gridBagConstraints);
        return iPanel;
    }

    private IPanel createKatasterPanel() {
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.aAllCheckbox = new Checkbox("alle Punkte", true, checkboxGroup);
        iPanel.add(this.aAllCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.aAllCheckbox, gridBagConstraints);
        this.aKatAllCheckbox = new Checkbox("alle Katasterpunkte", false, checkboxGroup);
        iPanel.add(this.aKatAllCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.aKatAllCheckbox, gridBagConstraints);
        this.aKatNeuCheckbox = new Checkbox("nur neue Katasterpunkte", false, checkboxGroup);
        iPanel.add(this.aKatNeuCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.aKatNeuCheckbox, gridBagConstraints);
        this.aKatAendCheckbox = new Checkbox("nur ge\u00e4nderte Katasterpunkte", false, checkboxGroup);
        iPanel.add(this.aKatAendCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.aKatAendCheckbox, gridBagConstraints);
        this.aKatDiffCheckbox = new Checkbox("nur neue und ge\u00e4nderte Katasterpunkte", false, checkboxGroup);
        iPanel.add(this.aKatDiffCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.aKatDiffCheckbox, gridBagConstraints);
        this.aKatAltCheckbox = new Checkbox("nur vorhandene Katasterpunkte", false, checkboxGroup);
        iPanel.add(this.aKatAltCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.aKatAltCheckbox, gridBagConstraints);
        if (DataBase.model.getModel() != 2) {
            this.aKatNutzCheckbox = new Checkbox("nur Nutzungsartenpunkte ohne Fachbedeutung", false, checkboxGroup);
            iPanel.add(this.aKatNutzCheckbox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.aKatNutzCheckbox, gridBagConstraints);
            this.aKatGebCheckbox = new Checkbox("nur Geb\u00e4udepunkte ohne Fachbedeutung", false, checkboxGroup);
            iPanel.add(this.aKatGebCheckbox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.aKatGebCheckbox, gridBagConstraints);
        }
        return iPanel;
    }

    private IPanel createSonstigesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 2;
        IPanel iPanel = new IPanel(gridBagLayout);
        this.offCheckbox = new Checkbox("mit Offlinepunkten", false);
        iPanel.add(this.offCheckbox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.offCheckbox, gridBagConstraints);
        this.invertCheckbox = new Checkbox("Filter invertieren", false);
        iPanel.add(this.invertCheckbox);
        this.invertCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.invertCheckbox, gridBagConstraints);
        return iPanel;
    }

    protected void updateLayout() {
        this.setTextFieldsEnabled(this.vPnrTextField, this.bPnrTextField, this.aPnrCheckbox);
        this.setTextFieldsEnabled(this.vPsTextField, this.bPsTextField, this.aPsCheckbox);
        this.setTextFieldsEnabled(this.vPaTextField, this.bPaTextField, this.aPaCheckbox);
        this.setTextFieldsEnabled(this.cPaTextField, null, this.aPaCheckbox);
        this.setTextFieldsEnabled(this.vVaTextField, this.bVaTextField, this.aVaCheckbox);
        this.setTextFieldsEnabled(this.vEbTextField, this.bEbTextField, this.aEbCheckbox);
        this.setTextFieldsEnabled(this.vOsTextField, this.bOsTextField, this.aOsCheckbox);
        this.setTextFieldsEnabled(this.vKsTextField, this.bKsTextField, this.aKsCheckbox);
        this.setTextFieldsEnabled(this.vLgTextField, this.bLgTextField, this.aLgCheckbox);
        this.setTextFieldsEnabled(this.cLgTextField, null, this.aLgCheckbox);
        this.setTextFieldsEnabled(this.vLsTextField, this.bLsTextField, this.aLsCheckbox);
        this.setTextFieldsEnabled(this.vLzTextField, this.bLzTextField, this.aLzCheckbox);
        this.setTextFieldsEnabled(this.vDsTextField, this.bDsTextField, this.aDsCheckbox);
        this.setTextFieldsEnabled(this.vSpTextField, this.bSpTextField, this.aSpCheckbox);
        this.setTextFieldsEnabled(this.vLspTextField, this.bLspTextField, this.aLspCheckbox);
        this.setTextFieldsEnabled(this.vZlTextField, this.bZlTextField, this.aZlCheckbox);
        this.setTextFieldsEnabled(this.vXTextField, this.bXTextField, this.aXCheckbox);
        this.setTextFieldsEnabled(this.vYTextField, this.bYTextField, this.aYCheckbox);
    }

    private void setTextFieldsEnabled(ITextField iTextField, ITextField iTextField2, Checkbox checkbox) {
        if (checkbox != null) {
            boolean bl = checkbox.getState();
            if (iTextField != null) {
                iTextField.setEditable(bl);
                iTextField.setEnabled(bl);
            }
            if (iTextField2 != null) {
                iTextField2.setEditable(bl);
                iTextField2.setEnabled(bl);
            }
        }
    }

    protected void setFilterParameters() throws IException {
        if (this.aPnrCheckbox != null) {
            this.filter.getFilter(101).setEnabled(this.aPnrCheckbox.getState());
            if (this.aPnrCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(101)).setMinimum(this.vPnrTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Punktnummer!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(101)).setMaximum(this.bPnrTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Punktnummer!");
                }
            }
        }
        if (this.aPsCheckbox != null) {
            this.filter.getFilter(200).setEnabled(this.aPsCheckbox.getState());
            if (this.aPsCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(200)).setMinimum(this.vPsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Punktstatus!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(200)).setMaximum(this.bPsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Punktstatus!");
                }
            }
        }
        if (this.aPaCheckbox != null) {
            this.filter.getFilter(201).setEnabled(this.aPaCheckbox.getState());
            if (this.aPaCheckbox.getState()) {
                if (DataBase.model.getModel() == 2) {
                    try {
                        ((IntegerListFilter)this.filter.getFilter(201)).setBounds(this.cPaTextField.getText());
                    }
                    catch (Exception exception) {
                        throw new IException(exception.getMessage() + " im Feld von Punktart!");
                    }
                }
                try {
                    ((NumberFilter)this.filter.getFilter(201)).setMinimum(this.vPaTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Punktart!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(201)).setMaximum(this.bPaTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Punktart!");
                }
            }
        }
        if (this.aVaCheckbox != null) {
            this.filter.getFilter(203).setEnabled(this.aVaCheckbox.getState());
            if (this.aVaCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(203)).setMinimum(this.vVaTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Vermarkungsart!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(203)).setMaximum(this.bVaTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Vermarkungsart!");
                }
            }
        }
        if (this.aEbCheckbox != null) {
            this.filter.getFilter(202).setEnabled(this.aEbCheckbox.getState());
            if (this.aEbCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(202)).setMinimum(this.vEbTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Ebene!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(202)).setMaximum(this.bEbTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Ebene!");
                }
            }
        }
        if (this.aOsCheckbox != null) {
            this.filter.getFilter(222).setEnabled(this.aOsCheckbox.getState());
            if (this.aOsCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(222)).setMinimum(this.vOsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Oska!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(222)).setMaximum(this.bOsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Oska!");
                }
            }
        }
        if (this.aKsCheckbox != null) {
            this.filter.getFilter(223).setEnabled(this.aKsCheckbox.getState());
            if (this.aKsCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(223)).setMinimum(this.vKsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Katasterstatus!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(223)).setMaximum(this.bKsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Katasterstatus!");
                }
            }
        }
        if (this.aLgCheckbox != null) {
            this.filter.getFilter(205).setEnabled(this.aLgCheckbox.getState());
            if (this.aLgCheckbox.getState()) {
                if (DataBase.model.getModel() == 2) {
                    try {
                        ((NumberFilter)this.filter.getFilter(205)).setMinimum(this.vLgTextField.getText());
                    }
                    catch (Exception exception) {
                        throw new IException(exception.getMessage() + " im Feld von Lagegenauigkeit!");
                    }
                    try {
                        ((NumberFilter)this.filter.getFilter(205)).setMaximum(this.bLgTextField.getText());
                    }
                    catch (Exception exception) {
                        throw new IException(exception.getMessage() + " im Feld bis Lagegenauigkeit!");
                    }
                }
                try {
                    ((CharacterFilter)this.filter.getFilter(205)).setBounds(this.cLgTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Lagegenauigkeit!");
                }
            }
        }
        if (this.aLsCheckbox != null) {
            this.filter.getFilter(204).setEnabled(this.aLsCheckbox.getState());
            if (this.aLsCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(204)).setMinimum(this.vLsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Lagestatus!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(204)).setMaximum(this.bLsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Lagestatus!");
                }
            }
        }
        if (this.aLzCheckbox != null) {
            this.filter.getFilter(206).setEnabled(this.aLzCheckbox.getState());
            if (this.aLzCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(206)).setMinimum(this.vLzTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Lagezuverl\u00e4ssigkeit!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(206)).setMaximum(this.bLzTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Lagezuverl\u00e4ssigkeit!");
                }
            }
        }
        if (this.aDsCheckbox != null) {
            this.filter.getFilter(209).setEnabled(this.aDsCheckbox.getState());
            if (this.aDsCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(209)).setMinimum(this.vDsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Verschiebung!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(209)).setMaximum(this.bDsTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Verschiebung!");
                }
            }
        }
        if (this.aSpCheckbox != null) {
            this.filter.getFilter(210).setEnabled(this.aSpCheckbox.getState());
            if (this.aSpCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(210)).setMinimum(this.vSpTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Standardabweichung!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(210)).setMaximum(this.bSpTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Standardabweichung!");
                }
            }
        }
        if (this.aLspCheckbox != null) {
            this.filter.getFilter(411).setEnabled(this.aLspCheckbox.getState());
            if (this.aLspCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(411)).setMinimum(this.vLspTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von lok. Standardabw.!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(411)).setMaximum(this.bLspTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis lok. Standardabw.!");
                }
            }
        }
        if (this.aZlCheckbox != null) {
            this.filter.getFilter(211).setEnabled(this.aZlCheckbox.getState());
            if (this.aZlCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(211)).setMinimum(this.vZlTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Zuverl\u00e4ssigkeit!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(211)).setMaximum(this.bZlTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Zuverl\u00e4ssigkeit!");
                }
            }
        }
        if (this.aXCheckbox != null) {
            this.filter.getFilter(302).setEnabled(this.aXCheckbox.getState());
            if (this.aXCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(302)).setMinimum(this.vXTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Hochwert!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(302)).setMaximum(this.bXTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Hochwert!");
                }
            }
        }
        if (this.aYCheckbox != null) {
            this.filter.getFilter(301).setEnabled(this.aYCheckbox.getState());
            if (this.aYCheckbox.getState()) {
                try {
                    ((NumberFilter)this.filter.getFilter(301)).setMinimum(this.vYTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld von Rechtswert!");
                }
                try {
                    ((NumberFilter)this.filter.getFilter(301)).setMaximum(this.bYTextField.getText());
                }
                catch (Exception exception) {
                    throw new IException(exception.getMessage() + " im Feld bis Rechtswert!");
                }
            }
        }
        this.filter.getFilter(1000).setEnabled(this.aKatAllCheckbox.getState());
        this.filter.getFilter(1001).setEnabled(this.aKatNeuCheckbox.getState());
        this.filter.getFilter(1002).setEnabled(this.aKatAendCheckbox.getState());
        this.filter.getFilter(1003).setEnabled(this.aKatDiffCheckbox.getState());
        this.filter.getFilter(1004).setEnabled(this.aKatAltCheckbox.getState());
        if (DataBase.model.getModel() != 2) {
            this.filter.getFilter(1005).setEnabled(this.aKatNutzCheckbox.getState());
            this.filter.getFilter(1006).setEnabled(this.aKatGebCheckbox.getState());
        }
        this.filter.getFilter(901).setEnabled(!this.offCheckbox.getState());
        this.filter.setInvert(this.invertCheckbox.getState());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
            this.endDialog();
        } else if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!(object instanceof Choice) && object instanceof Checkbox) {
            this.updateLayout();
            if (object == this.aPaCheckbox && this.aPaCheckbox.getState() && DataBase.model.getModel() == 2) {
                IntegerListFilter integerListFilter = (IntegerListFilter)this.filter.getFilter(201);
                ISwitchDialog iSwitchDialog = new ISwitchDialog(this.parent, "Punktarten", integerListFilter.getBoundsArray(false), true, true);
                iSwitchDialog.setSelectedItems(this.cPaTextField.getText());
                Point point = this.cPaTextField.getLocationOnScreen();
                point.y += this.cPaTextField.getHeight();
                iSwitchDialog.setLocation(point);
                iSwitchDialog.setVisible(true);
                String[] stringArray = iSwitchDialog.getSelectedItems();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(stringArray[i]);
                }
                this.cPaTextField.setText(stringBuffer.toString());
            } else if (object == this.invertCheckbox) {
                this.invertCheckbox.setForeground(this.invertCheckbox.getState() ? Color.red : Color.black);
            }
        }
    }

    @Override
    protected void doStandardAction() {
        try {
            this.setFilterParameters();
            this.filterSet = true;
            if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
        }
        catch (IException iException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iException);
            errorDialog.setVisible(true);
        }
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    public ExtendedPunktFilter getFilter() {
        return this.filterSet ? this.filter : null;
    }
}

