/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.INumTextField;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.text.IFormat;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.util.StringTokenizer;

public class FileInfoDialog
extends IOptionDialog {
    private double hoehe = DataBase.getGelHoehe();
    private static final String VOID_TEXT = " ";
    Label projectLabel;
    Label versionLabel;
    Label stelleLabel;
    Label bearbeiterLabel;
    Label gmdLabel;
    Label gmkLabel;
    Label flurLabel;
    Label flstLabel;
    Label kvaLabel;
    Label antragLabel;
    Label sysLabel;
    Label hoeheNameLabel;
    Label hoeheBemLabel;
    Label msLabel;
    Label mfLabel;
    Label bsLabel;
    Label bfLabel;
    Label fpLabel;
    Label bpLabel;
    Label npLabel;
    Label epLabel;
    Label upLabel;
    Label mwLabel;
    TextField hoeheTextField;

    public FileInfoDialog(IFrame iFrame, String string) {
        super(iFrame, string, true);
        this.updateLayout();
        this.setButtonEnabled("\u00dcbernehmen", false);
        this.pack();
    }

    @Override
    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add("North", this.createFileInfoPanel());
        iPanel.add("South", this.createPunktInfoPanel());
        return iPanel;
    }

    private IPanel createFileInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        gridBagConstraints.gridy = 0;
        Label label = new Label("Projekt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.projectLabel = new Label();
        iPanel.add(this.projectLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.projectLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        label = new Label("KafDatVersion:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.versionLabel = new Label();
        iPanel.add(this.versionLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.versionLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        label = new Label("Vermessungsstelle:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.stelleLabel = new Label();
        iPanel.add(this.stelleLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.stelleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        label = new Label("Bearbeiter:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bearbeiterLabel = new Label();
        iPanel.add(this.bearbeiterLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.bearbeiterLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        label = new Label("Gemeinde:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmdLabel = new Label();
        iPanel.add(this.gmdLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.gmdLabel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        label = new Label("Gemarkung:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmkLabel = new Label();
        iPanel.add(this.gmkLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.gmkLabel, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        label = new Label("Flur:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flurLabel = new Label();
        iPanel.add(this.flurLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.flurLabel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        label = new Label("Flurst\u00fcck:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flstLabel = new Label();
        iPanel.add(this.flstLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.flstLabel, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        label = new Label("Katasteramt:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kvaLabel = new Label();
        iPanel.add(this.kvaLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.kvaLabel, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        label = new Label("Antragsnummer:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.antragLabel = new Label();
        iPanel.add(this.antragLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.antragLabel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        label = new Label("KoordinatenSystem:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.sysLabel = new Label();
        iPanel.add(this.sysLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.sysLabel, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.hoeheNameLabel = new Label();
        iPanel.add(this.hoeheNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.hoeheNameLabel, gridBagConstraints);
        this.hoeheTextField = new INumTextField(10);
        iPanel.add(this.hoeheTextField);
        this.hoeheTextField.setText(IFormat.f_1.format(this.hoehe));
        this.hoeheTextField.addActionListener(this);
        this.hoeheTextField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.hoeheTextField, gridBagConstraints);
        this.hoeheBemLabel = new Label();
        iPanel.add(this.hoeheBemLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.hoeheBemLabel, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        label = new Label("Streckenma\u00dfstab:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.msLabel = new Label();
        iPanel.add(this.msLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.msLabel, gridBagConstraints);
        this.bsLabel = new Label();
        iPanel.add(this.bsLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.bsLabel, gridBagConstraints);
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        label = new Label("Fl\u00e4chenma\u00dfstab:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.mfLabel = new Label();
        iPanel.add(this.mfLabel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.mfLabel, gridBagConstraints);
        this.bfLabel = new Label();
        iPanel.add(this.bfLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.bfLabel, gridBagConstraints);
        return iPanel;
    }

    private IPanel createPunktInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        Label label = new Label("Festpunkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.fpLabel = new Label();
        iPanel.add(this.fpLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.fpLabel, gridBagConstraints);
        label = new Label("bewegl. Punkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bpLabel = new Label();
        iPanel.add(this.bpLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.bpLabel, gridBagConstraints);
        label = new Label("Neupunkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.npLabel = new Label();
        iPanel.add(this.npLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.npLabel, gridBagConstraints);
        label = new Label("N\u00e4herungspunkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.epLabel = new Label();
        iPanel.add(this.epLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.epLabel, gridBagConstraints);
        label = new Label("undef. Punkte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.upLabel = new Label();
        iPanel.add(this.upLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.upLabel, gridBagConstraints);
        label = new Label("Messwerte:");
        iPanel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.mwLabel = new Label();
        iPanel.add(this.mwLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.mwLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected void updateLayout() {
        this.updateLayout(true);
    }

    private void updateLayout(boolean bl) {
        if (bl) {
            this.projectLabel.setText(DataBase.projekt != null ? DataBase.projekt : VOID_TEXT);
            this.versionLabel.setText((String)(DataBase.kafDatVersion != null ? DataBase.kafDatVersion + "  (" + DataBase.model.getName() + ")" : VOID_TEXT));
            this.stelleLabel.setText(DataBase.vermStelle != null ? DataBase.vermStelle : VOID_TEXT);
            this.bearbeiterLabel.setText(DataBase.bearbeiter != null ? DataBase.bearbeiter : VOID_TEXT);
            this.gmdLabel.setText(DataBase.gemeinde != null ? DataBase.gemeinde : VOID_TEXT);
            this.gmkLabel.setText(DataBase.gemarkung != null ? DataBase.gemarkung : VOID_TEXT);
            this.flurLabel.setText(DataBase.flur != null ? DataBase.flur : VOID_TEXT);
            this.flstLabel.setText(DataBase.flurstueck != null ? DataBase.flurstueck : VOID_TEXT);
            this.kvaLabel.setText(DataBase.katasterAmt != null ? DataBase.katasterAmt : VOID_TEXT);
            this.antragLabel.setText(DataBase.antrag != null ? DataBase.antrag : VOID_TEXT);
            this.sysLabel.setText(DataBase.getKooSystemName());
            this.hoeheTextField.setText(IFormat.f_1.format(this.hoehe));
        }
        if (DataBase.getKooSystem() == 489) {
            this.hoeheNameLabel.setText("ellips. H\u00f6he:");
            this.hoeheBemLabel.setText("\u2248 " + (int)Math.rint(this.hoehe - 40.0) + " m \u00fc. NHN");
        } else {
            this.hoeheNameLabel.setText("Gel\u00e4ndeh\u00f6he:");
            this.hoeheBemLabel.setText(" m \u00fc. NHN");
        }
        double d = DataBase.getStreckeMasstab(DataBase.getAreaCenter(), this.hoehe);
        double d2 = DataBase.getFlaecheMasstab(DataBase.getAreaCenter(), this.hoehe);
        this.msLabel.setText(IFormat.f_10.format(1.0 / d));
        this.mfLabel.setText(IFormat.f_10.format(1.0 / d2));
        this.bsLabel.setText("\u00bb " + IFormat.f_1.format(Math.abs(10000.0 * (1.0 - d))) + " cm / 100m");
        this.bfLabel.setText("\u00bb " + IFormat.f_1.format(Math.abs(1000.0 * (1.0 - d2))) + " m\u02db / 1000m\u02db");
        if (bl) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(DataBase.getElements());
                this.fpLabel.setText(stringTokenizer.nextToken());
                this.bpLabel.setText(stringTokenizer.nextToken());
                this.npLabel.setText(stringTokenizer.nextToken());
                this.epLabel.setText(stringTokenizer.nextToken());
                this.upLabel.setText(stringTokenizer.nextToken());
                this.mwLabel.setText(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void setOptions() {
        DataBase.setGelHoehe(Double.parseDouble(this.hoeheTextField.getText()));
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        super.textValueChanged(textEvent);
        try {
            this.hoehe = Double.parseDouble(this.hoeheTextField.getText());
            this.updateLayout(false);
            this.pack();
            this.setButtonEnabled("\u00dcbernehmen", this.hoehe != DataBase.getGelHoehe());
        }
        catch (Exception exception) {
            this.setButtonEnabled("\u00dcbernehmen", false);
        }
    }
}

