/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.io.IFileOutputException;
import de.geocalc.io.Util;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.FlaechenbelegOptionDialog;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.io.FlaechenbelegWriter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class FlaechenbelegDialog
extends IDialog
implements ActionListener {
    DataBase db;
    protected ExceptionList exceptions;
    private static final String FILE_NAME_BUTTON_TEXT = "...";
    private static final String BELEG_FILE_NAME_COMMAND = "Flaechenbeleg";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String EINRECHNUNG_FILE_DEFAULT_NAME = "Flaechenbeleg";
    private TextField belegFileNameTextField;
    private Button belegFileNameButton;
    private Button okButton;
    private Button optionButton;
    private Button abortButton;
    private Label belegFileNameLabel;
    private Label progressLabel;
    private IProgressBar progressBar;
    private String filePath;

    public FlaechenbelegDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        super(iFrame, string, true);
        this.db = dataBase;
        this.filePath = dataBase.getDestPath();
        this.exceptions = new ExceptionList();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Datei"));
        this.belegFileNameLabel = new Label("Beleg: ");
        iPanel.add(this.belegFileNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.belegFileNameLabel, gridBagConstraints);
        this.belegFileNameTextField = new TextField(DataBase.getDestFileDisplayName(KafPlotProperties.getFlaechenbelegFileName() + ".rtf"), 40);
        iPanel.add(this.belegFileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.belegFileNameTextField, gridBagConstraints);
        this.belegFileNameButton = new Button(FILE_NAME_BUTTON_TEXT);
        iPanel.add(this.belegFileNameButton);
        this.belegFileNameButton.setActionCommand("Flaechenbeleg");
        this.belegFileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.belegFileNameButton, gridBagConstraints);
        panel.add("North", iPanel);
        IPanel iPanel2 = new IPanel(new BorderLayout());
        IBorder iBorder = new IBorder(1);
        iPanel2.setBorder(iBorder);
        Panel panel2 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel2.add(this.progressBar);
        iPanel2.add("North", panel2);
        Panel panel3 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label();
        panel3.add(this.progressLabel);
        iPanel2.add("South", panel3);
        panel.add("South", iPanel2);
        this.add("North", panel);
        Panel panel4 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel4.add(this.okButton);
        this.optionButton = new Button(OPTION_COMMAND);
        this.optionButton.addActionListener(this);
        panel4.add(this.optionButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel4.add(this.abortButton);
        this.add("South", panel4);
        this.pack();
        this.setLocationOfParent(iFrame);
    }

    public void write() {
        try {
            File file = Util.getFile(this.filePath, this.belegFileNameTextField.getText());
            FlaechenbelegWriter flaechenbelegWriter = new FlaechenbelegWriter(file, this.db);
            flaechenbelegWriter.setExceptionList(this.exceptions);
            flaechenbelegWriter.setProgressBar(this.progressBar);
            flaechenbelegWriter.setProgressLabel(this.progressLabel);
            flaechenbelegWriter.write();
        }
        catch (IFileOutputException iFileOutputException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iFileOutputException);
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.write();
            this.endDialog();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals(OPTION_COMMAND)) {
            FlaechenbelegOptionDialog flaechenbelegOptionDialog = new FlaechenbelegOptionDialog(this.parent, OPTION_COMMAND);
            flaechenbelegOptionDialog.setVisible(true);
        } else if (string.equals("Flaechenbeleg")) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 1);
            fileDialog.setFile(this.belegFileNameTextField.getText());
            fileDialog.setDirectory(this.filePath);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.belegFileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
                this.filePath = fileDialog.getDirectory();
            }
        }
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden markiert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        this.write();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

