/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.GemarkungInfoDialog;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class FlurInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
ItemListener {
    private Button gmkButton;
    private Choice gmkChoice;
    private IFrame parent;

    public FlurInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Flurstueck)null);
    }

    public FlurInfoDialog(IFrame iFrame, String string, Flurstueck flurstueck) {
        super(iFrame, string, flurstueck);
        this.parent = iFrame;
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Gemarkung"));
        this.gmkChoice = new Choice();
        iPanel.add(this.gmkChoice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.gmkChoice, gridBagConstraints);
        this.gmkButton = new Button("...");
        iPanel.add(this.gmkButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.gmkButton, gridBagConstraints);
        this.gmkButton.addActionListener(this);
        Enumeration enumeration = Gemarkung.sortedElements();
        while (enumeration.hasMoreElements()) {
            Gemarkung gemarkung = (Gemarkung)enumeration.nextElement();
            this.gmkChoice.addItem(Integer.toString(gemarkung.getNummer()) + "  " + gemarkung.getName());
        }
        this.gmkChoice.addItemListener(this);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(2);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Nummer", 0), new ITableCell("Fl\u00e4che", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        Gemarkung gemarkung = null;
        this.table.removeLines();
        if (object instanceof Gemarkung) {
            gemarkung = (Gemarkung)object;
        } else if (object instanceof Flurstueck) {
            gemarkung = Gemarkung.getGemarkung(((Flurstueck)object).getGemarkung());
        }
        if (gemarkung != null) {
            this.gmkChoice.select(Integer.toString(gemarkung.getNummer()) + "  " + gemarkung.getName());
            Vector vector = DataBase.FLST.getFlurenFrom(gemarkung.getNummer());
            for (int i = 0; i < vector.size(); ++i) {
                Flurstueck flurstueck = (Flurstueck)vector.elementAt(i);
                this.addObjectToTable(flurstueck);
                if (!(object instanceof Flurstueck) || flurstueck.getFlur() != ((Flurstueck)object).getFlur()) continue;
                this.table.select(i);
            }
        }
        super.setObject(object);
    }

    @Override
    protected void showObject(Object object) {
    }

    protected void addObjectToTable(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(flurstueck.getFlurAsString(), 0), new ITableCell(flurstueck.getGeoFlaecheAsDoubleString(), 10)};
        this.table.addLine(new ITableLine(iTableCellArray, object));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("...")) {
            GemarkungInfoDialog gemarkungInfoDialog = new GemarkungInfoDialog(this.parent, "Gemarkung ausw\u00e4hlen", null, true);
            gemarkungInfoDialog.setModal(true);
            if (this.getObject() instanceof Gemarkung) {
                gemarkungInfoDialog.setObject(this.getObject());
            } else if (this.getObject() instanceof Flurstueck) {
                gemarkungInfoDialog.setObject(Gemarkung.getGemarkung(((Flurstueck)this.getObject()).getGemarkung()));
            }
            gemarkungInfoDialog.setVisible(true);
            this.setObject(gemarkungInfoDialog.getObject());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.object = iTableEvent.getContent();
        this.showObject(iTableEvent.getContent());
        if (iTableEvent.getClickCount() > 1 && this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.gmkChoice && itemEvent.getStateChange() == 1) {
            this.setObject(Gemarkung.getGemarkung(Integer.parseInt(IFormat.getFirstNumbers(this.gmkChoice.getSelectedItem()))));
        }
    }
}

