/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IInscription;
import de.geocalc.awt.IInscriptionComponent;
import de.geocalc.awt.ISwitchElement;
import de.geocalc.geodata.AbstractFlurstueck;
import de.geocalc.geodata.AbstractLage;
import de.geocalc.geodata.AbstractLageEntry;
import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.LageEntry;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectLine;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.VoidEnumerator;
import de.geocalc.xml.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Flurstueck
extends GObject
implements AbstractFlurstueck,
PaintObject,
DatContainer,
ISwitchElement,
Comparable,
Messager {
    public static final String BER_OHNE = "ohne";
    public static final String BER_KOO = "Koo";
    public static final String BER_F = "F";
    public static final String BER_K = "K";
    public static final String BER_FK = "FK";
    public static final String BER_RDA = "RdA";
    public static final String BER_BUCH = "B";
    public static final String BER_SOLL = "Soll";
    public static final String BER_SOLL_F = "SollF";
    public static final String BER_SOLL_FK = "SollFK";
    public static final String BER_SOLL_K = "SollK";
    public static final String BER_SOLL_KOO = "SollKoo";
    public static final String BER_STRING_OHNE = "ohne Berechnung";
    public static final String BER_STRING_KOO = "aus Koordinaten";
    public static final String BER_STRING_F = "aus Feldma\u00dfen";
    public static final String BER_STRING_K = "aus Kartenma\u00dfen";
    public static final String BER_STRING_FK = "aus Feld-/Kartenma\u00dfen";
    public static final String BER_STRING_RDA = "Rest durch Abzug";
    public static final String BER_STRING_BUCH = "Buchfl\u00e4che";
    public static final String BER_STRING_SOLL = "Sollfl\u00e4che";
    public static final String BER_STRING_SOLL_F = "Sollfl\u00e4che aus Feldma\u00dfen";
    public static final String BER_STRING_SOLL_FK = "Sollfl\u00e4che aus Feld-/Kartenma\u00dfen";
    public static final String BER_STRING_SOLL_K = "Sollfl\u00e4che aus Kartenma\u00dfen";
    public static final String BER_STRING_SOLL_KOO = "Sollfl\u00e4che aus Koordinaten";
    public static final int BERECHNUNG_OHNE = 0;
    public static final int BERECHNUNG_BUCH = 1;
    public static final int BERECHNUNG_RDA = 2;
    public static final int BERECHNUNG_K = 3;
    public static final int BERECHNUNG_FK = 4;
    public static final int BERECHNUNG_F = 5;
    public static final int BERECHNUNG_KOO = 6;
    public static final int BERECHNUNG_SOLL = 10;
    public static final int BERECHNUNG_SOLL_K = 13;
    public static final int BERECHNUNG_SOLL_FK = 14;
    public static final int BERECHNUNG_SOLL_F = 15;
    public static final int BERECHNUNG_SOLL_KOO = 16;
    public static final int BERECHNUNG_MIN = 0;
    public static final int BERECHNUNG_MAX = 16;
    public static final int VEREINIGUNG_MARKER = 100000;
    public static final int VOID = -1;
    public static final int MIN_GEMARKUNG = 1;
    public static final int MAX_GEMARKUNG = 999999;
    public static final int MIN_FLUR = 0;
    public static final int MAX_FLUR = 9999;
    public static final int MIN_ZAEHLER = 1;
    public static final int MAX_ZAEHLER = 199999;
    public static final int MIN_NENNER = 0;
    public static final int MAX_NENNER = 999;
    public static final int MIN_PRUEFZEICHEN = 0;
    public static final int MAX_PRUEFZEICHEN = 9;
    public static final int MIN_AKTUALITAET = 0;
    public static final int MAX_AKTUALITAET = 99;
    public static final int MIN_NUTZUNG = 1;
    public static final int MAX_NUTZUNG = 999;
    private static final String PLATZHALTER = "-";
    private static final String BRUCH = "/";
    private static final String VOID_STRING = "";
    private static final String VEREINIGUNG_SHORT_STRING = "Vng";
    private static final String UNDEF_WERT = "ung\u00fcltiger Wert ";
    private static final String IN_FELD = "im Feld ";
    private static final String VAR_NAME_ART = "A";
    private static final String VAR_NAME_BERECHNUNG = "B";
    private static final String VAR_NAME_FLAECHE = "F";
    private static final String VAR_NAME_KLASSE = "K";
    private static final String VAR_NAME_LAGE = "L";
    private static final String VAR_NAME_NUTZUNG = "N";
    private static final String VAR_NAME_OSKA = "O";
    private static final String VAR_NAME_STRASSE = "S";
    private static final String VAR_NAME_VORGABE = "V";
    private static final String VAR_NAME_GRUNDBUCH = "G";
    private static final String VAR_NAME_GEMEINDE = "D";
    private static final String VAR_NAME_X = "X";
    private static final String VAR_NAME_Y = "Y";
    private static final String VAR_NAME_x = "x";
    private static final String VAR_NAME_y = "y";
    private int gemeinde = -1;
    private int gemarkung = -1;
    private int flur = -1;
    private int zaehler = -1;
    private int nenner = -1;
    private int teil = -1;
    private int pruefzeichen = -1;
    private int aktualitaet = -1;
    private int nutzung = -1;
    private int berechnung = 0;
    private int art = -1;
    private int count = 0;
    private Buchungsstelle buchung = null;
    private String gbbl = "";
    private short bvnr = (short)-1;
    private Lage lage = null;
    private double buchFlaeche = 0.0;
    private double geoFlaeche = 0.0;
    private double aktFlaeche = 0.0;
    private int intFlaeche = 0;
    private String klasse = null;
    private String nrVorgabe = null;
    private static Hashtable BER_ARTEN = new Hashtable();
    private static final double PRINT_FAK = 0.7;
    private static final Font dFont;
    private static final Font dBigFont;
    private static final Font dSmallFont;
    private static final Font pFont;
    private static final Font pBigFont;
    private static final Font pSmallFont;

    public Flurstueck() {
        this(-1);
    }

    public Flurstueck(int n) {
        this.art = n;
    }

    public Flurstueck(int n, int n2, int n3, int n4, int n5) {
        this.art = n;
        this.gemarkung = n2;
        this.flur = n3;
        this.zaehler = n4;
        this.nenner = n5;
    }

    public Flurstueck(int n, int n2, int n3, int n4, int n5, int n6) {
        this.art = n;
        this.gemarkung = n2;
        this.flur = n3;
        this.zaehler = n4;
        this.nenner = n5;
        this.teil = n6;
    }

    @Override
    public LinieParameter getLineDefaults() {
        return this.getTeil() > 0 ? LinieParameter.FLST_NEU : LinieParameter.FLST;
    }

    @Override
    public boolean defMultiArea() {
        return this.isNutzstueck();
    }

    @Override
    public void setArt(int n) {
        this.art = n;
    }

    @Override
    public int getArt() {
        return this.art;
    }

    @Override
    public boolean isVoid() {
        return this.gemarkung == -1;
    }

    @Override
    public void deleteName() {
        this.gemarkung = -1;
        this.count = 0;
    }

    @Override
    public void setCount(int n) {
        this.count = n;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public boolean isNutzstueck() {
        return FlurstueckArt.isNutzung(this.art);
    }

    @Override
    public boolean isFortfuehrung() {
        return FlurstueckArt.isFortfuehrung(this.art);
    }

    public boolean isFlagFortfuehrung() {
        return super.isFortfuehrung();
    }

    public boolean isReststueck() {
        return this.berechnung == 2;
    }

    public boolean isTeilstueck() {
        return FlurstueckArt.isTeilstueck(this.art);
    }

    public boolean isStammstueck() {
        return FlurstueckArt.isStammstueck(this.art);
    }

    public boolean isStammTeilstueck() {
        return FlurstueckArt.isStammTeilstueck(this.art);
    }

    public boolean isAbstractFlurstueck() {
        return FlurstueckArt.isAbstractFlurstueck(this.art);
    }

    public boolean isFlur() {
        return FlurstueckArt.isFlur(this.art);
    }

    public boolean isGemarkung() {
        if (this.art <= 0) {
            switch (this.getOska()) {
                case 211: 
                case 212: 
                case 214: 
                case 215: 
                case 231: {
                    return true;
                }
            }
            return false;
        }
        return FlurstueckArt.isGemarkung(this.art);
    }

    public boolean isFlurstueck() {
        return FlurstueckArt.isFlurstueck(this.art);
    }

    public boolean isStammstueckFrom(Flurstueck flurstueck) {
        return flurstueck != null && this.isStammstueck() && this.equalsIgnoreTeil(flurstueck);
    }

    public boolean isStammTeilstueckFrom(Flurstueck flurstueck) {
        return flurstueck != null && flurstueck.isNutzstueck() && (this.isStammstueck() || this.isStammTeilstueck()) && this.equalsIgnoreNutzung(flurstueck);
    }

    public boolean isTeilstueckFrom(Flurstueck flurstueck) {
        return this.isTeilstueck() && this.equalsIgnoreTeil(flurstueck);
    }

    public boolean isNutzstueckFrom(Flurstueck flurstueck) {
        return this.isNutzstueck() && this.equalsIgnoreNutzung(flurstueck);
    }

    public boolean isVereinigungTeilstueck() {
        return FlurstueckArt.isUntergang(this.art);
    }

    public boolean hasTeile() {
        return FlurstueckArt.isTeilbar(this.art);
    }

    public boolean isVereinigungTeilstueckFrom(Flurstueck flurstueck) {
        return this.isVereinigungTeilstueck() && this.teil == flurstueck.zaehler;
    }

    public boolean isVereinigungStammstueck() {
        return this.isStammstueck() && this.zaehler > 100000;
    }

    public boolean equalsIgnoreTeil(Flurstueck flurstueck) {
        return flurstueck != null && flurstueck.gemarkung == this.gemarkung && flurstueck.flur == this.flur && flurstueck.nenner == this.nenner && flurstueck.zaehler == this.zaehler;
    }

    public boolean equalsIgnoreNutzung(Flurstueck flurstueck) {
        return flurstueck != null && this.equalsIgnoreTeil(flurstueck) && flurstueck.teil == this.teil;
    }

    public boolean equalsGemarkung(Flurstueck flurstueck) {
        return this.gemarkung != -1 && flurstueck.gemarkung == this.gemarkung;
    }

    public boolean equalsFlur(Flurstueck flurstueck) {
        return this.equalsGemarkung(flurstueck) && this.flur != -1 && flurstueck.flur == this.flur;
    }

    public void setGemeinde(int n) {
        this.gemeinde = n;
    }

    public int getGemeinde() {
        return this.gemeinde;
    }

    public String getGemeindeAsString() {
        if (this.gemeinde == -1) {
            return VOID_STRING;
        }
        return IFormat.i08.format(this.gemeinde);
    }

    public boolean hasGemeinde() {
        return this.gemeinde != -1;
    }

    @Override
    public void setGemarkung(int n) {
        this.gemarkung = n;
    }

    @Override
    public int getGemarkung() {
        return this.gemarkung;
    }

    @Override
    public String getGemarkungAsString() {
        if (this.gemarkung == -1) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr06n.format(this.gemarkung).toString();
    }

    public String getGemarkungName() {
        Gemarkung gemarkung = Gemarkung.getGemarkung(this.gemarkung);
        return gemarkung != null ? gemarkung.getName() : Integer.toString(this.gemarkung);
    }

    @Override
    public void setFlur(int n) {
        this.flur = n;
    }

    @Override
    public int getFlur() {
        return this.flur;
    }

    @Override
    public String getFlurAsString() {
        if (this.flur == -1) {
            return VOID_STRING;
        }
        if (this.flur >= 1000) {
            return GeoNumberFormat.nr04n.format(this.flur).toString();
        }
        return GeoNumberFormat.nr03n.format(this.flur).toString();
    }

    public int getVereinigungNr() {
        if (this.zaehler > 100000) {
            return this.zaehler % 100000;
        }
        if (this.teil > 100000) {
            return this.teil % 100000;
        }
        return 0;
    }

    @Override
    public void setZaehler(int n) {
        this.zaehler = n;
    }

    @Override
    public int getZaehler() {
        return this.zaehler % 100000;
    }

    @Override
    public String getZaehlerAsString() {
        if (this.gemarkung == -1) {
            return "o.Nr.(" + new Integer(this.count).toString() + ")";
        }
        if (this.zaehler == -1) {
            return VOID_STRING;
        }
        if (this.zaehler > 100000) {
            return "Vng " + new Integer(this.getZaehler()).toString();
        }
        return new Integer(this.zaehler).toString();
    }

    @Override
    public void setNenner(int n) {
        this.nenner = n;
    }

    @Override
    public int getNenner() {
        return this.nenner;
    }

    @Override
    public String getNennerAsString() {
        if (this.nenner == -1) {
            return VOID_STRING;
        }
        return new Integer(this.nenner).toString();
    }

    @Override
    public void setTeil(int n) {
        this.teil = n;
    }

    @Override
    public int getTeil() {
        return this.teil % 100000;
    }

    @Override
    public String getTeilAsString() {
        if (this.teil == -1 || this.getTeil() == 0 || this.teil > 100000) {
            return VOID_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = this.getTeil() - 1;
        do {
            int n2 = n % 26;
            stringBuffer.insert(1, Character.forDigit(n2 + 10, 36));
        } while ((n = n / 26 - 1) >= 0);
        stringBuffer.append(")");
        return new String(stringBuffer.toString());
    }

    @Override
    public void setPruefzeichen(int n) {
        this.pruefzeichen = n;
    }

    @Override
    public int getPruefzeichen() {
        return this.pruefzeichen;
    }

    @Override
    public String getPruefzeichenAsString() {
        if (this.pruefzeichen == -1) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr01n.format(this.pruefzeichen).toString();
    }

    @Override
    public void setAktualitaet(int n) {
        this.aktualitaet = n;
    }

    @Override
    public int getAktualitaet() {
        return this.aktualitaet;
    }

    @Override
    public String getAktualitaetAsString() {
        if (this.aktualitaet == -1) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr02n.format(this.getAktualitaet()).toString();
    }

    @Override
    public void setBuchFlaeche(double d) {
        this.buchFlaeche = d;
    }

    @Override
    public double getBuchFlaeche() {
        return this.buchFlaeche;
    }

    @Override
    public String getBuchFlaecheAsString() {
        if (this.buchFlaeche == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr.format((int)Math.rint(this.buchFlaeche)).toString();
    }

    @Override
    public double getGeoFlaeche() {
        double d = this.getPolygonFlaeche();
        if (d != 0.0) {
            return Math.abs(d) * DataBase.getFlaecheMasstab(this.y);
        }
        return this.geoFlaeche;
    }

    @Override
    public void setGeoFlaeche(double d) {
        this.geoFlaeche = d;
    }

    @Override
    public String getGeoFlaecheAsString() {
        double d = this.getGeoFlaeche();
        if (d == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr.format((int)Math.rint(d)).toString();
    }

    public String getGeoFlaecheAsDoubleString() {
        double d = this.getGeoFlaeche();
        if (d == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.m02.format(d).toString();
    }

    @Override
    public void setAktFlaeche(double d) {
        this.aktFlaeche = d;
    }

    @Override
    public double getAktFlaeche() {
        return this.aktFlaeche;
    }

    @Override
    public String getAktFlaecheAsString() {
        if (this.aktFlaeche == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr.format((int)Math.rint(this.aktFlaeche)).toString();
    }

    public String getAktFlaecheAsDoubleString() {
        if (this.aktFlaeche == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.m02.format(this.aktFlaeche).toString();
    }

    @Override
    public int getRoundedFlaeche() {
        return this.intFlaeche;
    }

    @Override
    public void setRoundedFlaeche(int n) {
        this.intFlaeche = n;
    }

    @Override
    public String getRoundedFlaecheAsString() {
        return GeoNumberFormat.nr.format(this.getRoundedFlaeche()).toString();
    }

    @Override
    public double getFlaeche() {
        if (this.aktFlaeche != 0.0) {
            return this.aktFlaeche;
        }
        if (this.buchFlaeche != 0.0) {
            return this.buchFlaeche;
        }
        return Math.abs(this.getPolygonFlaeche());
    }

    @Override
    public String getFlaecheAsString() {
        if (this.getFlaeche() == 0.0) {
            return VOID_STRING;
        }
        return GeoNumberFormat.nr.format((int)Math.rint(this.getFlaeche())).toString();
    }

    @Override
    public String getStrasseAsString() {
        if (this.lage == null || !this.lage.hasEntries()) {
            return VOID_STRING;
        }
        return this.lage.getStrasseAsString();
    }

    @Override
    public void setNutzung(int n) {
        this.nutzung = n;
    }

    @Override
    public int getNutzung() {
        return this.nutzung;
    }

    @Override
    public String getNutzungAsString() {
        if (this.nutzung == -1) {
            return VOID_STRING;
        }
        return new Integer(this.nutzung).toString();
    }

    @Override
    public void setKlasse(String string) {
        this.klasse = string;
    }

    @Override
    public String getKlasse() {
        return this.klasse;
    }

    @Override
    public String getKlasseAsString() {
        if (this.klasse == null) {
            return VOID_STRING;
        }
        return this.klasse;
    }

    public boolean hasLage() {
        return this.lage != null;
    }

    public boolean hasStrasse() {
        return this.lage != null && this.lage.hasEntries();
    }

    @Override
    public AbstractLage getLage() {
        return this.lage;
    }

    @Override
    public void setLage(AbstractLage abstractLage) {
        this.lage = (Lage)abstractLage;
    }

    @Override
    public void setLageEntry(AbstractLageEntry abstractLageEntry) {
        if (this.lage == null) {
            this.lage = new Lage();
        }
        this.lage.setEntry((LageEntry)abstractLageEntry);
    }

    @Override
    public void addLageEntry(AbstractLageEntry abstractLageEntry) {
        if (this.lage == null) {
            this.lage = new Lage();
        }
        this.lage.addEntry(abstractLageEntry);
    }

    @Override
    public void setLageBezeichnung(String string) {
        if (this.lage == null) {
            this.lage = new Lage();
        }
        this.lage.setBezeichnung(string);
    }

    @Override
    public String getLageBezeichnung() {
        if (this.lage == null) {
            return null;
        }
        return this.lage.getBezeichnung();
    }

    @Override
    public String getLageBezeichnungAsString() {
        return this.lage != null ? this.lage.getBezeichnungAsString() : VOID_STRING;
    }

    @Override
    public void setBerechnungsArt(int n) {
        this.berechnung = n;
    }

    public void setBerechnungsArt(String string) throws IException {
        Enumeration enumeration = BER_ARTEN.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (!((String)BER_ARTEN.get(n)).equalsIgnoreCase(string)) continue;
            this.berechnung = n;
            return;
        }
        throw new IException("unbekannte Berechnungsart: " + string);
    }

    @Override
    public int getBerechnungsArt() {
        return this.berechnung;
    }

    @Override
    public String getBerechnungsArtAsString() {
        return Flurstueck.getBerechnungsArtAsString(this.berechnung);
    }

    public String getBerechnungsArtAsBelegString() {
        return Flurstueck.getBerechnungsArtAsBelegString(this.berechnung);
    }

    public static String getBerechnungsArtAsString(int n) {
        String string = (String)BER_ARTEN.get(new Integer(n));
        if (string != null) {
            return string;
        }
        return VOID_STRING;
    }

    public static String getBerechnungsArtAsBelegString(int n) {
        String string;
        if (n >= 10) {
            n %= 10;
        }
        if ((string = (String)BER_ARTEN.get(new Integer(n))) != null) {
            return string;
        }
        return VOID_STRING;
    }

    public boolean hasVorgabeNummer() {
        return this.nrVorgabe != null;
    }

    @Override
    public void setVorgabeNummer(String string) {
        this.nrVorgabe = string;
    }

    @Override
    public String getVorgabeNummer() {
        return this.nrVorgabe;
    }

    @Override
    public String getVorgabeNummerAsString() {
        return this.nrVorgabe != null ? this.nrVorgabe : VOID_STRING;
    }

    public boolean hasBuchung() {
        return this.buchung != null;
    }

    public Buchungsstelle getBuchung() {
        return this.buchung;
    }

    public void deleteBuchung() {
        this.buchung = null;
    }

    public void addBuchung(Buchungsstelle buchungsstelle) {
        if (this.buchung != null) {
            Buchungsstelle buchungsstelle2 = this.buchung;
            while (buchungsstelle2.hasNext()) {
                buchungsstelle2 = buchungsstelle2.getNext();
            }
            buchungsstelle2.setNext(buchungsstelle);
        } else {
            this.buchung = buchungsstelle;
        }
    }

    public Enumeration buchungen() {
        return this.buchung != null ? this.buchung.getSequenze() : new VoidEnumerator();
    }

    public boolean equalsBlatt(Flurstueck flurstueck) {
        Buchungsstelle buchungsstelle = flurstueck.getBuchung();
        if (this.buchung != null && buchungsstelle != null && this.buchung.getGrundbuchblattName().equals(buchungsstelle.getGrundbuchblattName())) {
            Buchungsstelle buchungsstelle2 = this.buchung;
            while (buchungsstelle2.hasNext()) {
                buchungsstelle2 = buchungsstelle2.getNext();
                if (buchungsstelle.hasNext()) {
                    buchungsstelle = buchungsstelle.getNext();
                    if (buchungsstelle2.getGrundbuchblattName().equals(buchungsstelle.getGrundbuchblattName())) continue;
                    return false;
                }
                return false;
            }
            return !buchungsstelle.hasNext();
        }
        return false;
    }

    public String getBuchungenAsString() {
        if (this.hasBuchung()) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.buchungen();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration.nextElement();
                stringBuffer.append(buchungsstelle.createDatLineKennzeichen());
            }
            return stringBuffer.toString();
        }
        return VOID_STRING;
    }

    public String getBlaetterAsString() {
        if (this.hasBuchung()) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.buchungen();
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration.nextElement();
                stringBuffer.append(buchungsstelle.getGrundbuchblattName());
            }
            return stringBuffer.toString();
        }
        return VOID_STRING;
    }

    public boolean hasBvnr() {
        return this.bvnr != -1;
    }

    @Override
    public void setBvnr(int n) {
        this.bvnr = (short)n;
    }

    @Override
    public int getBvnr() {
        return this.bvnr;
    }

    @Override
    public String getBvnrAsString() {
        return this.hasBvnr() ? Short.toString(this.bvnr) : VOID_STRING;
    }

    public String getNummer() {
        if (this.gemarkung == -1) {
            return "o.Nr. (" + new Integer(this.count).toString() + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isGemarkung()) {
            Gemarkung gemarkung = Gemarkung.getGemarkung(this.gemarkung);
            if (gemarkung != null) {
                stringBuffer.append(gemarkung.getName());
            } else {
                stringBuffer.append("Gemarkung ");
                stringBuffer.append(this.gemarkung);
            }
        } else if (this.isFlur()) {
            stringBuffer.append("Flur ");
            stringBuffer.append(this.flur);
        } else {
            stringBuffer.append(this.getZaehlerAsString());
            if (this.nenner > 0) {
                stringBuffer.append(BRUCH + new Integer(this.nenner).toString());
            }
        }
        return stringBuffer.toString();
    }

    public String getLongNummer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getZaehler() != -1) {
            stringBuffer.append(GeoNumberFormat.nr05n.format(this.getZaehler()).toString());
        }
        stringBuffer.append(BRUCH);
        if (this.getNenner() != -1) {
            stringBuffer.append(GeoNumberFormat.nr03n.format(this.getNenner()).toString());
        }
        return stringBuffer.toString();
    }

    public String getKennzeichen() {
        if (this.getGemarkung() <= -1) {
            return VOID_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.nr06n.format(this.getGemarkung()).toString());
        stringBuffer.append(PLATZHALTER);
        if (this.getFlur() != -1) {
            stringBuffer.append(GeoNumberFormat.nr03n.format(this.getFlur()).toString());
        }
        return stringBuffer.toString();
    }

    public String getLongKennzeichen() {
        if (this.getGemarkung() <= -1) {
            return VOID_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getKennzeichen());
        if (this.getZaehler() > -1) {
            stringBuffer.append(PLATZHALTER);
            stringBuffer.append(this.getLongNummer());
        }
        return stringBuffer.toString();
    }

    public String getAlkLongKennzeichen() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(GeoNumberFormat.nr06n.format(this.getGemarkung()).toString());
        stringBuffer.append(GeoNumberFormat.nr03n.format(this.getFlur() != -1 ? (long)this.getFlur() : 0L).toString());
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.getZaehler() != -1 ? (long)this.getZaehler() : 0L).toString());
        if (this.getNenner() > 0) {
            stringBuffer.append(GeoNumberFormat.nr03n.format(this.getNenner()).toString());
        } else {
            stringBuffer.append("___");
        }
        stringBuffer.append("__");
        return stringBuffer.toString();
    }

    public String toMiniString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNummer());
        if (this.getTeil() != -1) {
            stringBuffer.append(" " + this.getTeilAsString());
        }
        return stringBuffer.toString();
    }

    public String toLongString() {
        StringBuffer stringBuffer = new StringBuffer(this.getLongKennzeichen());
        if (this.getTeil() != -1) {
            stringBuffer.append(" " + this.getTeilAsString());
        }
        return stringBuffer.toString();
    }

    public String toLongKennzeichen() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.gemarkung != -1) {
            stringBuffer.append(IFormat.i06.format(this.getGemarkung()));
            stringBuffer.append(PLATZHALTER);
            if (this.getFlur() != -1) {
                if (this.flur >= 1000) {
                    stringBuffer.append(IFormat.i04.format(this.getFlur()));
                } else {
                    stringBuffer.append(IFormat.i03.format(this.getFlur()));
                }
                stringBuffer.append(PLATZHALTER);
                if (this.zaehler != -1) {
                    if (this.zaehler >= 100000) {
                        stringBuffer.append('v');
                        stringBuffer.append(IFormat.i04.format(this.getZaehler()));
                    } else {
                        stringBuffer.append(IFormat.i05.format(this.getZaehler()));
                    }
                    stringBuffer.append(BRUCH);
                    stringBuffer.append(IFormat.i03.format(this.getNenner()));
                    if (this.teil != -1) {
                        stringBuffer.append(BRUCH);
                        if (this.teil > 100000) {
                            stringBuffer.append('v');
                            stringBuffer.append(IFormat.i02.format(this.getTeil()));
                        } else {
                            stringBuffer.append(IFormat.i03.format(this.getTeil()));
                        }
                        if (this.getPruefzeichen() != -1) {
                            stringBuffer.append(".");
                            stringBuffer.append(IFormat.i01.format(this.getPruefzeichen()));
                            stringBuffer.append(".");
                            stringBuffer.append(IFormat.i02.format(this.getAktualitaet()));
                        } else {
                            stringBuffer.append("     ");
                        }
                    } else {
                        stringBuffer.append("         ");
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toMiniStringWithNutzung() {
        StringBuffer stringBuffer = new StringBuffer(this.toMiniString());
        if (this.getNutzung() != -1) {
            stringBuffer.append(" N=" + this.getNutzungAsString());
        }
        return stringBuffer.toString();
    }

    public String getFortfuehrungName() {
        if (this.getVorgabeNummer() != null) {
            return this.getVorgabeNummer();
        }
        return this.toMiniString();
    }

    public boolean equals(Object object) {
        if (object instanceof Flurstueck) {
            Flurstueck flurstueck = (Flurstueck)object;
            return this.gemarkung == flurstueck.gemarkung && this.flur == flurstueck.flur && this.zaehler == flurstueck.zaehler && this.nenner == flurstueck.nenner && this.teil == flurstueck.teil && this.nutzung == flurstueck.nutzung && this.count == flurstueck.count;
        }
        return false;
    }

    public boolean equals(int n, int n2, int n3, int n4) {
        return n == this.gemarkung && n2 == this.flur && n3 == this.zaehler && n4 == this.nenner;
    }

    public Flurstueck createNutzstueck(int n, double d) {
        Flurstueck flurstueck = new Flurstueck(901, this.gemarkung, this.flur, this.zaehler, this.nenner, this.teil);
        flurstueck.nutzung = n;
        flurstueck.buchFlaeche = d;
        return flurstueck;
    }

    @Override
    public Vector getKatasterNachweisLinien() {
        return this.getKatasterNachweisLinien(null);
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        Vector<Linie> vector = new Vector<Linie>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Linie linie = null;
        boolean bl = true;
        block6: for (int i = 0; i < this.size(); ++i) {
            Linie linie2 = (Linie)this.elementAt(i);
            if (!linie2.pa.isOn() || linie2.pe != null && !linie2.pe.isOn()) continue;
            switch (linie2.getLs()) {
                case 2: {
                    if (!this.isUmringDefPunkt(linie2.pa) || !this.isUmringDefPunkt(linie2.pe) || !this.isUmringDefLinie(linie2) || vector.contains(linie2)) continue block6;
                    vector.addElement(linie2);
                    continue block6;
                }
                case 1: {
                    n = i;
                }
                case 0: {
                    Linie linie3;
                    if (this.isUmringDefPunkt(linie2.pa)) {
                        if (n2 == -1) {
                            n2 = i;
                        }
                        if (n3 == -1) {
                            n3 = i;
                            linie = linie2;
                            bl = true;
                        } else {
                            linie3 = new Linie(((Linie)this.elementAt((int)n3)).pa, linie2.pa);
                            linie3.getParameter(linie);
                            linie3 = this.testLinieDistance(linie3, n3 + 1, i - 1, exceptionList);
                            if (linie3 != null && !vector.contains(linie3)) {
                                vector.addElement(linie3);
                            }
                            n3 = i;
                        }
                        if (this.isUmringDefPunkt(linie2.pe) && this.isUmringDefLinie(linie2)) {
                            if (!vector.contains(linie2)) {
                                vector.addElement(linie2);
                            }
                            n3 = -1;
                        }
                    }
                    if (this.isUmringDefLinie(linie2)) continue block6;
                    if (n2 == -1) {
                        n2 = -9;
                    }
                    n3 = -1;
                    bl = false;
                    continue block6;
                }
                case 9: {
                    Linie linie3;
                    if (this.isUmringDefPunkt(linie2.pa)) {
                        if (n3 != -1) {
                            linie3 = new Linie(((Linie)this.elementAt((int)n3)).pa, linie2.pa);
                            linie3.getParameter(linie);
                            if (!vector.contains(linie3) && (linie3 = this.testLinieDistance(linie3, n3 + 1, i - 1, exceptionList)) != null) {
                                vector.addElement(linie3);
                            }
                        }
                    } else {
                        if (n < 0) continue block6;
                        if (linie2.pa.equals(((Linie)this.elementAt((int)n)).pa)) {
                            if (n3 != -1 && n2 > -1) {
                                linie3 = new Linie(((Linie)this.elementAt((int)n3)).pa, ((Linie)this.elementAt((int)n2)).pa);
                                linie3.getParameter(linie);
                                if (!vector.contains(linie3)) {
                                    linie3 = this.testLinieDistance(linie3, n3 + 1, i - 1, exceptionList);
                                    if ((linie3 = this.testLinieDistance(linie3, n, n2 - 1, exceptionList)) != null) {
                                        vector.addElement(linie3);
                                    }
                                }
                            }
                        } else if (bl && exceptionList != null) {
                            exceptionList.addException(new GeomException(this.getHashPoint(), this.getPolygon(), "Fehler im Umring, " + this.getExceptionableName() + "\nLinienpunke besitzen nicht korrekte Arten"));
                        }
                    }
                    n = -1;
                    n2 = -1;
                    n3 = -1;
                }
            }
        }
        return vector;
    }

    protected boolean isUmringDefPunkt(Punkt punkt) {
        if (punkt.getKafPa() == -1) {
            int n = punkt.getOska() % 1000;
            return n == 118 || n == 119;
        }
        return punkt.getKafPa() == 1;
    }

    protected boolean isUmringDefLinie(Linie linie) {
        if (linie.getLa() == 2) {
            switch (linie.getEb()) {
                case 1: 
                case 41: 
                case 48: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private Linie testLinieDistance(Linie linie, int n, int n2, ExceptionList exceptionList) {
        if (linie == null || linie.pa.equals(linie.pe)) {
            return null;
        }
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            Punkt punkt = ((Linie)this.elementAt((int)i)).pa;
            double d = linie.getDistance(punkt);
            if (!(Math.abs(d) > DataBase.maxLinieDistance)) continue;
            if (exceptionList != null) {
                bl = true;
                DCollection dCollection = new DCollection(2);
                dCollection.addElement(new DLine(linie.pa, punkt));
                dCollection.addElement(new DLine(punkt, linie.pe));
                exceptionList.addException(new GeomException(punkt, dCollection, "Fehler im Umring, " + this.getExceptionableName() + "\n" + punkt.getExceptionableName() + " ist kein Grenzpunkt\ner weicht um " + IFormat.f_3.format(d).toString() + " aus der " + linie.getExceptionableName() + " ab"));
                continue;
            }
            return null;
        }
        if (bl) {
            return null;
        }
        return linie;
    }

    public int createOska() {
        switch (FlurstueckArt.getArt(this.art)) {
            case 1: {
                return 215;
            }
            case 2: {
                return 231;
            }
            case 3: {
                return 232;
            }
            case 6: 
            case 7: 
            case 8: {
                return 233;
            }
            case 9: {
                return this.getNutzung() * 10;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        if (this.gemarkung == flurstueck.gemarkung) {
            if (this.flur == flurstueck.flur) {
                if (this.zaehler == flurstueck.zaehler) {
                    if (this.nenner == flurstueck.nenner) {
                        if (this.teil == flurstueck.teil) {
                            if (this.nutzung == flurstueck.nutzung) {
                                if (this.count == flurstueck.count) {
                                    return 0;
                                }
                                return this.count > flurstueck.count ? 1 : -1;
                            }
                            return this.nutzung > flurstueck.nutzung ? 1 : -1;
                        }
                        return this.teil > flurstueck.teil ? 1 : -1;
                    }
                    return this.nenner > flurstueck.nenner ? 1 : -1;
                }
                return this.zaehler > flurstueck.zaehler ? 1 : -1;
            }
            return this.flur > flurstueck.flur ? 1 : -1;
        }
        return this.gemarkung > flurstueck.gemarkung ? 1 : -1;
    }

    @Override
    public String getName() {
        return this.toMiniStringWithNutzung();
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        switch (FlurstueckArt.getArt(this.art)) {
            case 2: {
                return KafPlotProperties.isFlstGmkVisible;
            }
            case 3: {
                return KafPlotProperties.isFlstFlurVisible;
            }
            case 6: {
                return KafPlotProperties.isFlstVngVisible;
            }
            case 7: {
                return KafPlotProperties.isFlstFlstVisible;
            }
            case 8: {
                return KafPlotProperties.isFlstTstVisible;
            }
            case 9: {
                return KafPlotProperties.isNutzVisible;
            }
        }
        return true;
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.getClassName());
        stringBuffer2.append(": ");
        stringBuffer2.append(this.getLongKennzeichen());
        if (this.getTeil() != -1) {
            stringBuffer2.append(BRUCH);
            stringBuffer2.append(IFormat.i03.format(this.getTeil()).toString());
        }
        if (this.getNutzung() != -1) {
            stringBuffer2.append("  N=");
        }
        stringBuffer2.append(this.getNutzungAsString());
        if (this.getFlaeche() != 0.0) {
            stringBuffer2.append("  F= ");
            stringBuffer2.append(IFormat.f_2.format(this.aktFlaeche).toString());
            stringBuffer2.append(" m\u02db");
            if (this.aktFlaeche == 0.0) {
                stringBuffer2.append(" (Buchfl\u00e4che)");
            }
        }
        return new Message(this, stringBuffer.toString(), stringBuffer2.toString());
    }

    @Override
    public String toSwitchString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isGemarkung()) {
            Gemarkung gemarkung = Gemarkung.getGemarkung(this.gemarkung);
            if (gemarkung != null) {
                stringBuffer.append(gemarkung.getName());
            } else {
                stringBuffer.append(this.gemarkung);
            }
        } else if (this.isFlur()) {
            Gemarkung gemarkung = Gemarkung.getGemarkung(this.gemarkung);
            if (gemarkung != null) {
                stringBuffer.append(gemarkung.getName());
            } else {
                stringBuffer.append(this.gemarkung);
            }
            stringBuffer.append("Flur ");
            stringBuffer.append(this.flur);
        } else {
            stringBuffer.append(this.toMiniStringWithNutzung());
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Enumeration enumeration;
        printWriter.println(this.toDatLine());
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((ObjectDecor)enumeration.nextElement()).toDatLine());
            }
        }
        if (!this.isAutoGeom()) {
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((DatObject)enumeration.nextElement()).toDatLine());
            }
        }
    }

    @Override
    public String toDatLine() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(KafkaIOProperties.flstAsAlb ? "C!Alb:  " : "C!Flst: ");
        stringBuffer.append(this.toLongKennzeichen());
        stringBuffer.append(" ");
        if (this.isFlaecheRead()) {
            stringBuffer.append("F");
            stringBuffer.append("=");
            stringBuffer.append(IFormat.i09.format(this.getBuchFlaeche()));
        } else if (this.getBerechnungsArt() == 2) {
            stringBuffer.append("F");
            stringBuffer.append("=");
            stringBuffer.append(BER_RDA);
            stringBuffer.append("   ");
        } else {
            stringBuffer.append("        ");
        }
        if (this.getNutzung() != -1) {
            stringBuffer.append(" N=");
            stringBuffer.append(IFormat.i03.format(this.getNutzung()));
        } else {
            stringBuffer.append("      ");
        }
        if (this.isFlaecheRead() && (n = this.getBerechnungsArt()) > 0 && n <= 16) {
            stringBuffer.append(" ");
            stringBuffer.append("B");
            stringBuffer.append("=");
            stringBuffer.append(this.getBerechnungsArtAsString());
        }
        if (this.hasGemeinde()) {
            stringBuffer.append(" D=");
            stringBuffer.append(this.getGemeindeAsString());
        }
        if (this.hasStrasse()) {
            stringBuffer.append(" S=");
            stringBuffer.append(this.lage.toDatString());
        }
        if (this.getKlasse() != null) {
            stringBuffer.append(" K=");
            stringBuffer.append(this.getKlasse().replace(' ', '_'));
        }
        if (this.getLageBezeichnung() != null) {
            stringBuffer.append(" L=");
            stringBuffer.append(this.getLageBezeichnung().replace(' ', '_'));
        }
        if (this.getVorgabeNummer() != null) {
            stringBuffer.append(" V=");
            stringBuffer.append(this.getVorgabeNummer().replace(' ', '_'));
        }
        if (this.getArt() > 0) {
            stringBuffer.append(" A=");
            stringBuffer.append(this.getArt());
        }
        if (this.getOska() != 0 && !this.isNutzstueck()) {
            stringBuffer.append(" O=");
            if (this.getFolie() > 0) {
                stringBuffer.append(IFormat.i03.format(this.getFolie()) + ".");
            }
            stringBuffer.append(this.getOska());
        }
        if (this.hasBuchung()) {
            stringBuffer.append(" G=");
            stringBuffer.append(this.getBuchungenAsString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_1.format(this.y));
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_1.format(this.x));
        }
        if (this.hasTextLocation()) {
            stringBuffer.append(" y=");
            stringBuffer.append(IFormat.f_1.format(this.yt));
            stringBuffer.append(" x=");
            stringBuffer.append(IFormat.f_1.format(this.xt));
        }
        if (super.getColor() != null) {
            stringBuffer.append(" C=");
            stringBuffer.append(IFormat.colorString(super.getColor()));
        }
        return stringBuffer.toString();
    }

    public static DataContainer parseDatLine(String string) throws IException {
        String string2;
        String string3;
        StringTokenizer stringTokenizer;
        Flurstueck flurstueck = new Flurstueck();
        if (string == null) {
            return flurstueck;
        }
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        while (n++ < n2) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                bl = true;
                break;
            }
            if (c == ' ') continue;
        }
        if ((stringTokenizer = new StringTokenizer(string)).countTokens() == 0) {
            return flurstueck;
        }
        if (bl) {
            string3 = stringTokenizer.nextToken();
            if (KafkaIOProperties.datVersion == 3 && string3.indexOf(PLATZHALTER) < 0) {
                try {
                    flurstueck.gemarkung = Integer.parseInt(string3.substring(0, 6));
                    flurstueck.flur = Integer.parseInt(string3.substring(6, 9));
                    flurstueck.zaehler = Integer.parseInt(string3.substring(9, 14));
                    if (string3.charAt(14) != '_') {
                        flurstueck.nenner = Integer.parseInt(string3.substring(14, 18));
                    }
                    flurstueck.nenner = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("unzul\u00e4ssige Zeichen im Flurst\u00fcckskennzeichen");
                }
            } else {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "-/\\.");
                while (stringTokenizer2.hasMoreTokens()) {
                    try {
                        string2 = stringTokenizer2.nextToken();
                        if (flurstueck.gemarkung == -1) {
                            flurstueck.gemarkung = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.flur == -1) {
                            flurstueck.flur = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.zaehler == -1) {
                            if (string2.startsWith("v") || string2.startsWith(VAR_NAME_VORGABE)) {
                                flurstueck.zaehler = new Integer(string2.substring(1)) + 100000;
                                continue;
                            }
                            flurstueck.zaehler = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.nenner == -1) {
                            flurstueck.nenner = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.teil == -1) {
                            if (string2.startsWith("v") || string2.startsWith(VAR_NAME_VORGABE)) {
                                flurstueck.teil = new Integer(string2.substring(1)) + 100000;
                                continue;
                            }
                            flurstueck.teil = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.pruefzeichen == -1) {
                            flurstueck.pruefzeichen = new Integer(string2);
                            continue;
                        }
                        if (flurstueck.aktualitaet != -1) continue;
                        flurstueck.aktualitaet = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IException("unzul\u00e4ssige Zeichen im Flurst\u00fcckskennzeichen");
                    }
                }
            }
            if (flurstueck.gemarkung < 1 || flurstueck.gemarkung > 999999) {
                throw new IException("ung\u00fcltiges Gemarkungskennzeichen");
            }
            if (flurstueck.flur != -1 && (flurstueck.flur < 0 || flurstueck.flur > 9999)) {
                throw new IException("ung\u00fcltiges Flurkennzeichen");
            }
            if (flurstueck.zaehler != -1 && (flurstueck.zaehler > 199999 || flurstueck.nenner > 999)) {
                throw new IException("ung\u00fcltiges Flurst\u00fcckskennzeichen");
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            int n3 = string3.indexOf("=");
            if (n3 < 0) {
                throw new IException("Kennung oder Wert fehlen im Feld \"" + string3 + "\"");
            }
            string2 = string3.substring(0, n3);
            String string4 = string3.substring(n3 + 1);
            if (string2.equalsIgnoreCase(VAR_NAME_NUTZUNG)) {
                try {
                    flurstueck.nutzung = new Integer(string4);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("ung\u00fcltiger Wert im Feld Nutzung");
                }
            }
            if (string2.equalsIgnoreCase(VAR_NAME_LAGE)) {
                flurstueck.setLageBezeichnung(string4.replace('_', ' '));
                continue;
            }
            if (string2.equalsIgnoreCase(VAR_NAME_VORGABE)) {
                flurstueck.nrVorgabe = string4.replace('_', ' ');
                continue;
            }
            if (string2.equalsIgnoreCase(VAR_NAME_GEMEINDE)) {
                try {
                    flurstueck.gemeinde = Integer.parseInt(string4);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("ung\u00fcltiger Wert im Feld Gemeindeschl\u00fcssel");
                }
            }
            if (string2.equalsIgnoreCase(VAR_NAME_STRASSE)) {
                try {
                    Lage lage = Lage.parseDatString(string4);
                    flurstueck.setLageEntry(lage.getEntry());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("ung\u00fcltiger Wert im Feld Stra\u00dfenschl\u00fcssel");
                }
            }
            if (string2.equalsIgnoreCase("K")) {
                flurstueck.klasse = string4.replace('_', ' ');
                continue;
            }
            if (string2.equalsIgnoreCase("F")) {
                if (string4.equalsIgnoreCase("RDA")) {
                    flurstueck.berechnung = 2;
                    continue;
                }
                try {
                    flurstueck.buchFlaeche = new Double(string4);
                    flurstueck.setFlaecheRead(true);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("ung\u00fcltiger Wert im Feld Fl\u00e4che");
                }
            }
            if (string2.equalsIgnoreCase("B")) {
                flurstueck.setBerechnungsArt(string4);
                continue;
            }
            if (string2.equalsIgnoreCase(VAR_NAME_ART)) {
                try {
                    flurstueck.setArt(Integer.parseInt(string4));
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld Art");
                }
            }
            if (string2.equalsIgnoreCase(VAR_NAME_OSKA)) {
                try {
                    int n4 = string4.indexOf(".");
                    if (n4 > 0) {
                        flurstueck.setFolie(Integer.parseInt(string4.substring(0, n4)));
                        flurstueck.setOska(Integer.parseInt(string4.substring(n4 + 1)));
                        continue;
                    }
                    flurstueck.setOska(Integer.parseInt(string4));
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld Oska");
                }
            }
            if (string2.equalsIgnoreCase(VAR_NAME_GRUNDBUCH)) {
                try {
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ",");
                    while (stringTokenizer3.hasMoreTokens()) {
                        String string5 = stringTokenizer3.nextToken();
                        flurstueck.addBuchung(Buchungsstelle.parseDatLineKennzeichen(string5));
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld Grundbuch, " + exception.getMessage());
                }
            }
            if (string2.equals(VAR_NAME_X)) {
                try {
                    flurstueck.x = Double.valueOf(string4);
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld X");
                }
            }
            if (string2.equals(VAR_NAME_Y)) {
                try {
                    flurstueck.y = Double.valueOf(string4);
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld Y");
                }
            }
            if (string2.equals(VAR_NAME_x)) {
                try {
                    flurstueck.xt = Double.valueOf(string4);
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld x");
                }
            }
            if (string2.equals(VAR_NAME_y)) {
                try {
                    flurstueck.yt = Double.valueOf(string4);
                    continue;
                }
                catch (Exception exception) {
                    throw new IException("ung\u00fcltiger Wert im Feld y");
                }
            }
            if (string2.equalsIgnoreCase("C")) {
                flurstueck.setColor(IFormat.parseColor(string4));
                continue;
            }
            throw new IException("ung\u00fcltige Kennung \"" + string2 + "\"");
        }
        if (flurstueck.art == -1) {
            flurstueck.art = DataBase.model.getModel() == 2 ? (flurstueck.gemarkung >= 1 && flurstueck.gemarkung <= 999999 ? (flurstueck.flur >= 0 && flurstueck.flur <= 9999 ? (flurstueck.zaehler >= 1 ? (flurstueck.teil == -1 ? 700 : (flurstueck.teil == 0 ? (flurstueck.zaehler >= 100000 ? (flurstueck.lage == null ? 681 : 601) : (flurstueck.lage != null ? 701 : 781)) : (flurstueck.teil >= 100000 ? 709 : 801))) : 300) : 200) : 0) : (flurstueck.gemarkung >= 1 && flurstueck.gemarkung <= 999999 ? (flurstueck.flur >= 0 && flurstueck.flur <= 9999 ? (flurstueck.zaehler >= 1 ? (flurstueck.teil == -1 ? 700 : (flurstueck.teil == 0 ? (flurstueck.zaehler >= 100000 ? (flurstueck.lage == null ? (flurstueck.nutzung == -1 ? 681 : 901) : (flurstueck.nutzung == -1 ? 691 : 601)) : (flurstueck.pruefzeichen == -1 ? (flurstueck.lage == null && flurstueck.nutzung != -1 ? 901 : 700) : (flurstueck.nutzung != -1 ? (flurstueck.lage == null ? 901 : 701) : (flurstueck.lage == null ? 781 : 791)))) : (flurstueck.teil >= 100000 ? 709 : (flurstueck.nutzung == -1 ? 891 : (flurstueck.lage != null ? 801 : 901))))) : 300) : 200) : 0);
        }
        return flurstueck;
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        printWriter.println(XmlIOProperties.open("flurstueck"));
        if (this.gemarkung != -1) {
            printWriter.println(XmlIOProperties.data("gmrk", this.getGemarkungAsString()));
        }
        if (this.flur != -1) {
            printWriter.println(XmlIOProperties.data("flur", this.getFlurAsString()));
        }
        if (this.zaehler != -1) {
            printWriter.println(XmlIOProperties.data("zaehler", this.getZaehlerAsString()));
        }
        if (this.nenner != -1) {
            printWriter.println(XmlIOProperties.data("nenner", this.getNennerAsString()));
        }
        if (this.teil != -1) {
            printWriter.println(XmlIOProperties.data("teil", this.getTeilAsString()));
        }
        if (this.pruefzeichen != -1) {
            printWriter.println(XmlIOProperties.data("prz", this.getPruefzeichenAsString()));
        }
        if (this.aktualitaet != -1) {
            printWriter.println(XmlIOProperties.data("akt", this.getAktualitaetAsString()));
        }
        if (this.nutzung != -1) {
            printWriter.println(XmlIOProperties.data("nutz", this.getNutzungAsString()));
        }
        if (this.berechnung != -1) {
            printWriter.println(XmlIOProperties.data("ber", this.getBerechnungsArtAsString()));
        }
        if (this.art != -1) {
            printWriter.println(XmlIOProperties.data("art", Integer.toString(this.art)));
        }
        if (this.klasse != null) {
            printWriter.println(XmlIOProperties.data("klas", this.klasse));
        }
        if (this.nrVorgabe != null) {
            printWriter.println(XmlIOProperties.data("vnr", this.nrVorgabe));
        }
        if (this.buchFlaeche != 0.0) {
            printWriter.println(XmlIOProperties.data("bfl", IFormat.f_2.format(this.buchFlaeche).toString()));
        }
        if (this.aktFlaeche != 0.0) {
            printWriter.println(XmlIOProperties.data("afl", IFormat.f_2.format(this.aktFlaeche).toString()));
        }
        printWriter.println(XmlIOProperties.data("kfl", IFormat.i.format(this.intFlaeche).toString()));
        if (this.hasLocation()) {
            printWriter.println(XmlIOProperties.data(VAR_NAME_y, IFormat.f_3.format(this.y).toString()));
            printWriter.println(XmlIOProperties.data(VAR_NAME_x, IFormat.f_3.format(this.x).toString()));
        }
        if (this.getOska() != 0) {
            printWriter.println(XmlIOProperties.data("os", IFormat.i04.format(this.getOska()).toString()));
        }
        printWriter.println(XmlIOProperties.open("linien"));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Linie)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("linien"));
        printWriter.println(XmlIOProperties.close("flurstueck"));
    }

    public Node toGml() throws Exception {
        Node node = new Node("Flurstueck");
        node.addNode(new Node("kafplot:name", this.getLongKennzeichen()));
        Gemarkung gemarkung = Gemarkung.getGemarkung(this.gemarkung);
        if (gemarkung != null) {
            Gemeinde gemeinde = gemarkung.getGemeinde();
            if (gemeinde != null) {
                node.addNode(new Node("kafplot:gemeinde", Integer.toString(gemeinde.getNummer())));
                node.addNode(new Node("kafplot:gemeinde_name", gemeinde.getName()));
            }
            node.addNode(new Node("kafplot:gemarkung", Integer.toString(gemarkung.getNummer())));
            node.addNode(new Node("kafplot:gemarkung_name", gemarkung.getName()));
        }
        node.addNode(new Node("kafplot:flur", Integer.toString(this.getFlur())));
        node.addNode(new Node("kafplot:nummer", this.toMiniString()));
        if (this.lage != null) {
            node.addNode(this.lage.toGml());
        }
        if (this.hasBuchung()) {
            node.addNode(new Node("kafplot:grundbuchblatt", this.getBuchungenAsString()));
        }
        return node;
    }

    public static String toZenoDefLine() {
        return "FID;VID;X;Y;Z;Gemarkung;Flur;Flurst\u00fcck;Buchfl\u00e4che;Realfl\u00e4che;Lage;Eigent\u00fcmer;Bild";
    }

    public void writeZenoLines(OutputStream outputStream, Charset charset, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getGemarkungName());
        stringBuffer.append(";");
        stringBuffer.append(this.flur);
        stringBuffer.append(";");
        if (this.isTeilstueck()) {
            stringBuffer.append(this.getTeilAsString());
            stringBuffer.append(" aus ");
        }
        stringBuffer.append(this.getNummer());
        if (this.isTeilstueck() && this.getVorgabeNummer() != null) {
            stringBuffer.append(" -> ");
            stringBuffer.append(this.getVorgabeNummer());
        }
        stringBuffer.append(";");
        stringBuffer.append(IFormat.f_1.format(this.buchFlaeche));
        stringBuffer.append(";");
        stringBuffer.append(IFormat.f_1.format(this.getGeoFlaeche()));
        stringBuffer.append(";");
        if (this.lage != null) {
            stringBuffer.append(this.lage.getBezeichnungAsString());
        }
        stringBuffer.append(";");
        Enumeration enumeration = this.buchungen();
        while (enumeration.hasMoreElements()) {
            Buchungsstelle buchungsstelle = (Buchungsstelle)enumeration.nextElement();
            String string = buchungsstelle.getGrundbuchblattName();
            stringBuffer.append("GB" + IFormat.trimLeft(Grundbuchblatt.getBlatt(string), '0'));
            stringBuffer.append(" ");
            Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(string);
            if (grundbuchblatt == null) continue;
            Enumeration enumeration2 = grundbuchblatt.elements();
            while (enumeration2.hasMoreElements()) {
                Name name = (Name)enumeration2.nextElement();
                stringBuffer.append(name.getNameAsString());
                if (name.hasGeburtName()) {
                    stringBuffer.append(" geb.");
                    stringBuffer.append(name.getGeburtName());
                }
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(";");
        super.writeZenoLines(outputStream, charset, n, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return FlurstueckArt.getArtName(this.art);
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLongKennzeichen());
        if (this.teil > 0) {
            stringBuffer.append(BRUCH);
            stringBuffer.append(IFormat.i03.format(this.teil));
        }
        if (this.nutzung > -1) {
            stringBuffer.append(" N=");
            stringBuffer.append(IFormat.i03.format(this.nutzung));
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getLongKennzeichen());
        stringBuffer.append(" " + this.getTeilAsString());
        stringBuffer.append(" N=" + this.getNutzungAsString());
        stringBuffer.append(" A=" + this.art);
        return stringBuffer.toString();
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(this.getFolie());
        dataOutput.writeInt(this.getOska());
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeInt(this.gemarkung);
        dataOutput.writeInt(this.flur);
        dataOutput.writeInt(this.zaehler);
        dataOutput.writeInt(this.nenner);
        dataOutput.writeShort(this.teil);
        dataOutput.writeByte(this.pruefzeichen);
        dataOutput.writeByte(this.aktualitaet);
        dataOutput.writeShort(this.nutzung);
        dataOutput.writeByte(this.berechnung);
        dataOutput.writeDouble(this.buchFlaeche);
        dataOutput.writeDouble(this.aktFlaeche);
        dataOutput.writeInt(this.intFlaeche);
        if (this.lage != null) {
            this.lage.writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
        KafPlotIOConstants.writeString(dataOutput, this.klasse);
        KafPlotIOConstants.writeString(dataOutput, this.nrVorgabe);
        dataOutput.writeShort(this.count);
        dataOutput.writeShort(this.art);
        if (this.hasBuchung()) {
            dataOutput.writeByte(9);
            KafPlotIOConstants.writeString(dataOutput, this.getBuchungenAsString());
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeInt(this.flags);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Linie)enumeration.nextElement()).writeObject(dataOutput);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ((ObjectDecor)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        if (this.att != null) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(110);
                String string = (String)enumeration.nextElement();
                KafPlotIOConstants.writeString(dataOutput, string);
                KafPlotIOConstants.writeString(dataOutput, this.getAttribute(string).toString());
            }
        }
        dataOutput.writeByte(0);
    }

    public static Flurstueck readObject(DataInput dataInput) throws IOException {
        Flurstueck flurstueck = new Flurstueck();
        flurstueck.y = dataInput.readDouble();
        flurstueck.x = dataInput.readDouble();
        if (KpvIOProperties.RVER >= 106 && dataInput.readByte() != 0) {
            flurstueck.yt = dataInput.readDouble();
            flurstueck.xt = dataInput.readDouble();
        }
        flurstueck.setFolie(dataInput.readShort());
        if (KpvIOProperties.RVER >= 202) {
            flurstueck.setOska(dataInput.readInt());
        } else {
            flurstueck.setOska(dataInput.readShort());
        }
        flurstueck.setTextAngle(dataInput.readFloat());
        flurstueck.gemarkung = dataInput.readInt();
        flurstueck.flur = dataInput.readInt();
        flurstueck.zaehler = dataInput.readInt();
        flurstueck.nenner = dataInput.readInt();
        flurstueck.teil = dataInput.readShort();
        flurstueck.pruefzeichen = dataInput.readByte();
        flurstueck.aktualitaet = dataInput.readByte();
        flurstueck.nutzung = dataInput.readShort();
        flurstueck.berechnung = dataInput.readByte();
        flurstueck.buchFlaeche = dataInput.readDouble();
        flurstueck.aktFlaeche = dataInput.readDouble();
        flurstueck.intFlaeche = dataInput.readInt();
        if (dataInput.readByte() == 81) {
            flurstueck.setLage(Lage.readObject(dataInput));
        }
        flurstueck.klasse = KafPlotIOConstants.readString(dataInput);
        flurstueck.nrVorgabe = KafPlotIOConstants.readString(dataInput);
        flurstueck.count = dataInput.readShort();
        flurstueck.art = dataInput.readShort();
        try {
            if (dataInput.readByte() != 0) {
                if (KpvIOProperties.RVER >= 204) {
                    var2_2 = KafPlotIOConstants.readString(dataInput);
                    var3_5 = new StringTokenizer(var2_2, ",");
                    while (var3_5.hasMoreTokens()) {
                        flurstueck.addBuchung(Buchungsstelle.parseDatLineKennzeichen(var3_5.nextToken()));
                    }
                } else if (KpvIOProperties.RVER >= 200) {
                    var2_2 = KafPlotIOConstants.readString(dataInput);
                    var3_5 = new StringTokenizer(var2_2, ",");
                    while (var3_5.hasMoreTokens()) {
                        flurstueck.addBuchung(new Buchungsstelle(var3_5.nextToken(), "0", 0));
                    }
                    dataInput.readShort();
                } else {
                    flurstueck.addBuchung(new Buchungsstelle(Long.toString(dataInput.readLong()), Short.toString(dataInput.readShort()), 0));
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        flurstueck.flags = dataInput.readInt();
        byte by = 0;
        while ((by = dataInput.readByte()) != -1) {
            if (by == 15) {
                flurstueck.addElement(Linie.readObject(dataInput));
                continue;
            }
            if (by == 61) {
                flurstueck.addDecor(ObjectText.readObject(dataInput));
                continue;
            }
            if (by == 62) {
                flurstueck.addDecor(ObjectSymbol.readObject(dataInput));
                continue;
            }
            if (by == 63) {
                flurstueck.addDecor(ObjectLine.readObject(dataInput));
                continue;
            }
            if (by != 110) break;
            flurstueck.setAttribute(KafPlotIOConstants.readString(dataInput), KafPlotIOConstants.readString(dataInput));
        }
        return flurstueck;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.isVisible() && this.isViewable(iGraphics.getViewport())) {
            if (bl2 || KafPlotProperties.isFlaecheFillVisible && KafPlotProperties.isFlstFillVisible) {
                this.drawBackground(iGraphics, bl, bl2);
            }
            if (bl2 || KafPlotProperties.isFlaechePolyVisible && KafPlotProperties.isFlstPolyVisible) {
                this.drawForeground(iGraphics, bl, bl2);
            }
            if (KafPlotProperties.isFlaecheTextVisible) {
                this.drawInscription(iGraphics, bl, bl2);
            }
            if (bl2) {
                this.drawHashpoint(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        switch (KafPlotProperties.getColorSwitch()) {
            case 1004: {
                if (!this.isFortfuehrung()) {
                    iGraphics.getGraphics().setColor(KafPlotProperties.aFoColor.getColor("F0"));
                    break;
                }
                if (this.teil <= 0) {
                    iGraphics.getGraphics().setColor(KafPlotProperties.aFoColor.getColor("F1"));
                    break;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aFoColor.getColor("F2"));
                break;
            }
            case 1009: {
                iGraphics.getGraphics().setColor(IColor.getBrighter(KafPlotProperties.aBgColor.getColor(VAR_NAME_OSKA), 0.7f));
                break;
            }
            case 1002: {
                if (this.getNutzung() <= 0) {
                    return;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aNuColor.getColor(new Integer(this.getNutzung())));
                break;
            }
            case 1005: {
                if (this.getLage() == null) {
                    return;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aLaColor.getColor(((Lage)this.getLage()).getStrasseKey()));
                break;
            }
            case 1010: {
                if (this.getLage() == null) {
                    return;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aAdColor.getColor(((Lage)this.getLage()).getAdresseKey()));
                break;
            }
            case 1003: {
                if (!this.hasBuchung()) {
                    return;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aGrColor.getColor(Integer.parseInt(IFormat.getNumbers(Grundbuchblatt.getBlatt(this.buchung.getGrundbuchblattName())))));
                break;
            }
            case 1006: {
                iGraphics.getGraphics().setColor(KafPlotProperties.aKaColor.getColor("F"));
                break;
            }
            case 1007: {
                double d = this.getBuchFlaeche();
                double d2 = this.getGeoFlaeche();
                if (d == 0.0 || d2 == 0.0) {
                    return;
                }
                double d3 = 100.0 * (d2 - d) / d;
                iGraphics.getGraphics().setColor(KafPlotProperties.aFaColor.getColor(d3));
                break;
            }
            case 1011: {
                double d = this.getBuchFlaeche();
                double d4 = this.getGeoFlaeche();
                if (d == 0.0 || d4 == 0.0) {
                    return;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aFdColor.getColor(d4 - d));
                break;
            }
            case 1008: {
                double d = this.getBuchFlaeche();
                double d5 = this.getGeoFlaeche();
                if (d == 0.0 || d5 == 0.0) {
                    return;
                }
                double d6 = 100.0 * (d5 - d) / d;
                iGraphics.getGraphics().setColor(KafPlotProperties.aFeColor.getColor(d6));
                break;
            }
            default: {
                if (this.getColor() != null) {
                    iGraphics.getGraphics().setColor(this.getColor());
                    break;
                }
                iGraphics.getGraphics().setColor(KafPlotProperties.aStColor.getColor(new Integer(1)));
            }
        }
        super.drawBackground(iGraphics, bl, bl2);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawInscription(iGraphics, bl, bl2, false);
    }

    public void printInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawInscription(iGraphics, bl, bl2, true);
    }

    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer;
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2) {
            iGraphics.setXORMode();
        } else {
            iGraphics.setPaintMode();
        }
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        Font font = bl3 ? pFont : dFont;
        Font font2 = bl3 ? pBigFont : dBigFont;
        Font font3 = bl3 ? pSmallFont : dSmallFont;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        FontMetrics fontMetrics2 = Toolkit.getDefaultToolkit().getFontMetrics(font2);
        FontMetrics fontMetrics3 = Toolkit.getDefaultToolkit().getFontMetrics(font3);
        IInscriptionComponent iInscriptionComponent = null;
        Color color = null;
        boolean bl4 = false;
        if (KafPlotProperties.getColorSwitch() == 1009) {
            color = KafPlotProperties.aBgColor.getColor(VAR_NAME_OSKA);
            bl4 = true;
        } else if (KafPlotProperties.getColorSwitch() == 1004 && !this.isFortfuehrung() && !super.isFortfuehrung()) {
            color = IColor.getDarker(KafPlotProperties.aFoColor.getColor("F0"), 0.85f);
            bl4 = true;
        }
        if (this.hasTextLocation()) {
            if (!iGraphics.contains(this.yt, this.xt)) {
                this.drawDecors(iGraphics, bl, bl2);
                return;
            }
            point = iGraphics.getGraphicPoint(this.yt, this.xt, point);
        } else {
            if (!iGraphics.contains(this.y, this.x)) {
                this.drawDecors(iGraphics, bl, bl2);
                return;
            }
            point = iGraphics.getGraphicPoint(new DPoint(this.y, this.x), point);
        }
        if (!iGraphics.getDrawRect().contains(point)) {
            this.drawDecors(iGraphics, bl, bl2);
            return;
        }
        Object object4 = new IInscription(point);
        int n = 0;
        int n2 = 0;
        if (this.isVoid()) {
            if (KafPlotProperties.isFlstTextOldVisible) {
                iInscriptionComponent = new IInscriptionComponent(this.getNummer(), 0, 0);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setForeground(Ebene.getColor(1));
                iInscriptionComponent.setFont(font);
            }
        } else if (this.isGemarkung() || this.isFlur()) {
            if (KafPlotProperties.isFlstTextOldVisible) {
                iInscriptionComponent = new IInscriptionComponent(this.getNummer(), 0, 0);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setForeground(Ebene.getColor(49));
                iInscriptionComponent.setFont(font2);
            }
        } else if (this.isVereinigungStammstueck()) {
            if (KafPlotProperties.isFlstTextOldVisible) {
                iInscriptionComponent = new IInscriptionComponent(this.getZaehlerAsString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(1));
            }
            if (KafPlotProperties.isFlstTextNewVisible && this.getVorgabeNummer() != null) {
                iInscriptionComponent = new IInscriptionComponent(this.getVorgabeNummerAsString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(48));
            }
        } else if (this.isFlurstueck()) {
            if (KafPlotProperties.isFlstTextOldVisible) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.getZaehlerAsString());
                if (this.getNenner() > 0) {
                    stringBuffer.append("\t");
                    stringBuffer.append(this.getNennerAsString());
                }
                iInscriptionComponent = new IInscriptionComponent(stringBuffer.toString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(1));
                if (FlurstueckArt.isUntergang(this.art)) {
                    iInscriptionComponent = new IInscriptionComponent(stringBuffer.toString(), 1, n2 - 1, n);
                    ((IInscription)object4).add(iInscriptionComponent);
                    iInscriptionComponent.setFont(font);
                    iInscriptionComponent.setTextVisible(false);
                    iInscriptionComponent.setForeground(Ebene.getColor(48));
                }
            }
            if (KafPlotProperties.isFlstTextNewVisible && this.getVorgabeNummer() != null) {
                iInscriptionComponent = new IInscriptionComponent(this.getVorgabeNummerAsString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(48));
            }
        } else if (this.isTeilstueck()) {
            if (KafPlotProperties.isFlstTextOldVisible) {
                iInscriptionComponent = new IInscriptionComponent(this.getTeilAsString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(48));
            }
            if (KafPlotProperties.isFlstTextNewVisible && this.getVorgabeNummer() != null) {
                iInscriptionComponent = new IInscriptionComponent(this.getVorgabeNummerAsString(), n2++, n);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(48));
            }
        }
        ++n;
        if ((KafPlotProperties.isNutzTextVisible || KafPlotProperties.isNutzNumberVisible) && this.getNutzung() > -1) {
            stringBuffer = new StringBuffer();
            if (KafPlotProperties.isNutzTextVisible && (object3 = NutzungsArt.getNutzungsArt(this.getNutzung())) != null) {
                stringBuffer.append(((NutzungsArt)object3).getAbkuerzung());
            }
            if (KafPlotProperties.isNutzNumberVisible) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("(");
                stringBuffer.append(this.getNutzungAsString());
                stringBuffer.append(")");
            }
            iInscriptionComponent = new IInscriptionComponent(stringBuffer.toString(), 0, n++);
            ((IInscription)object4).add(iInscriptionComponent);
            if (KafPlotProperties.getColorSwitch() == 1004) {
                iInscriptionComponent.setFont(font3);
                iInscriptionComponent.setForeground(this.isFortfuehrung() ? Color.black : Ebene.getColor(49));
            } else {
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(Ebene.getColor(47));
            }
        }
        if (this.lage != null) {
            if (KafPlotProperties.isLageKeyVisible) {
                iInscriptionComponent = new IInscriptionComponent(this.lage.getStrasseAsString(), 0, n++);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.LAGE);
            }
            if (KafPlotProperties.isLageTextVisible && (this.lage.hasBezeichnung() || this.lage.isComplete())) {
                iInscriptionComponent = new IInscriptionComponent(this.lage.getBezeichnungAsString(), 0, n++);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.LAGE);
            }
        }
        if (this.isDetailTextVisible()) {
            if (KafPlotProperties.isAreaBuchVisible && this.getBuchFlaeche() != 0.0) {
                iInscriptionComponent = new IInscriptionComponent((int)Math.rint(this.getBuchFlaeche()) + " m\u00b2", 0, n++);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.FLAECHE_BUCH);
            }
            if (KafPlotProperties.isAreaKooVisible && this.getGeoFlaeche() != 0.0) {
                iInscriptionComponent = new IInscriptionComponent((int)Math.rint(this.getGeoFlaeche()) + " m\u00b2", 0, n++);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.FLAECHE_KOO);
            }
            if ((KafPlotProperties.isAreaDiffVisible || KafPlotProperties.isAreaPercVisible) && this.getBuchFlaeche() != 0.0 && this.getGeoFlaeche() != 0.0) {
                double d = this.getGeoFlaeche() - this.getBuchFlaeche();
                double d2 = 100.0 * d / this.getBuchFlaeche();
                object2 = new StringBuffer();
                if (KafPlotProperties.isAreaDiffVisible) {
                    if (d > 1.0) {
                        ((StringBuffer)object2).append("+");
                    }
                    ((StringBuffer)object2).append((int)Math.rint(d));
                    ((StringBuffer)object2).append(" m\u00b2 ");
                }
                if (KafPlotProperties.isAreaPercVisible) {
                    if (d2 > 1.0) {
                        ((StringBuffer)object2).append("+");
                    }
                    ((StringBuffer)object2).append(IFormat.f_1.format(d2));
                    ((StringBuffer)object2).append(" %");
                }
                iInscriptionComponent = new IInscriptionComponent(((StringBuffer)object2).toString(), 0, n++);
                ((IInscription)object4).add(iInscriptionComponent);
                iInscriptionComponent.setFont(font);
                iInscriptionComponent.setForeground(KafPlotColor.FLAECHE_DIFF);
            }
        }
        if (((Container)object4).getComponentCount() > 0) {
            Dimension dimension = ((IInscription)object4).getSize();
            if (bl4) {
                for (int i = 0; i < ((Container)object4).getComponentCount(); ++i) {
                    ((Container)object4).getComponent(i).setForeground(color);
                }
            }
            if (this.hasTextLocation()) {
                object = iGraphics.getGraphicPoint(this.y, this.x, new Point());
                int n3 = point.x - dimension.width / 2 > ((Point)object).x ? point.x - dimension.width / 2 - 3 : (point.x + dimension.width / 2 < ((Point)object).x ? point.x + dimension.width / 2 + 3 : point.x);
                int n4 = point.y + dimension.height / 2 < ((Point)object).y ? point.y + dimension.height / 2 + 3 : (point.y - dimension.height / 2 > ((Point)object).y ? point.y - dimension.height / 2 - 3 : point.y);
                graphics.setColor(((Container)object4).getComponent(0).getForeground());
                graphics.drawLine(((Point)object).x, ((Point)object).y, n3, n4);
            }
            ((IInscription)object4).setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
            ((IInscription)object4).doLayout();
            ((IInscription)object4).printComponents(graphics);
        }
        if (this.hasBuchung() && this.isDetailTextVisible() && (KafPlotProperties.isGbblVisible || KafPlotProperties.isEtNameVisible || KafPlotProperties.isEtAllVisible)) {
            Point point2 = ((Component)object4).getLocation();
            point2.x += ((IInscription)object4).getSize().width / 2;
            object3 = this.buchungen();
            while (object3.hasMoreElements()) {
                Serializable serializable;
                Object object5;
                Object object6;
                Object object7;
                Buchungsstelle buchungsstelle = (Buchungsstelle)object3.nextElement();
                object = buchungsstelle.getGrundbuchblattName();
                if (KafPlotProperties.isGbblVisible) {
                    object2 = new IInscription();
                    object7 = buchungsstelle.hasLaufendeNummer() && !"null".equals(buchungsstelle.getLaufendeNummer()) ? "." + buchungsstelle.getLaufendeNummer() : VOID_STRING;
                    iInscriptionComponent = new IInscriptionComponent("[" + IFormat.trimLeft(Grundbuchblatt.getBlatt((String)object), '0') + (String)object7 + "]", 0, 0);
                    ((IInscription)object2).add(iInscriptionComponent);
                    iInscriptionComponent.setFont(font);
                    iInscriptionComponent.setForeground(bl4 ? color : KafPlotColor.GRUNDBUCHBLATT);
                    object6 = ((Component)object4).getLocation();
                    object5 = ((IInscription)object4).getSize();
                    serializable = ((IInscription)object2).getSize();
                    ((IInscription)object2).setOrientation(-10);
                    ((IInscription)object2).setLocation(point2.x - ((Dimension)serializable).width / 2, ((Point)object6).y + ((Dimension)object5).height + 5);
                    ((IInscription)object2).doLayout();
                    ((IInscription)object2).printComponents(graphics);
                    object4 = object2;
                }
                if ((object2 = (Grundbuchblatt)DataBase.BUCH.get((String)object)) == null || !KafPlotProperties.isEtNameVisible && !KafPlotProperties.isEtAllVisible) continue;
                object7 = new IInscription();
                n2 = 0;
                n = 0;
                object6 = ((DataContainer)object2).elements();
                while (object6.hasMoreElements()) {
                    object5 = (Name)object6.nextElement();
                    n2 = 0;
                    if (KafPlotProperties.isEtNameVisible) {
                        if (KafPlotProperties.isEtAllVisible && ((Name)object5).getNummer() > 0L) {
                            iInscriptionComponent = new IInscriptionComponent(((Name)object5).getKennzeichenAsString(), 0, n);
                            ((IInscription)object7).add(iInscriptionComponent);
                            iInscriptionComponent.setOrientation(-11);
                            iInscriptionComponent.setFont(font);
                            iInscriptionComponent.setForeground(bl4 ? color : KafPlotColor.EIGENTUM);
                            ++n2;
                        }
                        serializable = new StringBuffer(((Name)object5).getNameAsString());
                        if (KafPlotProperties.isEtAllVisible) {
                            boolean bl5 = false;
                            if (((Name)object5).hasGeburtName() || ((Name)object5).hasGeburtDatum()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, "geb.");
                            }
                            if (((Name)object5).hasGeburtName()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getGeburtName());
                            }
                            if (((Name)object5).hasGeburtDatum()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getGeburtDatum());
                            }
                            bl5 = false;
                            if (((Name)object5).hasAdresse()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getAdresse());
                            }
                            if (((Name)object5).hasPlzPf()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getPlzPfAsString());
                            }
                            if (((Name)object5).hasPostfach()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getPostfachAsString());
                            }
                            bl5 = false;
                            if (((Name)object5).hasPostleitzahl()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getPostleitzahlAsString());
                            }
                            if (((Name)object5).hasOrt()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getOrt());
                            }
                            if (((Name)object5).hasLand()) {
                                bl5 = Flurstueck.appendText((StringBuffer)serializable, bl5, ((Name)object5).getLandAsString());
                            }
                        }
                        if (((Name)object5).hasVertretung()) {
                            Flurstueck.appendText((StringBuffer)serializable, false, ((Name)object5).getVertretung());
                        }
                        iInscriptionComponent = new IInscriptionComponent(((StringBuffer)serializable).toString(), n2, n);
                        ((IInscription)object7).add(iInscriptionComponent);
                        iInscriptionComponent.setOrientation(-11);
                        iInscriptionComponent.setFont(font);
                        iInscriptionComponent.setForeground(bl4 ? color : KafPlotColor.EIGENTUM);
                    }
                    ++n;
                }
                if (((Container)object7).getComponentCount() > 0) {
                    object6 = ((Component)object4).getLocation();
                    object5 = ((IInscription)object4).getSize();
                    serializable = ((IInscription)object7).getSize();
                    ((IInscription)object7).setOrientation(-10);
                    ((IInscription)object7).setLocation(point2.x - ((Dimension)serializable).width / 3, ((Point)object6).y + ((Dimension)object5).height + 5);
                    ((IInscription)object7).doLayout();
                    ((IInscription)object7).printComponents(graphics);
                    object4 = object7;
                }
                if (!KafPlotProperties.isEtAllVisible || !((Grundbuchblatt)object2).hasZusatz()) continue;
                object7 = new IInscription();
                n = 0;
                object6 = new StringTokenizer(((Grundbuchblatt)object2).getZusatz(), ";");
                while (((StringTokenizer)object6).hasMoreTokens()) {
                    iInscriptionComponent = new IInscriptionComponent(((StringTokenizer)object6).nextToken(), 0, n);
                    ((IInscription)object7).add(iInscriptionComponent);
                    iInscriptionComponent.setOrientation(-11);
                    iInscriptionComponent.setFont(font);
                    iInscriptionComponent.setForeground(bl4 ? color : KafPlotColor.EIGENTUM);
                    ++n;
                }
                object5 = ((Component)object4).getLocation();
                serializable = ((IInscription)object4).getSize();
                Dimension dimension = ((IInscription)object7).getSize();
                ((IInscription)object7).setOrientation(-10);
                ((IInscription)object7).setLocation(((Point)object5).x, ((Point)object5).y + ((Dimension)serializable).height);
                ((IInscription)object7).doLayout();
                ((IInscription)object7).printComponents(graphics);
                object4 = object7;
            }
        }
        if (this.hasDecor() && KafPlotProperties.isNutzSymVisible && KafPlotProperties.getColorSwitch() != 1004) {
            Enumeration enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                object3 = (ObjectDecor)enumeration.nextElement();
                ((ObjectDecor)object3).setColor(KafPlotProperties.getColorSwitch() == 1009 ? KafPlotProperties.aBgColor.getColor(VAR_NAME_OSKA) : Ebene.getColor(47));
                ((ObjectDecor)object3).drawObject(iGraphics, bl, bl2);
            }
        }
    }

    private boolean isDetailTextVisible() {
        if (KafPlotProperties.isFlstTextFfVisible || KafPlotProperties.isFlstTextFnVisible) {
            if (this.isFortfuehrung()) {
                return KafPlotProperties.isFlstTextFfVisible;
            }
            if (this.isFFNeighbor()) {
                return KafPlotProperties.isFlstTextFnVisible;
            }
            return false;
        }
        return true;
    }

    private void drawDecors(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.hasDecor() && KafPlotProperties.isNutzSymVisible && KafPlotProperties.getColorSwitch() != 1004) {
            Enumeration enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ObjectDecor objectDecor = (ObjectDecor)enumeration.nextElement();
                objectDecor.setColor(KafPlotProperties.getColorSwitch() == 1009 ? KafPlotProperties.aBgColor.getColor(VAR_NAME_OSKA) : Ebene.getColor(47));
                objectDecor.drawObject(iGraphics, bl, bl2);
            }
        }
    }

    private static boolean appendText(StringBuffer stringBuffer, boolean bl, String string) {
        if (!bl) {
            stringBuffer.append("\n");
            bl = true;
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        return bl;
    }

    public String toString() {
        return this.getExceptionableName();
    }

    static {
        BER_ARTEN.put(new Integer(0), BER_OHNE);
        BER_ARTEN.put(new Integer(6), BER_KOO);
        BER_ARTEN.put(new Integer(5), "F");
        BER_ARTEN.put(new Integer(3), "K");
        BER_ARTEN.put(new Integer(4), BER_FK);
        BER_ARTEN.put(new Integer(2), BER_RDA);
        BER_ARTEN.put(new Integer(1), "B");
        BER_ARTEN.put(new Integer(10), BER_SOLL);
        BER_ARTEN.put(new Integer(15), BER_SOLL_F);
        BER_ARTEN.put(new Integer(14), BER_SOLL_FK);
        BER_ARTEN.put(new Integer(13), BER_SOLL_K);
        BER_ARTEN.put(new Integer(16), BER_SOLL_KOO);
        dFont = new Font("SansSerif", 3, 14);
        dBigFont = new Font("SansSerif", 3, 24);
        dSmallFont = new Font("SansSerif", 2, 14);
        pFont = new Font("SansSerif", 3, 9);
        pBigFont = new Font("SansSerif", 3, 16);
        pSmallFont = new Font("SansSerif", 2, 9);
    }
}

