/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import java.util.Enumeration;
import java.util.Hashtable;

public final class FlurstueckArt {
    public static final int GEMEINDE = 1;
    public static final int GEMARKUNG = 2;
    public static final int FLUR = 3;
    public static final int VEREINIGUNG = 6;
    public static final int FLURSTUECK = 7;
    public static final int TEILSTUECK = 8;
    public static final int NUTZUNG = 9;
    public static final int FORTF = 1;
    public static final int UNTERGANG = 9;
    public static final int OHNE = 0;
    public static final int GMK = 200;
    public static final int FLR = 300;
    public static final int VST_O = 601;
    public static final int VST_M_TST = 681;
    public static final int VST_M_NST = 691;
    public static final int FST = 700;
    public static final int FST_U = 709;
    public static final int FST_O = 701;
    public static final int FST_M_TST = 781;
    public static final int FST_M_NST = 791;
    public static final int TST_O = 801;
    public static final int TST_M_NST = 891;
    public static final int NST_O = 901;
    private static final String OHNE_STRING = "ohne Namen";
    private static final String GMK_STRING = "Gemarkung";
    private static final String FLR_STRING = "Flur";
    private static final String VST_O_STRING = "Vereinigung";
    private static final String VST_M_TST_STRING = "Vereinigung mit Teilst\u00fccken";
    private static final String VST_M_NST_STRING = "Vereinigung mit Nutzungen";
    private static final String FST_STRING = "Flurst\u00fcck ohne Fortf.";
    private static final String FST_U_STRING = "Flurst\u00fcck (wird vereinigt)";
    private static final String FST_O_STRING = "Flurst\u00fcck";
    private static final String FST_M_TST_STRING = "Flurst\u00fcck mit Teilst\u00fccken";
    private static final String FST_M_NST_STRING = "Flurst\u00fcck mit Nutzungen";
    private static final String TST_O_STRING = "Teilst\u00fcck";
    private static final String TST_M_NST_STRING = "Teilst\u00fcck mit Nutzungen";
    private static final String NST_O_STRING = "Nutzung";
    private static final Hashtable ARTEN = new Hashtable();

    public static String getArtString(int n) {
        return (String)ARTEN.get(new Integer(n));
    }

    public static int getArt(String string) {
        if (string != null) {
            Enumeration enumeration = ARTEN.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (!string.equals((String)ARTEN.get(n))) continue;
                return n;
            }
        }
        return -1;
    }

    public static Enumeration arten() {
        return ARTEN.keys();
    }

    public static Enumeration artenStrings() {
        return ARTEN.elements();
    }

    public static boolean isFortfuehrung(int n) {
        return FlurstueckArt.getFortf(n) != 0;
    }

    public static boolean isStammstueck(int n) {
        return FlurstueckArt.isFlurstueck(n) && !FlurstueckArt.isUntergang(n) || FlurstueckArt.isVereinigungstueck(n);
    }

    public static boolean isStammTeilstueck(int n) {
        return FlurstueckArt.isTeilstueck(n) && FlurstueckArt.getTeil(n) == 9;
    }

    public static boolean isUntergang(int n) {
        return FlurstueckArt.getFortf(n) == 9;
    }

    public static boolean isTeilbar(int n) {
        return FlurstueckArt.getTeil(n) > 0;
    }

    public static boolean isGemarkung(int n) {
        return FlurstueckArt.getArt(n) == 2;
    }

    public static boolean isFlur(int n) {
        return FlurstueckArt.getArt(n) == 3;
    }

    public static boolean isAbstractFlurstueck(int n) {
        return FlurstueckArt.getArt(n) > 3;
    }

    public static boolean isVereinigungstueck(int n) {
        return FlurstueckArt.getArt(n) == 6;
    }

    public static boolean isFlurstueck(int n) {
        return FlurstueckArt.getArt(n) == 7;
    }

    public static boolean isTeilstueck(int n) {
        return FlurstueckArt.getArt(n) == 8;
    }

    public static boolean isNutzung(int n) {
        return FlurstueckArt.getArt(n) == 9;
    }

    public static final int getArt(int n) {
        return n / 100;
    }

    public static final int getTeil(int n) {
        return n / 10 % 10;
    }

    public static final int getFortf(int n) {
        return n % 10;
    }

    public static final int setFortf(int n, int n2) {
        return FlurstueckArt.getArt(FlurstueckArt.getArt(n), FlurstueckArt.getTeil(n), n2);
    }

    public static final int getArt(int n, int n2, int n3) {
        return n * 100 + n2 * 10 + n3;
    }

    public static final String getArtName(int n) {
        switch (FlurstueckArt.getArt(n)) {
            case 1: {
                return "Gemeinde";
            }
            case 2: {
                return GMK_STRING;
            }
            case 3: {
                return FLR_STRING;
            }
            case 6: {
                return VST_O_STRING;
            }
            case 7: {
                return FST_O_STRING;
            }
            case 8: {
                return TST_O_STRING;
            }
            case 9: {
                return "Nutzungsart";
            }
        }
        return "Katasterobjekt";
    }

    static {
        ARTEN.put(new Integer(0), OHNE_STRING);
        ARTEN.put(new Integer(200), GMK_STRING);
        ARTEN.put(new Integer(300), FLR_STRING);
        ARTEN.put(new Integer(601), VST_O_STRING);
        ARTEN.put(new Integer(681), VST_M_TST_STRING);
        ARTEN.put(new Integer(691), VST_M_NST_STRING);
        ARTEN.put(new Integer(700), FST_STRING);
        ARTEN.put(new Integer(709), FST_U_STRING);
        ARTEN.put(new Integer(701), FST_O_STRING);
        ARTEN.put(new Integer(781), FST_M_TST_STRING);
        ARTEN.put(new Integer(791), FST_M_NST_STRING);
        ARTEN.put(new Integer(801), TST_O_STRING);
        ARTEN.put(new Integer(891), TST_M_NST_STRING);
        ARTEN.put(new Integer(901), NST_O_STRING);
    }
}

