/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.FlurInfoDialog;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Lage;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.NutzungsArt;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kafplot.io.FortfuehrungIOProperties;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class FlurstueckInfoDialog
extends ObjectInfoDialog
implements ITableListener,
DataBaseListener,
ActionListener {
    protected static final String GMD_COMMAND = "_Gemeinde";
    protected static final String GMK_COMMAND = "_Gemarkung";
    protected static final String FLR_COMMAND = "_Flur";
    protected static final String GBN_COMMAND = "_Grundbuch";
    private Label gmdLabel;
    private Label gmkLabel;
    private Label flurLabel;
    private Label gbnrLabel;
    private Button gmdButton;
    private Button gmkButton;
    private Button flurButton;
    private Button gbnrButton;
    FlurInfoDialog flurInfoDialog = null;
    long time = 0L;

    public FlurstueckInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Flurstueck)null);
    }

    public FlurstueckInfoDialog(IFrame iFrame, String string, Flurstueck flurstueck) {
        super(iFrame, string, flurstueck);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        this.gmdButton = new Button("...");
        iPanel.add(this.gmdButton);
        this.gmdButton.setActionCommand(GMD_COMMAND);
        this.gmdButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.gmdButton, gridBagConstraints);
        Label label = new Label("Gemeinde: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmdLabel = new Label("", 0);
        iPanel.add(this.gmdLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.gmdLabel, gridBagConstraints);
        this.gmkButton = new Button("...");
        iPanel.add(this.gmkButton);
        this.gmkButton.setActionCommand(GMK_COMMAND);
        this.gmkButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.gmkButton, gridBagConstraints);
        label = new Label("Gemarkung: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmkLabel = new Label("", 0);
        iPanel.add(this.gmkLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.gmkLabel, gridBagConstraints);
        this.flurButton = new Button("...");
        iPanel.add(this.flurButton);
        this.flurButton.setActionCommand(FLR_COMMAND);
        this.flurButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.flurButton, gridBagConstraints);
        label = new Label("Flur: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.flurLabel = new Label("", 0);
        iPanel.add(this.flurLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.flurLabel, gridBagConstraints);
        this.gbnrButton = new Button("...");
        iPanel.add(this.gbnrButton);
        this.gbnrButton.setActionCommand(GBN_COMMAND);
        this.gbnrButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.gbnrButton, gridBagConstraints);
        label = new Label("Buchung: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gbnrLabel = new Label("", 0);
        iPanel.add(this.gbnrLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.gbnrLabel, gridBagConstraints);
        label = new Label("Pr\u00fcfz./Akt.: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(12);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Nummer", 0), new ITableCell("Nutzung", 0), new ITableCell("Buchfl\u00e4che", 0), new ITableCell("berechnete\nKoordinaten-\nFl\u00e4che", 0), new ITableCell("endg\u00fcltige\nberechnete\nFl\u00e4che", 0), new ITableCell("endg\u00fcltige\ngerundete\nFl\u00e4che", 0), new ITableCell("Lagebezeichnung", 0), new ITableCell("Str.-Schl\u00fcssel", 0), new ITableCell("Klassifizierung", 0), new ITableCell("Berechnung", 0), new ITableCell("Vorgabenummer", 0), new ITableCell("Oska     ", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        this.table.removeLines();
        Flurstueck flurstueck2 = null;
        if (flurstueck != null) {
            Vector vector = DataBase.FLST.getFlurstueckeFrom(flurstueck);
            flurstueck2 = DataBase.FLST.getStammstueck(flurstueck);
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                Flurstueck flurstueck3 = (Flurstueck)vector.elementAt(i);
                this.addObjectToTable(flurstueck3);
            }
            this.table.select(object);
        }
        this.object = object;
        this.table.doLayout();
        this.table.requestFocus();
        super.setObject(object);
        this.showObject(flurstueck2 != null ? flurstueck2 : flurstueck);
    }

    public void setObjects(Enumeration enumeration) {
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            this.addObjectToTable(enumeration.nextElement());
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        if (flurstueck == null) {
            this.gmdLabel.setText("");
            this.gmkLabel.setText("");
            this.flurLabel.setText("");
            this.gbnrLabel.setText("");
        } else {
            Object object2;
            Flurstueck flurstueck2 = DataBase.FLST.getStammstueck(flurstueck);
            if (flurstueck2 != null) {
                flurstueck = flurstueck2;
            }
            Object object3 = null;
            Gemarkung gemarkung = Gemarkung.getGemarkung(flurstueck.getGemarkung());
            if (gemarkung != null && (object2 = gemarkung.getGemeinde()) != null) {
                object3 = "(" + IFormat.i08.format(((Gemeinde)object2).getNummer()) + ") " + ((Gemeinde)object2).getName();
            }
            this.gmdLabel.setText((String)(object3 != null ? object3 : ""));
            object3 = gemarkung != null ? "(" + IFormat.i06.format(gemarkung.getNummer()) + ") " + gemarkung.getName() : "(" + IFormat.i06.format(flurstueck.getGemarkung()) + ") ";
            this.gmkLabel.setText((String)(object3 != null ? object3 : ""));
            this.flurLabel.setText(flurstueck.getFlurAsString());
            object2 = flurstueck.getBuchungenAsString();
            this.gbnrLabel.setText((String)object2);
            this.gmdButton.setEnabled(gemarkung != null && gemarkung.getGemeinde() != null);
            this.gmkButton.setEnabled(gemarkung != null);
            this.flurButton.setEnabled(this.getFlur(object) != null);
            this.gbnrButton.setEnabled(flurstueck.hasBuchung());
        }
    }

    protected void addObjectToTable(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        ITableCell[] iTableCellArray = new ITableCell[12];
        iTableCellArray[0] = flurstueck.isGemarkung() || flurstueck.isFlur() ? new ITableCell(flurstueck.getNummer(), 0) : (flurstueck.isStammstueck() ? new ITableCell(flurstueck.getNummer(), 0) : (flurstueck.isVereinigungTeilstueck() ? new ITableCell("(" + flurstueck.getNummer() + ")", 0) : (flurstueck.isTeilstueck() ? new ITableCell(flurstueck.getTeilAsString(), 0) : (flurstueck.isFlurstueck() ? new ITableCell(flurstueck.getNummer(), 0) : new ITableCell("", 0)))));
        NutzungsArt nutzungsArt = NutzungsArt.getNutzungsArt(flurstueck.getNutzung());
        iTableCellArray[1] = new ITableCell(flurstueck.getNutzungAsString(), nutzungsArt != null ? nutzungsArt.getAbkuerzung() : null, 0);
        iTableCellArray[2] = new ITableCell(flurstueck.getBuchFlaecheAsString(), 10);
        iTableCellArray[3] = new ITableCell(flurstueck.getGeoFlaecheAsDoubleString(), 10);
        iTableCellArray[4] = new ITableCell(flurstueck.getAktFlaecheAsDoubleString(), 10);
        iTableCellArray[5] = new ITableCell(flurstueck.getRoundedFlaecheAsString(), 10);
        iTableCellArray[6] = new ITableCell(flurstueck.getLageBezeichnungAsString(), 0);
        iTableCellArray[7] = new ITableCell(flurstueck.getStrasseAsString(), 0);
        iTableCellArray[8] = new ITableCell(flurstueck.getKlasseAsString(), 0);
        iTableCellArray[9] = new ITableCell(flurstueck.getBerechnungsArtAsString(), 0);
        iTableCellArray[10] = new ITableCell(flurstueck.getVorgabeNummerAsString(), 0);
        iTableCellArray[1].setEventable(true);
        iTableCellArray[7].setEventable(true);
        StringBuffer stringBuffer = new StringBuffer();
        if (flurstueck.getFolie() > 0) {
            stringBuffer.append(IFormat.i03.format(flurstueck.getFolie()));
            stringBuffer.append(".");
        }
        if (flurstueck.getOska() > 0) {
            stringBuffer.append(IFormat.i04.format(flurstueck.getOska()));
        }
        iTableCellArray[11] = new ITableCell(stringBuffer.toString(), 10);
        this.table.addLine(new ITableLine(iTableCellArray, object));
        if (flurstueck.isFlurstueck() || flurstueck.isTeilstueck()) {
            double d = flurstueck.getGeoFlaeche();
            Enumeration enumeration = flurstueck.intersectObjects(DataBase.NUTZ.elements()).elements();
            while (enumeration.hasMoreElements()) {
                Nutzung nutzung = (Nutzung)enumeration.nextElement();
                nutzungsArt = NutzungsArt.getNutzungsArt(nutzung.getArt());
                double d2 = nutzung.getPolygonFlaeche() * DataBase.getFlaecheMasstab(nutzung.y);
                iTableCellArray = new ITableCell[]{new ITableCell("", 0), new ITableCell(Integer.toString(nutzung.getArt()), nutzungsArt != null ? nutzungsArt.getAbkuerzung() : null, 0), new ITableCell("", 0), new ITableCell(IFormat.f_2.format(d2), 10), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0), new ITableCell("", 0)};
                ITableLine iTableLine = new ITableLine(iTableCellArray, nutzung);
                if (d2 < FortfuehrungIOProperties.INTERSECT_MIN_ABS && d2 * 100.0 / d < FortfuehrungIOProperties.INTERSECT_MIN_PERC) {
                    iTableLine.setForeground(Color.red);
                }
                this.table.addLine(iTableLine);
            }
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        if (iTableEvent.getID() == 2001) {
            if (System.currentTimeMillis() - this.time < 100L) {
                return;
            }
            this.time = System.currentTimeMillis();
            if (iTableEvent.getCol() == 1) {
                this.table.switchAlternate(1);
                this.table.repaint();
            }
        } else {
            Object object = iTableEvent.getContent();
            if (object instanceof Flurstueck) {
                Flurstueck flurstueck = (Flurstueck)object;
                this.object = flurstueck;
                this.showObject(flurstueck);
                if (iTableEvent.getClickCount() > 1) {
                    if (iTableEvent.getCol() == 1 && this.elementListener != null) {
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), new NutzungsArt(flurstueck.getNutzung()), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    } else if (iTableEvent.getCol() == 7 && this.elementListener != null) {
                        Gemarkung gemarkung = Gemarkung.getGemarkung(flurstueck.getGemarkung());
                        Lage lage = (Lage)flurstueck.getLage();
                        Gemeinde gemeinde = gemarkung != null ? gemarkung.getGemeinde() : null;
                        Strasse strasse = gemeinde != null && IFormat.hasNumbers(flurstueck.getStrasseAsString()) ? gemeinde.getStrasse(flurstueck.getStrasseAsString()) : null;
                        Strasse strasse2 = strasse != null ? strasse : new Strasse();
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), strasse2, iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    } else if (this.actionListener != null && this.actionCommand != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                }
            } else if (object instanceof Nutzung) {
                Nutzung nutzung = (Nutzung)object;
                if (iTableEvent.getClickCount() > 1) {
                    if (iTableEvent.getCol() == 1 && this.elementListener != null) {
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), new NutzungsArt(nutzung.getArt()), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    } else if (this.actionListener != null && this.actionCommand != null) {
                        this.object = object;
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(GMD_COMMAND)) {
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), this.getGemeinde(this.getObject()), actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else if (string.equals(GMK_COMMAND)) {
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), this.getGemarkung(this.getObject()), actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else if (string.equals(FLR_COMMAND)) {
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), this.getFlur(this.getObject()), actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else if (string.equals(GBN_COMMAND)) {
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), this.getBuchung(this.getObject()), actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected Flurstueck getFlur(Object object) {
        if (DataBase.model.getModel() == 2) {
            return null;
        }
        Flurstueck flurstueck = (Flurstueck)object;
        Enumeration enumeration = DataBase.FLST.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (flurstueck2.getGemarkung() != flurstueck.getGemarkung() || flurstueck2.getFlur() != flurstueck.getFlur() || !flurstueck2.isFlur()) continue;
            return flurstueck2;
        }
        return null;
    }

    protected Buchungsstelle getBuchung(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        Flurstueck flurstueck2 = DataBase.FLST.getStammstueck(flurstueck);
        if (flurstueck2 != null) {
            return flurstueck2.getBuchung();
        }
        return null;
    }

    protected Gemeinde getGemeinde(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        Gemarkung gemarkung = Gemarkung.getGemarkung(flurstueck.getGemarkung());
        return gemarkung != null ? gemarkung.getGemeinde() : null;
    }

    protected Gemarkung getGemarkung(Object object) {
        Flurstueck flurstueck = (Flurstueck)object;
        return Gemarkung.getGemarkung(flurstueck.getGemarkung());
    }
}

