/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geodata.Feature;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.text.IFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FlurstueckTable
extends DataContainerTable {
    private int countVoidFlst = 0;
    private int lastVereinigungNr = 0;

    public FlurstueckTable() {
        this.reset();
    }

    public void reset() {
        this.countVoidFlst = 0;
    }

    public int getLastVereinigungNr() {
        return this.lastVereinigungNr;
    }

    @Override
    public Vector getFeatureParts(Feature feature) {
        return this.getTeileFrom((Flurstueck)feature);
    }

    @Override
    public void put(Feature feature) throws GeomException {
        int n;
        Flurstueck flurstueck = (Flurstueck)feature;
        if (flurstueck.isVoid() && flurstueck.getCount() == 0) {
            flurstueck.setCount(++this.countVoidFlst);
        }
        if (flurstueck.isVereinigungStammstueck()) {
            n = flurstueck.getVereinigungNr();
            this.lastVereinigungNr = Math.max(this.lastVereinigungNr, n);
        }
        for (n = this.size() - 1; n >= 0; --n) {
            Flurstueck flurstueck2 = (Flurstueck)this.elementAt(n);
            int n2 = flurstueck2.compareTo(flurstueck);
            if (n2 < 0) {
                super.insertElementAt(flurstueck, n + 1);
                return;
            }
            if (n2 != 0) continue;
            if (flurstueck.isNutzstueck()) {
                flurstueck.setCount(flurstueck2.getCount() + 1);
                continue;
            }
            throw new GeomException(new DPoint(flurstueck.y, flurstueck.x), flurstueck.getPolygon(), "Flurst\u00fcck: " + flurstueck.toMiniStringWithNutzung() + " ist doppelt vergeben" + flurstueck.getArt());
        }
        super.insertElementAt(flurstueck, 0);
    }

    public void addElement(Feature feature) {
        Flurstueck flurstueck = (Flurstueck)feature;
        if (flurstueck.isVoid() && flurstueck.getCount() == 0) {
            flurstueck.setCount(++this.countVoidFlst);
        }
        super.addElement(flurstueck);
    }

    @Override
    public Feature get(Feature feature) {
        Flurstueck flurstueck = (Flurstueck)feature;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            int n = flurstueck2.compareTo(flurstueck);
            if (!flurstueck2.equals(flurstueck.getGemarkung(), flurstueck.getFlur(), flurstueck.getZaehler(), flurstueck.getNenner())) continue;
            return flurstueck2;
        }
        return null;
    }

    public int getFaelle() {
        return this.countStammstuecke();
    }

    public int countStammstuecke() {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck()) continue;
            ++n;
        }
        return n;
    }

    public int countStammstuecke(int n, int n2) {
        int n3 = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck() || flurstueck.getGemarkung() != n || flurstueck.getFlur() != n2) continue;
            ++n3;
        }
        return n3;
    }

    public Flurstueck getFlurstueck(Flurstueck flurstueck) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getGemarkung() != flurstueck2.getGemarkung() || flurstueck.getFlur() != flurstueck2.getFlur() || flurstueck.getZaehler() != flurstueck2.getZaehler() || flurstueck.getNenner() != flurstueck2.getNenner()) continue;
            return flurstueck2;
        }
        return null;
    }

    public Flurstueck getStammstueck(Flurstueck flurstueck) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isStammstueckFrom(flurstueck)) continue;
            return flurstueck2;
        }
        return null;
    }

    public Flurstueck getStammTeilstueck(Flurstueck flurstueck) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isStammTeilstueckFrom(flurstueck)) continue;
            return flurstueck2;
        }
        return null;
    }

    public boolean hasFluren() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isFlur()) continue;
            return true;
        }
        return false;
    }

    public Vector getFluren() {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isFlur()) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public boolean hasGemarkungen() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isGemarkung()) continue;
            return true;
        }
        return false;
    }

    public Vector getGemarkungen() {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isGemarkung()) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public Vector getFlurenFrom(int n) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isFlur() || flurstueck.getGemarkung() != n) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public Vector getFlurstueckeFromBlatt(String string) {
        Vector vector = new Vector();
        return vector;
    }

    public Vector getFlurstueckeFrom(int n, int n2) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getGemarkung() != n || flurstueck.getFlur() != n2) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public Vector getStammstueckeFrom(int n, int n2) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck() || flurstueck.getGemarkung() != n || flurstueck.getFlur() != n2) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public Vector getStammstuecke() {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammstueck()) continue;
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public Flurstueck getStammstueckFrom(Flurstueck flurstueck) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isStammstueckFrom(flurstueck)) continue;
            return flurstueck2;
        }
        return null;
    }

    public Vector getTeilstueckeFrom(Flurstueck flurstueck) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        if (!flurstueck.hasTeile()) {
            return vector;
        }
        int n = this.getIndexOf(flurstueck);
        if (n >= 0) {
            ++n;
            while (n < this.size()) {
                Flurstueck flurstueck2 = (Flurstueck)this.elementAt(n);
                if (flurstueck2.getZaehler() > flurstueck.getZaehler()) {
                    return vector;
                }
                if (flurstueck.isStammstueck()) {
                    if (flurstueck2.isTeilstueckFrom(flurstueck) || flurstueck2.isNutzstueckFrom(flurstueck)) {
                        vector.addElement(flurstueck2);
                    }
                } else if (flurstueck.isStammTeilstueck()) {
                    if (flurstueck2.isNutzstueckFrom(flurstueck)) {
                        vector.addElement(flurstueck2);
                    }
                } else if (flurstueck2.isTeilstueckFrom(flurstueck) || flurstueck2.isNutzstueckFrom(flurstueck)) {
                    vector.addElement(flurstueck2);
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getTeileFrom(Flurstueck flurstueck) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        int n = this.getIndexOf(flurstueck);
        if (n >= 0) {
            ++n;
            while (n < this.size()) {
                Flurstueck flurstueck2 = (Flurstueck)this.elementAt(n);
                if (!flurstueck.equals(flurstueck2.getGemarkung(), flurstueck2.getFlur(), flurstueck2.getZaehler(), flurstueck2.getNenner())) {
                    return vector;
                }
                vector.addElement(flurstueck2);
                ++n;
            }
        }
        return vector;
    }

    public Vector getNutzstueckeFrom(Flurstueck flurstueck) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isNutzstueckFrom(flurstueck)) continue;
            vector.addElement(flurstueck2);
        }
        return vector;
    }

    public Vector getVereinigungTeilstueckeFrom(Flurstueck flurstueck) {
        Vector<Flurstueck> vector = new Vector<Flurstueck>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isVereinigungTeilstueckFrom(flurstueck)) continue;
            vector.addElement(flurstueck2);
        }
        return vector;
    }

    public Vector getFlurstueckeFrom(Flurstueck flurstueck) {
        Vector vector = new Vector();
        Flurstueck flurstueck2 = this.getStammstueck(flurstueck);
        if (flurstueck2 != null) {
            Object object;
            if (flurstueck2.isVereinigungStammstueck()) {
                object = this.getVereinigungTeilstueckeFrom(flurstueck2).elements();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
            }
            vector.addElement(flurstueck2);
            object = this.getTeilstueckeFrom(flurstueck2);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Flurstueck flurstueck3 = (Flurstueck)((Vector)object).elementAt(i);
                vector.addElement(flurstueck3);
                if (!flurstueck3.isStammTeilstueck()) continue;
                Vector vector2 = this.getNutzstueckeFrom(flurstueck3);
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.addElement(vector2.elementAt(j));
                }
            }
        } else {
            vector.addElement(flurstueck);
        }
        return vector;
    }

    public int countFluren() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getFlur() == -1 || flurstueck.getGemarkung() == n3 && flurstueck.getFlur() == n2) continue;
            n3 = flurstueck.getGemarkung();
            n2 = flurstueck.getFlur();
            ++n;
        }
        return n;
    }

    public int countFortfuehrungFluren() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getFlur() == -1 || !flurstueck.isFortfuehrung() || flurstueck.getGemarkung() == n3 && flurstueck.getFlur() == n2) continue;
            n3 = flurstueck.getGemarkung();
            n2 = flurstueck.getFlur();
            ++n;
        }
        return n;
    }

    public int countFaelle(int n, int n2) {
        int n3 = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getFlur() == -1 || !flurstueck.isFortfuehrung() || !flurstueck.isStammstueck() || flurstueck.getGemarkung() != n || flurstueck.getFlur() != n2) continue;
            ++n3;
        }
        return n3;
    }

    public int countNutzstuecke(Flurstueck flurstueck) {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck.isStammTeilstueckFrom(flurstueck2)) continue;
            ++n;
        }
        return n;
    }

    public int countTeilstuecke(Flurstueck flurstueck) {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            if (!flurstueck2.isTeilstueck() || !flurstueck.isStammstueckFrom(flurstueck2)) continue;
            ++n;
        }
        return n;
    }

    public int getIndexOf(Flurstueck flurstueck) {
        Flurstueck flurstueck2;
        int n = 0;
        int n2 = this.size() - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            flurstueck2 = (Flurstueck)this.elementAt(n3);
            int n4 = flurstueck2.compareTo(flurstueck);
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        flurstueck2 = (Flurstueck)this.elementAt(n);
        return flurstueck2.compareTo(flurstueck) == 0 ? n : -1;
    }

    public Vector getGemarkungKeys() {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            if (flurstueck.getGemarkung() <= n) continue;
            vector.addElement(new Integer(flurstueck.getGemarkung()));
            n = flurstueck.getGemarkung();
        }
        return vector;
    }

    @Override
    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
            this.writeFlurstueck(printWriter, flurstueck);
        }
    }

    public void writeFlurstueck(PrintWriter printWriter, Flurstueck flurstueck) throws IOException {
        int n = flurstueck.getArt();
        switch (FlurstueckArt.getArt(n)) {
            case 8: 
            case 9: {
                break;
            }
            default: {
                if (KafkaIOProperties.writeMenge && !KafkaIOProperties.getMenge().intersect(flurstueck.getPunkte(), KafkaIOProperties.writeFullMengeObjects ? PunktTable.INTERSECT_ALL : PunktTable.INTERSECT_ONE)) break;
                flurstueck.writeDatContainer(printWriter);
                break;
            }
            case 6: {
                if (KafkaIOProperties.changeKat) break;
                this.writeFlst(printWriter, flurstueck);
                break;
            }
            case 7: {
                Enumeration enumeration;
                if (KafkaIOProperties.writeMenge) {
                    PunktTable punktTable = new PunktTable();
                    enumeration = this.getFlurstueckeFrom(flurstueck).elements();
                    while (enumeration.hasMoreElements()) {
                        punktTable.insert(((Flurstueck)enumeration.nextElement()).getPunkte());
                    }
                    if (!KafkaIOProperties.getMenge().intersect(punktTable, KafkaIOProperties.writeFullMengeObjects ? PunktTable.INTERSECT_ALL : PunktTable.INTERSECT_ONE)) {
                        return;
                    }
                }
                if (FlurstueckArt.getTeil(n) == 8 && KafkaIOProperties.changeKat) {
                    Flurstueck flurstueck2;
                    boolean bl = true;
                    enumeration = this.getTeilstueckeFrom(flurstueck).elements();
                    while (enumeration.hasMoreElements() && (bl = (flurstueck2 = (Flurstueck)enumeration.nextElement()).getVorgabeNummer() != null)) {
                    }
                    if (bl) {
                        enumeration = this.getTeilstueckeFrom(flurstueck).elements();
                        while (enumeration.hasMoreElements()) {
                            this.writeKatStst(printWriter, (Flurstueck)enumeration.nextElement());
                        }
                        break;
                    }
                    this.writeKatStst(printWriter, flurstueck);
                    break;
                }
                this.writeKatStst(printWriter, flurstueck);
            }
        }
    }

    private void writeKatStst(PrintWriter printWriter, Flurstueck flurstueck) throws IOException {
        Object object;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (KafkaIOProperties.changeKat && flurstueck.hasVorgabeNummer()) {
            bl = true;
            object = new StringTokenizer(flurstueck.getVorgabeNummer(), ".:;-/\\");
            n = Integer.parseInt(IFormat.getDigits(((StringTokenizer)object).nextToken()));
            if (((StringTokenizer)object).hasMoreTokens()) {
                n2 = Integer.parseInt(IFormat.getDigits(((StringTokenizer)object).nextToken()));
            }
        }
        if (bl) {
            object = null;
            try {
                object = (Flurstueck)flurstueck.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            ((Flurstueck)object).setNenner(n2);
            ((Flurstueck)object).setZaehler(n);
            ((Flurstueck)object).setVorgabeNummer(null);
            if (FlurstueckArt.getArt(flurstueck.getArt()) == 8) {
                ((Flurstueck)object).setArt(FlurstueckArt.getArt(7, FlurstueckArt.isTeilbar(flurstueck.getArt()) ? 9 : 0, FlurstueckArt.isFortfuehrung(flurstueck.getArt()) ? 1 : 0));
                ((Flurstueck)object).setAktualitaet(-1);
                ((Flurstueck)object).setPruefzeichen(-1);
                ((Flurstueck)object).setTeil(0);
            }
            ((Flurstueck)object).writeDatContainer(printWriter);
        } else {
            flurstueck.writeDatContainer(printWriter);
        }
        object = this.getTeilstueckeFrom(flurstueck).elements();
        while (object.hasMoreElements()) {
            Object object2;
            Flurstueck flurstueck2 = (Flurstueck)object.nextElement();
            if (bl) {
                object2 = null;
                try {
                    object2 = (Flurstueck)flurstueck2.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ((Flurstueck)object2).setNenner(n2);
                ((Flurstueck)object2).setZaehler(n);
                ((Flurstueck)object2).setTeil(0);
                ((Flurstueck)object2).writeDatContainer(printWriter);
            } else {
                flurstueck2.writeDatContainer(printWriter);
            }
            if (!flurstueck2.hasTeile()) continue;
            object2 = this.getNutzstueckeFrom(flurstueck2).elements();
            while (object2.hasMoreElements()) {
                Flurstueck flurstueck3 = (Flurstueck)object2.nextElement();
                if (bl) {
                    Flurstueck flurstueck4 = null;
                    try {
                        flurstueck4 = (Flurstueck)flurstueck3.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                    flurstueck4.setNenner(n2);
                    flurstueck4.setZaehler(n);
                    flurstueck4.setTeil(0);
                    flurstueck4.writeDatContainer(printWriter);
                    continue;
                }
                flurstueck3.writeDatContainer(printWriter);
            }
        }
    }

    private void writeFlst(PrintWriter printWriter, Flurstueck flurstueck) throws IOException {
        flurstueck.writeDatContainer(printWriter);
        Enumeration enumeration = this.getTeilstueckeFrom(flurstueck).elements();
        while (enumeration.hasMoreElements()) {
            Flurstueck flurstueck2 = (Flurstueck)enumeration.nextElement();
            flurstueck2.writeDatContainer(printWriter);
        }
    }
}

