/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ClearPolygon;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geodata.Feature;
import de.geocalc.geom.DArc;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatContainer;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KatasterElement;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.lang.Exceptionable;
import de.geocalc.util.CountTable;
import de.geocalc.util.ListAttribute;
import de.geocalc.util.ListAttributeEnumerator;
import de.geocalc.util.VoidEnumerator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class GObject
extends DataContainer
implements Exceptionable,
Drawable,
DatContainer,
DatObject,
Feature {
    public static final int DEFINITIONS_GEOM = 1;
    public static final int AUSGESTALTUNG_GEOM = 2;
    public static final int BOTH_GEOM = 3;
    public static final int NO_AREA = 0;
    public static final int RIGHT_AREA = 1;
    public static final int LEFT_AREA = 2;
    private int areaTyp = 0;
    private float textAngle;
    protected int flags = 0;
    protected ListAttribute att;
    private ObjectDecor decor;
    private static final int FLAG_AUTO_GEOM = 1;
    private static final int FLAG_LOCATION_READ = 2;
    private static final int FLAG_DEBUG_MARKER = 512;
    private static final int FLAG_FORTFUEHRUNG = 1024;
    private static final int FLAG_FLAECHE_READ = 2048;
    private static final int FLAG_UNTERGANG = 4096;
    private static final int FLAG_FF_NEIGHBOR = 8192;
    private static final int FLAG_TEMP1 = 0x40000000;
    private static final int FLAG_TEMP2 = Integer.MIN_VALUE;
    private static final double STANDARD_SAGITTA = 0.01;
    private static final double ZENO_SAGITTA = 0.05;
    private static final AffineTransform NULL_TRANSFORM = new AffineTransform();

    @Override
    public Object clone() throws CloneNotSupportedException {
        GObject gObject = (GObject)super.clone();
        return gObject;
    }

    public abstract LinieParameter getLineDefaults();

    public boolean hasDecor() {
        return this.decor != null;
    }

    public void addDecor(ObjectDecor objectDecor) {
        if (this.decor == null) {
            this.decor = objectDecor;
        } else {
            ObjectDecor objectDecor2 = this.decor;
            while (objectDecor2.hasNext()) {
                objectDecor2 = objectDecor2.getNext();
            }
            objectDecor2.setNext(objectDecor);
        }
    }

    public ObjectDecor decorAt(int n) {
        ObjectDecor objectDecor = this.decor;
        for (int i = 0; i < n; ++i) {
            if (objectDecor == null) continue;
            objectDecor = objectDecor.getNext();
        }
        return objectDecor;
    }

    public Enumeration decors() {
        if (this.decor == null) {
            return new VoidEnumerator();
        }
        return this.decor.elements();
    }

    public void setAutoGeom(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isAutoGeom() {
        return (this.flags & 1) != 0;
    }

    public void setFlaecheRead(boolean bl) {
        this.flags = bl ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public boolean isFlaecheRead() {
        return (this.flags & 0x800) != 0;
    }

    public void setDebugMarker(boolean bl) {
        this.flags = bl ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean isDebugMarker() {
        return (this.flags & 0x200) != 0;
    }

    private void setLocationRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    private boolean isLocationRead() {
        return (this.flags & 2) != 0;
    }

    public void setFortfuehrung(boolean bl) {
        this.flags = bl ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isFortfuehrung() {
        return (this.flags & 0x400) != 0;
    }

    public void setUntergang(boolean bl) {
        this.flags = bl ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    public boolean isUntergang() {
        return (this.flags & 0x1000) != 0;
    }

    public void setFFNeighbor(boolean bl) {
        this.flags = bl ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    public boolean isFFNeighbor() {
        return (this.flags & 0x2000) != 0;
    }

    public void setTempFlag1(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40000000) : (this.flags &= 0xBFFFFFFF);
    }

    public boolean isTempFlag1() {
        return (this.flags & 0x40000000) != 0;
    }

    public void setTempFlag2(boolean bl) {
        this.flags = bl ? (this.flags |= Integer.MIN_VALUE) : (this.flags &= Integer.MAX_VALUE);
    }

    public boolean isTempFlag2() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void initGeom() {
        Object object;
        this.computeAreaTyp();
        this.computeBounds();
        if (!this.hasLocation()) {
            object = this.getMitte();
            this.y = ((DPoint)object).y;
            this.x = ((DPoint)object).x;
        }
        if (!this.hasLocation()) {
            object = this.getBounds();
            this.y = ((DRectangle)object).y + ((DRectangle)object).width / 2.0;
            this.x = ((DRectangle)object).x + ((DRectangle)object).height / 2.0;
        }
        if (!this.isVoid() && (object = this.getNearestDefLinie(this.getHashPoint())) != null) {
            double d = ((Linie)object).getRichtung();
            if (d < 0.0) {
                d += Math.PI;
            } else if (d > Math.PI) {
                d -= Math.PI;
            }
            this.setTextAngle(d);
        }
    }

    protected void computeAreaTyp() {
        double d = this.getPolygonFlaeche();
        this.areaTyp = d > 0.0 ? 1 : (d < 0.0 ? 2 : 0);
    }

    public int getAreaType() {
        return this.areaTyp;
    }

    @Override
    public int getId() {
        return 0;
    }

    public boolean contains(double d, double d2) {
        DPolygon dPolygon;
        if (this.getBounds().contains(d, d2) && (dPolygon = this.getPolygon()) != null) {
            return dPolygon.contains(d, d2);
        }
        return false;
    }

    public boolean containsVertex(double d, double d2) {
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (d == linie.pa.y && d2 == linie.pa.x) {
                return true;
            }
            if (linie.pe == null || d != linie.pe.y || d2 != linie.pe.x) continue;
            return true;
        }
        return false;
    }

    public boolean containsVertexPunkt(Punkt punkt) {
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (linie.pa.equals(punkt)) {
                return true;
            }
            if (linie.pe == null || !linie.pe.equals(punkt)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsRect(GObject gObject) {
        return this.getBounds().intersects(gObject.getBounds());
    }

    public boolean intersectsRect(DRectangle dRectangle) {
        return this.getBounds().intersects(dRectangle);
    }

    public boolean intersects(GObject gObject) {
        if (this.getBounds().intersects(gObject.getBounds())) {
            Linie linie;
            int n;
            PunktTable punktTable;
            DPolygon dPolygon = this.getPolygon();
            if (dPolygon != null) {
                punktTable = this.getPunkte();
                for (n = 0; n < gObject.size(); ++n) {
                    linie = (Linie)gObject.elementAt(n);
                    if (!punktTable.contains(linie.pa) && dPolygon.contains(linie.pa)) {
                        return true;
                    }
                    if (!linie.isLinie() || punktTable.contains(linie.pe) || !dPolygon.contains(linie.pe)) continue;
                    return true;
                }
            }
            if ((dPolygon = gObject.getPolygon()) != null) {
                punktTable = gObject.getPunkte();
                for (n = 0; n < this.size(); ++n) {
                    linie = (Linie)this.elementAt(n);
                    if (!punktTable.contains(linie.pa) && dPolygon.contains(linie.pa)) {
                        return true;
                    }
                    if (!linie.isLinie() || punktTable.contains(linie.pe) || !dPolygon.contains(linie.pe)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isNeighbor(GObject gObject) {
        if (this.getBounds().intersects(gObject.getBounds())) {
            Linie linie;
            Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>();
            Enumeration enumeration = gObject.elements();
            while (enumeration.hasMoreElements()) {
                linie = (Linie)enumeration.nextElement();
                if (!linie.isStart() && !linie.isMitte()) continue;
                hashtable.put(linie, linie);
            }
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                linie = (Linie)enumeration.nextElement();
                if (!linie.isStart() && !linie.isMitte() || hashtable.get(linie) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getNeighborLines(GObject gObject) {
        Vector<Linie> vector = new Vector<Linie>();
        if (this.getBounds().intersects(gObject.getBounds())) {
            Linie linie;
            Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>();
            Enumeration enumeration = gObject.elements();
            while (enumeration.hasMoreElements()) {
                linie = (Linie)enumeration.nextElement();
                if (!linie.isStart() && !linie.isMitte()) continue;
                hashtable.put(linie, linie);
            }
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                linie = (Linie)enumeration.nextElement();
                if (!linie.isStart() && !linie.isMitte() || hashtable.get(linie) == null) continue;
                vector.addElement(linie);
            }
        }
        return vector;
    }

    public Linie getNearestNeighborLine(GObject gObject) {
        return this.getNearestNeighborLine(gObject, gObject.y != 0.0 && gObject.x != 0.0 ? new DPoint(gObject.y, gObject.x) : gObject.getMitte());
    }

    public Linie getNearestNeighborLine(GObject gObject, DPoint dPoint) {
        Linie linie = null;
        double d = Double.MAX_VALUE;
        if (this.getBounds().intersects(gObject.getBounds())) {
            Linie linie2;
            Hashtable<Linie, Linie> hashtable = new Hashtable<Linie, Linie>();
            Enumeration enumeration = gObject.elements();
            while (enumeration.hasMoreElements()) {
                linie2 = (Linie)enumeration.nextElement();
                if (!linie2.isStart() && !linie2.isMitte()) continue;
                hashtable.put(linie2, linie2);
            }
            enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                double d2;
                linie2 = (Linie)enumeration.nextElement();
                if (!linie2.isStart() && !linie2.isMitte() || hashtable.get(linie2) == null || !((d2 = DLine.ptShortestDist(linie2.pa.y, linie2.pa.x, linie2.pe.y, linie2.pe.x, dPoint.y, dPoint.x)) < d)) continue;
                d = d2;
                linie = linie2;
            }
        }
        return linie;
    }

    public abstract void deleteName();

    public void deleteArea() {
        this.areaTyp = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) {
                this.removeElement(linie);
            }
            linie.setLinie();
        }
    }

    public void deleteGeom() {
        this.areaTyp = 0;
        super.removeAllElements();
        this.decor = null;
        this.setBounds(this.y, this.x, 0.0, 0.0);
    }

    public void setTextAngle(double d) {
        this.textAngle = (float)d;
    }

    public float getTextAngle() {
        return this.textAngle;
    }

    public abstract boolean isVoid();

    public boolean isArea() {
        return this.areaTyp != 0;
    }

    public Vector getKatasterNachweisLinien() {
        return this.getKatasterNachweisLinien(null);
    }

    public abstract Vector getKatasterNachweisLinien(ExceptionList var1);

    public void copyGeom(GObject gObject, int n) {
        boolean bl = true;
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (linie.isLinie()) {
                bl = false;
            }
            if (bl) {
                if (n == 1 || n == 3) {
                    this.addElement(linie);
                }
            } else if (n == 2 || n == 3) {
                this.addElement(linie);
            }
            if (!linie.isEnde()) continue;
            bl = false;
        }
    }

    public abstract boolean defMultiArea();

    public boolean isKomplexArea() {
        if (this.size() <= 0) {
            return false;
        }
        PunktTable punktTable = new PunktTable(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (linie.isEnde() || linie.isLinie()) {
                return false;
            }
            if (punktTable.put(linie.pa) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMultiArea() throws NullPointerException {
        if (!this.isKomplexArea()) {
            return false;
        }
        Vector vector = this.getSubAreas();
        if (vector.size() < 2) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            DPolygon dPolygon = GObject.getPolygon((Vector)vector.elementAt(i));
            if (dPolygon == null) {
                return false;
            }
            for (int j = i + 1; j < vector.size(); ++j) {
                DPolygon dPolygon2 = GObject.getPolygon((Vector)vector.elementAt(j));
                if (dPolygon2 == null) {
                    return false;
                }
                int n = dPolygon.outcode(dPolygon2);
                if (n == 2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasLinie(DPoint dPoint, DPoint dPoint2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if ((linie.pa != dPoint || linie.pe != dPoint2) && (linie.pa != dPoint2 || linie.pe != dPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnker() {
        Hashtable<Object, Linie> hashtable = new Hashtable<Object, Linie>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            Linie linie2 = hashtable.put(linie.getHashKey(), linie);
            if (linie2 == null) continue;
            return true;
        }
        return false;
    }

    public Vector getSubAreas() {
        CountTable countTable = new CountTable();
        boolean bl = false;
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (linie.isEnde() || countTable.put(linie.getHashKey()) < 2) continue;
            bl = true;
            break;
        }
        Vector vector = new Vector();
        this.createSubArea(this.elements(), vector);
        return vector;
    }

    private void createSubArea(Enumeration enumeration, Vector vector) {
        Linie linie;
        Vector<Linie> vector2 = new Vector<Linie>();
        vector.addElement(vector2);
        boolean bl = false;
        Punkt punkt = null;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            linie = (Linie)((Linie)enumeration.nextElement()).clone();
            if (bl) {
                if (linie.getArt() == 0) {
                    if (bl2) continue;
                    bl2 = true;
                    this.createSubArea(enumeration, vector);
                    continue;
                }
                bl2 = false;
                vector2.addElement(linie);
                if (!linie.isEnde() && linie.pe != punkt) continue;
                break;
            }
            if (linie.getArt() == 0 || linie.isEnde()) continue;
            linie.setLs(1);
            vector2.addElement(linie);
            punkt = linie.pa;
            bl = true;
        }
        if (vector2.size() > 0 && (linie = (Linie)vector2.lastElement()) != null && !linie.isEnde()) {
            vector2.addElement(new Linie(9, linie.pe, null));
        }
    }

    public boolean hasAusgestaltung() {
        boolean bl = false;
        Punkt punkt = null;
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (linie.isStart()) {
                punkt = linie.pa;
                continue;
            }
            if (linie.isEnde()) {
                if (linie.pa != punkt) {
                    return true;
                }
                bl = true;
                continue;
            }
            if (linie.isLinie()) {
                return true;
            }
            if (!bl || this.defMultiArea()) continue;
            return true;
        }
        return false;
    }

    public double getPolygonFlaeche() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Linie linie = null;
        Linie linie2 = null;
        boolean bl = false;
        block7: for (int i = 0; i < this.size(); ++i) {
            Linie linie3 = (Linie)this.elementAt(i);
            try {
                switch (linie3.getLs()) {
                    case 1: {
                        linie2 = linie3;
                        d2 = 0.0;
                        d3 = 0.0;
                        if (!linie3.isBogen()) break;
                        d3 += linie3.getBogenFlaeche();
                        break;
                    }
                    case 0: {
                        if (linie3.isBogen()) {
                            d3 += linie3.getBogenFlaeche();
                        }
                        d2 += linie3.pa.y * (linie.pa.x - linie3.pe.x);
                        break;
                    }
                    case 9: {
                        if (linie3.pa != linie2.pa) {
                            d2 = 0.0;
                        } else {
                            d2 += linie3.pa.y * (linie.pa.x - linie2.pe.x);
                            d2 = d2 / 2.0 + d3;
                        }
                        d = d != 0.0 && (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) ? (d -= d2) : (d += d2);
                        if (this.defMultiArea()) break;
                        bl = true;
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                linie = linie3;
                if (!bl) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public DPoint getMitte() {
        if (this.areaTyp != 0) {
            return this.getPolygon().getCentroid();
        }
        DPolygon dPolygon = this.getPolyline();
        if (dPolygon != null) {
            return dPolygon.getMidPoint();
        }
        DPoint dPoint = new DPoint();
        Linie linie = null;
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            Linie linie2 = (Linie)this.elementAt(i);
            if (linie != null && linie2.pa != linie.pe) {
                dPoint.y += linie2.pa.y;
                dPoint.x += linie2.pa.x;
                ++n;
            }
            if (linie2.pe != null) {
                dPoint.y += linie2.pe.y;
                dPoint.x += linie2.pe.x;
                ++n;
            }
            linie = linie2;
        }
        if (n > 0) {
            dPoint.y /= (double)n;
            dPoint.x /= (double)n;
        }
        return dPoint;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pa != null) {
                punktTable.put(linie.pa);
            }
            if (linie.pe == null) continue;
            punktTable.put(linie.pe);
        }
        return punktTable;
    }

    public DPolygon getPolyline() throws NullPointerException {
        Object object;
        DPolygon dPolygon = new DPolygon();
        Punkt punkt = null;
        block5: for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                }
                case 0: {
                    if (linie.pa != linie.pe) {
                        dPolygon.addPoint(linie.pa);
                    }
                    if (linie.l2 == 0.0) continue block5;
                    object = GObject.getBogenPolygon(linie.pa, linie.pe, linie.l2);
                    for (int j = 0; j < ((DPolygon)object).npoints; ++j) {
                        dPolygon.addPoint(((DPolygon)object).ypoints[j], ((DPolygon)object).xpoints[j]);
                    }
                    continue block5;
                }
                case 9: {
                    dPolygon.addPoint(linie.pa);
                    return dPolygon;
                }
            }
        }
        Linie linie = null;
        for (int i = 0; i < this.size(); ++i) {
            object = (Linie)this.elementAt(i);
            if (linie == null) {
                dPolygon.addPoint(((Linie)object).pa);
                dPolygon.addPoint(((Linie)object).pe);
            } else if (((Linie)object).pa == linie.pe) {
                dPolygon.addPoint(((Linie)object).pe);
            }
            linie = object;
        }
        return dPolygon.npoints == 0 ? null : dPolygon;
    }

    public DPolygon getPolygon() throws NullPointerException {
        return this.getPolygon(0.01);
    }

    public DPolygon getPolygon(double d) throws NullPointerException {
        DPolygon dPolygon = new DPolygon();
        Punkt punkt = null;
        block5: for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                }
                case 0: {
                    if (linie.pa != linie.pe) {
                        dPolygon.addPoint(linie.pa);
                    }
                    if (linie.l2 == 0.0) continue block5;
                    DPolygon dPolygon2 = GObject.getBogenPolygon(linie.pa, linie.pe, linie.l2, d);
                    for (int j = 0; j < dPolygon2.npoints; ++j) {
                        dPolygon.addPoint(dPolygon2.ypoints[j], dPolygon2.xpoints[j]);
                    }
                    continue block5;
                }
                case 9: {
                    if (linie.pa != punkt) {
                        return null;
                    }
                    return dPolygon;
                }
            }
        }
        return null;
    }

    private static DPolygon getBogenPolygon(DPoint dPoint, DPoint dPoint2, double d) {
        return GObject.getBogenPolygon(dPoint, dPoint2, d, 0.01);
    }

    private static DPolygon getBogenPolygon(DPoint dPoint, DPoint dPoint2, double d, double d2) {
        if (dPoint == dPoint2) {
            return GObject.getKreisPolygon(dPoint, d, d2);
        }
        DPolygon dPolygon = new DPolygon(10);
        DPoint dPoint3 = DArc.getCenter(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, d);
        double d3 = DLine.getDist(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        double d4 = Math.atan2(dPoint.y - dPoint3.y, dPoint.x - dPoint3.x);
        double d5 = Math.atan2(dPoint2.y - dPoint3.y, dPoint2.x - dPoint3.x);
        double d6 = Math.abs(d) - d2;
        double d7 = Math.sqrt(d * d - d6 * d6);
        double d8 = Math.atan2(d7, d6);
        double d9 = dPoint.y;
        double d10 = dPoint.x;
        double d11 = Math.abs(d);
        if (d5 - d4 > Math.PI || d4 - d5 > Math.PI) {
            d5 = d > 0.0 ? (d5 += Math.PI * 2) : (d5 -= Math.PI * 2);
        }
        if (d < 0.0) {
            d8 = -d8;
        }
        int n = 0;
        d4 += d8;
        while (Math.abs(d4 - d5) > Math.abs(d8)) {
            double d12 = dPoint3.y + d11 * Math.sin(d4);
            double d13 = dPoint3.x + d11 * Math.cos(d4);
            dPolygon.addPoint(d12, d13);
            d4 += d8;
            if (n++ <= 1000) continue;
            break;
        }
        return dPolygon;
    }

    private static DPolygon getKreisPolygon(DPoint dPoint, double d) {
        return GObject.getKreisPolygon(dPoint, d, 0.01);
    }

    private static DPolygon getKreisPolygon(DPoint dPoint, double d, double d2) {
        d = Math.abs(d);
        DPolygon dPolygon = new DPolygon(50);
        double d3 = 2.0 * Math.acos(-d2 / d + 1.0);
        double d4 = Math.PI * 2;
        double d5 = 0.0;
        dPolygon.addPoint(dPoint.y, dPoint.x + d);
        while (true) {
            double d6;
            d5 += d3;
            if (!(d6 < d4)) break;
            dPolygon.addPoint(dPoint.y + d * Math.sin(d5), dPoint.x + d * Math.cos(d5));
        }
        dPolygon.addPoint(dPoint.y, dPoint.x + d);
        return dPolygon;
    }

    public static DPolygon getPolygon(Vector vector) {
        DPolygon dPolygon = new DPolygon();
        Punkt punkt = null;
        Enumeration enumeration = vector.elements();
        block5: while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                }
                case 0: {
                    dPolygon.addPoint(linie.pa);
                    if (linie.l2 == 0.0) break;
                    DPolygon dPolygon2 = GObject.getBogenPolygon(linie.pa, linie.pe, linie.l2);
                    for (int i = 0; i < dPolygon2.npoints; ++i) {
                        dPolygon.addPoint(dPolygon2.ypoints[i], dPolygon2.xpoints[i]);
                    }
                    continue block5;
                }
                case 9: {
                    if (linie.pa == punkt) {
                        return dPolygon;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public DPolygon getOriginalPolygon() {
        DPolygon dPolygon = new DPolygon();
        Punkt punkt = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                }
                case 0: {
                    dPolygon.addPoint(linie.pa.getOriginal());
                    break;
                }
                case 9: {
                    if (linie.pa == punkt) {
                        return dPolygon;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public DPolygon getMovedPolygon() {
        DPolygon dPolygon = new DPolygon();
        Punkt punkt = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                }
                case 0: {
                    dPolygon.addPoint(linie.pa.getMoved());
                    break;
                }
                case 9: {
                    if (linie.pa == punkt) {
                        return dPolygon;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public final Linie getNearestDefLinie(DPoint dPoint) {
        double d = Double.MAX_VALUE;
        Linie linie = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            Linie linie2 = (Linie)enumeration.nextElement();
            if (linie2.isEnde() || !((d2 = Math.abs(linie2.getInnerDistance(dPoint))) < d)) continue;
            d = d2;
            linie = linie2;
        }
        return linie;
    }

    public final Linie getNearestLinie(DPoint dPoint) {
        double d = Double.MAX_VALUE;
        Linie linie = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            Linie linie2 = (Linie)enumeration.nextElement();
            if (linie2.isEnde() || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
            d = d2;
            linie = linie2;
        }
        return linie;
    }

    public final Punkt getNearestPunkt(DPoint dPoint) {
        double d = Double.MAX_VALUE;
        Punkt punkt = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pa != null && (d2 = DPoint.ptDistSq(linie.pa.y, linie.pa.x, dPoint.y, dPoint.x)) < d) {
                d = d2;
                punkt = linie.pa;
            }
            if (linie.pe == null || !((d2 = DPoint.ptDistSq(linie.pe.y, linie.pe.x, dPoint.y, dPoint.x)) < d)) continue;
            d = d2;
            punkt = linie.pe;
        }
        return punkt;
    }

    public final DPoint getIntersectPoint(DPoint dPoint, DPoint dPoint2) {
        double d = Double.MAX_VALUE;
        DPoint dPoint3 = null;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            DPoint dPoint4;
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pa == dPoint || linie.pa == dPoint2 || linie.pe == null || linie.pe == dPoint || linie.pe == dPoint2 || (dPoint4 = DLine.getIntersectInPoint(linie.pa.y, linie.pa.x, linie.pe.y, linie.pe.x, dPoint.y, dPoint.x, dPoint2.y, dPoint2.x)) == null || !((d2 = dPoint.getDistance(dPoint4)) < d)) continue;
            dPoint3 = dPoint4;
            d = d2;
        }
        return dPoint3;
    }

    public final Linie getLongestLine() {
        Linie linie = null;
        double d = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            Linie linie2 = (Linie)enumeration.nextElement();
            if (linie2.pe == null || !((d2 = linie2.getS2()) > d)) continue;
            d = d2;
            linie = linie2;
        }
        return linie;
    }

    private final void computeBounds() {
        Object object;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            object = (Linie)enumeration.nextElement();
            DRectangle dRectangle = ((Linie)object).getBounds();
            d = Math.min(d, dRectangle.y);
            d2 = Math.min(d2, dRectangle.x);
            d3 = Math.max(d3, dRectangle.y + dRectangle.width);
            d4 = Math.max(d4, dRectangle.x + dRectangle.height);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                object = (ObjectDecor)enumeration.nextElement();
                if (((ObjectDecor)object).hasLocation()) {
                    d = Math.min(d, ((ObjectDecor)object).y);
                    d2 = Math.min(d2, ((ObjectDecor)object).x);
                    d3 = Math.max(d3, ((ObjectDecor)object).y);
                    d4 = Math.max(d4, ((ObjectDecor)object).x);
                }
                if (!((ObjectDecor)object).hasDecorLocation()) continue;
                d = Math.min(d, ((ObjectDecor)object).yt);
                d2 = Math.min(d2, ((ObjectDecor)object).xt);
                d3 = Math.max(d3, ((ObjectDecor)object).yt);
                d4 = Math.max(d4, ((ObjectDecor)object).xt);
            }
        }
        if (d == d3) {
            d -= 0.5;
            d3 += 0.5;
        }
        if (d2 == d4) {
            d2 -= 0.5;
            d4 += 0.5;
        }
        this.setBounds(d, d2, d3 - d, d4 - d2);
    }

    private Area getArea() {
        DPolygon dPolygon = this.getPolygon();
        if (dPolygon == null) {
            return null;
        }
        return new Area(dPolygon.getPath());
    }

    private void setArea(Area area) {
        long l = 1L;
        super.removeAllElements();
        PathIterator pathIterator = area.getPathIterator(NULL_TRANSFORM);
        double[] dArray = new double[6];
        Punkt punkt = null;
        Cloneable cloneable = null;
        boolean bl = false;
        boolean bl2 = false;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    cloneable = punkt = new Punkt(l++, dArray[0], dArray[1]);
                    bl = true;
                    if (this.size() <= 0) break;
                    bl2 = true;
                    break;
                }
                case 1: {
                    KatasterElement katasterElement;
                    if (cloneable == null) {
                        cloneable = new Punkt(l++, dArray[0], dArray[1]);
                    } else {
                        katasterElement = new Punkt(l++, dArray[0], dArray[1]);
                        Linie linie = new Linie(bl ? 1 : 0, (Punkt)cloneable, (Punkt)katasterElement);
                        linie.setParameter(this.getLineDefaults());
                        super.addElement(linie);
                        cloneable = katasterElement;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    KatasterElement katasterElement = (Linie)super.lastElement();
                    katasterElement.pe = punkt;
                    super.addElement(new Linie(9, punkt, null));
                }
            }
            pathIterator.next();
        }
        this.y = 0.0;
        this.x = 0.0;
        if (bl2) {
            try {
                new GObjectManipulator(this).concatenate();
            }
            catch (Exception exception) {}
        } else {
            this.initGeom();
        }
    }

    public GObject intersect(GObject gObject) {
        if (this.intersectsRect(gObject)) {
            Area area = this.getArea();
            if (area == null || gObject.getArea() == null) {
                return null;
            }
            area.intersect(gObject.getArea());
            if (!area.isEmpty()) {
                GObject gObject2 = null;
                try {
                    gObject2 = (GObject)this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                gObject2.setArea(area);
                if (Math.abs(gObject2.getPolygonFlaeche()) > 0.001) {
                    return gObject2;
                }
            }
        }
        return null;
    }

    public Vector intersectObjects(Enumeration enumeration) {
        Vector<GObject> vector = new Vector<GObject>();
        while (enumeration.hasMoreElements()) {
            GObject gObject = (GObject)enumeration.nextElement();
            GObject gObject2 = gObject.intersect(this);
            if (gObject2 == null) continue;
            vector.addElement(gObject2);
        }
        return vector;
    }

    @Override
    public abstract String getClassName();

    @Override
    public abstract String getObjectName();

    @Override
    public abstract String toDebugString();

    @Override
    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        Object object;
        Object object2;
        printWriter.println(this.toDatLine());
        if (this.hasDecor()) {
            object2 = this.decors();
            while (object2.hasMoreElements()) {
                object = (ObjectDecor)object2.nextElement();
                if (((ObjectDecor)object).isAutoCreate()) continue;
                printWriter.println(((ObjectDecor)object).toDatLine());
            }
        }
        if (this.att != null) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("C!Att:");
            object = this.attributes();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = this.getAttribute(string).toString();
                ((StringBuffer)object2).append(" ");
                ((StringBuffer)object2).append(string);
                ((StringBuffer)object2).append("=");
                ((StringBuffer)object2).append(string2.replace(' ', '_'));
            }
            printWriter.println(((StringBuffer)object2).toString());
        }
        object2 = this.elements();
        while (object2.hasMoreElements()) {
            printWriter.println(((DatObject)object2.nextElement()).toDatLine());
        }
    }

    public void writeZenoLines(OutputStream outputStream, Charset charset, int n, String string) throws IOException {
        String string2 = ";" + string + System.lineSeparator();
        int n2 = 0;
        Punkt punkt = null;
        int n3 = this.size() - 1;
        for (int i = 0; i <= n3; ++i) {
            DatObject datObject = (DatObject)this.elementAt(i);
            if (!(datObject instanceof Linie)) continue;
            Linie linie = (Linie)datObject;
            if (i == n3 && linie.pa == punkt) {
                outputStream.write((linie.pa.toZenoLine(n, 1, false) + string2).getBytes(charset));
                continue;
            }
            if (i == 0) {
                punkt = linie.pa;
            }
            outputStream.write((linie.pa.toZenoLine(n, ++n2, false) + string2).getBytes(charset));
            if (linie.l2 != 0.0) {
                DPolygon dPolygon = GObject.getBogenPolygon(linie.pa, linie.pe, linie.l2, 0.05);
                for (int j = 0; j < dPolygon.npoints; ++j) {
                    Punkt punkt2 = new Punkt(dPolygon.ypoints[j], dPolygon.xpoints[j]);
                    outputStream.write((punkt2.toZenoLine(n, ++n2, false) + string2).getBytes(charset));
                }
            }
            if (!linie.isLinie()) continue;
            outputStream.write((linie.pe.toZenoLine(n, ++n2, false) + string2).getBytes(charset));
        }
    }

    @Override
    public Object getAttribute(String string) {
        for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
            if (!listAttribute.getName().equals(string)) continue;
            return listAttribute.getValue();
        }
        return null;
    }

    @Override
    public Object setAttribute(String string, Object object) {
        this.parseAttribute(string, object);
        if (this.att == null) {
            this.att = new ListAttribute(string, object);
        } else {
            for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
                if (listAttribute.getName().equals(string)) {
                    Object object2 = listAttribute.getValue();
                    listAttribute.setValue(object);
                    return object2;
                }
                if (listAttribute.getNext() != null) continue;
                listAttribute.setNext(new ListAttribute(string, object));
                return null;
            }
        }
        return null;
    }

    public void addAttribute(String string, Object object) {
        this.parseAttribute(string, object);
        this.att = new ListAttribute(string, object, this.att);
    }

    protected void parseAttribute(String string, Object object) {
    }

    @Override
    public Object removeAttribute(String string) {
        if (this.att.getName().equals(string)) {
            Object object = this.att.getValue();
            this.att = this.att.getNext();
            return object;
        }
        ListAttribute listAttribute = this.att;
        for (ListAttribute listAttribute2 = this.att.getNext(); listAttribute2 != null; listAttribute2 = listAttribute2.getNext()) {
            if (listAttribute2.getName().equals(string)) {
                listAttribute.setNext(listAttribute2.getNext());
                return listAttribute2.getValue();
            }
            listAttribute = listAttribute2;
        }
        return null;
    }

    @Override
    public Enumeration attributes() {
        return new ListAttributeEnumerator(this.att);
    }

    @Override
    public boolean hasAttributes() {
        return this.att != null;
    }

    @Override
    public abstract void drawObject(IGraphics var1, boolean var2, boolean var3);

    public void drawHashpoint(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !iGraphics.contains(this.y, this.x)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            iGraphics.setXORMode();
        } else {
            iGraphics.setPaintMode();
        }
        Point point = iGraphics.getGraphicPoint(this.y, this.x, new Point());
        graphics.fillOval(point.x - 3, point.y - 3, 6, 6);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawBackground(iGraphics, bl, bl2, iGraphics.getViewport());
    }

    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2, IViewport iViewport) {
        if (!this.isVisible() || !this.isViewable(iViewport) || this.areaTyp == 0) {
            return;
        }
        if (this.isDebugMarker()) {
            iGraphics.getGraphics().setColor(Color.red);
        }
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        ClearPolygon clearPolygon = null;
        int n = this.size();
        int n2 = 0;
        Punkt punkt = null;
        block5: for (int i = 0; i < n; ++i) {
            Linie linie = (Linie)this.elementAt(i);
            switch (linie.getLs()) {
                case 1: {
                    punkt = linie.pa;
                    clearPolygon = new ClearPolygon(n);
                    n2 = iViewport.incode(linie.pa.y, linie.pa.x);
                }
                case 0: {
                    n2 = IGraphics.addViewPortPoints(n2, linie.pa.y, linie.pa.x, iViewport, clearPolygon);
                    if (linie.isBogen()) {
                        var13_13 = iGraphics.getDataBogenPolygon(linie.pa, linie.pe, linie.l2);
                        for (int j = 0; j < var13_13.npoints; ++j) {
                            if (iViewport.contains(var13_13.ypoints[j], var13_13.xpoints[j])) {
                                point = iGraphics.getGraphicPoint(var13_13.ypoints[j], var13_13.xpoints[j], point);
                                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                                n2 = iViewport.incode(var13_13.ypoints[j], var13_13.xpoints[j]);
                                continue;
                            }
                            n2 = IGraphics.addViewPortPoints(n2, var13_13.ypoints[j], var13_13.xpoints[j], iViewport, clearPolygon);
                        }
                    } else {
                        var13_13 = iViewport.intersectLine(linie.pa.y, linie.pa.x, linie.pe.y, linie.pe.x);
                        if (var13_13 != null) {
                            point = iGraphics.getGraphicPoint(((DLine)var13_13).ya, ((DLine)var13_13).xa, point);
                            ((Polygon)clearPolygon).addPoint(point.x, point.y);
                            point = iGraphics.getGraphicPoint(((DLine)var13_13).ye, ((DLine)var13_13).xe, point);
                            ((Polygon)clearPolygon).addPoint(point.x, point.y);
                            n2 = iViewport.incode(((DLine)var13_13).ye, ((DLine)var13_13).xe);
                        }
                    }
                    n2 = IGraphics.addViewPortPoints(n2, linie.pe.y, linie.pe.x, iViewport, clearPolygon);
                    continue block5;
                }
                case 9: {
                    if (linie.pa != punkt || clearPolygon.npoints <= 2) continue block5;
                    graphics.fillPolygon(clearPolygon.xpoints, clearPolygon.ypoints, clearPolygon.npoints);
                }
            }
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2) {
            Hashtable<Punkt, GObject> hashtable = new Hashtable<Punkt, GObject>();
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Linie linie = (Linie)enumeration.nextElement();
                linie.drawForeground(iGraphics, bl, bl2);
                if (!KafPlotProperties.isPunktVisible) continue;
                if (linie.pa != null && hashtable.put(linie.pa, this) == null) {
                    linie.pa.drawSymbol(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                }
                if (linie.pe == null || hashtable.put(linie.pe, this) != null) continue;
                linie.pe.drawSymbol(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
        } else {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                ((Linie)enumeration.nextElement()).drawForeground(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public abstract void drawInscription(IGraphics var1, boolean var2, boolean var3);
}

