/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.geodata.Feature;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KatasterElement;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.OskaObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.util.CountTable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class GObjectManipulator {
    private GObject obj = null;
    private ExceptionList exceptionList = null;

    public GObjectManipulator(GObject gObject) {
        this.obj = gObject;
    }

    private void splitGeom(GObject gObject, Vector vector, Vector vector2, Vector vector3) {
        boolean bl = true;
        for (int i = 0; i < gObject.size(); ++i) {
            Linie linie = (Linie)((Linie)gObject.elementAt(i)).clone();
            if (bl) {
                if (linie.isEnde()) {
                    if (vector3 == null) continue;
                    bl = false;
                    continue;
                }
                if (linie.getArt() == 0) {
                    if (vector2 == null) continue;
                    boolean bl2 = true;
                    for (int j = 0; j < vector2.size(); ++j) {
                        Linie linie2 = (Linie)vector2.elementAt(j);
                        if ((linie2.pa != linie.pa || linie2.pe != linie.pe) && (linie2.pe != linie.pa || linie2.pa != linie.pe)) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    vector2.addElement(linie);
                    continue;
                }
                vector.addElement(linie);
                continue;
            }
            if (vector3 == null) continue;
            vector3.addElement(linie);
        }
    }

    private Vector createBoundings(Vector vector, boolean bl) {
        Punkt punkt;
        int n;
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object;
        Vector<Vector> vector2 = new Vector<Vector>();
        CountTable countTable = new CountTable();
        boolean bl2 = false;
        do {
            bl2 = false;
            object = vector.elements();
            while (object.hasMoreElements()) {
                cloneable2 = (Linie)object.nextElement();
                countTable.put(((Linie)cloneable2).pa);
                countTable.put(((Linie)cloneable2).pe);
            }
            object = countTable.keys();
            while (object.hasMoreElements()) {
                cloneable2 = (Punkt)object.nextElement();
                if (countTable.getCount(cloneable2) <= 2) continue;
                cloneable = this.createBounding(vector, (Punkt)cloneable2, countTable);
                vector2.addElement((Vector)cloneable);
                bl2 = true;
                break;
            }
            countTable.clear();
        } while (bl2);
        while (vector.size() > 0) {
            object = ((Linie)vector.elementAt((int)0)).pa;
            vector2.addElement(this.createBounding(vector, (Punkt)object, countTable));
        }
        do {
            bl2 = false;
            block5: for (n = vector2.size() - 1; n > 0; --n) {
                cloneable2 = (Vector)vector2.elementAt(n);
                cloneable = ((Linie)((Vector)cloneable2).firstElement()).pa;
                punkt = ((Linie)((Vector)cloneable2).lastElement()).pe;
                if (((Punkt)cloneable).equals(punkt)) continue;
                for (int i = n - 1; i >= 0; --i) {
                    Vector vector3 = (Vector)vector2.elementAt(i);
                    Punkt punkt2 = ((Linie)vector3.firstElement()).pa;
                    Punkt punkt3 = ((Linie)vector3.lastElement()).pe;
                    if (punkt2.equals(punkt3) || cloneable != punkt2 && cloneable != punkt3 && punkt != punkt2 && punkt != punkt3) continue;
                    this.bindPolygons(vector3, (Vector)cloneable2);
                    vector2.removeElementAt(n);
                    bl2 = true;
                    continue block5;
                }
            }
        } while (bl2);
        for (n = vector2.size() - 1; n >= 0; --n) {
            cloneable2 = (Vector)vector2.elementAt(n);
            cloneable = ((Linie)((Vector)cloneable2).firstElement()).pa;
            punkt = ((Linie)((Vector)cloneable2).lastElement()).pe;
            if (((Punkt)cloneable).equals(punkt)) continue;
            this.addException(new GeomException(2, this.obj.getHashPoint(), new DLine(punkt, (DPoint)((Object)cloneable)), "Objekt: " + this.obj.getExceptionableName() + " hat eine L\u00fccke im Polygon zwischen den Punkten " + punkt.nr + " - " + ((Punkt)cloneable).nr));
            if (!bl) continue;
            Linie linie = new Linie(2, 0, 0, 0, punkt, (Punkt)cloneable);
            linie.setAnchorLine(true);
            ((Vector)cloneable2).addElement(linie);
        }
        return vector2;
    }

    private void bindPolygons(Vector vector, Vector vector2) {
        block5: {
            Punkt punkt;
            Punkt punkt2;
            block7: {
                Punkt punkt3;
                block6: {
                    Punkt punkt4;
                    block4: {
                        punkt2 = ((Linie)vector.firstElement()).pa;
                        punkt4 = ((Linie)vector.lastElement()).pe;
                        punkt = ((Linie)vector2.firstElement()).pa;
                        punkt3 = ((Linie)vector2.lastElement()).pe;
                        if (punkt4 != punkt) break block4;
                        for (int i = 0; i < vector2.size(); ++i) {
                            vector.addElement(vector2.elementAt(i));
                        }
                        break block5;
                    }
                    if (punkt4 != punkt3) break block6;
                    for (int i = vector2.size() - 1; i >= 0; --i) {
                        vector.addElement(((Linie)vector2.elementAt(i)).skip());
                    }
                    break block5;
                }
                if (punkt2 != punkt3) break block7;
                for (int i = vector2.size() - 1; i >= 0; --i) {
                    vector.insertElementAt(vector2.elementAt(i), 0);
                }
                break block5;
            }
            if (punkt2 != punkt) break block5;
            for (int i = 0; i < vector2.size(); ++i) {
                vector.insertElementAt(((Linie)vector2.elementAt(i)).skip(), 0);
            }
        }
    }

    private Vector createBounding(Vector vector, Punkt punkt, CountTable countTable) {
        Vector<Linie> vector2 = new Vector<Linie>();
        boolean bl = false;
        block0: do {
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                Linie linie = (Linie)vector.elementAt(i);
                if (punkt == linie.pa) {
                    bl = true;
                } else if (punkt == linie.pe) {
                    linie = linie.skip();
                    bl = true;
                }
                if (!bl) continue;
                vector2.addElement(linie);
                vector.removeElementAt(i);
                punkt = linie.pe;
                if (countTable.getCount(punkt) <= 2) continue block0;
                return vector2;
            }
        } while (bl);
        return vector2;
    }

    private Vector sortBoundings(Vector vector) {
        boolean bl = false;
        do {
            bl = false;
            for (int i = 0; i < vector.size() - 1; ++i) {
                Vector vector2 = (Vector)vector.elementAt(i);
                Vector vector3 = (Vector)vector.elementAt(i + 1);
                if (!(Math.abs(this.getArea(vector2)) < Math.abs(this.getArea(vector3)))) continue;
                vector.setElementAt(vector3, i);
                vector.setElementAt(vector2, i + 1);
                bl = true;
            }
        } while (bl);
        return vector;
    }

    private void normalizeBoundings(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            if (!(this.getArea(vector2) < 0.0)) continue;
            this.skip(vector2);
        }
    }

    private void normalizeBoundings(Vector vector, Vector vector2) {
        DPolygon dPolygon;
        DPolygon dPolygon2 = this.createPolygon(vector);
        if (this.contains(dPolygon2, dPolygon = this.createPolygon(vector2))) {
            this.skip(vector2);
        } else if (this.contains(dPolygon, dPolygon2)) {
            this.skip(vector);
        }
    }

    private boolean contains(DPolygon dPolygon, DPolygon dPolygon2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < dPolygon2.npoints; ++i) {
            if (dPolygon.contains(dPolygon2.ypoints[i], dPolygon2.xpoints[i])) {
                ++n;
                continue;
            }
            ++n2;
        }
        return n > n2;
    }

    private DPolygon createPolygon(Vector vector) {
        DPolygon dPolygon = new DPolygon();
        for (int i = 0; i < vector.size(); ++i) {
            Linie linie = (Linie)vector.elementAt(i);
            dPolygon.addPoint(linie.pa);
        }
        return dPolygon;
    }

    private int getFirstSinglePointIndex(Vector vector) {
        Linie linie;
        int n;
        CountTable countTable = new CountTable();
        for (n = 0; n < vector.size(); ++n) {
            linie = (Linie)vector.elementAt(n);
            countTable.put(linie.pa);
            countTable.put(linie.pe);
        }
        for (n = 0; n < vector.size(); ++n) {
            linie = (Linie)vector.elementAt(n);
            if (countTable.getCount(linie.pa) > 2) continue;
            return n;
        }
        return -1;
    }

    private void bindBoundings(Vector vector, Vector vector2) throws Exception {
        int n;
        Cloneable cloneable;
        int n2;
        block0: for (n2 = vector.size() - 1; n2 >= 0; --n2) {
            cloneable = (Vector)vector.elementAt(n2);
            for (n = n2 - 1; n >= 0; --n) {
                Vector vector3 = (Vector)vector.elementAt(n);
                Punkt punkt = this.getMultiPoint(vector3, (Vector)cloneable);
                if (punkt == null) continue;
                this.bindBoundings(vector3, (Vector)cloneable, punkt);
                vector.removeElementAt(n2);
                continue block0;
            }
        }
        n2 = 1;
        while (vector2.size() != 0) {
            Vector vector4;
            cloneable = (Linie)vector2.firstElement();
            vector2.removeElementAt(0);
            n = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            block3: for (int i = 0; i < vector.size(); ++i) {
                vector4 = (Vector)vector.elementAt(i);
                for (int j = 0; j < vector4.size(); ++j) {
                    Linie linie = (Linie)vector4.elementAt(j);
                    if (((Linie)cloneable).pa != linie.pa && ((Linie)cloneable).pe != linie.pa) continue;
                    if (n < 0) {
                        n = i;
                        continue;
                    }
                    if (i == n) continue;
                    n4 = i;
                    continue block3;
                }
            }
            if (n4 < 0) {
                this.addException(new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Dem Objekt: " + this.obj.getExceptionableName() + " fehlt eine Verbindungslinie zwischen Polygonen"));
            }
            Vector vector5 = (Vector)vector.elementAt(n);
            vector4 = (Vector)vector.elementAt(n4);
            this.bindBoundings(vector5, vector4, (Linie)cloneable);
            vector.removeElementAt(n4);
            if (n2 != 0) continue;
        }
    }

    private void bindBoundings(Vector vector) throws Exception {
        Object object;
        Cloneable cloneable;
        Vector vector2;
        int n;
        boolean bl = false;
        do {
            bl = false;
            block1: for (n = vector.size() - 1; n >= 0; --n) {
                vector2 = (Vector)vector.elementAt(n);
                for (int i = vector.size() - 1; i >= 0; --i) {
                    Vector vector3;
                    if (n == i || (cloneable = this.getMultiPoint(vector3 = (Vector)vector.elementAt(i), vector2)) == null) continue;
                    this.bindBoundings(vector3, vector2, (Punkt)cloneable);
                    vector.removeElementAt(n);
                    bl = true;
                    continue block1;
                }
            }
        } while (bl);
        for (n = vector.size() - 1; n >= 0; --n) {
            vector2 = (Vector)vector.elementAt(n);
            DPolygon dPolygon = this.createPolygon(vector2);
            for (int i = n - 1; i >= 0; --i) {
                cloneable = (Vector)vector.elementAt(i);
                object = this.createPolygon((Vector)cloneable);
                if (!this.contains((DPolygon)object, dPolygon)) continue;
                this.bindBoundings((Vector)cloneable, vector2, this.createStrap((Vector)cloneable, vector2));
                vector.removeElementAt(n);
            }
        }
        bl = false;
        do {
            bl = false;
            double d = Double.MAX_VALUE;
            int n2 = -1;
            int n3 = -1;
            for (int i = vector.size() - 1; i >= 0; --i) {
                object = (Vector)vector.elementAt(i);
                for (int j = i - 1; j >= 0; --j) {
                    Vector vector4 = (Vector)vector.elementAt(j);
                    double d2 = this.getStrapDist(vector4, (Vector)object);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n2 = j;
                    n3 = i;
                }
            }
            if (n2 < 0) continue;
            this.bindBoundings((Vector)vector.elementAt(n2), (Vector)vector.elementAt(n3), this.createStrap((Vector)vector.elementAt(n2), (Vector)vector.elementAt(n3)));
            vector.removeElementAt(n3);
            bl = true;
        } while (bl);
    }

    private Vector bindBoundings(Vector vector, Vector vector2, Linie linie) {
        Linie linie2;
        int n;
        int n2;
        this.normalizeBoundings(vector, vector2);
        int n3 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Linie linie3 = (Linie)vector.elementAt(n2);
            if (linie.pa != linie3.pa && linie.pe != linie3.pa) continue;
            if (linie.pe == linie3.pa) {
                linie = linie.skip();
            }
            vector.insertElementAt(linie, n2);
            n3 = n2 + 1;
            break;
        }
        n2 = 0;
        boolean bl = false;
        for (n = 0; n < vector2.size(); ++n) {
            linie2 = (Linie)vector2.elementAt(n);
            if (bl) {
                vector.insertElementAt(linie2, n3);
                ++n3;
                continue;
            }
            if (linie2.pa != linie.pe) continue;
            n2 = n;
            vector.insertElementAt(linie2, n3);
            ++n3;
            bl = true;
        }
        for (n = 0; n < n2; ++n) {
            linie2 = (Linie)vector2.elementAt(n);
            vector.insertElementAt(linie2, n3);
            ++n3;
        }
        linie = (Linie)linie.clone();
        Linie linie4 = (Linie)vector.elementAt(n3);
        if (linie4.pa != linie.pe) {
            linie = linie.skip();
        }
        vector.insertElementAt(linie, n3);
        return vector;
    }

    private Vector bindBoundings(Vector vector, Vector vector2, Punkt punkt) {
        Linie linie;
        int n;
        int n2;
        this.normalizeBoundings(vector, vector2);
        int n3 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Linie linie2 = (Linie)vector.elementAt(n2);
            if (punkt != linie2.pa) continue;
            n3 = n2;
            break;
        }
        n2 = 0;
        boolean bl = false;
        for (n = 0; n < vector2.size(); ++n) {
            linie = (Linie)vector2.elementAt(n);
            if (bl) {
                vector.insertElementAt(linie, n3);
                ++n3;
                continue;
            }
            if (linie.pa != punkt) continue;
            n2 = n;
            vector.insertElementAt(linie, n3);
            ++n3;
            bl = true;
        }
        for (n = 0; n < n2; ++n) {
            linie = (Linie)vector2.elementAt(n);
            vector.insertElementAt(linie, n3);
            ++n3;
        }
        return vector;
    }

    private void createGeom(GObject gObject, Vector vector, Vector vector2, boolean bl) {
        int n;
        for (n = vector.size() - 1; n >= 0; --n) {
            Linie linie;
            KatasterElement katasterElement;
            Vector vector3 = (Vector)vector.elementAt(n);
            if (vector3.size() == 1) {
                katasterElement = (Linie)vector3.firstElement();
                katasterElement.setLs(2);
                gObject.addElement(katasterElement);
                continue;
            }
            katasterElement = null;
            for (int i = 0; i < vector3.size(); ++i) {
                linie = (Linie)vector3.elementAt(i);
                if (i == 0) {
                    linie.setLs(1);
                    katasterElement = linie.pa;
                } else {
                    linie.setLs(0);
                }
                gObject.addElement(linie);
            }
            Linie linie2 = (Linie)vector3.lastElement();
            if (linie2.pe != katasterElement && bl) {
                linie2 = new Linie(0, 0, 0, linie2.pe, (Punkt)katasterElement);
                linie2.getParameter().setOska(242);
                gObject.addElement(linie2);
            }
            linie = new Linie(linie2.pe, null);
            linie.setLs(9);
            gObject.addElement(linie);
        }
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                gObject.addElement(vector2.elementAt(n));
            }
        }
    }

    private double getArea(Vector vector) {
        double d = 0.0;
        double d2 = 0.0;
        Linie linie = null;
        Linie linie2 = null;
        Linie linie3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            linie = (Linie)vector.elementAt(i);
            if (linie.isBogen()) {
                d2 += linie.getBogenFlaeche();
            }
            if (i == 0) {
                linie3 = linie;
            } else {
                d += linie.pa.y * (linie2.pa.x - linie.pe.x);
            }
            linie2 = linie;
        }
        return (d += linie.pe.y * (linie2.pa.x - linie3.pe.x)) / 2.0 + d2;
    }

    private Vector skip(Vector vector) {
        int n;
        Vector<Linie> vector2 = new Vector<Linie>(vector.size());
        for (n = vector.size() - 1; n >= 0; --n) {
            vector2.addElement(((Linie)vector.elementAt(n)).skip());
        }
        vector.removeAllElements();
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(vector2.elementAt(n));
        }
        return vector;
    }

    private void insertCount(CountTable countTable, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Linie linie = (Linie)enumeration.nextElement();
            countTable.put(linie.pa);
            countTable.put(linie.pe);
        }
    }

    private void clearCount(CountTable countTable) {
        Punkt punkt = null;
        while ((punkt = this.getMultiPoint(countTable)) != null) {
            countTable.remove(punkt);
        }
    }

    private Punkt getMultiPoint(Vector vector, Vector vector2) {
        CountTable countTable = new CountTable();
        CountTable countTable2 = new CountTable();
        this.insertCount(countTable, vector);
        this.insertCount(countTable2, vector2);
        Enumeration enumeration = countTable.keys();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (countTable2.getCount(punkt) <= 0) continue;
            return punkt;
        }
        return null;
    }

    private Punkt getMultiPoint(CountTable countTable) {
        Enumeration enumeration = countTable.keys();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (countTable.getCount(punkt) <= 2) continue;
            return punkt;
        }
        return null;
    }

    private Linie createStrap(Vector vector, Vector vector2) throws Exception {
        CountTable countTable = new CountTable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            countTable.put(((Linie)enumeration.nextElement()).pa);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            countTable.put(((Linie)enumeration.nextElement()).pa);
        }
        double d = Double.MAX_VALUE;
        Punkt punkt = null;
        Punkt punkt2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Punkt punkt3 = ((Linie)vector.elementAt((int)i)).pa;
            if (countTable.getCount(punkt3) >= 2) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                double d2;
                Punkt punkt4 = ((Linie)vector2.elementAt((int)j)).pa;
                if (countTable.getCount(punkt4) >= 2 || !((d2 = DPoint.ptDistSq(punkt3.y, punkt3.x, punkt4.y, punkt4.x)) < d)) continue;
                punkt = punkt3;
                punkt2 = punkt4;
                d = d2;
            }
        }
        if (punkt != null && punkt2 != null) {
            Linie linie = new Linie(2, 0, 0, 0, punkt, punkt2);
            linie.setAnchorLine(true);
            return linie;
        }
        throw new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", es konnte keine Verbindungslinie zwischen Polygonen erzeugt werden");
    }

    private double getStrapDist(Vector vector, Vector vector2) {
        CountTable countTable = new CountTable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            countTable.put(((Linie)enumeration.nextElement()).pa);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            countTable.put(((Linie)enumeration.nextElement()).pa);
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            Punkt punkt = ((Linie)vector.elementAt((int)i)).pa;
            if (countTable.getCount(punkt) >= 2) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                double d2;
                Punkt punkt2 = ((Linie)vector2.elementAt((int)j)).pa;
                if (countTable.getCount(punkt2) >= 2 || !((d2 = DPoint.ptDistSq(punkt.y, punkt.x, punkt2.y, punkt2.x)) < d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public void repair() throws Exception {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.splitGeom(this.obj, vector, vector2, null);
            if (vector.size() < 3) {
                this.addException(new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", zu wenig Linien im Umring"));
            }
            Vector vector3 = this.createBoundings(vector, false);
            this.sortBoundings(vector3);
            this.normalizeBoundings(vector3);
            this.bindBoundings(vector3, vector2);
            this.bindBoundings(vector3);
            this.obj.removeAllElements();
            this.createGeom(this.obj, vector3, null, false);
        }
        catch (Exception exception) {
            if (exception instanceof GeomException) {
                this.addException(exception);
            }
            throw exception;
        }
        this.obj.initGeom();
        if (this.hasExceptions()) {
            throw (Exception)this.exceptionList.elementAt(0);
        }
    }

    public void union(GObject gObject, Vector vector) throws Exception {
        Vector<Object> vector2 = new Vector<Object>();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            this.splitGeom((GObject)object.nextElement(), vector2, vector3, vector4);
        }
        object = new Hashtable();
        Object object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            Linie linie = (Linie)object2.nextElement();
            if (((Hashtable)object).put(linie, linie) == null) continue;
            ((Hashtable)object).remove(linie);
        }
        vector2.removeAllElements();
        object2 = ((Hashtable)object).elements();
        while (object2.hasMoreElements()) {
            vector2.addElement(object2.nextElement());
        }
        if (vector2.size() < 3) {
            this.addException(new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", zu wenig Linien im Umring"));
        }
        object2 = this.createBoundings(vector2, false);
        this.sortBoundings((Vector)object2);
        this.normalizeBoundings((Vector)object2);
        this.bindBoundings((Vector)object2, vector3);
        this.bindBoundings((Vector)object2);
        gObject.removeAllElements();
        this.createGeom(gObject, (Vector)object2, vector4, false);
        gObject.initGeom();
    }

    public void concatenate() throws Exception {
        this.concatenate(false);
    }

    public void concatenate(boolean bl) throws Exception {
        try {
            Vector vector = new Vector();
            Vector vector2 = bl ? new Vector() : null;
            this.splitGeom(this.obj, vector, null, vector2);
            if (vector.size() < 3) {
                this.addException(new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", zu wenig Linien im Umring"));
            }
            Vector vector3 = this.createBoundings(vector, true);
            this.sortBoundings(vector3);
            this.normalizeBoundings(vector3);
            this.bindBoundings(vector3);
            this.obj.removeAllElements();
            this.createGeom(this.obj, vector3, vector2, true);
        }
        catch (Exception exception) {
            if (exception instanceof GeomException) {
                this.addException(exception);
            }
            throw exception;
        }
        this.obj.initGeom();
        if (this.hasExceptions()) {
            throw (Exception)this.exceptionList.elementAt(0);
        }
    }

    public void split() throws Exception {
        if (this.obj instanceof Flurstueck && ((Flurstueck)this.obj).isNutzstueck()) {
            Flurstueck flurstueck = (Flurstueck)this.obj;
            Vector vector = flurstueck.getSubAreas();
            if (vector.size() <= 1) {
                this.addException(new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + " hat keine Teilfl\u00e4chen"));
            } else {
                try {
                    OskaObject oskaObject;
                    int n;
                    Vector vector2 = new Vector();
                    Object object = flurstueck.decors();
                    while (object.hasMoreElements()) {
                        vector2.addElement(object.nextElement());
                    }
                    flurstueck.deleteGeom();
                    object = new Vector();
                    for (n = 1; n < vector.size(); ++n) {
                        oskaObject = (Flurstueck)flurstueck.clone();
                        this.copyGeom((GObject)oskaObject, (Vector)vector.elementAt(n));
                        ((Flurstueck)oskaObject).setCount(0);
                        ((DataContainer)oskaObject).removeLocation();
                        ((Vector)object).addElement(oskaObject);
                    }
                    this.copyGeom(flurstueck, (Vector)vector.elementAt(0));
                    flurstueck.removeLocation();
                    ((Vector)object).insertElementAt(flurstueck, 0);
                    for (n = 0; n < vector2.size(); ++n) {
                        oskaObject = (ObjectDecor)vector2.elementAt(n);
                        double d = Double.MAX_VALUE;
                        GObject gObject = null;
                        boolean bl = false;
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            double d2;
                            Flurstueck flurstueck2 = (Flurstueck)((Vector)object).elementAt(i);
                            DPolygon dPolygon = flurstueck2.getPolygon();
                            if (dPolygon.contains(((ObjectDecor)oskaObject).y, ((ObjectDecor)oskaObject).x)) {
                                flurstueck2.setLocation(((ObjectDecor)oskaObject).y, ((ObjectDecor)oskaObject).x);
                                flurstueck2.addDecor((ObjectDecor)oskaObject);
                                bl = true;
                                break;
                            }
                            DPoint dPoint = new DPoint(((ObjectDecor)oskaObject).y, ((ObjectDecor)oskaObject).x);
                            Punkt punkt = flurstueck2.getNearestPunkt(dPoint);
                            if (punkt == null || !((d2 = punkt.getDistance(dPoint)) < d)) continue;
                            d = d2;
                            gObject = flurstueck2;
                        }
                        if (bl) continue;
                        if (!gObject.hasDecor()) {
                            gObject.setLocation(((ObjectDecor)oskaObject).y, ((ObjectDecor)oskaObject).x);
                        }
                        gObject.addDecor((ObjectDecor)oskaObject);
                    }
                    for (n = 0; n < ((Vector)object).size(); ++n) {
                        oskaObject = (Flurstueck)((Vector)object).elementAt(n);
                        if (!((DataContainer)oskaObject).hasLocation()) {
                            DPoint dPoint = ((GObject)oskaObject).getMitte();
                            ((DataContainer)oskaObject).setLocation(dPoint.y, dPoint.x);
                        }
                        if (n <= 0) continue;
                        DataBase.FLST.put((Feature)((Object)oskaObject));
                    }
                }
                catch (Exception exception) {
                    throw new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", Fehler beim Zerlegen");
                }
            }
        } else {
            throw new GeomException(2, this.obj.getHashPoint(), this.obj.getHashPoint(), "Objekt: " + this.obj.getExceptionableName() + ", ist ung\u00fcltig");
        }
    }

    private void copyGeom(GObject gObject, Vector vector) {
        gObject.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            gObject.addElement(enumeration.nextElement());
        }
        gObject.initGeom();
    }

    public boolean hasExceptions() {
        return this.exceptionList != null && this.exceptionList.size() > 0;
    }

    public Enumeration exceptions() {
        return this.exceptionList.elements();
    }

    protected void addException(Exception exception) {
        if (this.exceptionList == null) {
            this.exceptionList = new ExceptionList();
        }
        this.exceptionList.addException(exception);
    }
}

