/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IException;
import de.geocalc.awt.IGraphics;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.ObjectDecor;
import de.geocalc.kafplot.ObjectLine;
import de.geocalc.kafplot.ObjectSymbol;
import de.geocalc.kafplot.ObjectText;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.kataster.model.Alkis;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Gebaeude
extends GObject
implements PaintObject,
DatObject,
Comparable,
Exceptionable,
Messager,
Drawable {
    private static final int FLAG_OIRD = 32768;
    private static final int FLAG_UIRD = 65536;
    private static final int FLAG_ABW_ZUSTAND = 131072;
    private GebaeudeKennzeichen leitzeichen;
    private Vector kennzeichen;
    private int count;
    private int funktion;
    private static final Text text = new Text(2, 2, null, 0.0, 0.0, 0.0, 1, 0);
    private static final Text attText = new Text(3, 2, null, 0.0, 0.0, 0.0, 0, 0x2000000);
    private static final TextSymbol sym = new TextSymbol(text, new Point());
    private static final TextSymbol attSym = new TextSymbol(attText, new Point());
    private static final Point p = new Point();

    public Gebaeude() {
    }

    public void setFunktion(int n) {
        this.funktion = n;
    }

    public int getFunktion() {
        return this.funktion;
    }

    public void setOird(boolean bl) {
        this.flags = bl ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean isOird() {
        return (this.flags & 0x8000) != 0;
    }

    public void setUird(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10000) : (this.flags &= 0xFFFEFFFF);
    }

    public boolean isUird() {
        return (this.flags & 0x10000) != 0;
    }

    public void setAbwZustand(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20000) : (this.flags &= 0xFFFDFFFF);
    }

    public boolean isAbwZustand() {
        return (this.flags & 0x20000) != 0;
    }

    @Override
    public LinieParameter getLineDefaults() {
        int n = this.getOska();
        if (n == 31001) {
            int n2;
            Object object = null;
            if (this.isAbwZustand() && (object = this.getAttribute("zustand")) != null && (n2 = Integer.parseInt(object.toString())) == 2200) {
                return LinieParameter.GEB_ABBR;
            }
            object = this.getAttribute("hochhaus");
            if (object != null && IFormat.parseBoolean(object.toString())) {
                if (this.isOird()) {
                    return LinieParameter.GEB_HHS_OIRD;
                }
                return LinieParameter.GEB_HHS;
            }
            if (this.isOird()) {
                return LinieParameter.GEB_OIRD;
            }
            if (this.isUird()) {
                return LinieParameter.GEB_UIRD;
            }
            return LinieParameter.GEB;
        }
        if (n == 31002) {
            if (this.getFunktion() == 1300) {
                if (this.isOird()) {
                    return LinieParameter.GEBT_HHS_OIRD;
                }
                return LinieParameter.GEBT_HHS;
            }
            if (this.isUird()) {
                return LinieParameter.GEBT_UIRD;
            }
            return LinieParameter.GEBT;
        }
        if (n == 31003) {
            return LinieParameter.GEB_BLIN;
        }
        if (n == 31004) {
            return LinieParameter.GEB_FLIN;
        }
        return LinieParameter.GEB;
    }

    @Override
    public boolean defMultiArea() {
        return false;
    }

    public Gebaeude(GebaeudeKennzeichen gebaeudeKennzeichen) {
        this.setLeitzeichen(gebaeudeKennzeichen);
    }

    @Override
    public void initGeom() {
        super.initGeom();
        if (!this.isVoid()) {
            Object object;
            if (this.hasLeitzeichen() && (double)this.leitzeichen.getAngle() == 0.0 && (object = this.getNearestDefLinie(new DPoint(this.leitzeichen.y, this.leitzeichen.x))) != null) {
                double d = ((Linie)object).getRichtung();
                if (d < 0.0) {
                    d += Math.PI;
                } else if (d > Math.PI) {
                    d -= Math.PI;
                }
                this.leitzeichen.setAngle(d);
            }
            if (this.hasKennzeichen()) {
                object = this.kennzeichen();
                while (object.hasMoreElements()) {
                    GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)object.nextElement();
                    Linie linie = this.getNearestDefLinie(gebaeudeKennzeichen.getHashPoint());
                    if (linie == null) continue;
                    double d = linie.getRichtung();
                    if (d < 0.0) {
                        d += Math.PI;
                    } else if (d > Math.PI) {
                        d -= Math.PI;
                    }
                    gebaeudeKennzeichen.setAngle(d);
                }
            }
        } else {
            Linie linie = this.getLongestLine();
            if (linie != null) {
                this.setTextAngle(linie.getRichtung());
            }
        }
    }

    public void setLeitzeichen(GebaeudeKennzeichen gebaeudeKennzeichen) {
        this.leitzeichen = gebaeudeKennzeichen;
        if (gebaeudeKennzeichen != null) {
            if (this.y == 0.0 && this.x == 0.0) {
                this.y = gebaeudeKennzeichen.y;
                this.x = gebaeudeKennzeichen.x;
            }
            gebaeudeKennzeichen.setGebaeude(this);
        }
    }

    public GebaeudeKennzeichen getLeitzeichen() {
        return this.leitzeichen;
    }

    public boolean hasLeitzeichen() {
        return this.leitzeichen != null;
    }

    @Override
    public boolean isVoid() {
        return this.leitzeichen == null;
    }

    @Override
    public void deleteName() {
        this.leitzeichen = null;
        this.count = 0;
    }

    public boolean hasKennzeichen() {
        return this.kennzeichen != null && !this.kennzeichen.isEmpty();
    }

    public void addKennzeichen(GebaeudeKennzeichen gebaeudeKennzeichen) {
        if (this.kennzeichen == null) {
            this.kennzeichen = new Vector();
        }
        this.kennzeichen.addElement(gebaeudeKennzeichen);
        gebaeudeKennzeichen.setGebaeude(this);
    }

    public Enumeration kennzeichen() {
        return this.kennzeichen.elements();
    }

    public GebaeudeKennzeichen kennzeichenAt(int n) {
        if (this.kennzeichen == null) {
            return null;
        }
        return (GebaeudeKennzeichen)this.kennzeichen.elementAt(n);
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void setTextAngle(double d) {
        super.setTextAngle(d);
        if (this.hasLeitzeichen() && (double)this.leitzeichen.getAngle() == 0.0) {
            this.leitzeichen.setAngle(d);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Gebaeude && this.compareTo(object) == 0 && this.count == ((Gebaeude)object).count;
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        Vector<Linie> vector = new Vector<Linie>();
        for (int i = 0; i < this.size(); ++i) {
            Linie linie = (Linie)this.elementAt(i);
            if (!linie.pa.isOn() || linie.pe != null && !linie.pe.isOn()) continue;
            if (linie.isEnde()) break;
            if (this.isUmringDefPunkt(linie.pa) && this.isUmringDefPunkt(linie.pe)) {
                if (!this.isUmringDefLinie(linie) || vector.contains(linie)) continue;
                vector.addElement(linie);
                continue;
            }
            if (exceptionList == null) continue;
            if (!this.isUmringDefPunkt(linie.pa)) {
                exceptionList.addException(new GeomException(linie.pa, new DLine(linie.pa, linie.pe), "Punkt " + linie.pa.nr + " ist kein g\u00fcltiger Linienendpunkt"));
            }
            if (this.isUmringDefPunkt(linie.pe)) continue;
            exceptionList.addException(new GeomException(linie.pe, new DLine(linie.pa, linie.pe), "Punkt " + linie.pe.nr + " ist kein g\u00fcltiger Linienendpunkt"));
        }
        return vector;
    }

    protected boolean isUmringDefPunkt(Punkt punkt) {
        return punkt.getKafPa() == 1 || punkt.getKafPa() == 2;
    }

    protected boolean isUmringDefLinie(Linie linie) {
        if (linie.getLa() == 2) {
            return true;
        }
        if (linie.getLa() == 3) {
            switch (linie.getOska()) {
                case 0: 
                case 1011: 
                case 1012: 
                case 1013: 
                case 1014: {
                    return true;
                }
                case 31001: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getName() {
        return this.getObjectName();
    }

    @Override
    public int compareTo(Object object) {
        Gebaeude gebaeude = (Gebaeude)object;
        if (this.hasLeitzeichen()) {
            if (gebaeude.hasLeitzeichen()) {
                return this.getLeitzeichen().compareTo(gebaeude.getLeitzeichen());
            }
            return -1;
        }
        if (gebaeude.hasLeitzeichen()) {
            return 1;
        }
        if (this.getOska() > gebaeude.getOska()) {
            return 1;
        }
        if (this.getOska() < gebaeude.getOska()) {
            return -1;
        }
        if (this.count == gebaeude.count) {
            return 0;
        }
        if (this.count > gebaeude.count) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getClassName() {
        int n = this.getOska();
        if (n == 31002) {
            return "Bauteil";
        }
        if (n == 31003) {
            return "BesondereGeb\u00e4udeLinie";
        }
        if (n == 31004) {
            return "FirstLinie";
        }
        return "Geb\u00e4ude";
    }

    @Override
    public String getObjectName() {
        if (this.leitzeichen != null) {
            return this.leitzeichen.getObjectName();
        }
        if (this.getOska() == 31001) {
            return "o.Nr. (" + this.count + ")";
        }
        return "(" + this.count + ")";
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    /*
     * Unable to fully structure code
     */
    public static DataContainer parseDatLine(String var0) throws IException {
        var1_1 = new Gebaeude();
        if (var0 != null) {
            var2_2 = new StringTokenizer(var0);
            var3_3 = 0;
            while (var2_2.hasMoreTokens()) {
                block30: {
                    var4_4 = var2_2.nextToken();
                    if (var3_3 == 0 && Character.isDigit(var4_4.charAt(0))) {
                        var5_5 = new GebaeudeKennzeichen();
                        if (KafkaIOProperties.datVersion == 3 && var4_4.indexOf("/") < 0 && var4_4.indexOf("-") < 0) {
                            try {
                                var5_5.setGemeinde(Integer.parseInt(var4_4.substring(0, 8)));
                                var5_5.setStrasse(Integer.parseInt(var4_4.substring(8, 13)));
                                var5_5.setHausNummer(Integer.parseInt(var4_4.substring(13, 17)));
                                if (!var2_2.hasMoreTokens()) ** GOTO lbl56
                                var4_4 = var2_2.nextToken();
                                if (Character.isDigit(var4_4.charAt(0))) {
                                    var5_5.setLfdNummer(Integer.parseInt(var4_4));
                                }
                                var5_5.setAdressenZusatz(var4_4);
                                if (!var2_2.hasMoreTokens()) ** GOTO lbl56
                                var4_4 = var2_2.nextToken();
                                var5_5.setLfdNummer(Integer.parseInt(var4_4));
                            }
                            catch (Exception var6_9) {
                                throw new IException("unzul\u00e4ssige Zeichen im Geb\u00e4udekennzeichen");
                            }
                        } else {
                            var6_8 = new StringTokenizer(var4_4, "-/\\.");
                            var7_10 = 0;
                            var8_12 = 0;
                            while (var6_8.hasMoreTokens()) {
                                var9_13 = var6_8.nextToken();
                                try {
                                    switch (var7_10) {
                                        case 0: {
                                            var8_12 = Integer.parseInt(var9_13);
                                            var5_5.setGemeinde(var8_12);
                                            break;
                                        }
                                        case 1: {
                                            var5_5.setStrasse(Strasse.parseKey(var8_12, var9_13));
                                            break;
                                        }
                                        case 2: {
                                            var10_14 = 0;
                                            if (var9_13.startsWith("p") || var9_13.startsWith("P")) {
                                                var5_5.setPseudoNummer(true);
                                                var10_14 = 1;
                                            }
                                            var5_5.setHausNummer(Integer.parseInt(var9_13.substring(var10_14, Math.min(var10_14 + 4, var9_13.length()))));
                                            if (var9_13.length() <= var10_14 + 4) break;
                                            var5_5.setAdressenZusatz(var9_13.substring(var10_14 + 4, var9_13.length()));
                                            break;
                                        }
                                        case 3: {
                                            var5_5.setLfdNummer(Integer.parseInt(var9_13));
                                        }
                                    }
                                }
                                catch (Exception var10_15) {
                                    throw new IException("unzul\u00e4ssige Zeichen im Geb\u00e4udekennzeichen");
                                }
                                ++var7_10;
                            }
                        }
lbl56:
                        // 5 sources

                        var1_1.setLeitzeichen(var5_5);
                    } else {
                        try {
                            var5_6 = var4_4.indexOf(61);
                            var6_8 = var4_4.substring(0, var5_6);
                            var7_11 = var4_4.substring(var5_6 + 1);
                            if (var6_8.equalsIgnoreCase("O")) {
                                var8_12 = var7_11.indexOf(".");
                                if (var8_12 > 0) {
                                    var1_1.setFolie(Integer.parseInt(var7_11.substring(0, var8_12)));
                                    var1_1.setOska(Integer.parseInt(var7_11.substring(var8_12 + 1)));
                                } else {
                                    var1_1.setOska(Integer.parseInt(var7_11));
                                }
                                break block30;
                            }
                            if (var6_8.equalsIgnoreCase("Y")) {
                                var1_1.y = Double.valueOf(var7_11);
                                if (var1_1.hasLeitzeichen()) {
                                    var1_1.getLeitzeichen().y = var1_1.y;
                                }
                                break block30;
                            }
                            if (var6_8.equalsIgnoreCase("X")) {
                                var1_1.x = Double.valueOf(var7_11);
                                if (var1_1.hasLeitzeichen()) {
                                    var1_1.getLeitzeichen().x = var1_1.x;
                                }
                                break block30;
                            }
                            if (var6_8.equalsIgnoreCase("C")) {
                                var1_1.setColor(IFormat.parseColor(var7_11));
                                break block30;
                            }
                            if (var6_8.equalsIgnoreCase("F")) {
                                var1_1.setFunktion(Integer.parseInt(var7_11));
                                break block30;
                            }
                            throw new IException("unzul\u00e4ssige Variable: " + (String)var6_8);
                        }
                        catch (Exception var5_7) {
                            throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + var4_4);
                        }
                    }
                }
                ++var3_3;
            }
        }
        return var1_1;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Geb:");
        stringBuffer.append(" ");
        if (this.leitzeichen != null) {
            stringBuffer.append(this.leitzeichen.toDatLine());
            stringBuffer.append(" ");
        }
        if ((this.leitzeichen == null || !this.leitzeichen.hasLocation()) && this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_1.format(this.y));
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_1.format(this.x));
        }
        if (this.getOska() != 0) {
            stringBuffer.append(" O=");
            if (this.getFolie() > 0) {
                stringBuffer.append(IFormat.i03.format(this.getFolie()) + ".");
            }
            stringBuffer.append(this.getOska());
        }
        if (this.getFunktion() != 0) {
            stringBuffer.append(" F=");
            stringBuffer.append(Integer.toString(this.getFunktion()));
        }
        if (super.getColor() != null) {
            stringBuffer.append(" C=");
            stringBuffer.append(IFormat.colorString(super.getColor()));
        }
        if (this.hasKennzeichen()) {
            Enumeration enumeration = this.kennzeichen();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(IFormat.EOL);
                stringBuffer.append("C!Gkz:");
                stringBuffer.append(" ");
                stringBuffer.append(((GebaeudeKennzeichen)enumeration.nextElement()).toDatLine());
            }
        }
        return stringBuffer.toString();
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        Enumeration enumeration;
        printWriter.println(XmlIOProperties.openln("gebaeude"));
        if (this.hasLocation()) {
            printWriter.println(XmlIOProperties.data("y", IFormat.f_3.format(this.y).toString()));
            printWriter.println(XmlIOProperties.data("x", IFormat.f_3.format(this.x).toString()));
        }
        if (this.getOska() != 0) {
            printWriter.println(XmlIOProperties.data("os", IFormat.i04.format(this.getOska()).toString()));
        }
        if (this.hasLeitzeichen()) {
            printWriter.println(this.leitzeichen.toXmlLine());
        }
        if (this.hasKennzeichen()) {
            enumeration = this.kennzeichen();
            while (enumeration.hasMoreElements()) {
                printWriter.println(((GebaeudeKennzeichen)enumeration.nextElement()).toXmlLine());
            }
        }
        printWriter.println(XmlIOProperties.open("linien"));
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Linie)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("linien"));
        printWriter.println(XmlIOProperties.close("gebaeude"));
    }

    public static String toZenoDefLine() {
        return "FID;VID;X;Y;Z;Lage;Funktion;Dach;Geschosse;H\u00f6he;Bild";
    }

    public void writeZenoLines(OutputStream outputStream, Charset charset, int n) throws IOException {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasLeitzeichen()) {
            stringBuffer.append(this.leitzeichen.createEntLage());
        }
        if (this.hasKennzeichen()) {
            object3 = this.kennzeichen();
            while (object3.hasMoreElements()) {
                object2 = (GebaeudeKennzeichen)object3.nextElement();
                stringBuffer.append(" ");
                stringBuffer.append(((GebaeudeKennzeichen)object2).createEntLage());
            }
        }
        stringBuffer.append(";");
        if (DataBase.model.getModel() == 2) {
            if (this.getOska() == 31001) {
                stringBuffer.append(Alkis.getAttributeValue(this.getOska(), "gebaeudefunktion", this.getFunktion()));
            } else if (this.getOska() == 31002) {
                stringBuffer.append(Alkis.getAttributeValue(this.getOska(), "bauart", this.getFunktion()));
            }
        } else {
            object3 = Oska.getOskaName(this.getOska());
            if (object3 != null) {
                stringBuffer.append((String)object3);
            }
        }
        stringBuffer.append(";");
        object3 = this.getAttribute("dachform");
        if (object3 != null) {
            object2 = Alkis.getAttributeValue(this.getOska(), "dachform", Integer.parseInt(object3.toString()));
            stringBuffer.append(object2 != null ? object2 : object3);
        }
        stringBuffer.append(";");
        object2 = this.getAttribute("anzahlDerUnterirdischenGeschosse");
        if (object2 != null) {
            stringBuffer.append("-" + object2.toString() + "/");
        }
        if ((object = this.getAttribute("anzahlDerOberirdischenGeschosse")) != null) {
            stringBuffer.append(object.toString());
        }
        stringBuffer.append(";");
        Object object4 = this.getAttribute("objekthoehe");
        if (object4 != null) {
            stringBuffer.append(object4.toString());
        }
        stringBuffer.append(";");
        super.writeZenoLines(outputStream, charset, n, stringBuffer.toString());
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        Enumeration enumeration;
        dataOutput.writeInt(this.flags);
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(this.getFolie());
        dataOutput.writeInt(this.getOska());
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeShort(this.count);
        dataOutput.writeShort(this.getFunktion());
        if (this.hasLeitzeichen()) {
            dataOutput.writeByte(54);
            this.leitzeichen.writeObject(dataOutput);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.hasKennzeichen()) {
            enumeration = this.kennzeichen();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(54);
                ((GebaeudeKennzeichen)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        dataOutput.writeByte(0);
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Linie)enumeration.nextElement()).writeObject(dataOutput);
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                ((ObjectDecor)enumeration.nextElement()).writeObject(dataOutput);
            }
        }
        if (this.att != null) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                dataOutput.writeByte(110);
                String string = (String)enumeration.nextElement();
                KafPlotIOConstants.writeString(dataOutput, string);
                KafPlotIOConstants.writeString(dataOutput, this.getAttribute(string).toString());
            }
        }
        dataOutput.writeByte(0);
    }

    public static Gebaeude readObject(DataInput dataInput) throws IOException {
        Gebaeude gebaeude = new Gebaeude();
        gebaeude.flags = dataInput.readInt();
        gebaeude.y = dataInput.readDouble();
        gebaeude.x = dataInput.readDouble();
        if (KpvIOProperties.RVER >= 106 && dataInput.readByte() != 0) {
            gebaeude.yt = dataInput.readDouble();
            gebaeude.xt = dataInput.readDouble();
        }
        gebaeude.setFolie(dataInput.readShort());
        if (KpvIOProperties.RVER >= 202) {
            gebaeude.setOska(dataInput.readInt());
        } else {
            gebaeude.setOska(dataInput.readShort());
        }
        gebaeude.setTextAngle(dataInput.readFloat());
        gebaeude.count = dataInput.readShort();
        if (KpvIOProperties.RVER >= 202) {
            gebaeude.setFunktion(dataInput.readShort());
        }
        if (dataInput.readByte() == 54) {
            gebaeude.leitzeichen = (GebaeudeKennzeichen)GebaeudeKennzeichen.readObject(dataInput);
            gebaeude.leitzeichen.setGebaeude(gebaeude);
            if (gebaeude.leitzeichen.x == 0.0 && gebaeude.leitzeichen.y == 0.0) {
                gebaeude.leitzeichen.x = gebaeude.x;
                gebaeude.leitzeichen.y = gebaeude.y;
            }
        }
        byte by = 0;
        while ((by = dataInput.readByte()) != -1 && by == 54) {
            gebaeude.addKennzeichen((GebaeudeKennzeichen)GebaeudeKennzeichen.readObject(dataInput));
        }
        while ((by = dataInput.readByte()) != -1) {
            if (by == 15) {
                gebaeude.addElement(Linie.readObject(dataInput));
                continue;
            }
            if (by == 61) {
                gebaeude.addDecor(ObjectText.readObject(dataInput));
                continue;
            }
            if (by == 62) {
                gebaeude.addDecor(ObjectSymbol.readObject(dataInput));
                continue;
            }
            if (by == 63) {
                gebaeude.addDecor(ObjectLine.readObject(dataInput));
                continue;
            }
            if (by != 110) break;
            gebaeude.setAttribute(KafPlotIOConstants.readString(dataInput), KafPlotIOConstants.readString(dataInput));
        }
        if (KpvIOProperties.RVER < 200) {
            gebaeude.setUntergang(false);
        }
        return gebaeude;
    }

    @Override
    protected void parseAttribute(String string, Object object) {
        super.parseAttribute(string, object);
        try {
            if (string.equals("bauart")) {
                this.setFunktion(Integer.parseInt(object.toString()));
            } else if (string.equals("zustand")) {
                this.setAbwZustand(true);
            } else if (string.equals("lageZurErdoberflaeche")) {
                int n = Integer.parseInt(object.toString());
                if (n == 1400) {
                    this.setOird(true);
                } else if (n == 1200 || n == 1700 || n == 1800 || n == 1810) {
                    this.setUird(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (bl2 || KafPlotProperties.isFlaecheFillVisible && KafPlotProperties.isGebFillVisible) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        if (bl2 || KafPlotProperties.isFlaechePolyVisible && KafPlotProperties.isGebPolyVisible) {
            this.drawForeground(iGraphics, bl, bl2);
        }
        if (KafPlotProperties.isFlaecheTextVisible) {
            this.drawInscription(iGraphics, bl, bl2);
        }
        if (bl2) {
            this.drawHashpoint(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!bl2) {
            if (this.isUntergang()) {
                return;
            }
            if (this.isUird()) {
                return;
            }
            if (this.getOska() == 31002) {
                return;
            }
        }
        Color color = null;
        if (KafPlotProperties.isShadowing) {
            color = KafPlotColor.DARK_SHADOW;
        } else {
            switch (KafPlotProperties.getColorSwitch()) {
                case 1009: {
                    color = IColor.getBrighter(KafPlotProperties.aBgColor.getColor("O"), 0.8f);
                    break;
                }
                case 1004: {
                    color = KafPlotProperties.aFoColor.getColor(this.isFortfuehrung() ? "G1" : "G0");
                    break;
                }
                case 1005: {
                    if (this.leitzeichen != null) {
                        color = KafPlotProperties.aLaColor.getColor(this.leitzeichen.getStrasse());
                        break;
                    }
                    color = KafPlotColor.BACKGROUND;
                    break;
                }
                case 1010: {
                    if (this.leitzeichen != null) {
                        color = KafPlotProperties.aAdColor.getColor(this.leitzeichen.getAdresseKey());
                        break;
                    }
                    color = KafPlotColor.BACKGROUND;
                    break;
                }
                case 1002: 
                case 1003: {
                    color = IColor.getDarker(KafPlotProperties.aNuColor.getColor(new Integer(this.getOska() / 10)), 0.8f);
                    break;
                }
                case 1006: {
                    if (DataBase.model.getModel() == 2) {
                        int n = Alkis.getGebaeudeFunctionGroup(this.funktion);
                        if (n == 1) {
                            color = KafPlotProperties.aKaColor.getColor("W");
                            break;
                        }
                        if (n == 2) {
                            color = KafPlotProperties.aKaColor.getColor("I");
                            break;
                        }
                        if (n == 3) {
                            color = KafPlotProperties.aKaColor.getColor("\u00d6");
                            break;
                        }
                        color = KafPlotProperties.aKaColor.getColor("O");
                        break;
                    }
                    switch (Oska.getGebaeudeDarstellung(this.getOska())) {
                        case 1: 
                        case 2: 
                        case 5: {
                            color = KafPlotProperties.aKaColor.getColor("W");
                            break;
                        }
                        case 4: 
                        case 6: {
                            color = KafPlotProperties.aKaColor.getColor("I");
                            break;
                        }
                        case 3: 
                        case 7: {
                            color = KafPlotProperties.aKaColor.getColor("O");
                            break;
                        }
                        default: {
                            color = KafPlotProperties.aKaColor.getDefaultColor();
                        }
                    }
                    if (this.getFolie() == 0 || this.getFolie() == 11) break;
                    color = IColor.getLighter(color, 0.4f);
                    break;
                }
                case 1007: 
                case 1008: 
                case 1011: {
                    return;
                }
                default: {
                    color = super.getColor();
                }
            }
        }
        iGraphics.getGraphics().setColor(color != null ? color : Ebene.getFlaecheColor(2));
        super.drawBackground(iGraphics, bl, bl2);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        Object object;
        Enumeration enumeration;
        if (!this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = null;
        color = KafPlotProperties.getColorSwitch() == 1001 ? Ebene.getColor(2) : (KafPlotProperties.getColorSwitch() == 1009 ? KafPlotProperties.aBgColor.getColor("O") : (KafPlotProperties.getColorSwitch() == 1004 ? (this.isFortfuehrung() ? Color.black : IColor.getDarker(KafPlotProperties.aFoColor.getColor("G0"), 0.85f)) : (KafPlotProperties.getColorSwitch() == 1006 ? (this.getFolie() == 0 || this.getFolie() == 11 ? Color.black : Color.gray) : Color.black)));
        graphics.setColor(color);
        double d = 0.0;
        if (this.hasLeitzeichen()) {
            d = (double)this.leitzeichen.getAngle() + iGraphics.getRotation();
            if (this.leitzeichen.hasLocation() && iGraphics.contains(this.leitzeichen.y, this.leitzeichen.x) && (KafPlotProperties.isGebNumberVisible && !this.leitzeichen.isPseudoNummer() && this.leitzeichen.getLfdNummer() == DataBase.model.getHauptHausLfdNummer() || KafPlotProperties.isGebLfdnrVisible && (this.leitzeichen.isPseudoNummer() || this.leitzeichen.getLfdNummer() > DataBase.model.getHauptHausLfdNummer()))) {
                Gebaeude.text.text = this.leitzeichen.getInscription();
                text.setTextWinkel((double)this.leitzeichen.getAngle() + iGraphics.getRotation());
                Gebaeude.sym.t = text;
                Gebaeude.sym.p = iGraphics.getGraphicPoint(this.leitzeichen.y, this.leitzeichen.x, p);
                sym.paint(graphics);
            }
        }
        if (this.hasKennzeichen() && KafPlotProperties.isGebNumberVisible) {
            enumeration = this.kennzeichen();
            while (enumeration.hasMoreElements()) {
                object = (GebaeudeKennzeichen)enumeration.nextElement();
                if (!((GebaeudeKennzeichen)object).hasLocation()) continue;
                if (d == 0.0) {
                    d = (double)((GebaeudeKennzeichen)object).getAngle() + iGraphics.getRotation();
                }
                if (!iGraphics.contains(((GebaeudeKennzeichen)object).y, ((GebaeudeKennzeichen)object).x)) continue;
                Gebaeude.text.text = ((GebaeudeKennzeichen)object).getInscription();
                text.setTextWinkel((double)((GebaeudeKennzeichen)object).getAngle() + iGraphics.getRotation());
                Gebaeude.sym.t = text;
                Gebaeude.sym.p = iGraphics.getGraphicPoint(((GebaeudeKennzeichen)object).y, ((GebaeudeKennzeichen)object).x, p);
                sym.paint(graphics);
            }
        }
        if (this.hasDecor()) {
            enumeration = this.decors();
            while (enumeration.hasMoreElements()) {
                object = (ObjectDecor)enumeration.nextElement();
                ((ObjectDecor)object).setColor(color);
                int n = ((ObjectDecor)object).getOska();
                if (object instanceof ObjectSymbol) {
                    if (!KafPlotProperties.isGebSymVisible) continue;
                    ((ObjectDecor)object).drawObject(iGraphics, bl, bl2);
                    continue;
                }
                if (n == 1033) {
                    if (!KafPlotProperties.isGebGschzVisible) continue;
                    ((ObjectDecor)object).drawObject(iGraphics, bl, bl2);
                    continue;
                }
                if (!KafPlotProperties.isGebNameVisible) continue;
                ((ObjectDecor)object).drawObject(iGraphics, bl, bl2);
            }
        }
        if (this.att != null && KafPlotProperties.isGebAttVisible) {
            enumeration = this.attributes();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    Point point;
                    double d2;
                    double d3;
                    if (((String)object).equals("DFIHO")) {
                        double d4 = new Double(this.getAttribute("DFIRW").toString()) / 1000.0;
                        d3 = new Double(this.getAttribute("DFIHW").toString()) / 1000.0;
                        d2 = new Double(this.getAttribute("DFIHO").toString()) / 1000.0;
                        if (!iGraphics.contains(d4, d3)) continue;
                        point = iGraphics.getGraphicPoint(d4, d3, p);
                        graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
                        graphics.drawLine(point.x - 2, point.y + 2, point.x + 2, point.y - 2);
                        Gebaeude.attText.text = "DFI=" + IFormat.f_2.format(d2);
                        attText.setTextWinkel(d);
                        Gebaeude.attSym.t = attText;
                        Gebaeude.attSym.p = point;
                        attSym.paint(graphics);
                        continue;
                    }
                    if (!((String)object).equals("FOKHO")) continue;
                    double d5 = new Double(this.getAttribute("FOKRW").toString()) / 1000.0;
                    d3 = new Double(this.getAttribute("FOKHW").toString()) / 1000.0;
                    d2 = new Double(this.getAttribute("FOKHO").toString()) / 1000.0;
                    if (!iGraphics.contains(d5, d3)) continue;
                    point = iGraphics.getGraphicPoint(d5, d3, p);
                    graphics.drawLine(point.x - 2, point.y - 2, point.x + 2, point.y + 2);
                    graphics.drawLine(point.x - 2, point.y + 2, point.x + 2, point.y - 2);
                    Gebaeude.attText.text = "FOK=" + IFormat.f_2.format(d2);
                    attText.setTextWinkel(d);
                    Gebaeude.attSym.t = attText;
                    Gebaeude.attSym.p = point;
                    attSym.paint(graphics);
                }
                catch (Exception exception) {}
            }
        }
    }

    public String toString() {
        return this.getExceptionableName();
    }
}

