/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.GebaeudeKennzeichen;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Oska;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kataster.model.Alkis;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class GebaeudeInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    protected static final String GMD_COMMAND = "_Gemeinde";
    protected static final String STR_COMMAND = "_Strasse";
    private Label gmdLabel;
    private Label strLabel;
    private Label hsnrLabel;
    private Label oskaLabel;
    private Label artLabel;
    private Button gmdButton;
    private Button strButton;
    private GebaeudeKennzeichen leitzeichen;

    public GebaeudeInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Gebaeude)null);
    }

    public GebaeudeInfoDialog(IFrame iFrame, String string, Gebaeude gebaeude) {
        super(iFrame, string, gebaeude);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(0));
        this.gmdButton = new Button("...");
        iPanel.add(this.gmdButton);
        this.gmdButton.setActionCommand(GMD_COMMAND);
        this.gmdButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.gmdButton, gridBagConstraints);
        Label label = new Label("Gemeinde: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.gmdLabel = new Label("", 0);
        iPanel.add(this.gmdLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.gmdLabel, gridBagConstraints);
        this.strButton = new Button("...");
        iPanel.add(this.strButton);
        this.strButton.setActionCommand(STR_COMMAND);
        this.strButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.strButton, gridBagConstraints);
        label = new Label("Stra\u00dfe: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.strLabel = new Label("", 0);
        iPanel.add(this.strLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.strLabel, gridBagConstraints);
        label = new Label("Nummer: ", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.hsnrLabel = new Label("", 0);
        iPanel.add(this.hsnrLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.hsnrLabel, gridBagConstraints);
        label = new Label("Oska:", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.oskaLabel = new Label("", 0);
        iPanel.add(this.oskaLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.oskaLabel, gridBagConstraints);
        label = new Label("Funktion:", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.artLabel = new Label("", 0);
        iPanel.add(this.artLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.artLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(4);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Gemeinde", 0), new ITableCell("Stra\u00dfe", 0), new ITableCell("Hausnummer", 0), new ITableCell("lfd. Nummer", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        Gebaeude gebaeude = (Gebaeude)object;
        this.table.removeLines();
        if (object != null && gebaeude.hasLeitzeichen()) {
            this.leitzeichen = gebaeude.getLeitzeichen();
            this.addObjectToTable(gebaeude, gebaeude.getLeitzeichen());
            if (gebaeude.hasKennzeichen()) {
                Enumeration enumeration = gebaeude.kennzeichen();
                while (enumeration.hasMoreElements()) {
                    this.addObjectToTable(gebaeude, (GebaeudeKennzeichen)enumeration.nextElement());
                }
            }
        }
        this.table.doLayout();
        this.table.requestFocus();
    }

    public void setObjects(Enumeration enumeration) {
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            Gebaeude gebaeude = (Gebaeude)enumeration.nextElement();
            if (!gebaeude.hasLeitzeichen()) continue;
            this.leitzeichen = gebaeude.getLeitzeichen();
            this.addObjectToTable(gebaeude, gebaeude.getLeitzeichen());
            if (!gebaeude.hasKennzeichen()) continue;
            Enumeration enumeration2 = gebaeude.kennzeichen();
            while (enumeration2.hasMoreElements()) {
                this.addObjectToTable(gebaeude, (GebaeudeKennzeichen)enumeration2.nextElement());
            }
        }
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    protected void showObject(Object object) {
        if (object != null && (object instanceof Gebaeude || object instanceof GebaeudeKennzeichen)) {
            Object object2;
            Object object3;
            Gebaeude gebaeude = null;
            GebaeudeKennzeichen gebaeudeKennzeichen = null;
            if (object instanceof Gebaeude) {
                gebaeude = (Gebaeude)object;
                gebaeudeKennzeichen = gebaeude.getLeitzeichen();
            } else {
                gebaeudeKennzeichen = (GebaeudeKennzeichen)object;
                gebaeude = gebaeudeKennzeichen.getGebaeude();
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (gebaeudeKennzeichen != null) {
                object3 = Gemeinde.getGemeinde(gebaeudeKennzeichen.getGemeinde());
                object2 = "(" + gebaeudeKennzeichen.getGemeindeAsString() + ") " + (object3 != null ? ((Gemeinde)object3).getName() : "");
                this.gmdLabel.setText((String)object2);
                Strasse strasse = object3 != null ? ((Gemeinde)object3).getStrasse(gebaeudeKennzeichen.getStrasse()) : null;
                object2 = "(" + gebaeudeKennzeichen.getStrasseAsString() + ") " + (strasse != null ? strasse.getName() : "");
                this.strLabel.setText((String)object2);
                if (gebaeudeKennzeichen.isPseudoNummer()) {
                    stringBuffer.append("(Pseudo) ");
                }
                stringBuffer.append(gebaeudeKennzeichen.getHausNummerAsString());
                if (gebaeudeKennzeichen.getAdressenZusatz() != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append(gebaeudeKennzeichen.getAdressenZusatz());
                }
                this.hsnrLabel.setText(stringBuffer.toString());
            } else {
                this.gmdLabel.setText("");
                this.strLabel.setText("");
                this.hsnrLabel.setText("");
            }
            if (gebaeude.getOska() > 0) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("(" + gebaeude.getOska() + ") ");
                object3 = Alkis.getObjectName(gebaeude.getOska());
                if (object3 != null) {
                    stringBuffer.append((String)object3);
                }
                this.oskaLabel.setText(stringBuffer.toString());
                if (DataBase.model.getModel() == 2) {
                    if (gebaeude.getOska() == 31001) {
                        object2 = Alkis.getAttributeValue(gebaeude.getOska(), "gebaeudefunktion", gebaeude.getFunktion());
                        this.artLabel.setText("(" + gebaeude.getFunktion() + ") " + (String)(object2 != null ? object2 : ""));
                    } else if (gebaeude.getOska() == 31002) {
                        object2 = Alkis.getAttributeValue(gebaeude.getOska(), "bauart", gebaeude.getFunktion());
                        this.artLabel.setText("(" + gebaeude.getFunktion() + ") " + (String)(object2 != null ? object2 : ""));
                    }
                } else {
                    object2 = Oska.getOskaName(gebaeude.getOska());
                    this.artLabel.setText((String)(object2 != null ? object2 : ""));
                }
            } else {
                this.oskaLabel.setText("");
                this.artLabel.setText("");
            }
        } else {
            this.gmdLabel.setText("");
            this.strLabel.setText("");
            this.hsnrLabel.setText("");
            this.oskaLabel.setText("");
            this.artLabel.setText("");
        }
    }

    private void addObjectToTable(Gebaeude gebaeude, Object object) {
        GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)object;
        ITableCell[] iTableCellArray = new ITableCell[4];
        iTableCellArray[0] = new ITableCell(gebaeudeKennzeichen.getGemeindeAsString(), 0);
        iTableCellArray[1] = new ITableCell(gebaeudeKennzeichen.getStrasseAsString(), 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (gebaeudeKennzeichen.isPseudoNummer()) {
            stringBuffer.append("(Pseudo) ");
        }
        stringBuffer.append(gebaeudeKennzeichen.getHausNummerAsString());
        if (gebaeudeKennzeichen.getAdressenZusatz() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(gebaeudeKennzeichen.getAdressenZusatz());
        }
        iTableCellArray[2] = new ITableCell(stringBuffer.toString(), 0);
        iTableCellArray[3] = new ITableCell(gebaeudeKennzeichen.getLfdNummerAsString(), 0);
        iTableCellArray[0].setEventable(true);
        iTableCellArray[1].setEventable(true);
        this.table.addLine(new ITableLine(iTableCellArray, gebaeudeKennzeichen));
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)iTableEvent.getContent();
        this.object = gebaeudeKennzeichen;
        this.showObject(gebaeudeKennzeichen);
        if (iTableEvent.getClickCount() > 1) {
            if (iTableEvent.getCol() == 0 && this.elementListener != null) {
                this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), Gemeinde.getGemeinde(gebaeudeKennzeichen.getGemeinde()), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
            } else if (iTableEvent.getCol() == 1 && this.elementListener != null) {
                Strasse strasse;
                Gemeinde gemeinde = Gemeinde.getGemeinde(gebaeudeKennzeichen.getGemeinde());
                Strasse strasse2 = strasse = gemeinde != null ? gemeinde.getStrasse(gebaeudeKennzeichen.getStrasse()) : null;
                if (strasse == null) {
                    strasse = new Strasse();
                }
                this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), strasse, iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
            } else if (this.actionListener != null && this.actionCommand != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(GMD_COMMAND) && this.leitzeichen != null) {
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), Gemeinde.getGemeinde(this.leitzeichen.getGemeinde()), actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else if (string.equals(STR_COMMAND) && this.leitzeichen != null) {
            Gemeinde gemeinde = Gemeinde.getGemeinde(this.leitzeichen.getGemeinde());
            Strasse strasse = gemeinde != null ? gemeinde.getStrasse(this.leitzeichen.getStrasse()) : new Strasse();
            this.elementListener.elementClicked(new ElementInfoEvent(actionEvent.getSource(), strasse, actionEvent.getID(), 2, actionEvent.getModifiers()));
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

