/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.AngleElement;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Gebaeude;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public final class GebaeudeKennzeichen
extends DPoint
implements DatObject,
Comparable,
Exceptionable,
AngleElement {
    public double yt;
    public double xt;
    private int gemeinde;
    private int strasse;
    private int hausNummer;
    private int lfdNummer = 1;
    private String adrZusatz = null;
    private boolean isPseudoNr = false;
    private float w;
    private Gebaeude geb;

    public GebaeudeKennzeichen() {
    }

    public GebaeudeKennzeichen(int n, int n2, int n3, String string, int n4, boolean bl) {
        this.gemeinde = n;
        this.strasse = n2;
        this.hausNummer = n3;
        this.adrZusatz = string;
        this.lfdNummer = n4;
        this.isPseudoNr = bl;
    }

    public void setGebaeude(Gebaeude gebaeude) {
        this.geb = gebaeude;
    }

    public Gebaeude getGebaeude() {
        return this.geb;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    public void setGemeinde(int n) {
        this.gemeinde = n;
    }

    public int getGemeinde() {
        return this.gemeinde;
    }

    public String getGemeindeAsString() {
        return IFormat.i08.format(this.gemeinde).toString();
    }

    public void setStrasse(int n) {
        this.strasse = n;
    }

    public int getStrasse() {
        return this.strasse;
    }

    public String getStrasseAsString() {
        return Strasse.toKeyString(this.gemeinde, this.strasse).toString();
    }

    public void setHausNummer(int n) {
        this.hausNummer = n;
    }

    public int getHausNummer() {
        return this.hausNummer;
    }

    public String getHausNummerAsString() {
        return IFormat.i.format(this.hausNummer).toString();
    }

    public void setLfdNummer(int n) {
        this.lfdNummer = n;
    }

    public int getLfdNummer() {
        return this.lfdNummer;
    }

    public String getLfdNummerAsString() {
        return this.lfdNummer > 0 ? IFormat.i03.format(this.lfdNummer).toString() : " ";
    }

    public void setPseudoNummer(boolean bl) {
        this.isPseudoNr = bl;
    }

    public boolean isPseudoNummer() {
        return this.isPseudoNr;
    }

    public void setAdressenZusatz(String string) {
        this.adrZusatz = string != null && string.length() > 3 ? string.substring(0, 3) : string;
    }

    public boolean hasAdressenZusatz() {
        return this.adrZusatz != null;
    }

    public String getAdressenZusatz() {
        return this.adrZusatz;
    }

    public boolean hasLocation() {
        return this.x != 0.0 && this.y != 0.0;
    }

    public int getAdresseKey() {
        if (this.isPseudoNr) {
            return this.strasse * 10000;
        }
        return this.strasse * 10000 + this.hausNummer * 100 + (this.adrZusatz != null ? Character.toUpperCase(this.adrZusatz.charAt(0)) - 65 + 1 : 0);
    }

    public boolean hasTextLocation() {
        return this.yt != 0.0 && this.xt != 0.0;
    }

    @Override
    public void setAngle(double d) {
        this.w = (float)d;
    }

    @Override
    public float getAngle() {
        return this.w;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GebaeudeKennzeichen) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public DPoint getHashPoint() {
        return this;
    }

    public boolean isVoid() {
        return this.gemeinde == 0 && this.strasse == 0 && this.hausNummer == 0;
    }

    @Override
    public final int compareTo(Object object) {
        GebaeudeKennzeichen gebaeudeKennzeichen = (GebaeudeKennzeichen)object;
        if (this.gemeinde == gebaeudeKennzeichen.gemeinde) {
            if (this.strasse == gebaeudeKennzeichen.strasse) {
                if (this.hausNummer == gebaeudeKennzeichen.hausNummer) {
                    if (this.adrZusatz != null && gebaeudeKennzeichen.adrZusatz != null && this.adrZusatz.equalsIgnoreCase(gebaeudeKennzeichen.adrZusatz) || this.adrZusatz == null && gebaeudeKennzeichen.adrZusatz == null) {
                        if (this.isPseudoNr == gebaeudeKennzeichen.isPseudoNr) {
                            if (this.lfdNummer == gebaeudeKennzeichen.lfdNummer) {
                                return 0;
                            }
                            return this.lfdNummer > gebaeudeKennzeichen.lfdNummer ? 1 : -1;
                        }
                        return this.isPseudoNr ? 1 : -1;
                    }
                    if (this.adrZusatz != null) {
                        if (gebaeudeKennzeichen.adrZusatz != null) {
                            return this.adrZusatz.toUpperCase().compareTo(gebaeudeKennzeichen.adrZusatz.toUpperCase());
                        }
                        return 1;
                    }
                    return -1;
                }
                return this.hausNummer > gebaeudeKennzeichen.hausNummer ? 1 : -1;
            }
            return this.strasse > gebaeudeKennzeichen.strasse ? 1 : -1;
        }
        return this.gemeinde > gebaeudeKennzeichen.gemeinde ? 1 : -1;
    }

    public String createEntLage() {
        Gemeinde gemeinde = Gemeinde.getGemeinde(this.getGemeinde());
        if (gemeinde == null) {
            return null;
        }
        Strasse strasse = gemeinde.getStrasse(this.getStrasse());
        if (strasse == null) {
            return null;
        }
        return this.createEntLage(strasse.getName());
    }

    public String createEntLage(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.getHausNummer());
        if (this.hasAdressenZusatz()) {
            stringBuffer.append(this.getAdressenZusatz());
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getClassName() {
        return "Geb\u00e4udekennzeichen";
    }

    @Override
    public final String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GeoNumberFormat.nr08n.format(this.gemeinde).toString());
        stringBuffer.append("-");
        stringBuffer.append(GeoNumberFormat.nr05n.format(this.strasse).toString());
        stringBuffer.append("-");
        if (this.isPseudoNr) {
            stringBuffer.append("P");
        }
        stringBuffer.append(GeoNumberFormat.nr04n.format(this.hausNummer).toString());
        if (this.adrZusatz != null) {
            stringBuffer.append(this.adrZusatz);
        }
        stringBuffer.append("-");
        stringBuffer.append(GeoNumberFormat.nr02n.format(this.lfdNummer).toString());
        return stringBuffer.toString();
    }

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClassName());
        stringBuffer.append(this.getObjectName());
        if (this.x != 0.0 && this.y != 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append("Y=");
            stringBuffer.append(GeoNumberFormat.koo01.format(this.y).toString());
            stringBuffer.append(" ");
            stringBuffer.append("X=");
            stringBuffer.append(GeoNumberFormat.koo01.format(this.x).toString());
        }
        return stringBuffer.toString();
    }

    public final String getInscription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lfdNummer == DataBase.model.getHauptHausLfdNummer()) {
            if (this.isPseudoNr) {
                stringBuffer.append("P ");
            }
            stringBuffer.append(this.hausNummer);
            if (this.adrZusatz != null) {
                stringBuffer.append(" ");
                stringBuffer.append(this.adrZusatz);
            }
        } else {
            stringBuffer.append("(");
            stringBuffer.append(this.lfdNummer);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static final GebaeudeKennzeichen parseOutFormat(String string) throws NumberFormatException {
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        if (string.length() == 24) {
            try {
                gebaeudeKennzeichen.gemeinde = Integer.parseInt(string.substring(0, 8));
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltiger Gemeindeschl\u00fcssel: " + string.substring(0, 8) + " in Geb\u00e4udekennzeichen: " + string);
            }
            try {
                gebaeudeKennzeichen.strasse = Integer.parseInt(string.substring(8, 13));
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltiger Stra\u00dfenschl\u00fcssel: " + string.substring(8, 13) + " in Geb\u00e4udekennzeichen: " + string);
            }
            try {
                gebaeudeKennzeichen.hausNummer = Integer.parseInt(string.substring(13, 17));
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltige Hausnummer: " + string.substring(13, 17) + " in Geb\u00e4udekennzeichen: " + string);
            }
            try {
                String string2 = string.substring(18, 21).trim();
                if (string2.length() > 0) {
                    gebaeudeKennzeichen.adrZusatz = string2;
                }
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltige Adressenzusatz: " + string.substring(18, 21) + " in Geb\u00e4udekennzeichen: " + string);
            }
            try {
                if (string.charAt(21) == 'P' || string.charAt(21) == 'p') {
                    gebaeudeKennzeichen.isPseudoNr = true;
                }
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltige Pseudokennung: " + string.substring(21, 22) + " in Geb\u00e4udekennzeichen: " + string);
            }
            try {
                gebaeudeKennzeichen.lfdNummer = Integer.parseInt(string.substring(22, 24));
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltige lfd. Nummer: " + string.substring(22, 24) + " in Geb\u00e4udekennzeichen: " + string);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string3 = stringTokenizer.nextToken();
            if (n == 0) {
                try {
                    gebaeudeKennzeichen.gemeinde = Integer.parseInt(string3.substring(0, 8));
                }
                catch (Exception exception) {
                    throw new NumberFormatException("ung\u00fcltiger Gemeindeschl\u00fcssel: " + string3 + " in Geb\u00e4udekennzeichen: " + string);
                }
                ++n;
                if (string3.length() <= 8) continue;
                string3 = string3.substring(8);
            }
            if (n == 1) {
                try {
                    gebaeudeKennzeichen.strasse = Integer.parseInt(string3.substring(0, 5));
                }
                catch (Exception exception) {
                    throw new NumberFormatException("ung\u00fcltiger Stra\u00dfenschl\u00fcssel: " + string3 + " in Geb\u00e4udekennzeichen: " + string);
                }
                ++n;
                if (string3.length() <= 5) continue;
                string3 = string3.substring(5);
            }
            if (n == 2) {
                for (n2 = 0; n2 < string3.length() && Character.isDigit(string3.charAt(n2)); ++n2) {
                }
                try {
                    gebaeudeKennzeichen.hausNummer = Integer.parseInt(string3.substring(0, n2));
                }
                catch (Exception exception) {
                    throw new NumberFormatException("ung\u00fcltige Hausnummer: " + string3 + " in Geb\u00e4udekennzeichen: " + string);
                }
                if (string3.length() > n2) {
                    String string4 = string3.substring(n2, string3.length());
                    if (string4.length() > 3) {
                        throw new NumberFormatException("Adressenzusatz zu lang: " + string3 + " in Geb\u00e4udekennzeichen: " + string);
                    }
                    gebaeudeKennzeichen.adrZusatz = string4;
                }
                ++n;
                continue;
            }
            if (n != 3) continue;
            n2 = 0;
            if (string3.charAt(0) == 'P' || string3.charAt(0) == 'p') {
                gebaeudeKennzeichen.isPseudoNr = true;
                n2 = 1;
            }
            if (string3.length() <= n2) continue;
            try {
                gebaeudeKennzeichen.lfdNummer = Integer.parseInt(string3.substring(n2, string3.length()));
            }
            catch (Exception exception) {
                throw new NumberFormatException("ung\u00fcltige laufende Nummer: " + string3 + " in Geb\u00e4udekennzeichen: " + string);
            }
        }
        return gebaeudeKennzeichen.isVoid() ? null : gebaeudeKennzeichen;
    }

    public static final GebaeudeKennzeichen parseOutTextFormat(String string) throws NumberFormatException {
        char c;
        int n;
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        string = IFormat.getLetterAndDigit(string.trim());
        int n2 = 0;
        if (string.startsWith("p") || string.startsWith("P")) {
            gebaeudeKennzeichen.setPseudoNummer(true);
            n2 = 1;
        }
        for (n = n2; n < string.length() && !Character.isLetter(c = string.charAt(n)); ++n) {
        }
        try {
            gebaeudeKennzeichen.setHausNummer(Integer.parseInt(string.substring(n2, n).trim()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltige Hausnummer");
        }
        if (n < string.length()) {
            gebaeudeKennzeichen.setAdressenZusatz(string.substring(n).trim());
        }
        return gebaeudeKennzeichen.isVoid() ? null : gebaeudeKennzeichen;
    }

    public static final GebaeudeKennzeichen parseBspeLine(String string) throws NumberFormatException {
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        try {
            gebaeudeKennzeichen.setGemeinde(Integer.parseInt(string.substring(2, 10).trim()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltiger Gemeindeschl\u00fcssel");
        }
        try {
            gebaeudeKennzeichen.setStrasse(Strasse.parseKey(gebaeudeKennzeichen.getGemeinde(), string.substring(10, 15).trim()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltiger Stra\u00dfenschl\u00fcssel");
        }
        try {
            gebaeudeKennzeichen.setHausNummer(Integer.parseInt(string.substring(15, 19).trim()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltige Hausnummer");
        }
        try {
            String string2 = string.substring(20, 23).trim();
            if (string2.length() > 0) {
                gebaeudeKennzeichen.setAdressenZusatz(string2);
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltiger Adressenzusatz");
        }
        try {
            if (string.charAt(23) == 'P') {
                gebaeudeKennzeichen.setPseudoNummer(true);
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException("Ung\u00fcltige Pseudokennung");
        }
        try {
            gebaeudeKennzeichen.setLfdNummer(Integer.parseInt(string.substring(24, 26).trim()));
        }
        catch (Exception exception) {
            throw new NumberFormatException("ung\u00fcltige laufende Nummer");
        }
        return gebaeudeKennzeichen;
    }

    public static final GebaeudeKennzeichen parseDatLine(String string) throws NumberFormatException {
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n == 0) {
                    var5_5 = new StringTokenizer(string2, "/-");
                    var6_6 = 0;
                    while (var5_5.hasMoreTokens()) {
                        var7_7 = var5_5.nextToken();
                        switch (var6_6) {
                            case 0: {
                                try {
                                    gebaeudeKennzeichen.gemeinde = Integer.parseInt(var7_7);
                                    break;
                                }
                                catch (Exception exception) {
                                    throw new NumberFormatException("Gemeindeschl\u00fcssel nicht numerisch");
                                }
                            }
                            case 1: {
                                try {
                                    gebaeudeKennzeichen.strasse = Strasse.parseKey(gebaeudeKennzeichen.gemeinde, var7_7);
                                    break;
                                }
                                catch (Exception exception) {
                                    throw new NumberFormatException("Stra\u00dfenschl\u00fcssel ung\u00fcltig");
                                }
                            }
                            case 2: {
                                if (var7_7.length() == 0) {
                                    throw new NumberFormatException("Hausnummer fehlt");
                                }
                                boolean bl = false;
                                int n2 = 0;
                                int n3 = 0;
                                for (int i = 0; i < var7_7.length(); ++i) {
                                    char c = var7_7.charAt(i);
                                    if (i == 0 && (c == 'P' || c == 'p')) {
                                        gebaeudeKennzeichen.isPseudoNr = true;
                                        continue;
                                    }
                                    if (!Character.isDigit(c)) break;
                                    if (!bl) {
                                        n2 = i;
                                        bl = true;
                                    }
                                    n3 = i;
                                }
                                try {
                                    gebaeudeKennzeichen.hausNummer = Integer.parseInt(var7_7.substring(n2, n3 + 1));
                                }
                                catch (Exception exception) {
                                    throw new NumberFormatException("ung\u00fcltiger numerischer Teil der Hausnummer");
                                }
                                if (n3 + 1 >= var7_7.length()) break;
                                gebaeudeKennzeichen.adrZusatz = var7_7.substring(n3 + 1, var7_7.length());
                                break;
                            }
                            case 3: {
                                try {
                                    gebaeudeKennzeichen.lfdNummer = Integer.parseInt(var7_7);
                                    break;
                                }
                                catch (Exception exception) {
                                    throw new NumberFormatException("laufende Nummer nicht numerisch");
                                }
                            }
                            default: {
                                throw new NumberFormatException("Anzahl der Teilformate \u00fcberschritten: " + var7_7);
                            }
                        }
                        ++var6_6;
                    }
                } else {
                    var5_5 = new StringTokenizer(string2, "=");
                    while (var5_5.hasMoreTokens()) {
                        var6_6 = var5_5.countTokens();
                        if (var6_6 < 2) {
                            throw new NumberFormatException("Kennung oder Wert fehlen im Feld \"" + string2 + "\"");
                        }
                        if (var6_6 > 2) {
                            throw new NumberFormatException("ung\u00fcltiges Zeichen \"=\" ist im Wert \"" + string2 + "\" enthalten");
                        }
                        var7_7 = var5_5.nextToken();
                        String string3 = var5_5.nextToken();
                        if (var7_7.equals("X")) {
                            try {
                                gebaeudeKennzeichen.x = Double.valueOf(string3);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new NumberFormatException("ung\u00fcltiger Wert im Feld X");
                            }
                        }
                        if (var7_7.equals("Y")) {
                            try {
                                gebaeudeKennzeichen.y = Double.valueOf(string3);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new NumberFormatException("ung\u00fcltiger Wert im Feld Y");
                            }
                        }
                        if (var7_7.equals("x")) {
                            try {
                                gebaeudeKennzeichen.xt = Double.valueOf(string3);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new NumberFormatException("ung\u00fcltiger Wert im Feld x");
                            }
                        }
                        if (var7_7.equals("y")) {
                            try {
                                gebaeudeKennzeichen.yt = Double.valueOf(string3);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new NumberFormatException("ung\u00fcltiger Wert im Feld y");
                            }
                        }
                        if (var7_7.equals("W")) {
                            try {
                                gebaeudeKennzeichen.setAngle(Double.valueOf(string3) * Math.PI / 200.0);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new NumberFormatException("ung\u00fcltiger Wert im Feld y");
                            }
                        }
                        throw new NumberFormatException("ung\u00fcltiger Variable: " + var7_7);
                    }
                }
                ++n;
            }
        }
        return gebaeudeKennzeichen.isVoid() ? null : gebaeudeKennzeichen;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IFormat.i08.format(this.gemeinde).toString());
        stringBuffer.append("/");
        stringBuffer.append(Strasse.toKeyString(this.gemeinde, this.strasse));
        stringBuffer.append("/");
        if (this.isPseudoNr) {
            stringBuffer.append("P");
        }
        stringBuffer.append(IFormat.i04.format(this.hausNummer).toString());
        if (this.adrZusatz != null) {
            stringBuffer.append(this.adrZusatz);
        }
        stringBuffer.append("/");
        stringBuffer.append(IFormat.i02.format(this.lfdNummer).toString());
        if (this.hasLocation()) {
            stringBuffer.append(" ");
            stringBuffer.append("Y=");
            stringBuffer.append(IFormat.f_1.format(this.y).toString());
            stringBuffer.append(" ");
            stringBuffer.append("X=");
            stringBuffer.append(IFormat.f_1.format(this.x).toString());
        }
        if (this.hasTextLocation()) {
            stringBuffer.append(" ");
            stringBuffer.append("y=");
            stringBuffer.append(IFormat.f_1.format(this.yt).toString());
            stringBuffer.append(" ");
            stringBuffer.append("x=");
            stringBuffer.append(IFormat.f_1.format(this.xt).toString());
        }
        return stringBuffer.toString();
    }

    public final String toXmlLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlIOProperties.openln("kennzeichen"));
        stringBuffer.append(XmlIOProperties.dataln("gemd", IFormat.i08.format(this.gemeinde).toString()));
        stringBuffer.append(XmlIOProperties.dataln("strs", IFormat.i08.format(this.gemeinde).toString()));
        String[] stringArray = new String[]{XmlIOProperties.att("isp", this.isPseudoNr ? "ja" : "nein")};
        stringBuffer.append(XmlIOProperties.open("hsnr", stringArray));
        stringBuffer.append(Integer.toString(this.hausNummer));
        if (this.adrZusatz != null) {
            stringBuffer.append(this.adrZusatz);
        }
        stringBuffer.append(XmlIOProperties.closeln("hsnr"));
        stringBuffer.append(XmlIOProperties.dataln("lfnr", Integer.toString(this.lfdNummer)));
        if (this.x != 0.0 && this.y != 0.0) {
            stringBuffer.append(XmlIOProperties.dataln("y", IFormat.f_3.format(this.y).toString()));
            stringBuffer.append(XmlIOProperties.dataln("x", IFormat.f_3.format(this.x).toString()));
        }
        stringBuffer.append(XmlIOProperties.close("kennzeichen"));
        return stringBuffer.toString();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        if (this.y != 0.0 || this.x != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.y);
            dataOutput.writeDouble(this.x);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeInt(this.gemeinde);
        dataOutput.writeInt(this.strasse);
        dataOutput.writeShort(this.hausNummer);
        dataOutput.writeShort(this.lfdNummer);
        KafPlotIOConstants.writeString(dataOutput, this.adrZusatz);
        dataOutput.writeBoolean(this.isPseudoNr);
        dataOutput.writeFloat(this.w);
    }

    public static Object readObject(DataInput dataInput) throws IOException {
        GebaeudeKennzeichen gebaeudeKennzeichen = new GebaeudeKennzeichen();
        if (KpvIOProperties.RVER >= 106 && dataInput.readByte() != 0) {
            gebaeudeKennzeichen.y = dataInput.readDouble();
            gebaeudeKennzeichen.x = dataInput.readDouble();
        }
        if (KpvIOProperties.RVER >= 106 && dataInput.readByte() != 0) {
            gebaeudeKennzeichen.yt = dataInput.readDouble();
            gebaeudeKennzeichen.xt = dataInput.readDouble();
        }
        gebaeudeKennzeichen.gemeinde = dataInput.readInt();
        gebaeudeKennzeichen.strasse = dataInput.readInt();
        gebaeudeKennzeichen.hausNummer = dataInput.readShort();
        gebaeudeKennzeichen.lfdNummer = dataInput.readShort();
        gebaeudeKennzeichen.adrZusatz = KafPlotIOConstants.readString(dataInput);
        gebaeudeKennzeichen.isPseudoNr = dataInput.readBoolean();
        gebaeudeKennzeichen.w = dataInput.readFloat();
        return gebaeudeKennzeichen;
    }
}

