/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geodata.Feature;
import de.geocalc.geom.GeomException;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Gebaeude;

public class GebaeudeTable
extends DataContainerTable {
    private int countVoidGeb = 0;

    public GebaeudeTable() {
        this.reset();
    }

    public void reset() {
        this.countVoidGeb = 0;
    }

    @Override
    public void put(Feature feature) throws GeomException {
        Gebaeude gebaeude = (Gebaeude)feature;
        if (gebaeude.isVoid() && gebaeude.getCount() == 0) {
            gebaeude.setCount(++this.countVoidGeb);
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            Gebaeude gebaeude2 = (Gebaeude)this.elementAt(i);
            int n = gebaeude2.compareTo(gebaeude);
            if (n < 0) {
                super.insertElementAt(gebaeude, i + 1);
                return;
            }
            if (n != 0) continue;
            gebaeude.setCount(gebaeude2.getCount() + 1);
            super.insertElementAt(gebaeude, i + 1);
            throw new GeomException(gebaeude.getHashPoint(), gebaeude.getPolygon(), gebaeude.getClassName() + ": " + gebaeude.getObjectName() + " ist doppelt vergeben");
        }
        super.insertElementAt(gebaeude, 0);
    }

    public void addElement(Feature feature) {
        Gebaeude gebaeude = (Gebaeude)feature;
        if (gebaeude.isVoid() && gebaeude.getCount() == 0) {
            gebaeude.setCount(++this.countVoidGeb);
        }
        super.addElement(gebaeude);
    }

    @Override
    public Feature get(Feature feature) {
        return null;
    }
}

