/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.SortableVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class Gemarkung
implements IntegerHashObject,
Comparable {
    private static final IntegerHashList gemarkungen = new IntegerHashList();
    private int nr;
    private String name;
    private Gemeinde gmd;

    public Gemarkung() {
    }

    public Gemarkung(int n, String string, Gemeinde gemeinde) {
        this.nr = n;
        this.name = string;
        this.gmd = gemeinde;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Gemarkung) {
            Gemarkung gemarkung = (Gemarkung)object;
            if (this.nr == gemarkung.getNummer()) {
                return 0;
            }
            if (this.nr > gemarkung.getNummer()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public final int intHashKey() {
        return this.nr;
    }

    public void setNummer(int n) {
        this.nr = n;
    }

    public int getNummer() {
        return this.nr;
    }

    public String getNummerAsString() {
        return IFormat.i06.format(this.nr);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Gemeinde getGemeinde() {
        return this.gmd;
    }

    public void setGemeinde(Gemeinde gemeinde) {
        this.gmd = gemeinde;
    }

    public String toString() {
        return this.name;
    }

    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer("C!KatGmk:");
        stringBuffer.append(' ');
        stringBuffer.append(this.gmd.getNummer());
        stringBuffer.append('.');
        stringBuffer.append(this.getNummer());
        stringBuffer.append(' ');
        stringBuffer.append("L=");
        stringBuffer.append(this.getName().replace(' ', '_'));
        return stringBuffer.toString();
    }

    public static Gemarkung parseDatLine(String string) throws IException {
        Object object;
        Gemarkung gemarkung = new Gemarkung();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IException("Gemarkungskennzeichen fehlt");
        }
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-/\\.");
        if (stringTokenizer2.countTokens() != 2) {
            throw new IException("ung\u00fcltiges Gemarkungskennzeichen: " + string2);
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(stringTokenizer2.nextToken());
            n2 = Integer.parseInt(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            throw new IException("Gemarkungskennzeichen nicht numerisch: " + string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n3 = ((String)object).indexOf("=");
            if (n3 < 0) {
                throw new IException("Kennung oder Wert fehlen im Feld \"" + (String)object + "\"");
            }
            String string3 = ((String)object).substring(0, n3);
            String string4 = ((String)object).substring(n3 + 1);
            if (!string3.equalsIgnoreCase("L")) continue;
            gemarkung.setName(string4.replace('_', ' '));
        }
        if (gemarkung.getName() == null) {
            throw new IException("Angabe Gemarkungsname fehlt");
        }
        gemarkung.setNummer(n2);
        object = Gemeinde.getGemeinde(n);
        if (object == null) {
            throw new IException("Gemeindeschl\u00fcssel " + n + " nicht in Katalogliste enthalten");
        }
        gemarkung.setGemeinde((Gemeinde)object);
        ((Gemeinde)object).addGemarkung(gemarkung);
        return gemarkung;
    }

    public String toXmlLine() {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.nr)), XmlIOProperties.att("name", this.name)};
        return XmlIOProperties.data("gemarkung", stringArray);
    }

    public static Enumeration elements() {
        return gemarkungen.elements();
    }

    public static Enumeration sortedElements() {
        SortableVector sortableVector = new SortableVector(Gemarkung.elements());
        sortableVector.sort();
        return sortableVector.elements();
    }

    public static Gemarkung getGemarkung(int n) {
        return (Gemarkung)gemarkungen.get(n);
    }

    public static Gemarkung getGemarkung(String string, String string2) {
        if (IFormat.hasOnlyNumbers(string2)) {
            try {
                return Gemarkung.getGemarkung(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Enumeration enumeration = gemarkungen.elements();
        while (enumeration.hasMoreElements()) {
            Gemarkung gemarkung = (Gemarkung)enumeration.nextElement();
            if (!(string == null ? string2.equals(gemarkung.getName()) : string.equals(gemarkung.getGemeinde().getName()) && string2.equals(gemarkung.getName()))) continue;
            return gemarkung;
        }
        return null;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nr);
        KafPlotIOConstants.writeString(dataOutput, this.name);
    }

    public static Gemarkung readObject(DataInput dataInput) throws IOException {
        Gemarkung gemarkung = new Gemarkung();
        gemarkung.nr = dataInput.readInt();
        gemarkung.name = KafPlotIOConstants.readString(dataInput);
        return gemarkung;
    }

    public static Gemarkung putGemarkung(Gemarkung gemarkung) {
        return (Gemarkung)gemarkungen.put(gemarkung);
    }

    public static void saveObject(Gemarkung gemarkung) {
        if (gemarkung == null) {
            throw new NullPointerException("Gemarkung");
        }
        gemarkungen.put(gemarkung);
    }

    public static void removeObject(Gemarkung gemarkung) {
        gemarkungen.remove(gemarkung);
    }

    public static void clear() {
        gemarkungen.clear();
    }
}

