/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.GemeindeInfoDialog;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class GemarkungInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
ItemListener {
    private Button gmdButton;
    private Choice gmdChoice;
    private IFrame parent;
    private Gemeinde gemeinde;

    public GemarkungInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null, false);
    }

    public GemarkungInfoDialog(IFrame iFrame, String string, Gemarkung gemarkung) {
        this(iFrame, string, gemarkung, false);
    }

    public GemarkungInfoDialog(IFrame iFrame, String string, Gemarkung gemarkung, boolean bl) {
        super(iFrame, string, gemarkung, bl);
        this.parent = iFrame;
        if (gemarkung == null && this.gmdChoice.getSelectedItem() != null) {
            this.setObject(Gemeinde.getGemeinde(Integer.parseInt(IFormat.getFirstNumbers(this.gmdChoice.getSelectedItem()))));
        }
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Gemeinde"));
        this.gmdChoice = new Choice();
        iPanel.add(this.gmdChoice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.gmdChoice, gridBagConstraints);
        this.gmdButton = new Button("...");
        iPanel.add(this.gmdButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.gmdButton, gridBagConstraints);
        this.gmdButton.addActionListener(this);
        Enumeration enumeration = Gemeinde.sortedElements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            this.gmdChoice.addItem(Integer.toString(gemeinde.getNummer()) + "  " + gemeinde.getName());
        }
        this.gmdChoice.addItemListener(this);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(2);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Schl\u00fcssel", 0), new ITableCell("Name", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof Gemeinde) {
            this.gemeinde = (Gemeinde)object;
            this.table.removeLines();
            if (this.gemeinde != null) {
                Enumeration enumeration = this.gemeinde.gemarkungen();
                while (enumeration.hasMoreElements()) {
                    Gemarkung gemarkung = (Gemarkung)enumeration.nextElement();
                    ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(IFormat.i05.format(gemarkung.getNummer()), 0), new ITableCell(gemarkung.getName(), -10)};
                    this.table.addLine(new ITableLine(iTableCellArray, gemarkung));
                }
                this.table.sort(0);
                this.table.repaint();
                this.gmdChoice.select(Integer.toString(this.gemeinde.getNummer()) + "  " + this.gemeinde.getName());
            }
            if (this.isModal()) {
                this.table.addTableListener(this);
            }
        } else if (object instanceof Gemarkung) {
            Gemarkung gemarkung = (Gemarkung)object;
            if (gemarkung != null && gemarkung.getGemeinde() != null && !gemarkung.getGemeinde().equals(this.gemeinde)) {
                this.setObject(gemarkung.getGemeinde());
            }
            this.table.select(gemarkung);
            super.setObject(gemarkung);
        }
    }

    @Override
    protected void showObject(Object object) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("...")) {
            GemeindeInfoDialog gemeindeInfoDialog = new GemeindeInfoDialog(this.parent, "Gemeinden ausw\u00e4hlen", null, true);
            gemeindeInfoDialog.setModal(true);
            if (this.getObject() instanceof Gemarkung) {
                gemeindeInfoDialog.setObject(((Gemarkung)this.getObject()).getGemeinde());
            }
            gemeindeInfoDialog.setVisible(true);
            this.setObject(gemeindeInfoDialog.getObject());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.setObject(iTableEvent.getContent());
        if (this.isModal() && iTableEvent.getClickCount() > 1) {
            this.endDialog();
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.gmdChoice && itemEvent.getStateChange() == 1) {
            this.setObject(Gemeinde.getGemeinde(Integer.parseInt(IFormat.getFirstNumbers(this.gmdChoice.getSelectedItem()))));
        }
    }
}

