/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.Gemarkung;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Strasse;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.xml.XmlIOProperties;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.SortableVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Gemeinde
implements IntegerHashObject,
Comparable,
DatObject {
    private static final IntegerHashList gemeinden = new IntegerHashList();
    private int nr;
    private String name;
    private Vector gemarkungen = new Vector();
    private IntegerHashList strassen = new IntegerHashList();

    public Gemeinde() {
    }

    public Gemeinde(int n, String string) {
        this.nr = n;
        this.name = string;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Gemeinde) {
            Gemeinde gemeinde = (Gemeinde)object;
            if (this.nr == gemeinde.getNummer()) {
                return 0;
            }
            if (this.nr > gemeinde.getNummer()) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public final int intHashKey() {
        return this.nr;
    }

    public boolean equals(Object object) {
        if (object instanceof Gemeinde) {
            return ((Gemeinde)object).getNummer() == this.nr;
        }
        return false;
    }

    public void setNummer(int n) {
        this.nr = n;
    }

    public int getNummer() {
        return this.nr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addGemarkung(Gemarkung gemarkung) {
        this.gemarkungen.addElement(gemarkung);
        Gemarkung.saveObject(gemarkung);
    }

    public void removeGemarkung(Gemarkung gemarkung) {
        Gemarkung.removeObject(gemarkung);
        for (int i = 0; i < this.gemarkungen.size(); ++i) {
            Gemarkung gemarkung2 = (Gemarkung)this.gemarkungen.elementAt(i);
            if (gemarkung.getNummer() != gemarkung.getNummer()) continue;
            this.gemarkungen.removeElementAt(i);
            return;
        }
    }

    public Enumeration gemarkungen() {
        return this.gemarkungen.elements();
    }

    public int countGemarkungen() {
        return this.gemarkungen.size();
    }

    public void addStrasse(Strasse strasse) {
        this.strassen.put(strasse);
    }

    public Strasse getStrasse(int n) {
        return (Strasse)this.strassen.get(n);
    }

    public Strasse getStrasse(String string) {
        return (Strasse)this.strassen.get(Strasse.parseKey(this.nr, string));
    }

    public Enumeration strassen() {
        return this.strassen.elements();
    }

    public int countStrassen() {
        return this.strassen.size();
    }

    public String toString() {
        return this.name;
    }

    public void writeDatContainer(PrintWriter printWriter) throws IOException {
        printWriter.println(this.toDatLine());
        SortableVector sortableVector = new SortableVector(this.gemarkungen());
        sortableVector.sort();
        Object object = sortableVector.elements();
        while (object.hasMoreElements()) {
            printWriter.println(((Gemarkung)object.nextElement()).toDatLine());
        }
        object = new SortableVector(this.strassen());
        ((SortableVector)object).sort();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Strasse)enumeration.nextElement()).toDatLine());
        }
    }

    @Override
    public String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer("C!KatGmd:");
        stringBuffer.append(' ');
        stringBuffer.append(this.getNummer());
        stringBuffer.append(' ');
        stringBuffer.append("L=");
        stringBuffer.append(this.getName().replace(' ', '_'));
        return stringBuffer.toString();
    }

    public static Gemeinde parseDatLine(String string) throws IException {
        Gemeinde gemeinde = new Gemeinde();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IException("Gemeindekennzeichen fehlt");
        }
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-/\\.");
        if (stringTokenizer2.countTokens() != 1) {
            throw new IException("ung\u00fcltiges Gemeindekennzeichen: " + string2);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            throw new IException("Gemeindekennzeichen nicht numerisch: " + string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf("=");
            if (n2 < 0) {
                throw new IException("Kennung oder Wert fehlen im Feld \"" + string3 + "\"");
            }
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            if (!string4.equalsIgnoreCase("L")) continue;
            gemeinde.setName(string5.replace('_', ' '));
        }
        if (gemeinde.getName() == null) {
            throw new IException("Angabe Gemeindebezeichnung fehlt");
        }
        gemeinde.setNummer(n);
        Gemeinde.putGemeinde(gemeinde);
        return gemeinde;
    }

    public void writeKatalog(PrintWriter printWriter) throws IOException {
        Object object;
        printWriter.print("GMD ");
        printWriter.print(this.getNummer());
        printWriter.print("=");
        printWriter.println(this.getName());
        SortableVector sortableVector = new SortableVector(this.gemarkungen.elements());
        sortableVector.sort();
        Object object2 = sortableVector.elements();
        while (object2.hasMoreElements()) {
            object = (Gemarkung)object2.nextElement();
            printWriter.print("gmk ");
            printWriter.print(((Gemarkung)object).getNummerAsString());
            printWriter.print(" \"");
            printWriter.print(((Gemarkung)object).getName());
            printWriter.println("\"");
        }
        object2 = new SortableVector(this.strassen.elements());
        ((SortableVector)object2).sort();
        object = ((Vector)object2).elements();
        while (object.hasMoreElements()) {
            Strasse strasse = (Strasse)object.nextElement();
            printWriter.print("str ");
            printWriter.print(strasse.getNummerAsString());
            printWriter.print(" \"");
            printWriter.print(strasse.getName());
            printWriter.println("\"");
        }
    }

    public void writeXmlLine(PrintWriter printWriter) throws IOException {
        String[] stringArray = new String[]{XmlIOProperties.att("id", Integer.toString(this.nr)), XmlIOProperties.att("name", this.name)};
        printWriter.println(XmlIOProperties.open("gemeinde", stringArray));
        Enumeration enumeration = this.gemarkungen();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Gemarkung)enumeration.nextElement()).toXmlLine());
        }
        enumeration = this.strassen();
        while (enumeration.hasMoreElements()) {
            printWriter.println(((Strasse)enumeration.nextElement()).toXmlLine());
        }
        printWriter.println(XmlIOProperties.close("gemeinde"));
    }

    public static int count() {
        return gemeinden.size();
    }

    public static Enumeration elements() {
        return gemeinden.elements();
    }

    public static Enumeration sortedElements() {
        SortableVector sortableVector = new SortableVector(Gemeinde.elements());
        sortableVector.sort();
        return sortableVector.elements();
    }

    public static void clear() {
        gemeinden.clear();
    }

    public static Gemeinde getGemeinde(int n) {
        return (Gemeinde)gemeinden.get(n);
    }

    public static Gemeinde putGemeinde(Gemeinde gemeinde) {
        return (Gemeinde)gemeinden.put(gemeinde);
    }

    public static Gemeinde getGemeinde(String string) {
        Enumeration enumeration = gemeinden.elements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            if (!gemeinde.getName().equals(string)) continue;
            return gemeinde;
        }
        return null;
    }

    public static void load(InputStream inputStream) throws IOException {
        boolean bl = false;
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            while ((string = lineNumberReader.readLine()) != null) {
                int n;
                if (string.length() == 0 || string.startsWith("#")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IOException("fehlende Werte");
                }
                String string2 = stringTokenizer.nextToken().trim();
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IOException("fehlende Werte");
                }
                String string3 = stringTokenizer.nextToken().trim();
                int n2 = string2.indexOf(".");
                if (n2 < 0) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("nicht numerischer Gemeindeschl\u00fcssel");
                    }
                    gemeinden.put(new Gemeinde(n, string3));
                    continue;
                }
                n = 0;
                int n3 = 0;
                try {
                    n = Integer.parseInt(string2.substring(0, n2));
                    n3 = Integer.parseInt(string2.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("nicht numerischer Schl\u00fcssel");
                }
                Gemeinde gemeinde = Gemeinde.getGemeinde(n);
                if (gemeinde == null) {
                    throw new IOException("Gemeindeschl\u00fcssel '" + n + "' nicht vorhanden");
                }
                gemeinde.addGemarkung(new Gemarkung(n3, string3, gemeinde));
            }
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        IntegerHashObject integerHashObject;
        dataOutput.writeInt(this.nr);
        KafPlotIOConstants.writeString(dataOutput, this.name);
        Enumeration enumeration = this.gemarkungen();
        while (enumeration.hasMoreElements()) {
            integerHashObject = (Gemarkung)enumeration.nextElement();
            dataOutput.writeByte(72);
            ((Gemarkung)integerHashObject).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
        enumeration = this.strassen();
        while (enumeration.hasMoreElements()) {
            integerHashObject = (Strasse)enumeration.nextElement();
            dataOutput.writeByte(73);
            ((Strasse)integerHashObject).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public static Gemeinde readObject(DataInput dataInput) throws IOException {
        IntegerHashObject integerHashObject;
        Gemeinde gemeinde = new Gemeinde();
        gemeinde.nr = dataInput.readInt();
        gemeinde.name = KafPlotIOConstants.readString(dataInput);
        while (dataInput.readByte() != 0) {
            integerHashObject = Gemarkung.readObject(dataInput);
            ((Gemarkung)integerHashObject).setGemeinde(gemeinde);
            gemeinde.addGemarkung((Gemarkung)integerHashObject);
        }
        while (dataInput.readByte() != 0) {
            integerHashObject = Strasse.readObject(dataInput);
            ((Strasse)integerHashObject).setGemeinde(gemeinde);
            gemeinde.addStrasse((Strasse)integerHashObject);
        }
        return gemeinde;
    }

    public static void saveObject(Gemeinde gemeinde) {
        if (gemeinde == null) {
            throw new NullPointerException("Gemeinde");
        }
        gemeinden.put(gemeinde);
    }

    public static void saveGemarkungen(PrintWriter printWriter, String string) {
        if (string != null) {
            printWriter.println(string);
        }
        Enumeration enumeration = Gemeinde.sortedElements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            printWriter.println("#");
            printWriter.println(gemeinde.getNummer() + "        = " + gemeinde.getName());
            SortableVector sortableVector = new SortableVector(gemeinde.gemarkungen());
            sortableVector.sort();
            Enumeration enumeration2 = sortableVector.elements();
            while (enumeration2.hasMoreElements()) {
                Gemarkung gemarkung = (Gemarkung)enumeration2.nextElement();
                printWriter.println(gemeinde.getNummer() + "." + gemarkung.getNummer() + " = " + gemarkung.getName());
            }
        }
    }

    public static void saveStrassen(PrintWriter printWriter, String string) {
        if (string != null) {
            printWriter.println(string);
        }
        SortableVector sortableVector = new SortableVector(gemeinden.elements());
        sortableVector.sort();
        Enumeration enumeration = sortableVector.elements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            if (gemeinde.strassen.size() == 0) continue;
            printWriter.println("# " + gemeinde.getName());
            printWriter.println("[" + gemeinde.getNummer() + "]");
            SortableVector sortableVector2 = new SortableVector(gemeinde.strassen());
            sortableVector2.sort();
            Enumeration enumeration2 = sortableVector2.elements();
            while (enumeration2.hasMoreElements()) {
                Strasse strasse = (Strasse)enumeration2.nextElement();
                printWriter.println(Strasse.toKeyString(gemeinde.getNummer(), strasse.getNummer()) + " = " + strasse.getName());
            }
        }
    }

    public static void writeDatContainerTable(PrintWriter printWriter) throws IOException {
        Enumeration enumeration = Gemeinde.sortedElements();
        while (enumeration.hasMoreElements()) {
            ((Gemeinde)enumeration.nextElement()).writeDatContainer(printWriter);
        }
    }
}

