/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.kafplot.Gemeinde;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.event.DataBaseEvent;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Enumeration;

public class GemeindeInfoDialog
extends ObjectInfoDialog
implements ITableListener {
    private Label nameLabel;
    private Label gmkLabel;
    private Label strLabel;

    public GemeindeInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, null, false);
    }

    public GemeindeInfoDialog(IFrame iFrame, String string, Gemeinde gemeinde) {
        this(iFrame, string, gemeinde, false);
    }

    public GemeindeInfoDialog(IFrame iFrame, String string, Gemeinde gemeinde, boolean bl) {
        super(iFrame, string, gemeinde, bl);
    }

    @Override
    protected Panel createInfoPanel() {
        if (this.isModal()) {
            return new Panel();
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Gemeindeinformation"));
        this.nameLabel = new Label("", 0);
        iPanel.add(this.nameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        this.gmkLabel = new Label("", 0);
        iPanel.add(this.gmkLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.gmkLabel, gridBagConstraints);
        this.strLabel = new Label("", 0);
        iPanel.add(this.strLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.strLabel, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(2);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Schl\u00fcssel", 0), new ITableCell("Name", -10)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        Enumeration enumeration = Gemeinde.elements();
        while (enumeration.hasMoreElements()) {
            Gemeinde gemeinde = (Gemeinde)enumeration.nextElement();
            ITableCell[] iTableCellArray2 = new ITableCell[]{new ITableCell(Integer.toString(gemeinde.getNummer()), 0), new ITableCell(gemeinde.getName(), -10)};
            iTable.addLine(new ITableLine(iTableCellArray2, gemeinde));
        }
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        this.table.select(object);
        super.setObject(object);
    }

    @Override
    public void showObject(Object object) {
        if (!this.isModal()) {
            Gemeinde gemeinde = (Gemeinde)object;
            if (gemeinde == null) {
                this.nameLabel.setText("");
                this.gmkLabel.setText("");
                this.strLabel.setText("");
            } else {
                this.table.select(gemeinde);
                this.nameLabel.setText(gemeinde.getName());
                this.gmkLabel.setText(gemeinde.countGemarkungen() + " Gemarkungen");
                this.strLabel.setText(gemeinde.countStrassen() + " Stra\u00dfen");
            }
        }
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.setObject(iTableEvent.getContent());
        if (this.isModal() && iTableEvent.getClickCount() > 1) {
            this.endDialog();
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }
}

