/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IProgressDialog;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.ggout.GeografFileTyp;
import de.geocalc.io.GeoFile;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.ImportOptionDialog;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.WldgeImportOptionDialog;
import de.geocalc.kafplot.io.AgaKooReader;
import de.geocalc.kafplot.io.AlbPrintReader;
import de.geocalc.kafplot.io.AlbReader;
import de.geocalc.kafplot.io.AlkReader;
import de.geocalc.kafplot.io.AlkisKooReader;
import de.geocalc.kafplot.io.CaddyKooReader;
import de.geocalc.kafplot.io.CsvErrorReader;
import de.geocalc.kafplot.io.CsvReader;
import de.geocalc.kafplot.io.Da040Reader;
import de.geocalc.kafplot.io.DatReader;
import de.geocalc.kafplot.io.DbkReader;
import de.geocalc.kafplot.io.EdbsReader;
import de.geocalc.kafplot.io.ErrorReader;
import de.geocalc.kafplot.io.EsriDigitReader;
import de.geocalc.kafplot.io.FreeFormatReader;
import de.geocalc.kafplot.io.GeografOutReader;
import de.geocalc.kafplot.io.GeografPunktReader;
import de.geocalc.kafplot.io.GgOutReader;
import de.geocalc.kafplot.io.GpsKooReader;
import de.geocalc.kafplot.io.GsbReader;
import de.geocalc.kafplot.io.GsiKooReader;
import de.geocalc.kafplot.io.IFileReader;
import de.geocalc.kafplot.io.IdbReader;
import de.geocalc.kafplot.io.K_SoftReader;
import de.geocalc.kafplot.io.KivReader;
import de.geocalc.kafplot.io.KpvReader;
import de.geocalc.kafplot.io.KpzReader;
import de.geocalc.kafplot.io.Lt3Reader;
import de.geocalc.kafplot.io.Lt6Reader;
import de.geocalc.kafplot.io.Lt7Reader;
import de.geocalc.kafplot.io.LtaReader;
import de.geocalc.kafplot.io.MessungParser;
import de.geocalc.kafplot.io.NasReader;
import de.geocalc.kafplot.io.PdbReader;
import de.geocalc.kafplot.io.PdkReader;
import de.geocalc.kafplot.io.RidReader;
import de.geocalc.kafplot.io.SystraKooReader;
import de.geocalc.kafplot.io.SystraOutReader;
import de.geocalc.kafplot.io.SystraReader;
import de.geocalc.kafplot.io.TflReader;
import de.geocalc.kafplot.io.TtpReader;
import de.geocalc.kafplot.io.UmnumReader;
import de.geocalc.kafplot.io.WldgeReader;
import de.geocalc.kafplot.io.ZenoTxtReader;
import de.geocalc.util.LongHashList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class GeoFileReader
extends IProgressDialog
implements Runnable {
    protected DataBase db;
    protected File inFile;
    protected URL url;
    private Thread thread;
    private GeoFile geoFile;
    IFileReader reader;
    String title;
    private int kooSystem;
    boolean canceled;
    boolean aborted;
    private File[] inFiles;

    public GeoFileReader(IFrame iFrame, String string, DataBase dataBase, URL uRL) {
        super(iFrame, string + (String)(uRL != null ? " [" + uRL.getFile() + "]" : " "));
        this.reader = null;
        this.title = "GeoFileReader";
        this.kooSystem = -1;
        this.canceled = false;
        this.aborted = false;
        this.inFiles = null;
        this.db = dataBase;
        this.url = uRL;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public GeoFileReader(IFrame iFrame, String string, DataBase dataBase, File file) {
        this(iFrame, string, dataBase, file, false);
    }

    public GeoFileReader(IFrame iFrame, String string, DataBase dataBase, File file, boolean bl) {
        block14: {
            super(iFrame, string + (String)(file != null ? " [" + file.getName() + "]" : " "), bl);
            this.reader = null;
            this.title = "GeoFileReader";
            this.kooSystem = -1;
            this.canceled = false;
            this.aborted = false;
            this.inFiles = null;
            this.db = dataBase;
            this.inFile = file;
            this.title = string;
            try {
                block13: {
                    try {
                        this.geoFile = new GeoFile(file);
                        this.reader = this.getReader(file, this.geoFile.getFileTyp(), dataBase);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.inFile = null;
                    }
                    catch (IOException iOException) {
                        this.inFile = null;
                    }
                    catch (Exception exception) {
                        this.geoFile = new GeoFile(file, -2);
                        this.reader = new FreeFormatReader(file, DataBase.P);
                        if (!((FreeFormatReader)this.reader).isReadable()) break block13;
                        this.addException(exception);
                    }
                }
                if (this.inFile != null && this.reader != null && this.geoFile != null) {
                    this.reader.setProgressViewer(this.progressBar);
                    this.reader.setEncoding(this.geoFile.getEncoding());
                    if (!this.isAutoMode() && this.geoFile != null) {
                        if (this.geoFile.getFileTyp() == 561 || this.geoFile.getFileTyp() == 562 || this.geoFile.getFileTyp() == 563) {
                            var6_9 = new WldgeImportOptionDialog(iFrame, "Importoptionen");
                            var6_9.setVisible(true);
                        } else {
                            var6_9 = new ImportOptionDialog(iFrame, "Importoptionen", this.geoFile, this.reader);
                            var6_9.setVisible(true);
                            this.canceled = ((ImportOptionDialog)var6_9).abort();
                        }
                    }
                    break block14;
                }
                if (this.isAutoMode()) {
                    System.out.println("Unbekanntes Format");
                    break block14;
                }
                if (this.inFile == null) {
                    throw new Exception("Datei " + file.getName() + " nicht vorhanden oder lesbar");
                }
                if (this.geoFile == null) {
                    throw new Exception("Unbekanntes Dateiformat");
                }
                throw new Exception("Kein Reader f\u00fcr das Dateiformat " + this.geoFile.getFileTypString() + " vorhanden");
            }
            catch (Exception exception) {
                this.addException(exception);
            }
        }
    }

    public GeoFileReader(IFrame iFrame, String string, DataBase dataBase, File[] fileArray, boolean bl) {
        this(iFrame, string, dataBase, fileArray[0], bl);
        this.inFiles = fileArray;
    }

    @Override
    protected synchronized boolean dialogAbort() {
        this.aborted = true;
        try {
            if (this.reader != null) {
                this.reader.userAbort();
            }
        }
        catch (Exception exception) {
            this.showError(exception);
        }
        this.endDialog();
        return true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    private void showError(Exception exception) {
        if (this.isAutoMode()) {
            System.out.println(exception.getMessage());
        } else {
            this.endDialog();
            ErrorDialog errorDialog = new ErrorDialog(this.parent, exception);
            errorDialog.setModal(true);
            errorDialog.setVisible(true);
        }
    }

    public int getKooSystem() {
        return this.kooSystem;
    }

    public void setKooSystem(int n) {
        if (this.kooSystem <= -1) {
            this.kooSystem = n;
        } else if (this.kooSystem != n) {
            this.kooSystem = -1;
        }
    }

    public void read() {
        this.thread = new Thread(this);
        this.thread.start();
        this.setVisible(true);
    }

    @Override
    public void run() {
        block31: {
            if (this.inFile != null) {
                try {
                    int n;
                    int n2 = n = this.geoFile != null ? this.geoFile.getFileTyp() : -2;
                    if (this.reader != null) {
                        this.reader.setExceptionList(this.exceptions);
                        Object object = this.title;
                        if (this.inFiles != null) {
                            object = this.title + " [ *." + GeoFile.getFileTypExtension(n) + "]";
                            int n3 = this.inFiles.length;
                            this.reader.prepareMultiReading();
                            for (int i = 0; i < n3; ++i) {
                                if (this.reader.isAborted()) {
                                    return;
                                }
                                this.setTitle((String)object + " (" + (i + 1) + "/" + n3 + ")");
                                this.reader.readMulti(this.inFiles[i]);
                            }
                            this.setTitle((String)object + " ... Verkn\u00fcpfung");
                            this.reader.finishMultiReading();
                        } else {
                            this.reader.read();
                        }
                        this.setTitle((String)object + " ... Auswertung");
                        if (this.isAborted()) {
                            return;
                        }
                        this.setKooSystem(this.reader.getKooSystem());
                        this.db.setArea(this.reader.getKooSystem());
                        this.setProgress(0);
                        MessungParser messungParser = new MessungParser(this.db, (IProgressViewer)this.progressBar);
                        messungParser.setExceptionList(this.exceptions);
                        if (this.isAborted()) {
                            return;
                        }
                        long l = System.currentTimeMillis();
                        if (n == 501 || n == 593) {
                            messungParser.parse();
                            this.setProgress(100);
                        } else if (n == 540) {
                            messungParser.natureRadien();
                            this.setProgress(100);
                        } else if (n == 561 || n == 562) {
                            messungParser.parseAlkLinien();
                        } else if (n == 550) {
                            messungParser.natureRadien();
                            this.setProgress(10);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.computeAlkisFlurstuecke(DataBase.FLST);
                            this.setProgress(20);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.computeAlkisNutzungen(DataBase.NUTZ);
                            this.setProgress(30);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.computeAlkisBodenschaetzung(DataBase.BODEN);
                            this.setProgress(40);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.computeAlkisTopografie(DataBase.TOP);
                            this.setProgress(50);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.computeAlkisGebaeudeSignatur(DataBase.GEB);
                            this.setProgress(60);
                            if (this.isAborted()) {
                                return;
                            }
                            MessungParser.createSymbolWinkel(DataBase.FLST);
                            this.setProgress(70);
                            if (this.isAborted()) {
                                return;
                            }
                            messungParser.computeFlstAreaExtends();
                            this.setProgress(80);
                            if (this.isAborted()) {
                                return;
                            }
                            KafPlotProperties.init(this.db);
                            this.setProgress(90);
                        } else {
                            messungParser.referMessungen();
                            this.setProgress(30);
                            if (this.isAborted()) {
                                return;
                            }
                            messungParser.referBedingungen();
                            this.setProgress(60);
                            if (this.isAborted()) {
                                return;
                            }
                            messungParser.initGeom();
                            this.setProgress(90);
                        }
                        if (KafPlot.debug()) {
                            System.out.println("MessungParser.time:" + (System.currentTimeMillis() - l));
                        }
                        if (this.isAborted()) {
                            return;
                        }
                        if (this.reader.getFinalMessage() != null) {
                            this.addException(new Exception(this.reader.getFinalMessage()));
                        }
                        break block31;
                    }
                    throw new IException("Kein Reader f\u00fcr Dateityp '" + GeoFile.getFileTypString(n) + "' vorhanden");
                }
                catch (Exception exception) {
                    this.showError(exception);
                }
            }
        }
        this.endDialog();
    }

    @Override
    protected void doStandardAction() {
    }

    @Override
    protected void doAbortAction() {
    }

    protected IFileReader getReader(File file, int n, DataBase dataBase) throws Exception {
        IFileReader iFileReader = null;
        switch (n) {
            case 211: {
                iFileReader = new GsiKooReader(file, DataBase.P);
                break;
            }
            case 139: {
                iFileReader = new AlkisKooReader(file, DataBase.P);
                break;
            }
            case 121: {
                iFileReader = new K_SoftReader(file, DataBase.P);
                break;
            }
            case 123: {
                iFileReader = new GsbReader(file, DataBase.P);
                break;
            }
            case 125: {
                iFileReader = new DbkReader(file, DataBase.P);
                break;
            }
            case 124: {
                iFileReader = new EdbsReader(file, DataBase.P);
                break;
            }
            case 122: {
                iFileReader = new GeografPunktReader(file, DataBase.P);
                break;
            }
            case 127: {
                iFileReader = new TtpReader(file, DataBase.P);
                break;
            }
            case 128: {
                iFileReader = new PdbReader(file, DataBase.P);
                break;
            }
            case 129: {
                iFileReader = new PdkReader(file, DataBase.P);
                break;
            }
            case 130: {
                iFileReader = new IdbReader(file, DataBase.P);
                break;
            }
            case 133: {
                iFileReader = new KivReader(file, DataBase.P);
                break;
            }
            case 103: {
                iFileReader = new Lt3Reader(file, DataBase.P);
                break;
            }
            case 107: {
                iFileReader = new Lt7Reader(file, DataBase.P);
                break;
            }
            case 131: {
                iFileReader = new AgaKooReader(file, DataBase.P);
                break;
            }
            case 132: {
                iFileReader = new CsvReader(file, DataBase.P);
                break;
            }
            case 138: {
                iFileReader = new GpsKooReader(file, DataBase.P);
                break;
            }
            case 134: {
                iFileReader = new CaddyKooReader(file, DataBase.P);
                break;
            }
            case 137: {
                iFileReader = new SystraKooReader(file, DataBase.P);
                break;
            }
            case 140: {
                iFileReader = new ZenoTxtReader(file, (LongHashList)DataBase.P, this.geoFile.getEncoding());
                break;
            }
            case 520: {
                iFileReader = new UmnumReader(file, DataBase.P);
                break;
            }
            case 501: {
                iFileReader = new DatReader(file, dataBase);
                break;
            }
            case 586: {
                iFileReader = new Lt6Reader(file, DataBase.ERR, DataBase.P);
                break;
            }
            case 540: {
                if (!KafPlotVersion.isSigned("AlkReader.class")) break;
                iFileReader = new AlkReader(file, dataBase);
                break;
            }
            case 550: {
                iFileReader = new NasReader(file, dataBase);
                break;
            }
            case 505: {
                iFileReader = new Da040Reader(file, dataBase);
                break;
            }
            case 561: {
                if (!KafPlotVersion.isSigned("WldgeReader.class")) break;
                iFileReader = new WldgeReader(file, DataBase.ALB, DataBase.FLST, DataBase.BUCH);
                break;
            }
            case 562: {
                if (!KafPlotVersion.isSigned("WldgeReader.class")) break;
                iFileReader = new AlbReader(file, DataBase.ALB, DataBase.FLST, DataBase.BUCH);
                break;
            }
            case 563: {
                if (!KafPlotVersion.isSigned("WldgeReader.class")) break;
                iFileReader = new AlbPrintReader(file, DataBase.ALB, DataBase.FLST, DataBase.BUCH);
                break;
            }
            case 591: {
                if (!KafPlotVersion.isSigned("GeoImage.class")) break;
                iFileReader = new RidReader(file, dataBase);
                break;
            }
            case 592: {
                if (!KafPlotVersion.isSigned("GeoImage.class")) break;
                iFileReader = new TflReader(file, dataBase);
                break;
            }
            case 511: {
                if (!KafPlotVersion.isSigned("SytraReader.class")) break;
                iFileReader = new SystraReader(file, dataBase);
                break;
            }
            case 512: {
                if (!KafPlotVersion.isSigned("SytraReader.class")) break;
                iFileReader = new SystraReader(file, dataBase);
                break;
            }
            case 593: {
                iFileReader = new SystraOutReader(file, dataBase);
                break;
            }
            case 570: {
                iFileReader = new CsvErrorReader(file, DataBase.ERR);
                break;
            }
            case 604: {
                iFileReader = new ErrorReader(file, DataBase.ERR);
                break;
            }
            case 601: {
                iFileReader = new KpvReader(file, dataBase);
                break;
            }
            case 602: {
                iFileReader = new KpzReader(file, dataBase);
                break;
            }
            case 609: {
                iFileReader = new LtaReader(file, DataBase.P);
                break;
            }
            case 594: {
                iFileReader = new EsriDigitReader(file, dataBase);
                break;
            }
            case -1: {
                iFileReader = new FreeFormatReader(file, DataBase.P);
                break;
            }
            case 503: {
                GeografFileTyp geografFileTyp = new GeografFileTyp();
                geografFileTyp.testFile(file);
                if (geografFileTyp.getFileTyp() != 1) {
                    throw new Exception("Unbekannter Dateityp: " + geografFileTyp.getFileTypString());
                }
                int n2 = geografFileTyp.getMajorVersion();
                if (n2 == 2) {
                    iFileReader = new GeografOutReader(file, DataBase.P, DataBase.BH, DataBase.T, DataBase.FLST, DataBase.GEB, DataBase.TOP);
                    break;
                }
                if (n2 == 3 || n2 == 7) {
                    iFileReader = new GgOutReader(file, dataBase);
                    break;
                }
                throw new Exception("Version " + geografFileTyp.getFileTypString() + " wird nicht unterst\u00fctzt, m\u00f6glich GRAFBAT V 2,3,7");
            }
        }
        return iFileReader;
    }
}

