/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFilePanel;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IProgressBar;
import de.geocalc.awt.IQuestionDialog;
import de.geocalc.io.GeoFile;
import de.geocalc.io.Util;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeografProperties;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.KatAmt;
import de.geocalc.kafplot.NummerZuschlag;
import de.geocalc.kafplot.PunktFilter;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.io.AgaKooWriter;
import de.geocalc.kafplot.io.AlkWriter;
import de.geocalc.kafplot.io.AlkisPunktWriter;
import de.geocalc.kafplot.io.CaddyKooWriter;
import de.geocalc.kafplot.io.CsvWriter;
import de.geocalc.kafplot.io.DatWriter;
import de.geocalc.kafplot.io.DbkWriter;
import de.geocalc.kafplot.io.DxfWriter;
import de.geocalc.kafplot.io.EdbsWriter;
import de.geocalc.kafplot.io.EsriDigitWriter;
import de.geocalc.kafplot.io.GeografAlkWriter;
import de.geocalc.kafplot.io.GeografHomWriter;
import de.geocalc.kafplot.io.GeografLinienWriter;
import de.geocalc.kafplot.io.GeografOutWriter;
import de.geocalc.kafplot.io.GeografPunktWriter;
import de.geocalc.kafplot.io.GeografRissWriter;
import de.geocalc.kafplot.io.GeografUmnumWriter;
import de.geocalc.kafplot.io.GgPlanWriter;
import de.geocalc.kafplot.io.GgRissWriter;
import de.geocalc.kafplot.io.GpsKooWriter;
import de.geocalc.kafplot.io.GsbWriter;
import de.geocalc.kafplot.io.HomWriter;
import de.geocalc.kafplot.io.IFileWriter;
import de.geocalc.kafplot.io.IOProperties;
import de.geocalc.kafplot.io.IdbWriter;
import de.geocalc.kafplot.io.ItrWriter;
import de.geocalc.kafplot.io.KivWriter;
import de.geocalc.kafplot.io.KpdWriter;
import de.geocalc.kafplot.io.KplWriter;
import de.geocalc.kafplot.io.KpvWriter;
import de.geocalc.kafplot.io.KpzWriter;
import de.geocalc.kafplot.io.KpzusWriter;
import de.geocalc.kafplot.io.LtaWriter;
import de.geocalc.kafplot.io.PdbWriter;
import de.geocalc.kafplot.io.PdkWriter;
import de.geocalc.kafplot.io.SoftWriter;
import de.geocalc.kafplot.io.SystraKooWriter;
import de.geocalc.kafplot.io.TtpWriter;
import de.geocalc.kafplot.io.UmnumWriter;
import de.geocalc.kafplot.io.ViewerHtmlWriter;
import de.geocalc.kafplot.io.XdesyWriter;
import de.geocalc.kafplot.io.XmlWriter;
import de.geocalc.kafplot.io.ZenoTxtZipWriter;
import de.geocalc.kafplot.io.alkis.AlkisIOProperties;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.kafplot.io.edbs.EdbsIOProperties;
import de.geocalc.kafplot.io.gg.GGIOProperties;
import de.geocalc.lang.ValueOutOfBoundsException;
import de.geocalc.util.BooleanFilter;
import de.geocalc.util.IntegerListFilter;
import de.geocalc.util.NumberFilter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GeoFileWriterDialog
extends IDialog
implements ActionListener,
ItemListener {
    protected DataBase db;
    protected File outFile;
    protected IProgressBar progressBar;
    protected ExceptionList exceptions;
    private PunktFilter punktFilter;
    private int fileTyp = 139;
    private String fileName;
    private String filePath;
    private IFilePanel ggPropPanel;
    private static final String FILE_NAME_COMMAND = "...";
    private static final String FILE_ALL_COMMAND = "+";
    private static final String FILE_SEL_COMMAND = "-";
    private static final String FILE_ALL_CHOICE = "...";
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String GGPROP_COMMAND = "GeografProperties";
    private static final String FILTER = "*.";
    private static final String NO_OPTIONS = "no";
    private static final String STANDARD_OPTIONS = "standard";
    private static final String GG_OPTIONS = "pnz";
    private static final String GGU_OPTIONS = "ggu";
    private static final String EDBS_OPTIONS = "edbs";
    private static final String PDK_OPTIONS = "pdk";
    private static final String ALKIS_OPTIONS = "alkis";
    private static final String ANDERE = "andere";
    private static final String ANDERE_NUM = "000000";
    private static final String PUNKTNUMMER = "Punktnummer";
    private static final String PUNKTART = "Punktart";
    private static final String AMT = "Katasteramt";
    private static final String ANTRAG = "Antragsnummer";
    private static final String SPACE = " ";
    private static final String FIELD_EXCEPTION = "Ung\u00fcltiger Wert im Feld: ";
    private static final String DOUBLE_POINT = ": ";
    private static Vector fileTypes = new Vector();
    private TextField fileNameTextField;
    private TextField vPnrTextField;
    private TextField bPnrTextField;
    private TextField paTextField;
    private TextField ggPzLokTextField;
    private TextField edbsAmtTextField;
    private Checkbox aPnrCheckbox;
    private Checkbox aPaCheckbox;
    private Checkbox onCheckbox;
    private Checkbox isUmnumCheckbox;
    private Checkbox withHoeheCheckbox;
    private Checkbox isUmnumCheckbox_Pdk;
    private Checkbox onlyNeuCheckbox_Alkis;
    private Checkbox onlyAendCheckbox_Alkis;
    private Checkbox onlyAltCheckbox_Alkis;
    private Checkbox edbsOsCheckbox;
    private Checkbox edbsLgCheckbox;
    private Checkbox edbsLsCheckbox;
    private Checkbox edbsSpCheckbox;
    private Choice fileTypChoice;
    private Choice edbsAmtChoice;
    private Choice ggPzAmtChoice;
    private Choice punktNummerChoice;
    private Button fileNameButton;
    private Button fileTypeButton;
    private Button okButton;
    private Button abortButton;
    private Label fileNameLabel;
    private Label fileTypLabel;
    private Label punktNummerLabel;
    private Label progressLabel;
    private IPanel optionPanel;
    private CardLayout optionPanelLayout;
    private KatAmt amt;
    private boolean userHoeheState = false;
    private boolean autoMode = false;

    public GeoFileWriterDialog(IFrame iFrame, String string, DataBase dataBase, String string2) {
        this(iFrame, string, dataBase, string2, null, false);
    }

    public GeoFileWriterDialog(IFrame iFrame, String string, DataBase dataBase, String string2, String string3, boolean bl) {
        super(iFrame, string, !bl);
        Panel panel;
        this.db = dataBase;
        this.fileName = string2;
        this.filePath = dataBase.getDestPath();
        this.exceptions = new ExceptionList();
        this.amt = KatAmt.getKatAmt(DataBase.katasterAmt);
        this.userHoeheState = IOProperties.isHoeheModus();
        this.autoMode = bl;
        if (string3 != null) {
            this.fileTyp = GeoFile.getFileTypOfExtension(string3);
        }
        if (this.fileTyp == -1) {
            this.fileTyp = 123;
        }
        this.setLayout(new BorderLayout());
        Panel panel2 = new Panel(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Datei"));
        this.fileNameLabel = new Label("Datei: ");
        iPanel.add(this.fileNameLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        this.fileNameTextField = new TextField((bl ? string2 : KafPlotProperties.getExportFileName()) + "." + GeoFile.getFileTypExtension(this.fileTyp), 40);
        iPanel.add(this.fileNameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fileNameTextField, gridBagConstraints);
        this.fileNameButton = new Button("...");
        iPanel.add(this.fileNameButton);
        this.fileNameButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fileNameButton, gridBagConstraints);
        this.fileTypLabel = new Label("Typ: ");
        iPanel.add(this.fileTypLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.fileTypLabel, gridBagConstraints);
        this.fileTypChoice = new Choice();
        iPanel.add(this.fileTypChoice);
        this.fillFileTypChoice(IOProperties.hasExportFileTypes());
        this.fileTypChoice.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fileTypChoice, gridBagConstraints);
        this.fileTypeButton = new Button(FILE_ALL_COMMAND);
        iPanel.add(this.fileTypeButton);
        this.fileTypeButton.addActionListener(this);
        this.fileTypeButton.setEnabled(IOProperties.hasExportFileTypes());
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.fileTypeButton, gridBagConstraints);
        panel2.add("North", iPanel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        IPanel iPanel2 = new IPanel(gridBagLayout2);
        iPanel2.setBorder(new IBorder(1, "Ausgabebereich"));
        ILabel iLabel = new ILabel("Punktnummer: ");
        iPanel2.add(iLabel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        iLabel = new ILabel("Punktart: ");
        iPanel2.add(iLabel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        iLabel = new ILabel("Offlinepunkte: ");
        iPanel2.add(iLabel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        this.vPnrTextField = new TextField(13);
        iPanel2.add(this.vPnrTextField);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.vPnrTextField, gridBagConstraints2);
        this.paTextField = new TextField(20);
        iPanel2.add(this.paTextField);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 3;
        gridBagLayout2.setConstraints(this.paTextField, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        iLabel = new ILabel(" -");
        iPanel2.add(iLabel);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(iLabel, gridBagConstraints2);
        this.bPnrTextField = new TextField(13);
        iPanel2.add(this.bPnrTextField);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.bPnrTextField, gridBagConstraints2);
        this.aPnrCheckbox = new Checkbox("Alle");
        iPanel2.add(this.aPnrCheckbox);
        this.aPnrCheckbox.addItemListener(this);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints(this.aPnrCheckbox, gridBagConstraints2);
        this.aPaCheckbox = new Checkbox("Alle");
        iPanel2.add(this.aPaCheckbox);
        this.aPaCheckbox.addItemListener(this);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 1;
        gridBagLayout2.setConstraints(this.aPaCheckbox, gridBagConstraints2);
        this.onCheckbox = new Checkbox("Alle");
        iPanel2.add(this.onCheckbox);
        this.onCheckbox.addItemListener(this);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(this.onCheckbox, gridBagConstraints2);
        panel2.add("Center", iPanel2);
        IPanel iPanel3 = new IPanel(new BorderLayout());
        iPanel3.setBorder(new IBorder(1, "Optionen"));
        this.optionPanelLayout = new CardLayout();
        this.optionPanel = new IPanel(this.optionPanelLayout);
        this.optionPanel.add((Component)this.createNoOptionsPanel(), NO_OPTIONS);
        this.optionPanel.add((Component)this.createStandardOptionsPanel(), STANDARD_OPTIONS);
        this.optionPanel.add((Component)this.createGgOptionsPanel(), GG_OPTIONS);
        this.optionPanel.add((Component)this.createEdbsOptionsPanel(), EDBS_OPTIONS);
        this.optionPanel.add((Component)this.createPdkOptionsPanel(), PDK_OPTIONS);
        this.optionPanel.add((Component)this.createAlkisOptionsPanel(), ALKIS_OPTIONS);
        iPanel3.add("North", this.optionPanel);
        if (KafPlotVersion.isSigned("Hoehe")) {
            panel = new Panel();
            this.withHoeheCheckbox = new Checkbox("Ausgabe mit H\u00f6he", IOProperties.isHoeheModus());
            panel.add(this.withHoeheCheckbox);
            this.withHoeheCheckbox.addItemListener(this);
            iPanel3.add(panel);
        }
        panel2.add("South", iPanel3);
        panel = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new FlowLayout());
        this.progressBar = new IProgressBar();
        panel3.add(this.progressBar);
        panel.add("North", panel3);
        Panel panel4 = new Panel(new GridLayout(1, 1));
        this.progressLabel = new Label("", 1);
        panel4.add(this.progressLabel);
        panel.add("South", panel4);
        this.add("Center", panel);
        this.add("North", panel2);
        Panel panel5 = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel5.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel5.add(this.abortButton);
        this.add("South", panel5);
        this.punktFilter = new PunktFilter(this.fileTyp);
        this.resetLayout();
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
        this.fileTypChoice.requestFocus();
        this.showOptionPanel();
        if (bl) {
            this.setVisible(true);
            try {
                this.write();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            super.endDialog();
        }
    }

    private void resetLayout() {
        NumberFilter numberFilter = (NumberFilter)this.punktFilter.getFilter(101);
        this.vPnrTextField.setText(numberFilter.getMinimum().toString());
        this.bPnrTextField.setText(numberFilter.getMaximum().toString());
        this.aPnrCheckbox.setState(!numberFilter.isEnabled());
        this.aPnrCheckbox.setEnabled(numberFilter.isSwitchable());
        IntegerListFilter integerListFilter = (IntegerListFilter)this.punktFilter.getFilter(201);
        this.paTextField.setText(integerListFilter.getBounds());
        this.aPaCheckbox.setState(!integerListFilter.isEnabled());
        this.aPaCheckbox.setEnabled(integerListFilter.isSwitchable());
        if (this.fileTyp == 609) {
            this.onCheckbox.setState(true);
            this.onCheckbox.setEnabled(false);
        } else {
            BooleanFilter booleanFilter = (BooleanFilter)this.punktFilter.getFilter(901);
            this.onCheckbox.setState(!booleanFilter.isEnabled());
            this.onCheckbox.setEnabled(booleanFilter.isSwitchable());
        }
        this.setTextFieldsEditable();
        if (this.withHoeheCheckbox != null) {
            if (GeoFile.is3DTyp(this.fileTyp)) {
                this.withHoeheCheckbox.setState(this.userHoeheState);
                this.withHoeheCheckbox.setEnabled(true);
            } else {
                this.withHoeheCheckbox.setState(false);
                this.withHoeheCheckbox.setEnabled(false);
            }
        }
    }

    private void setTextFieldsEditable() {
        this.vPnrTextField.setEnabled(!this.aPnrCheckbox.getState());
        this.bPnrTextField.setEnabled(!this.aPnrCheckbox.getState());
        this.vPnrTextField.setEditable(!this.aPnrCheckbox.getState());
        this.bPnrTextField.setEditable(!this.aPnrCheckbox.getState());
        this.paTextField.setEnabled(!this.aPaCheckbox.getState());
        this.paTextField.setEditable(!this.aPaCheckbox.getState());
    }

    public void write() throws IException {
        NumberFilter numberFilter = (NumberFilter)this.punktFilter.getFilter(101);
        numberFilter.setEnabled(!this.aPnrCheckbox.getState());
        if (!this.aPnrCheckbox.getState()) {
            try {
                numberFilter.setMinimum(new Long(this.vPnrTextField.getText()));
                numberFilter.setMaximum(new Long(this.bPnrTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("Ung\u00fcltiger Wert im Feld: Punktnummer");
            }
            catch (ValueOutOfBoundsException valueOutOfBoundsException) {
                throw new IException("Ung\u00fcltiger Wert im Feld: Punktnummer");
            }
        }
        NumberFilter numberFilter2 = (NumberFilter)this.punktFilter.getFilter(201);
        numberFilter2.setEnabled(!this.aPaCheckbox.getState());
        if (!this.aPaCheckbox.getState()) {
            try {
                numberFilter2.setBounds(this.paTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IException("Ung\u00fcltiger Wert im Feld: Punktart");
            }
            catch (ValueOutOfBoundsException valueOutOfBoundsException) {
                throw new IException("Ung\u00fcltiger Wert im Feld: Punktart");
            }
        }
        BooleanFilter booleanFilter = (BooleanFilter)this.punktFilter.getFilter(901);
        booleanFilter.setEnabled(!this.onCheckbox.getState());
        if (KafPlotVersion.isSigned("Hoehe")) {
            IOProperties.setHoeheModus(this.withHoeheCheckbox == null ? false : this.withHoeheCheckbox.getState());
        } else {
            IOProperties.setHoeheModus(false);
        }
        IFileWriter iFileWriter = null;
        File file = Util.getFile(this.filePath, this.fileNameTextField.getText());
        switch (this.fileTyp) {
            case 123: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new GsbWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new GsbWriter(file, DataBase.P);
                break;
            }
            case 128: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new PdbWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new PdbWriter(file, DataBase.P);
                break;
            }
            case 130: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new IdbWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new IdbWriter(file, DataBase.P);
                break;
            }
            case 133: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new KivWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new KivWriter(file, DataBase.P);
                break;
            }
            case 124: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new EdbsWriter(file, DataBase.MENGE) : new EdbsWriter(file, DataBase.P);
                try {
                    iFileWriter.setAmt(new Integer(this.edbsAmtTextField.getText().trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IException("Ung\u00fcltiger Wert im Feld: Katasteramt");
                }
                if (DataBase.antrag != null) {
                    iFileWriter.setAntrag(DataBase.antrag);
                } else {
                    iFileWriter.setAntrag(new String(""));
                }
                if (this.edbsLgCheckbox.getState()) {
                    EdbsIOProperties.setOutLga(0);
                } else if (this.edbsLsCheckbox.getState()) {
                    EdbsIOProperties.setOutLga(2);
                } else if (this.edbsSpCheckbox.getState()) {
                    EdbsIOProperties.setOutLga(9);
                }
                EdbsIOProperties.setOutOska(this.edbsOsCheckbox.getState());
                break;
            }
            case 139: {
                AlkisIOProperties.writeOnlyNeuPunkte = this.onlyNeuCheckbox_Alkis.getState();
                AlkisIOProperties.writeOnlyAendPunkte = this.onlyAendCheckbox_Alkis.getState();
                AlkisIOProperties.writeOnlyAltPunkte = this.onlyAltCheckbox_Alkis.getState();
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new AlkisPunktWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new AlkisPunktWriter(file, DataBase.P);
                break;
            }
            case 125: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new DbkWriter(file, DataBase.MENGE) : new DbkWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 129: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new PdkWriter(file, DataBase.MENGE) : new PdkWriter(file, DataBase.P);
                KafkaIOProperties.writeUmnum = this.isUmnumCheckbox_Pdk.getState();
                KafkaIOProperties.pnrModus = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
                break;
            }
            case 121: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new SoftWriter(file, DataBase.MENGE) : new SoftWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 137: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new SystraKooWriter(file, DataBase.MENGE) : new SystraKooWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 135: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new ItrWriter(file, DataBase.MENGE) : new ItrWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 134: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new CaddyKooWriter(file, DataBase.MENGE) : new CaddyKooWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 127: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new TtpWriter(file, DataBase.MENGE) : new TtpWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 131: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new AgaKooWriter(file, DataBase.MENGE) : new AgaKooWriter(file, DataBase.P);
                IOProperties.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 132: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new CsvWriter(file, DataBase.MENGE) : new CsvWriter(file, DataBase.P);
                IOProperties.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 138: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new GpsKooWriter(file, DataBase.MENGE) : new GpsKooWriter(file, DataBase.P);
                IOProperties.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 136: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new AlkWriter(file, DataBase.MENGE) : new AlkWriter(file, DataBase.P);
                iFileWriter.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 122: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                iFileWriter = geoFileWriterDialog.db.hasMenge() ? new GeografPunktWriter(file, DataBase.MENGE) : new GeografPunktWriter(file, DataBase.P);
                this.setGeografProperties();
                break;
            }
            case 502: {
                iFileWriter = new GeografLinienWriter(file, this.db.getLinien());
                this.setGeografProperties();
                break;
            }
            case 501: {
                iFileWriter = new DatWriter(file, this.db);
                KafkaIOProperties.writeUmnum = this.isUmnumCheckbox_Pdk.getState();
                KafkaIOProperties.pnrModus = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
                break;
            }
            case 503: {
                iFileWriter = GGIOProperties.versionPlan == 2 ? new GgPlanWriter(file, this.db) : new GeografOutWriter(file, this.db);
                this.setGeografProperties();
                break;
            }
            case 504: {
                iFileWriter = new GeografAlkWriter(file, this.db);
                this.setGeografProperties();
                break;
            }
            case 509: {
                iFileWriter = GGIOProperties.versionRiss == 2 ? new GgRissWriter(file, this.db) : new GeografRissWriter(file, this.db);
                this.setGeografProperties();
                break;
            }
            case 521: {
                iFileWriter = new GeografUmnumWriter(file, this.db);
                this.setGeografProperties();
                break;
            }
            case 520: {
                iFileWriter = new UmnumWriter(file, DataBase.P);
                KafkaIOProperties.writeUmnum = this.isUmnumCheckbox_Pdk.getState();
                KafkaIOProperties.pnrModus = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
                break;
            }
            case 510: {
                iFileWriter = new DxfWriter(file, this.db);
                break;
            }
            case 595: {
                iFileWriter = new ZenoTxtZipWriter(file, this.db);
                IOProperties.setUmnum(this.isUmnumCheckbox.getState());
                break;
            }
            case 513: {
                iFileWriter = new XdesyWriter(file, this.db);
                KafkaIOProperties.writeUmnum = this.isUmnumCheckbox_Pdk.getState();
                KafkaIOProperties.pnrModus = PunktNummer.getLength(this.punktNummerChoice.getSelectedItem());
                break;
            }
            case 530: {
                iFileWriter = new XmlWriter(file, this.db);
                break;
            }
            case 594: {
                iFileWriter = new EsriDigitWriter(file, this.db);
                break;
            }
            case 601: {
                iFileWriter = new KpvWriter(file, this.db);
                break;
            }
            case 602: {
                iFileWriter = new KpzWriter(file, this.db);
                break;
            }
            case 605: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new KplWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new KplWriter(file, DataBase.P);
                break;
            }
            case 606: {
                GeoFileWriterDialog geoFileWriterDialog = this;
                if (geoFileWriterDialog.db.hasMenge()) {
                    iFileWriter = new KpdWriter(file, DataBase.MENGE);
                    break;
                }
                iFileWriter = new KpdWriter(file, DataBase.P);
                break;
            }
            case 608: {
                iFileWriter = new KpzusWriter(file, this.db);
                break;
            }
            case 609: {
                iFileWriter = new LtaWriter(file, DataBase.P);
                break;
            }
            case 610: {
                iFileWriter = new HomWriter(file, this.db);
                break;
            }
            case 611: {
                iFileWriter = new GeografHomWriter(file, this.db);
                break;
            }
            case 603: {
                String string = file.getName();
                if (string.lastIndexOf(".") > 0) {
                    string = string.substring(0, string.lastIndexOf("."));
                }
                iFileWriter = new ViewerHtmlWriter(file, this.db, string + ".kpv");
            }
        }
        if (iFileWriter != null) {
            iFileWriter.setPunktFilter(this.punktFilter);
            iFileWriter.setProgressBar(this.progressBar);
            iFileWriter.setProgressLabel(this.progressLabel);
            iFileWriter.setExceptionList(this.exceptions);
            iFileWriter.write();
        } else {
            System.out.println("Fehler beim Schreiben von: " + String.valueOf(file));
        }
    }

    private void setGeografProperties() throws IException {
        GeografProperties.setLokalNrZuschlag(NummerZuschlag.parseNummerZuschlag(this.ggPzLokTextField.getText()));
        GeografProperties.setAmtNrModus(PunktNummer.getLength(this.ggPzAmtChoice.getSelectedItem()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.endDialog();
        } else if (string.equals("...")) {
            FileDialog fileDialog = new FileDialog((Frame)this.parent, "Speichern", 0);
            fileDialog.setDirectory(this.filePath);
            fileDialog.setFile(FILTER + GeoFile.getFileTypExtension(this.fileTyp));
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                this.fileNameTextField.setText(fileDialog.getDirectory() + fileDialog.getFile());
                this.filePath = fileDialog.getDirectory();
            }
        } else if (string.equals(FILE_SEL_COMMAND)) {
            this.fillFileTypChoice(true);
            this.fileTypeButton.setLabel(FILE_ALL_COMMAND);
        } else if (string.equals(FILE_ALL_COMMAND)) {
            this.fillFileTypChoice(false);
            this.fileTypeButton.setLabel(FILE_SEL_COMMAND);
        } else if (string.equals(GGPROP_COMMAND)) {
            File file = this.ggPropPanel.getFile();
            try {
                GeografProperties.load(new BufferedInputStream(new FileInputStream(file)));
                this.ggPzAmtChoice.select(PunktNummer.getLengthAsString(GeografProperties.getAmtNrModus(), DataBase.model.getModel()));
                NummerZuschlag nummerZuschlag = GeografProperties.getLokalNrZuschlag();
                if (nummerZuschlag == null) {
                    this.ggPzLokTextField.setText(new NummerZuschlag().toString());
                } else {
                    int n = this.fileName.lastIndexOf(System.getProperties().getProperty("file.separator"));
                    try {
                        nummerZuschlag = n < 0 ? NummerZuschlag.parseNummerZuschlag(this.fileName + "####") : NummerZuschlag.parseNummerZuschlag(this.fileName.substring(n + 1, this.fileName.length()) + "####");
                        this.ggPzLokTextField.setText(nummerZuschlag.toString());
                    }
                    catch (IException iException) {
                        this.ggPzLokTextField.setText(new NummerZuschlag().toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Checkbox checkbox;
        Object object = itemEvent.getSource();
        if (object instanceof Choice) {
            Choice choice = (Choice)object;
            String string = (String)itemEvent.getItem();
            if (choice == this.fileTypChoice) {
                if (string.equals("...")) {
                    this.fillFileTypChoice(false);
                    this.fileTypeButton.setLabel(FILE_SEL_COMMAND);
                    return;
                }
                this.fileTyp = GeoFile.getFileTyp(string);
                this.showOptionPanel();
            } else if (choice == this.edbsAmtChoice) {
                if (string.equals(ANDERE)) {
                    this.edbsAmtTextField.setText(ANDERE_NUM);
                    this.edbsAmtTextField.setEditable(true);
                } else {
                    KatAmt katAmt = KatAmt.getKatAmt(string);
                    if (katAmt != null) {
                        this.edbsAmtTextField.setText(new Integer(katAmt.getNummer()).toString());
                        this.edbsOsCheckbox.setState(katAmt.withEdbsOska);
                        if (katAmt.outLga == 0) {
                            this.edbsLgCheckbox.setState(true);
                        } else if (katAmt.outLga == 2) {
                            this.edbsLsCheckbox.setState(true);
                        } else if (katAmt.outLga == 9) {
                            this.edbsSpCheckbox.setState(true);
                        }
                    } else {
                        this.edbsAmtTextField.setText("0");
                        this.edbsOsCheckbox.setState(katAmt.withEdbsOska);
                        if (EdbsIOProperties.getOutLga() == 0) {
                            this.edbsLgCheckbox.setState(true);
                        } else if (EdbsIOProperties.getOutLga() == 2) {
                            this.edbsLsCheckbox.setState(true);
                        } else if (EdbsIOProperties.getOutLga() == 9) {
                            this.edbsSpCheckbox.setState(true);
                        }
                    }
                    this.edbsAmtTextField.setEditable(false);
                }
            }
        } else if (object instanceof Checkbox && (checkbox = (Checkbox)object) != this.isUmnumCheckbox_Pdk) {
            if (checkbox == this.withHoeheCheckbox) {
                this.userHoeheState = this.withHoeheCheckbox.getState();
            } else {
                this.setTextFieldsEditable();
            }
        }
    }

    private void showOptionPanel() {
        int n = this.fileNameTextField.getText().indexOf(".");
        this.fileName = n == -1 ? this.fileNameTextField.getText().trim() : this.fileNameTextField.getText().substring(0, n).trim();
        this.fileNameTextField.setText(this.fileName + "." + GeoFile.getFileTypExtension(this.fileTyp));
        this.punktFilter = new PunktFilter(this.fileTyp);
        this.resetLayout();
        switch (this.fileTyp) {
            case 123: 
            case 128: 
            case 130: 
            case 133: 
            case 510: 
            case 601: {
                this.optionPanelLayout.show(this.optionPanel, NO_OPTIONS);
                break;
            }
            case 121: 
            case 125: 
            case 127: 
            case 131: 
            case 132: 
            case 134: 
            case 136: {
                this.optionPanelLayout.show(this.optionPanel, STANDARD_OPTIONS);
                break;
            }
            case 138: 
            case 595: {
                this.withHoeheCheckbox.setState(true);
                this.optionPanelLayout.show(this.optionPanel, STANDARD_OPTIONS);
                break;
            }
            case 122: 
            case 502: {
                this.optionPanelLayout.show(this.optionPanel, GG_OPTIONS);
                break;
            }
            case 503: {
                this.optionPanelLayout.show(this.optionPanel, GG_OPTIONS);
                break;
            }
            case 504: {
                this.optionPanelLayout.show(this.optionPanel, GG_OPTIONS);
                break;
            }
            case 509: 
            case 521: {
                if (GGIOProperties.versionRiss == 2) {
                    this.optionPanelLayout.show(this.optionPanel, NO_OPTIONS);
                    break;
                }
                this.optionPanelLayout.show(this.optionPanel, GG_OPTIONS);
                break;
            }
            case 124: {
                this.optionPanelLayout.show(this.optionPanel, EDBS_OPTIONS);
                break;
            }
            case 129: 
            case 501: 
            case 511: 
            case 513: 
            case 520: {
                this.optionPanelLayout.show(this.optionPanel, PDK_OPTIONS);
                break;
            }
            case 139: {
                this.onCheckbox.setState(true);
                this.onCheckbox.setEnabled(false);
                this.optionPanelLayout.show(this.optionPanel, ALKIS_OPTIONS);
                break;
            }
            default: {
                this.optionPanelLayout.show(this.optionPanel, STANDARD_OPTIONS);
            }
        }
    }

    protected void setOutFile(File file) {
        this.outFile = file;
    }

    @Override
    protected void endDialog() {
        if (!this.exceptions.isEmpty()) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, "Es sind Fehler beim Schreiben der Daten aufgetreten, \ndie fehlerhafte Daten wurden ignoriert.", this.exceptions);
            errorDialog.setVisible(true);
        }
        super.endDialog();
    }

    private Panel createNoOptionsPanel() {
        Panel panel = new Panel();
        panel.add(new Label("keine Angaben n\u00f6tig"));
        return panel;
    }

    private Panel createGgOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Einstellungen:");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ggPropPanel = new IFilePanel("Einstellungen:", null, 0);
        panel.add(this.ggPropPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.ggPropPanel, gridBagConstraints);
        this.ggPropPanel.addActionListener(this);
        this.ggPropPanel.setActionCommand(GGPROP_COMMAND);
        label = new Label("Punktnummerzuschlag f\u00fcr lokale Punkte");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ggPzLokTextField = new TextField(10);
        panel.add(this.ggPzLokTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.ggPzLokTextField, gridBagConstraints);
        label = new Label("Punktnummernzuschlag f\u00fcr amtliche Punkte");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.ggPzAmtChoice = new Choice();
        panel.add(this.ggPzAmtChoice);
        int n = DataBase.model.getModel();
        this.ggPzAmtChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.ggPzAmtChoice.addItem(stringArray[i]);
        }
        this.ggPzAmtChoice.select(PunktNummer.getLengthAsString(GeografProperties.getAmtNrModus(), n));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.ggPzAmtChoice, gridBagConstraints);
        NummerZuschlag nummerZuschlag = GeografProperties.getLokalNrZuschlag();
        if (nummerZuschlag == null) {
            this.ggPzLokTextField.setText(new NummerZuschlag().toString());
        } else {
            int n2 = this.fileName.lastIndexOf(System.getProperties().getProperty("file.separator"));
            try {
                nummerZuschlag = n2 < 0 ? NummerZuschlag.parseNummerZuschlag(this.fileName + "####") : NummerZuschlag.parseNummerZuschlag(this.fileName.substring(n2 + 1, this.fileName.length()) + "####");
                this.ggPzLokTextField.setText(nummerZuschlag.toString());
            }
            catch (IException iException) {
                this.ggPzLokTextField.setText(new NummerZuschlag().toString());
            }
        }
        return panel;
    }

    private Panel createEdbsOptionsPanel() {
        Object object;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Katasteramt: ");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.edbsAmtChoice = this.getSortedChoice(KatAmt.getKatAmtList());
        panel.add(this.edbsAmtChoice);
        this.edbsAmtChoice.addItem(ANDERE);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.edbsAmtChoice, gridBagConstraints);
        this.edbsAmtTextField = new TextField(6);
        panel.add(this.edbsAmtTextField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.edbsAmtTextField, gridBagConstraints);
        boolean bl = this.selectChoice(this.edbsAmtChoice, DataBase.katasterAmt);
        if (bl) {
            object = KatAmt.getKatAmt(DataBase.katasterAmt);
            if (object != null) {
                this.edbsAmtTextField.setText(new Integer(((KatAmt)object).getNummer()).toString());
            } else {
                this.edbsAmtTextField.setText("0");
            }
        } else {
            this.edbsAmtChoice.select(ANDERE);
            this.edbsAmtTextField.setText(ANDERE_NUM);
        }
        this.edbsAmtTextField.setEditable(!bl);
        this.edbsAmtChoice.addItemListener(this);
        label = new Label("Antragsnummer: ");
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label(DataBase.antrag != null ? DataBase.antrag : SPACE);
        panel.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        if (this.amt != null) {
            EdbsIOProperties.setOutLga(this.amt.outLga);
            EdbsIOProperties.setOutOska(this.amt.withEdbsOska);
        } else {
            EdbsIOProperties.setOutLga(EdbsIOProperties.getOutStandardLga());
            EdbsIOProperties.setOutOska(EdbsIOProperties.isOutStandardOska());
        }
        object = new Panel();
        this.edbsOsCheckbox = new Checkbox("mit OSKA", EdbsIOProperties.isOutOska());
        ((Container)object).add(this.edbsOsCheckbox);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.edbsLgCheckbox = new Checkbox("LGA", checkboxGroup, EdbsIOProperties.getOutLga() == 0);
        ((Container)object).add(this.edbsLgCheckbox);
        this.edbsLsCheckbox = new Checkbox("LSP", checkboxGroup, EdbsIOProperties.getOutLga() == 2);
        ((Container)object).add(this.edbsLsCheckbox);
        this.edbsSpCheckbox = new Checkbox("SP", checkboxGroup, EdbsIOProperties.getOutLga() == 9);
        ((Container)object).add(this.edbsSpCheckbox);
        panel.add((Component)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        return panel;
    }

    private Panel createPdkOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        this.isUmnumCheckbox_Pdk = new Checkbox("umnumerierte Punktnummern", false);
        panel.add(this.isUmnumCheckbox_Pdk);
        this.isUmnumCheckbox_Pdk.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.isUmnumCheckbox_Pdk, gridBagConstraints);
        this.punktNummerLabel = new Label("Punktnummernbildung f\u00fcr amtliche Punkte: ");
        panel.add(this.punktNummerLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktNummerLabel, gridBagConstraints);
        this.punktNummerChoice = new Choice();
        panel.add(this.punktNummerChoice);
        int n = DataBase.model.getModel();
        this.punktNummerChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.punktNummerChoice.addItem(stringArray[i]);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.punktNummerChoice, gridBagConstraints);
        return panel;
    }

    private Panel createAlkisOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        Panel panel = new Panel(gridBagLayout);
        this.onlyNeuCheckbox_Alkis = new Checkbox("neue Punkte", AlkisIOProperties.writeOnlyNeuPunkte);
        panel.add(this.onlyNeuCheckbox_Alkis);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.onlyNeuCheckbox_Alkis, gridBagConstraints);
        this.onlyAendCheckbox_Alkis = new Checkbox("ver\u00e4nderte Punkte", AlkisIOProperties.writeOnlyAendPunkte);
        panel.add(this.onlyAendCheckbox_Alkis);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.onlyAendCheckbox_Alkis, gridBagConstraints);
        this.onlyAltCheckbox_Alkis = new Checkbox("unver\u00e4nderte Punkte", AlkisIOProperties.writeOnlyAltPunkte);
        panel.add(this.onlyAltCheckbox_Alkis);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.onlyAltCheckbox_Alkis, gridBagConstraints);
        return panel;
    }

    private Panel createStandardOptionsPanel() {
        Panel panel = new Panel(new FlowLayout());
        this.isUmnumCheckbox = new Checkbox("umnumerierte Punktnummern", false);
        panel.add(this.isUmnumCheckbox);
        return panel;
    }

    private Choice getSortedChoice(Hashtable hashtable) {
        Choice choice = new Choice();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((KatAmt)enumeration.nextElement()).getName();
            boolean bl = false;
            for (int i = 0; i < choice.getItemCount(); ++i) {
                if (choice.getItem(i).compareTo(string) <= 0) continue;
                choice.insert(string, i);
                bl = true;
                break;
            }
            if (bl) continue;
            choice.addItem(string);
        }
        return choice;
    }

    private void fillFileTypChoice(boolean bl) {
        this.fileTypChoice.removeAll();
        Enumeration enumeration = fileTypes.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (bl && !IOProperties.hasExportFileType(n)) continue;
            this.fileTypChoice.addItem(GeoFile.getFileTypString(n));
        }
        if (bl) {
            this.fileTypChoice.addItem("...");
        }
        this.fileTypChoice.select(GeoFile.getFileTypString(this.fileTyp));
        this.fileTypChoice.requestFocus();
    }

    private boolean selectChoice(Choice choice, String string) {
        for (int i = 0; i < choice.getItemCount(); ++i) {
            if (!choice.getItem(i).equals(string)) continue;
            choice.select(i);
            return true;
        }
        return false;
    }

    @Override
    protected void doStandardAction() {
        File file = Util.getFile(this.filePath, this.fileNameTextField.getText());
        if (file.exists()) {
            IQuestionDialog iQuestionDialog = new IQuestionDialog(this.parent, this.getTitle() + " best\u00e4tigen", file.getAbsolutePath() + " ist bereits vorhanden.\nM\u00f6chten Sie sie ersetzen?");
            iQuestionDialog.setVisible(true);
            if (iQuestionDialog.getAnswer() != 3) {
                this.setVisible(true);
                this.fileNameTextField.requestFocus();
                return;
            }
        }
        try {
            this.write();
        }
        catch (IException iException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iException);
            errorDialog.setVisible(true);
            return;
        }
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }

    static {
        fileTypes.addElement(new Integer(123));
        fileTypes.addElement(new Integer(124));
        fileTypes.addElement(new Integer(139));
        fileTypes.addElement(new Integer(136));
        fileTypes.addElement(new Integer(128));
        fileTypes.addElement(new Integer(130));
        fileTypes.addElement(new Integer(133));
        fileTypes.addElement(new Integer(125));
        fileTypes.addElement(new Integer(129));
        fileTypes.addElement(new Integer(121));
        fileTypes.addElement(new Integer(137));
        fileTypes.addElement(new Integer(134));
        fileTypes.addElement(new Integer(127));
        fileTypes.addElement(new Integer(131));
        fileTypes.addElement(new Integer(135));
        fileTypes.addElement(new Integer(132));
        fileTypes.addElement(new Integer(138));
        fileTypes.addElement(new Integer(122));
        fileTypes.addElement(new Integer(502));
        if (!KafPlotVersion.isReaderVersion()) {
            fileTypes.addElement(new Integer(501));
        }
        fileTypes.addElement(new Integer(503));
        fileTypes.addElement(new Integer(504));
        fileTypes.addElement(new Integer(509));
        fileTypes.addElement(new Integer(521));
        fileTypes.addElement(new Integer(520));
        fileTypes.addElement(new Integer(510));
        fileTypes.addElement(new Integer(530));
        fileTypes.addElement(new Integer(594));
        fileTypes.addElement(new Integer(601));
        fileTypes.addElement(new Integer(602));
        fileTypes.addElement(new Integer(605));
        fileTypes.addElement(new Integer(606));
        fileTypes.addElement(new Integer(609));
        fileTypes.addElement(new Integer(610));
        fileTypes.addElement(new Integer(611));
        fileTypes.addElement(new Integer(513));
        fileTypes.addElement(new Integer(595));
    }
}

