/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import com.sun.jimi.core.filters.Rotate;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.awt.image.ColorFilter;
import de.geocalc.awt.image.GrayFilter;
import de.geocalc.awt.image.PassFilter;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.ImageControlPoint;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KoordinatenSystem;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.DecimalFormatSymbols;
import de.geocalc.text.IFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.ReplicateScaleFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class GeoImage
implements PaintObject,
Messager {
    public static final String PROPERTIES_EXTENSION = "properties";
    private static final Color DISABLE_COLOR = Color.darkGray;
    private static final Color HIGHLIGHT_COLOR = KafPlotColor.BACKGROUND;
    protected JimiRasterImage raster;
    private Image viewImage;
    private GeoImageLocation loc;
    private String name;
    private String propName;
    private String pathName;
    private int width;
    private int height;
    protected int alpha = 0;
    protected int bright = 0;
    protected int contrast = 0;
    protected int sharp = 0;
    protected int gray = 0;
    protected boolean alphaAlternate = false;
    protected boolean isControlsVisible = false;
    protected boolean isDigitVisible = true;
    protected boolean isControlVisible = true;
    protected boolean isGapVisible = true;
    protected boolean isHighlight = true;
    private int digitWidth = 15;
    private Color controlColor = Color.red;
    private boolean isVisible = true;
    private static final int UNKNOWN = 0;
    private static final int ALPHA = 1;
    private static final int BRIGHT = 2;
    private static final int CONTRAST = 3;
    private static final int SHARP = 4;
    private static final int ALPHAALT = 5;
    private static final int GRAY = 6;
    private static final int CLIP = 51;
    private static final int PP = 101;
    private static final int DIGIT = 102;
    private static final int CONTROL = 103;
    private static final int GAP = 104;
    private static final int HIGHLIGHT = 105;
    private static final int COLOR = 106;
    private static final int WIDTH = 107;
    protected Rectangle lastArea = new Rectangle();
    double lastScale;
    double lastAngle;
    int lastColor;
    int lastSharp;
    int lastGray;
    double lastY;
    double lastX;
    private static final TextArt TA = TextArt.create(10);
    private static final BasicStroke CONTROL_LINE_2 = new BasicStroke(2.0f);
    private static final BasicStroke CONTROL_LINE_1 = new BasicStroke(1.0f);
    private static final BasicStroke HIGHLIGHT_LINE = new BasicStroke(4.0f);

    public static final String createWorldFileName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return string2 + "." + GeoImage.createWldExt(string3);
    }

    public static final String createWorldFileExtension(String string) {
        int n = string.lastIndexOf(".");
        return GeoImage.createWldExt(n > 0 ? string.substring(n + 1) : null);
    }

    public static final String createDefaultWorldFileName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n) + ".wld";
        }
        return string + ".wld";
    }

    private static final String createWldExt(String string) {
        if (string != null && string.length() >= 3) {
            return "" + string.charAt(0) + string.charAt(2) + "w";
        }
        return "wld";
    }

    public GeoImage() {
    }

    public GeoImage(JimiRasterImage jimiRasterImage, String string) {
        this.setRasterImage(jimiRasterImage);
        if (string != null) {
            int n = string.lastIndexOf(File.separator);
            if (n > 0) {
                this.pathName = string.substring(0, n + 1);
                this.name = string.substring(n + 1);
            } else {
                this.name = string;
            }
        }
        this.loc = new GeoImageLocation(this);
    }

    public void setImageLocation(GeoImageLocation geoImageLocation) {
        this.loc = geoImageLocation;
    }

    public GeoImageLocation getImageLocation() {
        return this.loc;
    }

    public boolean hasRasterImage() {
        return this.raster != null;
    }

    public JimiRasterImage getRasterImage() {
        return this.raster;
    }

    public void setRasterImage(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            this.raster = null;
            this.width = 0;
            this.height = 0;
        } else {
            this.raster = jimiRasterImage;
            this.width = jimiRasterImage.getWidth();
            this.height = jimiRasterImage.getHeight();
        }
    }

    public void removeRasterImage() {
        this.raster = null;
    }

    public void removeImageData() {
        this.raster = null;
        this.viewImage = null;
        System.gc();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public void setAlphaAlternate(boolean bl) {
        this.alphaAlternate = bl;
    }

    public boolean isAlphaAlternate() {
        return this.alphaAlternate;
    }

    public int getBright() {
        return this.bright;
    }

    public void setBright(int n) {
        this.bright = n;
    }

    public int getSharp() {
        return this.sharp;
    }

    public void setSharp(int n) {
        this.sharp = n;
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setContrast(int n) {
        this.contrast = n;
    }

    public int getGray() {
        return this.gray;
    }

    public void setGray(int n) {
        this.gray = n;
    }

    public Color getGrayColor(int n) {
        return new Color(new GrayFilter(n).filterRGB(0, 0, Color.black.getRGB()));
    }

    public Color getGrayColor(int n, Color color) {
        return new Color(new GrayFilter(n).filterRGB(0, 0, color.getRGB()));
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public void setPathName(String string) {
        this.pathName = string;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFilePath() {
        return this.pathName != null ? this.pathName + File.separator + this.name : this.name;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isControlsVisible() {
        return this.isControlsVisible;
    }

    public void setControlsVisible(boolean bl) {
        this.isControlsVisible = bl;
    }

    public void setDigitVisible(boolean bl) {
        this.isDigitVisible = bl;
    }

    public boolean isDigitVisible() {
        return this.isDigitVisible;
    }

    public boolean isControlVisible() {
        return this.isControlVisible;
    }

    public void setControlVisible(boolean bl) {
        this.isControlVisible = bl;
    }

    public boolean isGapVisible() {
        return this.isGapVisible;
    }

    public void setGapVisible(boolean bl) {
        this.isGapVisible = bl;
    }

    public boolean isHighlight() {
        return this.isHighlight;
    }

    public void setHighlight(boolean bl) {
        this.isHighlight = bl;
    }

    public Color getControlColor() {
        return this.controlColor;
    }

    public void setControlColor(Color color) {
        this.controlColor = color;
    }

    public int getDigitWidth() {
        return this.digitWidth;
    }

    public void setDigitWidth(int n) {
        this.digitWidth = n;
    }

    @Override
    public Message getMessage() {
        return new Message(this, "Bild: " + this.getName(), "Bild: " + this.getName() + " " + this.width + "x" + this.height + "px");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GeoImage: ");
        if (this.name != null) {
            stringBuffer.append(this.name);
        } else {
            stringBuffer.append("ohne Namen");
        }
        stringBuffer.append(" " + this.width + "," + this.height);
        return stringBuffer.toString();
    }

    public void saveProperties() throws IOException {
        this.saveProperties((this.getPathName() != null ? this.getPathName() : "") + this.getName() + ".properties");
    }

    public void saveProperties(String string) throws IOException {
        this.saveProperties(string, true);
    }

    public void saveProperties(String string, boolean bl) throws IOException {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#0.00000000000000", decimalFormatSymbols);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setFormatWidth(35);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(string))));
            double d = this.loc.getScale() * Math.cos(this.loc.getAngle());
            double d2 = Math.tan(-this.loc.getAngle()) * d;
            printWriter.println(decimalFormat.format(d));
            printWriter.println(decimalFormat.format(d2));
            printWriter.println(decimalFormat.format(d2));
            printWriter.println(decimalFormat.format(-d));
            printWriter.println(decimalFormat.format(this.loc.getLocation().y));
            printWriter.println(decimalFormat.format(this.loc.getLocation().x));
            if (bl) {
                Object object;
                printWriter.println("# Filtereinstellungen");
                printWriter.println("alpha = " + this.alpha);
                printWriter.println("alpha_alternate = " + (this.alphaAlternate ? 1 : 0));
                printWriter.println("bright = " + this.bright);
                printWriter.println("contrast = " + this.contrast);
                printWriter.println("sharp = " + this.sharp);
                printWriter.println("gray = " + this.gray);
                if (this.loc.hasClip()) {
                    printWriter.println("# Ausschnitt");
                    object = this.loc.getClipRect();
                    printWriter.println("clip = " + ((Rectangle)object).x + " " + ((Rectangle)object).y + " " + ((Rectangle)object).width + " " + ((Rectangle)object).height);
                }
                printWriter.println("# Passpunkte");
                printWriter.println("digit = " + (this.isDigitVisible() ? 1 : 0));
                printWriter.println("control = " + (this.isControlVisible() ? 1 : 0));
                printWriter.println("gap = " + (this.isGapVisible() ? 1 : 0));
                printWriter.println("highlight = " + (this.isHighlight() ? 1 : 0));
                printWriter.println("color = " + IFormat.colorString(this.getControlColor()));
                printWriter.println("width = " + this.getDigitWidth());
                object = this.loc.trafoElements();
                while (object.hasMoreElements()) {
                    ImageControlPoint imageControlPoint = (ImageControlPoint)object.nextElement();
                    if (!imageControlPoint.isValid()) continue;
                    Punkt punkt = imageControlPoint.getPunkt();
                    DPoint dPoint = imageControlPoint.getImagePoint();
                    printWriter.println("P " + IFormat.i14.format(punkt.nr) + " " + IFormat.f7_2.format(dPoint.x) + " " + IFormat.f7_2.format(dPoint.y) + " " + (imageControlPoint.isEnabled() ? 1 : 0));
                }
            }
            printWriter.close();
        }
        catch (Exception exception) {
            if (KafPlot.debug()) {
                exception.printStackTrace();
            }
            throw new IOException("Fehler beim Schreiben der Datei: " + string);
        }
    }

    public void loadProperties(String string) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string2;
            lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
            this.propName = new File(string).getName();
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            while ((string2 = lineNumberReader.readLine()) != null) {
                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                block2 : switch (n) {
                    case 0: {
                        d = Double.valueOf(string2.trim());
                        d5 = Math.abs(d) * (double)this.width;
                        break;
                    }
                    case 1: {
                        d7 = Double.valueOf(string2.trim());
                        break;
                    }
                    case 2: {
                        d8 = Double.valueOf(string2.trim());
                        break;
                    }
                    case 3: {
                        d2 = -Double.valueOf(string2.trim()).doubleValue();
                        d6 = Math.abs(d2) * (double)this.height;
                        break;
                    }
                    case 4: {
                        d3 = Double.valueOf(string2.trim());
                        break;
                    }
                    case 5: {
                        d4 = Double.valueOf(string2.trim());
                        break;
                    }
                    default: {
                        try {
                            int n2 = 0;
                            int n3 = 0;
                            ImageControlPoint imageControlPoint = null;
                            Rectangle rectangle = null;
                            StringTokenizer stringTokenizer = new StringTokenizer(string2);
                            block29: while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                if (n2 == 0) {
                                    if (string3.equalsIgnoreCase("alpha")) {
                                        n3 = 1;
                                    } else if (string3.equalsIgnoreCase("alpha_alternate")) {
                                        n3 = 5;
                                    } else if (string3.equalsIgnoreCase("bright")) {
                                        n3 = 2;
                                    } else if (string3.equalsIgnoreCase("contrast")) {
                                        n3 = 3;
                                    } else if (string3.equalsIgnoreCase("sharp")) {
                                        n3 = 4;
                                    } else if (string3.equalsIgnoreCase("gray")) {
                                        n3 = 6;
                                    } else if (string3.equalsIgnoreCase("clip")) {
                                        n3 = 51;
                                    } else if (string3.equalsIgnoreCase("digit")) {
                                        n3 = 102;
                                    } else if (string3.equalsIgnoreCase("control")) {
                                        n3 = 103;
                                    } else if (string3.equalsIgnoreCase("gap")) {
                                        n3 = 104;
                                    } else if (string3.equalsIgnoreCase("highlight")) {
                                        n3 = 105;
                                    } else if (string3.equalsIgnoreCase("color")) {
                                        n3 = 106;
                                    } else if (string3.equalsIgnoreCase("width")) {
                                        n3 = 107;
                                    } else {
                                        if (!string3.equalsIgnoreCase("p")) break block2;
                                        n3 = 101;
                                    }
                                    ++n2;
                                    continue;
                                }
                                switch (n3) {
                                    case 1: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.alpha = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 5: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.alphaAlternate = Integer.parseInt(string3) == 1;
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 2: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.bright = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 3: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.contrast = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 4: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.sharp = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 6: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.gray = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 102: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.isDigitVisible = Integer.parseInt(string3) == 1;
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 103: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.isControlVisible = Integer.parseInt(string3) == 1;
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 104: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.isGapVisible = Integer.parseInt(string3) == 1;
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 105: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.isHighlight = Integer.parseInt(string3) == 1;
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 106: {
                                        this.controlColor = IFormat.parseColor(string3);
                                        ++n2;
                                        break;
                                    }
                                    case 107: {
                                        if (IFormat.hasOnlyDigits(string3)) {
                                            this.digitWidth = Integer.parseInt(string3);
                                        }
                                        ++n2;
                                        break;
                                    }
                                    case 51: {
                                        if (n2 == 1) {
                                            if (!IFormat.hasOnlyDigits(string3)) break;
                                            rectangle = new Rectangle();
                                            rectangle.x = Integer.parseInt(string3);
                                            ++n2;
                                            break;
                                        }
                                        if (n2 == 2) {
                                            if (!IFormat.hasOnlyDigits(string3)) break;
                                            rectangle.y = Integer.parseInt(string3);
                                            ++n2;
                                            break;
                                        }
                                        if (n2 == 3) {
                                            if (!IFormat.hasOnlyDigits(string3)) break;
                                            rectangle.width = Integer.parseInt(string3);
                                            ++n2;
                                            break;
                                        }
                                        if (n2 != 4 || !IFormat.hasOnlyDigits(string3)) break;
                                        rectangle.height = Integer.parseInt(string3);
                                        this.loc.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                                        ++n2;
                                        break;
                                    }
                                    case 101: {
                                        if (n2 == 1) {
                                            Punkt punkt = null;
                                            if (IFormat.hasOnlyDigits(string3)) {
                                                punkt = (Punkt)DataBase.P.get(Long.parseLong(string3));
                                            }
                                            if (punkt == null) continue block29;
                                            imageControlPoint = new ImageControlPoint(null, punkt);
                                            this.loc.addTrafoPoint(imageControlPoint);
                                            ++n2;
                                            break;
                                        }
                                        if (n2 == 2) {
                                            if (!IFormat.hasOnlyFloats(string3)) break;
                                            imageControlPoint.setImageX(Double.parseDouble(string3));
                                            ++n2;
                                            break;
                                        }
                                        if (n2 == 3) {
                                            if (!IFormat.hasOnlyFloats(string3)) break;
                                            imageControlPoint.setImageY(Double.parseDouble(string3));
                                            ++n2;
                                            break;
                                        }
                                        if (n2 != 4 || !IFormat.hasOnlyDigits(string3)) break;
                                        imageControlPoint.setEnabled(Integer.parseInt(string3) > 0);
                                        ++n2;
                                    }
                                }
                            }
                            break;
                        }
                        catch (Exception exception) {
                            if (!KafPlot.debug()) break;
                            exception.printStackTrace();
                        }
                    }
                }
                ++n;
            }
            this.loc.setLocation(KoordinatenSystem.regularY(d3, DataBase.getKooSystem()), d4);
            double d9 = Math.atan2((Math.abs(d7) + Math.abs(d8)) / 2.0, (Math.abs(d) + Math.abs(d2)) / 2.0);
            if (d2 < 0.0) {
                d9 = -d9 + Math.PI;
            }
            if (d7 > 0.0) {
                d9 = -d9;
            }
            this.loc.setAngle(d9);
            this.loc.setScale((Math.abs(d) + Math.abs(d2)) / 2.0 / Math.abs(Math.cos(d9)));
            this.loc.transform();
            lineNumberReader.close();
        }
        catch (Exception exception) {
            throw new IOException("Fehler in Datei: " + string + " in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0));
        }
    }

    @Override
    public DRectangle getBounds() {
        return this.loc.getImageBounds();
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public DPoint getHashPoint() {
        DRectangle dRectangle = this.getBounds();
        return new DPoint(dRectangle.y + dRectangle.width / 2.0, dRectangle.x + dRectangle.height / 2.0);
    }

    public DPoint getCatchPoint() {
        return this.getHashPoint();
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (KafPlotProperties.isImgVisible) {
            if (KafPlotProperties.isImgFillVisible && !bl2) {
                this.drawBackground(iGraphics, bl, bl2);
            }
            if (KafPlotProperties.isImgPolyVisible || bl2) {
                this.drawForeground(iGraphics, bl, bl2);
            }
            if (KafPlotProperties.isImgTextVisible || bl2) {
                this.drawInscription(iGraphics, bl, bl2);
            }
            if (this.isControlsVisible) {
                this.drawControls(iGraphics, bl, false);
            }
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        graphics.setColor(KafPlotColor.IMAGE_FG);
        DPolygon dPolygon = this.loc.getImagePolygon();
        iGraphics.drawLine(dPolygon.ypoints[0], dPolygon.xpoints[0], dPolygon.ypoints[1], dPolygon.xpoints[1]);
        iGraphics.drawLine(dPolygon.ypoints[1], dPolygon.xpoints[1], dPolygon.ypoints[2], dPolygon.xpoints[2]);
        iGraphics.drawLine(dPolygon.ypoints[2], dPolygon.xpoints[2], dPolygon.ypoints[3], dPolygon.xpoints[3]);
        iGraphics.drawLine(dPolygon.ypoints[3], dPolygon.xpoints[3], dPolygon.ypoints[0], dPolygon.xpoints[0]);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.name != null) {
            if (!this.isViewable(iGraphics.getViewport())) {
                return;
            }
            DRectangle dRectangle = this.getBounds();
            double d = dRectangle.y + dRectangle.width / 2.0;
            double d2 = dRectangle.x + dRectangle.height / 2.0;
            if (!iGraphics.contains(d, d2)) {
                return;
            }
            Graphics graphics = iGraphics.getGraphics();
            graphics.setColor(KafPlotColor.IMAGE_FG);
            TextSymbol.paint(graphics, this.name, iGraphics.getGraphicPoint(d, d2, new Point()), TA, 4, 0, this.loc.getAngle() + iGraphics.getRotation() + 1.5707963267948966, 1.0);
        }
    }

    private DRectangle getDataViewRect(IGraphics iGraphics, Rectangle rectangle) {
        DPoint dPoint = iGraphics.getDataPoint(new Point(rectangle.x, rectangle.y), new DPoint());
        DPoint dPoint2 = iGraphics.getDataPoint(new Point(rectangle.x + rectangle.width, rectangle.y), new DPoint());
        DPoint dPoint3 = iGraphics.getDataPoint(new Point(rectangle.x, rectangle.y + rectangle.height), new DPoint());
        DPoint dPoint4 = iGraphics.getDataPoint(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new DPoint());
        DPolygon dPolygon = new DPolygon(4);
        dPolygon.addPoint(dPoint);
        dPolygon.addPoint(dPoint2);
        dPolygon.addPoint(dPoint4);
        dPolygon.addPoint(dPoint3);
        return dPolygon.getBounds();
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        block18: {
            if (this.raster == null || !this.isViewable(iGraphics.getViewport())) {
                return;
            }
            try {
                double d = this.loc.getLocation().y - this.loc.getScale() / 2.0;
                double d2 = this.loc.getLocation().x + this.loc.getScale() / 2.0;
                double d3 = this.loc.getWidth();
                double d4 = this.loc.getHeight();
                double d5 = this.loc.getScale();
                double d6 = this.loc.getAngle();
                Rectangle rectangle = iGraphics.getViewRect();
                double d7 = iGraphics.getRotation();
                double d8 = iGraphics.getScale();
                DRectangle dRectangle = this.getDataViewRect(iGraphics, rectangle);
                double d9 = Math.sin(d6);
                double d10 = Math.cos(d6);
                DRectangle dRectangle2 = this.getBounds();
                if (!dRectangle.intersects(dRectangle2)) {
                    return;
                }
                DRectangle dRectangle3 = dRectangle.intersect(dRectangle2);
                Polygon polygon = new Polygon();
                double d11 = dRectangle3.y - d;
                double d12 = d2 - (dRectangle3.x + dRectangle3.height);
                polygon.addPoint((int)Math.rint((d10 * d11 + d9 * d12) / d5), (int)Math.rint((d10 * d12 - d9 * d11) / d5));
                d11 = dRectangle3.y + dRectangle3.width - d;
                polygon.addPoint((int)Math.rint((d10 * d11 + d9 * d12) / d5), (int)Math.rint((d10 * d12 - d9 * d11) / d5));
                d11 = dRectangle3.y - d;
                d12 = d2 - dRectangle3.x;
                polygon.addPoint((int)Math.rint((d10 * d11 + d9 * d12) / d5), (int)Math.rint((d10 * d12 - d9 * d11) / d5));
                d11 = dRectangle3.y + dRectangle3.width - d;
                polygon.addPoint((int)Math.rint((d10 * d11 + d9 * d12) / d5), (int)Math.rint((d10 * d12 - d9 * d11) / d5));
                Rectangle rectangle2 = polygon.getBoundingBox();
                rectangle2 = rectangle2.intersection(this.loc.getClipRect());
                int n = Math.max(0, rectangle2.x);
                int n2 = Math.max(0, rectangle2.y);
                int n3 = Math.min(this.width, rectangle2.x + rectangle2.width + 1);
                int n4 = Math.min(this.height, rectangle2.y + rectangle2.height + 1);
                Point point = iGraphics.getGraphicPoint(d + (d10 * (double)n - d9 * (double)n2) * d5, d2 - (d9 * (double)n + d10 * (double)n2) * d5, new Point());
                int n5 = point.x;
                int n6 = point.y;
                Rectangle rectangle3 = new Rectangle(n, n2, n3 - n, n4 - n2);
                Rotate rotate = null;
                Rectangle rectangle4 = new Rectangle(0, 0, (int)Math.rint((double)(n3 - n) * d5 * d8), (int)Math.rint((double)(n4 - n2) * d5 * d8));
                if ((d7 += d6) != 0.0) {
                    rotate = new Rotate(-d7 * 180.0 / Math.PI);
                    rotate.transformSpace(rectangle4);
                    n5 += rectangle4.x;
                    n6 += rectangle4.y;
                }
                boolean bl3 = this.alphaAlternate;
                if (this instanceof WmsGeoImage) {
                    bl3 = false;
                }
                int n7 = this.alpha + (bl3 ? 1 : 0) + this.bright + this.contrast;
                if (this.viewImage == null || !this.lastArea.equals(rectangle3) || this.lastScale != d8 || this.lastAngle != d7 || this.lastColor != n7 || this.lastSharp != this.sharp || this.lastGray != this.gray || this.lastY != d || this.lastX != d2) {
                    if (this.viewImage != null) {
                        this.viewImage.flush();
                    }
                    ImageProducer imageProducer = this.raster.getCroppedImageProducer((int)Math.rint(n), (int)Math.rint(n2), (int)Math.rint(n3 - n), (int)Math.rint(n4 - n2));
                    double d13 = Math.abs(Math.sin(d7) * (double)Math.max(rectangle4.width, rectangle4.height));
                    if (d8 * d5 > 1.0) {
                        if (this.gray != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new GrayFilter(this.gray));
                        }
                        if (n7 != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new ColorFilter(this.alpha, this.bright, this.contrast, bl3));
                        }
                        if (this.sharp != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new PassFilter(imageProducer, this.sharp / 20));
                        }
                        if (d13 > 1.0) {
                            imageProducer = new FilteredImageSource(imageProducer, rotate);
                        }
                        imageProducer = new FilteredImageSource(imageProducer, new ReplicateScaleFilter(rectangle4.width, rectangle4.height));
                    } else {
                        imageProducer = new FilteredImageSource(imageProducer, new ReplicateScaleFilter((int)Math.rint((double)(n3 - n) * d5 * d8), (int)Math.rint((double)(n4 - n2) * d5 * d8)));
                        if (this.gray != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new GrayFilter(this.gray));
                        }
                        if (n7 != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new ColorFilter(this.alpha, this.bright, this.contrast, bl3));
                        }
                        if (this.sharp != 0) {
                            imageProducer = new FilteredImageSource(imageProducer, new PassFilter(imageProducer, this.sharp / 20));
                        }
                        if (d13 > 1.0) {
                            imageProducer = new FilteredImageSource(imageProducer, rotate);
                        }
                    }
                    this.viewImage = Toolkit.getDefaultToolkit().createImage(imageProducer);
                    GraphicsUtils.waitForImage(this.viewImage);
                    this.lastArea = rectangle3;
                    this.lastScale = d8;
                    this.lastAngle = d7;
                    this.lastColor = n7;
                    this.lastSharp = this.sharp;
                    this.lastGray = this.gray;
                    this.lastY = d;
                    this.lastX = d2;
                }
                iGraphics.getGraphics().drawImage(this.viewImage, n5, n6, null);
            }
            catch (Exception exception) {
                if (!KafPlot.debug()) break block18;
                exception.printStackTrace();
            }
        }
    }

    private void _writeImage(Image image, String string) {
        try {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string + ".png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawControls(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isControlsVisible || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        Enumeration<ImageControlPoint> enumeration = this.loc.trafoElements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            if (!imageControlPoint.isValid() || !imageControlPoint.isUsed()) continue;
            this.drawControl(iGraphics, imageControlPoint, bl, bl2);
        }
    }

    public void drawControl(IGraphics iGraphics, ImageControlPoint imageControlPoint, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setXORMode(KafPlotColor.RAISED);
        } else {
            graphics.setPaintMode();
        }
        Punkt punkt = imageControlPoint.getPunkt();
        DPoint dPoint = imageControlPoint.getImagePoint();
        DPoint dPoint2 = this.loc.transform(dPoint.x, dPoint.y);
        if (punkt == null || dPoint == null || dPoint2 == null) {
            return;
        }
        if (iGraphics.contains(punkt) || iGraphics.contains(dPoint2)) {
            Object object;
            Object object2;
            int n;
            BasicStroke basicStroke = this.digitWidth > 10 ? CONTROL_LINE_2 : CONTROL_LINE_1;
            int n2 = n = this.digitWidth >= 10 ? 4 : 2;
            if (this.isControlVisible()) {
                if (this.isDigitVisible()) {
                    if (this.isHighlight() && !bl2) {
                        graphics.setColor(HIGHLIGHT_COLOR);
                        iGraphics.drawOval(punkt, n, HIGHLIGHT_LINE, false);
                    }
                    graphics.setColor(imageControlPoint.isEnabled() ? this.controlColor : DISABLE_COLOR);
                    iGraphics.fillOval(punkt, n, basicStroke, false);
                    iGraphics.drawLine(dPoint2, punkt);
                } else {
                    if (this.isHighlight() && !bl2) {
                        graphics.setColor(HIGHLIGHT_COLOR);
                        iGraphics.drawOval(punkt, n * 2, HIGHLIGHT_LINE, false);
                    }
                    graphics.setColor(imageControlPoint.isEnabled() ? this.controlColor : DISABLE_COLOR);
                    iGraphics.drawOval(punkt, n * 2, basicStroke, false);
                }
            }
            if (this.isDigitVisible()) {
                if (this.digitWidth >= 10) {
                    if (this.isHighlight() && !bl2) {
                        graphics.setColor(HIGHLIGHT_COLOR);
                        iGraphics.drawOval(dPoint2, this.digitWidth, HIGHLIGHT_LINE, false);
                    }
                    graphics.setColor(imageControlPoint.isEnabled() ? this.controlColor : DISABLE_COLOR);
                    iGraphics.drawOval(dPoint2, this.digitWidth, basicStroke, false);
                }
                double d = Math.max(8.0, (double)this.digitWidth * 0.75) / iGraphics.getScale() / this.loc.getScale();
                object2 = this.loc.transform(dPoint.x - d, dPoint.y);
                object = this.loc.transform(dPoint.x + d, dPoint.y);
                iGraphics.drawLine((DPoint)object2, (DPoint)object, basicStroke, false, false);
                object2 = this.loc.transform(dPoint.x, dPoint.y - d);
                object = this.loc.transform(dPoint.x, dPoint.y + d);
                iGraphics.drawLine((DPoint)object2, (DPoint)object, basicStroke, false, false);
            }
            if (this.isGapVisible()) {
                Font font = KafPlotProperties.getPeFont();
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                graphics.setFont(font);
                object2 = new Point();
                object = new Point();
                String string = IFormat.f1_2.format(imageControlPoint.getRs());
                int n3 = this.digitWidth + 2;
                object2 = iGraphics.getGraphicPoint(punkt, (Point)object2);
                if (this.isDigitVisible()) {
                    object = iGraphics.getGraphicPoint(dPoint2, (Point)object);
                } else {
                    object = object2;
                    n3 = n * 3;
                }
                int n4 = fontMetrics.stringWidth(string);
                ((Point)object).x -= n4 / 2;
                ((Point)object).y = ((Point)object2).y < ((Point)object).y ? ((Point)object).y + n3 + fontMetrics.getHeight() - fontMetrics.getDescent() : ((Point)object).y - n3 - fontMetrics.getDescent();
                if (this.isHighlight() && !bl2) {
                    graphics.setColor(HIGHLIGHT_COLOR);
                    graphics.fillRect(((Point)object).x - 2, ((Point)object).y - fontMetrics.getAscent(), n4 + 4, fontMetrics.getAscent() + fontMetrics.getDescent());
                }
                graphics.setColor(imageControlPoint.isEnabled() ? this.controlColor : DISABLE_COLOR);
                graphics.drawString(string, ((Point)object).x, ((Point)object).y);
            }
        }
    }
}

