/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.ImageControlPoint;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class GeoImageLocation
extends InputObject
implements DataBaseListener {
    public static final int INPUT_LOCATION = 1;
    public static final int INPUT_CONTROLS = 2;
    public static final int INPUT_CLIP = 3;
    public static final int INPUT_MOVE = 4;
    public static final int INPUT_RESIZE = 5;
    private double y;
    private double x;
    private double r;
    private double scale;
    private double centerX;
    private double centerY;
    private double midRs;
    private double minRs;
    private double maxRs;
    private Vector<ImageControlPoint> PP = new Vector();
    private Rectangle clip = null;
    private Point anchor = null;
    private ImageControlPoint controlPoint;
    private DPoint imgPoint;
    private int inputMode = 2;
    GeoImage parent;
    private static final BasicStroke CURSOR = new BasicStroke(2.0f);

    public GeoImageLocation(GeoImage geoImage) {
        this.parent = geoImage;
        if (geoImage == null) {
            throw new NullPointerException(this.getClassName() + " mit leerem Image");
        }
        this.init();
    }

    public boolean isModifiable() {
        return !(this.parent instanceof WmsGeoImage);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void setInputMode(int n) {
        this.inputMode = n;
        this.step = 0;
        this.clip = null;
        this.anchor = null;
        this.imgPoint = null;
        this.controlPoint = null;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setParent(GeoImage geoImage) {
        this.parent = geoImage;
    }

    public GeoImage getParent() {
        return this.parent;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GeoImageLocation) {
            GeoImageLocation geoImageLocation = (GeoImageLocation)object;
            return this.y == geoImageLocation.y && this.x == geoImageLocation.x && this.r == geoImageLocation.r && this.scale == geoImageLocation.scale;
        }
        return false;
    }

    public boolean hasLocation() {
        return this.scale != 0.0;
    }

    public void setLocation(double d, double d2) {
        this.y = d;
        this.x = d2;
    }

    public void moveLocation(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        this.y += d;
        this.x += d2;
    }

    public void rotate(double d) {
        if (d == 0.0) {
            return;
        }
        if (this.centerY == 0.0 && this.centerX == 0.0) {
            DPoint dPoint = this.transform(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
            this.centerY = dPoint.y;
            this.centerX = dPoint.x;
        }
        double d2 = this.y - this.centerY;
        double d3 = this.x - this.centerX;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d2, d3) + d;
        this.y = this.centerY + d4 * Math.sin(d5);
        this.x = this.centerX + d4 * Math.cos(d5);
        this.r += d;
    }

    public double getRotateOfPixel() {
        return Math.atan2(1.0, (double)Math.max(this.parent.getWidth(), this.parent.getHeight()) / 2.0);
    }

    public void setLocation(DPoint dPoint) {
        this.setLocation(dPoint.y, dPoint.x);
    }

    public DPoint getLocation() {
        return new DPoint(this.y, this.x);
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public void setAngle(double d) {
        this.r = d;
    }

    public double getAngle() {
        return this.r;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public DDimension getSize() {
        return new DDimension(this.getWidth(), this.getHeight());
    }

    public double getWidth() {
        return (double)this.parent.getWidth() * this.scale;
    }

    public double getHeight() {
        return (double)this.parent.getHeight() * this.scale;
    }

    public double getMinRs() {
        return this.minRs;
    }

    public double getMaxRs() {
        return this.maxRs;
    }

    public double getMidRs() {
        return this.midRs;
    }

    public DPoint getGravityCentre() {
        return new DPoint(this.centerY, this.centerX);
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        for (int i = this.PP.size() - 1; i >= 0; --i) {
            ImageControlPoint imageControlPoint = this.PP.elementAt(i);
            Punkt punkt = (Punkt)DataBase.P.get(imageControlPoint.getNr());
            if (punkt == null) {
                this.PP.removeElementAt(i);
                continue;
            }
            imageControlPoint.setPunkt(punkt);
        }
        this.transform();
    }

    public String toString() {
        return "GeoImageLocation: y=" + IFormat.f_3.format(this.y) + " x=" + IFormat.f_3.format(this.y) + " w=" + IFormat.f_3.format(this.getWidth()) + " h=" + IFormat.f_3.format(this.getHeight());
    }

    @Override
    public int dataMode() {
        return 2;
    }

    @Override
    public int steps() {
        if (this.inputMode == 3) {
            return 2;
        }
        if (this.inputMode == 4) {
            return 1;
        }
        if (this.inputMode == 5) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int need() {
        if (this.inputMode == 3) {
            return 32;
        }
        if (this.inputMode == 4) {
            return 32;
        }
        if (this.inputMode == 5) {
            return 32;
        }
        if (this.inputMode == 2) {
            return 64;
        }
        if (this.inputMode == 1) {
            return this.step % 2 == 0 ? 32 : 64;
        }
        return 0;
    }

    @Override
    public boolean accept(Object object) {
        if (this.inputMode == 2 && object instanceof Punkt) {
            Enumeration<ImageControlPoint> enumeration = this.PP.elements();
            while (enumeration.hasMoreElements()) {
                ImageControlPoint imageControlPoint = enumeration.nextElement();
                if (!imageControlPoint.isValid() || imageControlPoint.getPunkt() != object) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (this.inputMode == 3) {
            if (this.step == 0 && object instanceof DPoint) {
                DPoint dPoint = this.inverse((DPoint)object);
                dPoint.x = Math.max(0.0, dPoint.x);
                dPoint.y = Math.max(0.0, dPoint.y);
                dPoint.x = Math.min((double)this.parent.getWidth(), dPoint.x);
                dPoint.y = Math.min((double)this.parent.getHeight(), dPoint.y);
                this.clip = new Rectangle((int)Math.rint(dPoint.x), (int)Math.rint(dPoint.y), 0, 0);
                if (bl) {
                    ++this.step;
                }
            } else if (this.step == 1 && object instanceof DPoint) {
                DPoint dPoint = this.inverse((DPoint)object);
                this.clip.width = (int)Math.rint(dPoint.x - (double)this.clip.x);
                this.clip.width = this.clip.width < 0 ? Math.max(-this.clip.x, this.clip.width) : Math.min(this.parent.getWidth() - this.clip.x, this.clip.width);
                this.clip.height = (int)Math.rint(dPoint.y - (double)this.clip.y);
                this.clip.height = this.clip.height < 0 ? Math.max(-this.clip.y, this.clip.height) : Math.min(this.parent.getHeight() - this.clip.y, this.clip.height);
                if (bl) {
                    if (this.clip.width < 0) {
                        this.clip.x += this.clip.width;
                        this.clip.width = -this.clip.width;
                    }
                    if (this.clip.height < 0) {
                        this.clip.y += this.clip.height;
                        this.clip.height = -this.clip.height;
                    }
                    ++this.step;
                }
            }
        } else if (this.inputMode == 4) {
            this.imgPoint = (DPoint)object;
            if (bl && this.imgPoint != null) {
                DPoint dPoint = this.transform(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
                this.y += this.imgPoint.y - dPoint.y;
                this.x += this.imgPoint.x - dPoint.x;
                this.setTrafoAllEnabled(false);
                ++this.step;
            }
        } else if (this.inputMode == 5) {
            this.imgPoint = (DPoint)object;
            if (bl && this.imgPoint != null) {
                DPoint dPoint = this.transform(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
                double d = this.imgPoint.y - dPoint.y;
                double d2 = this.imgPoint.x - dPoint.x;
                double d3 = Math.sqrt(d2 * d2 + d * d) * 2.0 / Math.sqrt(this.parent.getWidth() * this.parent.getWidth() + this.parent.getHeight() * this.parent.getHeight());
                DPoint dPoint2 = this.transformWithScale(this.parent.getWidth() / 2, this.parent.getHeight() / 2, d3);
                this.y += dPoint.y - dPoint2.y;
                this.x += dPoint.x - dPoint2.x;
                this.scale = d3;
                this.setTrafoAllEnabled(false);
                ++this.step;
            }
        } else if (this.inputMode == 1) {
            if (object == null && this.step > 0) {
                --this.step;
            } else if (this.step % 2 == 0 && object instanceof DPoint) {
                this.imgPoint = (DPoint)object;
                this.controlPoint = new ImageControlPoint(this.inverse(this.imgPoint), null);
                if (bl) {
                    ++this.step;
                }
            } else if (this.step % 2 == 1 && object instanceof Punkt && this.controlPoint != null) {
                this.controlPoint.setPunkt((Punkt)object);
                if (bl) {
                    this.addTrafoPoint(this.controlPoint);
                    this.sendInputEvent(this.controlPoint);
                    this.imgPoint = null;
                    this.controlPoint = null;
                    ++this.step;
                }
            }
        } else if (this.inputMode == 2 && object != null && object instanceof Punkt) {
            this.controlPoint = this.getTrafoPoint(((Punkt)object).nr);
            if (this.controlPoint != null && bl) {
                this.controlPoint.setEnabled(!this.controlPoint.isEnabled());
                this.sendInputEvent(this.controlPoint);
                this.controlPoint = null;
                ++this.step;
            }
        }
    }

    @Override
    public Object getDefault() {
        if (this.inputMode == 3) {
            return new DPoint();
        }
        if (this.inputMode == 4) {
            return new DPoint();
        }
        if (this.inputMode == 5) {
            return new DPoint();
        }
        if (this.step % 2 == 0) {
            return new DPoint();
        }
        return new Long(InputProperties.getNextReservedNumber());
    }

    @Override
    public Cursor getCurrentCursor() {
        if (this.inputMode == 3) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.inputMode == 4) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.inputMode == 5) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.inputMode == 1) {
            return this.step % 2 == 0 ? Cursor.getPredefinedCursor(1) : Cursor.getDefaultCursor();
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean isReady() {
        if (this.inputMode == 1) {
            return this.step % 2 == 0;
        }
        return this.step >= 1;
    }

    @Override
    public boolean isAbortable() {
        if (this.inputMode == 1) {
            return this.step % 2 == 0;
        }
        return true;
    }

    @Override
    public boolean isVoid() {
        if (this.inputMode == 2) {
            return this.controlPoint == null;
        }
        return this.imgPoint == null;
    }

    public boolean hasClip() {
        return this.clip != null;
    }

    public Rectangle getClipRect() {
        if (this.clip == null) {
            return new Rectangle(0, 0, this.parent.getWidth(), this.parent.getHeight());
        }
        return this.clip;
    }

    public DRectangle getClipDRect() {
        if (this.clip == null) {
            return new DRectangle(0.0, 0.0, this.parent.getWidth(), this.parent.getHeight());
        }
        return new DRectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public void removeClip() {
        this.clip = null;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.clip = new Rectangle(n, n2, n3, n4);
    }

    public DRectangle getImageBounds() {
        return this.getImagePolygon().getBounds();
    }

    public DPolygon getImagePolygon() {
        DPolygon dPolygon = new DPolygon(4);
        dPolygon.addPoint(this.transform(0, 0));
        dPolygon.addPoint(this.transform(this.parent.getWidth(), 0));
        dPolygon.addPoint(this.transform(this.parent.getWidth(), this.parent.getHeight()));
        dPolygon.addPoint(this.transform(0, this.parent.getHeight()));
        return dPolygon;
    }

    public DPolygon getImagePolygonWithScale(double d) {
        DPolygon dPolygon = new DPolygon(4);
        dPolygon.addPoint(this.transformWithScale(0.0, 0.0, d));
        dPolygon.addPoint(this.transformWithScale(this.parent.getWidth(), 0.0, d));
        dPolygon.addPoint(this.transformWithScale(this.parent.getWidth(), this.parent.getHeight(), d));
        dPolygon.addPoint(this.transformWithScale(0.0, this.parent.getHeight(), d));
        return dPolygon;
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        DRectangle dRectangle = this.getImageBounds();
        d = Math.min(d, dRectangle.x);
        d2 = Math.min(d2, dRectangle.y);
        d3 = Math.max(d3, dRectangle.x + dRectangle.height);
        d4 = Math.max(d4, dRectangle.y + dRectangle.width);
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = enumeration.nextElement().getPunkt();
            d = Math.min(d, punkt.x);
            d2 = Math.min(d2, punkt.y);
            d3 = Math.max(d3, punkt.x);
            d4 = Math.max(d4, punkt.y);
        }
        return new DRectangle(d2, d, d4 - d2, d3 - d);
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inputMode == 3) {
            if (this.clip == null) {
                stringBuffer.append("Ausschnitt w\u00e4hlen");
            } else {
                stringBuffer.append("Ausschnitt: ");
                stringBuffer.append(Integer.toString(this.clip.x));
                stringBuffer.append(", ");
                stringBuffer.append(Integer.toString(this.clip.y));
                if (this.clip.width != 0 && this.clip.height != 0) {
                    stringBuffer.append(", ");
                    stringBuffer.append(Integer.toString(this.clip.width));
                    stringBuffer.append(", ");
                    stringBuffer.append(Integer.toString(this.clip.height));
                }
            }
        } else if (this.inputMode == 4) {
            if (this.imgPoint == null) {
                stringBuffer.append("Neue Bildposition w\u00e4hlen");
            } else {
                stringBuffer.append("Bildposition: " + IFormat.f_3.format(this.imgPoint.y) + ", " + IFormat.f_3.format(this.imgPoint.x));
            }
        } else if (this.inputMode == 5) {
            stringBuffer.append("Neue Bildgr\u00f6\u00dfe w\u00e4hlen");
        } else if (this.step % 2 == 0) {
            if (this.imgPoint == null) {
                stringBuffer.append("Bildpunkt w\u00e4hlen");
            } else {
                stringBuffer.append("Bildpunkt: ");
                stringBuffer.append(Integer.toString((int)Math.rint(this.imgPoint.x)));
                stringBuffer.append(", ");
                stringBuffer.append(Integer.toString((int)Math.rint(this.imgPoint.y)));
            }
        } else if (this.controlPoint == null) {
            stringBuffer.append("Passpunkt w\u00e4hlen");
        } else {
            stringBuffer.append("Passpunkt: ");
            stringBuffer.append(Long.toString(this.controlPoint.getNr()));
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Image-Georeferenzierung";
    }

    @Override
    public String getObjectName() {
        return this.parent.getName();
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = enumeration.nextElement().getPunkt();
            d += punkt.y;
            d2 += punkt.x;
            ++n;
        }
        return new DPoint(d / (double)n, d2 / (double)n);
    }

    public void clear() {
        this.PP.clear();
        this.init();
    }

    public void clearPoints() {
        this.PP.clear();
    }

    private void init() {
        this.y = DataBase.ymin;
        this.x = DataBase.xmax;
        int n = this.parent.getWidth();
        int n2 = this.parent.getHeight();
        this.scale = n != 0 && n2 != 0 ? (DataBase.ymax - DataBase.ymin != 0.0 ? (DataBase.ymax - DataBase.ymin) / (double)n : 1.0) : 1.0;
        this.r = 0.0;
    }

    public int trafoPointCount(boolean bl) {
        int n = 0;
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            if ((bl || !imageControlPoint.isValid()) && !imageControlPoint.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    public Enumeration<ImageControlPoint> trafoElements() {
        return this.PP.elements();
    }

    public void addTrafoPoint(ImageControlPoint imageControlPoint) {
        for (int i = 0; i < this.PP.size(); ++i) {
            ImageControlPoint imageControlPoint2 = this.PP.elementAt(i);
            if (imageControlPoint2.getNr() != imageControlPoint.getNr()) continue;
            this.PP.setElementAt(imageControlPoint, i);
            return;
        }
        this.PP.add(imageControlPoint);
    }

    public ImageControlPoint getTrafoPoint(long l) {
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            if (imageControlPoint.getNr() != l) continue;
            return imageControlPoint;
        }
        return null;
    }

    public boolean setTrafoPointEnabled(long l, boolean bl) {
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            if (imageControlPoint.getNr() != l) continue;
            imageControlPoint.setEnabled(bl);
            return true;
        }
        return false;
    }

    public void setTrafoAllEnabled(boolean bl) {
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setEnabled(bl);
        }
    }

    public boolean setTrafoPointValid(long l, boolean bl) {
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            if (imageControlPoint.getNr() != l) continue;
            imageControlPoint.setValid(bl);
            return true;
        }
        return false;
    }

    public void setTrafoAllValid(boolean bl) {
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setValid(bl);
        }
    }

    public int removeTrafoInvalids() {
        int n = 0;
        for (int i = this.PP.size() - 1; i >= 0; --i) {
            ImageControlPoint imageControlPoint = this.PP.elementAt(i);
            if (imageControlPoint.isValid()) continue;
            this.PP.removeElementAt(i);
            ++n;
        }
        return n;
    }

    public int removeTrafoAll() {
        int n = this.PP.size();
        this.PP.removeAllElements();
        return n;
    }

    public void transform() {
        Object object;
        int n;
        DPoint dPoint;
        Object object2;
        Object object3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        Enumeration<ImageControlPoint> enumeration = this.PP.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            if (!((ImageControlPoint)object3).isValid()) continue;
            ((ImageControlPoint)object3).setUsed(true);
            if (((ImageControlPoint)object3).isEnabled()) {
                object2 = ((ImageControlPoint)object3).getPunkt();
                dPoint = ((ImageControlPoint)object3).getImagePoint();
                d += dPoint.x;
                d2 += -dPoint.y;
                d3 += ((DPoint)object2).y;
                d4 += ((DPoint)object2).x;
                ++n2;
            }
            ++n3;
        }
        int n4 = n = n2 > 0 ? n2 : n3;
        if (n2 == 1) {
            object3 = this.PP.elements();
            while (object3.hasMoreElements()) {
                object2 = (ImageControlPoint)object3.nextElement();
                if (!((ImageControlPoint)object2).isEnabled()) continue;
                dPoint = ((ImageControlPoint)object2).getPunkt();
                object = this.transform(((ImageControlPoint)object2).getImagePoint());
                this.y += dPoint.y - ((DPoint)object).y;
                this.x += dPoint.x - ((DPoint)object).x;
                this.centerY = dPoint.y;
                this.centerX = dPoint.x;
                break;
            }
        } else if (n2 > 1) {
            double d5;
            d /= (double)n2;
            d2 /= (double)n2;
            this.centerY = d3 /= (double)n2;
            this.centerX = d4 /= (double)n2;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            Enumeration<ImageControlPoint> enumeration2 = this.PP.elements();
            while (enumeration2.hasMoreElements()) {
                ImageControlPoint imageControlPoint = enumeration2.nextElement();
                if (!imageControlPoint.isEnabled()) continue;
                Punkt punkt = imageControlPoint.getPunkt();
                DPoint dPoint2 = imageControlPoint.getImagePoint();
                d5 = dPoint2.x - d;
                double d13 = -dPoint2.y - d2;
                double d14 = punkt.y - d3;
                double d15 = punkt.x - d4;
                d6 += d5 * d5;
                d7 += d13 * d13;
                d8 += d13 * d5;
                d9 += d13 * d14;
                d10 += d13 * d15;
                d11 += d5 * d14;
                d12 += d5 * d15;
            }
            double d16 = d6 + d7;
            double d17 = (d9 - d12) / d16;
            d5 = (d10 + d11) / d16;
            this.scale = Math.sqrt(d17 * d17 + d5 * d5);
            this.r = Math.atan2(d17, d5);
            this.y = d3 - d5 * d - d17 * d2;
            this.x = d4 - d5 * d2 + d17 * d;
        }
        if (n3 > 0) {
            double d18 = 0.0;
            this.minRs = Double.MAX_VALUE;
            this.maxRs = -1.7976931348623157E308;
            Enumeration<ImageControlPoint> enumeration3 = this.PP.elements();
            while (enumeration3.hasMoreElements()) {
                object = enumeration3.nextElement();
                Punkt punkt = ((ImageControlPoint)object).getPunkt();
                DPoint dPoint3 = ((ImageControlPoint)object).getImagePoint();
                DPoint dPoint4 = this.transform(dPoint3);
                ((ImageControlPoint)object).setRs(punkt.y - dPoint4.y, punkt.x - dPoint4.x);
                if ((n2 <= 0 || !((ImageControlPoint)object).isEnabled()) && (n2 != 0 || !((ImageControlPoint)object).isValid())) continue;
                double d19 = ((ImageControlPoint)object).getRs();
                this.minRs = Math.min(this.minRs, d19);
                this.maxRs = Math.max(this.maxRs, d19);
                d18 += d19;
            }
            this.midRs = d18 / (double)n;
        } else {
            this.midRs = 0.0;
            this.maxRs = 0.0;
            this.minRs = 0.0;
        }
    }

    public DPoint transform(int n, int n2) {
        return this.transform(new DPoint(n2, n));
    }

    public DPoint transform(DPoint dPoint) {
        return this.transform(dPoint.x, dPoint.y);
    }

    public DPoint transform(double d, double d2) {
        return new DPoint(this.y + (d * Math.cos(this.r) * this.scale - d2 * Math.sin(this.r) * this.scale), this.x - (d * Math.sin(this.r) * this.scale + d2 * Math.cos(this.r) * this.scale));
    }

    private DPoint transformWithScale(double d, double d2, double d3) {
        return new DPoint(this.y + (d * Math.cos(this.r) * d3 - d2 * Math.sin(this.r) * d3), this.x - (d * Math.sin(this.r) * d3 + d2 * Math.cos(this.r) * d3));
    }

    public DPoint inverse(DPoint dPoint) {
        double d = dPoint.y - this.y;
        double d2 = this.x - dPoint.x;
        double d3 = Math.sin(this.r);
        double d4 = Math.cos(this.r);
        return new DPoint((d4 * d2 - d3 * d) / this.scale, (d4 * d + d3 * d2) / this.scale);
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (bl2) {
            if (this.inputMode == 3 && this.clip != null) {
                DPoint dPoint = this.transform(this.clip.x, this.clip.y);
                DPoint dPoint2 = this.transform(this.clip.x + this.clip.width, this.clip.y);
                DPoint dPoint3 = this.transform(this.clip.x, this.clip.y + this.clip.height);
                DPoint dPoint4 = this.transform(this.clip.x + this.clip.width, this.clip.y + this.clip.height);
                iGraphics.drawLine(dPoint, dPoint2);
                iGraphics.drawLine(dPoint2, dPoint4);
                iGraphics.drawLine(dPoint4, dPoint3);
                iGraphics.drawLine(dPoint3, dPoint);
            } else if (this.inputMode == 4) {
                if (this.imgPoint != null) {
                    DPoint dPoint = this.transform(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
                    DPolygon dPolygon = this.getImagePolygon();
                    dPolygon.translate(this.imgPoint.y - dPoint.y, this.imgPoint.x - dPoint.x);
                    iGraphics.drawPolygon(dPolygon);
                }
            } else if (this.inputMode == 5) {
                if (this.imgPoint != null) {
                    DPoint dPoint = this.transform(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
                    double d = this.imgPoint.y - dPoint.y;
                    double d2 = this.imgPoint.x - dPoint.x;
                    double d3 = Math.sqrt(d2 * d2 + d * d) * 2.0 / Math.sqrt(this.parent.getWidth() * this.parent.getWidth() + this.parent.getHeight() * this.parent.getHeight());
                    DPolygon dPolygon = this.getImagePolygonWithScale(d3);
                    DPoint dPoint5 = this.transformWithScale(this.parent.getWidth() / 2, this.parent.getHeight() / 2, d3);
                    dPolygon.translate(dPoint.y - dPoint5.y + 3.0, dPoint.x - dPoint5.x + 3.0);
                    iGraphics.drawPolygon(dPolygon);
                }
            } else if (this.inputMode == 1) {
                Enumeration<ImageControlPoint> enumeration = this.PP.elements();
                while (enumeration.hasMoreElements()) {
                    ImageControlPoint imageControlPoint = enumeration.nextElement();
                    if (imageControlPoint.isUsed()) continue;
                    this.drawPoint(iGraphics, bl, bl2, imageControlPoint);
                }
                if (this.controlPoint != null) {
                    this.drawPoint(iGraphics, bl, bl2, this.controlPoint);
                }
            } else if (this.inputMode == 2 && this.controlPoint != null) {
                this.getParent().drawControl(iGraphics, this.controlPoint, bl, bl2);
            }
        }
    }

    private void drawPoint(IGraphics iGraphics, boolean bl, boolean bl2, ImageControlPoint imageControlPoint) {
        Punkt punkt = imageControlPoint.getPunkt();
        DPoint dPoint = imageControlPoint.getImagePoint();
        if (dPoint != null) {
            DPoint dPoint2 = this.transform(dPoint);
            Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
            Graphics graphics = iGraphics.getGraphics();
            int n = this.parent.getDigitWidth();
            if (punkt == null) {
                if (bl2) {
                    graphics.setColor(Color.white);
                    graphics.setXORMode(Color.black);
                }
                iGraphics.setStroke(CURSOR);
                graphics.drawLine(point.x - n, point.y, point.x - n * 2, point.y);
                graphics.drawLine(point.x + n, point.y, point.x + n * 2, point.y);
                graphics.drawLine(point.x, point.y - n, point.x, point.y - n * 2);
                graphics.drawLine(point.x, point.y + n, point.x, point.y + n * 2);
                if (n >= 10) {
                    int n2 = n * 3 / 2;
                    graphics.drawOval(point.x - n2, point.y - n2, n2 * 2, n2 * 2);
                }
                iGraphics.resetStroke();
            } else {
                if (bl2) {
                    iGraphics.setXORMode();
                }
                graphics.drawLine(point.x - n, point.y, point.x + n, point.y);
                graphics.drawLine(point.x, point.y - n, point.x, point.y + n);
                Point point2 = iGraphics.getGraphicPoint(punkt, new Point());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                punkt.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                if (this.parent.isGapVisible()) {
                    Font font = KafPlotProperties.getPeFont();
                    FontMetrics fontMetrics = graphics.getFontMetrics(font);
                    graphics.setFont(font);
                    String string = IFormat.f1_2.format(punkt.getDistance(dPoint2));
                    int n3 = fontMetrics.stringWidth(string);
                    point.x -= n3 / 2;
                    point.y = point2.y < point.y ? point.y + n + fontMetrics.getHeight() - fontMetrics.getDescent() : point.y - n - fontMetrics.getDescent();
                    graphics.drawString(string, point.x, point.y);
                }
            }
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }
}

