/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IException;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.INumTextField;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;

public class GeoImageLocationDialog
extends IOptionDialog
implements ActionListener,
ItemListener,
DataBaseListener {
    private GeoImage img;
    private ILabel nL;
    private INumTextField yTF;
    private INumTextField xTF;
    private INumTextField mTF;
    private INumTextField aTF;

    public GeoImageLocationDialog(IFrame iFrame, String string) {
        super(iFrame, string);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        ILabel iLabel = new ILabel("Name: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.nL = new ILabel("");
        iPanel.add(this.nL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.nL, gridBagConstraints);
        iLabel = new ILabel("Rechtswert: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.yTF = new INumTextField(20);
        iPanel.add(this.yTF);
        this.yTF.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.yTF, gridBagConstraints);
        iLabel = new ILabel("m");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        iLabel = new ILabel("Hochwert: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.xTF = new INumTextField(20);
        iPanel.add(this.xTF);
        this.xTF.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.xTF, gridBagConstraints);
        iLabel = new ILabel("m");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        iLabel = new ILabel("Ma\u00dfstab: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.mTF = new INumTextField(20);
        iPanel.add(this.mTF);
        this.mTF.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.mTF, gridBagConstraints);
        iLabel = new ILabel("Drehung: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.aTF = new INumTextField(20);
        iPanel.add(this.aTF);
        this.aTF.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.aTF, gridBagConstraints);
        iLabel = new ILabel("gon");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        return iPanel;
    }

    public void setGeoImage(GeoImage geoImage) {
        this.img = geoImage;
        GeoImageLocation geoImageLocation = geoImage.getImageLocation();
        this.nL.setText(geoImage.getName());
        this.yTF.setText(IFormat.f_3.format(geoImageLocation.getLocation().y));
        this.xTF.setText(IFormat.f_3.format(geoImageLocation.getLocation().x));
        this.mTF.setText(IFormat.f_4.format(geoImageLocation.getScale()));
        this.aTF.setText(IFormat.f_4.format(geoImageLocation.getAngle() * 200.0 / Math.PI));
    }

    @Override
    protected void setOptions() {
        GeoImageLocation geoImageLocation = this.img.getImageLocation();
        try {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            try {
                d = new Double(this.yTF.getText());
            }
            catch (Exception exception) {
                throw new IException("ung\u00fcltiger Wert im Feld Rechtswert");
            }
            try {
                d2 = new Double(this.xTF.getText());
            }
            catch (Exception exception) {
                throw new IException("ung\u00fcltiger Wert im Feld Hochwert");
            }
            try {
                d3 = new Double(this.mTF.getText());
            }
            catch (Exception exception) {
                throw new IException("ung\u00fcltiger Wert im Feld Ma\u00dfstab");
            }
            try {
                d4 = new Double(this.aTF.getText());
            }
            catch (Exception exception) {
                throw new IException("ung\u00fcltiger Wert im Feld Drehung");
            }
            geoImageLocation.setLocation(d, d2);
            geoImageLocation.setScale(d3);
            geoImageLocation.setAngle(d4 * Math.PI / 200.0);
        }
        catch (IException iException) {
            ErrorDialog errorDialog = new ErrorDialog(this.parent, iException.getMessage());
            errorDialog.setVisible(true);
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.setGeoImage(this.img);
    }
}

