/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IGraphics;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.PaintObject;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class GeoObject
extends GObject
implements PaintObject,
Comparable,
Exceptionable,
Messager {
    private int id = 0;
    private String className = null;
    private String name = null;
    private static final Text text = new Text(2, 2, null, 0.0, 0.0, 0.0, 1, 0);
    private static final TextSymbol sym = new TextSymbol(text, new Point());
    private static final Point p = new Point();

    @Override
    public LinieParameter getLineDefaults() {
        return LinieParameter.VOID;
    }

    @Override
    public void initGeom() {
        DRectangle dRectangle = this.getBounds();
        if (dRectangle.y == 0.0 && dRectangle.x == 0.0 && dRectangle.height == 0.0 && dRectangle.width == 0.0 && this.size() > 0) {
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = -1.7976931348623157E308;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                DRectangle dRectangle2 = ((GeomElement)enumeration.nextElement()).getBounds();
                d2 = Math.min(d2, dRectangle2.y);
                d = Math.min(d, dRectangle2.x);
                d4 = Math.max(d4, dRectangle2.y + dRectangle2.height);
                d3 = Math.max(d3, dRectangle2.x + dRectangle2.width);
            }
            this.setBounds(d2, d, d4 - d2, d3 - d);
            dRectangle = this.getBounds();
        }
        if (this.y == 0.0 && this.x == 0.0) {
            this.y = dRectangle.y + dRectangle.height / 2.0;
            this.x = dRectangle.x + dRectangle.width / 2.0;
        }
    }

    @Override
    public boolean defMultiArea() {
        return true;
    }

    @Override
    public boolean isVoid() {
        return this.id == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof GeoObject) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        GeoObject geoObject = (GeoObject)object;
        if (this.id == geoObject.id) {
            return 0;
        }
        if (this.id > geoObject.id) {
            return 1;
        }
        return -1;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void deleteName() {
        this.name = null;
    }

    @Override
    public Vector getKatasterNachweisLinien(ExceptionList exceptionList) {
        return new Vector(1);
    }

    @Override
    public final String toDatLine() {
        return "Geo";
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.y);
        dataOutput.writeDouble(this.x);
        if (this.yt != 0.0 || this.xt != 0.0) {
            dataOutput.writeByte(8);
            dataOutput.writeDouble(this.yt);
            dataOutput.writeDouble(this.xt);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(this.getFolie());
        dataOutput.writeShort(this.getOska());
        dataOutput.writeFloat(this.getTextAngle());
        dataOutput.writeInt(this.id);
        KafPlotIOConstants.writeString(dataOutput, this.name);
        dataOutput.writeByte(0);
    }

    public static GeoObject readObject(DataInput dataInput) throws IOException {
        GeoObject geoObject = new GeoObject();
        geoObject.y = dataInput.readDouble();
        geoObject.x = dataInput.readDouble();
        if (dataInput.readByte() != 0) {
            geoObject.yt = dataInput.readDouble();
            geoObject.xt = dataInput.readDouble();
        }
        geoObject.setFolie(dataInput.readShort());
        geoObject.setOska(dataInput.readShort());
        geoObject.setTextAngle(dataInput.readFloat());
        geoObject.id = dataInput.readInt();
        geoObject.name = KafPlotIOConstants.readString(dataInput);
        return geoObject;
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getName());
        return new Message(this, stringBuffer.toString());
    }

    public void setClassName(String string) {
        this.className = string;
    }

    @Override
    public String getClassName() {
        return this.className != null ? this.className : "GeoObjekt";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.id != 0) {
            stringBuffer.append(IFormat.i.format(this.id).toString());
        }
        if (this.hasLocation()) {
            stringBuffer.append(" Y=");
            stringBuffer.append(IFormat.f_3.format(this.y).toString());
            stringBuffer.append(" X=");
            stringBuffer.append(IFormat.f_3.format(this.x).toString());
        }
        if (this.name != null) {
            stringBuffer.append(" N=");
            stringBuffer.append(this.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (!this.isVisible()) {
            return;
        }
        if (bl2) {
            this.drawBackground(iGraphics, bl, bl2);
        }
        if (bl2) {
            this.drawForeground(iGraphics, bl, bl2);
        }
        this.drawInscription(iGraphics, bl, bl2);
        if (bl2) {
            this.drawHashpoint(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GeomElement)) continue;
            iGraphics.drawGeomElement((GeomElement)e);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        Color color = Color.black;
        graphics.setColor(color);
        double d = this.y;
        double d2 = this.x;
        boolean bl4 = bl3 = d != 0.0 && d2 != 0.0;
        if (!bl3) {
            d = KafPlotProperties.getGrafikCenter().y;
            d2 = KafPlotProperties.getGrafikCenter().x;
        }
        if (this.name != null && this.hasLocation() && iGraphics.contains(this.y, this.x)) {
            GeoObject.text.text = this.name;
            text.setTextWinkel(this.getTextAngle());
            GeoObject.sym.t = text;
            GeoObject.sym.p = iGraphics.getGraphicPoint(this.y, this.x, p);
            sym.paint(graphics);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        if (this.getName() != null) {
            stringBuffer.append(": ");
            stringBuffer.append(this.getName());
        }
        stringBuffer.append("\n");
        if (!bl3) {
            stringBuffer.append("  ohne Geometrie!\n");
        }
        Object object = this.attributes();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            stringBuffer.append("  ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(this.getAttribute(string));
            stringBuffer.append("\n");
        }
        object = new ErrorObject(new DPoint(d, d2), null, "GeoObject", stringBuffer.toString());
        ((ErrorObject)object).drawInscription(iGraphics, bl, bl2);
    }
}

