/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.kafplot.ArtKey;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.LinieParameter;
import de.geocalc.kafplot.NummerZuschlag;
import de.geocalc.kafplot.PropertyLoader;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktArt;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.NumberFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GeografProperties {
    private static Hashtable P_GRAF = new Hashtable();
    private static Hashtable L_GRAF = new Hashtable();
    private static Hashtable T_GRAF = new Hashtable();
    private static int DEFAULT_PA = 0;
    private static int DEFAULT_LA = 0;
    private static int DEFAULT_TA = 0;
    private static int DEFAULT_EB = 0;
    private static boolean withArt = true;
    private static boolean withEbene = true;
    private static boolean oskaModus = false;
    private static int amtNrModus = 0;
    private static NummerZuschlag lokNrZuschlag = null;
    private static String grafArtFile = "s500.art";
    private static String grafSymFile = "din.sym";
    private static String grafPenFile = "plotter.pen";
    private static String grafMacFile = "geograf.mde";
    private static String grafColFile = "g_color.col";
    private static String rissArtFile = "s500.art";
    private static String rissSymFile = "din1.sym";
    private static final int NK_OHNE = 0;
    private static final int NK_PA = 1;
    private static final int NK_VAT = 2;
    private static final int NK_EB = 3;
    private static final int NK_GGPA = 11;
    private static final int NK_GGEB = 12;
    private static char nkDelim = '\u0000';
    private static int lokalNkValue = 0;
    private static int amtlNkValue = 0;
    private static NumberFormat lokalNkFormat = null;
    private static NumberFormat amtlNkFormat = null;
    private static final Hashtable<AlkisEntry, String> alkisEntries = new Hashtable();
    private static boolean hasAlkisDefs = false;
    public static final int GEO_PK = 1;
    public static final int GEO_LI = 2;
    public static final int GEO_TX = 3;
    public static final int GEO_OO = 4;
    public static final int GEO_AA = 5;
    public static final int ART_FLST = 100;
    public static final int ART_GEB = 200;
    public static final int ART_NUTZ = 300;
    public static final int ART_BODS = 400;
    public static final int ART_TOP = 500;
    public static final int TYP_MARKE = 11;
    public static final int TYP_OHNE = 12;
    public static final int TYP_FLUR = 21;
    public static final int TYP_GMK = 22;
    public static final int TYP_GMD = 23;
    public static final int TYP_KREIS = 24;
    public static final int TYP_BEZ = 25;
    public static final int TYP_LAND = 26;
    public static final int TYP_NR = 31;
    public static final int TYP_NAME = 32;
    public static final int TYP_WHS = 41;
    public static final int TYP_WI = 42;
    public static final int TYP_OEF = 43;
    public static final int STA_INSERT = 1;
    public static final int STA_DELETE = 2;
    public static final int LGC_1 = 1;
    public static final int LGC_2 = 2;
    public static final int LGC_3 = 3;
    public static final int LGC_4 = 4;
    public static final int LGC_5 = 5;
    public static final int LGC_6 = 6;

    public static void setArtExport(boolean bl) {
        withArt = bl;
    }

    public static boolean getArtExport() {
        return withArt;
    }

    public static void setEbeneExport(boolean bl) {
        withEbene = bl;
    }

    public static boolean getEbeneExport() {
        return withEbene;
    }

    public static void setOskaModus(boolean bl) {
        oskaModus = bl;
    }

    public static boolean isOskaModus() {
        return oskaModus;
    }

    public static void setAmtNrModus(int n) {
        amtNrModus = n;
    }

    public static int getAmtNrModus() {
        return amtNrModus;
    }

    public static void setLokalNrZuschlag(NummerZuschlag nummerZuschlag) {
        lokNrZuschlag = nummerZuschlag;
    }

    public static NummerZuschlag getLokalNrZuschlag() {
        return lokNrZuschlag;
    }

    public static boolean hasLokalNkValue() {
        return lokalNkValue != 0;
    }

    public static int getLokalNkValue() {
        return lokalNkValue;
    }

    public static NumberFormat getLokalNkFormat() {
        return lokalNkFormat;
    }

    public static boolean hasAmtlNkValue() {
        return amtlNkValue != 0;
    }

    public static int getAmtlNkValue() {
        return amtlNkValue;
    }

    public static NumberFormat getAmtlNkFormat() {
        return amtlNkFormat;
    }

    public static boolean hasNkDelim() {
        return nkDelim != '\u0000';
    }

    public static char getNkDelim() {
        return nkDelim;
    }

    public static void setDefaultEbene(int n) {
        DEFAULT_EB = n;
    }

    public static void setDefaultPunktArt(int n) {
        DEFAULT_PA = n;
    }

    public static void setDefaultLinieArt(int n) {
        DEFAULT_LA = n;
    }

    public static void setDefaultTextArt(int n) {
        DEFAULT_TA = n;
    }

    public static int getDefaultEbene() {
        return DEFAULT_EB;
    }

    public static int getDefaultPunktArt() {
        return DEFAULT_PA;
    }

    public static int getDefaultLinieArt() {
        return DEFAULT_LA;
    }

    public static int getDefaultTextArt() {
        return DEFAULT_TA;
    }

    public static String getGrafArtFileName() {
        return grafArtFile;
    }

    public static String getGrafSymFileName() {
        return grafSymFile;
    }

    public static String getGrafPenFileName() {
        return grafPenFile;
    }

    public static String getGrafMacFileName() {
        return grafMacFile;
    }

    public static String getGrafColFileName() {
        return grafColFile;
    }

    public static String getRissArtFileName() {
        return rissArtFile;
    }

    public static String getRissSymFileName() {
        return rissSymFile;
    }

    public static void load(InputStream inputStream) throws IOException {
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = PropertyLoader.createReader(inputStream);
            P_GRAF.clear();
            L_GRAF.clear();
            T_GRAF.clear();
            while ((string = lineNumberReader.readLine()) != null) {
                int n = (string = string.trim()).indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n).trim();
                }
                if (string.length() == 0) continue;
                char c = string.charAt(0);
                switch (c) {
                    case '#': {
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        GeografProperties.readPunkt(string);
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        GeografProperties.readLinie(string);
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        GeografProperties.readVar(string);
                        break;
                    }
                    case 'A': {
                        GeografProperties.readAlkis(string);
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException("Fehler in Zeile: " + (lineNumberReader != null ? lineNumberReader.getLineNumber() : 0) + "\n" + iOException.getMessage());
        }
        if (alkisEntries.size() > 0) {
            hasAlkisDefs = true;
        }
    }

    public static boolean hasAlkisDefs() {
        return hasAlkisDefs;
    }

    public static ArtKey getGrafKey(PunktParameter punktParameter) {
        return GeografProperties.getKey(new ArtKey(punktParameter.getEb(), punktParameter.getModPa(), punktParameter.getModVa()), P_GRAF);
    }

    public static ArtKey getGrafKey(Linie linie) {
        return GeografProperties.getKey(new ArtKey(linie.getEb(), linie.getLa()), L_GRAF);
    }

    private static ArtKey getKey(ArtKey artKey, Hashtable hashtable) {
        ArtKey artKey2 = null;
        ArtKey artKey3 = new ArtKey(artKey.getEbene(), artKey.getArt(), artKey.getSymbol());
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setSymbol(ArtKey.IGNORE);
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setArt(ArtKey.IGNORE);
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setSymbol(artKey.getSymbol());
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setEbene(ArtKey.IGNORE);
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setArt(artKey.getArt());
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setSymbol(ArtKey.IGNORE);
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        artKey3.setArt(ArtKey.IGNORE);
        artKey2 = (ArtKey)hashtable.get(artKey3);
        if (artKey2 != null) {
            return artKey2;
        }
        return new ArtKey(DEFAULT_EB, DEFAULT_PA);
    }

    public static String getPunktNummer(Punkt punkt) {
        StringBuffer stringBuffer = new StringBuffer(15);
        if (punkt.nr <= 0L) {
            stringBuffer.append("#");
            stringBuffer.append(Math.abs(punkt.nr));
        } else if (punkt.isKatasterPunkt()) {
            stringBuffer.append(GeoNumberFormat.nr.format(punkt.buildKatNr(GeografProperties.getAmtNrModus())).toString());
            if (GeografProperties.hasAmtlNkValue()) {
                if (GeografProperties.hasNkDelim()) {
                    stringBuffer.append(GeografProperties.getNkDelim());
                }
                stringBuffer.append(GeografProperties.getNkValue(punkt));
            }
        } else {
            NummerZuschlag nummerZuschlag = GeografProperties.getLokalNrZuschlag();
            if (nummerZuschlag == null) {
                stringBuffer.append(GeoNumberFormat.nr.format(punkt.getNr()).toString());
            } else {
                stringBuffer.append(GeoNumberFormat.nr.format(nummerZuschlag.getNummer(punkt.getNr())).toString());
            }
            if (GeografProperties.hasLokalNkValue()) {
                if (GeografProperties.hasNkDelim()) {
                    stringBuffer.append(GeografProperties.getNkDelim());
                }
                stringBuffer.append(GeografProperties.getNkValue(punkt));
            }
        }
        return stringBuffer.toString();
    }

    public static String getNkValue(Punkt punkt) {
        int n = 0;
        NumberFormat numberFormat = null;
        if (punkt.isKatasterPunkt()) {
            n = amtlNkValue;
            numberFormat = amtlNkFormat;
        } else {
            n = lokalNkValue;
            numberFormat = lokalNkFormat;
        }
        PunktParameter punktParameter = punkt.getParameter(1);
        switch (n) {
            case 1: {
                return numberFormat.format(punktParameter.getModPa()).toString();
            }
            case 3: {
                return numberFormat.format(punktParameter.getModEb()).toString();
            }
            case 2: {
                return numberFormat.format(punktParameter.getModVa()).toString();
            }
            case 11: {
                return numberFormat.format(GeografProperties.getGrafKey(punktParameter).getArt()).toString();
            }
            case 12: {
                return numberFormat.format(GeografProperties.getGrafKey(punktParameter).getEbene()).toString();
            }
        }
        return null;
    }

    private static void readPunkt(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), "=#");
        if (stringTokenizer.countTokens() < 2) {
            throw new IOException("Geograf-Angaben fehlen");
        }
        try {
            ArtKey artKey = ArtKey.parseArtKey(stringTokenizer.nextToken());
            if (P_GRAF.get(artKey) != null) {
                throw new IOException("KafPlot-Art \"" + artKey.toString() + "\" ist doppelt vergeben");
            }
            ArtKey artKey2 = ArtKey.parseArtKey(stringTokenizer.nextToken());
            if (artKey2 != null) {
                P_GRAF.put(artKey, artKey2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private static void readLinie(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), "=#");
        if (stringTokenizer.countTokens() < 2) {
            throw new IOException("Geograf-Angaben fehlen");
        }
        try {
            ArtKey artKey = ArtKey.parseArtKey(stringTokenizer.nextToken());
            if (L_GRAF.get(artKey) != null) {
                throw new IOException("KafPlot-Art \"" + artKey.toString() + "\" ist doppelt vergeben");
            }
            ArtKey artKey2 = ArtKey.parseArtKey(stringTokenizer.nextToken());
            if (artKey2 != null) {
                L_GRAF.put(artKey, artKey2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    private static void readVar(String string) throws IOException {
        block22: {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), "=#");
            if (stringTokenizer.countTokens() < 2) {
                throw new IOException("Wert fehlt");
            }
            String string2 = null;
            String string3 = null;
            string2 = stringTokenizer.nextToken().trim();
            string3 = stringTokenizer.nextToken().trim();
            try {
                if (string2.equalsIgnoreCase("GrafArt")) {
                    grafArtFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("GrafSym")) {
                    grafSymFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("GrafPen")) {
                    grafPenFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("GrafMac")) {
                    grafMacFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("GrafCol")) {
                    grafColFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("RissArt")) {
                    rissArtFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("RissSym")) {
                    rissSymFile = string3;
                    break block22;
                }
                if (string2.equalsIgnoreCase("LokalNummer")) {
                    lokNrZuschlag = Integer.parseInt(string3) > 0 ? new NummerZuschlag() : null;
                    break block22;
                }
                if (string2.equalsIgnoreCase("AmtlNummer")) {
                    amtNrModus = PunktNummer.getLengthOfProperty(string3);
                    break block22;
                }
                if (string2.equalsIgnoreCase("Ebene")) {
                    GeografProperties.setEbeneExport(Integer.parseInt(string3) > 0);
                    break block22;
                }
                if (string2.equalsIgnoreCase("Art")) {
                    GeografProperties.setArtExport(Integer.parseInt(string3) > 0);
                    break block22;
                }
                if (string2.equalsIgnoreCase("DefaultEb")) {
                    GeografProperties.setDefaultEbene(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("DefaultPa")) {
                    GeografProperties.setDefaultPunktArt(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("DefaultLa")) {
                    GeografProperties.setDefaultLinieArt(Integer.parseInt(string3));
                    break block22;
                }
                if (string2.equalsIgnoreCase("NKDelim")) {
                    if (string3.length() != 3 || string3.charAt(0) != '\"' || string3.charAt(2) != '\"') {
                        throw new IOException("Der Wert der Variablen NKDelim entspricht nicht dem vorgesehenen Format");
                    }
                    nkDelim = string3.charAt(1);
                    break block22;
                }
                if (string2.equalsIgnoreCase("LokalNummerNK")) {
                    lokalNkValue = GeografProperties.parseNkValue(string3);
                    lokalNkFormat = GeografProperties.parseNkFormat(string3);
                    break block22;
                }
                if (string2.equalsIgnoreCase("AmtlNummerNK")) {
                    amtlNkValue = GeografProperties.parseNkValue(string3);
                    amtlNkFormat = GeografProperties.parseNkFormat(string3);
                    break block22;
                }
                throw new IOException("Unbekannte Variable: " + string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Ung\u00fcltiger Wert");
            }
            catch (IException iException) {
                throw new IOException(iException.getMessage());
            }
        }
    }

    private static int parseNkValue(String string) throws IOException {
        int n = 0;
        for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(0, n);
        if (string2.equalsIgnoreCase("PA")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("EB")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("VAT")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("GGPA")) {
            return 11;
        }
        if (string2.equalsIgnoreCase("GGEB")) {
            return 12;
        }
        throw new IOException("unbekannter Wert im Format: " + string2);
    }

    private static NumberFormat parseNkFormat(String string) throws IOException {
        DecimalFormat decimalFormat = null;
        int n = 0;
        for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(n);
        try {
            int n2 = Integer.parseInt(string2);
            decimalFormat = new DecimalFormat(string2.startsWith("0") ? GeoNumberFormat.getChars('0', n2) : "#");
            if (string2.startsWith("0")) {
                decimalFormat.setFormatWidth(n2);
            }
            decimalFormat.setMaximumIntegerDigits(n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("ung\u00fcltiger Wert im Format: " + string2);
        }
        return decimalFormat;
    }

    private static void readAlkis(String string) throws IOException {
        if (!(string = string.toUpperCase()).startsWith("ALKIS.")) {
            throw new IOException("unbekannte Kennung");
        }
        int n = (string = string.substring(6)).indexOf(61);
        if (n < 0) {
            throw new IOException("Zuweisung '=' fehlt");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.length() == 0) {
            throw new IOException("Schl\u00fcssel fehlt");
        }
        if (string3.length() == 0) {
            throw new IOException("Zuweisung fehlt");
        }
        if (!GeografProperties.isGgValid(string3)) {
            throw new IOException("ung\u00fcltige GeografArt: '" + string3 + "'");
        }
        alkisEntries.put(new AlkisEntry(string2), string3);
    }

    private static boolean isGgValid(String string) {
        if (string.startsWith("-")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+:", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n;
                String[] stringArray;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("+")) continue;
                if (string2.equals(":")) {
                    bl = true;
                    continue;
                }
                if (bl) {
                    stringArray = string2.split(",");
                    for (n = 0; n < stringArray.length; ++n) {
                        if (n == 0) {
                            Integer.parseInt(stringArray[n]);
                            continue;
                        }
                        Double.parseDouble(stringArray[n]);
                    }
                    if (stringArray.length > 3) {
                        return false;
                    }
                    bl = false;
                    continue;
                }
                stringArray = string2.split("\\.");
                for (n = 0; n < stringArray.length; ++n) {
                    Integer.parseInt(stringArray[n]);
                }
                if (stringArray.length <= 3) continue;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static String getArt(Punkt punkt) {
        String string = GeografProperties.getArt(new AlkisEntry(punkt));
        if (string != null) {
            int n = string.indexOf("+");
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((n = string.indexOf(":")) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public static String getArten(Punkt punkt) {
        return GeografProperties.getArt(new AlkisEntry(punkt));
    }

    public static String getArten(Linie linie) {
        return GeografProperties.getArt(new AlkisEntry(linie));
    }

    public static String getArten(GObject gObject, int n, int n2, int n3, int n4) {
        return GeografProperties.getArt(new AlkisEntry(gObject, n, n2, n3, n4));
    }

    public static String getArt(AlkisEntry alkisEntry) {
        String string = alkisEntries.get(alkisEntry);
        int n = 0;
        while ((string = alkisEntries.get(alkisEntry)) == null) {
            if (n == 0) {
                alkisEntry.lgc = 0;
            } else if (n == 1) {
                alkisEntry.typ = 0;
            } else if (n == 2) {
                alkisEntry.sta = 0;
            } else if (n == 3) {
                alkisEntry.art = 0;
            } else {
                return null;
            }
            ++n;
        }
        return string != null && string.charAt(0) == '-' ? null : string;
    }

    private static class AlkisEntry {
        protected int geo = 0;
        protected int art = 0;
        protected int sta = 0;
        protected int typ = 0;
        protected int lgc = 0;

        public AlkisEntry(String string) throws IOException {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                block33: {
                    String string2 = stringTokenizer.nextToken().trim();
                    try {
                        if (n == 0) {
                            if (string2.equals("P")) {
                                this.geo = 1;
                                break block33;
                            }
                            if (string2.equals("L")) {
                                this.geo = 2;
                                break block33;
                            }
                            if (string2.equals("T")) {
                                this.geo = 3;
                                break block33;
                            }
                            if (string2.equals("O")) {
                                this.geo = 4;
                                break block33;
                            }
                            if (string2.equals("A")) {
                                this.geo = 5;
                                break block33;
                            }
                            throw new Exception();
                        }
                        if (n == 1) {
                            if (this.geo == 1) {
                                this.art = PunktArt.parseString(string2);
                                break block33;
                            }
                            if (string2.equals("FLST")) {
                                this.art = 100;
                                break block33;
                            }
                            if (string2.equals("GEB")) {
                                this.art = 200;
                                break block33;
                            }
                            if (string2.equals("NUTZ")) {
                                this.art = 300;
                                break block33;
                            }
                            if (string2.equals("BODS")) {
                                this.art = 400;
                                break block33;
                            }
                            if (string2.equals("TOP")) {
                                this.art = 500;
                                break block33;
                            }
                            if (string2.equals("")) {
                                this.art = 0;
                                break block33;
                            }
                            throw new Exception();
                        }
                        if (string2.length() <= 0) break block33;
                        char c = string2.charAt(0);
                        if (Character.isDigit(c)) {
                            this.lgc = Integer.parseInt(string2);
                            break block33;
                        }
                        if (c == '+') {
                            this.sta = 1;
                            break block33;
                        }
                        if (c == '-') {
                            this.sta = 2;
                            break block33;
                        }
                        if (string2.equals("M")) {
                            this.typ = 11;
                            break block33;
                        }
                        if (string2.equals("O")) {
                            this.typ = 12;
                            break block33;
                        }
                        if (string2.equals("LAND")) {
                            this.typ = 26;
                            break block33;
                        }
                        if (string2.equals("BEZ")) {
                            this.typ = 25;
                            break block33;
                        }
                        if (string2.equals("KREIS")) {
                            this.typ = 24;
                            break block33;
                        }
                        if (string2.equals("GMD")) {
                            this.typ = 23;
                            break block33;
                        }
                        if (string2.equals("GMK")) {
                            this.typ = 22;
                            break block33;
                        }
                        if (string2.equals("FLUR")) {
                            this.typ = 21;
                            break block33;
                        }
                        if (string2.equals("NR")) {
                            this.typ = 31;
                            break block33;
                        }
                        if (string2.equals("NAME")) {
                            this.typ = 32;
                            break block33;
                        }
                        if (string2.equals("WHS")) {
                            this.typ = 41;
                            break block33;
                        }
                        if (string2.equals("WI")) {
                            this.typ = 42;
                            break block33;
                        }
                        if (string2.equals("OEF")) {
                            this.typ = 43;
                            break block33;
                        }
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        throw new IOException("ung\u00fcltiger Schl\u00fcsselinhalt '" + string2 + "'");
                    }
                }
                ++n;
            }
        }

        public AlkisEntry(Punkt punkt) {
            PunktParameter punktParameter = punkt.getParameter();
            this.geo = 1;
            this.art = punktParameter.getPa();
            this.sta = AlkisEntry.createSta(punktParameter);
            if (punktParameter.getKafVa() > 0) {
                this.typ = VermarkungsArt.isVermarkt(punktParameter.getKafVa()) ? 11 : 12;
            }
            this.lgc = AlkisEntry.createLgc(punktParameter);
        }

        public AlkisEntry(Linie linie) {
            LinieParameter linieParameter = linie.getParameter();
            this.geo = 2;
            int n = linieParameter.getLa();
            int n2 = linieParameter.getEb();
            int n3 = linieParameter.getSig2();
            if (n == 2) {
                this.art = 100;
                if (n3 != 0) {
                    if (n3 == 1105) {
                        this.typ = 26;
                    } else if (n3 == 1106) {
                        this.typ = 25;
                    } else if (n3 == 1107) {
                        this.typ = 23;
                    } else if (n3 == 1103) {
                        this.typ = 22;
                    } else if (n3 == 1102) {
                        this.typ = 21;
                    }
                }
                if (n2 == 48) {
                    this.sta = 1;
                }
            } else if (n == 3) {
                this.art = 200;
                if (n2 == 42) {
                    this.sta = 1;
                }
            } else if (n == 5) {
                this.art = n2 == 61 ? 400 : 300;
            } else if (n == 4) {
                this.art = 500;
            }
            int n4 = AlkisEntry.createLgc(linie.pa.getParameter());
            int n5 = linie.pe != null ? AlkisEntry.createLgc(linie.pe.getParameter()) : 0;
            int n6 = this.lgc = n4 > n5 ? n4 : n5;
            if (linie.isUntergang()) {
                this.sta = 2;
            }
        }

        public AlkisEntry(GObject gObject, int n, int n2, int n3, int n4) {
            this.geo = n;
            this.art = n2;
            this.typ = n3;
            this.sta = n4;
            Enumeration enumeration = gObject.getPunkte().elements();
            while (enumeration.hasMoreElements()) {
                PunktParameter punktParameter = ((Punkt)enumeration.nextElement()).getParameter();
                this.lgc = Math.max(this.lgc, AlkisEntry.createLgc(punktParameter));
            }
        }

        public int hashCode() {
            return this.geo * 10000000 + this.art * 10000 + this.sta * 1000 + this.typ * 10 + this.lgc;
        }

        public boolean equals(Object object) {
            if (object instanceof AlkisEntry) {
                AlkisEntry alkisEntry = (AlkisEntry)object;
                return this.geo == alkisEntry.geo && this.art == alkisEntry.art && this.sta == alkisEntry.sta && this.typ == alkisEntry.typ && this.lgc == alkisEntry.lgc;
            }
            return false;
        }

        public String toString() {
            return this.geo + "." + this.art + "." + this.sta + "." + this.typ + "." + this.lgc;
        }

        static int createLgc(PunktParameter punktParameter) {
            if (punktParameter.getLg() == 2100 || punktParameter.getLg() == 2200) {
                return 1;
            }
            if (punktParameter.getLg() == 2300) {
                return 2;
            }
            if (punktParameter.getLg() > 2300) {
                return 3;
            }
            if (punktParameter.getEq() == 4100) {
                return 4;
            }
            if (punktParameter.getEq() == 2000) {
                return 5;
            }
            if (punktParameter.getEq() == 4200 || punktParameter.getEq() == 4300) {
                return 6;
            }
            return 0;
        }

        static int createSta(PunktParameter punktParameter) {
            if (punktParameter.getPst() == 14) {
                return 1;
            }
            if (punktParameter.getPst() == 13) {
                return 2;
            }
            return 0;
        }
    }
}

