/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.GeografOutArt;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.VermarkungsArt;

public class GeografRissArt
extends GeografOutArt {
    public static final int UNDEF = 0;
    public static final int POLARAUFNAHME = 5060;
    public static final int POLARAUFNAHME_BEIDSEITIG = 5061;
    public static final int POLARAUFNAHME_DOPPELT = 5062;
    public static final int GPSAUFNAHME = 5065;
    public static final int LOKAL_PNR_TEXT = 5000;
    private static final int GP_UNV = 20;
    private static final int GP_STEIN = 21;
    private static final int GP_RUND = 22;
    private static final int GP_GH = 24;
    private static final int GP_KR = 25;
    private static final int GP_NB = 26;
    private static final int GP_LB = 27;
    private static final int HE = 0;
    private static final int TP = 1;
    private static final int AP = 3;
    private static final int TIEFER = 10;
    private static final int IN_FLUCHT = 20;
    private static final int NICHT_DARST = 50;
    private static final int GP_UNV_R = 10;
    private static final int GP_STEIN_R = 15;
    private static final int GP_RUND_R = 12;
    private static final int GP_GH_R = 15;
    private static final int GP_LB_R = 15;
    private static final int GP_NB_R = 15;
    private static final int GP_KR_R = 12;
    private static final int HE_R = 10;
    private static final int TP_R = 16;
    private static final int AP_R = 15;
    private int art;
    private int radius;

    public GeografRissArt(Punkt punkt) {
        this.setArt(punkt);
    }

    public int getArt() {
        return this.art;
    }

    public void setArt(int n) {
        this.art = n;
    }

    public double getRadius() {
        return (double)this.radius / 10.0;
    }

    public double getRadius(double d) {
        return (double)this.radius / 10000.0 * d;
    }

    public void setArt(Punkt punkt) {
        int n;
        PunktParameter punktParameter = punkt.getParameter(1);
        switch (punktParameter.getKafPa()) {
            case 8: {
                n = 1;
                this.radius = 16;
                break;
            }
            case 7: {
                n = 3;
                this.radius = 15;
                break;
            }
            case 1: {
                if (punkt.isOn()) {
                    Symbol symbol = VermarkungsArt.getVermarkungsArt(punktParameter.getVa()).getSymbol();
                    if (symbol == Symbol.ST || symbol == Symbol.ST_) {
                        n = 21;
                        this.radius = 15;
                    } else if (symbol == Symbol.R || symbol == Symbol.R_) {
                        n = 22;
                        this.radius = 12;
                    } else if (symbol == Symbol.KR) {
                        n = 25;
                        this.radius = 12;
                    } else if (symbol == Symbol.GH) {
                        n = 24;
                        this.radius = 15;
                    } else if (symbol == Symbol.LB) {
                        n = 27;
                        this.radius = 15;
                    } else if (symbol == Symbol.NB) {
                        n = 26;
                        this.radius = 15;
                    } else {
                        n = 20;
                        this.radius = 10;
                    }
                    if (punktParameter.getKafVvt() < 0 && punktParameter.getKafVva() <= 0 || symbol == Symbol.R_ || symbol == Symbol.ST_) {
                        n = this.setArtTiefer(n);
                    }
                    if (!punkt.isInLinie()) break;
                    n = this.setArtInFlucht(n);
                    break;
                }
                n = 50;
                break;
            }
            case 2: {
                n = 0;
                this.radius = 10;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.art = punktParameter.getEb() == 1 && punktParameter.getKafVva() > 0 ? 4800 + n : punktParameter.getEb() * 100 + n;
    }

    private int setArtTiefer(int n) {
        return n + 10;
    }

    private int setArtInFlucht(int n) {
        return n + 20;
    }
}

