/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.SurveyException;
import de.geocalc.text.GeoNumberFormat;

public class GeradenSchnitt {
    private Linie l1 = null;
    private Linie l2 = null;
    private double a1;
    private double a2;
    private Punkt p1;
    private Punkt p2;
    private Punkt p3;
    private Punkt p4;
    private double a;
    private double maxDist;
    private boolean param = false;

    public GeradenSchnitt() {
        this(null, null, 0.0, 0.0);
    }

    public GeradenSchnitt(Linie linie, Linie linie2) {
        this(linie, linie2, 0.0, 0.0);
    }

    public GeradenSchnitt(Linie linie, Linie linie2, double d, double d2) {
        this.l1 = linie;
        this.l2 = linie2;
        this.a1 = d;
        this.a2 = d2;
    }

    public void setL1(Linie linie) {
        this.l1 = linie;
    }

    public Linie getL1() {
        return this.l1;
    }

    public void setL2(Linie linie) {
        this.l2 = linie;
    }

    public Linie getL2() {
        return this.l2;
    }

    public void setA1(double d) {
        this.a1 = d;
    }

    public double getA1() {
        return this.a1;
    }

    public void setA2(double d) {
        this.a2 = d;
    }

    public double getA2() {
        return this.a2;
    }

    public void setMaxEinrechenDistance(double d) {
        this.maxDist = d;
    }

    public double getMaxEinrechenDistance() {
        return this.maxDist;
    }

    public Punkt getSchnittPunkt() {
        if (!this.param) {
            this.setParameter();
        }
        return new Punkt(this.p1.y + this.a * (this.p2.y - this.p1.y), this.p1.x + this.a * (this.p2.x - this.p1.x));
    }

    public void setPunktInSchnitt(Punkt punkt) throws SurveyException {
        Punkt punkt2 = this.getSchnittPunkt();
        double d = Math.sqrt((punkt.x - punkt2.x) * (punkt.x - punkt2.x) + (punkt.y - punkt2.y) * (punkt.y - punkt2.y));
        punkt.dy = (float)(punkt2.y - (punkt.y - (double)punkt.dy));
        punkt.dx = (float)(punkt2.x - (punkt.x - (double)punkt.dx));
        punkt.dl = (float)Math.abs(d);
        punkt.y = punkt2.y;
        punkt.x = punkt2.x;
        if (d > this.maxDist) {
            throw new SurveyException("Fehler in Einrechenschnitt von Punkt " + this.l1.pa.nr + " nach Punkt " + this.l1.pe.nr + " und von Punkt " + this.l2.pa.nr + " nach Punkt " + this.l2.pe.nr + "\n          Einrechenpunkt " + punkt.nr + " wurde mit einer Abweichung von " + GeoNumberFormat.koo03.format(d).toString() + " eingerechnet");
        }
    }

    private void setParameter() {
        double d = this.l1.getRichtung();
        double d2 = this.l2.getRichtung();
        this.p1 = new Punkt(this.l1.pa.y + this.a1 * Math.cos(d), this.l1.pa.x - this.a1 * Math.sin(d));
        this.p2 = new Punkt(this.l1.pe.y + this.a1 * Math.cos(d), this.l1.pe.x - this.a1 * Math.sin(d));
        this.p3 = new Punkt(this.l2.pa.y + this.a2 * Math.cos(d2), this.l2.pa.x - this.a2 * Math.sin(d2));
        this.p4 = new Punkt(this.l2.pe.y + this.a2 * Math.cos(d2), this.l2.pe.x - this.a2 * Math.sin(d2));
        this.a = ((this.p4.x - this.p1.x) * (this.p4.y - this.p3.y) - (this.p4.x - this.p3.x) * (this.p4.y - this.p1.y)) / ((this.p2.x - this.p1.x) * (this.p4.y - this.p3.y) - (this.p4.x - this.p3.x) * (this.p2.y - this.p1.y));
        this.param = true;
    }
}

