/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.FlowText;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class GetServicePortDialog
extends IDialog
implements ActionListener,
TextListener {
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private static final String COPY_COMMAND = "Adresse Kopieren";
    private static final int DEFAULT_PORT = 8000;
    private ITextField portField;
    private Label addressLabel;
    private int port = -1;
    private String host = null;
    IFrame parent;

    public GetServicePortDialog(IFrame iFrame, String string, String string2) {
        super(iFrame, string, true);
        this.parent = iFrame;
        this.host = string2;
        this.setLayout(new BorderLayout());
        this.add("North", this.createPortPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    public int getPort() {
        return this.port;
    }

    private IPanel createPortPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        FlowText flowText = new FlowText("Es wird ein " + this.getTitle() + " mit der folgenden Portadresse aufgebaut.", false);
        iPanel.add(flowText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText, gridBagConstraints);
        Label label = new Label("Port:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.portField = new ITextField(4);
        iPanel.add(this.portField);
        this.portField.setText(Integer.toString(8000));
        this.portField.addTextListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.portField, gridBagConstraints);
        FlowText flowText2 = new FlowText("Der " + this.getTitle() + " ist abrufbar unter der Adresse: ", false);
        iPanel.add(flowText2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(flowText2, gridBagConstraints);
        this.addressLabel = new Label(this.createAddress(8000));
        iPanel.add(this.addressLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.addressLabel, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button(COPY_COMMAND);
        button2.addActionListener(this);
        panel.add(button2);
        Button button3 = new Button(ABORT_COMMAND);
        button3.addActionListener(this);
        panel.add(button3);
        return panel;
    }

    private String createAddress(int n) {
        return this.host + ":" + Integer.toString(n);
    }

    private int parsePort() throws Exception {
        int n = Integer.parseInt(this.portField.getText());
        if (n < 1 || n > 9999) {
            throw new Exception("Ung\u00fcltiger Port " + n);
        }
        return n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            try {
                this.port = this.parsePort();
                this.endDialog();
            }
            catch (Exception exception) {
                this.portField.setForeground(Color.red);
                this.portField.setText(Integer.toString(8000));
            }
        } else if (string.equals(ABORT_COMMAND)) {
            this.port = -1;
            this.endDialog();
        } else if (string.equals(COPY_COMMAND)) {
            try {
                this.getToolkit().getSystemClipboard().setContents(new StringSelection(this.createAddress(this.parsePort())), (ClipboardOwner)((Object)this.parent));
            }
            catch (Exception exception) {
                this.getToolkit().getSystemClipboard().setContents(new StringSelection(exception.getMessage()), (ClipboardOwner)((Object)this.parent));
            }
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        try {
            this.port = this.parsePort();
            this.portField.setForeground(Color.black);
            this.addressLabel.setText(this.createAddress(this.port));
        }
        catch (Exception exception) {
            this.portField.setForeground(Color.red);
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

