/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.DrawField;
import de.geocalc.awt.DrawFieldSearchResult;
import de.geocalc.awt.IColor;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IInscription;
import de.geocalc.awt.IInscriptionComponent;
import de.geocalc.awt.ILocation;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.awt.event.IMessageListener;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.Bemerkung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Ebene;
import de.geocalc.kafplot.ErrorObject;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.Hoehe;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.KafPlotVersion;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktAnschlussgComparator;
import de.geocalc.kafplot.PunktAnschlusszComparator;
import de.geocalc.kafplot.PunktEllipseComparator;
import de.geocalc.kafplot.PunktHoeheDiffComparator;
import de.geocalc.kafplot.PunktIdentitaet;
import de.geocalc.kafplot.PunktParameter;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.PunktVectorComparator;
import de.geocalc.kafplot.PunktZuverlComparator;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.Symbol;
import de.geocalc.kafplot.Text;
import de.geocalc.kafplot.TextArt;
import de.geocalc.kafplot.TextSymbol;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.TrafoPunktRComparator;
import de.geocalc.kafplot.TrafoPunktVComparator;
import de.geocalc.kafplot.TrafoSystem;
import de.geocalc.kafplot.ValueDataContainer;
import de.geocalc.kafplot.VermarkungsArt;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.GeoNumberFormat;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparator;
import de.geocalc.util.IntegerHashList;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.SortableVector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GraphicClip
extends Component {
    private static final long NANO = 1000000L;
    private static final long MIKRO = 1000L;
    private static final int TARGET_THREAD_TIME = 150000;
    private static final String GRAPHIC_EXCEPTION_MESSAGE = "Fehler in der Datenzuordnung, pr\u00fcfen Sie die Eingabedatei!";
    private static DecimalFormat phFormat;
    private static DecimalFormat pnrFormat;
    private static Font pnrFont;
    private static Font phFont;
    private static Font vaFont;
    private static Font peFont;
    private DataBase db = null;
    private IGraphics iGraphics = null;
    private Vector BESCHRIFTUNG = new Vector();
    private static int MIN_TEXTBEZUG_DISTANCE;
    private static int MIN_TEXTDIST;
    private static int MAX_TEXTDIST;
    private double me = 0.5;
    private boolean debug = true;
    private IMessageListener messageListener;
    private Rectangle drawRect = null;
    private TimeList timeList = new TimeList(this);
    private TimeRegister timeRegister = new TimeRegister(this);
    private static final Color TEXT_OVERWRITE;
    private static final Text mass;
    private static final TextArt ta;
    private static final TextSymbol sym;
    private static final int DRAW_END = 0;
    private static final int DRAW_BG_FLST = 1110;
    private static final int DRAW_BG_GEB = 1210;
    private static final int DRAW_BG_GEB_SD = 1211;
    private static final int DRAW_BG_NUTZ = 1310;
    private static final int DRAW_BG_BODEN = 1410;
    private static final int DRAW_BG_TOP = 1510;
    private static final int DRAW_FG_FLST = 1120;
    private static final int DRAW_FG_GEB = 1220;
    private static final int DRAW_FG_NUTZ = 1320;
    private static final int DRAW_FG_BODEN = 1420;
    private static final int DRAW_FG_TOP = 1520;
    private static final int DRAW_TX_FLST = 1130;
    private static final int DRAW_TX_GEB = 1230;
    private static final int DRAW_TX_NUTZ = 1330;
    private static final int DRAW_TX_BODEN = 1430;
    private static final int DRAW_TX_TOP = 1530;
    private static final int DRAW_TL_FLST = 1140;
    private static final int DRAW_TL_GEB = 1240;
    private static final int DRAW_TL_TOP = 1540;
    private static final int DRAW_BG_RISS_POLAR = 2111;
    private static final int DRAW_BG_RISS_GPS = 2121;
    private static final int DRAW_BG_RISS_EIGENE = 2211;
    private static final int DRAW_BG_RISS_NACHWEIS = 2221;
    private static final int DRAW_BG_RISS_EINRECH = 2231;
    private static final int DRAW_BG_RISS_VORGABE = 2241;
    private static final int DRAW_BG_RISS_ZENIT = 2311;
    private static final int DRAW_BG_RISS_NIV = 2321;
    private static final int DRAW_BG_RISS_HOMOGEN = 2411;
    private static final int DRAW_BG_RISS_BEDING = 2421;
    private static final int DRAW_BG_RISS_TRAFO = 2511;
    private static final int DRAW_FG_RISS_POLAR = 2112;
    private static final int DRAW_FG_RISS_GPS = 2122;
    private static final int DRAW_FG_RISS_EIGENE = 2212;
    private static final int DRAW_FG_RISS_NACHWEIS = 2222;
    private static final int DRAW_FG_RISS_EINRECH = 2232;
    private static final int DRAW_FG_RISS_VORGABE = 2242;
    private static final int DRAW_FG_RISS_ZENIT = 2312;
    private static final int DRAW_FG_RISS_NIV = 2322;
    private static final int DRAW_FG_RISS_HOMOGEN = 2412;
    private static final int DRAW_FG_RISS_BEDING = 2422;
    private static final int DRAW_FG_RISS_TRAFO = 2512;
    private static final int DRAW_TX_RISS_POLAR = 2113;
    private static final int DRAW_TX_RISS_GPS = 2123;
    private static final int DRAW_TX_RISS_EIGENE = 2213;
    private static final int DRAW_TX_RISS_NACHWEIS = 2223;
    private static final int DRAW_TX_RISS_EINRECH = 2233;
    private static final int DRAW_TX_RISS_VORGABE = 2243;
    private static final int DRAW_TX_RISS_ZENIT = 2313;
    private static final int DRAW_TX_RISS_NIV = 2323;
    private static final int DRAW_TX_RISS_HOMOGEN = 2413;
    private static final int DRAW_TX_RISS_BEDING = 2423;
    private static final int DRAW_TX_RISS_TRAFO = 2513;
    private static final int DRAW_FG_MESS_POLAR = 3112;
    private static final int DRAW_FG_MESS_GPS = 3122;
    private static final int DRAW_FG_MESS_EIGENE = 3212;
    private static final int DRAW_FG_MESS_NACHWEIS = 3222;
    private static final int DRAW_FG_MESS_EINRECH = 3232;
    private static final int DRAW_FG_MESS_VORGABE = 3242;
    private static final int DRAW_FG_MESS_ZENIT = 3312;
    private static final int DRAW_FG_MESS_NIV = 3322;
    private static final int DRAW_FG_MESS_HOMOGEN = 3412;
    private static final int DRAW_FG_MESS_BEDING = 3422;
    private static final int DRAW_FG_MESS_MOVE = 3432;
    private static final int DRAW_FG_MESS_IDENT = 3442;
    private static final int DRAW_FG_MESS_TRAFO = 3512;
    private static final int DRAW_TX_MESS_EIGENE = 3213;
    private static final int DRAW_TX_MESS_NACHWEIS = 3223;
    private static final int DRAW_TX_MESS_EINRECH = 3233;
    private static final int DRAW_TX_MESS_VORGABE = 3243;
    private static final int DRAW_TX_MESS_HOMOGEN = 3413;
    private static final int DRAW_TX_MESS_BEDING = 3423;
    private static final int DRAW_TN_MESS_EIGENE = 3214;
    private static final int DRAW_TN_MESS_NACHWEIS = 3224;
    private static final int DRAW_TN_MESS_EINRECH = 3234;
    private static final int DRAW_TN_MESS_VORGABE = 3244;
    private static final int DRAW_FG_PUNKT = 5110;
    private static final int DRAW_FG_PUNKT_ERR = 5112;
    private static final int DRAW_TX_PUNKT = 5120;
    private static final int DRAW_TX_PUNKT_VAT = 5121;
    private static final int DRAW_TX_PUNKT_ERR = 5122;
    private static final int DRAW_BG_IMAGE = 8010;
    private static final int DRAW_FG_IMAGE = 8020;
    private static final int DRAW_TX_IMAGE = 8030;
    private static final int DRAW_PP_IMAGE = 8040;
    private static final int DRAW_GITTER = 8110;
    private static final int DRAW_IDENT = 8120;
    private static final int DRAW_MENGE = 8130;
    private static final int DRAW_TEXTFIELD = 8140;
    private static final int DRAW_PLOTBOX = 8150;
    private static final int DRAW_VERSION_MSG = 8160;
    private static final int HINT = 9900;
    private static final int HINT_NONE_NONE = 9901;
    private static final int HINT_LINE_NONE = 9902;
    private static final int HINT_NONE_TEXT = 9903;
    private static final int HINT_LINE_TEXT = 9904;
    private static final int TIME_BG_IMAGE = 500;
    private static final int TIME_FG_IMAGE = 5;
    private static final int TIME_TX_IMAGE = 10;
    private static final int TIME_PP_IMAGE = 5;
    private static final int TIME_BG_FLST = 6;
    private static final int TIME_BG_GEB = 3;
    private static final int TIME_BG_NUTZ = 10;
    private static final int TIME_BG_BODEN = 20;
    private static final int TIME_BG_TOP = 2;
    private static final int TIME_FG_FLST = 13;
    private static final int TIME_FG_GEB = 6;
    private static final int TIME_FG_NUTZ = 25;
    private static final int TIME_FG_BODEN = 30;
    private static final int TIME_FG_TOP = 7;
    private static final int TIME_TX_FLST_NR = 11;
    private static final int TIME_TX_FLST_GB = 11;
    private static final int TIME_TX_FLST_EN = 28;
    private static final int TIME_TX_FLST_ED = 37;
    private static final int TIME_TX_FLST_LS = 11;
    private static final int TIME_TX_FLST_LB = 15;
    private static final int TIME_TX_FLST_FF = 12;
    private static final int TIME_TX_GEB_NR = 15;
    private static final int TIME_TX_GEB_NRL = 40;
    private static final int TIME_TX_GEB_GZ = 0;
    private static final int TIME_TX_GEB_GN = 0;
    private static final int TIME_TX_GEB_GS = 0;
    private static final int TIME_TX_GEB_GA = 0;
    private static final int TIME_TX_NUTZ_NR = 0;
    private static final int TIME_TX_NUTZ_NT = 0;
    private static final int TIME_TX_NUTZ_NS = 0;
    private static final int TIME_TX_BODEN = 22;
    private static final int TIME_TX_TOP = 11;
    private static final int TIME_TL_FLST = 600;
    private static final int TIME_TL_GEB = 600;
    private static final int TIME_TL_TOP = 300;
    private static final int TIME_BG_RISS = 300;
    private static final int TIME_FG_RISS = 300;
    private static final int TIME_TX_RISS = 50;
    private static final int TIME_TN_RISS = 150;
    private static final int TIME_FG_MESS_AUFNAHME = 70;
    private static final int TIME_FG_MESS_ORTHO = 20;
    private static final int TIME_FG_MESS_BEDING = 8;
    private static final int TIME_FG_MESS_HOEHE = 25;
    private static final int TIME_FG_MESS_TRAFO = 3;
    private static final int TIME_TX_MESS_ORTHO = 110;
    private static final int TIME_FG_PUNKT = 6;
    private static final int TIME_FG_PUNKT_ERR = 6;
    private static final int TIME_TX_PUNKT_NR = 2;
    private static final int TIME_TX_PUNKT_PH = 1;
    private static final int TIME_TX_PUNKT_VAT = 2;
    private static final int TIME_GITTER = 40;
    private static final int TIME_IDENT = 5;
    private static final int TIME_TEXTFIELD = 5;
    private static final int TIME_PLOTBOX = 20;
    private static final int TIME_VERSION_MSG = 5;
    private static final int TIME_HINT = 1;
    private static final int TIME_THREAD = 8000;
    private static final float TIME_FACTOR_LINE_SIMPLE = 0.3f;
    private static final float TIME_FACTOR_LINE_NORMAL = 1.0f;
    private static final float TIME_FACTOR_LINE_PATTERN = 2.0f;
    private static final float TIME_FACTOR_LENGTH_NACHW = 0.4f;
    private static final float TIME_FACTOR_MESS_BEDING_TEXT = 1.3f;

    public GraphicClip(DataBase dataBase, IGraphics iGraphics, Rectangle rectangle) {
        this.db = dataBase;
        this.iGraphics = iGraphics;
        this.drawRect = rectangle;
    }

    public void setDataBase(DataBase dataBase) {
        this.db = dataBase;
    }

    public void setDrawRect(Rectangle rectangle) {
        this.drawRect = rectangle;
    }

    public void setGraphics(IGraphics iGraphics) {
        this.iGraphics = iGraphics;
    }

    public Vector getBeschriftungen() {
        return this.BESCHRIFTUNG;
    }

    public void setEllipseMasstab(double d) {
        this.me = d;
    }

    public void addMessageListener(IMessageListener iMessageListener) {
        this.messageListener = iMessageListener;
    }

    public void removeMessageListener(IMessageListener iMessageListener) {
        this.messageListener = null;
    }

    private void setHints(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)iGraphics.getGraphics();
        if (!KafPlotProperties.isAntialiasEnabled) {
            bl = false;
            bl2 = false;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, bl ? RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY : RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, bl ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, bl ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, bl2 ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        long l = System.nanoTime();
        TextArt.setMedium(0);
        pnrFormat = KafPlotProperties.getPnrFormat();
        phFormat = KafPlotProperties.getPhFormat();
        pnrFont = KafPlotProperties.getPnrFont();
        phFont = KafPlotProperties.getPhFont();
        peFont = KafPlotProperties.getPeFont();
        vaFont = KafPlotProperties.getVaFont();
        this.BESCHRIFTUNG.removeAllElements();
        this.iGraphics.setMinDiplaySize(KafPlotProperties.getMinDisplaySize());
        DrawOrder[] drawOrderArray = new DrawOrder[80];
        this.fillDrawList(drawOrderArray);
        BufferedImage bufferedImage = this.drawBufferThreads(drawOrderArray);
        graphics.drawImage(bufferedImage, 0, 0, SystemColor.window, this);
        this.drawPlotbox(this.iGraphics);
    }

    private BufferedImage drawBufferThreads(DrawOrder[] drawOrderArray) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        long l = System.nanoTime();
        int n5 = 0;
        int n6 = 1;
        for (n4 = 0; n4 < drawOrderArray.length; ++n4) {
            if (drawOrderArray[n4] == null) continue;
            n6 = Math.max(n6, drawOrderArray[n4].time);
            n5 += drawOrderArray[n4].time;
        }
        n4 = KafPlotProperties.getMaxThreadCount();
        int n7 = 150000;
        if (n5 > 150000) {
            n7 = Math.max(n6, n5 / n4 + n4);
        }
        if (n7 > 150000) {
            object = (Graphics2D)this.iGraphics.getGraphics();
            n3 = this.getWidth() / 4;
            n2 = this.getHeight() / 4;
            ((Graphics)object).drawLine(n3, n2, this.getWidth() - n3, this.getHeight() - n2);
            ((Graphics)object).drawLine(n3, this.getHeight() - n2, this.getWidth() - n3, n2);
        }
        object = new Draw[n4];
        n3 = 0;
        n2 = 0;
        int n8 = 0;
        int n9 = 0;
        while (drawOrderArray[n2] != null) {
            if ((n8 += drawOrderArray[n2].time) > n7 && n9 < n4 - 2) {
                object[n9++] = new Draw(n9, drawOrderArray, n3, n2);
                n8 = drawOrderArray[n2].time;
                n3 = n2;
            }
            ++n2;
        }
        if (n3 != n2) {
            object[n9++] = new Draw(n9, drawOrderArray, n3, n2);
        }
        for (n = 0; n < n9; ++n) {
            try {
                if (object[n] == null) continue;
                ((Thread)object[n]).join();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (n = n9 - 1; n > 0; --n) {
            if (object[n] == null) continue;
            Object object2 = object[n];
            Object object3 = object[n - 1];
            ((Draw)object2).closeGraphics();
            ((Draw)object3).drawImage((Draw)object2);
            ((Draw)object2).flush();
        }
        this.timeRegister.register(n6, (int)((System.nanoTime() - l) / 1000L));
        return ((Draw)object[0]).buffer;
    }

    private final void fillDrawList(DrawOrder[] drawOrderArray) {
        long l = 0L;
        if (this.debug) {
            l = System.nanoTime();
        }
        double d = this.iGraphics.getScale();
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!this.iGraphics.contains(punkt)) continue;
            ++n;
            if (!punkt.isVisible()) continue;
            ++n2;
        }
        int n3 = 0;
        drawOrderArray[n3++] = new DrawOrder(this, 9904, 1);
        if (KafPlotProperties.isImagesVisible() && KafPlotProperties.isImgFillVisible) {
            int n4 = n3++;
            drawOrderArray[n4] = new DrawOrder(this, 8010, DataBase.IMG.size() * 500);
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9901, 1);
        if (KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaecheFillVisible) {
            if (KafPlotProperties.getColorSwitch() == 1012 || KafPlotProperties.getColorSwitch() == 1013 || KafPlotProperties.getColorSwitch() == 1014) {
                if (KafPlotProperties.isBodsVisible && KafPlotProperties.isBodsFillVisible) {
                    int n5 = n3++;
                    drawOrderArray[n5] = new DrawOrder(this, 1410, DataBase.BODEN.size() * 20);
                }
            } else if (KafPlotProperties.getColorSwitch() == 1002) {
                if (KafPlotProperties.isNutzVisible && KafPlotProperties.isNutzFillVisible) {
                    if (DataBase.model.getModel() == 2) {
                        int n6 = n3++;
                        drawOrderArray[n6] = new DrawOrder(this, 1310, DataBase.NUTZ.size() * 20);
                    } else {
                        int n7 = n3++;
                        drawOrderArray[n7] = new DrawOrder(this, 1110, DataBase.FLST.size() * 6);
                    }
                }
            } else if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstFillVisible) {
                int n8 = n3++;
                drawOrderArray[n8] = new DrawOrder(this, 1110, DataBase.FLST.size() * 6);
            }
            if (KafPlotProperties.isFlaechePatternVisible && (KafPlotProperties.getColorSwitch() == 1002 || KafPlotProperties.getColorSwitch() == 1003 || KafPlotProperties.getColorSwitch() == 1005 || KafPlotProperties.getColorSwitch() == 1010) && KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebFillVisible) {
                int n9 = n3++;
                drawOrderArray[n9] = new DrawOrder(this, 1211, DataBase.GEB.size() * 3);
            }
            if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebFillVisible) {
                int n10 = n3++;
                drawOrderArray[n10] = new DrawOrder(this, 1210, DataBase.GEB.size() * 3);
            }
            if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopFillVisible) {
                int n11 = n3++;
                drawOrderArray[n11] = new DrawOrder(this, 1510, DataBase.TOP.size() * 2);
            }
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9904, 1);
        if (KafPlotProperties.getColorSwitch() == 1009) {
            if (KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaechePolyVisible) {
                float f = 1.0f;
                if (KafPlotProperties.isQuickPaintEnabled) {
                    f = 0.3f;
                } else if (KafPlotProperties.isFlaechePatternVisible) {
                    f = 2.0f;
                }
                if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopPolyVisible) {
                    int n12 = n3++;
                    drawOrderArray[n12] = new DrawOrder(this, 1520, (int)((float)(DataBase.TOP.size() * 7) * f));
                }
                if (KafPlotProperties.isNutzVisible && KafPlotProperties.isNutzPolyVisible) {
                    int n13 = n3++;
                    drawOrderArray[n13] = new DrawOrder(this, 1320, (int)((float)(DataBase.NUTZ.size() * 25) * f));
                }
                if (KafPlotProperties.isBodsVisible && KafPlotProperties.isBodsPolyVisible) {
                    int n14 = n3++;
                    drawOrderArray[n14] = new DrawOrder(this, 1420, (int)((float)(DataBase.BODEN.size() * 30) * f));
                }
                if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
                    int n15 = n3++;
                    drawOrderArray[n15] = new DrawOrder(this, 1220, (int)((float)(DataBase.GEB.size() * 6) * f));
                }
                if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
                    int n16 = n3++;
                    drawOrderArray[n16] = new DrawOrder(this, 1120, (int)((float)(DataBase.FLST.size() * 13) * f));
                }
            }
            if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaecheTextVisible(d)) {
                if (KafPlotProperties.isFlstVisible) {
                    int n17 = 0;
                    if (KafPlotProperties.isFlstTextOldVisible) {
                        n17 += 11;
                    }
                    if (KafPlotProperties.isGbblVisible) {
                        n17 += 11;
                    }
                    if (KafPlotProperties.isEtNameVisible) {
                        n17 += 28;
                    }
                    if (KafPlotProperties.isEtAllVisible) {
                        n17 += 37;
                    }
                    if (KafPlotProperties.isLageKeyVisible) {
                        n17 += 11;
                    }
                    if (KafPlotProperties.isLageTextVisible) {
                        n17 += 15;
                    }
                    if (KafPlotProperties.isAreaBuchVisible || KafPlotProperties.isAreaKooVisible || KafPlotProperties.isAreaDiffVisible || KafPlotProperties.isAreaPercVisible) {
                        n17 += 12;
                    }
                    int n18 = n3++;
                    drawOrderArray[n18] = new DrawOrder(this, 1130, DataBase.FLST.size() * n17);
                }
                if (KafPlotProperties.isGebaeudeVisible) {
                    int n19 = 0;
                    if (KafPlotProperties.isGebNumberVisible) {
                        n19 += 15;
                    }
                    if (KafPlotProperties.isGebLfdnrVisible) {
                        n19 += 40;
                    }
                    if (KafPlotProperties.isGebGschzVisible) {
                        n19 += 0;
                    }
                    if (KafPlotProperties.isGebNameVisible) {
                        n19 += 0;
                    }
                    if (KafPlotProperties.isGebSymVisible) {
                        n19 += 0;
                    }
                    if (KafPlotProperties.isGebAttVisible) {
                        n19 += 0;
                    }
                    int n20 = n3++;
                    drawOrderArray[n20] = new DrawOrder(this, 1230, DataBase.GEB.size() * n19);
                }
                if (KafPlotProperties.isNutzVisible) {
                    int n21 = 0;
                    if (KafPlotProperties.isNutzNumberVisible) {
                        n21 += 0;
                    }
                    if (KafPlotProperties.isNutzTextVisible) {
                        n21 += 0;
                    }
                    if (KafPlotProperties.isNutzSymVisible) {
                        n21 += 0;
                    }
                    int n22 = n3++;
                    drawOrderArray[n22] = new DrawOrder(this, 1330, DataBase.NUTZ.size() * n21);
                }
                if (KafPlotProperties.isBodsVisible) {
                    int n23 = n3++;
                    drawOrderArray[n23] = new DrawOrder(this, 1430, DataBase.BODEN.size() * 22);
                }
                if (KafPlotProperties.isTopographieVisible) {
                    int n24 = n3++;
                    drawOrderArray[n24] = new DrawOrder(this, 1530, DataBase.TOP.size() * 11);
                }
            }
        }
        if (KafPlotProperties.isRissFillVisible) {
            if (KafPlotProperties.isTrafoVisible()) {
                int n25 = n3++;
                drawOrderArray[n25] = new DrawOrder(this, 2511, DataBase.T.size() * 300);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                int n26 = n3++;
                drawOrderArray[n26] = new DrawOrder(this, 2421, DataBase.BB.size() * 300);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                int n27 = n3++;
                drawOrderArray[n27] = new DrawOrder(this, 2411, DataBase.BH.size() * 300);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                int n28 = n3++;
                drawOrderArray[n28] = new DrawOrder(this, 2321, DataBase.HN.size() * 300);
            }
            if (KafPlotProperties.isZenitVisible) {
                int n29 = n3++;
                drawOrderArray[n29] = new DrawOrder(this, 2311, DataBase.HP.size() * 300);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n30 = n3++;
                drawOrderArray[n30] = new DrawOrder(this, 2241, DataBase.MV.size() * 300);
            }
            if (KafPlotProperties.isGpsVisible) {
                int n31 = n3++;
                drawOrderArray[n31] = new DrawOrder(this, 2121, DataBase.MG.size() * 300);
            }
            if (KafPlotProperties.isPolarVisible) {
                int n32 = n3++;
                drawOrderArray[n32] = new DrawOrder(this, 2111, DataBase.MP.size() * 300);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                int n33 = n3++;
                drawOrderArray[n33] = new DrawOrder(this, 2211, DataBase.MM.size() * 300);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n34 = n3++;
                drawOrderArray[n34] = new DrawOrder(this, 2231, DataBase.ME.size() * 300);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n35 = n3++;
                drawOrderArray[n35] = new DrawOrder(this, 2221, DataBase.MK.size() * 300);
            }
        }
        if (KafPlotProperties.isRissPolyVisible) {
            if (KafPlotProperties.isTrafoVisible()) {
                int n36 = n3++;
                drawOrderArray[n36] = new DrawOrder(this, 2512, DataBase.T.size() * 300);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                int n37 = n3++;
                drawOrderArray[n37] = new DrawOrder(this, 2422, DataBase.BB.size() * 300);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                int n38 = n3++;
                drawOrderArray[n38] = new DrawOrder(this, 2412, DataBase.BH.size() * 300);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                int n39 = n3++;
                drawOrderArray[n39] = new DrawOrder(this, 2322, DataBase.HN.size() * 300);
            }
            if (KafPlotProperties.isZenitVisible) {
                int n40 = n3++;
                drawOrderArray[n40] = new DrawOrder(this, 2312, DataBase.HP.size() * 300);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n41 = n3++;
                drawOrderArray[n41] = new DrawOrder(this, 2242, DataBase.MV.size() * 300);
            }
            if (KafPlotProperties.isGpsVisible) {
                int n42 = n3++;
                drawOrderArray[n42] = new DrawOrder(this, 2122, DataBase.MG.size() * 300);
            }
            if (KafPlotProperties.isPolarVisible) {
                int n43 = n3++;
                drawOrderArray[n43] = new DrawOrder(this, 2112, DataBase.MP.size() * 300);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                int n44 = n3++;
                drawOrderArray[n44] = new DrawOrder(this, 2212, DataBase.MM.size() * 300);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n45 = n3++;
                drawOrderArray[n45] = new DrawOrder(this, 2232, DataBase.ME.size() * 300);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n46 = n3++;
                drawOrderArray[n46] = new DrawOrder(this, 2222, DataBase.MK.size() * 300);
            }
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9901, 1);
        if (KafPlotProperties.isEllipseVisible) {
            int n47 = n3++;
            drawOrderArray[n47] = new DrawOrder(this, 5112, DataBase.P.size() * 6);
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9904, 1);
        if (KafPlotProperties.isConditionVisible()) {
            if (KafPlotProperties.isHomogenisierungVisible()) {
                int n48 = n3++;
                drawOrderArray[n48] = new DrawOrder(this, 3412, DataBase.BH.size() * 8);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                int n49 = n3++;
                drawOrderArray[n49] = new DrawOrder(this, 3422, DataBase.BB.size() * 8);
            }
            if (KafPlotProperties.isBedMoveVisible) {
                int n50 = n3++;
                drawOrderArray[n50] = new DrawOrder(this, 3432, DataBase.PM.size() * 8);
            }
            if (KafPlotProperties.isBedIdentVisible) {
                int n51 = n3++;
                drawOrderArray[n51] = new DrawOrder(this, 3442, DataBase.PI.size() * 8);
            }
        }
        if (KafPlotProperties.isAufnahmeVisible) {
            if (KafPlotProperties.isPolarVisible) {
                int n52 = n3++;
                drawOrderArray[n52] = new DrawOrder(this, 3112, DataBase.MP.countObjects() * 70);
            }
            if (KafPlotProperties.isGpsVisible) {
                int n53 = n3++;
                drawOrderArray[n53] = new DrawOrder(this, 3122, DataBase.MG.countObjects() * 70);
            }
            if (KafPlotProperties.isZenitVisible) {
                int n54 = n3++;
                drawOrderArray[n54] = new DrawOrder(this, 3312, DataBase.HP.countObjects() * 25);
            }
        }
        if (KafPlotProperties.isOrthoVisible()) {
            if (KafPlotProperties.isEigeneVisible()) {
                int n55 = n3++;
                drawOrderArray[n55] = new DrawOrder(this, 3212, DataBase.MM.countObjects() * 20);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n56 = n3++;
                drawOrderArray[n56] = new DrawOrder(this, 3222, DataBase.MK.countObjects() * 20);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n57 = n3++;
                drawOrderArray[n57] = new DrawOrder(this, 3232, DataBase.ME.countObjects() * 20);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n58 = n3++;
                drawOrderArray[n58] = new DrawOrder(this, 3242, DataBase.MV.countObjects() * 20);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                int n59 = n3++;
                drawOrderArray[n59] = new DrawOrder(this, 3322, DataBase.HN.countObjects() * 25);
            }
        }
        if (KafPlotProperties.isOrthoVisible() && KafPlotProperties.isMaszeVisible()) {
            if (KafPlotProperties.isEigeneVisible()) {
                int n60 = n3++;
                drawOrderArray[n60] = new DrawOrder(this, 3213, DataBase.MM.countObjects() * 110);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n61 = n3++;
                drawOrderArray[n61] = new DrawOrder(this, 3223, DataBase.MK.countObjects() * 110);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n62 = n3++;
                drawOrderArray[n62] = new DrawOrder(this, 3233, DataBase.ME.countObjects() * 110);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n63 = n3++;
                drawOrderArray[n63] = new DrawOrder(this, 3243, DataBase.MV.countObjects() * 110);
            }
        }
        if (KafPlotProperties.isOrthoVisible() && KafPlotProperties.isRissOrthoNrVisible) {
            if (KafPlotProperties.isEigeneVisible()) {
                int n64 = n3++;
                drawOrderArray[n64] = new DrawOrder(this, 3214, DataBase.MM.size() * 150);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n65 = n3++;
                drawOrderArray[n65] = new DrawOrder(this, 3224, DataBase.MK.size() * 150);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n66 = n3++;
                drawOrderArray[n66] = new DrawOrder(this, 3234, DataBase.ME.size() * 150);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n67 = n3++;
                drawOrderArray[n67] = new DrawOrder(this, 3244, DataBase.MV.size() * 150);
            }
        }
        if (KafPlotProperties.getColorSwitch() != 1009) {
            if (KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaechePolyVisible) {
                float f = 1.0f;
                if (KafPlotProperties.isQuickPaintEnabled) {
                    f = 0.3f;
                } else if (KafPlotProperties.isFlaechePatternVisible) {
                    f = 2.0f;
                }
                if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopPolyVisible) {
                    int n68 = n3++;
                    drawOrderArray[n68] = new DrawOrder(this, 1520, (int)((float)(DataBase.TOP.size() * 7) * f));
                }
                if (KafPlotProperties.isNutzVisible && KafPlotProperties.isNutzPolyVisible) {
                    int n69 = n3++;
                    drawOrderArray[n69] = new DrawOrder(this, 1320, (int)((float)(DataBase.NUTZ.size() * 25) * f));
                }
                if (KafPlotProperties.isBodsVisible && KafPlotProperties.isBodsPolyVisible) {
                    int n70 = n3++;
                    drawOrderArray[n70] = new DrawOrder(this, 1420, (int)((float)(DataBase.BODEN.size() * 30) * f));
                }
                if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
                    int n71 = n3++;
                    drawOrderArray[n71] = new DrawOrder(this, 1220, (int)((float)(DataBase.GEB.size() * 6) * f));
                }
                if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
                    int n72 = n3++;
                    drawOrderArray[n72] = new DrawOrder(this, 1120, (int)((float)(DataBase.FLST.size() * 13) * f));
                }
            }
            if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaecheTextVisible(d)) {
                if (KafPlotProperties.isFlstVisible) {
                    int n73 = 0;
                    if (KafPlotProperties.isFlstTextOldVisible) {
                        n73 += 11;
                    }
                    if (KafPlotProperties.isGbblVisible) {
                        n73 += 11;
                    }
                    if (KafPlotProperties.isEtNameVisible) {
                        n73 += 28;
                    }
                    if (KafPlotProperties.isEtAllVisible) {
                        n73 += 37;
                    }
                    if (KafPlotProperties.isLageKeyVisible) {
                        n73 += 11;
                    }
                    if (KafPlotProperties.isLageTextVisible) {
                        n73 += 15;
                    }
                    if (KafPlotProperties.isAreaBuchVisible || KafPlotProperties.isAreaKooVisible || KafPlotProperties.isAreaDiffVisible || KafPlotProperties.isAreaPercVisible) {
                        n73 += 12;
                    }
                    int n74 = n3++;
                    drawOrderArray[n74] = new DrawOrder(this, 1130, DataBase.FLST.size() * n73);
                }
                if (KafPlotProperties.isGebaeudeVisible) {
                    int n75 = 0;
                    if (KafPlotProperties.isGebNumberVisible) {
                        n75 += 15;
                    }
                    if (KafPlotProperties.isGebLfdnrVisible) {
                        n75 += 40;
                    }
                    if (KafPlotProperties.isGebGschzVisible) {
                        n75 += 0;
                    }
                    if (KafPlotProperties.isGebNameVisible) {
                        n75 += 0;
                    }
                    if (KafPlotProperties.isGebSymVisible) {
                        n75 += 0;
                    }
                    if (KafPlotProperties.isGebAttVisible) {
                        n75 += 0;
                    }
                    int n76 = n3++;
                    drawOrderArray[n76] = new DrawOrder(this, 1230, DataBase.GEB.size() * n75);
                }
                if (KafPlotProperties.isNutzVisible) {
                    int n77 = 0;
                    if (KafPlotProperties.isNutzNumberVisible) {
                        n77 += 0;
                    }
                    if (KafPlotProperties.isNutzTextVisible) {
                        n77 += 0;
                    }
                    if (KafPlotProperties.isNutzSymVisible) {
                        n77 += 0;
                    }
                    int n78 = n3++;
                    drawOrderArray[n78] = new DrawOrder(this, 1330, DataBase.NUTZ.size() * n77);
                }
                if (KafPlotProperties.isBodsVisible && KafPlotProperties.isBodsTextVisible) {
                    int n79 = n3++;
                    drawOrderArray[n79] = new DrawOrder(this, 1430, DataBase.BODEN.size() * 22);
                }
                if (KafPlotProperties.isTopographieVisible) {
                    int n80 = n3++;
                    drawOrderArray[n80] = new DrawOrder(this, 1530, DataBase.TOP.size() * 11);
                }
            }
        }
        if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaecheLengthVisible()) {
            float f;
            float f2 = f = KafPlotProperties.isFlaecheLengthNachwVisible ? 0.4f : 1.0f;
            if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopographieLengthVisible) {
                int n81 = n3++;
                drawOrderArray[n81] = new DrawOrder(this, 1540, (int)((float)(DataBase.TOP.size() * 300) * f));
            }
            if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebaeudeLengthVisible) {
                int n82 = n3++;
                drawOrderArray[n82] = new DrawOrder(this, 1240, (int)((float)(DataBase.GEB.size() * 600) * f));
            }
            if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstLengthVisible) {
                int n83 = n3++;
                drawOrderArray[n83] = new DrawOrder(this, 1140, (int)((float)(DataBase.FLST.size() * 600) * f));
            }
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9901, 1);
        if (KafPlotProperties.isPunktVisible(d)) {
            drawOrderArray[n3++] = new DrawOrder(this, 5110, n2 * 6);
            int n84 = 0;
            if (KafPlotProperties.isPunktTextVisible(d)) {
                if (KafPlotProperties.isPunktNummerVisible) {
                    n84 += 2;
                }
                if (KafPlotProperties.isPunktHoeheVisible) {
                    ++n84;
                }
                if (KafPlotProperties.isVermarkungVisible) {
                    n84 += 2;
                }
                drawOrderArray[n3++] = new DrawOrder(this, 5120, n2 * n84);
            }
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9903, 1);
        if (KafPlotProperties.isTrafoVisible()) {
            int n85 = n3++;
            drawOrderArray[n85] = new DrawOrder(this, 3512, DataBase.T.countObjects() * 3);
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9904, 1);
        if (KafPlotProperties.isKatIdentVisible()) {
            int n86 = n3++;
            drawOrderArray[n86] = new DrawOrder(this, 8120, DataBase.P_IDENT.size() * 5);
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9903, 1);
        if (KafPlotProperties.isGitterVisible()) {
            drawOrderArray[n3++] = new DrawOrder(this, 8110, 40);
        }
        if (KafPlotProperties.isImagesVisible()) {
            if (KafPlotProperties.isImgPolyVisible) {
                int n87 = n3++;
                drawOrderArray[n87] = new DrawOrder(this, 8020, DataBase.IMG.size() * 5);
            }
            if (KafPlotProperties.isImgTextVisible) {
                int n88 = n3++;
                drawOrderArray[n88] = new DrawOrder(this, 8030, DataBase.IMG.size() * 10);
            }
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9902, 1);
        if (KafPlotProperties.isImagesVisible()) {
            int n89 = n3++;
            drawOrderArray[n89] = new DrawOrder(this, 8040, DataBase.IMG.size() * 5);
        }
        drawOrderArray[n3++] = new DrawOrder(this, 9903, 1);
        if (KafPlotProperties.isRissTextVisible) {
            if (KafPlotProperties.isPolarVisible) {
                int n90 = n3++;
                drawOrderArray[n90] = new DrawOrder(this, 2113, DataBase.MP.size() * 50);
            }
            if (KafPlotProperties.isGpsVisible) {
                int n91 = n3++;
                drawOrderArray[n91] = new DrawOrder(this, 2123, DataBase.MG.size() * 50);
            }
            if (KafPlotProperties.isZenitVisible) {
                int n92 = n3++;
                drawOrderArray[n92] = new DrawOrder(this, 2313, DataBase.HP.size() * 50);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                int n93 = n3++;
                drawOrderArray[n93] = new DrawOrder(this, 2213, DataBase.MM.size() * 50);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                int n94 = n3++;
                drawOrderArray[n94] = new DrawOrder(this, 2223, DataBase.MK.size() * 50);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                int n95 = n3++;
                drawOrderArray[n95] = new DrawOrder(this, 2233, DataBase.ME.size() * 50);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                int n96 = n3++;
                drawOrderArray[n96] = new DrawOrder(this, 2243, DataBase.MV.size() * 50);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                int n97 = n3++;
                drawOrderArray[n97] = new DrawOrder(this, 2323, DataBase.HN.size() * 50);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                int n98 = n3++;
                drawOrderArray[n98] = new DrawOrder(this, 2413, DataBase.BH.size() * 50);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                int n99 = n3++;
                drawOrderArray[n99] = new DrawOrder(this, 2423, DataBase.BB.size() * 50);
            }
            if (KafPlotProperties.isTrafoVisible()) {
                int n100 = n3++;
                drawOrderArray[n100] = new DrawOrder(this, 2513, DataBase.T.size() * 50);
            }
        }
        GraphicClip graphicClip = this;
        if (graphicClip.db.hasMenge()) {
            int n101 = n3++;
            drawOrderArray[n101] = new DrawOrder(this, 8130, DataBase.MENGE.size() * 6);
        }
        if (KafPlotProperties.isBemerkungVisible()) {
            int n102 = n3++;
            drawOrderArray[n102] = new DrawOrder(this, 8140, (DataBase.BEM.size() + DataBase.ERR.size()) * 5);
        }
        if (KafPlotVersion.isTestVersion()) {
            drawOrderArray[n3++] = new DrawOrder(this, 8160, 5);
        }
        double d2 = Math.sqrt((double)n / (double)DataBase.P.size());
        double d3 = this.timeRegister.getCoefficient();
        double d4 = d2 * d3;
        for (int i = 0; i < drawOrderArray.length; ++i) {
            int n103;
            if (drawOrderArray[i] == null || drawOrderArray[i].order == 5110) continue;
            drawOrderArray[i].time = n103 = (int)((double)drawOrderArray[i].time * d4);
        }
    }

    @Override
    public void print(Graphics graphics) {
        Object object;
        Object object2;
        IGraphics iGraphics = this.iGraphics;
        TextArt.setMedium(1);
        pnrFormat = KafPlotProperties.getPnrFormat();
        phFormat = KafPlotProperties.getPhFormat();
        pnrFont = KafPlotProperties.getPnrFont();
        phFont = KafPlotProperties.getPhFont();
        peFont = KafPlotProperties.getPeFont();
        vaFont = KafPlotProperties.getVaFont();
        Dimension dimension = this.getSize();
        DrawField drawField = new DrawField(dimension.width, dimension.height);
        iGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        iGraphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        iGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        iGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        iGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        iGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        iGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        iGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        IGraphics iGraphics2 = new IGraphics(drawField, iGraphics.getTransform(), iGraphics.getDrawRect());
        this.BESCHRIFTUNG.removeAllElements();
        if (KafPlotProperties.isImagesVisible()) {
            object2 = DataBase.IMG.elements();
            while (object2.hasMoreElements()) {
                object = (GeoImage)object2.nextElement();
                if (!((GeoImage)object).isVisible()) continue;
                ((GeoImage)object).drawObject(iGraphics, true, false);
            }
        }
        if (KafPlotProperties.getColorSwitch() != 1001 && KafPlotProperties.getColorSwitch() != 1004 && KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaecheFillVisible) {
            if (KafPlotProperties.isNutzVisible && KafPlotProperties.isNutzFillVisible) {
                this.drawAreas(iGraphics, DataBase.NUTZ);
            }
            if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstFillVisible) {
                this.drawAreas(iGraphics, DataBase.FLST);
            }
            if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebFillVisible) {
                this.drawAreas(iGraphics, DataBase.GEB);
            }
            if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopFillVisible) {
                this.drawAreas(iGraphics, DataBase.TOP);
            }
        }
        if (KafPlotProperties.getColorSwitch() == 1009) {
            drawField.setFill((byte)10);
            if (KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaechePolyVisible) {
                if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.TOP);
                    this.drawPolyLines(iGraphics2, DataBase.TOP);
                }
                if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.GEB);
                    this.drawPolyLines(iGraphics2, DataBase.GEB);
                }
                if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.FLST);
                    this.drawPolyLines(iGraphics2, DataBase.FLST);
                }
            }
        }
        if (KafPlotProperties.isRissFillVisible) {
            if (KafPlotProperties.isTrafoVisible()) {
                this.drawRissBackground(iGraphics, DataBase.T, true);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                this.drawRissBackground(iGraphics, DataBase.BB, true);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                this.drawRissBackground(iGraphics, DataBase.BH, true);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                this.drawRissBackground(iGraphics, DataBase.HN, true);
            }
            if (KafPlotProperties.isZenitVisible) {
                this.drawRissBackground(iGraphics, DataBase.HP, true);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                this.drawRissBackground(iGraphics, DataBase.MV, true);
            }
            if (KafPlotProperties.isGpsVisible) {
                this.drawRissBackground(iGraphics, DataBase.MG, true);
            }
            if (KafPlotProperties.isPolarVisible) {
                this.drawRissBackground(iGraphics, DataBase.MP, true);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                this.drawRissBackground(iGraphics, DataBase.MM, true);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                this.drawRissBackground(iGraphics, DataBase.ME, true);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                this.drawRissBackground(iGraphics, DataBase.MK, true);
            }
        }
        if (KafPlotProperties.isRissPolyVisible) {
            if (KafPlotProperties.isTrafoVisible()) {
                this.drawRissForeground(iGraphics, DataBase.T, true);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                this.drawRissForeground(iGraphics, DataBase.BB, true);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                this.drawRissForeground(iGraphics, DataBase.BH, true);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                this.drawRissForeground(iGraphics, DataBase.HN, true);
            }
            if (KafPlotProperties.isZenitVisible) {
                this.drawRissForeground(iGraphics, DataBase.HP, true);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                this.drawRissForeground(iGraphics, DataBase.MV, true);
            }
            if (KafPlotProperties.isGpsVisible) {
                this.drawRissForeground(iGraphics, DataBase.MG, true);
            }
            if (KafPlotProperties.isPolarVisible) {
                this.drawRissForeground(iGraphics, DataBase.MP, true);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                this.drawRissForeground(iGraphics, DataBase.MM, true);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                this.drawRissForeground(iGraphics, DataBase.ME, true);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                this.drawRissForeground(iGraphics, DataBase.MK, true);
            }
        }
        if (KafPlotProperties.isEllipseVisible) {
            this.drawPunktFehler(iGraphics, true);
        }
        if (KafPlotProperties.isConditionVisible()) {
            if (KafPlotProperties.isHomogenisierungVisible()) {
                this.drawBedingungen(iGraphics, DataBase.BH);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                this.drawBedingungen(iGraphics, DataBase.BB);
            }
        }
        if (KafPlotProperties.isAufnahmeVisible) {
            if (KafPlotProperties.isPolarVisible) {
                this.drawMessungen(iGraphics, DataBase.MP, true);
                drawField.setFill((byte)99);
                this.drawMessungen(iGraphics2, DataBase.MP, true);
            }
            if (KafPlotProperties.isGpsVisible) {
                this.drawMessungen(iGraphics, DataBase.MG, true);
                drawField.setFill((byte)99);
                this.drawMessungen(iGraphics2, DataBase.MG, true);
            }
            if (KafPlotProperties.isZenitVisible) {
                this.drawHoehen(iGraphics, DataBase.HP, true);
                drawField.setFill((byte)99);
                this.drawHoehen(iGraphics2, DataBase.HP, true);
            }
        }
        drawField.setFill((byte)10);
        if (KafPlotProperties.isOrthoVisible()) {
            if (KafPlotProperties.isEigeneVisible()) {
                this.drawMessungen(iGraphics, DataBase.MM, true);
                this.drawMessungen(iGraphics2, DataBase.MM, true);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                this.drawMessungen(iGraphics, DataBase.MK, true);
                this.drawMessungen(iGraphics2, DataBase.MK, true);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                this.drawMessungen(iGraphics, DataBase.ME, true);
                this.drawMessungen(iGraphics2, DataBase.ME, true);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                this.drawMessungen(iGraphics, DataBase.MV, true);
                this.drawMessungen(iGraphics2, DataBase.MV, true);
            }
            if (KafPlotProperties.isNivellementVisible) {
                this.drawHoehen(iGraphics, DataBase.HN, true);
                drawField.setFill((byte)99);
                this.drawHoehen(iGraphics2, DataBase.HN, true);
            }
        }
        if (KafPlotProperties.getColorSwitch() != 1009) {
            drawField.setFill((byte)10);
            if (KafPlotProperties.isFlaecheVisible && KafPlotProperties.isFlaechePolyVisible) {
                if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.TOP);
                    this.drawPolyLines(iGraphics2, DataBase.TOP);
                }
                if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.GEB);
                    this.drawPolyLines(iGraphics2, DataBase.GEB);
                }
                if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstPolyVisible) {
                    this.drawPolyLines(iGraphics, DataBase.FLST);
                    this.drawPolyLines(iGraphics2, DataBase.FLST);
                }
            }
        }
        if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaecheTextVisible(iGraphics.getScale())) {
            if (KafPlotProperties.isFlstVisible) {
                this.inscriptObjects(iGraphics, DataBase.FLST);
            }
            if (KafPlotProperties.isGebaeudeVisible) {
                this.inscriptObjects(iGraphics, DataBase.GEB);
            }
            if (KafPlotProperties.isTopographieVisible) {
                this.inscriptObjects(iGraphics, DataBase.TOP);
            }
        }
        if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaecheLengthVisible(iGraphics.getScale())) {
            if (KafPlotProperties.isTopographieVisible && KafPlotProperties.isTopographieLengthVisible) {
                this.printLinieLength(iGraphics, DataBase.TOP);
                this.printLinieLength(iGraphics2, DataBase.TOP);
            }
            if (KafPlotProperties.isGebaeudeVisible && KafPlotProperties.isGebaeudeLengthVisible) {
                this.printLinieLength(iGraphics, DataBase.GEB);
                this.printLinieLength(iGraphics2, DataBase.GEB);
            }
            if (KafPlotProperties.isFlstVisible && KafPlotProperties.isFlstLengthVisible) {
                this.printLinieLength(iGraphics, DataBase.FLST);
                this.printLinieLength(iGraphics2, DataBase.FLST);
            }
        }
        if (KafPlotProperties.isTrafoVisible()) {
            this.drawTrafoSysteme(iGraphics);
        }
        this.drawPunkte(iGraphics, true, drawField);
        if (KafPlotProperties.isKatIdentVisible()) {
            this.drawIdentitaeten(iGraphics);
        }
        if (KafPlotProperties.isGitterVisible()) {
            this.printGitter(iGraphics);
        }
        if (KafPlotProperties.isImagesVisible() && (KafPlotProperties.isImgPolyVisible || KafPlotProperties.isImgTextVisible)) {
            object2 = DataBase.IMG.elements();
            while (object2.hasMoreElements()) {
                object = (GeoImage)object2.nextElement();
                if (KafPlotProperties.isImgPolyVisible) {
                    ((GeoImage)object).drawForeground(iGraphics, true, true);
                }
                if (!KafPlotProperties.isImgTextVisible) continue;
                ((GeoImage)object).drawInscription(iGraphics, true, true);
            }
        }
        if (KafPlotProperties.isRissTextVisible) {
            if (KafPlotProperties.isPolarVisible) {
                this.drawRissNames(iGraphics, DataBase.MP, true);
            }
            if (KafPlotProperties.isGpsVisible) {
                this.drawRissNames(iGraphics, DataBase.MG, true);
            }
            if (KafPlotProperties.isZenitVisible) {
                this.drawRissNames(iGraphics, DataBase.HP, true);
            }
            if (KafPlotProperties.isEigeneVisible()) {
                this.drawRissNames(iGraphics, DataBase.MM, true);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                this.drawRissNames(iGraphics, DataBase.MK, true);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                this.drawRissNames(iGraphics, DataBase.ME, true);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                this.drawRissNames(iGraphics, DataBase.MV, true);
            }
            if (KafPlotProperties.isNivellementVisible()) {
                this.drawRissNames(iGraphics, DataBase.HN, true);
            }
            if (KafPlotProperties.isHomogenisierungVisible()) {
                this.drawRissNames(iGraphics, DataBase.BH, true);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                this.drawRissNames(iGraphics, DataBase.BB, true);
            }
            if (KafPlotProperties.isTrafoVisible()) {
                this.drawRissNames(iGraphics, DataBase.T, true);
            }
        }
        if (KafPlotProperties.isRissOrthoNrVisible) {
            if (KafPlotProperties.isEigeneVisible()) {
                this.drawRissOrthoNr(iGraphics, DataBase.MM, true);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                this.drawRissOrthoNr(iGraphics, DataBase.MK, true);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                this.drawRissOrthoNr(iGraphics, DataBase.ME, true);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                this.drawRissOrthoNr(iGraphics, DataBase.MV, true);
            }
        }
        if (KafPlotProperties.isBemerkungVisible()) {
            DataBase.BEM.checkLayout();
            DataBase.ERR.checkLayout();
            this.drawBeschriftung(iGraphics);
        }
        if (KafPlotVersion.isTestVersion()) {
            object2 = new Font("SansSerif", 1, 36);
            object = graphics.getFontMetrics((Font)object2);
            String string = "TestVersion";
            int n = ((FontMetrics)object).stringWidth(string) + 5;
            graphics.setColor(Color.lightGray);
            graphics.setFont((Font)object2);
            for (int i = 0; i < this.getSize().height + 41; i += 41) {
                for (int j = 5; j < this.getSize().width; j += n) {
                    graphics.drawString(string, j, i);
                }
            }
        }
    }

    private void drawImageBackground(IGraphics iGraphics) {
        if (KafPlotProperties.isImgFillVisible) {
            Enumeration enumeration = DataBase.IMG.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)enumeration.nextElement();
                if (!geoImage.isVisible()) continue;
                geoImage.drawBackground(iGraphics, true, false);
            }
        }
    }

    private void drawImageForeground(IGraphics iGraphics) {
        if (KafPlotProperties.isImagesVisible() && KafPlotProperties.isImgPolyVisible) {
            Enumeration enumeration = DataBase.IMG.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)enumeration.nextElement();
                geoImage.drawForeground(iGraphics, true, false);
            }
        }
    }

    private void drawImageInscription(IGraphics iGraphics) {
        if (KafPlotProperties.isImagesVisible() && KafPlotProperties.isImgTextVisible) {
            Enumeration enumeration = DataBase.IMG.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)enumeration.nextElement();
                geoImage.drawInscription(iGraphics, true, false);
            }
        }
    }

    private void drawImageControls(IGraphics iGraphics) {
        if (KafPlotProperties.isImagesVisible()) {
            Enumeration enumeration = DataBase.IMG.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)enumeration.nextElement();
                geoImage.drawControls(iGraphics, true, false);
            }
        }
    }

    private void drawPunkte(IGraphics iGraphics) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        FontMetrics fontMetrics = this.getFontMetrics(vaFont);
        int n = 5;
        boolean bl = KafPlotProperties.isPunktVisible(iGraphics.getScale());
        boolean bl2 = KafPlotProperties.isPunktNummerVisible() || KafPlotProperties.isPunktHoeheVisible() || KafPlotProperties.isEllipseTextVisible;
        boolean bl3 = KafPlotProperties.isPunktArtVisible;
        boolean bl4 = KafPlotProperties.isPunktTextVisible(iGraphics.getScale());
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!iGraphics.contains(punkt) || !punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
            if (bl) {
                punkt.drawSymbol(iGraphics, point.x, point.y, bl3, false, false);
            }
            if (KafPlotProperties.isPunktTextFilterEnabled() && !KafPlotProperties.getPunktTextFilter().isPunktEnabled(punkt)) continue;
            if (bl && bl4) {
                int n2 = punkt.getSymbolRadius(bl3, false);
                if (bl2) {
                    this.drawPunktNummer(graphics, point.x + (n2 + n), point.y, punkt);
                }
                if (KafPlotProperties.isVermarkungVisible) {
                    graphics.setFont(vaFont);
                    this.drawVermarkung(graphics, point.x - (n2 + n), point.y, fontMetrics, punkt);
                }
            }
            if (!punkt.hasBemerkung()) continue;
            this.addBeschriftung(punkt);
        }
    }

    private void drawPunktSymbole(IGraphics iGraphics) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        FontMetrics fontMetrics = this.getFontMetrics(vaFont);
        int n = 5;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!iGraphics.contains(punkt) || !punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
            punkt.drawSymbol(iGraphics, point.x, point.y, KafPlotProperties.isPunktArtVisible, false, false);
        }
        int n2 = KafPlotProperties.getColorSwitch();
        if (n2 == 1001 || n2 == 1009 || n2 == 1004) {
            double d = 0.0;
            Hashtable<Punkt, Punkt> hashtable = new Hashtable<Punkt, Punkt>();
            GraphicClip graphicClip = this;
            Enumeration enumeration2 = graphicClip.db.einrechenMessungen();
            while (enumeration2.hasMoreElements()) {
                Messung messung = (Messung)enumeration2.nextElement();
                int n3 = messung.getMessungsArt();
                if (n3 == 210) {
                    try {
                        d = DLine.getAngle(messung.ps, messung.getReferenz().ps) + iGraphics.getRotation() - 1.5707963267948966;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (n3 != 200 || !iGraphics.contains(messung.ps) || !messung.ps.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(messung.ps, point))) continue;
                double d2 = hashtable.put(messung.ps, messung.ps) == null ? 0.2 : 0.26;
                Symbol.setForeground(messung.ps.getForegroundColor(KafPlotProperties.isPunktArtVisible, false));
                Symbol.INLINIE.draw(graphics, point.x, point.y, d, d2, (byte)0);
            }
        }
    }

    private void drawPunktTexte(IGraphics iGraphics) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        FontMetrics fontMetrics = this.getFontMetrics(vaFont);
        int n = 5;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!iGraphics.contains(punkt) || !punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point)) || KafPlotProperties.isPunktTextFilterEnabled() && !KafPlotProperties.getPunktTextFilter().isPunktEnabled(punkt)) continue;
            int n2 = punkt.getSymbolRadius(KafPlotProperties.isPunktArtVisible, false);
            if (KafPlotProperties.isPunktNummerVisible || KafPlotProperties.isPunktHoeheVisible || KafPlotProperties.isEllipseTextVisible) {
                this.drawPunktNummer(graphics, point.x + (n2 + n), point.y, punkt);
            }
            if (KafPlotProperties.isVermarkungVisible) {
                graphics.setFont(vaFont);
                this.drawVermarkung(graphics, point.x - (n2 + n), point.y, fontMetrics, punkt);
            }
            if (!punkt.hasBemerkung()) continue;
            this.addBeschriftung(punkt);
        }
    }

    private void drawPunktFehler(IGraphics iGraphics, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        if (KafPlotProperties.isEllipseAreaVisible) {
            DPoint dPoint;
            double d = 0.0;
            Comparator comparator = null;
            Enumeration enumeration = null;
            switch (KafPlotProperties.getFehlerSwitch()) {
                case 701: {
                    comparator = new PunktEllipseComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.emax;
                    break;
                }
                case 702: {
                    comparator = new PunktVectorComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.vmax;
                    break;
                }
                case 703: {
                    comparator = new PunktZuverlComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.zmax;
                    break;
                }
                case 704: {
                    comparator = new PunktAnschlussgComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.amax;
                    break;
                }
                case 705: {
                    comparator = new PunktAnschlusszComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.smax;
                    break;
                }
                case 706: {
                    comparator = new PunktHoeheDiffComparator();
                    enumeration = DataBase.P.elements();
                    d = DataBase.dhmax;
                    break;
                }
                case 711: {
                    comparator = new TrafoPunktVComparator();
                    enumeration = new VisibleDataEnumerator(this, DataBase.T);
                    d = DataBase.tvmax;
                    break;
                }
                case 712: {
                    comparator = new TrafoPunktRComparator();
                    enumeration = new VisibleDataEnumerator(this, DataBase.T);
                    d = DataBase.trmax;
                }
            }
            SortableVector sortableVector = new SortableVector(100);
            block30: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                switch (KafPlotProperties.getFehlerSwitch()) {
                    case 701: {
                        dPoint = (Punkt)e;
                        if (((Punkt)dPoint).a != 0 && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 702: {
                        dPoint = (Punkt)e;
                        if ((((Punkt)dPoint).dx != 0.0f || ((Punkt)dPoint).dy != 0.0f) && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 703: {
                        dPoint = (Punkt)e;
                        if (((Punkt)dPoint).zl != 0.0f && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 704: {
                        dPoint = (Punkt)e;
                        if (((Punkt)dPoint).ag != 0.0f && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 705: {
                        dPoint = (Punkt)e;
                        if (((Punkt)dPoint).az != 0.0f && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 706: {
                        dPoint = (Punkt)e;
                        if (((Punkt)dPoint).dh != 0.0f && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 711: {
                        dPoint = (TrafoPunkt)e;
                        if ((((TrafoPunkt)dPoint).getVx() != 0.0f || ((TrafoPunkt)dPoint).getVy() != 0.0f) && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                    case 712: {
                        dPoint = (TrafoPunkt)e;
                        if ((((TrafoPunkt)dPoint).getRx() != 0.0f || ((TrafoPunkt)dPoint).getRy() != 0.0f) && this.drawRect.contains(iGraphics.getGraphicPoint(dPoint, point))) break;
                        continue block30;
                    }
                }
                sortableVector.addElement(e);
            }
            sortableVector.sort(comparator);
            int n = Math.max((int)Math.sqrt(this.me), 6);
            enumeration = sortableVector.elements();
            while (enumeration.hasMoreElements()) {
                dPoint = null;
                switch (KafPlotProperties.getFehlerSwitch()) {
                    case 701: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.ellColor.getColor(((Punkt)dPoint).getSP()));
                        break;
                    }
                    case 702: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.vecColor.getColor(((Punkt)dPoint).getDS()));
                        break;
                    }
                    case 703: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.lzvColor.getColor(((Punkt)dPoint).getZL()));
                        break;
                    }
                    case 704: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.agvColor.getColor(((Punkt)dPoint).getAG()));
                        break;
                    }
                    case 705: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.azvColor.getColor(((Punkt)dPoint).getAZ()));
                        break;
                    }
                    case 706: {
                        dPoint = (Punkt)enumeration.nextElement();
                        graphics.setColor(KafPlotProperties.vdhColor.getColor(Math.abs(((Punkt)dPoint).dh)));
                        break;
                    }
                    case 711: {
                        TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                        dPoint = trafoPunkt.getPunkt();
                        graphics.setColor(KafPlotProperties.tpvColor.getColor(trafoPunkt.getVs()));
                        break;
                    }
                    case 712: {
                        TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration.nextElement();
                        dPoint = trafoPunkt.getPunkt();
                        graphics.setColor(KafPlotProperties.tprColor.getColor(trafoPunkt.getRs()));
                        break;
                    }
                }
                if (dPoint == null || !((Punkt)dPoint).isVisible()) continue;
                point = iGraphics.getGraphicPoint(dPoint, point);
                graphics.fillArc(point.x - n, point.y - n, 2 * n, 2 * n, 0, 360);
            }
        } else {
            graphics.setColor(Color.red);
            int n = KafPlotProperties.getFehlerSwitch();
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                Punkt punkt = (Punkt)enumeration.nextElement();
                if (!punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
                if (n == 701) {
                    if (punkt.a <= 0 && punkt.b <= 0) continue;
                    this.drawEllipse(iGraphics, punkt, (double)punkt.a * 0.001, (double)punkt.b * 0.001, punkt.t);
                    continue;
                }
                if (n == 702) {
                    if (punkt.dy == 0.0f && punkt.dx == 0.0f) continue;
                    this.drawDyDx(iGraphics, punkt, punkt.dy, punkt.dx);
                    continue;
                }
                if (n == 703) {
                    if (!(punkt.zl > 0.0f)) continue;
                    this.drawEllipse(iGraphics, punkt, punkt.zl, punkt.zl, 0.0);
                    continue;
                }
                if (n == 704) {
                    if (!(punkt.ag > 0.0f)) continue;
                    this.drawEllipse(iGraphics, punkt, punkt.ag, punkt.ag, 0.0);
                    continue;
                }
                if (n == 705) {
                    if (!(punkt.az > 0.0f)) continue;
                    this.drawEllipse(iGraphics, punkt, punkt.az, punkt.az, 0.0);
                    continue;
                }
                if (n != 706 || punkt.dh == 0.0f) continue;
                this.drawDyDx(iGraphics, punkt, 0.0f, punkt.dh);
            }
        }
    }

    private void drawPunkte(IGraphics iGraphics, boolean bl, DrawField drawField) {
        int n;
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        FontMetrics fontMetrics = this.getFontMetrics(vaFont);
        int n2 = n = bl ? 3 : 5;
        if (KafPlotProperties.isPunktVisible(iGraphics.getScale())) {
            Punkt punkt;
            Enumeration enumeration = DataBase.P.elements();
            while (enumeration.hasMoreElements()) {
                punkt = (Punkt)enumeration.nextElement();
                if (!iGraphics.contains(punkt) || !punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
                if (bl) {
                    punkt.printSymbol(iGraphics, point, KafPlotProperties.isPunktArtVisible);
                } else {
                    punkt.drawSymbol(iGraphics, point, KafPlotProperties.isPunktArtVisible);
                }
                int n3 = punkt.getSymbolRadius(KafPlotProperties.isPunktArtVisible, bl);
                drawField.setFill((byte)99);
                drawField.fillRect(point.x - n3, point.y - n3, n3 * 2, n3 * 2);
            }
            if (KafPlotProperties.isPunktTextVisible(iGraphics.getScale())) {
                enumeration = DataBase.P.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    punkt = (Punkt)enumeration.nextElement();
                    if (!punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
                    IInscription iInscription = new IInscription(point);
                    IInscriptionComponent iInscriptionComponent = null;
                    boolean bl2 = false;
                    int n4 = 0;
                    if (KafPlotProperties.isPunktNummerVisible) {
                        switch (KafPlotProperties.getNummerSwitch()) {
                            case 101: {
                                iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.nr), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                                iInscriptionComponent.setFont(pnrFont);
                                iInscriptionComponent.setForeground(KafPlotColor.PNR_LOKAL);
                                break;
                            }
                            case 102: {
                                if (punkt.getUmnum() <= 0L) {
                                    iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.nr), 0, n4++);
                                    iInscription.add(iInscriptionComponent);
                                    iInscriptionComponent.setForeground(KafPlotColor.PNR_LOKAL);
                                } else {
                                    iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.getUmnum()), 0, n4++);
                                    iInscription.add(iInscriptionComponent);
                                    iInscriptionComponent.setForeground(KafPlotColor.PNR_UMNUM);
                                }
                                iInscriptionComponent.setFont(pnrFont);
                                break;
                            }
                            case 103: {
                                iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.nr), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                                iInscriptionComponent.setFont(pnrFont);
                                iInscriptionComponent.setForeground(KafPlotColor.PNR_LOKAL);
                                if (punkt.getUmnum() <= 0L) break;
                                iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.getUmnum()), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                                iInscriptionComponent.setForeground(KafPlotColor.PNR_UMNUM);
                                iInscriptionComponent.setFont(pnrFont);
                                break;
                            }
                            case 111: {
                                if (punkt.getUmnum() > 0L) break;
                                iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.nr), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                                iInscriptionComponent.setFont(pnrFont);
                                iInscriptionComponent.setForeground(KafPlotColor.PNR_LOKAL);
                                break;
                            }
                            case 112: {
                                if (punkt.getUmnum() <= 0L) break;
                                iInscriptionComponent = new IInscriptionComponent(pnrFormat.format(punkt.getUmnum()), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                                iInscriptionComponent.setForeground(KafPlotColor.PNR_UMNUM);
                                iInscriptionComponent.setFont(pnrFont);
                            }
                        }
                    }
                    if (KafPlotProperties.isPunktHoeheVisible() && punkt.h != 0.0f) {
                        iInscriptionComponent = new IInscriptionComponent(phFormat.format(punkt.h), 0, n4++);
                        iInscription.add(iInscriptionComponent);
                        iInscriptionComponent.setFont(phFont);
                        iInscriptionComponent.setForeground(KafPlotColor.HOEHE);
                    }
                    if (KafPlotProperties.isEllipseTextVisible) {
                        object = null;
                        int n5 = KafPlotProperties.getFehlerSwitch();
                        if (n5 == 701) {
                            if (punkt.a > 0 || punkt.b > 0) {
                                object = IFormat.f_3.format(punkt.getSP());
                            }
                        } else if (n5 == 702) {
                            if (punkt.dy != 0.0f || punkt.dx != 0.0f) {
                                object = IFormat.f_3.format(punkt.getDS());
                            }
                        } else if (n5 == 703) {
                            if (punkt.zl > 0.0f) {
                                object = IFormat.f_3.format(punkt.zl);
                            }
                        } else if (n5 == 704) {
                            if (punkt.ag > 0.0f) {
                                object = IFormat.f_3.format(punkt.ag);
                            }
                        } else if (n5 == 705) {
                            if (punkt.az > 0.0f) {
                                object = IFormat.f_3.format(punkt.az);
                            }
                        } else if (n5 == 706 && punkt.dh != 0.0f) {
                            object = IFormat.f_3.format(punkt.dh);
                        }
                        if (object != null) {
                            iInscriptionComponent = new IInscriptionComponent((String)object, 0, n4++);
                            iInscription.add(iInscriptionComponent);
                            iInscriptionComponent.setFont(phFont);
                            iInscriptionComponent.setForeground(Color.red);
                        }
                    }
                    if (KafPlotProperties.isVermarkungVisible) {
                        object = punkt.getParameter();
                        String string = VermarkungsArt.getVermarkungsArt(((PunktParameter)object).getVa()).getKuerzel();
                        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(((PunktParameter)object).getVva());
                        String string2 = !vermarkungsArt.isUnvermarkt() ? vermarkungsArt.getKuerzel() : null;
                        int n6 = ((PunktParameter)object).getKafVva();
                        if (n6 == 19) {
                            string = vermarkungsArt.getKuerzel();
                            string2 = null;
                        } else if (n6 == 99) {
                            string2 = string;
                            string = vermarkungsArt.getKuerzel();
                        }
                        if (string != null && string.trim().length() > 0) {
                            if (((PunktParameter)object).getKafVvt() == 0 || string2 != null) {
                                iInscriptionComponent = new IInscriptionComponent(string, 0, n4++);
                                iInscription.add(iInscriptionComponent);
                            } else {
                                iInscriptionComponent = new IInscriptionComponent((((PunktParameter)object).getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(((PunktParameter)object).getKafVvt()) / 10.0) : string) + "\t" + (((PunktParameter)object).getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(((PunktParameter)object).getKafVvt()) / 10.0) : string), 0, n4++);
                                iInscription.add(iInscriptionComponent);
                            }
                            iInscriptionComponent.setFont(vaFont);
                            iInscriptionComponent.setForeground(punkt.isNeuVermarkt() ? KafPlotColor.GP_NEU : KafPlotColor.GP_VORHANDEN);
                        }
                        if (string2 != null && string2.trim().length() > 0) {
                            if (((PunktParameter)object).getKafVvt() == 0) {
                                iInscriptionComponent = new IInscriptionComponent(string2, 0, n4);
                                iInscription.add(iInscriptionComponent);
                            } else {
                                iInscriptionComponent = new IInscriptionComponent((((PunktParameter)object).getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(((PunktParameter)object).getKafVvt()) / 10.0) : string2) + "\t" + (((PunktParameter)object).getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(((PunktParameter)object).getKafVvt()) / 10.0) : string2), 0, n4);
                                iInscription.add(iInscriptionComponent);
                            }
                            iInscriptionComponent.setFont(vaFont);
                            iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
                            iInscriptionComponent = new IInscriptionComponent("aufgef.", 1, n4);
                            iInscription.add(iInscriptionComponent);
                            iInscriptionComponent.setFont(vaFont);
                            iInscriptionComponent.setForeground(KafPlotColor.GP_VORHANDEN);
                        }
                    }
                    if (iInscription.getComponentCount() <= 0) continue;
                    iInscription.doLayout();
                    object = drawField.getOptimizedPosition(iInscription, punkt.getSymbolRadius(KafPlotProperties.isPunktArtVisible, bl) + 5, 80);
                    if (((DrawFieldSearchResult)object).mustOverwrite()) {
                        iInscription.setBackground(TEXT_OVERWRITE);
                        iInscription.overwriteComponents(graphics);
                    } else {
                        iInscription.printComponents(graphics);
                    }
                    iInscription.printComponents(drawField);
                }
            }
        }
    }

    private void drawAreas(IGraphics iGraphics, DataContainerTable dataContainerTable, int n) {
        KafPlotProperties.isShadowing = true;
        iGraphics.getGraphics().translate(n, n);
        this.drawAreas(iGraphics, dataContainerTable);
        iGraphics.getGraphics().translate(-n, -n);
        KafPlotProperties.isShadowing = false;
    }

    private void drawAreas(IGraphics iGraphics, DataContainerTable dataContainerTable) {
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                GObject gObject = (GObject)enumeration.nextElement();
                if (!gObject.isVisible()) continue;
                gObject.drawBackground(iGraphics, false, false);
            }
            catch (NullPointerException nullPointerException) {
                if (this.messageListener == null) continue;
                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, GRAPHIC_EXCEPTION_MESSAGE));
            }
        }
    }

    private void drawPolyLines(IGraphics iGraphics, DataContainerTable dataContainerTable) {
        for (int i = dataContainerTable.size() - 1; i >= 0; --i) {
            try {
                GObject gObject = (GObject)dataContainerTable.elementAt(i);
                if (!gObject.isVisible()) continue;
                gObject.drawForeground(iGraphics, KafPlotProperties.isFlaechePatternVisible, false);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                if (this.messageListener == null) continue;
                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, GRAPHIC_EXCEPTION_MESSAGE));
            }
        }
    }

    private void inscriptObjects(IGraphics iGraphics, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                GObject gObject = (GObject)enumeration.nextElement();
                if (!gObject.isVisible()) continue;
                gObject.drawInscription(iGraphics, true, false);
            }
            catch (NullPointerException nullPointerException) {
                if (this.messageListener == null) continue;
                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, GRAPHIC_EXCEPTION_MESSAGE));
            }
        }
    }

    private void drawGitter(IGraphics iGraphics) {
        this.drawGitter(iGraphics, false);
    }

    private void printGitter(IGraphics iGraphics) {
        this.drawGitter(iGraphics, true);
    }

    private void drawGitter(IGraphics iGraphics, boolean bl) {
        double d = 0.0;
        Point point = new Point();
        Point point2 = new Point();
        DPoint dPoint = new DPoint();
        Graphics graphics = iGraphics.getGraphics();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        double d5 = Double.MIN_VALUE;
        DPoint dPoint2 = new DPoint();
        dPoint2 = iGraphics.getDataPoint(new Point(this.drawRect.x, this.drawRect.y), dPoint2);
        d2 = Math.min(d2, dPoint2.x);
        d3 = Math.min(d3, dPoint2.y);
        d4 = Math.max(d4, dPoint2.x);
        d5 = Math.max(d5, dPoint2.y);
        dPoint2 = iGraphics.getDataPoint(new Point(this.drawRect.x + this.drawRect.width, this.drawRect.y), dPoint2);
        d2 = Math.min(d2, dPoint2.x);
        d3 = Math.min(d3, dPoint2.y);
        d4 = Math.max(d4, dPoint2.x);
        d5 = Math.max(d5, dPoint2.y);
        dPoint2 = iGraphics.getDataPoint(new Point(this.drawRect.x, this.drawRect.y + this.drawRect.height), dPoint2);
        d2 = Math.min(d2, dPoint2.x);
        d3 = Math.min(d3, dPoint2.y);
        d4 = Math.max(d4, dPoint2.x);
        d5 = Math.max(d5, dPoint2.y);
        dPoint2 = iGraphics.getDataPoint(new Point(this.drawRect.x + this.drawRect.width, this.drawRect.y + this.drawRect.height), dPoint2);
        d2 = Math.min(d2, dPoint2.x);
        d3 = Math.min(d3, dPoint2.y);
        d4 = Math.max(d4, dPoint2.x);
        d5 = Math.max(d5, dPoint2.y);
        double d6 = (d3 + d5) * 0.5;
        double d7 = (d2 + d4) * 0.5;
        graphics.setColor(KafPlotColor.GITTER);
        if (1000.0 * iGraphics.getScale() > 5.0) {
            double d8;
            for (d8 = d2; d8 < d4 + 1000.0; d8 += 1000.0) {
                d = (int)d8 / 1000 * 1000;
                if (!iGraphics.contains(d6, d)) continue;
                point = iGraphics.getGraphicPoint(d3, d, point);
                point2 = iGraphics.getGraphicPoint(d5, d, point2);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            for (d8 = d3; d8 < d5 + 1000.0; d8 += 1000.0) {
                d = (int)d8 / 1000 * 1000;
                if (!iGraphics.contains(d, d7)) continue;
                point = iGraphics.getGraphicPoint(d, d2, point);
                point2 = iGraphics.getGraphicPoint(d, d4, point2);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        if (KafPlotProperties.isGitterTextVisible() && 1000.0 * iGraphics.getScale() > 80.0) {
            Font font = KafPlotProperties.getGtFont();
            Font font2 = new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * 0.7));
            FontMetrics fontMetrics = this.getFontMetrics(font);
            FontMetrics fontMetrics2 = this.getFontMetrics(font2);
            for (double d9 = d2; d9 < d4 + 1000.0; d9 += 1000.0) {
                for (double d10 = d3; d10 < d5 + 1000.0; d10 += 1000.0) {
                    dPoint.setLocation((int)d10 / 1000 * 1000 + 500, (int)d9 / 1000 * 1000 + 500);
                    if (!iGraphics.contains(dPoint)) continue;
                    String string = GeoNumberFormat.nr02n.format((int)dPoint.y / 100000).toString();
                    String string2 = GeoNumberFormat.nr02n.format((int)dPoint.y / 1000 % 100).toString();
                    String string3 = GeoNumberFormat.nr02n.format((int)dPoint.x / 100000).toString();
                    String string4 = GeoNumberFormat.nr02n.format((int)dPoint.x / 1000 % 100).toString();
                    point = iGraphics.getGraphicPoint(dPoint, point);
                    graphics.setFont(font);
                    graphics.drawString(".", point.x, point.y + fontMetrics.getAscent() / 2);
                    graphics.drawString(string2, point.x - fontMetrics.stringWidth(string2), point.y + fontMetrics.getAscent() / 2);
                    graphics.drawString(string4, point.x + fontMetrics.stringWidth(".") + fontMetrics2.stringWidth(string3), point.y + fontMetrics.getAscent() / 2);
                    graphics.setFont(font2);
                    graphics.drawString(string, point.x - fontMetrics.stringWidth(string2) - fontMetrics2.stringWidth(string), point.y);
                    graphics.drawString(string3, point.x + fontMetrics.stringWidth("."), point.y);
                }
            }
        }
    }

    private Color getRissColor(ValueDataContainer valueDataContainer, int n) {
        Color color = Color.gray;
        int n2 = KafPlotProperties.getColorMessSwitch();
        if (n2 == 2003) {
            color = KafPlotProperties.mnmColor.getColor(valueDataContainer.getId());
        } else if (n2 == 2002) {
            color = KafPlotProperties.mrhColor.getColor(n);
        } else if (n2 == 2004) {
            Object object = valueDataContainer.firstElement();
            if (object instanceof TrafoPunkt) {
                color = KafPlotProperties.mgwColor.getColor(1.0);
            } else if (object instanceof Bedingung) {
                color = KafPlotProperties.mgwColor.getColor(((Bedingung)object).g);
            } else if (object instanceof Messung) {
                color = KafPlotProperties.mgwColor.getColor(((Messung)object).getAverageGewicht());
            }
        } else {
            if (n2 >= 2011 && n2 < 2018) {
                return KafPlotColor.getStatColor(n2, valueDataContainer.maxStat.clone(4));
            }
            if (n2 == 2018) {
                color = KafPlotProperties.mefColor.getColor((double)valueDataContainer.maxStatGrzw * 0.001);
            } else if (n2 == 2019) {
                color = KafPlotProperties.mekColor.getColor((double)valueDataContainer.maxStatEgk * 0.001);
            } else {
                Object object = valueDataContainer.firstElement();
                if (object instanceof TrafoPunkt) {
                    color = KafPlotProperties.mmaColor.getColor(new Integer(40));
                } else if (object instanceof Bedingung) {
                    color = KafPlotProperties.mmaColor.getColor(new Integer(60));
                } else if (object instanceof Messung) {
                    Messung messung = (Messung)object;
                    switch (messung.getMessungsArt(false)) {
                        case -200: 
                        case 230: {
                            color = KafPlotProperties.mmaColor.getColor(new Integer(23));
                        }
                        case 280: {
                            color = KafPlotProperties.mmaColor.getColor(new Integer(28));
                        }
                        case 270: {
                            color = KafPlotProperties.mmaColor.getColor(new Integer(27));
                        }
                    }
                    color = KafPlotProperties.mmaColor.getColor(new Integer(20));
                }
            }
        }
        return color;
    }

    private void drawRissBackground(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ValueDataContainer valueDataContainer = (ValueDataContainer)enumeration.nextElement();
            if (valueDataContainer.size() == 0) continue;
            if (valueDataContainer.isVisible() && valueDataContainer.isViewable(iGraphics.getViewport())) {
                iGraphics.getGraphics().setColor(IColor.getLighter(this.getRissColor(valueDataContainer, n), 0.1f));
                valueDataContainer.drawHullBackground(iGraphics, bl, false);
            }
            ++n;
        }
    }

    private void drawRissForeground(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ValueDataContainer valueDataContainer = (ValueDataContainer)enumeration.nextElement();
            if (valueDataContainer.size() == 0) continue;
            if (valueDataContainer.isVisible() && valueDataContainer.isViewable(iGraphics.getViewport())) {
                iGraphics.getGraphics().setColor(this.getRissColor(valueDataContainer, n));
                valueDataContainer.drawHullForeground(iGraphics, bl, false);
            }
            ++n;
        }
    }

    private void drawRissNames(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ValueDataContainer valueDataContainer = (ValueDataContainer)enumeration.nextElement();
            if (valueDataContainer.size() == 0) continue;
            if (valueDataContainer.isVisible() && valueDataContainer.isViewable(iGraphics.getViewport())) {
                iGraphics.getGraphics().setColor(this.getRissColor(valueDataContainer, n));
                valueDataContainer.drawHullInscription(iGraphics, bl, false);
            }
            ++n;
        }
    }

    private void drawRissOrthoNr(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ValueDataContainer valueDataContainer = (ValueDataContainer)enumeration.nextElement();
            if (valueDataContainer.size() == 0) continue;
            if (valueDataContainer.isVisible() && valueDataContainer.isViewable(iGraphics.getViewport())) {
                iGraphics.getGraphics().setColor(this.getRissColor(valueDataContainer, n));
                valueDataContainer.drawPartInscription(iGraphics, bl, false);
            }
            ++n;
        }
    }

    private void drawMessungen(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            switch (KafPlotProperties.getColorMessSwitch()) {
                case 2003: {
                    Messung.setDefaultColor(KafPlotProperties.mnmColor.getColor(riss.getId()));
                    break;
                }
                case 2002: {
                    Messung.setDefaultColor(KafPlotProperties.mrhColor.getColor(n));
                    break;
                }
                default: {
                    Messung.setDefaultColor(null);
                }
            }
            if (riss.isVisible() && riss.isViewable(iGraphics.getViewport())) {
                riss.drawObject(iGraphics, bl, false);
            }
            if (KafPlotProperties.isBemerkungVisible()) {
                Enumeration enumeration2 = riss.elements();
                while (enumeration2.hasMoreElements()) {
                    try {
                        Messung messung = (Messung)enumeration2.nextElement();
                        if (!messung.hasText() || !messung.isVisible() || !messung.isViewable(iGraphics.getViewport())) continue;
                        this.addBeschriftung(messung);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
            ++n;
        }
    }

    private void drawMessungenFG(IGraphics iGraphics, Vector vector, boolean bl) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            switch (KafPlotProperties.getColorMessSwitch()) {
                case 2003: {
                    Messung.setDefaultColor(KafPlotProperties.mnmColor.getColor(riss.getId()));
                    break;
                }
                case 2002: {
                    Messung.setDefaultColor(KafPlotProperties.mrhColor.getColor(n));
                    break;
                }
                default: {
                    Messung.setDefaultColor(null);
                }
            }
            if (riss.isVisible() && riss.isViewable(iGraphics.getViewport())) {
                riss.drawForeground(iGraphics, bl, false);
            }
            if (KafPlotProperties.isBemerkungVisible()) {
                Enumeration enumeration2 = riss.elements();
                while (enumeration2.hasMoreElements()) {
                    try {
                        Messung messung = (Messung)enumeration2.nextElement();
                        if (!messung.hasText() || !messung.isVisible() || !messung.isViewable(iGraphics.getViewport())) continue;
                        this.addBeschriftung(messung);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
            ++n;
        }
    }

    private void drawMessungenTX(IGraphics iGraphics, Vector vector, boolean bl) {
        boolean bl2 = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            switch (KafPlotProperties.getColorMessSwitch()) {
                case 2003: {
                    Messung.setDefaultColor(KafPlotProperties.mnmColor.getColor(riss.getId()));
                    break;
                }
                case 2002: {
                    Messung.setDefaultColor(KafPlotProperties.mrhColor.getColor((double)bl2));
                    break;
                }
                default: {
                    Messung.setDefaultColor(null);
                }
            }
            if (!riss.isVisible() || !riss.isViewable(iGraphics.getViewport())) continue;
            riss.drawInscription(iGraphics, bl, false);
        }
    }

    private void drawMessungenTN(IGraphics iGraphics, Vector vector, boolean bl) {
        boolean bl2 = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            switch (KafPlotProperties.getColorMessSwitch()) {
                case 2003: {
                    Messung.setDefaultColor(KafPlotProperties.mnmColor.getColor(riss.getId()));
                    break;
                }
                case 2002: {
                    Messung.setDefaultColor(KafPlotProperties.mrhColor.getColor((double)bl2));
                    break;
                }
                default: {
                    Messung.setDefaultColor(null);
                }
            }
            if (!riss.isVisible() || !riss.isViewable(iGraphics.getViewport())) continue;
            riss.drawPartInscription(iGraphics, bl, false);
        }
    }

    private void drawHoehen(IGraphics iGraphics, Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            if (riss.isVisible() && riss.isViewable(iGraphics.getViewport())) {
                riss.drawObject(iGraphics, bl, false);
            }
            if (!KafPlotProperties.isBemerkungVisible()) continue;
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                try {
                    Hoehe hoehe = (Hoehe)enumeration2.nextElement();
                    if (!hoehe.hasText() || !hoehe.isVisible() || !hoehe.isViewable(iGraphics.getViewport())) continue;
                    this.addBeschriftung(hoehe);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    private void drawLinieLength(IGraphics iGraphics, Vector vector) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            GObject gObject = (GObject)vector.elementAt(i);
            if (!gObject.isVisible() || !gObject.isViewable(iGraphics.getViewport())) continue;
            this.drawLinieLength(iGraphics, gObject, false);
        }
    }

    private void printLinieLength(IGraphics iGraphics, Vector vector) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            GObject gObject = (GObject)vector.elementAt(i);
            if (!gObject.isVisible() || !gObject.isViewable(iGraphics.getViewport())) continue;
            this.drawLinieLength(iGraphics, gObject, true);
        }
    }

    private void drawLinieLength(IGraphics iGraphics, GObject gObject, boolean bl) {
        Enumeration enumeration;
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        Enumeration enumeration2 = enumeration = KafPlotProperties.isFlaecheLengthNachwVisible ? gObject.getKatasterNachweisLinien().elements() : gObject.elements();
        while (enumeration.hasMoreElements()) {
            double d;
            Linie linie = (Linie)enumeration.nextElement();
            if (linie.pe == null) continue;
            DPoint dPoint = linie.getHashPoint();
            GraphicClip.mass.y = dPoint.y;
            GraphicClip.mass.x = dPoint.x;
            if (!iGraphics.contains(mass)) continue;
            for (d = linie.getRichtung() + iGraphics.getRotation(); d <= 0.0; d += Math.PI) {
            }
            while (d > Math.PI) {
                d -= Math.PI;
            }
            mass.setTextWinkel(d);
            graphics.setColor(Ebene.getColor(linie.getEb()));
            int n = 42011140;
            if (KafPlotProperties.isFlaechePatternVisible) {
                n = n | 0x10 | 0x40000;
            }
            if (linie.isBogen()) {
                TextSymbol.paint(graphics, "R=" + IFormat.f_2k.format(Math.abs(linie.getRadius())), iGraphics.getGraphicPoint(mass, point), ta, 1, n, d, 1.0);
                TextSymbol.paint(graphics, "L=" + IFormat.f_2k.format(Math.abs(linie.getBogenLaenge())), iGraphics.getGraphicPoint(mass, point), ta, 7, n, d, 1.0);
                continue;
            }
            TextSymbol.paint(graphics, IFormat.f_2k.format(DataBase.getStrecke(linie)), iGraphics.getGraphicPoint(mass, point), ta, 1, n, d, 1.0);
        }
    }

    private void drawTrafoSysteme(IGraphics iGraphics) {
        Graphics graphics = iGraphics.getGraphics();
        Point point = new Point();
        Point point2 = new Point();
        DPoint dPoint = new DPoint();
        boolean bl = KafPlotProperties.getFehlerSwitch() == 711;
        boolean bl2 = KafPlotProperties.getFehlerSwitch() == 712;
        int n = 0;
        int n2 = KafPlotProperties.getColorMessSwitch();
        Enumeration enumeration = DataBase.T.elements();
        while (enumeration.hasMoreElements()) {
            TrafoSystem trafoSystem = (TrafoSystem)enumeration.nextElement();
            if (!trafoSystem.isVisible() || !trafoSystem.isViewable(iGraphics.getViewport())) continue;
            Color color = null;
            color = n2 == 2003 ? KafPlotProperties.mnmColor.getColor(trafoSystem.getId()) : (n2 == 2002 ? KafPlotProperties.mrhColor.getColor(n) : KafPlotProperties.mmaColor.getColor(new Integer(40)));
            float f = Float.MAX_VALUE;
            Enumeration enumeration2 = trafoSystem.elements();
            while (enumeration2.hasMoreElements()) {
                TrafoPunkt trafoPunkt = (TrafoPunkt)enumeration2.nextElement();
                Punkt punkt = trafoPunkt.getPunkt();
                if (f == Float.MAX_VALUE && trafoPunkt.hasGewichte()) {
                    f = trafoPunkt.getGewichte().getG1();
                }
                if (!iGraphics.contains(punkt) || !punkt.isVisible() || !this.drawRect.contains(point = iGraphics.getGraphicPoint(punkt, point))) continue;
                if (n2 == 2001) {
                    color = trafoPunkt.isOn() ? (color = KafPlotProperties.mmaColor.getColor(new Integer(40))) : KafPlotColor.OFFLINE_FG;
                } else if (n2 == 2004 && trafoPunkt.hasGewichte()) {
                    color = KafPlotProperties.mgwColor.getColor(f / trafoPunkt.getGewichte().getG1());
                } else if (n2 > 2004 && trafoPunkt.hasStatistik()) {
                    color = !trafoPunkt.isOn() ? KafPlotColor.OFFLINE_FG : KafPlotColor.getStatColor(n2, trafoPunkt.getStatistik());
                }
                if (KafPlotProperties.isPunktVisible(iGraphics.getScale())) {
                    Punkt.setForeground(color);
                    if (n2 == 2001 && (punkt.isDigitPP() && trafoSystem.getStatus() == 9 || punkt.isTrafoPP() && trafoSystem.getStatus() == 8)) {
                        Punkt.setBackground(IColor.getLighter(color, 0.2f));
                        punkt.fillTrafoSymbol(iGraphics, point, KafPlotProperties.isPunktArtVisible);
                    }
                    punkt.drawTrafoSymbol(iGraphics, point, KafPlotProperties.isPunktArtVisible);
                }
                if (KafPlotProperties.isEllipseVisible && !KafPlotProperties.isEllipseAreaVisible) {
                    graphics.setColor(color);
                    if (bl) {
                        this.drawDyDx(iGraphics, punkt, trafoPunkt.getVy(), trafoPunkt.getVx());
                    } else if (bl2) {
                        this.drawDyDx(iGraphics, punkt, trafoPunkt.getRy(), trafoPunkt.getRx());
                    }
                }
                if (!KafPlotProperties.isBemerkungVisible() || !trafoPunkt.hasBemerkung()) continue;
                this.addBeschriftung(trafoPunkt);
            }
            ++n;
        }
    }

    private void drawBedingungen(IGraphics iGraphics, Vector vector) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            switch (KafPlotProperties.getColorMessSwitch()) {
                case 2003: {
                    Bedingung.setDefaultColor(KafPlotProperties.mnmColor.getColor(riss.getId()));
                    break;
                }
                case 2002: {
                    Bedingung.setDefaultColor(KafPlotProperties.mrhColor.getColor(n));
                    break;
                }
                default: {
                    Bedingung.setDefaultColor(null);
                }
            }
            if (riss.isVisible()) {
                Enumeration enumeration2 = riss.elements();
                while (enumeration2.hasMoreElements()) {
                    ((Bedingung)enumeration2.nextElement()).drawObject(iGraphics, true, false);
                }
            }
            ++n;
        }
    }

    private void drawBeschriftung(IGraphics iGraphics) {
        Drawable drawable;
        Enumeration enumeration;
        if (KafPlotProperties.isBemerkungTextVisible()) {
            DataBase.BEM.checkLayout();
            enumeration = DataBase.BEM.elements();
            while (enumeration.hasMoreElements()) {
                this.BESCHRIFTUNG.addElement(enumeration.nextElement());
            }
        }
        if (KafPlotProperties.isBemerkungErrorVisible() || KafPlotProperties.isBemerkungDbVisible()) {
            DataBase.ERR.checkLayout();
            enumeration = DataBase.ERR.elements();
            while (enumeration.hasMoreElements()) {
                drawable = (ErrorObject)enumeration.nextElement();
                if (!((ErrorObject)drawable).isVisible()) continue;
                boolean bl = false;
                switch (((ErrorObject)drawable).getType()) {
                    case 12: {
                        bl = KafPlotProperties.isBemerkungDbInsertVisible();
                        break;
                    }
                    case 10: {
                        bl = KafPlotProperties.isBemerkungDbConfirmVisible();
                        break;
                    }
                    case 11: {
                        bl = KafPlotProperties.isBemerkungDbReplaceVisible();
                        break;
                    }
                    case 13: {
                        bl = KafPlotProperties.isBemerkungDbDeleteVisible();
                        break;
                    }
                    case 20: {
                        bl = KafPlotProperties.isBemerkungDbObjectVisible();
                        break;
                    }
                    default: {
                        bl = KafPlotProperties.isBemerkungErrorVisible();
                    }
                }
                if (!bl) continue;
                this.BESCHRIFTUNG.addElement(drawable);
            }
        }
        enumeration = this.BESCHRIFTUNG.elements();
        while (enumeration.hasMoreElements()) {
            drawable = (Drawable)enumeration.nextElement();
            drawable.drawObject(iGraphics, true, false);
        }
    }

    private void drawIdentitaeten(IGraphics iGraphics) {
        Enumeration enumeration = DataBase.P_IDENT.elements();
        while (enumeration.hasMoreElements()) {
            PunktIdentitaet punktIdentitaet = (PunktIdentitaet)enumeration.nextElement();
            punktIdentitaet.drawSymbol(iGraphics, true);
            this.addBeschriftung(punktIdentitaet);
        }
    }

    private void drawPunktTables(IGraphics iGraphics, PunktTable punktTable) {
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            ((Drawable)enumeration.nextElement()).drawObject(iGraphics, true, false);
        }
    }

    public void drawMenge(IGraphics iGraphics, PunktTable punktTable) {
        Point point = new Point();
        Graphics graphics = iGraphics.getGraphics();
        graphics.setColor(Color.white);
        graphics.setXORMode(new Color(255, 200, 50));
        Enumeration enumeration = punktTable.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt = (Punkt)enumeration.nextElement();
            if (!iGraphics.contains(punkt)) continue;
            punkt.drawSymbol(iGraphics, iGraphics.getGraphicPoint(punkt, point), KafPlotProperties.isPunktArtVisible(), true);
        }
        graphics.setPaintMode();
    }

    private void drawPlotbox(IGraphics iGraphics) {
        if (DataBase.PLOTBOX != null) {
            DataBase.PLOTBOX.drawSymbol(iGraphics, false);
        }
    }

    private void drawVersionMsg(IGraphics iGraphics) {
        if (KafPlotVersion.isTestVersion()) {
            if (DataBase.IMG.size() > 0) {
                Graphics graphics = iGraphics.getGraphics();
                Font font = new Font("SansSerif", 1, 36);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                String string = "TestVersion";
                int n = (int)((double)(fontMetrics.stringWidth(string) + 5) * 1.5);
                graphics.setColor(Color.lightGray);
                graphics.setFont(font);
                for (int i = 0; i < this.getSize().height + 120; i += 120) {
                    for (int j = 5; j < this.getSize().width; j += n) {
                        graphics.drawString(string, j, i);
                    }
                }
            }
        }
    }

    private void drawPunktNummer(Graphics graphics, int n, int n2, Punkt punkt) {
        boolean bl;
        boolean bl2 = bl = KafPlotProperties.getColorSwitch() == 1004 ? punkt.isFortfuehrung() : punkt.isOn();
        if (punkt.isMasterPoint()) {
            n2 -= pnrFont.getSize() / 2;
        } else if (punkt.isSlavePoint()) {
            n2 += pnrFont.getSize() / 2;
        }
        boolean bl3 = KafPlotProperties.isPunktNummerVisible();
        boolean bl4 = KafPlotProperties.isPunktHoeheVisible() && punkt.h != 0.0f;
        boolean bl5 = KafPlotProperties.isEllipseTextVisible;
        if (bl4) {
            graphics.setFont(phFont);
            graphics.setColor(bl ? KafPlotColor.HOEHE : KafPlotColor.OFFLINE_FG);
            graphics.drawString(phFormat.format(punkt.h), n, n2 + (bl3 ? phFont.getSize() : phFont.getSize() / 2));
        }
        if (bl3) {
            graphics.setFont(pnrFont);
            graphics.setColor(bl ? KafPlotColor.PNR_LOKAL : KafPlotColor.OFFLINE_FG);
            long l = 0L;
            switch (KafPlotProperties.getNummerSwitch()) {
                case 101: {
                    l = punkt.nr;
                    break;
                }
                case 102: {
                    if (punkt.getUmnum() <= 0L) {
                        l = punkt.nr;
                        break;
                    }
                    l = punkt.getUmnum();
                    graphics.setColor(bl ? KafPlotColor.PNR_UMNUM : KafPlotColor.OFFLINE_FG);
                    break;
                }
                case 103: {
                    if (punkt.getUmnum() <= 0L) {
                        l = punkt.nr;
                        break;
                    }
                    graphics.drawString(pnrFormat.format(punkt.nr).toString(), n, bl4 ? n2 - pnrFont.getSize() : n2);
                    graphics.setColor(bl ? KafPlotColor.PNR_UMNUM : KafPlotColor.OFFLINE_FG);
                    graphics.drawString(pnrFormat.format(punkt.getUmnum()).toString(), n, n2 + (bl4 ? 0 : pnrFont.getSize()));
                    break;
                }
                case 111: {
                    if (punkt.getUmnum() > 0L) break;
                    l = punkt.nr;
                    break;
                }
                case 112: {
                    if (punkt.getUmnum() >= 0L) {
                        l = punkt.getUmnum();
                    }
                    graphics.setColor(bl ? KafPlotColor.PNR_UMNUM : KafPlotColor.OFFLINE_FG);
                }
            }
            if (l > 0L) {
                Serializable serializable;
                Object object = pnrFormat.format(l);
                if (punkt.isMasterPoint() || punkt.isSlavePoint()) {
                    object = punkt.getParameter().getOutPa() + (String)object;
                }
                if (KafPlotProperties.isPunktTextBgVisible) {
                    serializable = graphics.getColor();
                    FontMetrics fontMetrics = graphics.getFontMetrics(pnrFont);
                    int n3 = fontMetrics.stringWidth((String)object);
                    graphics.setColor(KafPlotColor.BACKGROUND);
                    graphics.fillRoundRect(n - 2, (bl4 ? n2 : n2 + pnrFont.getSize() / 2) - fontMetrics.getAscent() + 2, n3 + 4, fontMetrics.getAscent(), 5, 5);
                    graphics.setColor((Color)serializable);
                }
                graphics.drawString((String)object, n, bl4 ? n2 : n2 + pnrFont.getSize() / 2);
                if (punkt.getPst() == 13) {
                    serializable = graphics.getFontMetrics(pnrFont);
                    int n4 = ((FontMetrics)serializable).stringWidth((String)object);
                    graphics.setColor(Color.red);
                    graphics.drawLine(n - 1, n2, n + n4 + 1, n2);
                }
            }
        }
        if (bl5) {
            String string = null;
            int n5 = KafPlotProperties.getFehlerSwitch();
            if (n5 == 701) {
                if (punkt.a > 0 || punkt.b > 0) {
                    string = IFormat.f_3.format(punkt.getSP());
                }
            } else if (n5 == 702) {
                if (punkt.dy != 0.0f || punkt.dx != 0.0f) {
                    string = IFormat.f_3.format(punkt.getDS());
                }
            } else if (n5 == 703) {
                if (punkt.zl > 0.0f) {
                    string = IFormat.f_3.format(punkt.zl);
                }
            } else if (n5 == 704) {
                if (punkt.ag > 0.0f) {
                    string = IFormat.f_3.format(punkt.ag);
                }
            } else if (n5 == 705) {
                if (punkt.az > 0.0f) {
                    string = IFormat.f_3.format(punkt.az);
                }
            } else if (n5 == 706 && punkt.dh != 0.0f) {
                string = IFormat.f_3.format(punkt.dh);
            }
            if (string != null) {
                int n6;
                graphics.setColor(Color.red);
                graphics.setFont(peFont);
                int n7 = n6 = bl4 ? n2 : n2 + pnrFont.getSize() / 2;
                if (bl3) {
                    n6 += pnrFont.getSize();
                    if (KafPlotProperties.getNummerSwitch() == 103 && punkt.getUmnum() > 0L) {
                        n6 += pnrFont.getSize();
                    }
                }
                graphics.drawString(string, n, n6);
            }
        }
    }

    private void drawVermarkung(Graphics graphics, int n, int n2, FontMetrics fontMetrics, Punkt punkt) {
        boolean bl = KafPlotProperties.getColorSwitch() == 1004 ? punkt.isFortfuehrung() : punkt.isOn();
        PunktParameter punktParameter = punkt.getParameter();
        String string = VermarkungsArt.getVermarkungsArt(punktParameter.getVa()).getKuerzel();
        VermarkungsArt vermarkungsArt = VermarkungsArt.getVermarkungsArt(punktParameter.getVva());
        String string2 = !vermarkungsArt.isUnvermarkt() ? vermarkungsArt.getKuerzel() : null;
        int n3 = punktParameter.getKafVva();
        if (n3 == 19) {
            string = vermarkungsArt.getKuerzel();
            string2 = null;
        } else if (n3 == 99) {
            string2 = string;
            string = vermarkungsArt.getKuerzel();
        }
        n -= 5;
        if (string != null) {
            if (bl) {
                graphics.setColor(punkt.isNeuVermarkt() ? KafPlotColor.GP_NEU : KafPlotColor.GP_VORHANDEN);
            } else {
                graphics.setColor(KafPlotColor.OFFLINE_FG);
            }
            if (punktParameter.getKafVvt() == 0 || string2 != null) {
                this.drawTextBruch(graphics, string, null, n, n2, string2 == null ? 5 : 2, fontMetrics);
            } else {
                this.drawTextBruch(graphics, punktParameter.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string, punktParameter.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string, n, n2, string2 == null ? 5 : 2, fontMetrics);
            }
        }
        if (string2 != null) {
            if (bl) {
                graphics.setColor(KafPlotColor.GP_VORHANDEN);
            } else {
                graphics.setColor(KafPlotColor.OFFLINE_FG);
            }
            this.drawTextBruch(graphics, "aufgef.", null, n, n2, string == null ? 5 : 8, fontMetrics);
            if (punktParameter.getKafVvt() == 0) {
                this.drawTextBruch(graphics, string2, null, n - fontMetrics.stringWidth("aufgef.") - 5, n2, string == null ? 5 : 8, fontMetrics);
            } else {
                this.drawTextBruch(graphics, punktParameter.getKafVvt() > 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string2, punktParameter.getKafVvt() < 0 ? GeoNumberFormat.m01.format((double)Math.abs(punktParameter.getKafVvt()) / 10.0).toString() : string2, n - fontMetrics.stringWidth("aufgef.") - 5, n2, string == null ? 5 : 8, fontMetrics);
            }
        }
    }

    private void drawTextBruch(Graphics graphics, String string, String string2, int n, int n2, int n3, FontMetrics fontMetrics) {
        int n4 = fontMetrics.stringWidth(string) / 2;
        int n5 = string2 == null ? 0 : fontMetrics.stringWidth(string2) / 2;
        int n6 = Math.max(n4, n5);
        int n7 = (string2 == null ? fontMetrics.getAscent() : 2 * fontMetrics.getAscent() + fontMetrics.getDescent() + 2) / 2;
        switch (n3) {
            case 0: {
                n += n6;
                n2 -= n7;
                break;
            }
            case 1: {
                n2 -= n7;
                break;
            }
            case 2: {
                n -= n6;
                n2 -= n7;
                break;
            }
            case 3: {
                n += n6;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                n -= n6;
                break;
            }
            case 6: {
                n += n6;
                n2 += n7;
                break;
            }
            case 7: {
                n2 += n7;
                break;
            }
            case 8: {
                n -= n6;
                n2 += n7;
            }
        }
        if (string2 == null) {
            graphics.drawString(string, n - n4, n2 + fontMetrics.getAscent() / 2);
        } else {
            graphics.drawString(string, n - n4, n2 - 1 - fontMetrics.getDescent());
            graphics.drawLine(n - n6, n2, n + n6, n2);
            graphics.drawString(string2, n - n5, n2 + 1 + fontMetrics.getAscent());
        }
    }

    private void drawEllipse(IGraphics iGraphics, Punkt punkt, double d, double d2, double d3) {
        double d4 = KafPlotProperties.isEllipseStaticVisible ? KafPlotProperties.getEllipseZoomStatic() : this.me;
        double d5 = (100.0 + d3) * Math.PI / 200.0 + iGraphics.getRotation();
        double d6 = Math.cos(d5) * d4;
        double d7 = Math.sin(d5) * d4;
        double d8 = punkt.y - d * d6;
        double d9 = punkt.x + d * d7;
        for (double d10 = 0.1; d10 < 6.4; d10 += 0.16) {
            double d11 = d * Math.cos(d10);
            double d12 = d2 * Math.sin(d10);
            double d13 = punkt.y - (d11 * d6 - d12 * d7);
            double d14 = punkt.x + (d11 * d7 + d12 * d6);
            iGraphics.drawLine(d8, d9, d13, d14);
            d9 = d14;
            d8 = d13;
        }
    }

    private void drawDyDx(IGraphics iGraphics, Punkt punkt, float f, float f2) {
        double d = KafPlotProperties.isEllipseStaticVisible ? KafPlotProperties.getEllipseZoomStatic() : this.me;
        iGraphics.drawLine(punkt.y, punkt.x, punkt.y + d * (double)f, punkt.x + d * (double)f2);
    }

    public void drawDPolygon(Graphics graphics, DPolygon dPolygon) {
        Point point = new Point();
        Point point2 = null;
        for (int i = 0; i < dPolygon.npoints; ++i) {
            point = this.iGraphics.getGraphicPoint(new DPoint(dPolygon.ypoints[i], dPolygon.xpoints[i]), point);
            if (point2 != null) {
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
            }
            point2 = new Point(point.x, point.y);
        }
    }

    private void addBeschriftung(Object object) {
        if (!KafPlotProperties.isBemerkungVisible()) {
            return;
        }
        if (object instanceof Punkt) {
            if (!KafPlotProperties.isBemerkungPunktVisible()) {
                return;
            }
            Punkt punkt = (Punkt)object;
            this.BESCHRIFTUNG.addElement(new Bemerkung(punkt, null, punkt.getBemerkungText()));
        } else if (object instanceof Messung) {
            if (!KafPlotProperties.isBemerkungMessungVisible()) {
                return;
            }
            Messung messung = (Messung)object;
            Bemerkung bemerkung = new Bemerkung(messung.ps, messung.pz, messung.getText());
            if (messung.isFehler()) {
                bemerkung.setPosition(ILocation.reverse(bemerkung.getPosition()));
            }
            this.BESCHRIFTUNG.addElement(bemerkung);
        } else if (object instanceof TrafoPunkt) {
            if (!KafPlotProperties.isBemerkungMessungVisible()) {
                return;
            }
            TrafoPunkt trafoPunkt = (TrafoPunkt)object;
            Bemerkung bemerkung = new Bemerkung(trafoPunkt.getPunkt(), null, trafoPunkt.getBemerkungText());
            this.BESCHRIFTUNG.addElement(bemerkung);
        } else if (object instanceof Hoehe) {
            if (!KafPlotProperties.isBemerkungMessungVisible()) {
                return;
            }
            Hoehe hoehe = (Hoehe)object;
            Bemerkung bemerkung = new Bemerkung(hoehe.getPs(), hoehe.getPz(), hoehe.getText());
            this.BESCHRIFTUNG.addElement(bemerkung);
        } else if (object instanceof PunktIdentitaet) {
            Bemerkung bemerkung;
            if (!KafPlotProperties.isBemerkungPunktVisible()) {
                return;
            }
            PunktIdentitaet punktIdentitaet = (PunktIdentitaet)object;
            if (punktIdentitaet.bemIst != null) {
                bemerkung = new Bemerkung(punktIdentitaet.ist, null, punktIdentitaet.bemIst);
                bemerkung.setPosition(ILocation.getLocation(punktIdentitaet.ist.y < punktIdentitaet.soll.y ? 10 : -10, punktIdentitaet.ist.x < punktIdentitaet.soll.x ? -1 : 1));
                this.BESCHRIFTUNG.addElement(bemerkung);
            }
            if (punktIdentitaet.bemSoll != null) {
                bemerkung = new Bemerkung(punktIdentitaet.soll, null, punktIdentitaet.bemSoll);
                bemerkung.setPosition(ILocation.getLocation(punktIdentitaet.soll.y < punktIdentitaet.ist.y ? 10 : -10, punktIdentitaet.soll.x < punktIdentitaet.ist.x ? -1 : 1));
                this.BESCHRIFTUNG.addElement(bemerkung);
            }
        }
    }

    static {
        MIN_TEXTBEZUG_DISTANCE = 8;
        MIN_TEXTDIST = 5;
        MAX_TEXTDIST = 60;
        TEXT_OVERWRITE = new Color(255, 255, 255);
        mass = new Text(1, 50);
        ta = TextArt.create(1);
        sym = new TextSymbol(ta);
    }

    class TimeList
    extends IntegerHashList {
        TimeList(GraphicClip graphicClip) {
            this.put(new TimeDebugEntry(graphicClip, 1110, "DRAW_BG_FLST         "));
            this.put(new TimeDebugEntry(graphicClip, 1210, "DRAW_BG_GEB          "));
            this.put(new TimeDebugEntry(graphicClip, 1211, "DRAW_BG_GEB_SD       "));
            this.put(new TimeDebugEntry(graphicClip, 1310, "DRAW_BG_NUTZ         "));
            this.put(new TimeDebugEntry(graphicClip, 1410, "DRAW_BG_BODEN        "));
            this.put(new TimeDebugEntry(graphicClip, 1510, "DRAW_BG_TOP          "));
            this.put(new TimeDebugEntry(graphicClip, 1120, "DRAW_FG_FLST         "));
            this.put(new TimeDebugEntry(graphicClip, 1220, "DRAW_FG_GEB          "));
            this.put(new TimeDebugEntry(graphicClip, 1320, "DRAW_FG_NUTZ         "));
            this.put(new TimeDebugEntry(graphicClip, 1420, "DRAW_FG_BODEN        "));
            this.put(new TimeDebugEntry(graphicClip, 1520, "DRAW_FG_TOP          "));
            this.put(new TimeDebugEntry(graphicClip, 1130, "DRAW_TX_FLST         "));
            this.put(new TimeDebugEntry(graphicClip, 1230, "DRAW_TX_GEB          "));
            this.put(new TimeDebugEntry(graphicClip, 1330, "DRAW_TX_NUTZ         "));
            this.put(new TimeDebugEntry(graphicClip, 1430, "DRAW_TX_BODEN        "));
            this.put(new TimeDebugEntry(graphicClip, 1530, "DRAW_TX_TOP          "));
            this.put(new TimeDebugEntry(graphicClip, 1140, "DRAW_TL_FLST         "));
            this.put(new TimeDebugEntry(graphicClip, 1240, "DRAW_TL_GEB          "));
            this.put(new TimeDebugEntry(graphicClip, 1540, "DRAW_TL_TOP          "));
            this.put(new TimeDebugEntry(graphicClip, 2111, "DRAW_BG_RISS_POLAR   "));
            this.put(new TimeDebugEntry(graphicClip, 2121, "DRAW_BG_RISS_GPS     "));
            this.put(new TimeDebugEntry(graphicClip, 2211, "DRAW_BG_RISS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 2221, "DRAW_BG_RISS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 2231, "DRAW_BG_RISS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 2241, "DRAW_BG_RISS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 2311, "DRAW_BG_RISS_ZENIT   "));
            this.put(new TimeDebugEntry(graphicClip, 2321, "DRAW_BG_RISS_NIV     "));
            this.put(new TimeDebugEntry(graphicClip, 2411, "DRAW_BG_RISS_HOMOGEN "));
            this.put(new TimeDebugEntry(graphicClip, 2421, "DRAW_BG_RISS_BEDING  "));
            this.put(new TimeDebugEntry(graphicClip, 2511, "DRAW_BG_RISS_TRAFO   "));
            this.put(new TimeDebugEntry(graphicClip, 2112, "DRAW_FG_RISS_POLAR   "));
            this.put(new TimeDebugEntry(graphicClip, 2122, "DRAW_FG_RISS_GPS     "));
            this.put(new TimeDebugEntry(graphicClip, 2212, "DRAW_FG_RISS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 2222, "DRAW_FG_RISS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 2232, "DRAW_FG_RISS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 2242, "DRAW_FG_RISS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 2312, "DRAW_FG_RISS_ZENIT   "));
            this.put(new TimeDebugEntry(graphicClip, 2322, "DRAW_FG_RISS_NIV     "));
            this.put(new TimeDebugEntry(graphicClip, 2412, "DRAW_FG_RISS_HOMOGEN "));
            this.put(new TimeDebugEntry(graphicClip, 2422, "DRAW_FG_RISS_BEDING  "));
            this.put(new TimeDebugEntry(graphicClip, 2512, "DRAW_FG_RISS_TRAFO   "));
            this.put(new TimeDebugEntry(graphicClip, 2113, "DRAW_TX_RISS_POLAR   "));
            this.put(new TimeDebugEntry(graphicClip, 2123, "DRAW_TX_RISS_GPS     "));
            this.put(new TimeDebugEntry(graphicClip, 2213, "DRAW_TX_RISS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 2223, "DRAW_TX_RISS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 2233, "DRAW_TX_RISS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 2243, "DRAW_TX_RISS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 2313, "DRAW_TX_RISS_ZENIT   "));
            this.put(new TimeDebugEntry(graphicClip, 2323, "DRAW_TX_RISS_NIV     "));
            this.put(new TimeDebugEntry(graphicClip, 2413, "DRAW_TX_RISS_HOMOGEN "));
            this.put(new TimeDebugEntry(graphicClip, 2423, "DRAW_TX_RISS_BEDING  "));
            this.put(new TimeDebugEntry(graphicClip, 2513, "DRAW_TX_RISS_TRAFO   "));
            this.put(new TimeDebugEntry(graphicClip, 3112, "DRAW_FG_MESS_POLAR   "));
            this.put(new TimeDebugEntry(graphicClip, 3122, "DRAW_FG_MESS_GPS     "));
            this.put(new TimeDebugEntry(graphicClip, 3212, "DRAW_FG_MESS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 3222, "DRAW_FG_MESS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 3232, "DRAW_FG_MESS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 3242, "DRAW_FG_MESS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 3312, "DRAW_FG_MESS_ZENIT   "));
            this.put(new TimeDebugEntry(graphicClip, 3322, "DRAW_FG_MESS_NIV     "));
            this.put(new TimeDebugEntry(graphicClip, 3412, "DRAW_FG_MESS_HOMOGEN "));
            this.put(new TimeDebugEntry(graphicClip, 3422, "DRAW_FG_MESS_BEDING  "));
            this.put(new TimeDebugEntry(graphicClip, 3432, "DRAW_FG_MESS_MOVE    "));
            this.put(new TimeDebugEntry(graphicClip, 3442, "DRAW_FG_MESS_IDENT   "));
            this.put(new TimeDebugEntry(graphicClip, 3512, "DRAW_FG_MESS_TRAFO   "));
            this.put(new TimeDebugEntry(graphicClip, 3213, "DRAW_TX_MESS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 3223, "DRAW_TX_MESS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 3233, "DRAW_TX_MESS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 3243, "DRAW_TX_MESS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 3413, "DRAW_TX_MESS_HOMOGEN "));
            this.put(new TimeDebugEntry(graphicClip, 3423, "DRAW_TX_MESS_BEDING  "));
            this.put(new TimeDebugEntry(graphicClip, 3214, "DRAW_TN_MESS_EIGENE  "));
            this.put(new TimeDebugEntry(graphicClip, 3224, "DRAW_TN_MESS_NACHWEIS"));
            this.put(new TimeDebugEntry(graphicClip, 3234, "DRAW_TN_MESS_EINRECH "));
            this.put(new TimeDebugEntry(graphicClip, 3244, "DRAW_TN_MESS_VORGABE "));
            this.put(new TimeDebugEntry(graphicClip, 5110, "DRAW_FG_PUNKT        "));
            this.put(new TimeDebugEntry(graphicClip, 5112, "DRAW_FG_PUNKT_ERR    "));
            this.put(new TimeDebugEntry(graphicClip, 5120, "DRAW_TX_PUNKT        "));
            this.put(new TimeDebugEntry(graphicClip, 5121, "DRAW_TX_PUNKT_VAT    "));
            this.put(new TimeDebugEntry(graphicClip, 5122, "DRAW_TX_PUNKT_ERR    "));
            this.put(new TimeDebugEntry(graphicClip, 8010, "DRAW_BG_IMAGE        "));
            this.put(new TimeDebugEntry(graphicClip, 8020, "DRAW_FG_IMAGE        "));
            this.put(new TimeDebugEntry(graphicClip, 8030, "DRAW_TX_IMAGE        "));
            this.put(new TimeDebugEntry(graphicClip, 8040, "DRAW_PP_IMAGE        "));
            this.put(new TimeDebugEntry(graphicClip, 8110, "DRAW_GITTER          "));
            this.put(new TimeDebugEntry(graphicClip, 8120, "DRAW_IDENT           "));
            this.put(new TimeDebugEntry(graphicClip, 8130, "DRAW_MENGE           "));
            this.put(new TimeDebugEntry(graphicClip, 8140, "DRAW_TEXTFIELD       "));
            this.put(new TimeDebugEntry(graphicClip, 8160, "DRAW_VERSION_MSG     "));
            this.put(new TimeDebugEntry(graphicClip, 9901, "HINT_NONE_NONE       "));
            this.put(new TimeDebugEntry(graphicClip, 9902, "HINT_LINE_NONE       "));
            this.put(new TimeDebugEntry(graphicClip, 9903, "HINT_NONE_TEXT       "));
            this.put(new TimeDebugEntry(graphicClip, 9904, "HINT_LINE_TEXT       "));
        }

        public void put(int n, int n2, int n3) {
            TimeDebugEntry timeDebugEntry = (TimeDebugEntry)this.get(n);
            if (timeDebugEntry != null) {
                timeDebugEntry.compTime += (long)n2;
                timeDebugEntry.usedTime += (long)n3;
                ++timeDebugEntry.count;
            }
        }
    }

    class TimeRegister {
        static final int COUNT = 20;
        int[][] timeRegister = new int[20][2];
        int c = 0;

        TimeRegister(GraphicClip graphicClip) {
        }

        public void register(int n, int n2) {
            this.timeRegister[this.c][0] = n;
            this.timeRegister[this.c][1] = n2;
            ++this.c;
            if (this.c == 20) {
                this.c = 0;
            }
        }

        public double getCoefficient() {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < 20; ++i) {
                if (this.timeRegister[i][0] <= 0) continue;
                d += (double)this.timeRegister[i][0];
                d2 += (double)this.timeRegister[i][1];
            }
            return d > 0.0 ? d2 / d : 1.0;
        }
    }

    class DrawOrder {
        int order;
        int time;
        int runTime;

        public DrawOrder(GraphicClip graphicClip, int n, int n2) {
            this.order = n;
            this.time = n2;
            this.runTime = 0;
        }
    }

    class Draw
    extends Thread {
        BufferedImage buffer;
        IGraphics g2;
        Graphics2D g;
        DrawOrder[] drawList;
        int id;
        int a;
        int e;

        public Draw(int n, DrawOrder[] drawOrderArray, int n2, int n3) {
            this.id = n;
            this.g2 = this.g2;
            this.drawList = drawOrderArray;
            this.a = n2;
            this.e = n3;
            this.setPriority(10);
            this.start();
        }

        @Override
        public void run() {
            int n;
            int n2;
            long l = 0L;
            if (GraphicClip.this.debug) {
                l = System.nanoTime();
            }
            this.buffer = new BufferedImage(GraphicClip.this.getWidth(), GraphicClip.this.getHeight(), 2);
            try {
                this.g2 = (IGraphics)GraphicClip.this.iGraphics.clone();
            }
            catch (Exception exception) {
                this.g2 = GraphicClip.this.iGraphics;
            }
            this.g = this.buffer.createGraphics();
            this.g2.setGraphics(this.g);
            this.g2.setPaintMode();
            for (n2 = this.a; n2 >= 0; --n2) {
                n = this.drawList[n2].order;
                if (n < 9000) continue;
                if (n == 9901) {
                    GraphicClip.this.setHints(this.g2, false, false);
                    break;
                }
                if (n == 9902) {
                    GraphicClip.this.setHints(this.g2, true, false);
                    break;
                }
                if (n == 9903) {
                    GraphicClip.this.setHints(this.g2, false, true);
                    break;
                }
                if (n != 9904) break;
                GraphicClip.this.setHints(this.g2, true, true);
                break;
            }
            n2 = 0;
            for (n = this.a; n < this.e; ++n) {
                if (this.drawList[n] == null) continue;
                long l2 = System.nanoTime();
                n2 += this.drawList[n].time;
                switch (this.drawList[n].order) {
                    case 0: {
                        break;
                    }
                    case 8010: {
                        GraphicClip.this.drawImageBackground(this.g2);
                        break;
                    }
                    case 8020: {
                        GraphicClip.this.drawImageForeground(this.g2);
                        break;
                    }
                    case 8030: {
                        GraphicClip.this.drawImageInscription(this.g2);
                        break;
                    }
                    case 8040: {
                        GraphicClip.this.drawImageControls(this.g2);
                        break;
                    }
                    case 1110: {
                        DataBase cfr_ignored_0 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.FLST);
                        break;
                    }
                    case 1210: {
                        DataBase cfr_ignored_1 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.GEB);
                        break;
                    }
                    case 1211: {
                        DataBase cfr_ignored_2 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.GEB, 3);
                        break;
                    }
                    case 1310: {
                        DataBase cfr_ignored_3 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.NUTZ);
                        break;
                    }
                    case 1410: {
                        DataBase cfr_ignored_4 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.BODEN);
                        break;
                    }
                    case 1510: {
                        DataBase cfr_ignored_5 = GraphicClip.this.db;
                        GraphicClip.this.drawAreas(this.g2, DataBase.TOP);
                        break;
                    }
                    case 1120: {
                        DataBase cfr_ignored_6 = GraphicClip.this.db;
                        GraphicClip.this.drawPolyLines(this.g2, DataBase.FLST);
                        break;
                    }
                    case 1220: {
                        DataBase cfr_ignored_7 = GraphicClip.this.db;
                        GraphicClip.this.drawPolyLines(this.g2, DataBase.GEB);
                        break;
                    }
                    case 1320: {
                        DataBase cfr_ignored_8 = GraphicClip.this.db;
                        GraphicClip.this.drawPolyLines(this.g2, DataBase.NUTZ);
                        break;
                    }
                    case 1420: {
                        DataBase cfr_ignored_9 = GraphicClip.this.db;
                        GraphicClip.this.drawPolyLines(this.g2, DataBase.BODEN);
                        break;
                    }
                    case 1520: {
                        DataBase cfr_ignored_10 = GraphicClip.this.db;
                        GraphicClip.this.drawPolyLines(this.g2, DataBase.TOP);
                        break;
                    }
                    case 1130: {
                        DataBase cfr_ignored_11 = GraphicClip.this.db;
                        GraphicClip.this.inscriptObjects(this.g2, DataBase.FLST);
                        break;
                    }
                    case 1230: {
                        DataBase cfr_ignored_12 = GraphicClip.this.db;
                        GraphicClip.this.inscriptObjects(this.g2, DataBase.GEB);
                        break;
                    }
                    case 1330: {
                        DataBase cfr_ignored_13 = GraphicClip.this.db;
                        GraphicClip.this.inscriptObjects(this.g2, DataBase.NUTZ);
                        break;
                    }
                    case 1430: {
                        DataBase cfr_ignored_14 = GraphicClip.this.db;
                        GraphicClip.this.inscriptObjects(this.g2, DataBase.BODEN);
                        break;
                    }
                    case 1530: {
                        DataBase cfr_ignored_15 = GraphicClip.this.db;
                        GraphicClip.this.inscriptObjects(this.g2, DataBase.TOP);
                        break;
                    }
                    case 1140: {
                        DataBase cfr_ignored_16 = GraphicClip.this.db;
                        GraphicClip.this.drawLinieLength(this.g2, DataBase.FLST);
                        break;
                    }
                    case 1240: {
                        DataBase cfr_ignored_17 = GraphicClip.this.db;
                        GraphicClip.this.drawLinieLength(this.g2, DataBase.GEB);
                        break;
                    }
                    case 1540: {
                        DataBase cfr_ignored_18 = GraphicClip.this.db;
                        GraphicClip.this.drawLinieLength(this.g2, DataBase.TOP);
                        break;
                    }
                    case 2111: {
                        DataBase cfr_ignored_19 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.MP, false);
                        break;
                    }
                    case 2121: {
                        DataBase cfr_ignored_20 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.MG, false);
                        break;
                    }
                    case 2211: {
                        DataBase cfr_ignored_21 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.MM, false);
                        break;
                    }
                    case 2221: {
                        DataBase cfr_ignored_22 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.MK, false);
                        break;
                    }
                    case 2231: {
                        DataBase cfr_ignored_23 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.ME, false);
                        break;
                    }
                    case 2241: {
                        DataBase cfr_ignored_24 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.MV, false);
                        break;
                    }
                    case 2311: {
                        DataBase cfr_ignored_25 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.HP, false);
                        break;
                    }
                    case 2321: {
                        DataBase cfr_ignored_26 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.HN, false);
                        break;
                    }
                    case 2411: {
                        DataBase cfr_ignored_27 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.BH, false);
                        break;
                    }
                    case 2421: {
                        DataBase cfr_ignored_28 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.BB, false);
                        break;
                    }
                    case 2511: {
                        DataBase cfr_ignored_29 = GraphicClip.this.db;
                        GraphicClip.this.drawRissBackground(this.g2, DataBase.T, false);
                        break;
                    }
                    case 2112: {
                        DataBase cfr_ignored_30 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.MP, false);
                        break;
                    }
                    case 2122: {
                        DataBase cfr_ignored_31 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.MG, false);
                        break;
                    }
                    case 2212: {
                        DataBase cfr_ignored_32 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.MM, false);
                        break;
                    }
                    case 2222: {
                        DataBase cfr_ignored_33 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.MK, false);
                        break;
                    }
                    case 2232: {
                        DataBase cfr_ignored_34 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.ME, false);
                        break;
                    }
                    case 2242: {
                        DataBase cfr_ignored_35 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.MV, false);
                        break;
                    }
                    case 2312: {
                        DataBase cfr_ignored_36 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.HP, false);
                        break;
                    }
                    case 2322: {
                        DataBase cfr_ignored_37 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.HN, false);
                        break;
                    }
                    case 2412: {
                        DataBase cfr_ignored_38 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.BH, false);
                        break;
                    }
                    case 2422: {
                        DataBase cfr_ignored_39 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.BB, false);
                        break;
                    }
                    case 2512: {
                        DataBase cfr_ignored_40 = GraphicClip.this.db;
                        GraphicClip.this.drawRissForeground(this.g2, DataBase.T, false);
                        break;
                    }
                    case 2113: {
                        DataBase cfr_ignored_41 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.MP, false);
                        break;
                    }
                    case 2123: {
                        DataBase cfr_ignored_42 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.MG, false);
                        break;
                    }
                    case 2213: {
                        DataBase cfr_ignored_43 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.MM, false);
                        break;
                    }
                    case 2223: {
                        DataBase cfr_ignored_44 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.MK, false);
                        break;
                    }
                    case 2233: {
                        DataBase cfr_ignored_45 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.ME, false);
                        break;
                    }
                    case 2243: {
                        DataBase cfr_ignored_46 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.MV, false);
                        break;
                    }
                    case 2313: {
                        DataBase cfr_ignored_47 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.HP, false);
                        break;
                    }
                    case 2323: {
                        DataBase cfr_ignored_48 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.HN, false);
                        break;
                    }
                    case 2413: {
                        DataBase cfr_ignored_49 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.BH, false);
                        break;
                    }
                    case 2423: {
                        DataBase cfr_ignored_50 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.BB, false);
                        break;
                    }
                    case 2513: {
                        DataBase cfr_ignored_51 = GraphicClip.this.db;
                        GraphicClip.this.drawRissNames(this.g2, DataBase.T, false);
                        break;
                    }
                    case 3112: {
                        DataBase cfr_ignored_52 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.MP, true);
                        break;
                    }
                    case 3122: {
                        DataBase cfr_ignored_53 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.MG, true);
                        break;
                    }
                    case 3212: {
                        DataBase cfr_ignored_54 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.MM, true);
                        break;
                    }
                    case 3222: {
                        DataBase cfr_ignored_55 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.MK, true);
                        break;
                    }
                    case 3232: {
                        DataBase cfr_ignored_56 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.ME, true);
                        break;
                    }
                    case 3242: {
                        DataBase cfr_ignored_57 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenFG(this.g2, DataBase.MV, true);
                        break;
                    }
                    case 3312: {
                        DataBase cfr_ignored_58 = GraphicClip.this.db;
                        GraphicClip.this.drawHoehen(this.g2, DataBase.HP, true);
                        break;
                    }
                    case 3322: {
                        DataBase cfr_ignored_59 = GraphicClip.this.db;
                        GraphicClip.this.drawHoehen(this.g2, DataBase.HN, true);
                        break;
                    }
                    case 3412: {
                        DataBase cfr_ignored_60 = GraphicClip.this.db;
                        GraphicClip.this.drawBedingungen(this.g2, DataBase.BH);
                        break;
                    }
                    case 3422: {
                        DataBase cfr_ignored_61 = GraphicClip.this.db;
                        GraphicClip.this.drawBedingungen(this.g2, DataBase.BB);
                        break;
                    }
                    case 3432: {
                        DataBase cfr_ignored_62 = GraphicClip.this.db;
                        GraphicClip.this.drawPunktTables(this.g2, DataBase.PM);
                        break;
                    }
                    case 3442: {
                        DataBase cfr_ignored_63 = GraphicClip.this.db;
                        GraphicClip.this.drawPunktTables(this.g2, DataBase.PI);
                        break;
                    }
                    case 3512: {
                        GraphicClip.this.drawTrafoSysteme(this.g2);
                        break;
                    }
                    case 3213: {
                        DataBase cfr_ignored_64 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTX(this.g2, DataBase.MM, true);
                        break;
                    }
                    case 3223: {
                        DataBase cfr_ignored_65 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTX(this.g2, DataBase.MK, true);
                        break;
                    }
                    case 3233: {
                        DataBase cfr_ignored_66 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTX(this.g2, DataBase.ME, true);
                        break;
                    }
                    case 3243: {
                        DataBase cfr_ignored_67 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTX(this.g2, DataBase.MV, true);
                        break;
                    }
                    case 3214: {
                        DataBase cfr_ignored_68 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTN(this.g2, DataBase.MM, true);
                        break;
                    }
                    case 3224: {
                        DataBase cfr_ignored_69 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTN(this.g2, DataBase.MK, true);
                        break;
                    }
                    case 3234: {
                        DataBase cfr_ignored_70 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTN(this.g2, DataBase.ME, true);
                        break;
                    }
                    case 3244: {
                        DataBase cfr_ignored_71 = GraphicClip.this.db;
                        GraphicClip.this.drawMessungenTN(this.g2, DataBase.MV, true);
                        break;
                    }
                    case 5110: {
                        GraphicClip.this.drawPunktSymbole(this.g2);
                        break;
                    }
                    case 5120: {
                        GraphicClip.this.drawPunktTexte(this.g2);
                        break;
                    }
                    case 5112: {
                        GraphicClip.this.drawPunktFehler(this.g2, false);
                        break;
                    }
                    case 8110: {
                        GraphicClip.this.drawGitter(this.g2);
                        break;
                    }
                    case 8120: {
                        GraphicClip.this.drawIdentitaeten(this.g2);
                        break;
                    }
                    case 8130: {
                        DataBase cfr_ignored_72 = GraphicClip.this.db;
                        GraphicClip.this.drawMenge(this.g2, DataBase.MENGE);
                        break;
                    }
                    case 8140: {
                        GraphicClip.this.drawBeschriftung(this.g2);
                        break;
                    }
                    case 8160: {
                        GraphicClip.this.drawVersionMsg(this.g2);
                        break;
                    }
                    case 9901: {
                        GraphicClip.this.setHints(this.g2, false, false);
                        break;
                    }
                    case 9902: {
                        GraphicClip.this.setHints(this.g2, true, false);
                        break;
                    }
                    case 9903: {
                        GraphicClip.this.setHints(this.g2, false, true);
                        break;
                    }
                    case 9904: {
                        GraphicClip.this.setHints(this.g2, true, true);
                    }
                }
                int n3 = (int)((System.nanoTime() - l2) / 1000L);
                GraphicClip.this.timeList.put(this.drawList[n].order, this.drawList[n].time, n3);
                if (!GraphicClip.this.debug) continue;
                this.drawList[n].runTime = n3;
            }
        }

        public void drawImage(Draw draw) {
            this.g.drawImage((Image)draw.buffer, 0, 0, null);
        }

        public void closeGraphics() {
            if (this.g != null) {
                this.g.dispose();
            }
        }

        public void flush() {
            if (this.buffer != null) {
                this.buffer.flush();
            }
        }

        @Override
        public String toString() {
            return "Draw(" + this.id + "[" + this.a + "," + this.e + "])";
        }
    }

    class VisibleDataEnumerator
    implements Enumeration {
        Enumeration tables;
        Enumeration nextEn;

        VisibleDataEnumerator(GraphicClip graphicClip, DataContainerTable dataContainerTable) {
            this.tables = dataContainerTable.elements();
            this.setNextEnumerator();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.nextEn == null) {
                return false;
            }
            if (this.nextEn.hasMoreElements()) {
                return true;
            }
            return this.setNextEnumerator();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.nextEn.nextElement();
            }
            throw new NoSuchElementException("VisibleDataEnumerator");
        }

        protected boolean setNextEnumerator() {
            while (this.tables.hasMoreElements()) {
                DataContainer dataContainer = (DataContainer)this.tables.nextElement();
                if (!dataContainer.isVisible()) continue;
                this.nextEn = dataContainer.elements();
                if (!this.nextEn.hasMoreElements()) continue;
                return true;
            }
            return false;
        }
    }

    class TimeDebugEntry
    implements IntegerHashObject {
        String name;
        int id;
        int count;
        long compTime;
        long usedTime;

        TimeDebugEntry(GraphicClip graphicClip, int n, String string) {
            this.id = n;
            this.name = string;
        }

        @Override
        public int intHashKey() {
            return this.id;
        }

        public String toString() {
            if (this.count == 0 || this.usedTime <= 0L || this.compTime <= 0L) {
                return this.name + ": " + IFormat.i5.format(this.compTime) + " > " + IFormat.i5.format(this.usedTime) + " 100%";
            }
            return this.name + ": " + IFormat.i5.format(this.compTime / (long)this.count) + " > " + IFormat.i5.format(this.usedTime / (long)this.count) + " " + IFormat.i3.format((double)this.usedTime / (double)this.compTime * 100.0) + "%";
        }
    }
}

