/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.awt.event.IMessageEvent;
import de.geocalc.awt.event.IMessageListener;
import de.geocalc.awt.event.IQuestionEvent;
import de.geocalc.awt.event.IQuestionListener;
import de.geocalc.awt.event.Question;
import de.geocalc.awt.event.Questioner;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeoTransform;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.Transform;
import de.geocalc.kafplot.Bogen;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.DataContainerTable;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Flaeche;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GraphicClip;
import de.geocalc.kafplot.Identitaet;
import de.geocalc.kafplot.InputBedingung;
import de.geocalc.kafplot.InputLinieClip;
import de.geocalc.kafplot.InputLinieConnect;
import de.geocalc.kafplot.InputMessung;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputObjectClip;
import de.geocalc.kafplot.InputObjectUnion;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.InputPunkt;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Linienzug;
import de.geocalc.kafplot.MarkObjectPopupMenu;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.Plotbox;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktMove;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.Riss;
import de.geocalc.kafplot.TextBox;
import de.geocalc.kafplot.TrafoPunkt;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.kafplot.event.GraphicEvent;
import de.geocalc.kafplot.event.GraphicListener;
import de.geocalc.lang.IDouble;
import de.geocalc.text.IFormat;
import de.geocalc.util.Acceptor;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import java.util.Vector;

public class GraphicPanel
extends Panel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
Questioner {
    public static final double ZOOM_SMALL = 1.1;
    public static final double ZOOM = 2.0;
    public static final double ZOOM_BIG = 5.0;
    public static final double MOVE_SMALL = 0.1;
    public static final double MOVE = 1.0;
    public static final double MOVE_BIG = 2.0;
    public static final double ROT_SMALL = 0.003490658503988659;
    public static final double ROT = 0.05235987755982988;
    public static final double ROT_BIG = 0.15707963267948966;
    private static final double ELLIPSE_FACTOR = 0.75;
    private static final double DIN = 1.4802;
    private static final int MOUSE_DRAG_SENSITIVE_VALUE = 50;
    private static final int MOUSE_MOVE_SENSITIVE_VALUE = 25;
    private static final long MOUSE_DRAG_SENSITIVE_TIME = 250L;
    private static final String GRAPHIC_EXCEPTION_MESSAGE = "Fehler in der Datenzuordnung, pr\u00fcfen Sie die Eingabedatei!";
    private DataBase db = null;
    private IGraphics g2 = new IGraphics(null, null, null);
    private GraphicClip graphicClip = null;
    private ActionListener actionListener;
    private IMessageListener messageListener;
    private IQuestionListener questionListener;
    private GraphicListener graphicListener;
    private WheelRepainter wheelRepainter;
    private Point mousePoint = new Point();
    private Point mousePressedPoint = null;
    private long mousePressedTime = 0L;
    private boolean mousePressedEventConsumed = false;
    private Punkt mousePunkt = null;
    private boolean longMessage = false;
    private int XM;
    private int YM;
    private double xM;
    private double yM;
    private double M;
    private double me = 0.5;
    private double zoomFaktor = 1.0;
    private Object markObject;
    private Object cmdObject;
    private InputObject inputObject;
    private PopupMenu popup = null;
    private MarkObjectPopupMenu markPopup = new MarkObjectPopupMenu();
    private Rectangle drawRect = new Rectangle();
    private String infoObjectCommand = null;
    private ViewProperties viewProps = new ViewProperties(this);
    private static final long REPAINTER_WAIT_TIME = 300L;

    public GraphicPanel() {
        this((DataBase)null);
    }

    public GraphicPanel(DataBase dataBase) {
        this.setLayout(new BorderLayout());
        this.graphicClip = new GraphicClip(dataBase, this.g2, this.drawRect);
        this.add(this.graphicClip);
        this.setView(dataBase);
        this.setCursor();
        this.add(this.markPopup);
        this.wheelRepainter = new WheelRepainter();
        this.wheelRepainter.setPriority(1);
        this.wheelRepainter.start();
    }

    public void addPopupMenu(PopupMenu popupMenu) {
        if (this.popup != null) {
            this.removePopupMenu();
        }
        this.add(popupMenu);
        this.popup = popupMenu;
    }

    public void removePopupMenu() {
        if (this.popup != null) {
            this.remove(this.popup);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.markPopup.addActionListener(this.actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        this.markPopup.removeActionListener(this.actionListener);
    }

    public void setInfoObjectCommand(String string) {
        this.infoObjectCommand = string;
    }

    public String getInfoObjectCommand() {
        return this.infoObjectCommand;
    }

    public void addMessageListener(IMessageListener iMessageListener) {
        this.messageListener = iMessageListener;
        this.graphicClip.addMessageListener(iMessageListener);
    }

    public void removeMessageListener(IMessageListener iMessageListener) {
        this.messageListener = null;
        this.graphicClip.removeMessageListener(iMessageListener);
    }

    public void addQuestionListener(IQuestionListener iQuestionListener) {
        this.questionListener = iQuestionListener;
    }

    public void removeQuestionListener(IQuestionListener iQuestionListener) {
        this.questionListener = null;
    }

    public void addGraphicListener(GraphicListener graphicListener) {
        this.graphicListener = graphicListener;
    }

    public void removeGraphicListener(GraphicListener graphicListener) {
        this.graphicListener = null;
    }

    public void setCursor() {
        switch (KafPlotProperties.getMouseSwitch()) {
            case 5: {
                if (KafPlotProperties.isMessFree()) {
                    super.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                super.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 6: 
            case 7: {
                super.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 8: {
                if (this.inputObject != null) {
                    super.setCursor(this.inputObject.getCurrentCursor());
                    break;
                }
                super.setCursor(Cursor.getDefaultCursor());
                break;
            }
            default: {
                super.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setView(DataBase var1_1) {
        block2: {
            if (var1_1.isEmpty()) break block2;
            var2_2 = KafPlotProperties.getGrafikCenter();
            if (!(var2_2.y < DataBase.ymax)) ** GOTO lbl-1000
            if (!(var2_2.y > DataBase.ymin)) ** GOTO lbl-1000
            if (!(var2_2.x < DataBase.xmax)) ** GOTO lbl-1000
            if (var2_2.x > DataBase.xmin) {
                this.xM = var2_2.x;
                this.yM = var2_2.y;
                this.zoomFaktor = KafPlotProperties.getGrafikZoom();
                this.me = KafPlotProperties.getEllipseZoom();
            } else lbl-1000:
            // 4 sources

            {
                this.xM = (DataBase.xmax + DataBase.xmin) / 2.0;
                this.yM = (DataBase.ymax + DataBase.ymin) / 2.0;
                KafPlotProperties.setGrafikRotation(0.0);
                this.zoomFaktor = 1.0;
                this.me = 0.5;
            }
        }
        this.setDataBase(var1_1);
    }

    public void setViewOfProperties() {
        this.yM = KafPlotProperties.getGrafikCenter().y;
        this.xM = KafPlotProperties.getGrafikCenter().x;
        this.zoomFaktor = KafPlotProperties.getGrafikZoom();
        this.me = KafPlotProperties.getEllipseZoom();
    }

    public void setDataBase(DataBase dataBase) {
        this.db = dataBase;
        this.graphicClip.setDataBase(dataBase);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
        if (!dataBase.isEmpty()) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }
        this.markObject = null;
        this.repaint();
    }

    public void zoomIn(double d) {
        this.zoomFaktor *= d;
        this.me *= d * 0.75;
        if (this.mousePoint != null) {
            DPoint dPoint = new DPoint();
            dPoint = this.g2.getDataPoint(this.mousePoint, dPoint);
            this.yM = dPoint.y;
            this.xM = dPoint.x;
        }
        this.repaint();
    }

    public void zoomOut(double d) {
        this.zoomFaktor /= d;
        this.me /= d * 0.75;
        if (this.mousePoint != null) {
            DPoint dPoint = new DPoint();
            dPoint = this.g2.getDataPoint(this.mousePoint, dPoint);
            this.yM = dPoint.y;
            this.xM = dPoint.x;
        }
        this.repaint();
    }

    public void zoomEllipseIn(double d) {
        this.me *= d;
        this.repaint();
    }

    public void zoomEllipseOut(double d) {
        this.me /= d;
        this.repaint();
    }

    public void move(int n, double d) {
        Dimension dimension = this.getSize();
        Point point = new Point(this.XM, this.YM);
        switch (n) {
            case 1: {
                point.y += (int)((double)dimension.width / 10.0 * d);
                break;
            }
            case -1: {
                point.y -= (int)((double)dimension.width / 10.0 * d);
                break;
            }
            case 10: {
                point.x += (int)((double)dimension.height / 10.0 * d);
                break;
            }
            case -10: {
                point.x -= (int)((double)dimension.height / 10.0 * d);
            }
        }
        DPoint dPoint = new DPoint();
        dPoint = this.g2.getDataPoint(point, dPoint);
        this.xM = dPoint.x;
        this.yM = dPoint.y;
        this.repaint();
    }

    public void showView(int n) {
        ViewProperty viewProperty = null;
        if (n < 0) {
            viewProperty = this.viewProps.before();
        } else if (n > 0) {
            viewProperty = this.viewProps.next();
        }
        if (viewProperty != null) {
            this.zoomFaktor = viewProperty.z;
            this.xM = viewProperty.x;
            this.yM = viewProperty.y;
        }
        this.repaint();
    }

    public void reverseInput() {
        if (KafPlotProperties.getMouseSwitch() == 8 && this.inputObject != null) {
            this.drawInputObject();
            this.inputObject.reverse(1);
            this.drawInputObject();
        }
    }

    public void centerOfPunkt(DPoint dPoint) {
        if (dPoint != null) {
            this.centerOfPunkt(dPoint.y, dPoint.x);
        }
    }

    public void centerOfPunkt(double d, double d2) {
        this.xM = d2;
        this.yM = d;
        this.repaint();
    }

    public void setMarkedPunkt(Punkt punkt) {
        this.g2.setGraphics(this.getGraphics());
        this.g2.setXORMode(Color.magenta);
        Point point = new Point();
        if (punkt == null && this.mousePunkt != null) {
            this.mousePunkt.drawObject(this.g2, KafPlotProperties.isPunktArtVisible(), true);
        }
        this.mousePunkt = punkt;
        if (this.mousePunkt != null) {
            this.mousePunkt.drawObject(this.g2, KafPlotProperties.isPunktArtVisible(), true);
        }
        this.g2.setPaintMode();
    }

    public Punkt getMarkedPunkt() {
        if (this.markObject instanceof Punkt) {
            return (Punkt)this.markObject;
        }
        return null;
    }

    public void deleteMarkObject() {
        if (this.markObject != null) {
            this.drawMarkObject();
        }
        this.markObject = null;
    }

    public Object getMarkObject() {
        return this.markObject;
    }

    public void setMarkObject(Object object) {
        this.markObject = object;
        this.drawMarkObject();
    }

    public void setCommandObject(Object object) {
        this.cmdObject = object;
    }

    public Object getCommandObject() {
        return this.cmdObject;
    }

    public void deleteCommandObject() {
        if (this.cmdObject == this.markObject) {
            this.deleteMarkObject();
        }
    }

    public Object getInputObject() {
        return this.inputObject;
    }

    public void deleteInputObject() {
        this.drawInputObject();
        this.inputObject = null;
    }

    public void refreshInputObject() {
        if (this.inputObject != null) {
            if (this.inputObject.needInterface() == 2) {
                if (this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                }
            } else if (this.questionListener != null) {
                this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
            }
        }
    }

    public Point getMousePoint() {
        return this.mousePoint;
    }

    public void setInputObject(InputObject inputObject) {
        if (inputObject == null && this.inputObject != null) {
            this.drawInputObject();
            this.inputObject = null;
        } else {
            this.inputObject = inputObject;
            this.drawInputObject();
        }
    }

    public void drawMenge(PunktTable punktTable) {
        this.g2.setGraphics(this.getGraphics());
        this.graphicClip.drawMenge(this.g2, punktTable);
    }

    public void deleteMenge(PunktTable punktTable) {
        Graphics graphics = this.getGraphics();
        this.g2.setGraphics(graphics);
        this.graphicClip.drawMenge(this.g2, punktTable);
        this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Menge aufgel\u00f6st"));
        this.messageListener.messagePerformed(new IMessageEvent(this, 1002, null));
    }

    public void deletePlotbox(Plotbox plotbox) {
        if (plotbox != null) {
            this.g2.setGraphics(this.getGraphics());
            plotbox.drawSymbol(this.g2, false);
        }
    }

    public void drawObjects(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            ((Drawable)enumeration.nextElement()).drawObject(this.g2, true, false);
        }
    }

    public void drawObject(Drawable drawable) {
        drawable.drawObject(this.g2, true, false);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        boolean bl = KafPlotProperties.isAntialiasEnabled;
        boolean bl2 = KafPlotProperties.isPunktVisible;
        boolean bl3 = KafPlotProperties.isPunktNummerVisible;
        boolean bl4 = KafPlotProperties.isPunktHoeheVisible;
        boolean bl5 = KafPlotProperties.isVermarkungVisible;
        boolean bl6 = KafPlotProperties.isPunktArtVisible;
        boolean bl7 = KafPlotProperties.isFlaecheTextVisible;
        boolean bl8 = KafPlotProperties.isFlaecheLengthVisible;
        boolean bl9 = KafPlotProperties.isFlaechePatternVisible;
        boolean bl10 = KafPlotProperties.isEllipseVisible;
        boolean bl11 = KafPlotProperties.isMaszeVisible;
        boolean bl12 = KafPlotProperties.isGitterVisible;
        boolean bl13 = KafPlotProperties.isPolarAufnahmeVisible;
        boolean bl14 = KafPlotProperties.isGpsAufnahmeVisible;
        boolean bl15 = KafPlotProperties.isNivellementVisible;
        boolean bl16 = KafPlotProperties.isZenitVisible;
        boolean bl17 = KafPlotProperties.isTrafoVisible;
        boolean bl18 = KafPlotProperties.isConditionVisible;
        boolean bl19 = KafPlotProperties.isBemerkungVisible;
        boolean bl20 = KafPlotProperties.isImgVisible;
        boolean bl21 = KafPlotProperties.isKatIdentVisible;
        boolean bl22 = KafPlotProperties.isUnusedPunktVisible;
        if (KafPlotProperties.isQuickPaintEnabled) {
            GraphicPanel graphicPanel = this;
            if (graphicPanel.db.getGObjectCount() > 200) {
                KafPlotProperties.isPunktVisible = false;
            }
            KafPlotProperties.isAntialiasEnabled = false;
            KafPlotProperties.isPunktNummerVisible = false;
            KafPlotProperties.isPunktHoeheVisible = false;
            KafPlotProperties.isVermarkungVisible = false;
            KafPlotProperties.isPunktArtVisible = false;
            KafPlotProperties.isFlaecheTextVisible = false;
            KafPlotProperties.isFlaecheLengthVisible = false;
            KafPlotProperties.isFlaechePatternVisible = false;
            KafPlotProperties.isEllipseVisible = false;
            KafPlotProperties.isMaszeVisible = false;
            KafPlotProperties.isGitterVisible = false;
            KafPlotProperties.isPolarAufnahmeVisible = false;
            KafPlotProperties.isGpsAufnahmeVisible = false;
            KafPlotProperties.isNivellementVisible = false;
            KafPlotProperties.isZenitVisible = false;
            KafPlotProperties.isTrafoVisible = false;
            KafPlotProperties.isConditionVisible = false;
            KafPlotProperties.isBemerkungVisible = false;
            KafPlotProperties.isImgVisible = false;
            KafPlotProperties.isKatIdentVisible = false;
            KafPlotProperties.isUnusedPunktVisible = false;
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = graphics.getClipBounds();
        this.drawRect = new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
        graphics.setPaintMode();
        GraphicPanel graphicPanel = this;
        if (graphicPanel.db.getState() < 0) {
            this.setBackground(SystemColor.control);
            this.drawRahmen(graphics, dimension);
            return;
        }
        this.setBackground(SystemColor.window);
        if (!KafPlotProperties.isQuickPaintEnabled) {
            this.drawRahmen(graphics, dimension);
        }
        GraphicPanel graphicPanel2 = this;
        if (graphicPanel2.db.isWork()) {
            return;
        }
        graphics.clipRect(2, 2, dimension.width - 4, dimension.height - 4);
        this.XM = dimension.width / 2;
        this.YM = dimension.height / 2;
        this.M = (double)Math.min(dimension.width, dimension.height) / Math.max(DataBase.xmax - DataBase.xmin, DataBase.ymax - DataBase.ymin) * this.zoomFaktor;
        GeoTransform geoTransform = new GeoTransform(-this.yM, -this.xM, this.YM, this.XM, KafPlotProperties.getGrafikRotation(), this.M);
        KafPlotProperties.setGrafikCenter(new DPoint(this.yM, this.xM));
        KafPlotProperties.setGrafikZoom(this.zoomFaktor);
        KafPlotProperties.setEllipseZoom(this.me);
        this.g2 = new IGraphics(graphics, geoTransform, this.drawRect);
        this.g2.setMinDiplaySize(KafPlotProperties.getMinDisplaySize());
        boolean bl23 = rectangle.width != this.getSize().width || rectangle.height != this.getSize().height;
        this.g2.setClip(bl23);
        this.graphicClip.setGraphics(this.g2);
        this.g2.setViewRect(rectangle);
        if (!bl23) {
            KafPlotProperties.setViewport(this.g2.getViewport());
        }
        this.graphicClip.setDrawRect(this.drawRect);
        this.graphicClip.setEllipseMasstab(this.me);
        this.graphicClip.paint(graphics);
        this.drawMousePunkt(graphics);
        this.drawMarkObject(graphics);
        this.drawInputObject(graphics);
        this.g2.setDrawRect(this.drawRect);
        if (KafPlotProperties.isQuickPaintEnabled) {
            KafPlotProperties.isAntialiasEnabled = bl;
            KafPlotProperties.isPunktVisible = bl2;
            KafPlotProperties.isPunktNummerVisible = bl3;
            KafPlotProperties.isPunktHoeheVisible = bl4;
            KafPlotProperties.isVermarkungVisible = bl5;
            KafPlotProperties.isPunktArtVisible = bl6;
            KafPlotProperties.isFlaecheTextVisible = bl7;
            KafPlotProperties.isFlaecheLengthVisible = bl8;
            KafPlotProperties.isFlaechePatternVisible = bl9;
            KafPlotProperties.isEllipseVisible = bl10;
            KafPlotProperties.isMaszeVisible = bl11;
            KafPlotProperties.isGitterVisible = bl12;
            KafPlotProperties.isPolarAufnahmeVisible = bl13;
            KafPlotProperties.isGpsAufnahmeVisible = bl14;
            KafPlotProperties.isNivellementVisible = bl15;
            KafPlotProperties.isZenitVisible = bl16;
            KafPlotProperties.isTrafoVisible = bl17;
            KafPlotProperties.isConditionVisible = bl18;
            KafPlotProperties.isBemerkungVisible = bl19;
            KafPlotProperties.isImgVisible = bl20;
            KafPlotProperties.isKatIdentVisible = bl21;
            KafPlotProperties.isUnusedPunktVisible = bl22;
        }
        KafPlotProperties.isQuickPaintEnabled = false;
        this.g2.setViewRect(new Rectangle(0, 0, dimension.width, dimension.height));
        this.g2.setDrawRect(new Rectangle(-10, -10, dimension.width + 20, dimension.height + 20));
    }

    public void repaint(DRectangle dRectangle) {
        Graphics graphics = this.getGraphics();
        if (dRectangle.width == 0.0 || dRectangle.height == 0.0) {
            Point point = this.g2.getGraphicPoint(dRectangle.y, dRectangle.x, new Point());
            graphics.setClip(point.x - 20, point.y - 20, 40, 40);
        } else {
            Point point = this.g2.getGraphicPoint(dRectangle.y, dRectangle.x, new Point());
            Point point2 = this.g2.getGraphicPoint(dRectangle.y + dRectangle.width, dRectangle.x + dRectangle.height, new Point());
            int n = Math.min(point2.x, point.x);
            int n2 = Math.min(point2.y, point.y);
            int n3 = Math.abs(point2.x - point.x);
            int n4 = Math.abs(point2.y - point.y);
            graphics.setClip(n - 20, n2 - 20, n3 + 40, n4 + 40);
        }
        this.paint(graphics);
    }

    @Override
    public void repaint() {
        if (this.xM != 0.0 && this.yM != 0.0) {
            this.viewProps.put(new ViewProperty(this, this.zoomFaktor, this.xM, this.yM));
        }
        KafPlotProperties.setGrafikCenter(new DPoint(this.yM, this.xM));
        KafPlotProperties.setGrafikZoom(this.zoomFaktor);
        KafPlotProperties.setEllipseZoom(this.me);
        if (this.graphicListener != null) {
            this.graphicListener.graphicUpdated(new GraphicEvent(this, 3009));
        }
        super.repaint();
    }

    public void repaintQuick() {
        KafPlotProperties.isQuickPaintEnabled = true;
        super.repaint();
    }

    private DPoint getPunkt(Point point) {
        if (point == null || this.g2 == null) {
            return null;
        }
        return this.g2.getPunkt(point);
    }

    private DPoint getPunkt(int n, int n2) {
        if (this.g2 == null) {
            return null;
        }
        return this.g2.getPunkt(new Point(n, n2));
    }

    private Punkt getNearestPunkt(DPoint dPoint) {
        if (dPoint == null) {
            return null;
        }
        return this.getNearestPunkt(dPoint.y, dPoint.x);
    }

    private Punkt getNearestPunkt(double d, double d2) {
        IViewport iViewport = this.g2.getViewport();
        Punkt punkt = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt2 = (Punkt)enumeration.nextElement();
            if (!punkt2.isVisible() || !punkt2.isViewable(iViewport)) continue;
            DPoint dPoint = punkt2.getHashPoint();
            d4 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d);
            if (!(d4 < d3)) continue;
            d3 = d4;
            punkt = punkt2;
        }
        return punkt;
    }

    private Punkt getNearestPunkt(DPoint dPoint, Acceptor acceptor) {
        if (dPoint == null) {
            return null;
        }
        return this.getNearestPunkt(dPoint.y, dPoint.x, acceptor);
    }

    private Punkt getNearestPunkt(double d, double d2, Acceptor acceptor) {
        IViewport iViewport = this.g2.getViewport();
        Punkt punkt = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Enumeration enumeration = DataBase.P.elements();
        while (enumeration.hasMoreElements()) {
            Punkt punkt2 = (Punkt)enumeration.nextElement();
            if (!punkt2.isVisible() || !punkt2.isViewable(iViewport)) continue;
            DPoint dPoint = punkt2.getHashPoint();
            d4 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d);
            if (!(d4 < d3) || !acceptor.accept(punkt2)) continue;
            d3 = d4;
            punkt = punkt2;
        }
        return punkt;
    }

    private Linie getNearestLinie(DPoint dPoint) {
        if (dPoint == null) {
            return null;
        }
        IViewport iViewport = this.g2.getViewport();
        double d = Double.MAX_VALUE;
        Linie linie = null;
        if (KafPlotProperties.isFlaecheVisible() && KafPlotProperties.isFlaechePolyVisible()) {
            double d2;
            Linie linie2;
            GObject gObject;
            Enumeration enumeration;
            if (KafPlotProperties.isTopographieVisible() && KafPlotProperties.isObjectCatch(4)) {
                enumeration = DataBase.TOP.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (GObject)enumeration.nextElement();
                    if (!gObject.isVisible() || !gObject.isViewable(iViewport) || (linie2 = gObject.getNearestLinie(dPoint)) == null || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
                    linie = linie2;
                    d = d2;
                }
            }
            if (KafPlotProperties.isBodenVisible() && KafPlotProperties.isObjectCatch(16)) {
                enumeration = DataBase.BODEN.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (GObject)enumeration.nextElement();
                    if (!gObject.isVisible() || !gObject.isViewable(iViewport) || (linie2 = gObject.getNearestLinie(dPoint)) == null || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
                    linie = linie2;
                    d = d2;
                }
            }
            if (KafPlotProperties.isNutzungVisible() && KafPlotProperties.isObjectCatch(8)) {
                enumeration = DataBase.NUTZ.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (GObject)enumeration.nextElement();
                    if (!gObject.isVisible() || !gObject.isViewable(iViewport) || (linie2 = gObject.getNearestLinie(dPoint)) == null || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
                    linie = linie2;
                    d = d2;
                }
            }
            if (KafPlotProperties.isGebaeudeVisible() && KafPlotProperties.isObjectCatch(2)) {
                enumeration = DataBase.GEB.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (GObject)enumeration.nextElement();
                    if (!gObject.isVisible() || !gObject.isViewable(iViewport) || (linie2 = gObject.getNearestLinie(dPoint)) == null || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
                    linie = linie2;
                    d = d2;
                }
            }
            if (KafPlotProperties.isFlstVisible() && KafPlotProperties.isObjectCatch(1)) {
                enumeration = DataBase.FLST.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = (GObject)enumeration.nextElement();
                    if (!gObject.isVisible() || !gObject.isViewable(iViewport) || (linie2 = gObject.getNearestLinie(dPoint)) == null || !((d2 = Math.abs(linie2.getOuterDistance(dPoint))) < d)) continue;
                    linie = linie2;
                    d = d2;
                }
            }
        }
        return linie;
    }

    private DataContainer getNearestObject(DataContainerTable dataContainerTable, DPoint dPoint) {
        if (dPoint == null) {
            return null;
        }
        return this.getNearestObject(dataContainerTable, dPoint.y, dPoint.x);
    }

    private DataContainer getNearestObject(DataContainerTable dataContainerTable, double d, double d2) {
        IViewport iViewport = this.g2.getViewport();
        GObject gObject = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        boolean bl = false;
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                GObject gObject2 = (GObject)enumeration.nextElement();
                if (!gObject2.isVisible() || !gObject2.isViewable(iViewport)) continue;
                d4 = Math.abs(gObject2.x - d2) + Math.abs(gObject2.y - d);
                if (gObject2.isArea() && gObject2.getPolygon().contains(d, d2)) {
                    if (bl) {
                        if (!(d4 < d3)) continue;
                        d3 = d4;
                        gObject = gObject2;
                        continue;
                    }
                    d3 = d4;
                    gObject = gObject2;
                    bl = true;
                    continue;
                }
                if (bl || !(d4 < d3)) continue;
                d3 = d4;
                gObject = gObject2;
            }
            catch (Exception exception) {}
        }
        return gObject;
    }

    private DataContainer getNearestObject(DataContainerTable dataContainerTable, DPoint dPoint, Acceptor acceptor) {
        if (dPoint == null) {
            return null;
        }
        return this.getNearestObject(dataContainerTable, dPoint.y, dPoint.x, acceptor);
    }

    private DataContainer getNearestObject(DataContainerTable dataContainerTable, double d, double d2, Acceptor acceptor) {
        IViewport iViewport = this.g2.getViewport();
        GObject gObject = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        boolean bl = false;
        Enumeration enumeration = dataContainerTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                GObject gObject2 = (GObject)enumeration.nextElement();
                if (!gObject2.isVisible() || !gObject2.isViewable(iViewport)) continue;
                d4 = Math.abs(gObject2.x - d2) + Math.abs(gObject2.y - d);
                if (gObject2.isArea() && gObject2.getPolygon().contains(d, d2) && acceptor.accept(gObject2)) {
                    if (bl) {
                        if (!(d4 < d3)) continue;
                        d3 = d4;
                        gObject = gObject2;
                        continue;
                    }
                    d3 = d4;
                    gObject = gObject2;
                    bl = true;
                    continue;
                }
                if (bl || !(d4 < d3)) continue;
                d3 = d4;
                gObject = gObject2;
            }
            catch (Exception exception) {}
        }
        return gObject;
    }

    private Drawable getNearestBedingung(DPoint dPoint) {
        return this.getNearestBedingung(dPoint.y, dPoint.x);
    }

    private Drawable getNearestBedingung(double d, double d2) {
        Drawable drawable = null;
        IDouble iDouble = new IDouble(Double.MAX_VALUE);
        if (KafPlotProperties.isConditionVisible()) {
            if (KafPlotProperties.isHomogenisierungVisible()) {
                drawable = this.getNearestBedingung(d, d2, iDouble, DataBase.BH, drawable);
            }
            if (KafPlotProperties.isBedingungVisible()) {
                drawable = this.getNearestBedingung(d, d2, iDouble, DataBase.BB, drawable);
            }
            if (KafPlotProperties.isBedMoveVisible) {
                drawable = this.getNearestBedingung(d, d2, iDouble, DataBase.PM.elements(), drawable);
            }
            if (KafPlotProperties.isBedIdentVisible) {
                drawable = this.getNearestBedingung(d, d2, iDouble, DataBase.PI.elements(), drawable);
            }
        }
        return drawable;
    }

    private Drawable getNearestBedingung(double d, double d2, IDouble iDouble, Vector vector, Drawable drawable) {
        IViewport iViewport = this.g2.getViewport();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Riss riss = (Riss)enumeration.nextElement();
                if (!riss.isVisible() || !riss.isViewable(iViewport)) continue;
                drawable = this.getNearestBedingung(d, d2, iDouble, riss.elements(), drawable);
            }
            catch (Exception exception) {}
        }
        return drawable;
    }

    private Drawable getNearestBedingung(double d, double d2, IDouble iDouble, Enumeration enumeration, Drawable drawable) {
        IViewport iViewport = this.g2.getViewport();
        double d3 = 0.0;
        while (enumeration.hasMoreElements()) {
            try {
                Drawable drawable2 = (Drawable)enumeration.nextElement();
                if (!drawable2.isVisible() || !drawable2.isViewable(iViewport)) continue;
                DPoint dPoint = drawable2.getHashPoint();
                d3 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d);
                if (!(d3 < iDouble.getValue())) continue;
                iDouble.setValue(d3);
                drawable = drawable2;
            }
            catch (Exception exception) {}
        }
        return drawable;
    }

    private Messung getNearestMessung(DPoint dPoint) {
        if (dPoint == null) {
            return null;
        }
        return this.getNearestMessung(dPoint.y, dPoint.x);
    }

    private Messung getNearestMessung(double d, double d2) {
        Messung messung = null;
        IDouble iDouble = new IDouble(Double.MAX_VALUE);
        if (KafPlotProperties.isAufnahmeVisible) {
            if (KafPlotProperties.isPolarVisible) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.MP, messung);
            }
            if (KafPlotProperties.isGpsVisible) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.MG, messung);
            }
        }
        if (KafPlotProperties.isOrthoVisible()) {
            if (KafPlotProperties.isEigeneVisible()) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.MM, messung);
            }
            if (KafPlotProperties.isNachweisVisible()) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.MK, messung);
            }
            if (KafPlotProperties.isEinrechnungVisible()) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.ME, messung);
            }
            if (KafPlotProperties.isVorgabenVisible()) {
                messung = this.getNearestMessung(d, d2, iDouble, DataBase.MV, messung);
            }
        }
        return messung;
    }

    private Messung getNearestMessung(double d, double d2, IDouble iDouble, Vector vector, Messung messung) {
        IViewport iViewport = this.g2.getViewport();
        double d3 = 0.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Riss riss = (Riss)enumeration.nextElement();
            if (!riss.isVisible() || !riss.isViewable(iViewport)) continue;
            Enumeration enumeration2 = riss.elements();
            while (enumeration2.hasMoreElements()) {
                Messung messung2 = (Messung)enumeration2.nextElement();
                if (!messung2.isVisible() || !messung2.isViewable(iViewport)) continue;
                DPoint dPoint = messung2.getCatchPoint();
                d3 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d);
                if (!(d3 < iDouble.getValue())) continue;
                iDouble.setValue(d3);
                messung = messung2;
            }
        }
        return messung;
    }

    private TextBox getNearestBemerkung(DPoint dPoint) {
        return this.getNearestBemerkung(dPoint.y, dPoint.x);
    }

    private TextBox getNearestBemerkung(double d, double d2) {
        TextBox textBox = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Enumeration enumeration = this.graphicClip.getBeschriftungen().elements();
        while (enumeration.hasMoreElements()) {
            TextBox textBox2 = (TextBox)enumeration.nextElement();
            DPoint dPoint = textBox2.getCatchPoint();
            if (dPoint == null || !((d4 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d)) < d3)) continue;
            d3 = d4;
            textBox = textBox2;
        }
        return textBox;
    }

    private GeoImage getNearestImage(DPoint dPoint) {
        return this.getNearestImage(dPoint.y, dPoint.x);
    }

    private GeoImage getNearestImage(double d, double d2) {
        GeoImage geoImage = null;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Enumeration enumeration = DataBase.IMG.elements();
        while (enumeration.hasMoreElements()) {
            DPoint dPoint;
            GeoImage geoImage2 = (GeoImage)enumeration.nextElement();
            if (!geoImage2.isVisible() || (dPoint = geoImage2.getCatchPoint()) == null || !((d4 = Math.abs(dPoint.x - d2) + Math.abs(dPoint.y - d)) < d3)) continue;
            d3 = d4;
            geoImage = geoImage2;
        }
        return geoImage;
    }

    public void drawMarkObject() {
        this.drawMarkObject(this.getGraphics());
    }

    public void drawMarkObject(Graphics graphics) {
        if (this.markObject == null) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.clipRect(2, 2, dimension.width - 4, dimension.height - 4);
        this.g2.setGraphics(graphics);
        this.g2.setXORMode(Color.magenta);
        if (this.markObject instanceof Drawable) {
            ((Drawable)this.markObject).drawObject(this.g2, false, true);
            if ((KafPlotProperties.getMouseSwitch() == 1 || KafPlotProperties.getMouseSwitch() == 5) && this.messageListener != null && this.markObject instanceof Messager) {
                Message message = ((Messager)this.markObject).getMessage();
                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, this.longMessage ? message.getLongText() : message.getShortText()));
            }
        } else if (this.markObject instanceof TrafoPunkt) {
            Punkt punkt = ((TrafoPunkt)this.markObject).getPunkt();
            punkt.drawObject(this.g2, false, true);
        } else if (this.markObject instanceof OrthoLinie) {
            OrthoLinie orthoLinie = (OrthoLinie)this.markObject;
            orthoLinie.drawSymbol(this.g2, true);
        } else if (this.markObject instanceof PolarAufnahme) {
            PolarAufnahme polarAufnahme = (PolarAufnahme)this.markObject;
            polarAufnahme.drawSymbol(this.g2, true);
        } else if (this.markObject instanceof Flaeche) {
            Flaeche flaeche = (Flaeche)this.markObject;
            flaeche.drawSymbol(this.g2, true);
        } else if (this.markObject instanceof Linienzug) {
            Linienzug linienzug = (Linienzug)this.markObject;
            linienzug.drawSymbol(this.g2, true);
        } else if (this.markObject instanceof DPolygon) {
            this.graphicClip.drawDPolygon(graphics, (DPolygon)this.markObject);
        } else if (this.markObject instanceof Plotbox) {
            Plotbox plotbox = (Plotbox)this.markObject;
            plotbox.drawSymbol(this.g2, true);
        } else if (this.markObject instanceof DPoint) {
            Point point = this.g2.getGraphicPoint((DPoint)this.markObject, new Point());
            graphics.drawLine(point.x - 20, point.y, point.x + 20, point.y);
            graphics.drawLine(point.x - 20, point.y - 1, point.x + 20, point.y - 1);
            graphics.drawLine(point.x - 20, point.y + 1, point.x + 20, point.y + 1);
            graphics.drawLine(point.x, point.y - 20, point.x, point.y + 20);
            graphics.drawLine(point.x - 1, point.y - 20, point.x - 1, point.y + 20);
            graphics.drawLine(point.x + 1, point.y - 20, point.x + 1, point.y + 20);
        }
        this.g2.setPaintMode();
        ((Graphics2D)graphics).setPaint(Color.white);
    }

    public void drawInputObject() {
        this.drawInputObject(this.getGraphics());
    }

    public void drawInputObject(Graphics graphics) {
        this.g2.setGraphics(graphics);
        if (this.inputObject == null) {
            return;
        }
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.magenta);
        if (this.inputObject instanceof Drawable) {
            this.inputObject.drawObject(this.g2, false, true);
            if (KafPlotProperties.getMouseSwitch() == 8) {
                if (this.inputObject.needInterface() == 1) {
                    if (this.messageListener != null && this.inputObject instanceof Messager) {
                        Message message = this.inputObject.getMessage();
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1001, this.longMessage ? message.getLongText() : message.getShortText()));
                    }
                } else if (this.inputObject.needInterface() == 2 && this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                }
            }
        }
    }

    private void drawMousePunkt(Graphics graphics) {
        this.g2.setGraphics(this.getGraphics());
        this.g2.setXORMode(Color.magenta);
        Point point = new Point();
        if (this.mousePunkt != null && this.g2.contains(this.mousePunkt)) {
            this.mousePunkt.drawSymbol(this.g2, this.g2.getGraphicPoint(this.mousePunkt, point), KafPlotProperties.isPunktArtVisible(), true);
        }
    }

    private void drawRahmen(Graphics graphics, Dimension dimension) {
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawRect(1, 1, dimension.width, dimension.height);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height);
        graphics.drawLine(1, dimension.height - 1, dimension.width, dimension.height - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 3);
        graphics.drawLine(2, dimension.height - 2, dimension.width - 2, dimension.height - 2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressedPoint = mouseEvent.getPoint();
        this.mousePressedTime = System.currentTimeMillis();
        this.mousePoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        block111: {
            boolean bl;
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                this.drawRect = new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
                this.g2.setDrawRect(this.drawRect);
            }
            if (this.mousePressedEventConsumed) {
                this.setCursor();
                this.mousePressedPoint = null;
                this.mousePoint = null;
                this.mousePunkt = null;
                this.mousePressedEventConsumed = false;
                return;
            }
            boolean bl2 = bl = mouseEvent.getClickCount() > 1;
            if (bl) {
                this.cmdObject = this.markObject;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.isPopupTrigger() && mouseEvent.isShiftDown()) {
                if (this.popup != null) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            switch (KafPlotProperties.getMouseSwitch()) {
                case 1: {
                    if (mouseEvent.isMetaDown() || (mouseEvent.getModifiers() & 4) == 4) {
                        if (this.markObject == null) break;
                        this.markPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), this.markObject);
                        this.cmdObject = this.markObject;
                        if (!(this.markObject instanceof WmsGeoImage)) break;
                        ((WmsGeoImage)this.markObject).setQueryPoint(new Point(n, n2));
                        break;
                    }
                    boolean bl3 = this.longMessage = !this.longMessage;
                    if (this.messageListener != null && this.markObject instanceof Messager) {
                        Message message = ((Messager)this.markObject).getMessage();
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1001, message.getLongText()));
                    }
                    if (!bl || this.actionListener == null || this.infoObjectCommand == null) break;
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.infoObjectCommand));
                    break;
                }
                case 3: {
                    double d = mouseEvent.isAltDown() ? 1.1 : (mouseEvent.isControlDown() ? 5.0 : 2.0);
                    double d2 = d * 0.75;
                    if (mouseEvent.isMetaDown() || (mouseEvent.getModifiers() & 4) == 4) {
                        this.zoomFaktor /= d;
                        this.me /= d2;
                    } else {
                        this.zoomFaktor *= d;
                        this.me *= d2;
                    }
                    DPoint dPoint = this.g2.getDataPoint(mouseEvent.getPoint(), new DPoint());
                    this.yM = dPoint.y;
                    this.xM = dPoint.x;
                    this.repaint();
                    break;
                }
                case 4: {
                    if (!KafPlotProperties.isEllipseVisible() || mouseEvent.isAltDown() && mouseEvent.isControlDown()) {
                        if (mouseEvent.isAltDown()) {
                            double d = 1.05;
                        } else if (mouseEvent.isControlDown()) {
                            double d = 1.2;
                        } else {
                            double d = 1.1;
                        }
                    } else {
                        double d = mouseEvent.isAltDown() ? 1.1 : (mouseEvent.isControlDown() ? 5.0 : 2.0);
                        this.me = mouseEvent.isMetaDown() || (mouseEvent.getModifiers() & 4) == 4 ? (this.me /= d) : (this.me *= d);
                    }
                    this.repaint();
                    break;
                }
                case 2: {
                    DPoint dPoint = this.g2.getDataPoint(mouseEvent.getPoint(), new DPoint());
                    double d = mouseEvent.isAltDown() ? 0.1 : (mouseEvent.isControlDown() ? 2.0 : 1.0);
                    this.yM += d * (dPoint.y - this.yM);
                    this.xM += d * (dPoint.x - this.xM);
                    this.repaint();
                    break;
                }
                case 5: {
                    if (mouseEvent.isMetaDown() || (mouseEvent.getModifiers() & 4) == 4) {
                        this.drawMarkObject();
                        this.markObject = null;
                        break;
                    }
                    switch (KafPlotProperties.getMessSwitch()) {
                        case 501: {
                            if (!(this.markObject instanceof OrthoLinie)) {
                                this.markObject = new OrthoLinie();
                            }
                            OrthoLinie orthoLinie = (OrthoLinie)this.markObject;
                            if (bl) {
                                if (this.actionListener != null && this.infoObjectCommand != null) {
                                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.infoObjectCommand));
                                    break;
                                }
                            } else {
                                if (orthoLinie.getAnfangsPunkt() == null) {
                                    orthoLinie.setAnfangsPunkt(this.mousePunkt);
                                    break;
                                }
                                if (orthoLinie.getEndPunkt() == null) {
                                    orthoLinie.setAnfangsPunkt(this.mousePunkt);
                                    orthoLinie.setEndPunkt(this.mousePunkt);
                                    break;
                                }
                                if (orthoLinie.size() == 0) {
                                    if (this.mousePunkt == orthoLinie.getAnfangsPunkt()) break;
                                    orthoLinie.setEndPunkt(this.mousePunkt);
                                    orthoLinie.addElement(this.mousePunkt);
                                    break;
                                }
                            }
                            break block111;
                        }
                        case 502: {
                            if (!(this.markObject instanceof PolarAufnahme)) {
                                this.markObject = new PolarAufnahme(DataBase.getStreckeMasstab(this.mousePunkt.y));
                            }
                            PolarAufnahme polarAufnahme = (PolarAufnahme)this.markObject;
                            if (bl) {
                                if (this.actionListener != null && this.infoObjectCommand != null) {
                                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.infoObjectCommand));
                                    break;
                                }
                            } else {
                                if (polarAufnahme.getStandPunkt() == null) {
                                    polarAufnahme.setStandPunkt(this.mousePunkt);
                                    break;
                                }
                                if (polarAufnahme.getAnschlussPunkt() == null) {
                                    polarAufnahme.setStandPunkt(this.mousePunkt);
                                    polarAufnahme.setAnschlussPunkt(this.mousePunkt);
                                    break;
                                }
                                if (polarAufnahme.size() == 0) {
                                    polarAufnahme.setAnschlussPunkt(this.mousePunkt);
                                    polarAufnahme.addElement(this.mousePunkt);
                                    break;
                                }
                            }
                            break block111;
                        }
                        case 503: {
                            if (!(this.markObject instanceof Bogen)) {
                                this.markObject = new Bogen();
                            }
                            Bogen bogen = (Bogen)this.markObject;
                            if (bogen.pa == null) {
                                bogen.pa = this.mousePunkt;
                                break;
                            }
                            if (bogen.pe == null) {
                                bogen.pa = this.mousePunkt;
                                bogen.pe = this.mousePunkt;
                                break;
                            }
                            if (bogen.pm == null) {
                                if (this.mousePunkt == bogen.pa) break;
                                bogen.pe = this.mousePunkt;
                                bogen.pm = this.mousePunkt;
                                break;
                            }
                            break block111;
                        }
                        case 504: {
                            if (!(this.markObject instanceof Flaeche)) {
                                this.markObject = new Flaeche();
                            }
                            Flaeche flaeche = (Flaeche)this.markObject;
                            flaeche.addPoint(this.mousePunkt);
                            break;
                        }
                        case 505: {
                            if (!(this.markObject instanceof Linienzug)) {
                                this.markObject = new Linienzug();
                            }
                            Linienzug linienzug = (Linienzug)this.markObject;
                            linienzug.addPoint(this.mousePunkt);
                        }
                    }
                    break;
                }
                case 6: {
                    Point point = new Point();
                    if (!(this.markObject instanceof DPolygon)) {
                        this.markObject = new DPolygon();
                    }
                    DPolygon dPolygon = (DPolygon)this.markObject;
                    graphics.setColor(Color.white);
                    graphics.setXORMode(Color.magenta);
                    if (dPolygon.npoints > 0) {
                        point = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[dPolygon.npoints - 1], dPolygon.xpoints[dPolygon.npoints - 1]), point);
                        if (this.mousePoint != null) {
                            graphics.drawLine(point.x, point.y, this.mousePoint.x, this.mousePoint.y);
                        }
                    }
                    if (mouseEvent.isMetaDown() || (mouseEvent.getModifiers() & 4) == 4) {
                        if (dPolygon.npoints > 2) {
                            point = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[dPolygon.npoints - 1], dPolygon.xpoints[dPolygon.npoints - 1]), point);
                            Point point2 = new Point();
                            point2 = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[0], dPolygon.xpoints[0]), point2);
                            graphics.drawLine(point.x, point.y, point2.x, point2.y);
                            dPolygon.addPoint(dPolygon.ypoints[0], dPolygon.xpoints[0]);
                        }
                        GraphicPanel graphicPanel = this;
                        boolean bl4 = !graphicPanel.db.hasMenge();
                        GraphicPanel graphicPanel2 = this;
                        if (graphicPanel2.db.hasMenge()) {
                            this.graphicClip.drawMenge(this.g2, DataBase.MENGE);
                        }
                        int n3 = DataBase.buildMenge(dPolygon);
                        this.graphicClip.drawMenge(this.g2, DataBase.MENGE);
                        graphics.setColor(Color.white);
                        graphics.setXORMode(Color.magenta);
                        this.graphicClip.drawDPolygon(graphics, dPolygon);
                        this.markObject = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        GraphicPanel graphicPanel3 = this;
                        if (!graphicPanel3.db.hasMenge()) {
                            stringBuffer.append("Keine Menge gebildet");
                        } else if (bl4) {
                            stringBuffer.append("Neue Menge aus ");
                            stringBuffer.append(n3);
                            stringBuffer.append(" Punkt");
                            if (n3 != 1) {
                                stringBuffer.append("en");
                            }
                            stringBuffer.append(" gebildet.");
                        } else {
                            stringBuffer.append("Der Menge wurde");
                            if (n3 != 1) {
                                stringBuffer.append("n");
                            }
                            stringBuffer.append(" ");
                            stringBuffer.append(n3);
                            stringBuffer.append(" Punkt");
                            if (n3 != 1) {
                                stringBuffer.append("e");
                            }
                            stringBuffer.append(" hinzugef\u00fcgt.");
                        }
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1001, stringBuffer.toString()));
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1002, null));
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
                        break;
                    }
                    if (dPolygon.npoints > 0) {
                        point = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[dPolygon.npoints - 1], dPolygon.xpoints[dPolygon.npoints - 1]), point);
                        graphics.drawLine(point.x, point.y, mouseEvent.getX(), mouseEvent.getY());
                    }
                    DPoint dPoint = this.getPunkt(mouseEvent.getPoint());
                    dPolygon.addPoint(dPoint.y, dPoint.x);
                    this.mousePoint = null;
                    break;
                }
                case 7: {
                    if (!(this.markObject instanceof Plotbox)) {
                        Plotbox plotbox = new Plotbox();
                        this.g2.getDataPoint(mouseEvent.getPoint(), plotbox);
                        plotbox.orientation = this.g2.getRotation();
                        if (this.messageListener != null) {
                            this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox zoomen"));
                        }
                        this.markObject = plotbox;
                        break;
                    }
                    Plotbox plotbox = (Plotbox)this.markObject;
                    if (!mouseEvent.isMetaDown() && (mouseEvent.getModifiers() & 4) != 4) {
                        switch (plotbox.getMouseCommand()) {
                            case 1: {
                                plotbox.setMouseCommand(2);
                                if (this.messageListener == null) break;
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox bewegen"));
                                break;
                            }
                            case 2: {
                                plotbox.setMouseCommand(3);
                                if (this.messageListener == null) break;
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox drehen"));
                                break;
                            }
                            case 3: {
                                plotbox.setMouseCommand(0);
                                if (this.messageListener == null) break;
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox halten"));
                                break;
                            }
                            case 0: {
                                plotbox.setMouseCommand(1);
                                if (this.messageListener == null) break;
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox zoomen"));
                            }
                        }
                        break;
                    }
                    if (DataBase.PLOTBOX != null) {
                        DataBase.PLOTBOX.drawSymbol(this.g2, false);
                    }
                    DataBase.PLOTBOX = plotbox;
                    plotbox.drawSymbol(this.g2, true);
                    plotbox.drawSymbol(this.g2, false);
                    if (this.messageListener != null) {
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1001, "Plotbox erzeugt"));
                        this.messageListener.messagePerformed(new IMessageEvent(this, 1002, null));
                    }
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_update_plotbox"));
                    this.markObject = null;
                    break;
                }
                case 8: {
                    if (bl) {
                        return;
                    }
                    this.drawInputObject();
                    if (!mouseEvent.isMetaDown() && (mouseEvent.getModifiers() & 4) != 4 && this.inputObject != null) {
                        GeomElement geomElement;
                        int n4 = this.inputObject.need();
                        Object object = null;
                        if (object == null && (n4 & 0x400) != 0) {
                            geomElement = this.getPunkt(mouseEvent.getPoint());
                            Linie linie = this.getNearestLinie((DPoint)geomElement);
                            DLine.moveIn(linie.pa, linie.pe, geomElement);
                            object = geomElement;
                        }
                        if (object == null && (n4 & 0x100) != 0) {
                            object = this.getNearestLinie(this.getPunkt(mouseEvent.getPoint()));
                        }
                        if (object == null && (n4 & 0x40) != 0) {
                            object = this.getNearestPunkt(this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                        }
                        if (object == null && (n4 & 0x20) != 0) {
                            object = this.g2.getDataPoint(mouseEvent.getPoint(), new DPoint());
                        }
                        if (object == null && (n4 & 0x80) != 0 && this.questionListener != null) {
                            this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                        }
                        if (object == null && (n4 & 0x800) != 0) {
                            switch (KafPlotProperties.getEditObjectSwitch()) {
                                case 2201: {
                                    object = this.getNearestObject((DataContainerTable)DataBase.FLST, this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                                    break;
                                }
                                case 2204: {
                                    object = this.getNearestObject((DataContainerTable)DataBase.NUTZ, this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                                }
                            }
                        }
                        if (object == null) {
                            this.drawInputObject();
                            this.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, 10));
                            break;
                        }
                        if (object != null) {
                            this.inputObject.setObject(object, true);
                            if (this.inputObject.isFull()) {
                                InputProperties.saveObject(this.inputObject);
                                if (this.inputObject.dataMode() == 1) {
                                    geomElement = this.inputObject.getBounds();
                                    this.inputObject = null;
                                    if (KafPlotProperties.isPunktMoveStrukturVisible) {
                                        this.repaint();
                                    } else {
                                        this.repaint((DRectangle)geomElement);
                                    }
                                } else {
                                    this.repaint();
                                }
                                this.inputObject = null;
                            } else {
                                n4 = this.inputObject.need();
                                if ((n4 & 4) != 0 && this.questionListener != null) {
                                    this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                                }
                            }
                        }
                        this.drawInputObject();
                    } else if (this.inputObject != null) {
                        if (this.inputObject.isReady()) {
                            InputProperties.saveObject(this.inputObject);
                            if (this.inputObject.dataMode() == 1) {
                                this.repaint(this.inputObject.getBounds());
                            } else {
                                this.repaint();
                            }
                            if (this.questionListener != null) {
                                this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
                            }
                            if (InputProperties.getInputFangSwitch() == 901 && this.actionListener != null) {
                                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Punkte fangen"));
                            }
                            this.inputObject = null;
                        } else if (this.inputObject.isAbortable()) {
                            this.inputObject = null;
                            if (this.questionListener != null) {
                                this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
                            }
                            if (InputProperties.getInputFangSwitch() == 901 && this.actionListener != null) {
                                this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Punkte fangen"));
                            }
                            this.inputObject = null;
                        } else {
                            this.inputObject.setObject(null, true);
                            this.drawInputObject();
                        }
                    }
                    this.setCursor();
                    this.mousePressedPoint = null;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.inputObject != null && this.inputObject.isVoid()) {
            this.deleteInputObject();
        }
        Graphics graphics = this.getGraphics();
        if (this.markObject instanceof DPolygon && KafPlotProperties.getMouseSwitch() == 6) {
            DPolygon dPolygon = (DPolygon)this.markObject;
            if (dPolygon.npoints > 0) {
                Point point = new Point();
                point = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[dPolygon.npoints - 1], dPolygon.xpoints[dPolygon.npoints - 1]), point);
                graphics.setColor(Color.white);
                graphics.setXORMode(Color.magenta);
                if (this.mousePoint != null) {
                    graphics.drawLine(point.x, point.y, this.mousePoint.x, this.mousePoint.y);
                }
            }
        }
        this.mousePoint = null;
    }

    private Rectangle getSizedRectangle(Point point, Point point2, int n, int n2) {
        int n3 = point2.x - point.x;
        int n4 = Math.abs(n3 * n2 / n);
        if (point2.y - point.y < 0) {
            n4 = -n4;
        }
        return new Rectangle(n3 > 0 ? point.x : point2.x, n4 > 0 ? point.y : point.y + n4, Math.abs(n3), Math.abs(n4));
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (mouseWheelEvent.isShiftDown()) {
            double d = 0.0;
            double d2 = KafPlotProperties.getGrafikRotation();
            d = mouseWheelEvent.isAltDown() ? 0.003490658503988659 : (mouseWheelEvent.isControlDown() ? 0.15707963267948966 : 0.05235987755982988);
            d2 = n < 0 ? (d2 += d) : (d2 -= d);
            if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            }
            if (d2 < -Math.PI) {
                d2 += Math.PI * 2;
            }
            KafPlotProperties.setGrafikRotation(d2);
            if (this.graphicListener != null) {
                this.graphicListener.graphicUpdated(new GraphicEvent(this, 3009));
            }
        } else {
            double d = 1.0;
            double d3 = 1.0;
            d = mouseWheelEvent.isAltDown() ? 1.1 : (mouseWheelEvent.isControlDown() ? 5.0 : 2.0);
            d = Math.pow(d, (double)Math.abs(n) / 3.0);
            d3 = d * 0.75;
            if (n < 0) {
                this.zoomFaktor *= d;
                this.me *= d3;
            } else {
                this.zoomFaktor /= d;
                this.me /= d3;
            }
            if (this.mousePoint != null) {
                DPoint dPoint = this.g2.getDataPoint(this.mousePoint, new DPoint());
                Dimension dimension = this.getSize();
                double d4 = (double)Math.min(dimension.width, dimension.height) / Math.max(DataBase.xmax - DataBase.xmin, DataBase.ymax - DataBase.ymin) * this.zoomFaktor;
                GeoTransform geoTransform = new GeoTransform(-this.yM, -this.xM, this.YM, this.XM, KafPlotProperties.getGrafikRotation(), d4);
                DPoint dPoint2 = ((Transform)geoTransform).inverse(this.mousePoint, new DPoint());
                double d5 = dPoint.x - dPoint2.x;
                double d6 = dPoint.y - dPoint2.y;
                this.xM += d5;
                this.yM += d6;
            }
        }
        this.wheelRepainter.setTime();
        this.repaintQuick();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            this.mousePoint = mouseEvent.getPoint();
            Graphics graphics = this.getGraphics();
            this.g2.setGraphics(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                this.drawRect = new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
                this.g2.setDrawRect(this.drawRect);
            }
            if ((Math.abs(this.mousePressedPoint.y - mouseEvent.getY()) > 25 || Math.abs(this.mousePressedPoint.x - mouseEvent.getX()) > 25) && System.currentTimeMillis() - this.mousePressedTime > 250L) {
                if (mouseEvent.isShiftDown()) {
                    double d = Math.atan2(this.mousePressedPoint.x - this.XM, this.mousePressedPoint.y - this.YM);
                    double d2 = Math.atan2(mouseEvent.getPoint().x - this.XM, mouseEvent.getPoint().y - this.YM);
                    double d3 = d - d2;
                    double d4 = 1.0;
                    d4 = mouseEvent.isAltDown() ? 0.1 : (mouseEvent.isControlDown() ? 2.0 : 1.0);
                    double d5 = KafPlotProperties.getGrafikRotation() + d3 * d4;
                    if (d5 > Math.PI) {
                        d5 -= Math.PI * 2;
                    }
                    if (d5 < -Math.PI) {
                        d5 += Math.PI * 2;
                    }
                    KafPlotProperties.setGrafikRotation(d5);
                    if (this.graphicListener != null) {
                        this.graphicListener.graphicUpdated(new GraphicEvent(this, 3009));
                    }
                } else {
                    super.setCursor(Cursor.getPredefinedCursor(13));
                    DPoint dPoint = this.g2.getDataPoint(this.mousePressedPoint, new DPoint());
                    DPoint dPoint2 = this.g2.getDataPoint(mouseEvent.getPoint(), new DPoint());
                    double d = 1.0;
                    d = mouseEvent.isAltDown() ? 0.1 : (mouseEvent.isControlDown() ? 2.0 : 1.0);
                    this.yM += d * (dPoint.y - dPoint2.y);
                    this.xM += d * (dPoint.x - dPoint2.x);
                }
                this.mousePressedPoint.x = mouseEvent.getX();
                this.mousePressedPoint.y = mouseEvent.getY();
                this.mousePressedEventConsumed = true;
                this.mousePunkt = null;
                this.wheelRepainter.setTime();
                this.repaintQuick();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            Graphics graphics = this.getGraphics();
            this.g2.setGraphics(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                this.drawRect = new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
                this.g2.setDrawRect(this.drawRect);
            }
            block1 : switch (KafPlotProperties.getMouseSwitch()) {
                case 1: {
                    Object object = null;
                    switch (KafPlotProperties.getMarkSwitch()) {
                        case 601: {
                            object = this.getNearestPunkt(this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 604: {
                            object = this.getNearestLinie(this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 602: {
                            object = this.getNearestMessung(this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 603: {
                            object = this.getNearestBedingung(this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 605: {
                            if (!KafPlotProperties.isFlstVisible) break;
                            object = this.getNearestObject(DataBase.FLST, this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 606: {
                            if (!KafPlotProperties.isNutzVisible) break;
                            object = this.getNearestObject(DataBase.NUTZ, this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 607: {
                            if (!KafPlotProperties.isBodsVisible) break;
                            object = this.getNearestObject(DataBase.BODEN, this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 608: {
                            if (!KafPlotProperties.isGebaeudeVisible) break;
                            object = this.getNearestObject(DataBase.GEB, this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 609: {
                            if (!KafPlotProperties.isTopographieVisible) break;
                            object = this.getNearestObject(DataBase.TOP, this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 610: {
                            object = this.getNearestBemerkung(this.getPunkt(mouseEvent.getPoint()));
                            break;
                        }
                        case 611: {
                            object = this.getNearestImage(this.getPunkt(mouseEvent.getPoint()));
                        }
                    }
                    if (object == this.markObject || object == null) break;
                    this.drawMarkObject(this.getGraphics());
                    this.markObject = object;
                    this.drawMarkObject(this.getGraphics());
                    break;
                }
                case 5: {
                    Punkt punkt = KafPlotProperties.isMessFree() ? (Punkt)this.g2.getDataPoint(mouseEvent.getPoint(), new Punkt()) : this.getNearestPunkt(this.getPunkt(mouseEvent.getPoint()));
                    if (punkt == this.mousePunkt) break;
                    this.mousePunkt = punkt;
                    this.drawMarkObject();
                    switch (KafPlotProperties.getMessSwitch()) {
                        case 501: {
                            OrthoLinie orthoLinie;
                            if (this.markObject == null || !(this.markObject instanceof OrthoLinie)) {
                                this.markObject = new OrthoLinie();
                            }
                            if ((orthoLinie = (OrthoLinie)this.markObject).getEndPunkt() == null) {
                                orthoLinie.setAnfangsPunkt(this.mousePunkt);
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, this.mousePunkt.getMessage().getShortText()));
                            } else if (orthoLinie.size() == 0) {
                                orthoLinie.setEndPunkt(this.mousePunkt);
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, orthoLinie.getEndMessung().toMessageString()));
                            } else {
                                orthoLinie.setElementAt(this.mousePunkt, 0);
                                this.messageListener.messagePerformed(new IMessageEvent(this, 1001, orthoLinie.getMessungOf(this.mousePunkt).toMessageString()));
                            }
                            this.drawMarkObject();
                            break block1;
                        }
                        case 502: {
                            PolarAufnahme polarAufnahme;
                            if (this.markObject == null || !(this.markObject instanceof PolarAufnahme)) {
                                this.markObject = new PolarAufnahme(DataBase.getStreckeMasstab(this.mousePunkt.y));
                            }
                            if ((polarAufnahme = (PolarAufnahme)this.markObject).getAnschlussPunkt() == null) {
                                polarAufnahme.setStandPunkt(this.mousePunkt);
                            } else if (polarAufnahme.size() == 0) {
                                polarAufnahme.setAnschlussPunkt(this.mousePunkt);
                            } else {
                                polarAufnahme.setElementAt(this.mousePunkt, 0);
                            }
                            this.messageListener.messagePerformed(new IMessageEvent(this, 1001, polarAufnahme.getMessungOf(this.mousePunkt).toMessageString()));
                            this.drawMarkObject();
                            break block1;
                        }
                        case 503: {
                            if (this.markObject == null || !(this.markObject instanceof Bogen)) {
                                this.markObject = new Bogen();
                            }
                            Bogen bogen = (Bogen)this.markObject;
                            if (bogen.pe == null) {
                                bogen.pa = this.mousePunkt;
                            } else if (bogen.pm == null) {
                                bogen.pe = this.mousePunkt;
                            } else {
                                bogen.setBogenMitte(this.mousePunkt);
                            }
                            this.drawMarkObject(this.getGraphics());
                            break block1;
                        }
                        case 504: {
                            Flaeche flaeche;
                            if (this.markObject == null || !(this.markObject instanceof Flaeche)) {
                                flaeche = new Flaeche();
                                flaeche.addPoint(this.mousePunkt.y, this.mousePunkt.x);
                                this.markObject = flaeche;
                            }
                            flaeche = (Flaeche)this.markObject;
                            flaeche.xpoints[flaeche.npoints - 1] = this.mousePunkt.x;
                            flaeche.ypoints[flaeche.npoints - 1] = this.mousePunkt.y;
                            StringBuffer stringBuffer = new StringBuffer();
                            if (this.mousePunkt.nr > 0L) {
                                stringBuffer.append(this.mousePunkt.getMessage().getShortText());
                                stringBuffer.append("  , ");
                            }
                            stringBuffer.append("Fl\u00e4che aus ");
                            stringBuffer.append(Integer.toString(flaeche.npoints));
                            stringBuffer.append(" Punkten F= ");
                            stringBuffer.append(IFormat.f_3.format(Math.abs(flaeche.getArea() * DataBase.getFlaecheMasstab(flaeche.getCenter()))).toString());
                            this.messageListener.messagePerformed(new IMessageEvent(this, 1001, stringBuffer.toString()));
                            this.drawMarkObject();
                            break block1;
                        }
                        case 505: {
                            Linienzug linienzug;
                            if (this.markObject == null || !(this.markObject instanceof Linienzug)) {
                                linienzug = new Linienzug();
                                linienzug.addPoint(this.mousePunkt.y, this.mousePunkt.x);
                                this.markObject = linienzug;
                            }
                            linienzug = (Linienzug)this.markObject;
                            linienzug.xpoints[linienzug.npoints - 1] = this.mousePunkt.x;
                            linienzug.ypoints[linienzug.npoints - 1] = this.mousePunkt.y;
                            StringBuffer stringBuffer = new StringBuffer();
                            if (this.mousePunkt.nr > 0L) {
                                stringBuffer.append(this.mousePunkt.getMessage().getShortText());
                                stringBuffer.append("  , ");
                            }
                            stringBuffer.append("L\u00e4nge aus ");
                            stringBuffer.append(Integer.toString(linienzug.npoints));
                            stringBuffer.append(" Punkten L= ");
                            stringBuffer.append(IFormat.f_3.format(Math.abs(linienzug.getLength() * DataBase.getStreckeMasstab(linienzug.getCenter()))).toString());
                            this.messageListener.messagePerformed(new IMessageEvent(this, 1001, stringBuffer.toString()));
                            this.drawMarkObject();
                            break block1;
                        }
                    }
                    break;
                }
                case 6: {
                    if (!(this.markObject instanceof DPolygon)) break;
                    DPolygon dPolygon = (DPolygon)this.markObject;
                    if (dPolygon.npoints <= 0) break;
                    Point point = new Point();
                    point = this.g2.getGraphicPoint(new DPoint(dPolygon.ypoints[dPolygon.npoints - 1], dPolygon.xpoints[dPolygon.npoints - 1]), point);
                    graphics.setColor(Color.white);
                    graphics.setXORMode(Color.magenta);
                    if (this.mousePoint != null) {
                        graphics.drawLine(point.x, point.y, this.mousePoint.x, this.mousePoint.y);
                    }
                    graphics.drawLine(point.x, point.y, mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 7: {
                    if (!(this.markObject instanceof Plotbox)) break;
                    Plotbox plotbox = (Plotbox)this.markObject;
                    plotbox.drawSymbol(this.g2, true);
                    DPoint dPoint = new DPoint();
                    DPoint dPoint2 = new DPoint();
                    dPoint = this.g2.getDataPoint(mouseEvent.getPoint(), dPoint);
                    dPoint2 = this.mousePoint != null ? this.g2.getDataPoint(this.mousePoint, dPoint2) : dPoint;
                    switch (plotbox.getMouseCommand()) {
                        case 1: {
                            plotbox.width += (Math.sin(plotbox.orientation) * (dPoint.x - dPoint2.x) + Math.cos(plotbox.orientation) * (dPoint.y - dPoint2.y)) * 2.0;
                            plotbox.height -= (Math.cos(plotbox.orientation) * (dPoint.x - dPoint2.x) - Math.sin(plotbox.orientation) * (dPoint.y - dPoint2.y)) * 2.0;
                            double d = plotbox.height / 1.4802;
                            plotbox.width = (plotbox.width + d) / 2.0;
                            plotbox.height = plotbox.width * 1.4802;
                            break;
                        }
                        case 2: {
                            plotbox.x += dPoint.x - dPoint2.x;
                            plotbox.y += dPoint.y - dPoint2.y;
                            break;
                        }
                        case 3: {
                            plotbox.orientation += Math.atan2(plotbox.y - dPoint2.y, plotbox.x - dPoint2.x) - Math.atan2(plotbox.y - dPoint.y, plotbox.x - dPoint.x);
                        }
                    }
                    plotbox.drawSymbol(this.g2, true);
                    break;
                }
                case 8: {
                    InputObject inputObject = null;
                    switch (KafPlotProperties.getInputSwitch()) {
                        case 801: {
                            if (this.inputObject != null && this.inputObject instanceof InputPunkt) break;
                            inputObject = new InputPunkt();
                            break;
                        }
                        case 851: {
                            if (this.inputObject != null && this.inputObject instanceof InputLinieClip) break;
                            inputObject = new InputLinieClip();
                            break;
                        }
                        case 852: {
                            if (this.inputObject != null && this.inputObject instanceof InputLinieConnect) break;
                            inputObject = new InputLinieConnect();
                            break;
                        }
                        case 861: {
                            if (this.inputObject != null && this.inputObject instanceof InputObjectClip) break;
                            inputObject = new InputObjectClip();
                            break;
                        }
                        case 862: {
                            if (this.inputObject != null && this.inputObject instanceof InputObjectUnion) break;
                            inputObject = new InputObjectUnion();
                            break;
                        }
                        case 821: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == 270) break;
                            inputObject = new InputMessung(270);
                            break;
                        }
                        case 822: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == 230) break;
                            inputObject = new InputMessung(230);
                            break;
                        }
                        case 823: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == 210) break;
                            inputObject = new InputMessung(210);
                            break;
                        }
                        case 824: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == -100) break;
                            inputObject = new InputMessung(-100);
                            break;
                        }
                        case 825: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == 220) break;
                            inputObject = new InputMessung(220);
                            break;
                        }
                        case 826: {
                            if (this.inputObject != null && this.inputObject instanceof InputMessung && ((InputMessung)this.inputObject).getArt() == 260) break;
                            inputObject = new InputMessung(260);
                            break;
                        }
                        case 811: {
                            if (this.inputObject != null && this.inputObject instanceof Identitaet) break;
                            inputObject = new Identitaet(null, null, 1);
                            break;
                        }
                        case 812: {
                            if (this.inputObject != null && this.inputObject instanceof PunktMove) break;
                            inputObject = new PunktMove(null, 0.0f, 0.0f, 1);
                            break;
                        }
                        case 871: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 1) break;
                            inputObject = new InputBedingung(1);
                            break;
                        }
                        case 872: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 2) break;
                            inputObject = new InputBedingung(2);
                            break;
                        }
                        case 873: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 3) break;
                            inputObject = new InputBedingung(3);
                            break;
                        }
                        case 874: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 4) break;
                            inputObject = new InputBedingung(4);
                            break;
                        }
                        case 875: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 5) break;
                            inputObject = new InputBedingung(5);
                            break;
                        }
                        case 876: {
                            if (this.inputObject != null && this.inputObject instanceof InputBedingung && ((InputBedingung)this.inputObject).getArt() == 6) break;
                            inputObject = new InputBedingung(6);
                        }
                    }
                    if (inputObject != null && inputObject != this.inputObject) {
                        this.drawInputObject();
                        this.inputObject = inputObject;
                        this.drawInputObject();
                    }
                    if (this.inputObject == null) break;
                    int n = this.inputObject.need();
                    Object object = null;
                    if (this.inputObject.needInterface() == 1) {
                        if (object == null && (n & 0x400) != 0) {
                            DPoint dPoint = this.getPunkt(mouseEvent.getPoint());
                            Linie linie = this.getNearestLinie(dPoint);
                            DLine.moveIn(linie.pa, linie.pe, dPoint);
                            object = dPoint;
                        }
                        if (object == null && (n & 0x100) != 0) {
                            object = this.getNearestLinie(this.getPunkt(mouseEvent.getPoint()));
                        }
                        if (object == null && (n & 0x40) != 0) {
                            object = this.getNearestPunkt(this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                        }
                        if (object == null && (n & 0x20) != 0) {
                            object = this.g2.getDataPoint(mouseEvent.getPoint(), new DPoint());
                        }
                        if (object == null && (n & 0x800) != 0) {
                            switch (KafPlotProperties.getEditObjectSwitch()) {
                                case 2201: {
                                    object = this.getNearestObject((DataContainerTable)DataBase.FLST, this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                                    break;
                                }
                                case 2204: {
                                    object = this.getNearestObject((DataContainerTable)DataBase.NUTZ, this.getPunkt(mouseEvent.getPoint()), this.inputObject);
                                }
                            }
                        }
                    } else if (this.inputObject.needInterface() == 2 && this.questionListener != null) {
                        this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                    }
                    if (object == null || object.equals(this.inputObject.lastInput())) break;
                    this.drawInputObject();
                    this.inputObject.setObject(object, false);
                    this.drawInputObject();
                    if (this.messageListener == null) break;
                    this.messageListener.messagePerformed(new IMessageEvent(this, 1001, this.inputObject.getMessage().getShortText()));
                    break;
                }
            }
            this.mousePoint = mouseEvent.getPoint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void answerPerformed(Object object) {
        if (this.inputObject != null) {
            Object object2 = null;
            if (object != null) {
                int n = this.inputObject.need();
                switch (n) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 128: {
                        if (!(object instanceof Number)) break;
                        object2 = object;
                        break;
                    }
                    case 16: {
                        if (!(object instanceof String)) break;
                        object2 = object.toString();
                    }
                }
                this.drawInputObject();
                int n2 = this.inputObject.getStep();
                this.inputObject.setObject(object2, true);
                if (this.inputObject.getStep() > n2 && this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
                }
                if (this.inputObject.isFull()) {
                    InputProperties.saveObject(this.inputObject);
                    if (this.inputObject.dataMode() == 1) {
                        this.repaint(this.inputObject.getBounds());
                    } else {
                        this.repaint();
                    }
                    this.inputObject = null;
                } else {
                    this.drawInputObject();
                }
            } else if (this.inputObject.isAbortable()) {
                this.drawInputObject();
                this.inputObject = null;
                if (this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
                }
                if (InputProperties.getInputFangSwitch() == 901 && this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Punkte fangen"));
                }
                this.inputObject = null;
            } else {
                this.inputObject.setObject(null, true);
            }
            if (this.inputObject != null && this.inputObject.needInterface() == 2) {
                if (this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 1, new Question(this, this.inputObject.getMessage().getShortText(), this.inputObject.getDefault(), this.inputObject.format())));
                }
            } else {
                this.requestFocus();
                if (this.questionListener != null) {
                    this.questionListener.questionPerformed(new IQuestionEvent(this, 3, null));
                }
            }
        }
    }

    private class ViewProperties {
        private static final int SIZE = 20;
        ViewProperty[] props = new ViewProperty[20];
        int akt = -1;

        private ViewProperties(GraphicPanel graphicPanel) {
        }

        public void put(ViewProperty viewProperty) {
            for (int i = 0; i < 20; ++i) {
                if (this.props[i] == null || !this.props[i].equals(viewProperty)) continue;
                return;
            }
            this.akt = this.trim(++this.akt);
            this.props[this.akt] = viewProperty;
        }

        public ViewProperty next() {
            if (this.props[this.trim(this.akt + 1)] != null) {
                this.akt = this.trim(this.akt + 1);
                return this.props[this.akt];
            }
            return null;
        }

        public ViewProperty before() {
            if (this.props[this.trim(this.akt - 1)] != null) {
                this.akt = this.trim(this.akt - 1);
                return this.props[this.akt];
            }
            return null;
        }

        private int trim(int n) {
            while (n >= 20) {
                n -= 20;
            }
            while (n < 0) {
                n += 20;
            }
            return n;
        }
    }

    private class WheelRepainter
    extends Thread {
        long time = 0L;
        boolean wait = false;

        private WheelRepainter() {
        }

        public void setTime() {
            this.time = System.currentTimeMillis();
            this.wait = true;
        }

        @Override
        public final void run() {
            this.time = System.currentTimeMillis();
            while (true) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.wait || System.currentTimeMillis() - this.time <= 300L) continue;
                this.wait = false;
                GraphicPanel.this.repaint();
            }
        }
    }

    private class ViewProperty {
        public double z;
        public double x;
        public double y;

        public ViewProperty(GraphicPanel graphicPanel, double d, double d2, double d3) {
            this.z = d;
            this.x = d2;
            this.y = d3;
        }

        public boolean equals(Object object) {
            if (object instanceof ViewProperty) {
                ViewProperty viewProperty = (ViewProperty)object;
                return viewProperty.z == this.z && viewProperty.y == this.y && viewProperty.x == this.x;
            }
            return false;
        }

        public String toString() {
            return "ViewProperty: " + this.z + " " + this.y + " " + this.x;
        }
    }
}

