/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ElementInfoEvent;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.kafplot.BuchungsArt;
import de.geocalc.kafplot.Buchungsstelle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.EigentuemerArt;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.Grundbuchblatt;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.ObjectListSource;
import de.geocalc.kafplot.RechtsgemeinschaftsArt;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.lang.Exceptionable;
import de.geocalc.util.VoidEnumerator;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GrundbuchInfoDialog
extends ObjectInfoDialog
implements DataBaseListener,
ObjectListSource {
    private Label bezLabel;
    private Label blattLabel;
    private Label artLabel;
    private Label zusLabel;
    long time = 0L;

    public GrundbuchInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (Grundbuchblatt)null);
    }

    public GrundbuchInfoDialog(IFrame iFrame, String string, Grundbuchblatt grundbuchblatt) {
        super(iFrame, string, grundbuchblatt);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Grundbuchbezirk: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bezLabel = new Label("", 0);
        panel.add(this.bezLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.bezLabel, gridBagConstraints);
        label = new Label("Grundbuchblatt: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.blattLabel = new Label("", 0);
        panel.add(this.blattLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.blattLabel, gridBagConstraints);
        label = new Label("Blattart: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.artLabel = new Label("", 0);
        panel.add(this.artLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.artLabel, gridBagConstraints);
        label = new Label("Zus\u00e4tze: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.zusLabel = new Label("", 0);
        panel.add(this.zusLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.zusLabel, gridBagConstraints);
        return panel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(17);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("GbNummer", 0), new ITableCell("GbStelle", 0), new ITableCell("GbArt", 0), new ITableCell("NNr", 0), new ITableCell("EArt", 0), new ITableCell("GArt", 0), new ITableCell("Anteil", 0), new ITableCell("Name", 0), new ITableCell("Geburtsname", 0), new ITableCell("Geburtstag", 0), new ITableCell("PLZ", 0), new ITableCell("Ort", 0), new ITableCell("Adresse", 0), new ITableCell("PF", 0), new ITableCell("PLZ/PF", 0), new ITableCell("Land", 0), new ITableCell("Akt.", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        if (object instanceof Grundbuchblatt) {
            Grundbuchblatt grundbuchblatt = (Grundbuchblatt)object;
            this.table.removeLines();
            if (grundbuchblatt != null) {
                Enumeration enumeration = grundbuchblatt.elements();
                while (enumeration.hasMoreElements()) {
                    this.addObjectToTable((Name)enumeration.nextElement(), null);
                }
            }
        } else if (object instanceof Buchungsstelle) {
            this.table.removeLines();
            for (Buchungsstelle buchungsstelle = (Buchungsstelle)object; buchungsstelle != null; buchungsstelle = buchungsstelle.getNext()) {
                Grundbuchblatt grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(buchungsstelle.getGrundbuchblattName());
                if (grundbuchblatt == null) continue;
                Enumeration enumeration = grundbuchblatt.elements();
                while (enumeration.hasMoreElements()) {
                    this.addObjectToTable((Name)enumeration.nextElement(), buchungsstelle);
                }
            }
        }
        super.setObject(object);
    }

    public void setObjects(Enumeration enumeration) {
        Hashtable<Grundbuchblatt, Grundbuchblatt> hashtable = new Hashtable<Grundbuchblatt, Grundbuchblatt>();
        this.table.removeLines();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            Grundbuchblatt grundbuchblatt = null;
            if (e instanceof Flurstueck) {
                object = (Flurstueck)e;
                Object object2 = ((Flurstueck)object).hasBuchung() ? object : DataBase.FLST.getStammstueck((Flurstueck)object);
                if (object2 == null || !((Flurstueck)object2).hasBuchung() || hashtable.put(grundbuchblatt = (Grundbuchblatt)DataBase.BUCH.get(((Flurstueck)object2).getBuchung().getGrundbuchblattName()), grundbuchblatt) != null) continue;
                Enumeration enumeration2 = grundbuchblatt.elements();
                while (enumeration2.hasMoreElements()) {
                    this.addObjectToTable((Name)enumeration2.nextElement(), null);
                }
                continue;
            }
            if (e instanceof Grundbuchblatt) {
                grundbuchblatt = (Grundbuchblatt)e;
                object = grundbuchblatt.elements();
                while (object.hasMoreElements()) {
                    this.addObjectToTable((Name)object.nextElement(), null);
                }
                continue;
            }
            if (e instanceof Name) {
                object = (Name)e;
                this.addObjectToTable((Name)object, null);
                continue;
            }
            new Exception("fehlende Implementierung Buchungsstelle").printStackTrace();
        }
        this.table.sort(0);
        this.table.select(0);
        this.table.doLayout();
        this.table.requestFocus();
    }

    @Override
    public Enumeration getObjects() {
        if (this.object != null && this.object instanceof Grundbuchblatt) {
            String string = ((Grundbuchblatt)this.object).getKennzeichen();
            Vector<Flurstueck> vector = new Vector<Flurstueck>();
            Enumeration enumeration = DataBase.FLST.elements();
            while (enumeration.hasMoreElements()) {
                Flurstueck flurstueck = (Flurstueck)enumeration.nextElement();
                String string2 = flurstueck.hasBuchung() ? flurstueck.getBuchung().getGrundbuchblattName() : null;
                if (!string.equals(string2)) continue;
                vector.addElement(flurstueck);
            }
            return vector.elements();
        }
        return new VoidEnumerator();
    }

    @Override
    protected void showObject(Object object) {
        Exceptionable exceptionable;
        if (object instanceof Buchungsstelle) {
            exceptionable = (Buchungsstelle)object;
            object = DataBase.BUCH.get(((Buchungsstelle)exceptionable).getGrundbuchblattName());
        }
        exceptionable = null;
        if (object instanceof Grundbuchblatt) {
            exceptionable = (Grundbuchblatt)object;
        }
        this.bezLabel.setText(exceptionable != null && ((Grundbuchblatt)exceptionable).getBezirk() != 0 ? Integer.toString(((Grundbuchblatt)exceptionable).getBezirk()) : "");
        this.blattLabel.setText(exceptionable != null && ((Grundbuchblatt)exceptionable).hasBlatt() ? ((Grundbuchblatt)exceptionable).getBlatt() : "");
        this.artLabel.setText((String)(exceptionable != null && ((Grundbuchblatt)exceptionable).hasArt() ? ((Grundbuchblatt)exceptionable).getArt() + " (" + Grundbuchblatt.blattartName(((Grundbuchblatt)exceptionable).getArt()) + ")" : ""));
        this.zusLabel.setText(exceptionable != null && ((Grundbuchblatt)exceptionable).hasZusatz() ? ((Grundbuchblatt)exceptionable).getZusatz() : "");
    }

    protected void addObjectToTable(Name name, Buchungsstelle buchungsstelle) {
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(Grundbuchblatt.getBlatt(name.getGrundbuchblatt()), 10, true), new ITableCell(buchungsstelle != null ? buchungsstelle.getLaufendeNummer() : "", 10), new ITableCell(buchungsstelle != null ? buchungsstelle.getBuchungsArtAsString() : "", 10, true), new ITableCell(name.getKennzeichenAsString(), 10), new ITableCell(name.getArtAsString(), -10, true), new ITableCell(name.getGemeinschaftsArtAsString(), -10, true), new ITableCell(name.getAnteil(), 0), new ITableCell(name.getNameMitVertretung(), -10), new ITableCell(name.getGeburtName(), -10), new ITableCell(name.getGeburtDatum(), 10), new ITableCell(name.getPostleitzahlAsString(), -10), new ITableCell(name.getOrt(), -10), new ITableCell(name.getAdresse(), -10), new ITableCell(name.getPostfachAsString(), -10), new ITableCell(name.getPlzPfAsString(), -10), new ITableCell(name.getLandAsString(), -10), new ITableCell(name.getAktualitaetAsString(), -10)};
        this.table.addLine(new ITableLine(iTableCellArray, name));
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        if (iTableEvent.getID() != 2001) {
            Object object = iTableEvent.getContent();
            String string = iTableEvent.getText();
            if (object instanceof Name && iTableEvent.getClickCount() > 1 && this.elementListener != null && string != null && string.length() > 0) {
                Name name = (Name)object;
                try {
                    if (iTableEvent.getCol() == 0) {
                        Object object2 = DataBase.BUCH.get(name.getGrundbuchblatt());
                        if (object2 != null) {
                            this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), object2, iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                        }
                    } else if (iTableEvent.getCol() == 2) {
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), BuchungsArt.getBuchungsArt(Integer.parseInt(string)), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    } else if (iTableEvent.getCol() == 4) {
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), EigentuemerArt.getEigentuemerArt(Integer.parseInt(string)), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    } else if (iTableEvent.getCol() == 5) {
                        this.elementListener.elementClicked(new ElementInfoEvent(iTableEvent.getSource(), RechtsgemeinschaftsArt.getRechtsgemeinschaftsArt(Integer.parseInt(string)), iTableEvent.getID(), iTableEvent.getClickCount(), iTableEvent.getModifiers()));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

