/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IException;
import de.geocalc.geodata.Feature;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Name;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.kpv.KpvIOProperties;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Comparable;
import de.geocalc.util.IntegerHashObject;
import de.geocalc.util.ListAttribute;
import de.geocalc.util.ListAttributeEnumerator;
import de.geocalc.xml.Node;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Grundbuchblatt
extends DataContainer
implements DatObject,
Comparable,
Exceptionable,
IntegerHashObject,
Feature {
    public static final String DELIM = ",";
    private static final Hashtable<Integer, String> blattarten = new Hashtable();
    private static final int BEZIRK_LENGTH = 6;
    private static final int BLATT_LENGTH = 7;
    private static final int KENN_LENGTH = 13;
    private static final int FLAG_READ = 2;
    private int art = 0;
    private int flags = 0;
    private String kennzeichen = "";
    private String zusatz;
    protected ListAttribute att;
    private static final int MIN_H = 0;
    private static final int MAX_H = 255;
    private static final int RANGE_H = 255;
    private static final int DIF_H = 76;
    private static final int MIN_S = 31;
    private static final int MAX_S = 180;
    private static final int DIF_S = 21;
    private static final int RANGE_S = 149;
    private static final int MIN_V = 220;
    private static final int MAX_V = 256;
    private static final int DIF_V = 3;
    private static final int RANGE_V = 36;

    public static String blattartName(int n) {
        String string = blattarten.get(n);
        return string != null ? string : "undefiniert";
    }

    public static int getBezirk(String string) {
        return string.length() > 7 ? Integer.parseInt(string.substring(0, 6)) : 0;
    }

    public static String getBlatt(String string) {
        return string.length() > 7 ? string.substring(6) : string;
    }

    public static String createKennzeichen(int n, int n2) {
        return IFormat.i06.format(n) + IFormat.i07.format(n2);
    }

    public static String createKennzeichen(String string) throws Exception {
        if (string == null || string.length() == 0) {
            throw new Exception("leeres Grundbuchkennzeichen");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-/\\.");
        int n = stringTokenizer.countTokens();
        String string2 = "";
        String string3 = "";
        if (n == 1) {
            if (string.length() == 13) {
                return string;
            }
            if (string.length() < 7) {
                string3 = string;
            } else {
                string2 = string.substring(0, 6);
                string3 = string.substring(6);
            }
        } else {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        if (string2.length() > 0 && !IFormat.hasOnlyNumbers(string2)) {
            throw new Exception("Grundbuchbezirk ist nicht numerisch: " + string2);
        }
        if (string2.length() > 6) {
            throw new Exception("Grundbuchbezirk enth\u00e4lt zu viele Zeichen: " + string2);
        }
        if (string3.length() > 7) {
            throw new Exception("Grundbuchblatt enth\u00e4lt zu viele Zeichen: " + string3);
        }
        return IFormat.getRightString(string2, 6, '0') + IFormat.getRightString(string3, 7, '0');
    }

    public Grundbuchblatt() {
    }

    public Grundbuchblatt(String string) throws Exception {
        this.kennzeichen = Grundbuchblatt.createKennzeichen(string);
    }

    public static String createDatLineKennzeichen(String string) {
        int n = string.length();
        if (n <= 7) {
            return string;
        }
        return string.substring(0, 6) + "/" + string.substring(6);
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void initGeom() {
    }

    public void addElement(Name name) throws Exception {
        if (this.contains(name)) {
            throw new Exception("Name: " + String.valueOf(name) + " ist schon vorhanden");
        }
        super.addElement(name);
    }

    public void setRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isRead() {
        return (this.flags & 2) != 0;
    }

    @Override
    public String getName() {
        return this.getKennzeichen();
    }

    @Override
    public Color getColor() {
        if (super.getColor() == null) {
            return Grundbuchblatt.getColor(this.getBlatt());
        }
        return super.getColor();
    }

    public static Color getColor(String string) {
        int n = Integer.parseInt(IFormat.getNumbers(string));
        float f = (float)(0 + n * 76 % 255) / 255.0f;
        float f2 = (float)(31 + n * 21 % 149) / 255.0f;
        float f3 = (float)(220 + n * 3 % 36) / 255.0f;
        return Color.getHSBColor(f, f2, f3);
    }

    public void setKennzeichen(String string) throws Exception {
        this.kennzeichen = Grundbuchblatt.createKennzeichen(string);
    }

    public String getKennzeichen() {
        return this.kennzeichen;
    }

    public boolean hasBezirk() {
        return this.kennzeichen.length() > 7;
    }

    public int getBezirk() {
        return this.hasBezirk() ? Integer.parseInt(this.kennzeichen.substring(0, 6)) : 0;
    }

    public boolean hasBlatt() {
        return this.kennzeichen.length() > 0;
    }

    public String getBlatt() {
        return this.hasBezirk() ? this.kennzeichen.substring(6) : this.kennzeichen;
    }

    public String getBlattAsString() {
        return IFormat.trimLeft(this.getBlatt(), '0');
    }

    public boolean hasArt() {
        return this.art != 0;
    }

    public void setArt(int n) {
        this.art = n;
    }

    public int getArt() {
        return this.art;
    }

    public boolean hasZusatz() {
        return this.zusatz != null;
    }

    public String getZusatz() {
        return this.zusatz;
    }

    public void setZusatz(String string) {
        this.zusatz = string;
    }

    public void appendZusatz(String string) {
        this.zusatz = this.zusatz == null ? string : this.zusatz + ";" + string;
    }

    public boolean equals(Object object) {
        if (object instanceof Grundbuchblatt) {
            Grundbuchblatt grundbuchblatt = (Grundbuchblatt)object;
            return this.getKennzeichen().equals(grundbuchblatt.getKennzeichen());
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        Grundbuchblatt grundbuchblatt = (Grundbuchblatt)object;
        return this.getKennzeichen().compareTo(grundbuchblatt.getKennzeichen());
    }

    public int hashCode() {
        return this.getKennzeichen().hashCode();
    }

    @Override
    public int intHashKey() {
        return this.getKennzeichen().hashCode();
    }

    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getKennzeichen());
        return new Message(this, stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Bestand";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getKennzeichen());
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public Object getAttribute(String string) {
        for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
            if (!listAttribute.getName().equals(string)) continue;
            return listAttribute.getValue();
        }
        return null;
    }

    @Override
    public Object setAttribute(String string, Object object) {
        if (this.att == null) {
            this.att = new ListAttribute(string, object);
        } else {
            for (ListAttribute listAttribute = this.att; listAttribute != null; listAttribute = listAttribute.getNext()) {
                if (listAttribute.getName().equals(string)) {
                    Object object2 = listAttribute.getValue();
                    listAttribute.setValue(object);
                    return object2;
                }
                if (listAttribute.getNext() != null) continue;
                listAttribute.setNext(new ListAttribute(string, object));
                return null;
            }
        }
        return null;
    }

    @Override
    public Object removeAttribute(String string) {
        if (this.att.getName().equals(string)) {
            Object object = this.att.getValue();
            this.att = this.att.getNext();
            return object;
        }
        ListAttribute listAttribute = this.att;
        for (ListAttribute listAttribute2 = this.att.getNext(); listAttribute2 != null; listAttribute2 = listAttribute2.getNext()) {
            if (listAttribute2.getName().equals(string)) {
                listAttribute.setNext(listAttribute2.getNext());
                return listAttribute2.getValue();
            }
            listAttribute = listAttribute2;
        }
        return null;
    }

    @Override
    public Enumeration attributes() {
        return new ListAttributeEnumerator(this.att);
    }

    @Override
    public boolean hasAttributes() {
        return this.att != null;
    }

    public static DataContainer parseDatLine(String string) throws IException {
        Grundbuchblatt grundbuchblatt = new Grundbuchblatt();
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    if (n == 0 && Character.isDigit(string2.charAt(0))) {
                        grundbuchblatt.setKennzeichen(string2);
                    } else {
                        int n2 = string2.indexOf(61);
                        String string3 = string2.substring(0, n2);
                        String string4 = string2.substring(n2 + 1);
                        if (string3.equalsIgnoreCase("A")) {
                            grundbuchblatt.setArt(Integer.parseInt(string4));
                        } else if (string3.equalsIgnoreCase("Z")) {
                            grundbuchblatt.setZusatz(string4.replace('_', ' '));
                        } else if (string3.equalsIgnoreCase("C")) {
                            grundbuchblatt.setColor(IFormat.parseColor(string4));
                        } else {
                            throw new IException("unzul\u00e4ssige Variable: " + string3);
                        }
                    }
                    ++n;
                }
                catch (Exception exception) {
                    throw new IException("unzul\u00e4ssige Zeichen in Zeichenkette: " + string2);
                }
            }
        }
        return grundbuchblatt;
    }

    @Override
    public final String toDatLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Gbbl:");
        stringBuffer.append(" ");
        stringBuffer.append(Grundbuchblatt.createDatLineKennzeichen(this.getKennzeichen()));
        if (this.getZusatz() != null) {
            stringBuffer.append(" Z=");
            stringBuffer.append(this.getZusatz().replace(' ', '_'));
        }
        if (super.getColor() != null) {
            stringBuffer.append(" C=");
            stringBuffer.append(IFormat.colorString(super.getColor()));
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(IFormat.EOL);
            stringBuffer.append(((Name)enumeration.nextElement()).toDatLine());
        }
        return stringBuffer.toString();
    }

    public Node toGml() throws Exception {
        Node node = new Node("Flurstueck");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            node.addNode(((Name)enumeration.nextElement()).toGml());
        }
        return node;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        KafPlotIOConstants.writeString(dataOutput, this.getKennzeichen());
        KafPlotIOConstants.writeString(dataOutput, this.getZusatz());
        dataOutput.writeInt(this.flags);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            dataOutput.writeByte(58);
            ((Name)enumeration.nextElement()).writeObject(dataOutput);
        }
        dataOutput.writeByte(0);
    }

    public static Grundbuchblatt readObject(DataInput dataInput) throws IOException {
        Grundbuchblatt grundbuchblatt = new Grundbuchblatt();
        try {
            if (KpvIOProperties.RVER >= 200) {
                grundbuchblatt.setKennzeichen(KafPlotIOConstants.readString(dataInput));
            } else {
                grundbuchblatt.setKennzeichen(Integer.toString(dataInput.readInt()) + Integer.toString(dataInput.readInt()));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        grundbuchblatt.zusatz = KafPlotIOConstants.readString(dataInput);
        grundbuchblatt.flags = dataInput.readInt();
        byte by = 0;
        while ((by = dataInput.readByte()) != -1 && by == 58) {
            try {
                grundbuchblatt.addElement(Name.readObject(dataInput));
            }
            catch (Exception exception) {}
        }
        return grundbuchblatt;
    }

    public final String toHumanString() {
        return this.toHumanString("\n");
    }

    public final String toHumanString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GB: ");
        stringBuffer.append(IFormat.trimLeft(Grundbuchblatt.getBlatt(this.kennzeichen), '0'));
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string);
            stringBuffer.append(((Name)enumeration.nextElement()).toHumanString(string));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C!Gbbl:");
        stringBuffer.append(" ");
        stringBuffer.append(this.getKennzeichen());
        return stringBuffer.toString();
    }

    static {
        blattarten.put(1000, "Grundbuchblatt");
        blattarten.put(2000, "Katasterblatt");
        blattarten.put(3000, "Pseudoblatt");
        blattarten.put(5000, "Fiktives Blatt");
    }
}

