/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DatObject;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.HoeheGewicht;
import de.geocalc.kafplot.IdentitaetUtil;
import de.geocalc.kafplot.KafPlotColor;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.LinieForm;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.PunktContainer;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktTable;
import de.geocalc.kafplot.TagObject;
import de.geocalc.kafplot.io.KafPlotIOConstants;
import de.geocalc.kafplot.io.dat.KafkaIOProperties;
import de.geocalc.lang.Control;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.sml.Tag;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Hoehe
implements Cloneable,
PunktContainer,
Exceptionable,
Drawable,
Control,
Messager,
DatObject,
TagObject {
    public static final byte NIVELLEMENT = 1;
    public static final byte TRIG = 2;
    public static final byte ZENIT = 3;
    public static final int FLAG_ON = 2;
    protected byte ha;
    protected byte mNr;
    protected Punkt ps;
    protected Punkt pz;
    protected double l1;
    protected double l2;
    protected float g1;
    protected float g2;
    protected float dz;
    protected String bemerkung;
    protected int flags;
    protected Hoehe referenz;
    protected HoeheGewicht gewicht;
    private static final double S_LIM = 1.0;
    private static final int PFT = 12;
    private static final int PFL = 10;
    private static final int PFB = 5;
    private static final int R = 4;
    private static final int PPFT = 7;
    private static final int PPFL = 20;
    private static final int PPFB = 2;
    private static final int PR = 3;

    public Hoehe() {
        this.setOn(true);
    }

    public void setArt(byte by) {
        this.ha = by;
    }

    public byte getArt() {
        return this.ha;
    }

    public void setPs(Punkt punkt) {
        this.ps = punkt;
    }

    public Punkt getPs() {
        return this.ps;
    }

    public void setPz(Punkt punkt) {
        this.pz = punkt;
    }

    public Punkt getPz() {
        return this.pz;
    }

    public void setL1(double d) {
        this.l1 = d;
    }

    public double getL1() {
        return this.l1;
    }

    public void setL2(double d) {
        this.l2 = d;
    }

    public double getL2() {
        return this.l2;
    }

    public void setG1(float f) {
        this.g1 = f;
    }

    public float getG1() {
        return this.g1;
    }

    public void setG2(float f) {
        this.g2 = f;
    }

    public float getG2() {
        return this.g2;
    }

    public void setDz(float f) {
        this.dz = f;
    }

    public float getDz() {
        return this.dz;
    }

    public boolean hasReferenz() {
        return this.referenz != null;
    }

    public void setReferenz(Hoehe hoehe) {
        this.referenz = hoehe;
    }

    public Hoehe getReferenz() {
        return this.referenz;
    }

    @Override
    public void setOn(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public boolean isOn() {
        return (this.flags & 2) != 0;
    }

    public boolean hasText() {
        return this.bemerkung != null && this.getText() != null;
    }

    public String getText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (this.bemerkung.indexOf(60) < 0 || this.bemerkung.indexOf(62) < 0) {
            return this.bemerkung;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.bemerkung.length();
        boolean bl = false;
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            char c2 = this.bemerkung.charAt(i);
            if (c2 == '<' && i < n - 1 && this.bemerkung.charAt(i + 1) != ' ') {
                bl = true;
            } else if (bl && c2 == '>' && c != ' ') {
                bl = false;
            } else if (!(bl || c2 == ' ' && c == ' ')) {
                stringBuffer.append(c2);
            }
            c = c2;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public final boolean hasBemerkung() {
        return this.bemerkung != null;
    }

    @Override
    public final void setBemerkung(String string) {
        this.bemerkung = string;
    }

    @Override
    public final void addBemerkung(String string) {
        this.bemerkung = this.bemerkung == null ? string : this.bemerkung + string;
    }

    @Override
    public final void addTag(String string) {
        this.bemerkung = this.bemerkung == null ? string : string + this.bemerkung;
    }

    @Override
    public final boolean hasTag(String string) {
        return this.bemerkung != null && Tag.hasTag(this.bemerkung, string);
    }

    @Override
    public final String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public final String getBemerkungText() {
        if (this.bemerkung == null) {
            return null;
        }
        if (Tag.hasTag(this.bemerkung)) {
            return Tag.parseText(this.bemerkung);
        }
        return this.bemerkung;
    }

    @Override
    public Message getMessage() {
        String string = this.getExceptionableName();
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        switch (this.ha) {
            case 1: {
                stringBuffer2.append(" dh = ");
                stringBuffer2.append(IFormat.f_4.format(this.l1));
                stringBuffer2.append(" s = ");
                stringBuffer2.append(IFormat.f_3.format(this.l2));
                stringBuffer2.append("[km]");
                break;
            }
            case 2: {
                stringBuffer2.append(" dh = ");
                stringBuffer2.append(IFormat.f_4.format(this.l1));
                stringBuffer2.append(" s = ");
                stringBuffer2.append(IFormat.f_3.format(this.l2));
                if ((double)this.dz == 0.0) break;
                stringBuffer2.append(" dz = ");
                stringBuffer2.append(IFormat.f_3.format(this.dz));
                break;
            }
            case 3: {
                stringBuffer2.append(" z = ");
                stringBuffer2.append(IFormat.f_4.format(this.l1));
                if (this.l2 != 0.0) {
                    stringBuffer2.append(" s = ");
                    stringBuffer2.append(IFormat.f_3.format(this.l2));
                }
                if ((double)this.dz == 0.0) break;
                stringBuffer2.append(" dz = ");
                stringBuffer2.append(IFormat.f_3.format(this.dz));
            }
        }
        if (!this.isOn()) {
            stringBuffer.append(" (aus)");
            stringBuffer2.append(" (aus)");
        }
        return new Message(this, stringBuffer.toString(), stringBuffer2.toString());
    }

    @Override
    public final String getClassName() {
        switch (this.ha) {
            case 1: {
                return "geometrischer H\u00f6henunterschied";
            }
            case 2: {
                return "trigonometrischer H\u00f6henunterschied";
            }
            case 3: {
                return "Zenitdistanz";
            }
        }
        return "H\u00f6he";
    }

    @Override
    public final String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ps != null && this.ps.nr != 0L) {
            stringBuffer.append(IFormat.i.format(this.ps.nr).toString());
        }
        if (this.pz != null && this.pz.nr != 0L) {
            stringBuffer.append("-");
            stringBuffer.append(IFormat.i.format(this.pz.nr).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public final String toDebugString() {
        return this.getExceptionableName();
    }

    @Override
    public String toDatLine() {
        Punkt punkt;
        IdentitaetUtil identitaetUtil;
        if (KafkaIOProperties.datVersion < 2) {
            return "C keine Unterst\u00fctzung von H\u00f6hen in dieser Dat-Version";
        }
        String string = this.bemerkung;
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.isOn()) {
            stringBuffer.append(IFormat.i1.format(this.ha));
            stringBuffer.append(" ");
        } else {
            stringBuffer.append('C');
            stringBuffer.append(IFormat.i1.format(this.ha));
        }
        stringBuffer.append(" ");
        if (this.ps != null && this.ps.nr > 0L) {
            identitaetUtil = new IdentitaetUtil(this.ps, string, 1, !KafkaIOProperties.writeOffline);
            punkt = identitaetUtil.getPunkt();
            string = identitaetUtil.getBem();
            stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
        } else {
            stringBuffer.append("              ");
        }
        stringBuffer.append(" ");
        if (this.pz != null && this.pz.nr > 0L) {
            identitaetUtil = new IdentitaetUtil(this.pz, string, 2, !KafkaIOProperties.writeOffline);
            punkt = identitaetUtil.getPunkt();
            string = identitaetUtil.getBem();
            stringBuffer.append(IFormat.i14.format(punkt.buildKatNr(KafkaIOProperties.pnrModus, KafkaIOProperties.writeUmnum ? punkt.getNr() : punkt.nr)));
        } else {
            stringBuffer.append("              ");
        }
        if (this.l1 != 0.0) {
            stringBuffer.append(IFormat.f6_4.format(this.l1));
        } else {
            stringBuffer.append("           ");
        }
        if (this.l2 != 0.0) {
            stringBuffer.append(IFormat.f6_4.format(this.l2));
        } else {
            stringBuffer.append("           ");
        }
        if (this.g1 != 0.0f) {
            stringBuffer.append(IFormat.f3_3.format(this.g1));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.g2 != 0.0f) {
            stringBuffer.append(IFormat.f3_3.format(this.g2));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (this.dz != 0.0f) {
            stringBuffer.append(IFormat.f3_3.format(this.dz));
        } else {
            stringBuffer.append("       ");
        }
        stringBuffer.append(" ");
        if (string != null) {
            stringBuffer.append("                     ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(13);
        dataOutput.writeByte(this.ha);
        dataOutput.writeByte(this.mNr);
        PunktNummer.writeObject(this.ps != null ? this.ps.nr : 0L, dataOutput);
        PunktNummer.writeObject(this.pz != null ? this.pz.nr : 0L, dataOutput);
        if (this.l1 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l1);
        } else {
            dataOutput.writeByte(0);
        }
        if (this.l2 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat((float)this.l2);
        } else {
            dataOutput.writeByte(0);
        }
        if ((double)this.g1 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.g1);
        } else {
            dataOutput.writeByte(0);
        }
        if ((double)this.g2 != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.g2);
        } else {
            dataOutput.writeByte(0);
        }
        if ((double)this.dz != 0.0) {
            dataOutput.writeByte(7);
            dataOutput.writeFloat(this.dz);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeInt(this.flags);
        KafPlotIOConstants.writeString(dataOutput, this.bemerkung);
    }

    public static Hoehe readObject(DataInput dataInput) throws IOException {
        Hoehe hoehe = new Hoehe();
        hoehe.ha = dataInput.readByte();
        hoehe.mNr = dataInput.readByte();
        hoehe.ps = new Punkt(PunktNummer.readObject(dataInput));
        hoehe.pz = new Punkt(PunktNummer.readObject(dataInput));
        if (dataInput.readByte() != 0) {
            hoehe.l1 = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            hoehe.l2 = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            hoehe.g1 = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            hoehe.g2 = dataInput.readFloat();
        }
        if (dataInput.readByte() != 0) {
            hoehe.dz = dataInput.readFloat();
        }
        hoehe.flags = dataInput.readInt();
        hoehe.bemerkung = KafPlotIOConstants.readString(dataInput);
        return hoehe;
    }

    @Override
    public boolean contains(Punkt punkt) {
        return this.ps != null && this.ps.nr == punkt.nr || this.pz != null && this.pz.nr == punkt.nr;
    }

    @Override
    public PunktTable getPunkte() {
        PunktTable punktTable = new PunktTable();
        if (this.ps != null) {
            punktTable.put(this.ps);
        }
        if (this.pz != null) {
            punktTable.put(this.pz);
        }
        return punktTable;
    }

    @Override
    public DRectangle getBounds() {
        if (this.pz != null && this.ps != null) {
            return new DRectangle(Math.min(this.ps.y, this.pz.y), Math.min(this.ps.x, this.pz.x), Math.abs(this.ps.y - this.pz.y), Math.abs(this.ps.x - this.pz.x));
        }
        if (this.pz == null) {
            if (this.ps == null) {
                return null;
            }
            return new DRectangle(this.ps.y, this.ps.x, 0.0, 0.0);
        }
        return new DRectangle(this.pz.y, this.pz.x, 0.0, 0.0);
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isVisible() {
        return this.ha == 1 && KafPlotProperties.isNivellementVisible() || KafPlotProperties.isZenitVisible();
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        switch (this.ha) {
            case 1: {
                return DPoint.getMiddle(this.ps != null ? this.ps : this.referenz.ps, this.pz);
            }
            case 2: 
            case 3: {
                Punkt punkt;
                Punkt punkt2 = this.ps != null ? this.ps : (punkt = this.referenz.ps != null ? this.referenz.ps : null);
                if (punkt == null) {
                    return this.pz;
                }
                double d = Math.sqrt((punkt.x - this.pz.x) * (punkt.x - this.pz.x) + (punkt.y - this.pz.y) * (punkt.y - this.pz.y));
                return new DPoint(this.pz.y + (punkt.y - this.pz.y) / d * 0.05 * (double)(this.mNr + 1), this.pz.x + (punkt.x - this.pz.x) / d * 0.05 * (double)(this.mNr + 1));
            }
        }
        return this.ps != null ? this.ps : this.pz;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        this.drawForeground(iGraphics, bl, bl2);
        if (bl2) {
            if (this.ps != null && this.ps.nr != 0L) {
                this.ps.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.pz != null && this.pz.nr != 0L) {
                this.pz.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.referenz != null) {
                this.referenz.drawForeground(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Punkt punkt;
        Graphics graphics = iGraphics.getGraphics();
        Punkt punkt2 = punkt = this.ps != null ? this.ps : this.getReferenz().ps;
        if (bl2) {
            iGraphics.setXORMode(Color.magenta);
        } else {
            iGraphics.setPaintMode(this.isOn() ? KafPlotProperties.mmaColor.getColor(new Integer(30 + this.ha)) : KafPlotColor.OFFLINE);
        }
        switch (this.ha) {
            case 1: {
                if (bl) {
                    iGraphics.drawLine(punkt, this.pz, LinieForm.LINIENFORM_STRICH_STRICH, false);
                    break;
                }
                iGraphics.drawLine(punkt, this.pz);
                break;
            }
            default: {
                if (this.pz.isStandHoehe()) {
                    iGraphics.drawLine(punkt, this.pz);
                }
                this.drawAufnahmePfeil(iGraphics, punkt, this.pz, bl2);
            }
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    private void drawAufnahmePfeil(IGraphics iGraphics, DPoint dPoint, DPoint dPoint2, boolean bl) {
        if (!iGraphics.contains(dPoint2)) {
            return;
        }
        Graphics graphics = iGraphics.getGraphics();
        double d = DLine.getOrientation(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x) + iGraphics.getRotation() - 1.5707963267948966;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 10 * this.mNr;
        Point point = iGraphics.getGraphicPoint(dPoint2, new Point());
        Point point2 = new Point(point.x - (int)Math.rint(d2 * (double)(4 + n)), point.y - (int)Math.rint(d3 * (double)(4 + n)));
        Point point3 = new Point(point.x - (int)Math.rint(d2 * (double)(16 + n) + d3 * 5.0), point.y - (int)Math.rint(d3 * (double)(16 + n) - d2 * 5.0));
        Point point4 = new Point(point.x - (int)Math.rint(d2 * (double)(16 + n) - d3 * 5.0), point.y - (int)Math.rint(d3 * (double)(16 + n) + d2 * 5.0));
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        graphics.drawLine(point2.x, point2.y, point4.x, point4.y);
    }
}

