/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IColor;
import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DDimension;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.LongHashObject;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;

public final class Identitaet
extends InputObject
implements LongHashObject,
Exceptionable,
Messager,
Drawable {
    private Punkt p1;
    private Punkt p2;
    private static final Point gps = new Point();
    private static final Point gpz = new Point();
    private static final int PFL = 7;
    private static final int PFB = 5;

    public Identitaet(Punkt punkt, Punkt punkt2, int n) {
        this.setP1(punkt);
        this.setP2(punkt2);
        this.setOperation(n);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return 2;
    }

    @Override
    public int need() {
        return 64;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
        if (n == 0) {
            this.p1 = (Punkt)object;
        } else if (n == 1) {
            this.p2 = (Punkt)object;
        }
        this.lastIn = object;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (this.step == 0) {
            this.p1 = (Punkt)object;
        } else if (this.step == 1) {
            this.p2 = (Punkt)object;
        }
        if (bl) {
            ++this.step;
        }
        this.lastIn = object;
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void setP1(Punkt punkt) {
        this.p1 = punkt;
    }

    public Punkt getP1() {
        return this.p1;
    }

    public void setP2(Punkt punkt) {
        this.p2 = punkt;
    }

    public Punkt getP2() {
        return this.p2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Identitaet) {
            Identitaet identitaet = (Identitaet)object;
            if (this.p1 != null) {
                if (this.p2 != null) {
                    return this.p1.equals(identitaet.p1) && this.p2.equals(identitaet.p2) || this.p1.equals(identitaet.p2) && this.p2.equals(identitaet.p1);
                }
                return this.p1.equals(identitaet.p1) && this.p2 == null && identitaet.p2 == null;
            }
            return false;
        }
        return false;
    }

    @Override
    public long longHashKey() {
        if (this.p1 == null) {
            return 0L;
        }
        return this.p1.longHashKey();
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isReady()) {
            if (this.step == 0) {
                stringBuffer.append("Istpunkt: ");
                if (this.p1 != null) {
                    stringBuffer.append(this.p1.nr);
                }
            } else {
                stringBuffer.append("Sollpunkt: ");
                if (this.p2 != null) {
                    stringBuffer.append(this.p2.nr);
                    stringBuffer.append(" [");
                    stringBuffer.append(IFormat.f_3.format(DataBase.getStrecke(this.p1, this.p2)));
                    stringBuffer.append("]");
                }
            }
        } else if (this.p1 != null && this.p2 != null) {
            stringBuffer.append(this.getExceptionableName());
            stringBuffer.append(" [");
            stringBuffer.append(IFormat.f_3.format(DataBase.getStrecke(this.p1, this.p2)));
            stringBuffer.append("]");
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Identit\u00e4t";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.p1 != null && this.p1.nr > 0L) {
            stringBuffer.append(this.p1.nr);
        }
        if (this.p2 != null && this.p2.nr > 0L) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.p2.nr);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClassName() + ": " + this.getObjectName();
    }

    @Override
    public DRectangle getBounds() {
        if (this.p1 != null && this.p2 != null) {
            return new DRectangle(Math.min(this.p1.y, this.p2.y), Math.min(this.p1.x, this.p2.x), Math.abs(this.p1.y - this.p2.y), Math.abs(this.p1.x - this.p2.x));
        }
        return new DRectangle(this.p1.y, this.p1.x, 0.0, 0.0);
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        if (this.p1 != null && this.p2 != null) {
            return DPoint.getMiddle(this.p1, this.p2);
        }
        if (this.p1 != null) {
            return this.p1;
        }
        if (this.p2 != null) {
            return this.p2;
        }
        return null;
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.p1 == null || !this.isVisible() || !this.isViewable(iGraphics.getViewport())) {
            return;
        }
        if (bl2) {
            if (this.p1 != null) {
                this.p1.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
            if (this.p2 != null) {
                this.p2.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
        }
        this.drawForeground(iGraphics, bl, bl2);
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            Color color = KafPlotProperties.mmaColor.getColor(new Integer(68));
            if (this.getOperation() == 0) {
                color = IColor.getLighter(color, 0.4f);
            }
            graphics.setColor(color);
        }
        this.drawIdentitaet(iGraphics, this.p1, this.p2, bl2);
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    private void drawIdentitaet(IGraphics iGraphics, Punkt punkt, Punkt punkt2, boolean bl) {
        Graphics graphics = iGraphics.getGraphics();
        boolean bl2 = false;
        boolean bl3 = false;
        Punkt.setForeground(graphics.getColor());
        if (punkt != null && punkt.isVisible()) {
            if (iGraphics.contains(punkt)) {
                iGraphics.getGraphicPoint(punkt, gps);
                punkt.drawMarkSymbol(iGraphics, Identitaet.gps.x, Identitaet.gps.y, KafPlotProperties.isPunktArtVisible, bl);
            }
            bl2 = true;
        }
        if (punkt2 != null && punkt2.isVisible()) {
            if (iGraphics.contains(punkt2)) {
                iGraphics.getGraphicPoint(punkt2, gpz);
                punkt2.drawMarkSymbol(iGraphics, Identitaet.gpz.x, Identitaet.gpz.y, KafPlotProperties.isPunktArtVisible, bl);
            }
            bl3 = true;
        }
        if (bl2 && bl3 && !punkt.equals(punkt2)) {
            if (bl) {
                iGraphics.drawLine(punkt, punkt2, 2);
            } else {
                iGraphics.drawLine(punkt, punkt2);
            }
            double d = DLine.getOrientation(punkt.y, punkt.x, punkt2.y, punkt2.x) + iGraphics.getRotation() + (this.getOperation() == 3 ? 1.5707963267948966 : -1.5707963267948966);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            Point point = iGraphics.getGraphicPoint((punkt.y + punkt2.y) / 2.0, (punkt.x + punkt2.x) / 2.0, new Point());
            if (this.getOperation() == 2) {
                int n = (int)Math.rint(d2 * 7.0 + d3 * 7.0);
                int n2 = (int)Math.rint(d2 * 7.0 - d3 * 7.0);
                iGraphics.getGraphics().drawLine(point.x - n, point.y + n2, point.x + n, point.y - n2);
                iGraphics.getGraphics().drawLine(point.x - n2, point.y - n, point.x + n2, point.y + n);
            } else {
                int[] nArray = new int[]{point.x + (int)Math.rint(d2 * 7.0), point.x - (int)Math.rint(d2 * 7.0 + d3 * 5.0), point.x - (int)Math.rint(d2 * 7.0 - d3 * 5.0)};
                int[] nArray2 = new int[]{point.y + (int)Math.rint(d3 * 7.0), point.y - (int)Math.rint(d3 * 7.0 - d2 * 5.0), point.y - (int)Math.rint(d3 * 7.0 + d2 * 5.0)};
                iGraphics.getGraphics().fillPolygon(nArray, nArray2, nArray.length);
            }
        }
    }
}

