/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.ITable;
import de.geocalc.awt.ITableCell;
import de.geocalc.awt.ITableLine;
import de.geocalc.awt.event.ITableEvent;
import de.geocalc.awt.event.ITableListener;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.ImageControlPoint;
import de.geocalc.kafplot.ObjectInfoDialog;
import de.geocalc.kafplot.Punkt;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.text.IFormat;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class ImageInfoDialog
extends ObjectInfoDialog
implements ActionListener,
ITableListener,
DataBaseListener {
    private Label nameLabel;
    private Label pathLabel;
    private Label kooLabel;
    private Label angleLabel;
    private Label dimLabel;

    public ImageInfoDialog(IFrame iFrame, String string) {
        this(iFrame, string, (GeoImage)null);
    }

    public ImageInfoDialog(IFrame iFrame, String string, GeoImage geoImage) {
        super(iFrame, string, geoImage);
    }

    @Override
    protected Panel createInfoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel(gridBagLayout);
        Label label = new Label("Name: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.nameLabel = new Label("", 0);
        panel.add(this.nameLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        label = new Label("Pfad: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.pathLabel = new Label("", 0);
        panel.add(this.pathLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pathLabel, gridBagConstraints);
        label = new Label("Lage: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.kooLabel = new Label("", 0);
        panel.add(this.kooLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.kooLabel, gridBagConstraints);
        label = new Label("Winkel: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.angleLabel = new Label("", 0);
        panel.add(this.angleLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.angleLabel, gridBagConstraints);
        label = new Label("Dimension: ", 0);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dimLabel = new Label("", 0);
        panel.add(this.dimLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dimLabel, gridBagConstraints);
        return panel;
    }

    @Override
    protected ITable createTable() {
        ITable iTable = new ITable(5);
        ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell("Passpunkt", 0), new ITableCell("Koo-Y", 0), new ITableCell("Koo-X", 0), new ITableCell("Bild-Y", 0), new ITableCell("Bild-X", 0)};
        iTable.setHeader(new ITableLine(iTableCellArray));
        iTable.addTableListener(this);
        return iTable;
    }

    @Override
    public void setObject(Object object) {
        GeoImage geoImage = (GeoImage)object;
        this.table.removeLines();
        if (geoImage != null) {
            this.addObjectToTable(geoImage);
        }
        super.setObject(object);
    }

    public void setObjects(Enumeration enumeration) {
    }

    @Override
    protected void showObject(Object object) {
        GeoImage geoImage = (GeoImage)object;
        if (geoImage != null) {
            this.nameLabel.setText(geoImage.getName() != null ? geoImage.getName() : "");
            this.pathLabel.setText(geoImage.getPathName() != null ? geoImage.getPathName() : "");
            GeoImageLocation geoImageLocation = geoImage.getImageLocation();
            this.kooLabel.setText(IFormat.f_3.format(geoImageLocation.getY()) + " , " + IFormat.f_3.format(geoImageLocation.getX()));
            this.angleLabel.setText(IFormat.f_6.format(geoImageLocation.getAngle()) + " \u00b0");
            this.dimLabel.setText(geoImage.getWidth() + " x " + geoImage.getHeight() + " px");
        } else {
            this.nameLabel.setText("");
            this.pathLabel.setText("");
            this.kooLabel.setText("");
            this.angleLabel.setText("");
            this.dimLabel.setText("");
        }
    }

    private void addObjectToTable(Object object) {
        GeoImage geoImage = (GeoImage)object;
        GeoImageLocation geoImageLocation = geoImage.getImageLocation();
        Enumeration<ImageControlPoint> enumeration = geoImageLocation.trafoElements();
        while (enumeration.hasMoreElements()) {
            ImageControlPoint imageControlPoint = enumeration.nextElement();
            Punkt punkt = imageControlPoint.getPunkt();
            DPoint dPoint = imageControlPoint.getImagePoint();
            ITableCell[] iTableCellArray = new ITableCell[]{new ITableCell(Long.toString(punkt.nr), 10), new ITableCell(IFormat.f_3.format(punkt.getY()), 10), new ITableCell(IFormat.f_3.format(punkt.getX()), 10), new ITableCell(IFormat.f_3.format(dPoint.getY()), 10), new ITableCell(IFormat.f_3.format(dPoint.getX()), 10)};
            this.table.addLine(new ITableLine(iTableCellArray, punkt));
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
    }

    @Override
    public void cellClicked(ITableEvent iTableEvent) {
        this.object = iTableEvent.getContent();
        this.showObject(iTableEvent.getContent());
        if (iTableEvent.getClickCount() > 1 && this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }
}

