/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IColorSliderDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.ILabel;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.IPositioner;
import de.geocalc.geom.DPoint;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.GeoImageLocation;
import de.geocalc.kafplot.GeoImageLocationDialog;
import de.geocalc.kafplot.ImageControlPoint;
import de.geocalc.kafplot.KafPlot;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.ObjectSupplier;
import de.geocalc.kafplot.WmsGeoImage;
import de.geocalc.kafplot.event.DataBaseEvent;
import de.geocalc.kafplot.event.DataBaseListener;
import de.geocalc.kafplot.event.InputEvent;
import de.geocalc.kafplot.event.InputListener;
import de.geocalc.text.IFormat;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImageObjectDialog
extends IOptionDialog
implements ActionListener,
ItemListener,
AdjustmentListener,
DataBaseListener,
InputListener,
ObjectSupplier {
    private static final String IMG_COLOR_COMMAND = "Farbe Setzen";
    private static final String RESET_COMMAND = "Zur\u00fccksetzen";
    private static final String ALL_ON_COMMAND = "Alle an";
    private static final String ALL_OFF_COMMAND = "Alle aus";
    private static final String INVERT_COMMAND = "Umkehren";
    private static final String CLEAN_COMMAND = "Bereinigen";
    private static final String INSERT_COMMAND = "Hinzuf\u00fcgen";
    private static final String SELECT_COMMAND = "W\u00e4hlen";
    private static final String DELETE_COMMAND = "Alle L\u00f6schen";
    private static final String INPUT_COMMAND = "Eingabe";
    private static final String CONTROL_COLOR_COMMAND = "Control_Color";
    private static final String CLIP_WAHL_COMMAND = "Ausschnitt w\u00e4hlen";
    private static final String CLIP_DELETE_COMMAND = "Ausschnitt l\u00f6schen";
    private static final String MOVE_COMMAND = "Verschieben";
    private static final String RESIZE_COMMAND = "Gr\u00f6\u00dfe \u00e4ndern";
    private static final String SAVE_COMMAND = "Speichern";
    private static final String _CONTROL_COLOR_COMMAND = "_control_color";
    private static final String _NEW_POSITION = "_new_position";
    private static final String SIZE_15 = "Gro\u00df";
    private static final String SIZE_10 = "Mittel";
    private static final String SIZE_05 = "Klein";
    private static final DecimalFormat fKoo = new DecimalFormat("0.000");
    private static final DecimalFormat fM = new DecimalFormat("0.0000 m/px");
    private static final DecimalFormat fR = new DecimalFormat("0.0000 gon");
    private static final DecimalFormat fS = new DecimalFormat("+ 0.000 m;" + Character.toString(8722) + " 0.000 m");
    private GeoImage img;
    private Scrollbar alphaSb;
    private Scrollbar brightSb;
    private Scrollbar contrastSb;
    private Scrollbar schaerfeSb;
    private Scrollbar graySb;
    private Label nameLabel;
    private Label propLabel;
    private Label pathLabel;
    private Label alphaLabel;
    private Label brightLabel;
    private Label contrastLabel;
    private Label schaerfeLabel;
    private Label ppCountLabel;
    private Label midRsLabel;
    private Label maxRsLabel;
    private Label yLabel;
    private Label xLabel;
    private Label rLabel;
    private Label mLabel;
    private Label sxLabel;
    private Label syLabel;
    private Label srLabel;
    private Checkbox alphaCb;
    private Checkbox digitCb;
    private Checkbox controlCb;
    private Checkbox gapCb;
    private Checkbox highlightCb;
    private Button resetButton;
    private Button grayButton;
    private Button allOnButton;
    private Button allOffButton;
    private Button invertButton;
    private Button cleanButton;
    private Button insertButton;
    private Button selectButton;
    private Button deleteButton;
    private Button inputButton;
    private Button saveButton;
    private Button controlColorButton;
    private Button clipWahlButton;
    private Button clipDeleteButton;
    private Button moveButton;
    private Button resizeButton;
    private List papuList;
    private Choice sizeChoice;
    private IColorSliderDialog colDialog;
    private IPositioner positioner;
    private DPoint shift = new DPoint();
    private double rotate = 0.0;
    private static final Insets DEFAULT_INSETS = new Insets(1, 1, 1, 1);
    private Hashtable layers;

    public ImageObjectDialog(IFrame iFrame, String string, GeoImage geoImage) {
        super(iFrame, string, geoImage);
        this.setResizable(true);
        this.setDirectlyActivatable(true, KafPlotProperties.isDirectlyDialogs());
        this.setImage(geoImage);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.img.isControlsVisible()) {
            this.img.setControlsVisible(bl);
            this.use();
        } else {
            this.img.setControlsVisible(bl);
        }
        super.setVisible(bl);
    }

    public void setImage(GeoImage geoImage) {
        this.img = geoImage;
        GeoImageLocation geoImageLocation = geoImage.getImageLocation();
        geoImageLocation.addInputListener(this);
        this.nameLabel.setText(geoImage.getName());
        this.propLabel.setText(geoImage.getPropertyName() != null ? geoImage.getPropertyName() : "");
        this.pathLabel.setText(geoImage.getPathName());
        int n = geoImage.getAlpha();
        this.alphaSb.setValue(n);
        this.alphaLabel.setText(n + " %");
        this.alphaCb.setState(geoImage.isAlphaAlternate());
        int n2 = geoImage.getBright();
        this.brightSb.setValue(n2);
        this.brightLabel.setText(n2 + " %");
        int n3 = geoImage.getContrast();
        this.contrastSb.setValue(n3);
        this.contrastLabel.setText(n3 + " %");
        int n4 = geoImage.getSharp();
        this.schaerfeSb.setValue(n4);
        this.schaerfeLabel.setText(n4 + " %");
        int n5 = geoImage.getGray();
        this.graySb.setValue(n5);
        this.grayButton.setLabel("" + n5);
        this.grayButton.setBackground(n5 == 0 ? this.getBackground() : geoImage.getGrayColor(n5));
        this.grayButton.setEnabled(!this.isDirectly());
        if (geoImageLocation.isModifiable()) {
            this.updateControlsOfTrafo(geoImageLocation);
            this.digitCb.setState(geoImage.isDigitVisible());
            this.controlCb.setState(geoImage.isControlVisible());
            this.gapCb.setState(geoImage.isGapVisible());
            this.highlightCb.setState(geoImage.isHighlight());
            this.setLocationLabels(geoImageLocation);
            int n6 = geoImage.getDigitWidth();
            if (n6 >= 15) {
                this.sizeChoice.select(SIZE_15);
            } else if (n6 >= 10) {
                this.sizeChoice.select(SIZE_10);
            } else {
                this.sizeChoice.select(SIZE_05);
            }
            this.clipDeleteButton.setEnabled(geoImage.getImageLocation().hasClip());
            this.saveButton.setLabel(GeoImage.createWorldFileExtension(geoImage.getName()) + " Speichern");
            this.shift.setNull();
            this.rotate = 0.0;
        }
    }

    private void setLocationLabels(GeoImageLocation geoImageLocation) {
        if (geoImageLocation.hasLocation()) {
            this.yLabel.setText(fKoo.format(geoImageLocation.getLocation().y));
            this.xLabel.setText(fKoo.format(geoImageLocation.getLocation().x));
            this.mLabel.setText(fM.format(geoImageLocation.getScale()));
            this.rLabel.setText(fR.format(geoImageLocation.getAngle() * 200.0 / Math.PI));
        } else {
            this.yLabel.setText("");
            this.xLabel.setText("");
            this.mLabel.setText("");
            this.rLabel.setText("");
        }
        if (!this.shift.isNull()) {
            this.syLabel.setText(fS.format(this.shift.y));
            this.sxLabel.setText(fS.format(this.shift.x));
        } else {
            this.syLabel.setText("");
            this.sxLabel.setText("");
        }
        if (this.rotate != 0.0) {
            this.srLabel.setText(fR.format(this.rotate));
        } else {
            this.srLabel.setText("");
        }
    }

    @Override
    public IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = DEFAULT_INSETS;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        IPanel iPanel2 = this.createNamePanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.createValuePanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.1f;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.getOptionObject() instanceof WmsGeoImage ? this.createWmsPanel() : this.createIdentPanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        return iPanel;
    }

    private IPanel createNamePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = DEFAULT_INSETS;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        ILabel iLabel = new ILabel("Name: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.nameLabel = new ILabel("__________________________________");
        iPanel.add(this.nameLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        iLabel = new ILabel("Einstellungen: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.propLabel = new ILabel("");
        iPanel.add(this.propLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.propLabel, gridBagConstraints);
        iLabel = new ILabel("Verzeichnis: ");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.pathLabel = new ILabel("");
        iPanel.add(this.pathLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.pathLabel, gridBagConstraints);
        return iPanel;
    }

    public IPanel createValuePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 1, 1, 2);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Bildfarben"));
        ILabel iLabel = new ILabel("Transparenz:");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.alphaSb = new Scrollbar(0, 0, 5, -100, 105);
        iPanel.add(this.alphaSb);
        this.alphaSb.setUnitIncrement(5);
        this.alphaSb.setBlockIncrement(25);
        this.alphaSb.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.alphaSb, gridBagConstraints);
        this.alphaLabel = new ILabel("-100 %");
        iPanel.add(this.alphaLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.alphaLabel, gridBagConstraints);
        this.alphaCb = new Checkbox("vollst\u00e4ndig durchleuchten", false);
        iPanel.add(this.alphaCb);
        this.alphaCb.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.alphaCb, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 1, 1, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        iLabel = new ILabel("Helligkeit:");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.brightSb = new Scrollbar(0, 0, 5, -100, 105);
        iPanel.add(this.brightSb);
        this.brightSb.setUnitIncrement(5);
        this.brightSb.setBlockIncrement(25);
        this.brightSb.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.brightSb, gridBagConstraints);
        this.brightLabel = new ILabel("-100 %");
        iPanel.add(this.brightLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.brightLabel, gridBagConstraints);
        iLabel = new ILabel("Kontrast:");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.contrastSb = new Scrollbar(0, 0, 5, -100, 105);
        iPanel.add(this.contrastSb);
        this.contrastSb.setUnitIncrement(5);
        this.contrastSb.setBlockIncrement(25);
        this.contrastSb.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.contrastSb, gridBagConstraints);
        this.contrastLabel = new ILabel("-100 %");
        iPanel.add(this.contrastLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.contrastLabel, gridBagConstraints);
        iLabel = new ILabel("Sch\u00e4rfe:");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.schaerfeSb = new Scrollbar(0, 0, 20, -100, 120);
        iPanel.add(this.schaerfeSb);
        this.schaerfeSb.setUnitIncrement(20);
        this.schaerfeSb.setBlockIncrement(50);
        this.schaerfeSb.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.schaerfeSb, gridBagConstraints);
        this.schaerfeLabel = new ILabel("-100 %");
        iPanel.add(this.schaerfeLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.schaerfeLabel, gridBagConstraints);
        iLabel = new ILabel("Farbe:");
        iPanel.add(iLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(iLabel, gridBagConstraints);
        this.graySb = new Scrollbar(0, 0, 1, 0, 255);
        iPanel.add(this.graySb);
        this.graySb.setUnitIncrement(1);
        this.graySb.setBlockIncrement(25);
        this.graySb.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.graySb, gridBagConstraints);
        this.grayButton = new Button("0");
        iPanel.add(this.grayButton);
        this.grayButton.setActionCommand(IMG_COLOR_COMMAND);
        this.grayButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.grayButton, gridBagConstraints);
        this.resetButton = new Button(RESET_COMMAND);
        iPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.resetButton, gridBagConstraints);
        return iPanel;
    }

    private IPanel createWmsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = DEFAULT_INSETS;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Layer"));
        int n = 0;
        WmsGeoImage wmsGeoImage = (WmsGeoImage)this.getOptionObject();
        Enumeration enumeration = wmsGeoImage.layers();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            Checkbox checkbox = new Checkbox(string, wmsGeoImage.isLayerVisible(string));
            checkbox.setName("WMSLayer" + n);
            iPanel.add(checkbox);
            checkbox.addItemListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagLayout.setConstraints(checkbox, gridBagConstraints);
            String string2 = wmsGeoImage.getLayerTitle(string);
            if (string2 != null) {
                Label label = new Label(string2);
                iPanel.add(label);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n;
                gridBagLayout.setConstraints(label, gridBagConstraints);
            }
            if (this.layers == null) {
                this.layers = new Hashtable();
            }
            this.layers.put(string, new Boolean(wmsGeoImage.isLayerVisible(string)));
            ++n;
        }
        return iPanel;
    }

    private IPanel createIdentPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = DEFAULT_INSETS;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Georeferenzierung"));
        IPanel iPanel2 = new IPanel(new GridLayout(1, 3));
        this.ppCountLabel = new ILabel("0 (0) Passpunkte", 0);
        iPanel2.add(this.ppCountLabel);
        this.midRsLabel = new ILabel("Mittel = 0.00 m", 1);
        iPanel2.add(this.midRsLabel);
        this.maxRsLabel = new ILabel("MaximumF = 0.00 m", 2);
        iPanel2.add(this.maxRsLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel.add(iPanel2);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        IPanel iPanel3 = new IPanel(gridBagLayout2);
        this.papuList = new List(6, true);
        iPanel3.add(this.papuList);
        this.papuList.setFont(new Font("Monospaced", 0, 12));
        this.papuList.addItemListener(this);
        gridBagConstraints2.insets = new Insets(2, 2, 1, 3);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 7;
        gridBagLayout2.setConstraints(this.papuList, gridBagConstraints2);
        gridBagConstraints2.insets = DEFAULT_INSETS;
        gridBagConstraints2.ipady = 4;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        this.insertButton = new Button(INSERT_COMMAND);
        iPanel3.add(this.insertButton);
        this.insertButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.ipady = 10;
        gridBagLayout2.setConstraints(this.insertButton, gridBagConstraints2);
        this.selectButton = new Button(SELECT_COMMAND);
        iPanel3.add(this.selectButton);
        this.selectButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.ipady = 10;
        gridBagLayout2.setConstraints(this.selectButton, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        this.allOnButton = new Button(ALL_ON_COMMAND);
        iPanel3.add(this.allOnButton);
        this.allOnButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.ipady = 0;
        gridBagLayout2.setConstraints(this.allOnButton, gridBagConstraints2);
        this.allOffButton = new Button(ALL_OFF_COMMAND);
        iPanel3.add(this.allOffButton);
        this.allOffButton.addActionListener(this);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagLayout2.setConstraints(this.allOffButton, gridBagConstraints2);
        this.invertButton = new Button(INVERT_COMMAND);
        iPanel3.add(this.invertButton);
        this.invertButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagLayout2.setConstraints(this.invertButton, gridBagConstraints2);
        this.cleanButton = new Button(CLEAN_COMMAND);
        iPanel3.add(this.cleanButton);
        this.cleanButton.addActionListener(this);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagLayout2.setConstraints(this.cleanButton, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 2;
        this.deleteButton = new Button(DELETE_COMMAND);
        iPanel3.add(this.deleteButton);
        this.deleteButton.addActionListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagLayout2.setConstraints(this.deleteButton, gridBagConstraints2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(iPanel3, gridBagConstraints);
        iPanel.add(iPanel3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        IPanel iPanel4 = new IPanel(gridBagLayout3);
        this.digitCb = new Checkbox("Bildpunkt");
        iPanel4.add(this.digitCb);
        this.digitCb.addItemListener(this);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagLayout3.setConstraints(this.digitCb, gridBagConstraints3);
        this.controlCb = new Checkbox("Passpunkt");
        iPanel4.add(this.controlCb);
        this.controlCb.addItemListener(this);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagLayout3.setConstraints(this.controlCb, gridBagConstraints3);
        this.gapCb = new Checkbox("Restklaffe");
        iPanel4.add(this.gapCb);
        this.gapCb.addItemListener(this);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagLayout3.setConstraints(this.gapCb, gridBagConstraints3);
        this.highlightCb = new Checkbox("Hervorgehoben");
        iPanel4.add(this.highlightCb);
        this.highlightCb.addItemListener(this);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints(this.highlightCb, gridBagConstraints3);
        this.controlColorButton = new Button("Farbe");
        iPanel4.add(this.controlColorButton);
        this.controlColorButton.setActionCommand(CONTROL_COLOR_COMMAND);
        this.controlColorButton.addActionListener(this);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints(this.controlColorButton, gridBagConstraints3);
        this.sizeChoice = new Choice();
        iPanel4.add(this.sizeChoice);
        this.sizeChoice.addItemListener(this);
        this.sizeChoice.add(SIZE_15);
        this.sizeChoice.add(SIZE_10);
        this.sizeChoice.add(SIZE_05);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 1;
        gridBagLayout3.setConstraints(this.sizeChoice, gridBagConstraints3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(iPanel4, gridBagConstraints);
        iPanel.add(iPanel4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 4;
        this.clipWahlButton = new Button(CLIP_WAHL_COMMAND);
        iPanel.add(this.clipWahlButton);
        this.clipWahlButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.clipWahlButton, gridBagConstraints);
        this.clipDeleteButton = new Button(CLIP_DELETE_COMMAND);
        iPanel.add(this.clipDeleteButton);
        this.clipDeleteButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.clipDeleteButton, gridBagConstraints);
        this.moveButton = new Button(MOVE_COMMAND);
        iPanel.add(this.moveButton);
        this.moveButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.moveButton, gridBagConstraints);
        this.resizeButton = new Button(RESIZE_COMMAND);
        iPanel.add(this.resizeButton);
        this.resizeButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagLayout.setConstraints(this.resizeButton, gridBagConstraints);
        this.inputButton = new Button(INPUT_COMMAND);
        iPanel.add(this.inputButton);
        this.inputButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.inputButton, gridBagConstraints);
        this.saveButton = new Button(SAVE_COMMAND);
        iPanel.add(this.saveButton);
        this.saveButton.setActionCommand(SAVE_COMMAND);
        this.saveButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(this.saveButton, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.1;
        this.positioner = new IPositioner(0.25, 128.0, 1.0, new DecimalFormat("##0.00 px"), _NEW_POSITION, true);
        iPanel.add(this.positioner);
        this.positioner.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.positioner, gridBagConstraints);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 1.0;
        IPanel iPanel5 = new IPanel(gridBagLayout4);
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridx = 0;
        Label label = new Label("Y =", 2);
        iPanel5.add(label);
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints(label, gridBagConstraints4);
        label = new Label("X =", 2);
        iPanel5.add(label);
        gridBagConstraints4.gridy = 1;
        gridBagLayout4.setConstraints(label, gridBagConstraints4);
        label = new Label("M =", 2);
        iPanel5.add(label);
        gridBagConstraints4.gridy = 2;
        gridBagLayout4.setConstraints(label, gridBagConstraints4);
        label = new Label("R =", 2);
        iPanel5.add(label);
        gridBagConstraints4.gridy = 3;
        gridBagLayout4.setConstraints(label, gridBagConstraints4);
        gridBagConstraints4.gridx = 1;
        this.yLabel = new ILabel("0000000.000", 0, true);
        iPanel5.add(this.yLabel);
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints(this.yLabel, gridBagConstraints4);
        this.xLabel = new ILabel("0000000.000", 0, true);
        iPanel5.add(this.xLabel);
        gridBagConstraints4.gridy = 1;
        gridBagLayout4.setConstraints(this.xLabel, gridBagConstraints4);
        this.mLabel = new ILabel("000.0000 m/px", 0, true);
        iPanel5.add(this.mLabel);
        gridBagConstraints4.gridy = 2;
        gridBagLayout4.setConstraints(this.mLabel, gridBagConstraints4);
        this.rLabel = new ILabel("-000.0000 gon", 0, true);
        iPanel5.add(this.rLabel);
        gridBagConstraints4.gridy = 3;
        gridBagLayout4.setConstraints(this.rLabel, gridBagConstraints4);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.weightx = 1.0;
        this.syLabel = new ILabel("+ 00.000 m", 2, true);
        iPanel5.add(this.syLabel);
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints(this.syLabel, gridBagConstraints4);
        this.sxLabel = new ILabel("+ 00.000 m", 2, true);
        iPanel5.add(this.sxLabel);
        gridBagConstraints4.gridy = 1;
        gridBagLayout4.setConstraints(this.sxLabel, gridBagConstraints4);
        this.srLabel = new ILabel("+ 0.0000 gon", 2, true);
        iPanel5.add(this.srLabel);
        gridBagConstraints4.gridy = 3;
        gridBagLayout4.setConstraints(this.srLabel, gridBagConstraints4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(iPanel5, gridBagConstraints);
        iPanel.add(iPanel5);
        return iPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        GeoImageLocation geoImageLocation = this.img.getImageLocation();
        if (string.equals(IMG_COLOR_COMMAND)) {
            this.img.setGray(this.graySb.getValue());
            this.use();
        } else if (string.equals(RESET_COMMAND)) {
            this.alphaSb.setValue(0);
            this.alphaLabel.setText("0 %");
            this.alphaCb.setState(false);
            int n = this.img.getBright();
            this.brightSb.setValue(0);
            this.brightLabel.setText("0 %");
            this.contrastSb.setValue(0);
            this.contrastLabel.setText("0 %");
            this.schaerfeSb.setValue(0);
            this.schaerfeLabel.setText("0 %");
            this.graySb.setValue(0);
            this.grayButton.setLabel("0");
            this.grayButton.setBackground(this.getBackground());
            if (this.isDirectly()) {
                this.img.setAlpha(0);
                this.img.setBright(0);
                this.img.setContrast(0);
                this.img.setSharp(0);
                this.img.setGray(0);
                this.use();
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(ALL_ON_COMMAND)) {
            for (int i = 0; i < this.papuList.getItemCount(); ++i) {
                if (this.papuList.isIndexSelected(i)) continue;
                this.papuList.select(i);
            }
            if (this.isDirectly()) {
                this.performLocation(geoImageLocation);
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(ALL_OFF_COMMAND)) {
            for (int i = 0; i < this.papuList.getItemCount(); ++i) {
                if (!this.papuList.isIndexSelected(i)) continue;
                this.papuList.deselect(i);
            }
            if (this.isDirectly()) {
                this.performLocation(geoImageLocation);
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(INVERT_COMMAND)) {
            for (int i = 0; i < this.papuList.getItemCount(); ++i) {
                if (this.papuList.isIndexSelected(i)) {
                    this.papuList.deselect(i);
                    continue;
                }
                this.papuList.select(i);
            }
            if (this.isDirectly()) {
                this.performLocation(geoImageLocation);
            } else {
                super.itemStateChanged();
            }
        } else if (string.equals(CLEAN_COMMAND)) {
            for (int i = this.papuList.getItemCount() - 1; i >= 0; --i) {
                if (this.papuList.isIndexSelected(i)) continue;
                geoImageLocation.setTrafoPointValid(this.getPapuListNr(i), false);
            }
            this.updatePaPuListOfTrafo(geoImageLocation);
            if (this.isDirectly()) {
                this.performLocation(geoImageLocation);
            }
            super.itemStateChanged();
        } else if (string.equals(DELETE_COMMAND)) {
            geoImageLocation.setTrafoAllValid(false);
            this.papuList.removeAll();
            if (this.isDirectly()) {
                this.performLocation(geoImageLocation);
            }
            super.itemStateChanged();
        } else if (string.equals(INSERT_COMMAND)) {
            geoImageLocation.setInputMode(1);
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Objekte erzeugen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Passpunkte angeben"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_send_inputobject"));
        } else if (string.equals(SELECT_COMMAND)) {
            geoImageLocation.setInputMode(2);
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Objekte erzeugen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Passpunkte w\u00e4hlen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_send_inputobject"));
        } else if (string.equals(INPUT_COMMAND)) {
            GeoImageLocationDialog geoImageLocationDialog = new GeoImageLocationDialog(this.parent, "Georeferenzierung");
            geoImageLocationDialog.setGeoImage(this.img);
            geoImageLocationDialog.setActionCommand(this.getActionCommand());
            geoImageLocationDialog.addActionListener(this.getActionListener());
            geoImageLocationDialog.addActionListener(this);
            DataBase.addDataBaseListener(geoImageLocationDialog);
            geoImageLocationDialog.setModal(true);
            geoImageLocationDialog.setVisible(true);
        } else if (string.equals(CONTROL_COLOR_COMMAND)) {
            if (this.colDialog == null) {
                this.colDialog = new IColorSliderDialog(this.parent, "Passpunktfarbe", true, this.img.getControlColor());
                this.colDialog.setActionCommand(_CONTROL_COLOR_COMMAND);
                this.colDialog.addActionListener(this);
                this.colDialog.setModal(false);
            } else {
                this.colDialog.setColor(this.img.getControlColor());
            }
            this.colDialog.setVisible(true);
        } else if (string.equals(_CONTROL_COLOR_COMMAND)) {
            if (this.colDialog != null && this.colDialog.getColor() != null) {
                this.img.setControlColor(this.colDialog.getColor());
                if (this.isDirectly()) {
                    this.use();
                } else {
                    super.itemStateChanged();
                }
            }
        } else if (string.equals(CLIP_WAHL_COMMAND)) {
            geoImageLocation.setInputMode(3);
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Objekte erzeugen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Ausschnitt angeben"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_send_inputobject"));
        } else if (string.equals(CLIP_DELETE_COMMAND)) {
            geoImageLocation.removeClip();
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        } else if (string.equals(MOVE_COMMAND)) {
            geoImageLocation.setInputMode(4);
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Objekte erzeugen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Bild verschieben"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_send_inputobject"));
        } else if (string.equals(RESIZE_COMMAND)) {
            geoImageLocation.setInputMode(5);
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Objekte erzeugen"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Bildgr\u00f6\u00dfe \u00e4ndern"));
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_send_inputobject"));
        } else if (string.equals(SAVE_COMMAND)) {
            try {
                this.img.saveProperties(GeoImage.createWorldFileName(this.img.getFilePath()), false);
            }
            catch (Exception exception) {
                if (KafPlot.debug()) {
                    exception.printStackTrace();
                }
            }
        } else if (string.equals(_NEW_POSITION)) {
            if (this.positioner.hasShift() || this.positioner.hasRotate() && this.getPaPuListEnabledCount() > 1) {
                this.setPaPuListSelect(false);
            }
            double d = this.positioner.hasRotate() ? this.positioner.getRotate() * geoImageLocation.getRotateOfPixel() : 0.0;
            DPoint dPoint = this.positioner.getShift();
            double d2 = KafPlotProperties.getGrafikRotation();
            double d3 = geoImageLocation.getScale();
            double d4 = dPoint.y * Math.cos(d2) * d3 - dPoint.x * Math.sin(d2) * d3;
            double d5 = dPoint.y * Math.sin(d2) * d3 + dPoint.x * Math.cos(d2) * d3;
            if (this.isDirectly()) {
                geoImageLocation.rotate(d);
                geoImageLocation.moveLocation(d4, d5);
                this.performLocation(geoImageLocation);
            } else {
                this.shift.y = d4;
                this.shift.x = d5;
                this.rotate = d;
                this.setLocationLabels(geoImageLocation);
                super.itemStateChanged();
            }
        } else if (string.equals(this.getActionCommand())) {
            geoImageLocation.setTrafoAllEnabled(false);
            this.updateControlsOfTrafo(geoImageLocation);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void dataBaseUpdated(DataBaseEvent dataBaseEvent) {
        this.setImage(this.img);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.alphaSb) {
            int n = this.alphaSb.getValue();
            if (n % 5 != 0) {
                n = n / 5 * 5;
                this.alphaSb.setValue(n);
            }
            this.alphaLabel.setText(n + " %");
            if (this.isDirectly()) {
                this.img.setAlpha(n);
                this.use();
            } else {
                super.adjustmentValueChanged(adjustmentEvent);
            }
        } else if (object == this.brightSb) {
            int n = this.brightSb.getValue();
            if (n % 5 != 0) {
                n = n / 5 * 5;
                this.brightSb.setValue(n);
            }
            this.brightLabel.setText(n + " %");
            if (this.isDirectly()) {
                this.img.setBright(n);
                this.use();
            } else {
                super.adjustmentValueChanged(adjustmentEvent);
            }
        } else if (object == this.contrastSb) {
            int n = this.contrastSb.getValue();
            if (n % 5 != 0) {
                n = n / 5 * 5;
                this.contrastSb.setValue(n);
            }
            this.contrastLabel.setText(n + " %");
            if (this.isDirectly()) {
                this.img.setContrast(n);
                this.use();
            } else {
                super.adjustmentValueChanged(adjustmentEvent);
            }
        } else if (object == this.schaerfeSb) {
            int n = this.schaerfeSb.getValue();
            if (n % 5 != 0) {
                n = n / 5 * 5;
                this.schaerfeSb.setValue(n);
            }
            this.schaerfeLabel.setText(n + " %");
            if (this.isDirectly()) {
                this.img.setSharp(n);
                this.use();
            } else {
                super.adjustmentValueChanged(adjustmentEvent);
            }
        } else if (object == this.graySb) {
            int n = this.graySb.getValue();
            if (n % 1 != 0) {
                this.graySb.setValue(n);
            }
            this.grayButton.setLabel("" + n);
            this.grayButton.setBackground(n == 0 ? this.getBackground() : this.img.getGrayColor(n));
            if (this.isDirectly()) {
                this.img.setGray(n);
                this.use();
            } else {
                super.adjustmentValueChanged(adjustmentEvent);
            }
        } else {
            super.adjustmentValueChanged(adjustmentEvent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.alphaCb) {
            if (this.isDirectly()) {
                this.img.setAlphaAlternate(this.alphaCb.getState());
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (itemEvent.getSource() == this.papuList) {
            Object object2 = itemEvent.getItem();
            if (object2 instanceof Integer) {
                int n = (Integer)object2;
                GeoImageLocation geoImageLocation = this.img.getImageLocation();
                geoImageLocation.setTrafoPointEnabled(this.getPapuListNr(n), this.papuList.isIndexSelected(n));
                if (this.isDirectly()) {
                    this.performLocation(this.img.getImageLocation());
                } else {
                    super.itemStateChanged(itemEvent);
                }
            }
        } else if (object == this.digitCb) {
            this.img.setDigitVisible(this.digitCb.getState());
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (object == this.controlCb) {
            this.img.setControlVisible(this.controlCb.getState());
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (object == this.gapCb) {
            this.img.setGapVisible(this.gapCb.getState());
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (object == this.highlightCb) {
            this.img.setHighlight(this.highlightCb.getState());
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (object == this.sizeChoice) {
            String string = this.sizeChoice.getSelectedItem();
            if (string.equals(SIZE_15)) {
                this.img.setDigitWidth(15);
            } else if (string.equals(SIZE_10)) {
                this.img.setDigitWidth(10);
            } else {
                this.img.setDigitWidth(5);
            }
            if (this.isDirectly()) {
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else if (object instanceof Checkbox) {
            Object object3;
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (checkbox.getName().startsWith("WMSLayer")) {
                object3 = checkbox.getLabel();
                if (this.layers != null && this.layers.get(object3) != null) {
                    this.layers.put(object3, new Boolean(checkbox.getState()));
                }
            }
            if (this.isDirectly()) {
                if (this.getOptionObject() instanceof WmsGeoImage) {
                    object3 = (WmsGeoImage)this.getOptionObject();
                    Enumeration enumeration = this.layers.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Boolean bl = (Boolean)this.layers.get(string);
                        if (bl == null) continue;
                        ((WmsGeoImage)object3).setLayerVisible(string, bl);
                    }
                }
                this.use();
            } else {
                super.itemStateChanged(itemEvent);
            }
        } else {
            super.itemStateChanged(itemEvent);
        }
    }

    @Override
    public void inputUpdated(InputEvent inputEvent) {
        GeoImageLocation geoImageLocation = this.img.getImageLocation();
        if (this.isDirectly()) {
            geoImageLocation.transform();
        }
        this.updateControlsOfTrafo(geoImageLocation);
        this.use();
        super.itemStateChanged();
    }

    @Override
    protected void setDirectly(boolean bl) {
        if (bl) {
            this.setOptions();
            this.use();
        }
        this.grayButton.setEnabled(!bl);
        super.setDirectly(bl);
    }

    @Override
    public void setOptions() {
        Messager messager;
        this.img.setAlpha(this.alphaSb.getValue());
        this.img.setAlphaAlternate(this.alphaCb.getState());
        this.img.setBright(this.brightSb.getValue());
        this.img.setContrast(this.contrastSb.getValue());
        this.img.setSharp(this.schaerfeSb.getValue());
        this.img.setGray(this.graySb.getValue());
        if (this.getOptionObject() instanceof WmsGeoImage) {
            messager = (WmsGeoImage)this.getOptionObject();
            Enumeration enumeration = this.layers.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Boolean bl = (Boolean)this.layers.get(string);
                if (bl == null) continue;
                ((WmsGeoImage)messager).setLayerVisible(string, bl);
            }
        }
        if (((GeoImageLocation)(messager = this.img.getImageLocation())).isModifiable()) {
            ((GeoImageLocation)messager).removeTrafoInvalids();
            this.updateTrafoOfControls((GeoImageLocation)messager);
            this.updateControlsOfTrafo((GeoImageLocation)messager);
        }
    }

    private void performLocation(GeoImageLocation geoImageLocation) {
        this.updateTrafoOfControls(geoImageLocation);
        this.updateControlsOfTrafo(geoImageLocation);
        this.use();
    }

    private void updateTrafoOfControls(GeoImageLocation geoImageLocation) {
        if (geoImageLocation.isModifiable()) {
            if (!this.shift.isNull() || this.rotate != 0.0) {
                geoImageLocation.rotate(this.rotate);
                this.rotate = 0.0;
                geoImageLocation.moveLocation(this.shift.y, this.shift.x);
                this.shift.setNull();
            }
            for (int i = 0; i < this.papuList.getItemCount(); ++i) {
                geoImageLocation.setTrafoPointEnabled(this.getPapuListNr(i), this.papuList.isIndexSelected(i));
            }
            geoImageLocation.transform();
        }
    }

    private void updateControlsOfTrafo(GeoImageLocation geoImageLocation) {
        int n = geoImageLocation.trafoPointCount(false);
        int n2 = geoImageLocation.trafoPointCount(true);
        this.ppCountLabel.setText(n2 + " (" + n + ") Passpunkt" + (n > 1 ? "e" : ""));
        this.midRsLabel.setText("Mittel = " + IFormat.f1_2.format(geoImageLocation.getMidRs()) + " m");
        this.maxRsLabel.setText("Maximum = " + IFormat.f1_2.format(geoImageLocation.getMaxRs()) + " m");
        this.updatePaPuListOfTrafo(geoImageLocation);
        if (geoImageLocation.trafoPointCount(true) > 0) {
            this.midRsLabel.setEnabled(true);
            this.maxRsLabel.setEnabled(true);
            this.papuList.setForeground(SystemColor.controlText);
            this.shift.setNull();
        } else {
            this.midRsLabel.setEnabled(false);
            this.maxRsLabel.setEnabled(false);
            this.papuList.setForeground(SystemColor.textInactiveText);
        }
        this.setLocationLabels(geoImageLocation);
        this.positioner.reset();
    }

    private void updatePaPuListOfTrafo(GeoImageLocation geoImageLocation) {
        block10: {
            int n = 0;
            try {
                Enumeration<ImageControlPoint> enumeration = geoImageLocation.trafoElements();
                while (enumeration.hasMoreElements()) {
                    ImageControlPoint imageControlPoint = enumeration.nextElement();
                    if (!imageControlPoint.isValid()) continue;
                    String string = this.createPapuItem(imageControlPoint);
                    if (this.papuList.getItemCount() - 1 < n) {
                        this.papuList.addItem(string);
                    } else if (!string.equals(this.papuList.getItem(n))) {
                        this.papuList.replaceItem(string, n);
                    }
                    if (imageControlPoint.isEnabled() && !this.papuList.isIndexSelected(n)) {
                        this.papuList.select(n);
                    } else if (!imageControlPoint.isEnabled() && this.papuList.isIndexSelected(n)) {
                        this.papuList.deselect(n);
                    }
                    ++n;
                }
                for (int i = this.papuList.getItemCount() - 1; i >= n; --i) {
                    this.papuList.remove(i);
                }
            }
            catch (Exception exception) {
                if (!KafPlot.debug()) break block10;
                exception.printStackTrace();
            }
        }
    }

    private int getPaPuListEnabledCount() {
        int n = 0;
        for (int i = 0; i < this.papuList.getItemCount(); ++i) {
            if (!this.papuList.isIndexSelected(i)) continue;
            ++n;
        }
        return n;
    }

    private void setPaPuListSelect(boolean bl) {
        for (int i = 0; i < this.papuList.getItemCount(); ++i) {
            if (bl == this.papuList.isIndexSelected(i)) continue;
            if (bl) {
                this.papuList.select(i);
                continue;
            }
            this.papuList.deselect(i);
        }
    }

    private long getPapuListNr(int n) {
        String string = this.papuList.getItem(n);
        return Long.parseLong(string.substring(0, Math.min(string.length(), 15)).trim());
    }

    private double getPapuListRs(int n) {
        String string = this.papuList.getItem(n);
        if (string.length() > 16) {
            return Double.parseDouble(string.substring(16).trim());
        }
        return 0.0;
    }

    public String createPapuItem(ImageControlPoint imageControlPoint) {
        if (imageControlPoint == null) {
            return IFormat.i15.format(0L);
        }
        return IFormat.i15.format(imageControlPoint.getNr()) + " " + IFormat.f3_3.format(imageControlPoint.getRs());
    }

    private void use() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_repaint"));
        }
    }

    @Override
    public Object getObject() {
        return this.img.getImageLocation();
    }

    @Override
    protected void endDialog() {
        this.img.getImageLocation().removeInputListener(this);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_destroy_inputobject"));
        }
        super.endDialog();
    }

    @Override
    protected void doStandardAction() {
        block2: {
            super.doStandardAction();
            try {
                this.img.saveProperties();
            }
            catch (Exception exception) {
                if (!KafPlot.debug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void doAbortAction() {
        this.dialogAbort();
        super.doAbortAction();
    }

    @Override
    protected boolean dialogAbort() {
        this.img.getImageLocation().setTrafoAllValid(true);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "_destroy_inputobject"));
        }
        this.img.setControlsVisible(false);
        this.img.getImageLocation().removeInputListener(this);
        this.use();
        return super.dialogAbort();
    }
}

