/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.GeoImage;
import de.geocalc.kafplot.ImageObjectDialog;
import de.geocalc.kafplot.PaintObjectDialog;
import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class ImageObjectsDialog
extends PaintObjectDialog
implements ActionListener,
ItemListener {
    Button deleteButton;
    Button optionButton;
    Button upButton;
    Button downButton;
    private static final String DELETE_COMMAND = "L\u00f6schen";
    private static final String OPTION_COMMAND = "Optionen";
    private static final String UP_COMMAND = "nach oben";
    private static final String DOWN_COMMAND = "nach unten";

    public ImageObjectsDialog(IFrame iFrame, String string, Vector vector) {
        super(iFrame, string, vector);
    }

    @Override
    protected IPanel createSelectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        Button button = new Button("Alle");
        iPanel.add(button);
        button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        button = new Button("Keine");
        iPanel.add(button);
        button.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        this.deleteButton = new Button(DELETE_COMMAND);
        iPanel.add(this.deleteButton);
        this.deleteButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.deleteButton, gridBagConstraints);
        this.optionButton = new Button(OPTION_COMMAND);
        iPanel.add(this.optionButton);
        this.optionButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.optionButton, gridBagConstraints);
        this.upButton = new Button(UP_COMMAND);
        iPanel.add(this.upButton);
        this.upButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.upButton, gridBagConstraints);
        this.downButton = new Button(DOWN_COMMAND);
        iPanel.add(this.downButton);
        this.downButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.downButton, gridBagConstraints);
        return iPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE_COMMAND)) {
            for (int i = this.objectList.getItemCount() - 1; i >= 0; --i) {
                if (!this.objectList.isIndexSelected(i)) continue;
                GeoImage geoImage = (GeoImage)this.O.elementAt(i);
                this.objectList.remove(i);
            }
        } else if (string.equals(OPTION_COMMAND)) {
            int n = this.objectList.getSelectedIndex();
            String string2 = this.objectList.getItem(n);
            for (int i = 0; i < DataBase.IMG.size(); ++i) {
                GeoImage geoImage = (GeoImage)DataBase.IMG.elementAt(i);
                if (!geoImage.getName().equals(string2)) continue;
                ImageObjectDialog imageObjectDialog = new ImageObjectDialog(this.parent, "Imageoptionen", geoImage);
                imageObjectDialog.setActionCommand(this.getActionCommand());
                imageObjectDialog.addActionListener(this.getActionListener());
                imageObjectDialog.setModal(false);
                imageObjectDialog.setVisible(true);
                DataBase.addDataBaseListener(imageObjectDialog);
                break;
            }
        } else if (string.equals(UP_COMMAND)) {
            for (int i = 1; i < this.objectList.getItemCount(); ++i) {
                if (!this.objectList.isSelected(i) || this.objectList.isSelected(i - 1)) continue;
                String string3 = this.objectList.getItem(i - 1);
                this.objectList.replaceItem(this.objectList.getItem(i), i - 1);
                this.objectList.replaceItem(string3, i);
                this.objectList.select(i - 1);
            }
        } else if (string.equals(DOWN_COMMAND)) {
            for (int i = this.objectList.getItemCount() - 2; i >= 0; --i) {
                if (!this.objectList.isSelected(i) || this.objectList.isSelected(i + 1)) continue;
                String string4 = this.objectList.getItem(i + 1);
                this.objectList.replaceItem(this.objectList.getItem(i), i + 1);
                this.objectList.replaceItem(string4, i);
                this.objectList.select(i + 1);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    protected void setOptions() {
        Vector vector = (Vector)this.O.clone();
        this.O.removeAllElements();
        block0: for (int i = 0; i < this.objectList.getItemCount(); ++i) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                GeoImage geoImage = (GeoImage)enumeration.nextElement();
                if (!geoImage.getName().equals(this.objectList.getItem(i))) continue;
                this.O.addElement(geoImage);
                geoImage.setVisible(this.objectList.isIndexSelected(i));
                continue block0;
            }
        }
    }

    @Override
    protected void setListLayout() {
        super.setListLayout();
        this.setButtonLayout();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.setButtonLayout();
    }

    private void setButtonLayout() {
        int n = this.objectList.getSelectedIndexes().length;
        int n2 = this.objectList.getItemCount();
        this.deleteButton.setEnabled(n > 0);
        this.optionButton.setEnabled(n == 1);
        this.upButton.setEnabled(n > 0 && n < n2);
        this.downButton.setEnabled(n > 0 && n < n2);
    }
}

