/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.ProgressListener;
import de.geocalc.awt.ErrorDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.FileReaderDialog;
import de.geocalc.kafplot.GeoImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;

public class ImageReader
extends FileReaderDialog
implements Runnable,
ProgressListener {
    protected int loadingFlags = 9;
    File[] inFiles = new File[1];

    public ImageReader(IFrame iFrame, String string, DataBase dataBase, File[] fileArray) {
        super(iFrame, string, dataBase, fileArray[0]);
        this.inFiles = fileArray;
    }

    public ImageReader(IFrame iFrame, String string, DataBase dataBase, File file) {
        super(iFrame, string, dataBase, file);
        this.inFiles[0] = file;
    }

    public ImageReader(IFrame iFrame, String string, DataBase dataBase, URL uRL) {
        super(iFrame, string, dataBase, uRL);
    }

    public int getKooSystem() {
        return -1;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.inFiles.length; ++i) {
            try {
                String string = this.inFiles[i].getAbsolutePath();
                JimiRasterImage jimiRasterImage = this.loadRasterImage(string);
                Image image = Toolkit.getDefaultToolkit().createImage(jimiRasterImage.getCroppedImageProducer(0, 0, 1, 1));
                GraphicsUtils.waitForImage(image);
                GeoImage geoImage = new GeoImage(jimiRasterImage, string);
                File file = new File(string + ".properties");
                if (file.exists()) {
                    geoImage.loadProperties(file.getAbsolutePath());
                } else {
                    file = new File(GeoImage.createWorldFileName(string));
                    if (file.exists()) {
                        geoImage.loadProperties(file.getAbsolutePath());
                    } else {
                        file = new File(GeoImage.createDefaultWorldFileName(string));
                        if (file.exists()) {
                            geoImage.loadProperties(file.getAbsolutePath());
                        }
                    }
                }
                DataBase.addImage(geoImage);
                continue;
            }
            catch (Exception exception) {
                this.showError(exception);
            }
        }
        this.endDialog();
    }

    protected JimiRasterImage loadRasterImage(String string) throws Exception {
        JimiReader jimiReader = Jimi.createJimiReader(string, this.loadingFlags);
        jimiReader.setProgressListener(this);
        JimiRasterImage jimiRasterImage = jimiReader.getRasterImage();
        return jimiRasterImage;
    }

    protected JimiRasterImage loadRasterImage(URL uRL) throws Exception {
        JimiReader jimiReader = Jimi.createJimiReader(uRL, 1);
        jimiReader.setProgressListener(this);
        JimiRasterImage jimiRasterImage = jimiReader.getRasterImage();
        return jimiRasterImage;
    }

    protected void showError(Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(this.parent, exception);
        errorDialog.setVisible(true);
    }

    @Override
    public void setStarted() {
        this.setProgress(0);
    }

    @Override
    public void setProgressLevel(int n) {
        this.setProgress(n);
    }

    @Override
    public void setFinished() {
        this.setProgress(100);
    }

    @Override
    public void setAbort() {
    }

    @Override
    public void setAbort(String string) {
    }
}

