/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import de.geocalc.awt.ITextField;
import de.geocalc.io.GeoFile;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.EdbsImportOptionDialog;
import de.geocalc.kafplot.EdbsParserDialog;
import de.geocalc.kafplot.ExtendedPunktFilterDialog;
import de.geocalc.kafplot.NasImportOptionDialog;
import de.geocalc.kafplot.PunktAttChoiceDialog;
import de.geocalc.kafplot.PunktNummer;
import de.geocalc.kafplot.PunktStatus;
import de.geocalc.kafplot.io.IFileReader;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

public class ImportOptionDialog
extends IOptionDialog
implements ActionListener,
ItemListener {
    private static final String FILTER_COMMAND = "Filter";
    private static final String ATT_CHOICE_COMMAND = "Attributauswahl";
    private Choice punktNummerChoice;
    private Choice psChoice;
    private Choice doppelChoice;
    private Checkbox newCheckbox;
    private Checkbox oldCheckbox;
    private Checkbox kooBereichCheckbox;
    private Checkbox ignoreCheckbox;
    private Checkbox replaceCheckbox;
    private Checkbox newNrCheckbox;
    private Checkbox changeCheckbox;
    private Checkbox newKooCheckbox;
    private Checkbox newDyDxCheckbox;
    private Checkbox attIgnoreCheckbox;
    private Checkbox attReplaceCheckbox;
    private Checkbox attAppendCheckbox;
    private Checkbox newMengeCheckbox;
    private Checkbox oldMengeCheckbox;
    private Checkbox updMengeCheckbox;
    CheckboxGroup existPointGroup = new CheckboxGroup();
    private Button filterButton;
    private Button attButton;
    private ITextField newNumberField;
    private int fileTyp = 0;
    private GeoFile geoFile;
    private Hashtable lagestatusTable = null;
    private Hashtable hoehestatusTable = null;
    private IFileReader reader;
    private boolean abort = false;
    Button detailButton;

    public ImportOptionDialog(IFrame iFrame, String string, GeoFile geoFile, IFileReader iFileReader) {
        super(iFrame, string + " (" + geoFile.getName() + " : " + geoFile.getFileTypString() + ")", false);
        this.geoFile = geoFile;
        this.reader = iFileReader;
        this.fileTyp = geoFile.getFileTyp();
        this.detailButton.setEnabled(this.fileTyp == 124 || this.fileTyp == 550);
        this.setLayoutOptions();
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        IPanel iPanel2 = this.createNumberPanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.createSelectPanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.createModePanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        iPanel2 = this.createMengePanel();
        iPanel.add(iPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(iPanel2, gridBagConstraints);
        return iPanel;
    }

    @Override
    protected Panel layoutButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        Button button = new Button("OK");
        button.addActionListener(this);
        panel.add(button);
        Button button2 = new Button("Abbrechen");
        button2.addActionListener(this);
        panel.add(button2);
        this.detailButton = new Button("Details");
        this.detailButton.addActionListener(this);
        panel.add(this.detailButton);
        return panel;
    }

    private IPanel createNumberPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Punktbildung"));
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Label label = new Label("Punktnummernbildung:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.punktNummerChoice = new Choice();
        iPanel.add(this.punktNummerChoice);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.punktNummerChoice, gridBagConstraints);
        label = new Label("Punktstatus:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.psChoice = new Choice();
        iPanel.add(this.psChoice);
        this.psChoice.addItem(PunktStatus.getString(0));
        this.psChoice.addItem(PunktStatus.getString(1));
        this.psChoice.addItem(PunktStatus.getString(2));
        this.psChoice.addItem(PunktStatus.getString(-1));
        this.psChoice.addItem(PunktStatus.getString(-3));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.psChoice, gridBagConstraints);
        label = new Label("Startwert neuer Punktnummern:");
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.newNumberField = new ITextField(20);
        iPanel.add(this.newNumberField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.newNumberField, gridBagConstraints);
        this.newNumberField.addKeyListener(this);
        return iPanel;
    }

    private IPanel createSelectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Auswahl"));
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.kooBereichCheckbox = new Checkbox("Koordinatenausschnitt");
        iPanel.add(this.kooBereichCheckbox);
        this.kooBereichCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.kooBereichCheckbox, gridBagConstraints);
        this.filterButton = new Button(FILTER_COMMAND);
        iPanel.add(this.filterButton);
        this.filterButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.filterButton, gridBagConstraints);
        this.newCheckbox = new Checkbox("Neupunkte lesen");
        iPanel.add(this.newCheckbox);
        this.newCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.newCheckbox, gridBagConstraints);
        this.oldCheckbox = new Checkbox("Altpunkte lesen");
        iPanel.add(this.oldCheckbox);
        this.oldCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.oldCheckbox, gridBagConstraints);
        return iPanel;
    }

    private IPanel createModePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "vorhandene Punkte"));
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.existPointGroup = new CheckboxGroup();
        this.ignoreCheckbox = new Checkbox("Ignorieren", false, this.existPointGroup);
        iPanel.add(this.ignoreCheckbox);
        this.ignoreCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.ignoreCheckbox, gridBagConstraints);
        this.replaceCheckbox = new Checkbox("Ersetzen", false, this.existPointGroup);
        iPanel.add(this.replaceCheckbox);
        this.replaceCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.replaceCheckbox, gridBagConstraints);
        this.changeCheckbox = new Checkbox("Erg\u00e4nzen", false, this.existPointGroup);
        iPanel.add(this.changeCheckbox);
        this.changeCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.changeCheckbox, gridBagConstraints);
        this.newNrCheckbox = new Checkbox("neue Nummer", false, this.existPointGroup);
        iPanel.add(this.newNrCheckbox);
        this.newNrCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.newNrCheckbox, gridBagConstraints);
        this.newKooCheckbox = new Checkbox("Koordinaten ersetzen");
        iPanel.add(this.newKooCheckbox);
        this.newKooCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.newKooCheckbox, gridBagConstraints);
        this.newDyDxCheckbox = new Checkbox("DyDxDh erzeugen");
        iPanel.add(this.newDyDxCheckbox);
        this.newDyDxCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.newDyDxCheckbox, gridBagConstraints);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.attIgnoreCheckbox = new Checkbox("Attribute ignorieren", false, checkboxGroup);
        iPanel.add(this.attIgnoreCheckbox);
        this.attIgnoreCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.attIgnoreCheckbox, gridBagConstraints);
        this.attReplaceCheckbox = new Checkbox("Attribute ersetzen", false, checkboxGroup);
        iPanel.add(this.attReplaceCheckbox);
        this.attReplaceCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.attReplaceCheckbox, gridBagConstraints);
        this.attAppendCheckbox = new Checkbox("Attribute erg\u00e4nzen", false, checkboxGroup);
        iPanel.add(this.attAppendCheckbox);
        this.attAppendCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.attAppendCheckbox, gridBagConstraints);
        this.attButton = new Button(ATT_CHOICE_COMMAND);
        iPanel.add(this.attButton);
        this.attButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.attButton, gridBagConstraints);
        return iPanel;
    }

    private IPanel createMengePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1, "Menge erzeugen"));
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.newMengeCheckbox = new Checkbox("aus Neupunkten");
        iPanel.add(this.newMengeCheckbox);
        this.newMengeCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.newMengeCheckbox, gridBagConstraints);
        this.oldMengeCheckbox = new Checkbox("aus Altpunkten");
        iPanel.add(this.oldMengeCheckbox);
        this.oldMengeCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.oldMengeCheckbox, gridBagConstraints);
        this.updMengeCheckbox = new Checkbox("aus Differenzpunkten");
        iPanel.add(this.updMengeCheckbox);
        this.updMengeCheckbox.addItemListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.updMengeCheckbox, gridBagConstraints);
        return iPanel;
    }

    private void setLayoutOptions() {
        int n = this.reader.getModel();
        this.punktNummerChoice.addItem(PunktNummer.getLengthAsString(0, n));
        String[] stringArray = PunktNummer.getNames(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.punktNummerChoice.addItem(stringArray[i]);
        }
        this.punktNummerChoice.select(PunktNummer.getLengthAsString(this.reader.getPnrModus(), n));
        this.punktNummerChoice.setEnabled(this.reader.isMutableNumberReader());
        this.psChoice.select(PunktStatus.getString(this.reader.getPunktStatus()));
        this.psChoice.setEnabled(this.reader.isMutableStatusReader());
        this.newNumberField.setText(Long.toString(this.reader.getFreeStartNumber()));
        this.newNumberField.setEnabled(this.reader.isFreeNumberReader() || this.reader.isMode(64));
        this.newCheckbox.setState(this.reader.isMode(1));
        this.oldCheckbox.setState(this.reader.isMode(2));
        this.kooBereichCheckbox.setState(this.reader.isMode(4));
        if (!this.reader.isSelectableReader()) {
            this.newCheckbox.setEnabled(false);
            this.oldCheckbox.setEnabled(false);
            this.kooBereichCheckbox.setEnabled(false);
            this.filterButton.setEnabled(false);
        }
        this.ignoreCheckbox.setState(this.reader.isMode(8));
        this.replaceCheckbox.setState(this.reader.isMode(16));
        this.newNrCheckbox.setState(this.reader.isMode(64));
        this.changeCheckbox.setState(this.reader.isMode(32));
        this.newKooCheckbox.setState(this.reader.isMode(128));
        this.newDyDxCheckbox.setState(this.reader.isMode(512));
        this.attIgnoreCheckbox.setState(this.reader.isMode(1024));
        this.attReplaceCheckbox.setState(this.reader.isMode(2048));
        this.attAppendCheckbox.setState(this.reader.isMode(4096));
        if (this.reader.isUpdateReader()) {
            this.ignoreCheckbox.setEnabled(false);
            this.replaceCheckbox.setEnabled(false);
            this.newNrCheckbox.setEnabled(false);
            this.changeCheckbox.setEnabled(false);
        }
        this.newMengeCheckbox.setState(this.reader.isMode(8192));
        this.oldMengeCheckbox.setState(this.reader.isMode(16384));
        this.updMengeCheckbox.setState(this.reader.isMode(32768));
        if (!this.reader.isMengeReader()) {
            this.newMengeCheckbox.setEnabled(false);
            this.oldMengeCheckbox.setEnabled(false);
            this.updMengeCheckbox.setEnabled(false);
        }
        this.setLayoutOfProperties();
    }

    private void setLayoutOfProperties() {
        this.newNumberField.setEnabled(this.reader.isFreeNumberReader() || this.newNrCheckbox.getState());
        boolean bl = this.newCheckbox.getState();
        if (!bl) {
            this.newMengeCheckbox.setState(false);
        }
        this.newMengeCheckbox.setEnabled(bl && this.reader.isMengeReader());
        boolean bl2 = this.oldCheckbox.getState();
        if (!this.reader.isUpdateReader()) {
            this.ignoreCheckbox.setEnabled(bl2);
            this.replaceCheckbox.setEnabled(bl2);
            this.newNrCheckbox.setEnabled(bl2);
            this.changeCheckbox.setEnabled(bl2);
        }
        if (!bl2) {
            this.oldMengeCheckbox.setState(false);
        }
        this.oldMengeCheckbox.setEnabled(bl2 && this.reader.isMengeReader());
        boolean bl3 = this.oldCheckbox.getState() && this.changeCheckbox.getState();
        this.newKooCheckbox.setEnabled(bl3);
        this.newDyDxCheckbox.setEnabled(bl3);
        this.attIgnoreCheckbox.setEnabled(bl3);
        this.attReplaceCheckbox.setEnabled(bl3);
        this.attAppendCheckbox.setEnabled(bl3);
        this.attButton.setEnabled(bl3);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setLayoutOfProperties();
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void setOptions() {
        if (this.reader.isMutableNumberReader()) {
            this.reader.setPnrModus(PunktNummer.getLength(this.punktNummerChoice.getSelectedItem()));
        }
        if (this.reader.isMutableStatusReader()) {
            this.reader.setPunktStatus(PunktStatus.getStatus(this.psChoice.getSelectedItem()));
        }
        try {
            this.reader.setFreeStartNumber(Long.parseLong(this.newNumberField.getText().trim()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reader.setMode(1, this.newCheckbox.getState());
        this.reader.setMode(2, this.oldCheckbox.getState());
        this.reader.setMode(4, this.kooBereichCheckbox.getState());
        this.reader.setMode(8, this.ignoreCheckbox.getState());
        this.reader.setMode(16, this.replaceCheckbox.getState());
        this.reader.setMode(32, this.changeCheckbox.getState());
        this.reader.setMode(64, this.newNrCheckbox.getState());
        this.reader.setMode(128, this.newKooCheckbox.getState());
        this.reader.setMode(512, this.newDyDxCheckbox.getState());
        this.reader.setMode(1024, this.attIgnoreCheckbox.getState());
        this.reader.setMode(2048, this.attReplaceCheckbox.getState());
        this.reader.setMode(4096, this.attAppendCheckbox.getState());
        this.reader.setMode(8192, this.newMengeCheckbox.getState());
        this.reader.setMode(16384, this.oldMengeCheckbox.getState());
        this.reader.setMode(32768, this.oldMengeCheckbox.getState());
        IFileReader.setLagestatusTable(this.lagestatusTable);
        IFileReader.setHoehestatusTable(this.hoehestatusTable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Details")) {
            if (this.fileTyp == 124) {
                EdbsParserDialog edbsParserDialog = new EdbsParserDialog(this.parent, "Edbs untersuchen", this.geoFile.getFile());
                edbsParserDialog.setVisible(true);
                this.lagestatusTable = edbsParserDialog.getLsResult();
                this.hoehestatusTable = edbsParserDialog.getHsResult();
                EdbsImportOptionDialog edbsImportOptionDialog = new EdbsImportOptionDialog(this.parent, "Koordinatenstatus ausw\u00e4hlen", this.lagestatusTable, this.hoehestatusTable);
                edbsImportOptionDialog.setVisible(true);
            } else if (this.fileTyp == 550) {
                NasImportOptionDialog nasImportOptionDialog = new NasImportOptionDialog(this.parent, "NAS-Import-Optionen");
                nasImportOptionDialog.setVisible(true);
            }
        } else if (string.equals(FILTER_COMMAND)) {
            ExtendedPunktFilterDialog extendedPunktFilterDialog = new ExtendedPunktFilterDialog(this.parent, "PunktFilter", DataBase.getInstance(), this.reader.getPunktFilter(), true);
            extendedPunktFilterDialog.setActionCommand(this.getActionCommand());
            extendedPunktFilterDialog.addActionListener(this.getActionListener());
            extendedPunktFilterDialog.setVisible(true);
            this.reader.setPunktFilter(extendedPunktFilterDialog.getFilter());
        } else if (string.equals(ATT_CHOICE_COMMAND)) {
            PunktAttChoiceDialog punktAttChoiceDialog = new PunktAttChoiceDialog(this.parent, ATT_CHOICE_COMMAND, this.reader.getParameterList(), true);
            punktAttChoiceDialog.setVisible(true);
            this.reader.setParameterList(punktAttChoiceDialog.getSelectedAtts());
        } else if (string.equals("Abbrechen")) {
            this.abort = true;
            this.endDialog();
        } else if (string.equals("OK")) {
            this.setOptions();
            this.endDialog();
        }
    }

    protected void windowAbort() {
        this.abort = true;
    }

    public boolean abort() {
        return this.abort;
    }
}

