/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.ITimeDisplayer;
import de.geocalc.kafplot.KafPlotVersion;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class InfoDialogPanel
extends Panel
implements MouseListener,
ITimeDisplayer {
    Button okButton = new Button("OK");
    Button verButton = new Button("Versionsinfo");
    boolean hasLicense = true;
    private static final Point[] points = new Point[]{new Point(-45, -30), new Point(30, 270), new Point(-5, -30), new Point(20, 70), new Point(45, 170), new Point(70, 270), new Point(195, -80), new Point(220, 20), new Point(245, 120), new Point(270, 220), new Point(295, 320), new Point(420, -30), new Point(445, 70), new Point(470, 170), new Point(50, -20), new Point(62, 30), new Point(102, 20), new Point(90, -30)};
    private static final Color bg = Color.white;
    private static final Color nGray = new Color(232, 232, 232);
    private static final Color hGray = new Color(244, 244, 244);
    Rectangle lastTimeRect = null;

    public InfoDialogPanel(boolean bl) {
        this.hasLicense = bl;
        if (bl) {
            this.add(this.verButton);
            this.add(this.okButton);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
        this.verButton.addActionListener(actionListener);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(340, this.hasLicense ? 230 : 300);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, true);
    }

    public void paint(Graphics graphics, boolean bl) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Dimension dimension = this.getSize();
        graphics.setColor(bg);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(nGray);
        this.drawLine(graphics, points[0], points[1], 4);
        this.drawLine(graphics, points[2], points[3], 4);
        this.drawLine(graphics, points[3], points[4], 4);
        this.drawLine(graphics, points[4], points[5], 4);
        this.drawLine(graphics, points[6], points[7], 4);
        this.drawLine(graphics, points[7], points[8], 4);
        this.drawLine(graphics, points[8], points[9], 4);
        this.drawLine(graphics, points[9], points[10], 4);
        this.drawLine(graphics, points[3], points[7], 4);
        this.drawLine(graphics, points[7], points[11], 4);
        this.drawLine(graphics, points[4], points[8], 4);
        this.drawLine(graphics, points[8], points[12], 4);
        this.drawLine(graphics, points[5], points[9], 4);
        this.drawLine(graphics, points[9], points[13], 4);
        for (int i = 0; i < 13; ++i) {
            this.drawArc(graphics, points[i]);
        }
        int[] nArray = new int[]{InfoDialogPanel.points[14].x, InfoDialogPanel.points[15].x, InfoDialogPanel.points[16].x, InfoDialogPanel.points[17].x};
        int[] nArray2 = new int[]{InfoDialogPanel.points[14].y, InfoDialogPanel.points[15].y, InfoDialogPanel.points[16].y, InfoDialogPanel.points[17].y};
        for (n2 = 0; n2 < 3; ++n2) {
            graphics.setColor(hGray);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(nGray);
            graphics.drawPolygon(nArray, nArray2, 4);
            n = 0;
            while (n < 4) {
                int n3 = n;
                nArray[n3] = nArray[n3] + 25;
                int n4 = n++;
                nArray2[n4] = nArray2[n4] + 100;
            }
        }
        n2 = bl ? 0 : 2;
        graphics.setColor(Color.black);
        Font font = new Font("SansSerif", 1, 48);
        Object object = KafPlotVersion.getTitle(1);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (bl) {
            graphics.setColor(Color.lightGray);
            graphics.setFont(font);
            n = dimension.width - fontMetrics.stringWidth((String)object) - 13;
            graphics.drawString((String)object, n, fontMetrics.getAscent());
        }
        graphics.setColor(Color.black);
        graphics.setFont(font);
        n = dimension.width - fontMetrics.stringWidth((String)object) - 15 + n2;
        int n5 = n2 + fontMetrics.getAscent();
        graphics.drawString((String)object, n, n5);
        font = new Font("SansSerif", 1, 18);
        graphics.setFont(font);
        object = "GeoCalc - ";
        fontMetrics = this.getFontMetrics(font);
        if (bl) {
            graphics.setColor(Color.lightGray);
            graphics.drawString((String)object, n - fontMetrics.stringWidth((String)object), fontMetrics.getHeight());
        }
        graphics.setColor(Color.black);
        graphics.drawString((String)object, n - fontMetrics.stringWidth((String)object) - 2 + n2, n2 + fontMetrics.getHeight());
        if (KafPlotVersion.isReaderVersion()) {
            object = "Reader   ";
            if (bl) {
                graphics.setColor(Color.lightGray);
                graphics.drawString((String)object, n - fontMetrics.stringWidth((String)object), n5);
            }
            graphics.setColor(Color.black);
            graphics.drawString((String)object, n - fontMetrics.stringWidth((String)object) - 2 + n2, n5);
        }
        font = new Font("SansSerif", 1, 18);
        graphics.setFont(font);
        object = "Version: 2.1.011 \u2012 27.05.2025";
        fontMetrics = this.getFontMetrics(font);
        graphics.setColor(Color.black);
        graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 70);
        font = new Font("SansSerif", 1, 12);
        graphics.setFont(font);
        fontMetrics = this.getFontMetrics(font);
        if (KafPlotVersion.hasProviderUpdate()) {
            graphics.setColor(Color.red);
        }
        object = KafPlotVersion.getProviderUpdateInfo();
        graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 90);
        graphics.setColor(Color.black);
        font = new Font("SansSerif", 0, 12);
        graphics.setFont(font);
        fontMetrics = this.getFontMetrics(font);
        object = "\u00a9 Dipl.- Ing. J\u00f6rg Schr\u00f6der";
        graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 110);
        if (KafPlotVersion.LIZENZ_NR > 0L) {
            object = "Lizenz-Nr.: " + KafPlotVersion.LIZENZ_NR;
            graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 130);
            object = "lizenziert f\u00fcr: " + KafPlotVersion.LIZENZ_NM;
            graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 150);
        } else if (KafPlotVersion.DATA_NR > 0L) {
            object = "Lizenz-Nr.: " + KafPlotVersion.DATA_NR;
            graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 130);
            object = "zur Verf\u00fcgung gestellt von: " + KafPlotVersion.LIZENZ_NM;
            graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 150);
        } else {
            object = "Demoversion";
            font = new Font("SansSerif", 1, 16);
            graphics.setFont(font);
            fontMetrics = this.getFontMetrics(font);
            graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, 140);
            font = new Font("SansSerif", 0, 12);
            graphics.setFont(font);
            fontMetrics = this.getFontMetrics(font);
            graphics.drawString("Diese Programm wurde Ihnen als Demoversion zur", 5, 155);
            graphics.drawString("Verf\u00fcgung gestellt. Eine kommerzielle  Verwendung", 5, 170);
            graphics.drawString("dieser Software ist nur mit einer g\u00fcltigen Lizenz", 5, 185);
            graphics.drawString("zul\u00e4ssig.", 5, 200);
            graphics.drawString("Informationen \u00fcber die Lizenzbedingungen erhalten Sie", 5, 215);
            graphics.drawString("unter kafplot@geocalc.de", 5, 230);
            graphics.drawString("Sie k\u00f6nnen diese Software w\u00e4hrend dieser Dialog", 5, 245);
            graphics.drawString("ge\u00f6ffnet ist testen. Nach Ablauf von 2 Minuten", 5, 260);
            graphics.drawString("schlie\u00dft sich das Programm automatisch.", 5, 275);
        }
        if (this.hasLicense) {
            Dimension dimension2 = this.okButton.getPreferredSize();
            this.okButton.setBounds(dimension.width - dimension2.width - 25, 170, dimension2.width + 10, dimension2.height + 5);
            this.okButton.setVisible(true);
            Dimension dimension3 = this.verButton.getPreferredSize();
            this.verButton.setBounds(dimension.width - dimension2.width - 30 - dimension3.width, 170, dimension3.width, dimension3.height + 5);
            this.verButton.setVisible(true);
        }
        font = new Font("SansSerif", 0, 11);
        graphics.setFont(font);
        object = "WWW: www.geocalc.de EMAIL: kafplot@geocalc.de";
        fontMetrics = this.getFontMetrics(font);
        graphics.drawString((String)object, dimension.width - fontMetrics.stringWidth((String)object) - 10, dimension.height - 3);
    }

    public void drawArc(Graphics graphics, Point point) {
        graphics.setColor(bg);
        graphics.fillOval(point.x - 5, point.y - 5, 10, 10);
        graphics.setColor(nGray);
        graphics.drawOval(point.x - 5, point.y - 5, 10, 10);
        graphics.drawOval(point.x - 4, point.y - 4, 8, 8);
    }

    public void drawLine(Graphics graphics, Point point, Point point2, int n) {
        if (n < 2) {
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        } else {
            double d = point2.x - point.x;
            double d2 = point2.y - point.y;
            double d3 = (float)Math.sqrt(d * d + d2 * d2);
            double d4 = d / d3;
            double d5 = d2 / d3;
            double d6 = (double)n / 2.0;
            int[] nArray = new int[]{(int)Math.rint((double)point.x + d5 * d6), (int)Math.rint((double)point.x - d5 * d6), (int)Math.rint((double)point2.x - d5 * d6), (int)Math.rint((double)point2.x + d5 * d6)};
            int[] nArray2 = new int[]{(int)Math.rint((double)point.y - d4 * d6), (int)Math.rint((double)point.y + d4 * d6), (int)Math.rint((double)point2.y + d4 * d6), (int)Math.rint((double)point2.y - d4 * d6)};
            graphics.fillPolygon(nArray, nArray2, 4);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void setTime(long l) {
        int n = this.getSize().height;
        Graphics graphics = this.getGraphics();
        Font font = new Font("SansSerif", 0, 12);
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        if (this.lastTimeRect != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(5, n - 5 - n2, this.lastTimeRect.width, this.lastTimeRect.height);
        }
        String string = l / 1000L + "s";
        graphics.setColor(Color.black);
        graphics.drawString(string, 5, n - 5);
        this.lastTimeRect = new Rectangle(fontMetrics.stringWidth(string), n2);
    }
}

