/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.Bedingung;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;

public class InputBedingung
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private int ba;
    private Punkt p1;
    private Punkt p2;
    private Punkt p3;
    private Punkt p4;
    private double mass;

    public InputBedingung(int n) {
        this.ba = n;
    }

    public void setArt(int n) {
        this.ba = n;
    }

    public int getArt() {
        return this.ba;
    }

    public void setP1(Punkt punkt) {
        this.p1 = punkt;
    }

    public Punkt getP1() {
        return this.p1;
    }

    public void setP2(Punkt punkt) {
        this.p2 = punkt;
    }

    public Punkt getP2() {
        return this.p2;
    }

    public void setP3(Punkt punkt) {
        this.p3 = punkt;
    }

    public Punkt getP3() {
        return this.p3;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public double getMass() {
        return this.mass;
    }

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        switch (this.ba) {
            case 1: 
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
        }
        return 4;
    }

    @Override
    public int need() {
        switch (this.ba) {
            case 1: 
            case 2: {
                if (this.step % 2 == 0) {
                    return InputProperties.getInputFangSwitch() == 903 ? 256 : 64;
                }
                return 64;
            }
            case 3: {
                if (this.step == 4) {
                    return 4;
                }
                if (this.step % 2 == 0) {
                    return InputProperties.getInputFangSwitch() == 903 ? 256 : 64;
                }
                return 64;
            }
            case 4: {
                if (this.step == 3) {
                    return 4;
                }
                if (this.step == 0) {
                    return InputProperties.getInputFangSwitch() == 903 ? 256 : 64;
                }
                return 64;
            }
            case 5: {
                if (this.step == 2) {
                    return 4;
                }
                return 64;
            }
            case 6: {
                if (this.step == 3) {
                    return 4;
                }
                if (this.step == 0) {
                    return InputProperties.getInputFangSwitch() == 903 ? 612 : 64;
                }
                return 64;
            }
        }
        return 64;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        switch (this.ba) {
            case 3: {
                if (this.step != 4 || this.p1 == null || this.p2 == null || this.p3 == null || this.p4 == null) break;
                return new Float((DLine.ptLineDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x, this.p3.y, this.p3.x) + DLine.ptLineDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x, this.p4.y, this.p4.x)) / 2.0 * DataBase.getStreckeMasstab((this.p1.y + this.p2.y) / 2.0));
            }
            case 4: {
                if (this.step != 3 || this.p1 == null || this.p2 == null || this.p3 == null) break;
                return new Float(DLine.ptLineDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x, this.p3.y, this.p3.x) * DataBase.getStreckeMasstab((this.p1.y + this.p2.y) / 2.0));
            }
            case 5: {
                if (this.step != 2 || this.p1 == null || this.p2 == null) break;
                return new Float(DPoint.ptDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x) * DataBase.getStreckeMasstab((this.p1.y + this.p2.y) / 2.0));
            }
            case 6: {
                if (this.step != 3 || this.p1 == null || this.p2 == null || this.p3 == null) break;
                return new Float(DPoint.ptDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x) + DPoint.ptDist(this.p1.y, this.p1.x, this.p3.y, this.p3.x) * DataBase.getStreckeMasstab((this.p1.y + this.p2.y) / 2.0));
            }
        }
        return null;
    }

    public void setObject(Object object, int n) {
        switch (this.ba) {
            default: 
        }
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (this.step < 2) {
            if (this.step == 0) {
                if (object instanceof Linie) {
                    Linie linie = (Linie)object;
                    this.p1 = linie.pa;
                    this.p2 = linie.pe;
                    if (bl) {
                        this.step += 2;
                    }
                } else if (object instanceof Punkt) {
                    this.p1 = (Punkt)object;
                    if (bl) {
                        ++this.step;
                    }
                }
            } else if (object instanceof Punkt) {
                this.p2 = (Punkt)object;
                if (bl) {
                    ++this.step;
                }
            }
        } else {
            switch (this.ba) {
                case 1: 
                case 2: {
                    if (object instanceof Linie) {
                        Linie linie = (Linie)object;
                        if (linie.pa.equals(this.p1) && linie.pe.equals(this.p2) || linie.pe.equals(this.p1) && linie.pa.equals(this.p2)) {
                            return;
                        }
                        if (linie.pa.equals(this.p1) || linie.pa.equals(this.p2)) {
                            this.p3 = linie.pe;
                            if (linie.pa.equals(this.p1)) {
                                this.p4 = this.p1;
                                this.p1 = this.p2;
                                this.p2 = this.p4;
                                this.p4 = null;
                            }
                            if (!bl) break;
                            ++this.step;
                            break;
                        }
                        if (!linie.pe.equals(this.p1) && !linie.pe.equals(this.p2)) break;
                        this.p3 = linie.pa;
                        if (linie.pe.equals(this.p1)) {
                            this.p4 = this.p1;
                            this.p1 = this.p2;
                            this.p2 = this.p4;
                            this.p4 = null;
                        }
                        if (!bl) break;
                        ++this.step;
                        break;
                    }
                    if (!(object instanceof Punkt)) break;
                    this.p3 = (Punkt)object;
                    if (!bl) break;
                    ++this.step;
                    break;
                }
                case 3: {
                    if (this.step == 2) {
                        if (object instanceof Linie) {
                            Linie linie = (Linie)object;
                            if (linie.pa.equals(this.p1) || linie.pa.equals(this.p2) || linie.pe.equals(this.p1) || linie.pe.equals(this.p2)) break;
                            this.p3 = linie.pa;
                            this.p4 = linie.pe;
                            if (!bl) break;
                            this.step += 2;
                            break;
                        }
                        if (!(object instanceof Punkt)) break;
                        this.p3 = (Punkt)object;
                        if (!bl) break;
                        ++this.step;
                        break;
                    }
                    if (this.step == 3) {
                        if (!(object instanceof Punkt)) break;
                        this.p4 = (Punkt)object;
                        if (!bl) break;
                        ++this.step;
                        break;
                    }
                    if (this.step != 4 || !(object instanceof Number)) break;
                    this.mass = ((Number)object).doubleValue();
                    if (!bl) break;
                    ++this.step;
                    break;
                }
                case 4: 
                case 6: {
                    if (this.step == 2) {
                        if (!(object instanceof Punkt)) break;
                        this.p3 = (Punkt)object;
                        if (!bl) break;
                        ++this.step;
                        break;
                    }
                    if (this.step != 3 || !(object instanceof Number)) break;
                    this.mass = ((Number)object).doubleValue();
                    if (!bl) break;
                    ++this.step;
                    break;
                }
                case 5: {
                    if (this.step != 2 || !(object instanceof Number)) break;
                    this.mass = ((Number)object).doubleValue();
                    if (!bl) break;
                    ++this.step;
                }
            }
        }
        this.lastIn = object;
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(DataContainer dataContainer) {
        switch (this.ba) {
            case 1: {
                dataContainer.addElement(new Bedingung(1, this.p1, this.p2, this.p3, 0.0));
                break;
            }
            case 2: {
                dataContainer.addElement(new Bedingung(2, this.p1, this.p2, this.p3, 0.0));
                break;
            }
            case 3: {
                Bedingung bedingung;
                int n = -1;
                for (int i = 0; i < dataContainer.size(); ++i) {
                    bedingung = (Bedingung)dataContainer.elementAt(i);
                    if (bedingung.ba != 3 || (!bedingung.p1.equals(this.p1) || !bedingung.p2.equals(this.p2)) && (!bedingung.p1.equals(this.p2) || !bedingung.p2.equals(this.p1))) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    bedingung = new Bedingung(3, this.p1, this.p2, null, 0.0);
                    dataContainer.addElement(bedingung);
                    Bedingung bedingung2 = new Bedingung(0, this.p3, this.p4, null, this.mass);
                    dataContainer.addElement(bedingung2);
                    bedingung2.setReferenz(bedingung);
                    break;
                }
                bedingung = (Bedingung)dataContainer.elementAt(n);
                Bedingung bedingung3 = new Bedingung(0, this.p3, this.p4, null, this.mass);
                dataContainer.insertElementAt(bedingung3, n + 1);
                bedingung3.setReferenz(bedingung);
                break;
            }
            case 4: {
                dataContainer.addElement(new Bedingung(4, this.p1, this.p2, this.p3, this.mass));
                break;
            }
            case 5: {
                dataContainer.addElement(new Bedingung(5, this.p1, this.p2, null, this.mass));
                break;
            }
            case 6: {
                int n = -1;
                for (int i = 0; i < dataContainer.size(); ++i) {
                    Bedingung bedingung = (Bedingung)dataContainer.elementAt(i);
                    if (bedingung.ba != 6 || (!bedingung.p1.equals(this.p1) || !bedingung.p2.equals(this.p2)) && (!bedingung.p1.equals(this.p2) || !bedingung.p2.equals(this.p1))) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    dataContainer.addElement(new Bedingung(6, this.p1, this.p2, this.p3, this.mass));
                    break;
                }
                dataContainer.insertElementAt(new Bedingung(9, this.p3, null, null, this.mass), n + 1);
                break;
            }
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer;
        block49: {
            block48: {
                stringBuffer = new StringBuffer();
                if (this.isReady()) break block48;
                block0 : switch (this.ba) {
                    case 1: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Anfangspunkt: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Fluchtpunkt: ");
                                if (this.p2 == null) break;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Endpunkt: ");
                                if (this.p3 == null) break;
                                stringBuffer.append(this.p3.nr);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Anfangspunkt: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Rechter Winkel in: ");
                                if (this.p2 == null) break;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Endpunkt: ");
                                if (this.p3 == null) break;
                                stringBuffer.append(this.p3.nr);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Bezugsgerade: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Bezugsgerade: ");
                                if (this.p1 != null) {
                                    stringBuffer.append(this.p1.nr);
                                }
                                stringBuffer.append(" - ");
                                if (this.p2 == null) break;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Parallele: ");
                                if (this.p3 == null) break;
                                stringBuffer.append(this.p3.nr);
                                break block0;
                            }
                            case 3: {
                                stringBuffer.append("Parallele: ");
                                if (this.p3 != null) {
                                    stringBuffer.append(this.p3.nr);
                                }
                                stringBuffer.append(" - ");
                                if (this.p4 == null) break;
                                stringBuffer.append(this.p4.nr);
                                break block0;
                            }
                            case 4: {
                                stringBuffer.append("Abstand: ");
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Bezugsgerade: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Bezugsgerade: ");
                                if (this.p1 != null) {
                                    stringBuffer.append(this.p1.nr);
                                }
                                stringBuffer.append(" - ");
                                if (this.p2 == null) break;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Punkt: ");
                                if (this.p3 == null) break;
                                stringBuffer.append(this.p3.nr);
                                break block0;
                            }
                            case 3: {
                                stringBuffer.append("Abstand: ");
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("erster Punkt: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("zweiter Punkt: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Abstand: ");
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("erster Punkt: ");
                                if (this.p1 != null) {
                                    stringBuffer.append(this.p1.nr);
                                    break block0;
                                }
                                break block49;
                            }
                            case 1: {
                                stringBuffer.append("zweiter Punkt: ");
                                if (this.p1 != null) {
                                    stringBuffer.append(this.p1.nr);
                                    break block0;
                                }
                                break block49;
                            }
                            case 2: {
                                stringBuffer.append("dritter Punkt: ");
                                if (this.p3 != null) {
                                    stringBuffer.append(this.p3.nr);
                                    break block0;
                                }
                                break block49;
                            }
                            case 3: {
                                stringBuffer.append("Radius: ");
                            }
                        }
                    }
                }
                break block49;
            }
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        switch (this.ba) {
            case 1: {
                return "Geradenbedingung";
            }
            case 2: {
                return "Rechter Winkel";
            }
            case 3: {
                return "Parallele";
            }
            case 4: {
                return "Abstand Gerade-Punkt";
            }
            case 5: {
                return "Abstand Punkt-Punkt";
            }
            case 6: {
                return "Kreisbogen";
            }
        }
        return "Bedingung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.p1 != null) {
            stringBuffer.append(this.p1.nr);
        }
        if (this.p2 != null) {
            stringBuffer.append("-");
            stringBuffer.append(this.p2.nr);
        }
        if (this.p3 != null) {
            stringBuffer.append("-");
            stringBuffer.append(this.p3.nr);
        }
        if (this.mass != 0.0) {
            stringBuffer.append(" [");
            stringBuffer.append(IFormat.f_3.format(this.mass));
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        if (this.p1 != null) {
            d = Math.min(d, this.p1.y);
            d2 = Math.min(d2, this.p1.x);
            d3 = Math.max(d3, this.p1.y);
            d4 = Math.max(d4, this.p1.x);
        }
        if (this.p2 != null) {
            d = Math.min(d, this.p2.y);
            d2 = Math.min(d2, this.p2.x);
            d3 = Math.max(d3, this.p2.y);
            d4 = Math.max(d4, this.p2.x);
        }
        if (this.p3 != null) {
            d = Math.min(d, this.p3.y);
            d2 = Math.min(d2, this.p3.x);
            d3 = Math.max(d3, this.p3.y);
            d4 = Math.max(d4, this.p3.x);
        }
        if (this.p4 != null) {
            d = Math.min(d, this.p4.y);
            d2 = Math.min(d2, this.p4.x);
            d3 = Math.max(d3, this.p4.y);
            d4 = Math.max(d4, this.p4.x);
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return new DRectangle();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        switch (this.ba) {
            default: {
                new Bedingung(this.ba, this.p1, this.p2, this.p3, this.mass).drawObject(iGraphics, bl, bl2);
                break;
            }
            case 3: {
                Bedingung bedingung = new Bedingung(this.ba, this.p1, this.p2, null, 0.0);
                if (this.p3 == null && this.p4 == null) {
                    bedingung.drawObject(iGraphics, bl, bl2);
                    break;
                }
                Bedingung bedingung2 = new Bedingung(0, this.p3, this.p4, null, this.mass);
                bedingung2.setReferenz(bedingung);
                bedingung2.drawObject(iGraphics, bl, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
        Graphics graphics = iGraphics.getGraphics();
        if (bl2) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setPaintMode();
            graphics.setColor(KafPlotProperties.mmaColor.getColor(new Integer(60 + this.ba)));
        }
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InputBedingung: ");
        if (this.p1 != null) {
            stringBuffer.append(this.p1.nr);
        }
        stringBuffer.append(" - ");
        if (this.p2 != null) {
            stringBuffer.append(this.p2.nr);
        }
        stringBuffer.append(" - ");
        if (this.p3 != null) {
            stringBuffer.append(this.p3.nr);
        }
        stringBuffer.append(" - ");
        if (this.p4 != null) {
            stringBuffer.append(this.p4.nr);
        }
        stringBuffer.append("   ");
        if (this.mass != 0.0) {
            stringBuffer.append(IFormat.f_3.format(this.mass));
        }
        return stringBuffer.toString();
    }
}

