/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import java.awt.Cursor;
import java.util.Enumeration;

public class InputLinieClip
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private Linie l;
    private Punkt p;

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return 2;
    }

    @Override
    public int need() {
        if (this.step == 0) {
            return 256;
        }
        return 64;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (this.step == 0 && object instanceof Linie) {
            this.l = (Linie)((Linie)object).clone();
        } else if (this.step == 1 && object instanceof Punkt && object != this.l.getPa() && object != this.l.getPe()) {
            this.p = (Punkt)object;
        }
        this.lastIn = object;
        if (bl) {
            ++this.step;
        }
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            GObject gObject = (GObject)enumeration.nextElement();
            for (int i = 0; i < gObject.size(); ++i) {
                Linie linie = (Linie)gObject.elementAt(i);
                if ((linie.getPa() != this.l.getPa() || linie.getPe() != this.l.getPe()) && (linie.getPa() != this.l.getPe() || linie.getPe() != this.l.getPa())) continue;
                Linie linie2 = (Linie)linie.clone();
                linie2.setPa(this.p);
                linie2.setLs(linie.isLinie() ? 2 : 0);
                linie.setPe(this.p);
                gObject.insertElementAt(linie2, i + 1);
                gObject.initGeom();
            }
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isFull()) {
            if (this.step == 0) {
                stringBuffer.append("Linie: ");
                if (this.l != null) {
                    stringBuffer.append(this.l.getPa().nr + " - " + this.l.getPe().nr);
                }
            } else if (this.step == 1) {
                stringBuffer.append("Punkt: ");
                if (this.p != null) {
                    stringBuffer.append(this.p.nr);
                }
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Linienteilung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.l != null) {
            stringBuffer.append(this.l.getPa().nr);
        }
        if (this.p != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.p.nr);
        }
        if (this.l != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.l.getPe().nr);
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        if (this.l != null && this.l.getPa() != null) {
            d = Math.min(d, this.l.getPa().y);
            d2 = Math.min(d2, this.l.getPa().x);
            d3 = Math.max(d3, this.l.getPa().y);
            d4 = Math.max(d4, this.l.getPa().x);
        }
        if (this.l != null && this.l.getPe() != null) {
            d = Math.min(d, this.l.getPe().y);
            d2 = Math.min(d2, this.l.getPe().x);
            d3 = Math.max(d3, this.l.getPe().y);
            d4 = Math.max(d4, this.l.getPe().x);
        }
        if (this.p != null) {
            d = Math.min(d, this.p.y);
            d2 = Math.min(d2, this.p.x);
            d3 = Math.max(d3, this.p.y);
            d4 = Math.max(d4, this.p.x);
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return new DRectangle();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.l != null) {
            this.l.drawObject(iGraphics, bl, bl2);
        }
        if (this.p != null) {
            this.p.drawObject(iGraphics, bl, bl2);
            new Linie(2, this.l.getLa(), this.l.getEb(), this.l.getPa(), this.p).drawObject(iGraphics, bl, bl2);
            new Linie(2, this.l.getLa(), this.l.getEb(), this.l.getPe(), this.p).drawObject(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        return this.getExceptionableName();
    }
}

