/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import java.awt.Cursor;
import java.util.Enumeration;

public class InputLinieConnect
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private Linie l1;
    private Linie l2;

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return 2;
    }

    @Override
    public int need() {
        return 256;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
    }

    @Override
    public void setObject(Object object, boolean bl) {
        if (object instanceof Linie) {
            Linie linie = (Linie)object;
            if (this.step == 0) {
                this.l1 = (Linie)linie.clone();
            } else if (this.step == 1 && linie != this.l1 && (linie.getPa() == this.l1.getPa() || linie.getPa() == this.l1.getPe() || linie.getPe() == this.l1.getPa() || linie.getPe() == this.l1.getPe())) {
                this.l2 = (Linie)linie.clone();
            }
            this.lastIn = object;
            if (bl) {
                ++this.step;
            }
        }
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(Enumeration enumeration) {
        Punkt punkt = this.getStartPoint();
        Punkt punkt2 = this.getMiddlePoint();
        Punkt punkt3 = this.getEndPoint();
        while (enumeration.hasMoreElements()) {
            GObject gObject = (GObject)enumeration.nextElement();
            Linie linie = null;
            Linie linie2 = null;
            for (int i = 0; i < gObject.size(); ++i) {
                Linie linie3 = (Linie)gObject.elementAt(i);
                switch (linie3.getLs()) {
                    case 1: {
                        linie = linie3;
                        break;
                    }
                    case 0: {
                        if (!linie3.getPa().equals(punkt2) || !linie2.equalsParameter(linie3) || (!linie2.getPa().equals(punkt) || !linie3.getPe().equals(punkt3)) && (!linie2.getPa().equals(punkt3) || !linie3.getPe().equals(punkt))) break;
                        linie2.setPe(linie3.getPe());
                        gObject.removeElementAt(i);
                        gObject.initGeom();
                        break;
                    }
                    case 9: {
                        if (!linie3.getPa().equals(punkt2) || !linie2.equalsParameter(linie) || linie2.getLs() == 1 || (!linie2.getPa().equals(punkt) || !linie.getPe().equals(punkt3)) && (!linie2.getPa().equals(punkt3) || !linie.getPe().equals(punkt))) break;
                        linie2.setLs(9);
                        linie2.setPe(null);
                        linie.setPa(linie2.getPa());
                        gObject.removeElementAt(i);
                        gObject.initGeom();
                        break;
                    }
                }
                linie2 = linie3;
            }
        }
    }

    private void printObj(GObject gObject) {
        System.out.println(gObject);
        for (int i = 0; i < gObject.size(); ++i) {
            System.out.println(gObject.elementAt(i));
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isFull()) {
            stringBuffer.append("Linie: ");
            if (this.step == 0) {
                if (this.l1 != null) {
                    stringBuffer.append(this.l1.getPa().nr + " - " + this.l1.getPe().nr);
                }
            } else if (this.step == 1 && this.l2 != null) {
                stringBuffer.append(this.l2.getPa().nr + " - " + this.l2.getPe().nr);
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    private Punkt getMiddlePoint() {
        if (this.l1 == null || this.l2 == null) {
            return null;
        }
        if (this.l1.getPa() == this.l2.getPa()) {
            return this.l1.getPa();
        }
        if (this.l1.getPa() == this.l2.getPe()) {
            return this.l1.getPa();
        }
        if (this.l1.getPe() == this.l2.getPa()) {
            return this.l1.getPe();
        }
        if (this.l1.getPe() == this.l2.getPe()) {
            return this.l1.getPe();
        }
        return null;
    }

    private Punkt getStartPoint() {
        if (this.l1 == null) {
            return null;
        }
        if (this.l2 == null) {
            return this.l1.getPa();
        }
        return this.l1.getPe() == this.getMiddlePoint() ? this.l1.getPa() : this.l1.getPe();
    }

    private Punkt getEndPoint() {
        if (this.l1 == null) {
            return null;
        }
        if (this.l2 == null) {
            return this.l1.getPe();
        }
        return this.l2.getPe() == this.getMiddlePoint() ? this.l2.getPa() : this.l2.getPe();
    }

    @Override
    public String getClassName() {
        return "Linienverbindung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        Punkt punkt = null;
        punkt = this.getStartPoint();
        if (punkt != null) {
            stringBuffer.append(punkt.nr);
        }
        if ((punkt = this.getMiddlePoint()) != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(punkt.nr);
        }
        if ((punkt = this.getEndPoint()) != null) {
            stringBuffer.append(" - ");
            stringBuffer.append(punkt.nr);
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        if (this.l1 == null) {
            return new DRectangle();
        }
        if (this.l2 == null) {
            return this.l1.getBounds();
        }
        DRectangle dRectangle = this.l1.getBounds();
        dRectangle.add(this.l2.getBounds());
        return dRectangle;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.l1 != null) {
            this.l1.drawObject(iGraphics, bl, bl2);
        }
        if (this.l2 != null) {
            this.l2.drawObject(iGraphics, bl, bl2);
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        return this.getExceptionableName();
    }
}

