/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.DataContainer;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.InputProperties;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Messung;
import de.geocalc.kafplot.OrthoLinie;
import de.geocalc.kafplot.PolarAufnahme;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Vector;

public class InputMessung
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private int ma;
    private Punkt p1;
    private Punkt p2;
    private double l11;
    private double l12;
    private double l21;
    private double l22;
    private boolean isFluchtLinie = false;
    private Vector basis;

    public InputMessung(int n) {
        this.ma = n;
        switch (n) {
            case 230: 
            case 270: {
                this.basis = new PolarAufnahme();
                break;
            }
            case 210: {
                this.basis = new OrthoLinie();
                break;
            }
            case 260: {
                this.basis = new Vector();
            }
        }
    }

    public void setArt(int n) {
        this.ma = n;
    }

    public int getArt() {
        return this.ma;
    }

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        switch (this.ma) {
            case 210: 
            case 230: 
            case 270: {
                return Integer.MAX_VALUE;
            }
            case 220: {
                return 3;
            }
            case 260: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public int need() {
        switch (this.ma) {
            case 230: 
            case 270: {
                if (this.step == 0 || (this.step - 1) % 3 == 0) {
                    return InputProperties.getInputFangSwitch() == 901 ? 128 : 64;
                }
                return 4;
            }
            case 210: {
                if (this.step % 3 == 0) {
                    return InputProperties.getInputFangSwitch() == 901 ? 128 : 64;
                }
                return 4;
            }
            case 220: {
                if (this.step < 2) {
                    return InputProperties.getInputFangSwitch() == 901 ? 128 : 64;
                }
                return 4;
            }
            case 260: {
                if (this.step < 3) {
                    return InputProperties.getInputFangSwitch() == 901 ? 128 : 64;
                }
                return 4;
            }
        }
        return 64;
    }

    @Override
    public boolean isReady() {
        switch (this.ma) {
            case 230: 
            case 270: {
                if (this.step < 4) {
                    return false;
                }
                return (this.step - 1) % 3 == 0;
            }
            case 210: {
                if (this.step < 6) {
                    return false;
                }
                return this.step % 3 == 0;
            }
        }
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        switch (this.ma) {
            case 230: 
            case 270: {
                return this.step <= 1 || this.step - 1 == 0;
            }
            case 210: {
                return this.step % 3 == 0;
            }
            case 220: {
                return this.step <= 1;
            }
            case 260: {
                return this.step <= 2;
            }
        }
        return true;
    }

    @Override
    public Object getDefault() {
        switch (this.ma) {
            case 270: {
                if (this.p1 != null && this.p2 != null) {
                    if (this.step == 1) {
                        return new Long(InputProperties.getNextFreeNumber());
                    }
                    if (this.step == 2) {
                        return new Float(this.p2.y - this.p1.y);
                    }
                    if (this.step == 3) {
                        return new Float(this.p2.x - this.p1.x);
                    }
                    if ((this.step - 1) % 3 == 0) {
                        return new Long(InputProperties.getNextFreeNumber());
                    }
                    if ((this.step - 1) % 3 == 1) {
                        Punkt punkt = (Punkt)this.basis.elementAt(this.step - 5);
                        return new Float(punkt.y - this.p1.y);
                    }
                    if ((this.step - 1) % 3 == 2) {
                        Punkt punkt = (Punkt)this.basis.elementAt(this.step - 6);
                        return new Float(punkt.x - this.p1.x);
                    }
                }
            }
            case 230: {
                if (this.p1 != null && this.p2 != null) {
                    if (this.step == 0 || this.step == 1) {
                        return new Long(0L);
                    }
                    if (this.step == 2) {
                        return new Float(0.0f);
                    }
                    if (this.step == 3) {
                        return new Float(DPoint.ptDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x) * DataBase.getStreckeMasstab(this.p1.y));
                    }
                    if ((this.step - 1) % 3 == 1) {
                        Punkt punkt = (Punkt)this.basis.elementAt(this.step - 5);
                        return new Float(((PolarAufnahme)this.basis).getMessungOf((Punkt)punkt).l1);
                    }
                    if ((this.step - 1) % 3 == 2) {
                        Punkt punkt = (Punkt)this.basis.elementAt(this.step - 6);
                        return new Float(((PolarAufnahme)this.basis).getMessungOf((Punkt)punkt).l2);
                    }
                }
            }
            case 210: {
                if (this.step == 0) {
                    return new Long(0L);
                }
                if (this.step == 1) {
                    return new Float(0.0f);
                }
                if (this.step == 2) {
                    return new Float(0.0f);
                }
                if (this.step == 3) {
                    return new Long(0L);
                }
                if (this.step == 4) {
                    return new Float(0.0f);
                }
                if (this.step == 5) {
                    return new Float(((OrthoLinie)this.basis).getEndMass());
                }
                if (this.step % 3 == 0) {
                    return new Long(InputProperties.getNextFreeNumber());
                }
                if (this.step % 3 == 1) {
                    Punkt punkt = (Punkt)this.basis.elementAt(this.step - 7);
                    return punkt.y == 0.0 ? new Float(0.0f) : new Float(((OrthoLinie)this.basis).getMessungOf((Punkt)punkt).l1);
                }
                if (this.step % 3 == 2) {
                    Punkt punkt = (Punkt)this.basis.elementAt(this.step - 8);
                    return punkt.y == 0.0 ? new Float(0.0f) : new Float(((OrthoLinie)this.basis).getMessungOf((Punkt)punkt).l2);
                }
            }
            case 220: {
                if (this.step < 2) {
                    return new Long(0L);
                }
                return new Float(DPoint.ptDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x) * DataBase.getStreckeMasstab(this.p1.y));
            }
            case 260: {
                if (this.step < 2) {
                    return new Long(0L);
                }
                if (this.step == 2) {
                    return new Long(InputProperties.getNextFreeNumber());
                }
                if (this.step == 3) {
                    return new Float(DPoint.ptDist(this.p1, (Punkt)this.basis.firstElement()) * DataBase.getStreckeMasstab(this.p1.y));
                }
                if (this.step != 4) break;
                return new Float(DPoint.ptDist(this.p2, (Punkt)this.basis.firstElement()) * DataBase.getStreckeMasstab(this.p2.y));
            }
        }
        return null;
    }

    public void setObject(Object object, int n) {
        switch (this.ma) {
            default: 
        }
    }

    private Punkt getPunkt(Object object) {
        if (object instanceof Punkt) {
            return (Punkt)object;
        }
        if (object instanceof Number) {
            Punkt punkt = InputProperties.getOldPunkt(((Number)object).longValue());
            if (punkt != null) {
                return punkt;
            }
            return InputProperties.getNewPunkt(((Number)object).longValue());
        }
        return null;
    }

    private Punkt getOldPunkt(Object object) {
        if (object instanceof Punkt) {
            return (Punkt)object;
        }
        if (object instanceof Number) {
            return InputProperties.getOldPunkt(((Number)object).longValue());
        }
        return null;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        block56: {
            block0 : switch (this.ma) {
                case 270: {
                    switch (this.step) {
                        case 0: {
                            this.p1 = this.getOldPunkt(object);
                            if (this.p1 != null) break block0;
                            bl = false;
                            break block0;
                        }
                        case 1: {
                            this.p2 = this.getOldPunkt(object);
                            if (this.p2 != null) break block0;
                            bl = false;
                            break block0;
                        }
                        case 2: {
                            this.l11 = ((Float)object).doubleValue();
                            break block0;
                        }
                        case 3: {
                            this.l12 = ((Float)object).doubleValue();
                            break block0;
                        }
                    }
                    if ((this.step - 1) % 3 == 0) {
                        if (this.basis.size() % 3 == 1) {
                            this.basis.setElementAt(this.getPunkt(object), this.basis.size() - 1);
                            break;
                        }
                        this.basis.addElement(this.getPunkt(object));
                        break;
                    }
                    this.basis.addElement(object);
                    break;
                }
                case 230: {
                    switch (this.step) {
                        case 0: {
                            this.p1 = this.getOldPunkt(object);
                            if (this.p1 != null) break block0;
                            bl = false;
                            break block0;
                        }
                        case 1: {
                            this.p2 = this.getOldPunkt(object);
                            if (this.p2 != null) break block0;
                            bl = false;
                            break block0;
                        }
                        case 2: {
                            this.l11 = ((Float)object).doubleValue();
                            break block0;
                        }
                        case 3: {
                            this.l12 = ((Float)object).doubleValue();
                            PolarAufnahme polarAufnahme = new PolarAufnahme(DataBase.getStreckeMasstab(this.p1.y));
                            polarAufnahme.setStandPunkt(this.p1);
                            polarAufnahme.setAnschlussPunkt(this.p2);
                            this.basis = polarAufnahme;
                            break block0;
                        }
                    }
                    if ((this.step - 1) % 3 == 0) {
                        if (this.basis.size() % 3 == 1) {
                            this.basis.setElementAt(this.getPunkt(object), this.basis.size() - 1);
                            break;
                        }
                        this.basis.addElement(this.getPunkt(object));
                        break;
                    }
                    this.basis.addElement(object);
                    break;
                }
                case 210: {
                    switch (this.step) {
                        case 0: {
                            this.p1 = this.getOldPunkt(object);
                            if (this.p1 == null) {
                                bl = false;
                            }
                            ((OrthoLinie)this.basis).setAnfangsPunkt(this.p1);
                            break block0;
                        }
                        case 1: {
                            if (object == null) {
                                this.isFluchtLinie = true;
                                this.l11 = Double.NaN;
                                this.l12 = Double.NaN;
                                if (!bl) break block0;
                                ++this.step;
                                break block0;
                            }
                            this.l11 = ((Float)object).doubleValue();
                            ((OrthoLinie)this.basis).setAnfangsMass(this.l11);
                            break block0;
                        }
                        case 2: {
                            if (object != null) {
                                this.l12 = ((Float)object).doubleValue();
                                ((OrthoLinie)this.basis).setAnfangsOrdinate(this.l12);
                                break block0;
                            }
                            this.l12 = Double.NaN;
                            break block0;
                        }
                        case 3: {
                            this.p2 = this.getOldPunkt(object);
                            if (this.p2 == null) {
                                bl = false;
                            }
                            ((OrthoLinie)this.basis).setEndPunkt(this.p2);
                            if (!this.isFluchtLinie) break block0;
                            this.l21 = Double.NaN;
                            this.l22 = Double.NaN;
                            if (!bl) break block0;
                            this.step += 2;
                            break block0;
                        }
                        case 4: {
                            if (object != null) {
                                this.l22 = ((Float)object).doubleValue();
                                ((OrthoLinie)this.basis).setEndOrdinate(this.l22);
                                this.l21 = ((OrthoLinie)this.basis).getEndMass();
                                break block0;
                            }
                            this.l22 = Double.NaN;
                            break block0;
                        }
                        case 5: {
                            if (object != null) {
                                this.l21 = ((Float)object).doubleValue();
                                ((OrthoLinie)this.basis).setEndMass(this.l21);
                                break block0;
                            }
                            this.l21 = Double.NaN;
                            break block0;
                        }
                    }
                    if (this.step % 3 == 0) {
                        if (this.basis.size() % 3 == 1) {
                            this.basis.setElementAt(this.getPunkt(object), this.basis.size() - 1);
                        } else {
                            this.basis.addElement(this.getPunkt(object));
                        }
                        if (!this.isFluchtLinie || !bl) break;
                        this.basis.addElement(new Float(Float.NaN));
                        this.basis.addElement(new Float(Float.NaN));
                        this.step += 2;
                        break;
                    }
                    if (object == null) {
                        this.basis.addElement(new Float(Float.NaN));
                        if (this.step % 3 != 1) break;
                        this.basis.addElement(new Float(Float.NaN));
                        if (!bl) break;
                        ++this.step;
                        break;
                    }
                    this.basis.addElement(object);
                    if (this.step % 3 != 2) break;
                    Punkt punkt = (Punkt)this.basis.elementAt(this.basis.size() - 3);
                    if (punkt.y != 0.0 || punkt.x != 0.0) break;
                    Punkt punkt2 = ((OrthoLinie)this.basis).getPunktOf(((Float)this.basis.elementAt(this.basis.size() - 2)).doubleValue(), ((Float)object).doubleValue());
                    punkt.y = punkt2.y;
                    punkt.x = punkt2.x;
                    break;
                }
                case 220: {
                    switch (this.step) {
                        case 0: {
                            this.p1 = this.getOldPunkt(object);
                            if (this.p1 != null) break;
                            bl = false;
                            break;
                        }
                        case 1: {
                            this.p2 = this.getOldPunkt(object);
                            if (this.p2 != null) break;
                            bl = false;
                            break;
                        }
                        case 2: {
                            this.l11 = ((Float)object).doubleValue();
                        }
                    }
                    break;
                }
                case 260: {
                    switch (this.step) {
                        case 0: {
                            this.p1 = this.getOldPunkt(object);
                            if (this.p1 == null) {
                                bl = false;
                                break block0;
                            }
                            break block56;
                        }
                        case 1: {
                            this.p2 = this.getOldPunkt(object);
                            if (this.p2 == null) {
                                bl = false;
                                break block0;
                            }
                            break block56;
                        }
                        case 2: {
                            this.basis.removeAllElements();
                            this.basis.addElement(this.getPunkt(object));
                            break block0;
                        }
                        case 3: {
                            this.l11 = ((Float)object).doubleValue();
                            break block0;
                        }
                        case 4: {
                            this.l21 = ((Float)object).doubleValue();
                        }
                    }
                }
            }
        }
        this.lastIn = object;
        if (bl) {
            ++this.step;
        }
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(DataContainer dataContainer) {
        switch (this.ma) {
            case 270: {
                Messung messung = new Messung(270, this.p1, this.p2, this.l11, this.l12);
                messung.setWerteBelegung(3);
                dataContainer.addElement(messung);
                for (int i = 2; i < this.basis.size(); i += 3) {
                    Messung messung2 = new Messung(270, null, (Punkt)this.basis.elementAt(i - 2), ((Float)this.basis.elementAt(i - 1)).doubleValue(), ((Float)this.basis.elementAt(i)).doubleValue());
                    messung2.setReferenz(messung);
                    messung2.setWerteBelegung(3);
                    dataContainer.addElement(messung2);
                }
                break;
            }
            case 230: {
                Messung messung = new Messung(230, this.p1, this.p2, this.l11, this.l12);
                messung.setWerteBelegung(3);
                dataContainer.addElement(messung);
                for (int i = 2; i < this.basis.size(); i += 3) {
                    Messung messung3 = new Messung(230, null, (Punkt)this.basis.elementAt(i - 2), ((Float)this.basis.elementAt(i - 1)).doubleValue(), ((Float)this.basis.elementAt(i)).doubleValue());
                    messung3.setReferenz(messung);
                    messung3.setWerteBelegung(3);
                    dataContainer.addElement(messung3);
                }
                break;
            }
            case 210: {
                Vector<Messung> vector = new Vector<Messung>();
                Messung messung = new Messung(210, this.p1, null, Double.isNaN(this.l11) ? 0.0 : this.l11, Double.isNaN(this.l12) ? 0.0 : this.l12);
                Messung messung4 = new Messung(290, this.p2, null, Double.isNaN(this.l21) ? 0.0 : this.l21, Double.isNaN(this.l22) ? 0.0 : this.l22);
                if (messung.l2 != 0.0) {
                    messung.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung.ps);
                }
                if (messung4.l2 != 0.0) {
                    messung4.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung4.ps);
                }
                messung.setReferenz(messung4);
                messung4.setReferenz(messung);
                messung.setWerteBelegung((!Double.isNaN(this.l11) ? 1 : 0) + (!Double.isNaN(this.l12) ? 2 : 0));
                messung4.setWerteBelegung((!Double.isNaN(this.l21) ? 1 : 0) + (!Double.isNaN(this.l22) ? 2 : 0));
                vector.addElement(messung);
                for (int i = 2; i < this.basis.size(); i += 3) {
                    double d = ((Float)this.basis.elementAt(i - 1)).doubleValue();
                    double d2 = ((Float)this.basis.elementAt(i)).doubleValue();
                    Messung messung5 = new Messung(200, (Punkt)this.basis.elementAt(i - 2), null, Double.isNaN(d) ? 0.0 : d, Double.isNaN(d2) ? 0.0 : d2);
                    if (messung5.l2 != 0.0) {
                        messung5.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung5.ps);
                    }
                    messung5.setReferenz(messung);
                    messung5.setWerteBelegung((!Double.isNaN(d) ? 1 : 0) + (!Double.isNaN(d2) ? 2 : 0));
                    vector.addElement(messung5);
                }
                vector.addElement(messung4);
                this.sortOrtho(vector);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    dataContainer.addElement(enumeration.nextElement());
                }
                break;
            }
            case 220: {
                Messung messung = new Messung(220, this.p1, this.p2, this.l11, this.l12);
                messung.setWerteBelegung(1);
                dataContainer.addElement(messung);
                break;
            }
            case 260: {
                Messung messung = new Messung(260, this.p1, (Punkt)this.basis.firstElement(), this.l11, this.l12);
                Messung messung6 = new Messung(260, this.p2, (Punkt)this.basis.firstElement(), this.l21, this.l21);
                messung.setWerteBelegung(1);
                messung6.setWerteBelegung(1);
                messung.setReferenz(messung6);
                messung6.setReferenz(messung);
                if (DLine.getDistance(messung.ps, messung6.ps, messung.pz) > 0.0) {
                    dataContainer.addElement(messung);
                    dataContainer.addElement(messung6);
                    break;
                }
                dataContainer.addElement(messung6);
                dataContainer.addElement(messung);
                break;
            }
        }
    }

    private void sortOrtho(Vector vector) {
        Messung messung;
        boolean bl = true;
        while (bl) {
            bl = false;
            Messung messung2 = null;
            for (int i = 1; i < vector.size() - 1; ++i) {
                messung = (Messung)vector.elementAt(i);
                if (messung2 != null && messung.getWerteBelegung() > 0 && messung2.getWerteBelegung() > 0) {
                    if (messung2.l1 > messung.l1) {
                        vector.setElementAt(messung, i - 1);
                        vector.setElementAt(messung2, i);
                        messung = messung2;
                        bl = true;
                    } else if (messung2.l1 == messung.l1 && Math.abs(messung2.l2) > Math.abs(messung.l2)) {
                        vector.setElementAt(messung, i - 1);
                        vector.setElementAt(messung2, i);
                        messung = messung2;
                        bl = true;
                    }
                }
                messung2 = messung;
            }
        }
        for (int i = 1; i < vector.size(); ++i) {
            Messung messung3 = (Messung)vector.elementAt(i - 1);
            messung = (Messung)vector.elementAt(i);
            if (messung3.getWerteBelegung() == 0 || messung.getWerteBelegung() == 0 || messung3.l1 != messung.l1) continue;
            if (messung3.l2 == 0.0) {
                messung3.pz = messung3.ps;
                messung3.ps = messung.ps;
                messung3.l2 = messung.l2;
                vector.removeElementAt(i);
                --i;
                continue;
            }
            if (messung3.pz == null) continue;
            messung.pz = messung3.pz;
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer;
        block46: {
            block45: {
                stringBuffer = new StringBuffer();
                if (this.isFull()) break block45;
                block0 : switch (this.ma) {
                    case 270: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Referenzpunkt: ");
                                if (this.p1 == null) break block0;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Zielpunkt: ");
                                if (this.p2 == null) break block0;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                        }
                        if (this.step % 3 == 1) {
                            stringBuffer.append("Zielpunkt: ");
                            if (this.basis.size() <= this.step - 4) break;
                            stringBuffer.append(((Punkt)this.basis.elementAt((int)(this.step - 4))).nr);
                            break;
                        }
                        if (this.step % 3 == 2) {
                            stringBuffer.append("dy: " + IFormat.f_3.format(this.getDefault()));
                            break;
                        }
                        if (this.step % 3 != 0) break;
                        stringBuffer.append("dx: " + IFormat.f_3.format(this.getDefault()));
                        break;
                    }
                    case 230: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Standpunkt: ");
                                if (this.p1 == null) break block0;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Anschlu\u00dfpunkt: ");
                                if (this.p2 == null) break block0;
                                stringBuffer.append(this.p2.nr);
                                break block0;
                            }
                        }
                        if (this.step % 3 == 1) {
                            stringBuffer.append("Polarpunkt: ");
                            if (this.basis.size() <= this.step - 4) break;
                            stringBuffer.append(((Punkt)this.basis.elementAt((int)(this.step - 4))).nr);
                            break;
                        }
                        if (this.step % 3 == 2) {
                            stringBuffer.append("Richtung: " + IFormat.f_4.format(this.getDefault()));
                            break;
                        }
                        if (this.step % 3 != 0) break;
                        stringBuffer.append("Strecke: " + IFormat.f_3.format(this.getDefault()));
                        break;
                    }
                    case 210: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Anfangspunkt: ");
                                if (this.p1 == null) break block0;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Anlegema\u00df: ");
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Ordinate: ");
                                break block0;
                            }
                            case 3: {
                                stringBuffer.append("Endpunkt: ");
                                if (this.p2 == null) break block0;
                                stringBuffer.append(this.p2.nr + " a=" + IFormat.f_3.format(((OrthoLinie)this.basis).getEndMass()));
                                break block0;
                            }
                            case 4: {
                                stringBuffer.append("Ordinate: ");
                                break block0;
                            }
                            case 5: {
                                stringBuffer.append("Endma\u00df: " + IFormat.f_2.format(this.getDefault()));
                                break block0;
                            }
                        }
                        if (this.step % 3 == 0) {
                            if (this.basis.size() <= this.step - 6) break;
                            Punkt punkt = (Punkt)this.basis.elementAt(this.step - 6);
                            if (punkt.y != 0.0 && punkt.x != 0.0) {
                                stringBuffer.append(((OrthoLinie)this.basis).getMessungOf(punkt).toMessageString());
                                break;
                            }
                            stringBuffer.append(punkt.getMessage().getShortText());
                            break;
                        }
                        if (this.step % 3 == 1) {
                            stringBuffer.append("Abzisse: " + IFormat.f_2.format(this.getDefault()));
                            break;
                        }
                        if (this.step % 3 != 2) break;
                        stringBuffer.append("Ordinate: " + IFormat.f_2.format(this.getDefault()));
                        break;
                    }
                    case 220: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Anfangspunkt: ");
                                if (this.p1 == null) break;
                                stringBuffer.append(this.p1.nr);
                                break block0;
                            }
                            case 1: {
                                stringBuffer.append("Endpunkt: ");
                                if (this.p2 == null) break;
                                stringBuffer.append(this.p2.nr + " s=" + IFormat.f_3.format(DPoint.ptDist(this.p1.y, this.p1.x, this.p2.y, this.p2.x) * DataBase.getStreckeMasstab(this.p1.y)));
                                break block0;
                            }
                            case 2: {
                                stringBuffer.append("Strecke: " + IFormat.f_2.format(this.getDefault()));
                            }
                        }
                        break;
                    }
                    case 260: {
                        switch (this.step) {
                            case 0: {
                                stringBuffer.append("Punkt 1: ");
                                if (this.p1 != null) {
                                    stringBuffer.append(this.p1.nr);
                                    break block0;
                                }
                                break block46;
                            }
                            case 1: {
                                stringBuffer.append("Punkt 2: ");
                                if (this.p2 != null) {
                                    stringBuffer.append(this.p2.nr);
                                    break block0;
                                }
                                break block46;
                            }
                            case 2: {
                                stringBuffer.append("Schnittpunkt: ");
                                if (this.basis.size() > this.step - 2) {
                                    stringBuffer.append(((Punkt)this.basis.elementAt((int)(this.step - 2))).nr);
                                    break block0;
                                }
                                break block46;
                            }
                            case 3: {
                                stringBuffer.append("Strecke 1: " + IFormat.f_2.format(this.getDefault()));
                                break block0;
                            }
                            case 4: {
                                stringBuffer.append("Strecke 2: " + IFormat.f_2.format(this.getDefault()));
                            }
                        }
                    }
                }
                break block46;
            }
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        switch (this.ma) {
            case 270: {
                return "Basislinie";
            }
            case 230: {
                return "Polarmessung";
            }
            case 210: {
                return "Orthogonale Linie";
            }
            case 220: {
                return "Strecke";
            }
            case 260: {
                return "Bogenschlag";
            }
        }
        return "Messung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.p1 != null) {
            stringBuffer.append(this.p1.nr);
        }
        if (this.p2 != null) {
            stringBuffer.append("-");
            stringBuffer.append(this.p2.nr);
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        if (this.p1 != null) {
            d = Math.min(d, this.p1.y);
            d2 = Math.min(d2, this.p1.x);
            d3 = Math.max(d3, this.p1.y);
            d4 = Math.max(d4, this.p1.x);
        }
        if (this.p2 != null) {
            d = Math.min(d, this.p2.y);
            d2 = Math.min(d2, this.p2.x);
            d3 = Math.max(d3, this.p2.y);
            d4 = Math.max(d4, this.p2.x);
        }
        if (this.basis != null) {
            Enumeration enumeration = this.basis.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof DPoint)) continue;
                DPoint dPoint = (DPoint)e;
                d = Math.min(d, dPoint.y);
                d2 = Math.min(d2, dPoint.x);
                d3 = Math.max(d3, dPoint.y);
                d4 = Math.max(d4, dPoint.x);
            }
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return new DRectangle();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        switch (this.ma) {
            case 270: {
                new Messung(270, this.p1, this.p2).drawObject(iGraphics, bl, bl2);
                for (int i = 0; i < this.basis.size(); i += 3) {
                    new Messung(270, null, (Punkt)this.basis.elementAt(i)).drawObject(iGraphics, bl, bl2);
                }
                break;
            }
            case 230: {
                new Messung(230, this.p1, this.p2, this.l11, this.l12).drawObject(iGraphics, bl, bl2);
                for (int i = 0; i < this.basis.size(); i += 3) {
                    new Messung(230, this.p1, (Punkt)this.basis.elementAt(i), 1.0, 1.0).drawObject(iGraphics, bl, bl2);
                }
                break;
            }
            case 210: {
                if (this.p1 == null) {
                    return;
                }
                if (this.p2 == null) {
                    this.p1.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                    break;
                }
                Messung messung = new Messung(210, this.p1, null, Double.isNaN(this.l11) ? 0.0 : this.l11, Double.isNaN(this.l12) ? 0.0 : this.l12);
                Messung messung2 = new Messung(290, this.p2, null, Double.isNaN(this.l21) ? 0.0 : (this.l21 != 0.0 ? this.l21 : new OrthoLinie(this.p1, this.p2, this.l11, this.l12).getEndMass()), Double.isNaN(this.l22) ? 0.0 : this.l22);
                if (messung.l2 != 0.0) {
                    messung.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung.ps);
                }
                if (messung2.l2 != 0.0) {
                    messung2.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung2.ps);
                }
                if (messung.pz != null && Double.isNaN(messung.pz.y)) {
                    OrthoLinie orthoLinie = new OrthoLinie(this.p1, this.p2);
                    messung.pz = orthoLinie.getPunktOf(0.0, -this.l12);
                    messung2.pz = orthoLinie.getPunktOf(this.p1.getDistance(this.p2), -this.l12);
                }
                if (messung2.pz != null && Double.isNaN(messung2.pz.y)) {
                    messung2.pz = messung2.ps;
                }
                messung.setReferenz(messung2);
                messung2.setReferenz(messung);
                messung.setWerteBelegung((!Double.isNaN(this.l11) ? 1 : 0) + (!Double.isNaN(this.l12) ? 2 : 0));
                messung2.setWerteBelegung((!Double.isNaN(this.l21) ? 1 : 0) + (!Double.isNaN(this.l22) ? 2 : 0));
                messung.drawObject(iGraphics, bl, bl2);
                messung2.drawInscription(iGraphics, bl, bl2);
                this.p2.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                for (int i = 0; i < this.basis.size(); i += 3) {
                    Punkt punkt = (Punkt)this.basis.elementAt(i);
                    Messung messung3 = ((OrthoLinie)this.basis).getMessungOf(punkt);
                    double d = i + 1 < this.basis.size() ? ((Float)this.basis.elementAt(i + 1)).doubleValue() : messung3.l1;
                    double d2 = i + 2 < this.basis.size() ? ((Float)this.basis.elementAt(i + 2)).doubleValue() : messung3.l2;
                    Messung messung4 = new Messung(200, punkt, null, Double.isNaN(d) ? 0.0 : d, Double.isNaN(d2) ? 0.0 : d2);
                    if (messung4.l2 != 0.0) {
                        messung4.pz = ((OrthoLinie)this.basis).getLotfusspunktOf(messung4.ps);
                    }
                    messung4.setWerteBelegung((!Double.isNaN(d) ? 1 : 0) + (!Double.isNaN(d2) ? 2 : 0));
                    messung4.drawForeground(iGraphics, bl, bl2);
                    messung4.setReferenz(messung);
                    messung4.drawInscription(iGraphics, bl, bl2);
                    punkt.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                }
                break;
            }
            case 220: {
                if (this.p2 != null) {
                    new Messung(220, this.p1, this.p2, this.l11 != 0.0 ? this.l11 : DPoint.ptDist(this.p1, this.p2) * DataBase.getStreckeMasstab(this.p1.y), 0.0).drawObject(iGraphics, bl, bl2);
                    break;
                }
                if (this.p1 == null) break;
                this.p1.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                break;
            }
            case 260: {
                if (this.basis.size() > 0) {
                    Punkt punkt = (Punkt)this.basis.firstElement();
                    new Messung(260, this.p1, punkt, this.l11 != 0.0 ? this.l11 : DPoint.ptDist(this.p1, punkt) * DataBase.getStreckeMasstab(this.p1.y), 0.0).drawObject(iGraphics, bl, bl2);
                    new Messung(260, this.p2, punkt, this.l21 != 0.0 ? this.l21 : DPoint.ptDist(this.p2, punkt) * DataBase.getStreckeMasstab(this.p2.y), 0.0).drawObject(iGraphics, bl, bl2);
                    punkt.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                    break;
                }
                if (!bl2) break;
                if (this.p1 != null) {
                    this.p1.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
                }
                if (this.p2 == null) break;
                this.p2.drawObject(iGraphics, KafPlotProperties.isPunktArtVisible, bl2);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InputMessung(" + this.ma + "): ");
        if (this.p1 != null) {
            stringBuffer.append(this.p1.nr);
        }
        stringBuffer.append(" - ");
        if (this.p2 != null) {
            stringBuffer.append(this.p2.nr);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.basis.size() + " Elemente");
        return stringBuffer.toString();
    }
}

