/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.geom.DDimension;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataOperator;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.event.InputEvent;
import de.geocalc.kafplot.event.InputListener;
import de.geocalc.lang.Exceptionable;
import de.geocalc.text.IFormat;
import de.geocalc.util.Acceptor;
import java.awt.Cursor;
import java.text.Format;
import java.util.Enumeration;
import java.util.Vector;

public abstract class InputObject
implements DataOperator,
Exceptionable,
Messager,
Drawable,
Acceptor {
    public static final int NONE = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int STRING = 16;
    public static final int KOO = 32;
    public static final int PUNKT = 64;
    public static final int NUMMER = 128;
    public static final int GERADE = 256;
    public static final int BOGEN = 612;
    public static final int LOT = 1024;
    public static final int AREA = 2048;
    public static final int MOUSE = 1;
    public static final int KEYBOARD = 2;
    public static final int DATA_NEW = 1;
    public static final int DATA_UPDATE = 2;
    public static final int DATA_REMOVE = 3;
    private static final Vector<InputListener> inputListeners = new Vector();
    protected Object lastIn = null;
    private int operation = 0;
    protected int step = 0;

    public void addInputListener(InputListener inputListener) {
        if (!inputListeners.contains(inputListener)) {
            inputListeners.addElement(inputListener);
        }
    }

    public void removeInputListener(InputListener inputListener) {
        inputListeners.removeElement(inputListener);
    }

    public void sendInputEvent(Object object) {
        this.fireInputEvent(2001, object);
    }

    private void fireInputEvent(int n, Object object) {
        InputEvent inputEvent = new InputEvent(this, object, n);
        Enumeration<InputListener> enumeration = inputListeners.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().inputUpdated(inputEvent);
        }
    }

    public abstract int dataMode();

    public int needInterface() {
        switch (this.need()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 128: {
                return 2;
            }
        }
        return 1;
    }

    public Format format() {
        switch (this.need()) {
            case 1: 
            case 2: 
            case 128: {
                return IFormat.i;
            }
            case 4: 
            case 8: {
                return IFormat.f_2;
            }
        }
        return null;
    }

    @Override
    public DDimension getSize() {
        DRectangle dRectangle = this.getBounds();
        return new DDimension(dRectangle.width, dRectangle.height);
    }

    public Object lastInput() {
        return this.lastIn;
    }

    @Override
    public void setOperation(int n) {
        this.operation = n;
    }

    @Override
    public int getOperation() {
        return this.operation;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public void addStep() {
        ++this.step;
    }

    public int getStep() {
        return this.step;
    }

    public boolean reverse(int n) {
        return false;
    }

    public abstract int steps();

    public abstract int need();

    @Override
    public boolean accept(Object object) {
        return true;
    }

    public abstract void setObject(Object var1, boolean var2);

    public abstract Object getDefault();

    public abstract Cursor getCurrentCursor();

    public abstract boolean isReady();

    public abstract boolean isAbortable();

    public boolean isVoid() {
        return this.step == 0;
    }

    public boolean isFull() {
        return this.step == this.steps();
    }

    @Override
    public String getClassName() {
        return "EingabeObjekt";
    }

    @Override
    public abstract String getObjectName();

    @Override
    public String getExceptionableName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getObjectName());
        return stringBuffer.toString();
    }

    @Override
    public String toDebugString() {
        return this.getExceptionableName();
    }
}

