/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.kafplot;

import de.geocalc.awt.IGraphics;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DRectangle;
import de.geocalc.kafplot.DataBase;
import de.geocalc.kafplot.Drawable;
import de.geocalc.kafplot.Flurstueck;
import de.geocalc.kafplot.FlurstueckArt;
import de.geocalc.kafplot.GObject;
import de.geocalc.kafplot.GObjectManipulator;
import de.geocalc.kafplot.InputObject;
import de.geocalc.kafplot.KafPlotProperties;
import de.geocalc.kafplot.Linie;
import de.geocalc.kafplot.Message;
import de.geocalc.kafplot.Messager;
import de.geocalc.kafplot.Nutzung;
import de.geocalc.kafplot.Punkt;
import de.geocalc.lang.Exceptionable;
import de.geocalc.util.VoidEnumerator;
import java.awt.Cursor;
import java.util.Enumeration;
import java.util.Vector;

public class InputObjectClip
extends InputObject
implements Exceptionable,
Messager,
Drawable {
    private Vector points = new Vector();
    private Punkt pa;
    private Punkt pe;
    private GObject clipObject = null;
    private Vector relevantObjects = new Vector();
    boolean paIsVertex;
    boolean peIsVertex;

    @Override
    public int dataMode() {
        return 1;
    }

    @Override
    public int steps() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int need() {
        return 64;
    }

    @Override
    public boolean isReady() {
        return this.isFull();
    }

    @Override
    public boolean isAbortable() {
        return true;
    }

    @Override
    public Object getDefault() {
        return null;
    }

    public void setObject(Object object, int n) {
    }

    @Override
    public boolean reverse(int n) {
        if (this.points.size() >= 1) {
            this.pe = (Punkt)this.points.lastElement();
            this.points.removeElementAt(this.points.size() - 1);
            --this.step;
            if (this.step <= 1) {
                this.peIsVertex = false;
                this.clipObject = null;
            }
            if (this.step == 0) {
                this.paIsVertex = false;
                this.pa = this.pe;
            }
            return true;
        }
        return false;
    }

    private Enumeration searchObjects() {
        if (KafPlotProperties.getEditObjectSwitch() == 2201) {
            return DataBase.flurstuecke();
        }
        if (KafPlotProperties.getEditObjectSwitch() == 2204) {
            return DataBase.nutzungen();
        }
        return new VoidEnumerator();
    }

    private Linie createLinie(int n, Punkt punkt, Punkt punkt2) {
        int n2 = 0;
        int n3 = 0;
        if (KafPlotProperties.getEditObjectSwitch() == 2201) {
            n2 = 2;
            n3 = 48;
        } else if (KafPlotProperties.getEditObjectSwitch() == 2204) {
            n2 = 5;
            n3 = 7;
        }
        return new Linie(n, n2, n3, punkt, punkt2);
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof Punkt) {
            Punkt punkt = (Punkt)object;
            if (KafPlotProperties.getEditObjectSwitch() == 2201 && punkt.getKafPa() != 1) {
                return false;
            }
            if (this.step == 0) {
                return true;
            }
            if (this.step == 1) {
                GObject gObject = this.getClipObject(punkt);
                if (gObject == null) {
                    return false;
                }
                if (!gObject.containsVertexPunkt(punkt) && !gObject.contains(punkt.y, punkt.x)) {
                    return false;
                }
                Punkt punkt2 = (Punkt)this.points.lastElement();
                if (gObject.hasLinie(punkt2, punkt)) {
                    return false;
                }
                return gObject.getIntersectPoint(punkt2, punkt) == null;
            }
            if (this.clipObject != null) {
                if (!this.clipObject.containsVertexPunkt(punkt) && !this.clipObject.contains(punkt.y, punkt.x)) {
                    return false;
                }
                if (this.clipObject.hasLinie((Punkt)this.lastIn, punkt)) {
                    return false;
                }
                return this.clipObject.getIntersectPoint((Punkt)this.lastIn, punkt) == null;
            }
        }
        return false;
    }

    private GObject getClipObject(Punkt punkt) {
        GObject gObject = null;
        double d = punkt.y - this.pa.y;
        double d2 = punkt.x - this.pa.x;
        double d3 = Math.sqrt(d * d + d2 * d2);
        DPoint dPoint = new DPoint(this.pa.y + d / d3 * 0.01, this.pa.x + d2 / d3 * 0.01);
        Enumeration enumeration = this.relevantObjects.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject2 = (GObject)enumeration.nextElement();
            if (!gObject2.contains(dPoint.y, dPoint.x)) continue;
            gObject = gObject2;
        }
        return gObject;
    }

    @Override
    public void setObject(Object object, boolean bl) {
        Punkt punkt = (Punkt)object;
        if (this.accept(punkt)) {
            if (this.step == 0) {
                this.pa = punkt;
                if (bl) {
                    this.relevantObjects.removeAllElements();
                    Enumeration enumeration = this.searchObjects();
                    while (enumeration.hasMoreElements()) {
                        GObject gObject = (GObject)enumeration.nextElement();
                        if (!gObject.boundsContains(this.pa.y, this.pa.x) || !gObject.containsVertexPunkt(this.pa) && !gObject.contains(this.pa.y, this.pa.x)) continue;
                        this.relevantObjects.addElement(gObject);
                    }
                }
            } else if (this.step == 1) {
                this.clipObject = this.getClipObject(punkt);
                if (this.clipObject != null) {
                    this.paIsVertex = this.clipObject.containsVertexPunkt(this.pa);
                }
            }
            this.pe = punkt;
            if (bl) {
                this.points.addElement(this.pe);
                if (this.clipObject != null) {
                    this.peIsVertex = this.clipObject.containsVertexPunkt(this.pe);
                }
                ++this.step;
                if (this.paIsVertex && this.peIsVertex || this.pa == this.pe && this.points.size() > 2) {
                    this.step = Integer.MAX_VALUE;
                }
            }
            this.lastIn = punkt;
        }
    }

    @Override
    public Cursor getCurrentCursor() {
        return Cursor.getDefaultCursor();
    }

    public void save(Enumeration enumeration) {
        block22: {
            if (this.clipObject == null) {
                return;
            }
            GObject gObject = null;
            GObject gObject2 = null;
            try {
                int n;
                Cloneable cloneable;
                int n2;
                GObject gObject3;
                int n3;
                gObject = (GObject)this.clipObject.clone();
                gObject2 = (GObject)this.clipObject.clone();
                gObject.removeAllElements();
                gObject.x = 0.0;
                gObject.x = 0.0;
                gObject.yt = 0.0;
                gObject.yt = 0.0;
                gObject2.removeAllElements();
                gObject2.x = 0.0;
                gObject2.x = 0.0;
                gObject2.yt = 0.0;
                gObject2.yt = 0.0;
                if (this.paIsVertex && this.peIsVertex) {
                    n3 = 0;
                    boolean bl = false;
                    gObject3 = gObject;
                    for (n2 = 0; n2 < this.clipObject.size() && (cloneable = (Linie)((Linie)this.clipObject.elementAt(n2)).clone()).getLs() != 9; ++n2) {
                        cloneable.setLs(0);
                        if (cloneable.pa == this.pa) {
                            for (n = 1; n < this.points.size(); ++n) {
                                gObject3.addElement(this.createLinie(0, (Punkt)this.points.elementAt(n - 1), (Punkt)this.points.elementAt(n)));
                            }
                            gObject3 = gObject3 == gObject ? gObject2 : gObject;
                            gObject3.addElement(cloneable);
                            continue;
                        }
                        if (cloneable.pa == this.pe) {
                            for (n = this.points.size() - 2; n >= 0; --n) {
                                gObject3.addElement(this.createLinie(0, (Punkt)this.points.elementAt(n + 1), (Punkt)this.points.elementAt(n)));
                            }
                            gObject3 = gObject3 == gObject ? gObject2 : gObject;
                            gObject3.addElement(cloneable);
                            continue;
                        }
                        gObject3.addElement(cloneable);
                    }
                    ((Linie)gObject.firstElement()).setLs(1);
                    gObject.addElement(new Linie(9, 2, 48, ((Linie)gObject.firstElement()).pa, null));
                    gObject.initGeom();
                    ((Linie)gObject2.firstElement()).setLs(1);
                    gObject2.addElement(new Linie(9, 2, 48, ((Linie)gObject2.firstElement()).pa, null));
                    gObject2.initGeom();
                } else if (this.pa == this.pe && this.points.size() > 2) {
                    gObject = (GObject)this.clipObject.clone();
                    gObject.x = 0.0;
                    gObject.x = 0.0;
                    gObject.yt = 0.0;
                    gObject.yt = 0.0;
                    for (n3 = 1; n3 < this.points.size(); ++n3) {
                        gObject.addElement(this.createLinie(2, (Punkt)this.points.elementAt(n3 - 1), (Punkt)this.points.elementAt(n3)));
                        gObject2.addElement(this.createLinie(0, (Punkt)this.points.elementAt(n3 - 1), (Punkt)this.points.elementAt(n3)));
                    }
                    try {
                        new GObjectManipulator(gObject).repair();
                    }
                    catch (Exception exception) {
                        return;
                    }
                    ((Linie)gObject2.firstElement()).setLs(1);
                    gObject2.addElement(new Linie(9, 2, 48, ((Linie)gObject2.firstElement()).pa, null));
                    gObject.initGeom();
                    gObject2.initGeom();
                } else {
                    return;
                }
                if (this.clipObject instanceof Flurstueck) {
                    Flurstueck flurstueck = (Flurstueck)this.clipObject;
                    Flurstueck flurstueck2 = (Flurstueck)gObject;
                    flurstueck2.setAktFlaeche(0.0);
                    flurstueck2.setRoundedFlaeche(0);
                    flurstueck2.setFlaecheRead(false);
                    gObject3 = (Flurstueck)gObject2;
                    ((Flurstueck)gObject3).setAktFlaeche(0.0);
                    ((Flurstueck)gObject3).setRoundedFlaeche(0);
                    gObject3.setFlaecheRead(false);
                    flurstueck2.setArt(801);
                    ((Flurstueck)gObject3).setArt(801);
                    n2 = flurstueck.getArt();
                    if (FlurstueckArt.isTeilstueck(n2)) {
                        cloneable = DataBase.FLST.getStammstueckFrom(flurstueck);
                        ((Flurstueck)gObject3).setTeil(DataBase.FLST.countTeilstuecke((Flurstueck)cloneable) + 1);
                        try {
                            DataBase.FLST.put(gObject3);
                        }
                        catch (Exception exception) {
                            return;
                        }
                        flurstueck.removeAllElements();
                        flurstueck.x = 0.0;
                        flurstueck.x = 0.0;
                        flurstueck.yt = 0.0;
                        flurstueck.yt = 0.0;
                        flurstueck.setAktFlaeche(0.0);
                        for (n = 0; n < flurstueck2.size(); ++n) {
                            flurstueck.addElement(flurstueck2.elementAt(n));
                        }
                        flurstueck.initGeom();
                        break block22;
                    }
                    flurstueck.setArt(781);
                    flurstueck.setLage(null);
                    flurstueck2.setTeil(1);
                    flurstueck2.deleteBuchung();
                    flurstueck2.setBuchFlaeche(0.0);
                    ((Flurstueck)gObject3).setTeil(2);
                    ((Flurstueck)gObject3).deleteBuchung();
                    ((Flurstueck)gObject3).setBuchFlaeche(0.0);
                    DataBase.FLST.put(flurstueck2);
                    DataBase.FLST.put(gObject3);
                    break block22;
                }
                if (this.clipObject instanceof Nutzung) {
                    ((Nutzung)gObject2).setCount(0);
                    DataBase.NUTZ.addElement(gObject2);
                    this.clipObject.removeAllElements();
                    this.clipObject.x = 0.0;
                    this.clipObject.x = 0.0;
                    this.clipObject.xt = 0.0;
                    this.clipObject.xt = 0.0;
                    for (n3 = 0; n3 < gObject.size(); ++n3) {
                        this.clipObject.addElement(gObject.elementAt(n3));
                    }
                    this.clipObject.initGeom();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    @Override
    public Message getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isFull()) {
            if (this.clipObject != null) {
                stringBuffer.append(this.clipObject.getExceptionableName());
                stringBuffer.append(": ");
            }
            stringBuffer.append("Punkt: ");
            if (this.pe != null) {
                stringBuffer.append(this.pe.nr);
            }
        } else {
            stringBuffer.append(this.getExceptionableName());
        }
        return new Message(this, stringBuffer.toString(), stringBuffer.toString());
    }

    @Override
    public String getClassName() {
        return "Objektteilung";
    }

    @Override
    public String getObjectName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pe != null) {
            stringBuffer.append(this.pe.nr);
        }
        return stringBuffer.toString();
    }

    @Override
    public DRectangle getBounds() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            DPoint dPoint = (DPoint)this.points.elementAt(i);
            d = Math.min(d, dPoint.y);
            d2 = Math.min(d2, dPoint.x);
            d3 = Math.max(d3, dPoint.y);
            d4 = Math.max(d4, dPoint.x);
        }
        if (d != Double.MAX_VALUE) {
            return new DRectangle(d, d2, d3 - d, d4 - d2);
        }
        return new DRectangle();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isViewable(IViewport iViewport) {
        return iViewport.intersects(this.getBounds());
    }

    @Override
    public DPoint getHashPoint() {
        return new DPoint();
    }

    @Override
    public void drawObject(IGraphics iGraphics, boolean bl, boolean bl2) {
        if (this.pe != null) {
            Punkt punkt = this.pa;
            for (int i = 1; i < this.points.size(); ++i) {
                Punkt punkt2 = (Punkt)this.points.elementAt(i);
                new Linie(2, 2, 48, punkt, punkt2).drawObject(iGraphics, bl, bl2);
                punkt = punkt2;
            }
            this.pe.drawObject(iGraphics, bl, bl2);
            this.createLinie(2, punkt, this.pe).drawObject(iGraphics, bl, bl2);
            if (this.clipObject != null) {
                this.clipObject.drawInscription(iGraphics, true, true);
            }
        }
    }

    @Override
    public void drawBackground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawForeground(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    @Override
    public void drawInscription(IGraphics iGraphics, boolean bl, boolean bl2) {
    }

    public String toString() {
        return this.getExceptionableName();
    }
}

